	subroutine scpsyn_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   		  mark,interr,erro)
c	*********************************************************
c
	implicit none
c
	character*(*) buf, mymssg
	integer type,val,dec,lim,p1,p2,mark,interr,erro
	real	rval
c
c	Description
c	===========
c
c	This procedure analyses <scope> in BUF and returns result in <scope>
c	arrays (c$scpl, c$scpu), and # of scope expressions (items + subitems)
c	in (c$scpx).
c
c	<scope> = <item>,   {",",<item>},
c		  <subitem>,{",",<subitem>},
c		  <subitem>  ":" <subitem>, {<subitem> ":" <subitem>}
c		  ].
c
c	<item>     = ALL! !NEXT [<n>]
c
c	<subitem>  = TOP! BOTTOM !CURRENT !RECORD <n> !<n>
c
c	        where	TOP		first used record, if any
c			BOTTOM		last  used  record,   "
c			ALL		all   used records,   "
c			CURRENT		current record,       "
c			<n>		record with code = n, "
c			RECORD <n>	sane as <n>
c			NEXT <n>	n records after (including) current one
c			NEXT		sane as NEXT 1
c
c	The result of <scope> analysis is returned as follows:
c
c	c$scpl(i)	lower bound for <scope>
c	c$scpu(i)	upper   "    "     "
c
c	If c$scpl(i) or c$scpu(i) < 0, means that <scope> couldn't be
c	completely evaluated:
c
c		CURRENT		 = -1
c		TOP		 = -2
c		BOTTOM		 = -3
c		NEXT		 = -4	(next record after CURRENT record
c
c	-4 (NEXT) is a particular case: it may only appear in c$scpl(i) and
c	NEXT argument is stored in c$scpu(i)
c
c	1) Empty scope
c		lower=-1	upper=-1
c
c	2) ALL
c		lower=-2	upper=-3
c
c	3) NEXT
c		lower=-4	upper= n
c
c	4) CURRENT
c		lower=-1	upper=-1
c
c	5) a:b
c		lower= a	upper= b
c
c	6) a
c		lower= a	upper= a
c
c	TYPE, VAL, DEC, RVAL, BUF, LIM, P1, P2 and INTERR are usual intok
c	procedure arguments.
c
c	ERRO is returned < 0 if intok found some error (in interr).
c
c	ERRO is returned > 0 if any invalid construction is seen, e.g.
c	RECORD:4, BOTTOM:TOP, 3:2, 0:8, etc.
c
c	If ERRO not = 0, MARK will contain beginning position of rejected
c	BUF portion.
c
c	===== DEC is used internally by s????$ procedures so they can
c	      know if a subitem has been found after ":" or between
c	      ","'s, in order to set correctly scope arrays as defined
c	      above.
c		DEC=1 after ',' or at the begginig; =2 after ":".
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:dbagc.own'
c
	integer mydec
	logical found
c
c	begin
c	=====
c
	call errclr_('SCPSYN')				!error init
	erro=0						!clear error
	mydec=1						!first time...
	c$scpx=0					!no scope expressions
c
	found=.false.					!set FOUND to .false.
	dec=mydec
	call scpit$_(found,type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   	    mark,interr,erro)
	if (interr.ne.0) goto 95001			!flag inwht error
	if (erro.ne.0)   return				!just return if error
	if (type.eq.0)   return				!or eol
c
cwhile	do while (type.eq.8)			!","
1098	continue
	   if (type.ne.8) goto 1099
c
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 95001			!inwht error
	   if (type.ne.1.and.				!int. or id. after ","
     1   	  type.ne.2  ) goto 90001		!<item/subit.> expected
c
	   found=.false.				!set FOUND to .false.
	   mydec=1					!after ','
	   dec=1					!.........
	   call scpit$_(found,type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   		  mark,interr,erro)
	   if (interr.ne.0) goto 95001			!flag inwht error
	   if (erro.ne.0)   return			!return if any error
	   if (.not.found)  goto 90001			!item/subit. expected!
	   if (type.eq.0)   return			!eol
c
	   goto 1098
1099	continue
cwhile	enddo
c
	return
c
c	errors
c	======
c
c	item/subitem expected after ","
90001	continue
	mark=p1				!mark rejected portion
	erro=1
	goto 99000
c
99000	continue
	call errset_('SCPSYN',erro)	!set error
	return				!and return
c
c	inwht error
95001	continue
	erro=-1				!flag inwht error
	mark=p1				!mark rejected portion
	return				!return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine scpit$_(found,type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   		  mark,interr,erro)
c	************************************************************
c
	implicit none
c
	integer type,val,dec,lim,p1,p2,mark,interr,erro
	logical found
	real rval
	character*(*) buf,mymssg
c
c	Description
c	===========
c
c	It implements <item> figure, see above in SCPSYN.
c
c	FOUND is set to .true. if at least one item has been found
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	integer mydec, kind, value
c
c	begin
c	=====
c
	call errclr_('SCPIT$')				!error init
c
	erro=0
	mydec=dec					!...........
c
c	See if <n> first
c	----------------
c
	if (type.eq.2) then
	   call ssbit$_(found,type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   	       mark,interr,erro)
	   if (interr.ne.0) goto 95001			!inwht error
	   if (erro.ne.0)   return			!error, carry
	   if (type.eq.18) then			!":"
	      call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	      if (interr.ne.0) goto 95001		!inwht error
	      if (type.ne.1.and.			!int. or id. after ":"
     1   	  type.ne.2  ) goto 90001		!<subitem> expected
	      found=.false.
	      mydec=2					!after ":"
	      dec=2					!.........
	      call ssbit$_(found,type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   		  mark,interr,erro)
	      if (interr.ne.0) goto 95001		!inwht error
	      if (erro.ne.0)   return			!error, carry
	      if (.not.found)  goto 90001		!subitem expected!
	      if (type.eq.0)   return			!eol
	   endif
c
	   return
c
	endif
c
c	Try keywords if not <n>
c	-----------------------
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
	if     (keypos.le.0) then
	   return					!non-scope item
c
	elseif (keypos.eq.allky) then		!ALL
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 95001			!inwht error
	   if (type.eq.18)  goto 90002			!":" found after item
c
	   kind=3					!ALL found
	   value=-1
	   call sset$_(kind,value,mydec,p1,mark,erro)	!set scope arrays
	   if (erro.ne.0) return			!error, carry
	   found=.true.					!set FOUND to .true.
c
	elseif (keypos.eq.nextky) then		!NEXT
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 95001			!inwht error
	   if (type.eq.18)  goto 90002			!":" found after item
	   if (type.eq.2) then			!NEXT <n>
	      value=val
	      call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	      if (interr.ne.0) goto 95001		!inwht error
	      if (type.eq.18)  goto 90002		!":" found after item
c
	   kind=7					!NEXT <n> found
	   call sset$_(kind,value,mydec,p1,mark,erro)	!set scope arrays
	   if (erro.ne.0) return			!error, carry
	   found=.true.					!set FOUND to .true.
c
	   else					!NEXT
c
	   kind=8					!NEXT found
	   value=1
	   call sset$_(kind,value,mydec,p1,mark,erro)	!set scope arrays
	   if (erro.ne.0) return			!error, carry
	   found=.true.					!set FOUND to .true.
c
	   endif
	else
	   call ssbit$_(found,type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   	       mark,interr,erro)
	   if (interr.ne.0) goto 95001			!inwht error
	   if (erro.ne.0)   return			!error, carry
	   if (type.eq.18) then			!":"
	      call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	      if (interr.ne.0) goto 95001		!inwht error
	      if (type.ne.1.and.			!int. or id. after ":"
     1   	  type.ne.2  ) goto 90001		!<subitem> expected
	      found=.false.				!set FOUND to .false.
	      mydec=2					!after ":"
	      dec=2					!.........
	      call ssbit$_(found,type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   		  mark,interr,erro)
	      if (interr.ne.0) goto 95001		!inwht error
	      if (erro.ne.0)   return			!error, carry
	      if (.not.found)  goto 90001		!subitem expected!
	      if (type.eq.0)   return			!eol
	   endif
	endif
c
	return
c
c	errors
c	======
c
c	subitem expected after ":"
90001	continue
	mark=p1				!mark rejected portion
	erro=1
	goto 99000
c
c	":" found after item
c
90002	continue
	mark=p1				!mark rejected portion
	erro=2
	goto 99000
c
99000	continue
	call errset_('SCPIT$',erro)	!set error
	return				!and return
c
c	inwht error
95001	continue
	mark=p1				!mark rejected portion
	erro=-1				!flag inwht error
	return				!return
c
	end
c
c
c
c
	subroutine ssbit$_(found,type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   		  mark,interr,erro)
c	*************************************************************
c
	implicit none
c
	integer type,val,dec,lim,p1,p2,mark,interr,erro
	logical found
	real rval
	character*(*) buf,mymssg
c
c	Description
c	===========
c
c	It implements <subitem> figure, see above in SCPSYN.
c
c	FOUND is set to .true. if al least one <subitem> is found
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	integer mydec, kind, value
c
c	begin
c	=====
c
	call errclr_('SSBIT$')				!error init
c
	erro=0
	mydec=dec					!...........
c
c	See if <n> first
c	----------------
c
	if (type.eq.2) then			!<n>
	   kind=5					!<n> found
	   value=val
	   call sset$_(kind,value,mydec,p1,mark,erro)	!set scope arrays
	   if (erro.ne.0) return			!error, carry
c
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 95001			!inwht error
	   found=.true.					!set FOUND to .true.
	   return
	endif
c
c	Try keywords if not <n>
c	-----------------------
c
c
	call seetab_(keytok,keytop,keypos,buf(p1:p2),minchr)
	if     (keypos.le.0) then
	   return					!non-scope item
c
	elseif (keypos.eq.topky) then		!TOP
	   kind=1					!TOP found
	   value=-1
	   call sset$_(kind,value,mydec,p1,mark,erro)	!set scope arrays
	   if (erro.ne.0) return			!error, carry
c
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 95001			!inwht error
	   found=.true.					!set FOUND to .true.
	elseif (keypos.eq.bottky) then		!BOTTOM
	   kind=2					!BOTTOM found
	   value=-1
	   call sset$_(kind,value,mydec,p1,mark,erro)	!set scope arrays
	   if (erro.ne.0) return			!error, carry
c
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 95001			!inwht error
	   found=.true.					!set FOUND to .true.
	elseif (keypos.eq.currky) then		!CURRENT
	   kind=4					!CURRENT found
	   value=1
	   call sset$_(kind,value,mydec,p1,mark,erro)	!set scope arrays
	   if (erro.ne.0) return			!error, carry
c
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 95001			!inwht error
	   found=.true.					!set FOUND to .true.
	elseif (keypos.eq.recoky) then		!RECORD
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 95001			!inwht error
	   if (type.eq.2) then			!RECORD <n>
	      kind=6					!RECORD <n> found
	      value=val
	      call sset$_(kind,value,mydec,p1,mark,erro)!set scope arrays
	      if (erro.ne.0) return			!error, carry
c
	      call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	      if (interr.ne.0) goto 95001		!inwht error
	   else
	      goto 90001				!<n> expected
	   endif
	   found=.true.					!set FOUND to .true.
	endif
c
	return
c
c	errors
c	======
c
c	<n>  expected after RECORD in scope list
90001	continue
	mark=p1				!mark rejected portion
	erro=1
	goto 99000
c
99000	continue
	call errset_('SSBIT$',erro)	!set error
	return				!and return
c
c	inwht error
95001	continue
	mark=p1				!mark rejected portion
	erro=-1				!flag inwht error
	return				!return
c
	end
c
c
c
c
	subroutine sset$_(kind,value,mydec,p1,mark,erro)
c	***********************************************
c
	implicit none
c
	integer kind, value, mydec, p1, mark, erro
c
c	Description
c	===========
c
c	It sets scope arrays as defined above.
c
c	mydec=1, item/subitem after ',' or at the begginning; =2, after ":"
c
c	kind:	1	TOP
c		2	BOTTOM
c		3	ALL
c		4	CURRENT
c		5	<n>
c		6	RECORD <n>
c		7	NEXT <n>
c		8	NEXT
c
c	value:	<n>, only appliable if kind = -5, -6 or -7
c
c	erro ne 0 if fatal error
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:dbagc.own'
c
c	begin
c	=====
c
	call errclr_('SSET$')				!error init
c
	erro=0
c
	if     (mydec.eq.1) then
	   c$scpx=c$scpx+1				!next scope expression
	   if (c$scpx.gt.c$scpg) goto 90001			!exhausted
	   goto (11,12,13,14,15,16,17,18) kind		!','
	   goto 90002						!?????
	elseif (mydec.eq.2) then
	   goto (21,22,23,24,25,26,27,28) kind		!":"
	   goto 90002						!?????
	else
	   goto 90006						!?????
	endif
c
c	DEC = 1
c	=======
c
c	TOP
c
11	continue
	c$scpl(c$scpx)=-2			!lower bound
	c$scpu(c$scpx)=-2			!upper bound
	goto 100
c
c	BOTTOM
c
12	continue
	c$scpl(c$scpx)=-3			!lower bound
	c$scpu(c$scpx)=-3			!upper bound
	goto 100
c
c	ALL
c
13	continue
	c$scpl(c$scpx)=-2			!lower bound
	c$scpu(c$scpx)=-3			!upper bound
	goto 100
c
c	CURRENT
c
14	continue
	c$scpl(c$scpx)=-1			!lower bound
	c$scpu(c$scpx)=-1			!upper bound
	goto 100
c
c	<n>
c
15	continue
	if (value.le.0) goto 90003		!scope item < 1
	c$scpl(c$scpx)=value			!lower bound
	c$scpu(c$scpx)=value			!upper bound
	goto 100
c
c	RECORD <n>
c
16	continue
	if (value.lt.0) goto 90003		!scope item < 1
	c$scpl(c$scpx)=value			!lower bound
	c$scpu(c$scpx)=value			!upper bound
	goto 100
c
c	NEXT <n>
c
17	continue
	if (value.le.0) goto 90004		!NEXT <n> < 1
	c$scpl(c$scpx)=-4			!lower bound
	c$scpu(c$scpx)=value			!NEXT arg ("upper bound")
	goto 100
c
c	NEXT
c
18	continue
	c$scpl(c$scpx)=-4			!lower bound
	c$scpu(c$scpx)=-4			!upper bound
	goto 100
c
c	DEC = 2
c	=======
c
c	TOP
c
21	continue
	c$scpu(c$scpx)=-2			!upper bound
	goto 100
c
c	BOTTOM
c
22	continue
	c$scpu(c$scpx)=-3			!upper bound
	goto 100
c
c	ALL
c
23	continue
	goto 90002				!??????
c
c	CURRENT
c
24	continue
	c$scpu(c$scpx)=-1			!upper bound
	goto 100
c
c	<n>
c
25	continue
	if (c$scpl(c$scpx).gt.0.and.
     1      c$scpl(c$scpx).gt.value) then
	   goto 90005				!lower > upper bound
	else
	   if (value.le.0) goto 90003		!scope item < 1
	   c$scpu(c$scpx)=value			!upper bound
	   goto 100
	endif
c
c	RECORD <n>
c
26	continue
	if (c$scpl(c$scpx).gt.0.and.
     1      c$scpl(c$scpx).gt.value) then
	   goto 90005				!lower > upper bound
	else
	   if (value.le.0) goto 90004		!RECORD <n> < 1
	   c$scpu(c$scpx)=value			!upper bound
	   goto 100
	endif
c
c	NEXT <n>
c
27	continue
	goto 90002				!??????
c
c	NEXT
c
28	continue
	goto 90002				!??????
c
c
100	continue
c
	return
c
c	errors
c	======
c
c	max # scope expressions reached
90001	continue
	mark=p1				!mark rejected portion
	erro=1
	goto 99000
c	internal error????? (unknown expression type)
90002	continue
	mark=p1				!mark rejected portion
	erro=2
	goto 99000
c	record# < 1
90003	continue
	mark=p1				!mark rejected portion
	erro=3
	goto 99000
c	NEXT <n> < 1
90004	continue
	mark=p1				!mark rejected portion
	erro=4
	goto 99000
c	<a>:<b> with a>b: lower bound > upper
90005	continue
	mark=p1				!mark rejected portion
	erro=5
	goto 99000
c	internal error????? (unknown expression position)
90006	continue
	mark=p1				!mark rejected portion
	erro=6
	goto 99000
c
99000	continue
	call errset_('SSET$',erro)	!set error
	return				!and return
c
	end
c
c
c
c
	subroutine scpchk_(base,bmap,scpinf,scpsup,alive,topbot,erro)
c	*************************************************************
c
	implicit none
c
	integer base, bmap(*), scpinf, scpsup, alive, erro
	logical topbot
c
c	Description
c	===========
c
c	This  procedure should be fed with proper SCOPE expressions
c	already resolved into the SCOPE arrays by SCPSYN procedure.
c
c	The SCOPE arrays are checked against base BASE. If they are
c	ok, their maximum and minimum values are returned in SCPINF
c	and SCPSUP and bitmap BMAP size checked.
c
c	The result of scope analysis (SCPSYN) is given to SCPCHK  as
c	follows:
c
c	c$scpl(i)	lower bound for <scope>
c	c$scpu(i)	upper   "    "     "
c
c	If c$scpl(i) or c$scpu(i) < 0, means that <scope> couldn't be
c	completely evaluated by SCPSYN:
c
c		CURRENT		 = -1
c		TOP		 = -2
c		BOTTOM		 = -3
c		NEXT		 = -4	(next record after CURRENT record
c
c	-4 (NEXT) is a particular case: it can appear only in c$scpl(i) and
c	NEXT argument is stored in c$scpu(i).
c
c	ON OUTPUT, all scope expressions wil be evaluated as a,b into SCOPE
c	array.
c
c	TOPBOT = .true. if a record# has been "fixed" (forced to TOP or
c	BOTTOM record#).
c
c	ERRO is returned not = 0 if any invalid construction is seen, e.g.
c	RECORD 0, BOTTOM:TOP, 3:2, 0:8,0, etc, or if no current base, or no
c	current record and current record needed, or empty base.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:dbagc.own'
c
	integer k,mytop,mybot,itop,ibot,icurr,inext,iupp,ilow,
     1   	bminf,bmsup
c
c	begin
c	=====
c
	call errclr_('SCPCHK')			!error init
	erro=0					!clear error
c
	topbot=.false.
c
	if (base.le.0) goto 90004		!base = 0
c
	alive=0					!not used anymore
	call zfirst_(base,alive,mytop,erro)	!TOP record
	if (erro.ne.0) return			!error, carry
c
	if (mytop.le.0) then
	   goto 90001				!data base is empty
	endif
c
	alive=0					!not used anymore
	call zlast_(base,alive,mybot,erro)	!BOTTOM record
	if (erro.ne.0) return			!error, carry
c
	call ex3in_(base,mytop,itop,erro)	!top
	if (erro.ne.0) return			!error, carry
	call ex3in_(base,mybot,ibot,erro)	!bottom
	if (erro.ne.0) return			!error, carry
	call ex3in_(base,c$rec,icurr,erro)	!current
	if (erro.ne.0) return			!error, carry
c
	scpinf=itop				!init minimum
	scpsup=ibot				!and maximum
c
	do 1001 k = 1, c$scpx			!loop on scope expressions
c
c	check expression
c
	   if     (c$scpl(k).eq.-1.and.
     1   	   c$scpu(k).eq.-2    ) then	!current:top
	      goto 90003			!upper<lower
	   elseif (c$scpl(k).eq.-3.and.
     1   	   (c$scpu(k).eq.-2.or.
     1   	    c$scpu(k).eq.-1)  ) then
	      goto 90003			!bottom:current or top, up<low.
	   elseif (c$scpl(k).gt.0.and.		!<n>:<m>
     1   	   c$scpu(k).gt.0.and.
     1   	   c$scpl(k).gt.c$scpu(k)) then
	      goto 90003			!up<low
	   endif
c
c	Evaluate scope if needed
c
c	Particular case: a = NEXT or NEXT <n>
c
	      if (c$scpl(k).eq.-4) then			!a=NEXT
c
	         if (icurr.le.0) goto 90005			!no current
	         inext=icurr+1				!next record
	         if (inext.gt.ibot) then
	            inext=ibot
	            topbot=.true.
	         endif
c
	         c$scpu(k)=inext+c$scpu(k)-1		!thru next + <n>
	         c$scpl(k)=inext			!from next record
	      else
c
c	lower bound
c
	         if     (c$scpl(k).gt.0) then		!a=<n>
	            call ex3in_(base,c$scpl(k),ilow,erro)
	            if (erro.ne.0) goto 90007		!wrong check digit
c
	            if     (ilow.lt.itop) then
	               ilow=itop
	               topbot=.true.
	            elseif (ilow.gt.ibot) then
	               ilow=ibot
	               topbot=.true.
	            endif
c
	            c$scpl(k)=ilow			!...
c
	         elseif (c$scpl(k).eq.-1) then		!a=CURRENT
c
	            if (icurr.le.0) goto 90005			!no current
c
	            c$scpl(k)=icurr
c
	         elseif (c$scpl(k).eq.-2) then		!a=TOP
	            c$scpl(k)=itop
c
	         elseif (c$scpl(k).eq.-3) then		!a=BOTTOM
	            c$scpl(k)=ibot
c
	         endif
c
c	upper bound
c
	         if     (c$scpu(k).gt.0) then		!b=<n>
	            call ex3in_(base,c$scpu(k),iupp,erro)
	            if (erro.ne.0) goto 90007		!wrong check digit
c
	            if     (iupp.lt.itop) then
	               iupp=itop
	               topbot=.true.
	            elseif (iupp.gt.ibot) then
	               iupp=ibot
	               topbot=.true.
	            endif
c
	            c$scpu(k)=iupp			!...
c
	         elseif (c$scpu(k).eq.-1) then		!b=CURRENT
c
	            if (icurr.le.0) goto 90005			!no current
c
	            c$scpu(k)=icurr
c
	         elseif (c$scpu(k).eq.-2) then		!b=TOP
	            c$scpu(k)=itop
c
	         elseif (c$scpu(k).eq.-3) then		!b=BOTTOM
	            c$scpu(k)=ibot
c
	         endif
c
	      endif
c
	   if (c$scpu(k).gt.scpsup) scpsup=c$scpu(k)	!retain maximum
	   if (c$scpl(k).lt.scpinf) scpinf=c$scpl(k)	!and minimum
c
1001	continue
c
c	Check BMAP
c
	call bitlim_(bmap,bminf,bmsup,erro)	!ask bmap lower/upper record
	if (erro.ne.0) return			!error, carry
c
	if (scpinf.lt.bminf.or.
     1      scpsup.gt.bmsup) then
	   goto 90006				!scope doesn't fit
	endif
c
	return
c
c	errors
c	======
c
c	data base is empty
90001	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)
	erro=1
	goto 99000			!set error and return
c
c	<n> or RECORD <n> and out of TOP-BOTTOM
90002	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)
	erro=2
	goto 99000			!set error and return
c
c	Found upper bound < lower bound in scope list
90003	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)
	erro=3
	goto 99000			!set error and return
c
c	SCOPE base = 0
90004	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)
	erro=4
	goto 99000			!set error and return
c
c	CURRENT or NEXT and no current record
90005	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)
	erro=5
	goto 99000			!set error and return
c
c	scope doesn't fit in bitmap
90006	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)
	erro=6
	goto 99000			!set error and return
c
c	Invalid record# (wrong check digit)
90007	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)
	erro=7
	goto 99000			!set error and return
c
c	Set error and return
c
99000	continue
	call errset_('SCPCHK',erro)
	return
c
	end
c
c
c
c
	subroutine scpsem_(bmap,erro)
c	****************************
c
	implicit none
c
	integer bmap(*), erro
c
c	Description
c	===========
c
c	This procedure should be fed with proper SCOPE expressions
c	already completely resolved into the SCOPE arrays by call
c	to SCPSYN and SCPCHK procedures.
c
c	SCOPE expressions are simply translated into bit BMAP.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagc.own'
c
	integer k
c
c	begin
c	=====
c
	call errclr_('SCPSEM')			!error init
	erro=0					!clear error
c
	if (c$scpx.le.0) goto 90001		!empty!
c
c	Set BMAP
c
	do 1001 k = 1, c$scpx
	   call bitscp_(bmap,c$scpl(k),c$scpu(k),erro)	!set scope
	   if (erro.ne.0) return			!error, carry
1001	continue
c
	return
c
c	errors
c	======
c
c	no scope expression to "evaluate"
90001	continue
c
	erro=1
	goto 99000
c
99000	continue
c
	call errset_('SCPSEM',erro)
	return
c
	end
c
c
c
c
