	subroutine srlsyn_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   		  mark,interr,erro)
c	*********************************************************
c
	implicit none
c
	character*(*) buf, mymssg
	integer type,val,dec,lim,p1,p2,mark,interr,erro
	real	rval
c
c	Description
c	===========
c
c	This procedure analyses <sort list > in BUF and returns result in
c	<sort list> arrays (c$srln, c$srla, c$show), with total # of items
c	in c$srtn.
c
c	<sort  list>  =	<item>, {",",<item>}
c
c	<item>	      =	<FIELD#! FIELD NAME> , { "A" ! "B" }
c
c			with FIELD# = "%" <n>!#           #: record#
c
c	c$srln(i) :	<n> or 0
c	c$srla(i) :	field name to be checked later, by SRLCHK, or spaces
c	c$show(i) :	1,2,3,4 (Ascend, Descend, Asc. uc, Desc. uc)
c
c	TYPE, VAL, DEC, RVAL, BUF, LIM, P1, P2 and INTERR are usual intok
c	procedure arguments.
c
c	ERRO is returned < 0 if intok found some error (in interr).
c
c	ERRO is returned > 0 if any invalid construction is seen, e.g.
c	%1,) or data,
c
c	If ERRO not = 0, MARK will contain beginning position of rejected
c	BUF portion.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:dbagc.own'
c
c	begin
c	=====
c
	call errclr_('SRLSYN')				!error init
	erro=0						!clear error
c
	c$srtn=0				!clear # of items
c
	call srlit$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   	    mark,interr,erro)
	if (interr.ne.0) goto 95001			!flag inwht error
	if (erro.ne.0)   return				!error, carry
	if (type.eq.0)   goto 900			!or eol
c
cwhile	do while (type.eq.8)			!","
1098	continue
	   if (type.ne.8) goto 1099
c
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 95001			!inwht error
c
	   call srlit$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1                 mark,interr,erro)
	   if (interr.ne.0) goto 95001			!flag inwht error
	   if (erro.ne.0)   return			!error, carry
	   if (type.eq.0)   goto 900			!eol
c
	   goto 1098
1099	continue
cwhile	enddo
c
900	continue
c
	if (c$srtn.le.0) goto 90002			!<sort list> empty
c
	return
c
c	errors
c	======
c
c	*** obsolete ***
90001	continue
	mark=p1				!mark rejected portion
	erro=1
	goto 99000
c
c	<sort list> empty
90002	continue
	mark=0
	erro=2
	goto 99000
c
99000	continue
	call errset_('SRLSYN',erro)	!set error
	return				!and return
c
c	inwht error
95001	continue
	erro=-1				!flag inwht error
	mark=p1				!mark rejected portion
	return				!return
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine srlit$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   		  mark,interr,erro)
c	*********************************************************
c
	implicit none
c
	integer type,val,dec,lim,p1,p2,mark,interr,erro
	real rval
	character*(*) buf,mymssg
c
c	Description
c	===========
c
c	It implements <item> figure, see above in SRLSYN.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:dbagc.own'
c
	integer size
c
c	begin
c	=====
c
	call errclr_('SRLIT$')				!error init
c
	erro=0
c
	if     (type.eq.35) then		!%n
	   c$srtn=c$srtn+1					!count it
	   if (c$srtn.gt.c$srlg) goto 90002		!max# exceeded
	   c$srln(c$srtn)=val				!store <n>
	   c$srla(c$srtn)(1:)=' '				!clear name
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 95001			!inwht error
	   goto 100					!look for 'A' or 'D'
c
	elseif (type.eq.1.or.
     1          type.eq.24  ) then		!identifier (_)
	   c$srtn=c$srtn+1					!count it
	   if (c$srtn.gt.c$srlg) goto 90002		!max# exceeded
	   c$srla(c$srtn)(1:)=buf(p1:p2)		!store <field name>
	   c$srln(c$srtn)=0				!clear field number
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 95001			!inwht error
	   goto 100					!look for 'A' or 'D'
c
	elseif (type.eq.33) then		!%
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 95001			!inwht error
	   if (type.ne.2) goto 90003			!<n> expected!
	   c$srtn=c$srtn+1					!count it
	   if (c$srtn.gt.c$srlg) goto 90002		!max# exceeded
	   c$srln(c$srtn)=val				!store <n>
	   c$srla(c$srtn)(1:)=' '				!clear field name
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 95001			!inwht error
	   goto 100					!look for 'A' or 'D'
c
	elseif (type.eq.40) then		!# (record #)
	   c$srtn=c$srtn+1					!count it
	   if (c$srtn.gt.c$srlg) goto 90002		!max# exceeded
	   c$srln(c$srtn)=0				!rec# = field# 0
	   c$srla(c$srtn)(1:)=' '				!clear name
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 95001			!inwht error
	   goto 100					!look for 'A' or 'D'
c
	else
	   goto 90001					!non-sort list item!
	endif
c
	goto 900					!return
c
c	Look for "A" or "D"
c
100	continue
c
	c$show(c$srtn)=1					!default is Ascend.
	if (erro.ne.0) return				!error, carry
	if (type.eq.0)   goto 900			!eol, return
	size=p2-p1+1					!size
	if (size.eq.1.and.type.eq.1) then
	   if     (buf(p1:p2).eq.'A'.or.
     1             buf(p1:p2).eq.'a'    ) then		!Asc., default
	      call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	      if (interr.ne.0) goto 95001		!inwht error
	   elseif (buf(p1:p2).eq.'D'.or.
     1             buf(p1:p2).eq.'d'    ) then		!Desc., set it
	      c$show(c$srtn)=2
	      call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	      if (interr.ne.0) goto 95001		!inwht error
	   endif
	endif
c
	goto 900						!return
c
900	continue
c
	return
c
c	errors
c	======
c
c	item expected
90001	continue
	mark=p1				!mark rejected portion
	erro=1
	goto 99000
c	max# of %<n> or <field name> reached
90002	continue
	mark=p1				!mark rejected portion
	erro=2
	goto 99000
c	<n> expected after %
90003	continue
	mark=p1				!mark rejected portion
	erro=3
	goto 99000
c
99000	continue
	call errset_('SRLIT$',erro)	!set error
	return				!and return
c
c	inwht error
95001	continue
	mark=p1				!mark rejected portion
	erro=-1				!flag inwht error
	return				!return
c
	end
c
c
c
c
	subroutine srlchk_(base,srlmap,srlhow,erro)
c	******************************************
c
	implicit none
c
	integer base,srlmap(*),srlhow(*),erro
c
c	Description
c	===========
c
c	This procedure should be fed with proper <sort list> items
c	already resolved into the <sort list> arrays. It then checks
c	them, setting <sort list> arrays SRLMAP and SRLHOW.
c
c	BASE is supposed to be in use (OPNBAS).
c
c	The result of sort list analysis (SRLSYN) is given to SRLCHK
c	as follows:
c
c	c$srtn	 :	total # of field numbers and field names
c	c$srln(i):	%n or 0
c	c$srla(i):	field names or spaces
c	c$show(i):	1 - Ascending, no UC
c			2 - Descending, no UC
c			3 - Asc., UC (strings)
c			4 - Desc., UC (strings)
c
c	N.B.:	If rec#, c$srln = 0 and c$srla = spaces
c
c	ON OUTPUT, all <sort list> expressions will be returned in arrays
c	srlmap:		srlmap(i), i=1,...	= k for field k
c	srlhow:		srlhow(i), i=1,...	as stated above
c
c			from 1 up to c$srtn
c
c	ERRO is returned not = 0 if illegal field number or "blank" field name.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagc.own'
c
	external istrip_
	integer istrip_
	character*10 myname
	integer k,kk,kkk,f,lim,idx,first,last
c
c	begin
c	=====
c
	call errclr_('SRLCHK')			!error init
	erro=0					!clear error
c
	first=d$u1st(base)		!first user data field
	last=first+d$udnf(base)-1	!and last
c
	idx=1				!initialize SRLMAP, SRLHOW
	srlmap(idx)=0			!...
	srlhow(idx)=0			!...
c
	do 1001 k = 1, c$srtn
	   f=c$srln(k)
c
	   if (f.lt.0) goto 90003		!???
c
	   if (f.gt.0) then			!field number
c
	      if (f.lt.first.or.f.gt.last) goto 90001	!field doesn't exist
	      srlmap(idx)=f				!set it
	      srlhow(idx)=c$show(idx)			!...
	      idx=idx+1					!next one
c
	   else					!field name
c
	      lim=istrip_(c$srla(k))
	      if (lim.le.0) then		!rec#
	         srlmap(idx)=0				!set it
	         srlhow(idx)=c$show(idx)		!...
	         idx=idx+1				!next one
	      else
	         call uc8to7_(c$srla(k))		!upper case field name
	         do 1002 kk = first, last
cbug	            call zmne_(base,kk,myname(1:),erro)
cbug	            if (erro.ne.0) return		!error, carry
	            myname=d$fmne(kk,base)		!real mnemonic !!!
	            call uc8to7_(myname)		!upper case
	            if (myname.eq.c$srla(k)) then
c
	               srlmap(idx)=kk			!set it
	               srlhow(idx)=c$show(idx)		!...
	               idx=idx+1			!next one
c
	               goto 100				!done with it
	            endif
1002	         continue
c
	         goto 90002				!bad field name
c
100	         continue
c
	      endif
	   endif
c
1	   continue
c
1001	continue
c
	if (idx.le.c$srlg) then
	      srlmap(idx)=0				!end of sort map
	      srlhow(idx)=0				!...
	endif
c
	return
c
c	errors
c	======
c
c	Field # doesn't exist
90001	continue
	erro=1
	goto 99000			!set error and return
c
c	Field name doesn't exist
90002	continue
	erro=2
	goto 99000			!set error and return
c
c	Internal error??????????(field number < 0)
90003	continue
	erro=3
	goto 99000			!set error and return
c
c	Set error and return
c
99000	continue
	call errset_('SRLCHK',erro)
	return
c
	end
c
c
c
c
	subroutine srlsem_(base,bitmap,srlmap,srlhow,twice,kcount,
	1                  erro)
c	**********************************************************
c
	implicit none
c
	integer base,bitmap(*),srlmap(*),srlhow(*),kcount,erro
	logical twice
c
c	Description
c	===========
c
c	A  BASE is given where records where selected in BITMAP.
c	Given a sorting criteria in SRLMAP (which fields comand)
c	the  sorting ) and SRLHOW ( ascending or descending) the
c	selected records are ordered accordingly in a misterious
c	data structure no one sees.
c
c	KCOUNT = # of killed records ignored, if any.
c
c	TWICE = .true. if dupolicated field reference in sort list.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagc.own'
c
	integer k,kkk,alive,nsrl,nrec
	logical protfail
c
c	begin
c	=====
c
	call errclr_('SRLSEM')		!error init
	erro=0				!clear error
c
	nsrl=c$srtn			!# of fields
	nrec=0				!# of records sorted
	kcount=0			!# of killed records
c
	protfail=.false.
c
c	Check/flag repeated field reference and protections
c
	twice=.false.
	do 1001 k = 1, nsrl - 1
	   do 1002 kkk = k + 1, nsrl
	      if (srlmap(k).eq.srlmap(kkk)) twice=.true.
1002	   continue
	   if (d$prt(base).ne.0) then		!protection ON
	      if (d$prfl(srlmap(k),base).eq.prtno) then
	         protfail=.true.		!can't read field
	      endif
	   endif
1001	continue
c
	if (d$prt(base).ne.0) then		!protection ON (last field...)
	   if (d$prfl(srlmap(nsrl),base).eq.prtno) then
	      protfail=.true.			!can't read field
	   endif
	endif
c
	if (protfail) goto 90001		!can't sort
c
c	get rid of any previous structure
c
	call ordclr_(bitmap,erro)
	if (erro.ne.0) goto 99001
c
c	init new structure
c
	call ordini_(base,bitmap,erro)
	if (erro.ne.0) goto 99001
c
c	order bitmap
c
	call ordkey_(base,bitmap,alive,srlmap,srlhow,nsrl,
	1            nrec,kcount,erro)
	if (erro.ne.0) goto 99001
	if (kcount.gt.0) then		!# of ignored records (killed)

	else

	endif
c
	return
c
c	errors
c	======
c
c	Inherited error, carry on
99001	continue
	return
c	Protected field, can't sort
90001	continue
	erro=1
	goto 99000
c
c	Set error and return
c
99000	continue
	call errset_('SRLSEM',erro)
	return
c
c	formats
c	=======
c
	end
c
c
c
c
