c	*****************************************************************
c	VERSO W1.1 - COM PREENCHIMENTO DE UM RECORD 
c	*****************************************************************
c
c	CAUTION: When appending properties (call putsw_ or call appsw_),
c		 make sure the owner record "pai" exists !!!, these
c		 procedures don't check that.
c
	subroutine inqsw_(prop,pai,exist,error)
c	***************************************
c	Written by Paulo Alexandre Gonalves 14/12/87
c
	implicit none
c
c	Input
c	=====
	integer prop,pai
	logical exist
c
c	Output
c	======
	integer error
c
c	Description
c	===========
c	Returns EXIST =.true. if property exists, .false. otherwise.
c
c	Var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagsr.own'
c
	integer xcode				!Call variables
	character*10 txt			!Call variables
	logical eox				!Call variable
c
	integer father				!father position
c
c	Begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('INQSW')
	error=0					!clear error
c
	if (prop.le.0.or.
	1   prop.gt.d$b ) goto 90001		!???
	if (pp$fat(prop).le.0) goto 90002	!not opened
c
	if (d$race(prop).ne.r$pp) goto 90003	!not the proper creature
c
	father=pp$fat(prop)			!father position
c
	if (d$ixio(father,prop).le.0) then
	   call opnx_(prop,father,error)	!(Re)open index
	   if (error.ne.0) goto 95000
	endif
c
	call findx_(prop,father,pai,txt,xcode,eox,error)!Search if a property
	if (error.ne.0) goto 95000		!exists
	exist=.not.eox
c
	return
c
c	errors
c	======
c	Invalid base channel
90001	continue
	error=1
	goto 99000
c	Not opened
90002	continue
	d$rinf(1:10)='structure '
	d$rinf(11:)=d$unam(prop)		!tell him witch structure
	error=2
	goto 99000
c	Not the proper creature
90003	continue
	d$rinf(1:)=d$unam(prop)			!tell him witch creature
	error=3
	goto 99000
c
99000	continue
	call errset_('INQSW',error)			!set my own error
	return						!return
c
c	Others error
c
95000	continue
	return
c
	end	
c
c
c
c
	subroutine putsw_(prop,pai,win,error)
c	*************************************
c	Written by Paulo Alexandre Gonalves 7/12/87
c
	implicit none
c
c	Input
c	=====
	integer prop,pai
	character*(*) win(*)
c
c	Output
c	======
	integer error
c
c	Description
c	===========
c
c	Deletes the property if it exists and appends the new element.
c
c	CAUTION: DELSW + APPSW could (should...) be used instead ... !!!
c
c	Var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagsr.own'
c
	character*10 txt
	logical eox
	integer xcode,from
c
	integer father		!father position
c
c	Begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('PUTSW')
	error=0					!clear error
c
	if (prop.le.0.or.
	1   prop.gt.d$b ) goto 90001		!???
c
	if (d$base(prop).le.0.or.
	1   pp$fat(prop).le.0.or.
	1   d$pid(prop).le.0     ) then
	   goto 90002				!not properly open
	endif
c
	if (d$race(prop).ne.r$pp) goto 90003	!not the proper creature
c
	father=pp$fat(prop)			!father position
c
	if (d$ixio(father,prop).le.0) then
	   call opnx_(prop,father,error)	!(Re)open index
	   if (error.ne.0) goto 95000
	endif
c
	call findx_(prop,father,pai,txt,xcode,eox,error)!Find First element
	if (error.ne.0)  goto 95000
	if (.not.eox) then
	   from=1					!the whole property
	   call delsw_(prop,pai,from,error)		!deleted
	   if (error.ne.0)  goto 95000
	endif
c
	call appsw_(prop,pai,win,error)		!append new element
	if (error.ne.0)  goto 95000
c
	goto 100				!return
c
c	Return
c
100	return
c
c	errors
c	======
c	Invalid base channel
90001	continue
	error=1
	goto 99000
c	Not opened or not opened for update
90002	continue
	d$rinf(1:10)='structure '
	d$rinf(11:)=d$unam(prop)		!tell him witch structure
	error=2
	goto 99000
c	Not the proper creature
90003	continue
	d$rinf(1:)=d$unam(prop)			!tell him witch creature
	error=3
	goto 99000
c
99000	continue
	call errset_('PUTSW',error)			!set my own error
	return						!return
c
c	Others error
c
95000	continue
	return
c
	end
c
c
c
c
	subroutine appsw_(prop,pai,win,error)
c	*************************************
c	Written by Paulo Alexandre Gonalves 14/12/87
c
	implicit none
c
c	Input
c	=====
	integer prop,pai
	character*(*) win(*)
c
c	Output
c	======
	integer error
c
c	Description
c	===========
c	This procedure appends a new record to the property.The various fields
c	come in via win,one field per line.
c
c	Var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagsr.own'
c
	integer nxtrec,onenmb
	integer xcode,alive			!Call variables
	integer primeiro			!First record
	integer lastrec				!Record appended
	integer ultrec				!Last record of old property
	integer i				!auxiliar variable
	logical eox				!Call variable
	character*10 txt			!call variables
	integer linksz
	integer p1,p2
c
	integer father		!father position
	integer next		!next position
	integer last		!last position
	integer data1st		!first data field
	integer datanf		!number of data fields
	integer datalast	!last data field
c
c	Begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('APPSW')
	error=0				!clear error
c
	if (prop.le.0.or.
	1   prop.gt.d$b ) goto 90001		!???
c
	if (d$base(prop).le.0.or.
	1   pp$fat(prop).le.0.or.
	1   d$pid(prop).le.0     ) then
	   goto 90002				!not properly open
	endif
c
	if (d$race(prop).ne.r$pp) goto 90003	!not the proper creature
c
	father=pp$fat(prop)		!father position
	next=pp$nxt(prop)		!next position
	last=pp$lst(prop)		!last position
	linksz=d$siz(father,prop)	!father/next/last size
c
	data1st=d$u1st(prop)			!first data field
	datanf=d$udnf(prop)			!number of data fields
	datalast=data1st+datanf-1		!last field data
c
	if (d$ixio(father,prop).le.0) then
	   call opnx_(prop,father,error)	!(Re)open index
	   if (error.ne.0) goto 95000
	endif
c
	call findx_(prop,father,pai,txt,xcode,eox,error)!Search if exists
							!property
	if (error.ne.0) goto 95000				
	if (eox) then				!The first one
c
	   do 5,i=1,datanf
	      p1=d$pos(i+data1st-1,prop)
	      p2=p1+d$siz(i+data1st-1,prop)-1
cx	      d$xbuf(p1:p2)=win(i)		!win1()=win
	      d$xbuf(p1:p2)=' '			!clean !!!
	      onenmb=0
	      call cflt_(prop,win(i),onenmb,i,d$xbuf,error)
	      if (error.ne.0) goto 95000
5	   continue
c
	   p1=d$pos(father,prop)
	   p2=p1+linksz-1
	   write (d$xbuf(p1:p2),'(i<linksz>)',
	1         err=90005) pai		!

	   p1=d$pos(next,prop)
	   p2=p1+linksz-1
	   write (d$xbuf(p1:p2),'(i<linksz>)',
	1         err=90005) nil		!Initialize pointers

	   call znext_(prop,nxtrec,error)
	   if (error.ne.0) goto 95000

	   p1=d$pos(last,prop)
	   p2=p1+linksz-1
	   write (d$xbuf(p1:p2),'(i<linksz>)',
	1         err=90005) nxtrec		!next record (myself)

	   error=-16381744
	   call more2_(prop,xcode,d$xbuf,.true.,.false.,error)
	   if (error.ne.0) goto 95000
c
	   goto 100
	else
	   primeiro=xcode			!First record
	   call find_(prop,primeiro,alive,d$xbuf,error)
	   if (error.ne.0) goto 95000
	   p1=d$pos(last,prop)
	   p2=p1+linksz-1
	   read(d$xbuf(p1:p2),'(i<linksz>)',
	1       err=90004) ultrec		!last record of the property
	   if (ultrec.le.0) goto 90004		!???

	   do 10,i=1,datanf
	      p1=d$pos(i+data1st-1,prop)
	      p2=p1+d$siz(i+data1st-1,prop)-1
cx	      d$xbuf(p1:p2)=win(i)		!win1()=win
	      d$xbuf(p1:p2)=' '			!clean !!!
	      onenmb=0
	      call cflt_(prop,win(i),onenmb,i,d$xbuf,error)
	      if (error.ne.0) goto 95000
10	   continue
c
	   p1=d$pos(father,prop)
	   p2=p1+linksz-1
	   write (d$xbuf(p1:p2),'(i<linksz>)',
	1         err=90005) pai			!

	   p1=d$pos(next,prop)
	   p2=p1+linksz-1
	   write (d$xbuf(p1:p2),'(i<linksz>)',
	1         err=90005) nil			!Initialize pointers

	   p1=d$pos(last,prop)
	   p2=p1+linksz-1
	   write (d$xbuf(p1:p2),'(i<linksz>)',
	1         err=90005) nil			!

	   error=-16381744
	   call more2_(prop,xcode,d$xbuf,.false.,.false.,error)
	   if (error.ne.0) goto 95000
c
	   lastrec=xcode
	   call find_(prop,ultrec,alive,d$xbuf,error)
	   if (error.ne.0) goto 95000		     !	
	   p1=d$pos(next,prop)
	   p2=p1+linksz-1
	   write (d$xbuf(p1:p2),'(i<linksz>)',
	1         err=90005) lastrec			!next to new append
c
	   error=-16381744
	   call modify2_(prop,ultrec,d$xbuf,.false.,error)
	   if (error.ne.0) goto 95000
	   call find_(prop,primeiro,alive,d$xbuf,error)
	   if (error.ne.0) goto 95000		       !the last record on
	   p1=d$pos(last,prop)
	   p2=p1+linksz-1
	   write (d$xbuf(p1:p2),'(i<linksz>)',
	1         err=90005) lastrec			!first rec.last

	   error=-16381744
	   call modify2_(prop,primeiro,d$xbuf,.false.,error)
	   if (error.ne.0) goto 95000
	   goto 100
c
	endif
c
c	Return
c
100	return
c
c	errors
c	======
c
c	Invalid base channel
90001	continue
	error=1
	goto 99000
c	Not opened or not opened for update
90002	continue
	d$rinf(1:10)='structure '
	d$rinf(11:)=d$unam(prop)		!tell him witch structure
	error=2
	goto 99000
c	Not the proper creature
90003	continue
	d$rinf(1:)=d$unam(prop)			!tell him witch creature
	error=3
	goto 99000
c	Bad link to last record
90004	continue
	d$rinf(1:9)='PROPERTY '
	d$rinf(10:)=d$unam(prop)		!tell him witch creature
	error=4
	goto 99000
c	Error writing links
90005	continue
	d$rinf(1:9)='PROPERTY '
	d$rinf(10:)=d$unam(prop)		!tell him witch creature
	error=5
	goto 99000
c
99000	continue
	call errset_('APPSW',error)			!set my own error
	return						!return
c
c	Others error
c
95000	continue
	return
c
	end
c
c
c
c
	subroutine delsw_(prop,pai,from,error)
c	****************************************
c	Written by Paulo Alexandre Gonalves 14/12/87
c
	implicit none
c
c	Input
c	=====
	integer prop,pai,from
c
c	Output
c	======
	integer error
c
c	Description
c	===========
c	Puts a nil pointer on the field next of the desde element if it exists
c	The other elements are forgetten to the property but they remain on the
c	base.
c	If deleting the whole property (FROM=1), the entry on the index file is
c	removed and the property elements remain untouched.
c
c	Var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagsr.own'
c
	integer i				!Auxiliar variable
	integer xcode,field,val,alive,rec	!Call variables
	integer primeiro,lastrec		!First and Last records
	character*10 txt			!Call variables
	logical eox				!Call variable
	integer linksz
	integer p1,p2
c
	integer father		!father position
	integer next		!next position
	integer last		!last position
c
c	Begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('DELSW')
	error=0						!clear error
c
	if (prop.le.0.or.
	1   prop.gt.d$b ) goto 90001		!???
c
	if (d$base(prop).le.0.or.
	1   pp$fat(prop).le.0.or.
	1   d$pid(prop).le.0     ) then
	   goto 90002				!not properly open
	endif
c
	if (d$race(prop).ne.r$pp) goto 90003	!not the proper creature
c
	father=pp$fat(prop)		!father position
	next=pp$nxt(prop)		!next position
	last=pp$lst(prop)		!last position
	linksz=d$siz(father,prop)	!father/next/last size
c
	if (d$ixio(father,prop).le.0) then
	   call opnx_(prop,father,error)			!(Re)open index
	   if (error.ne.0) goto 95000
	endif
c
	call findx_(prop,father,pai,txt,xcode,eox,error)!Search if a property
	if (error.ne.0) goto 95000			!exists
	primeiro=xcode					!First rec = XCODE
	if (eox) goto 90005				!If don't find error
	if (from.lt.0) goto 90006			!If negative rec error
	if (from.eq.1) then				!Delete entire property	
c
	   if (d$ixio(father,prop).le.0) then
	      call opnx_(prop,father,error)		!(Re)open index
	      if (error.ne.0) goto 95000
	   endif
c
	   call delx_(prop,father,val,txt,xcode,error)	!  Remove from index 
	   if (error.ne.0) goto 95000			!  file.
c
	   error=-16381744
	   call find_(prop,xcode,alive,d$xbuf,error)	!read last rec valid
	   if (error.ne.0) goto 95000
c
	   p1=d$pos(last,prop)				!no more next to last!
	   p2=p1+linksz-1
	   write(d$xbuf(p1:p2),'(i<linksz>)',
	1        err=90008) nil
c
	   error=-16381744
	   call modify2_(prop,xcode,d$xbuf,.false.,error)
	   if (error.ne.0) goto 95000
c
	   goto 100
c
	endif
c
	do 10,i=1,from					!Look for FROM element
	   if (xcode.eq.0) goto 90004			!  not enough elements
	   lastrec=xcode					!Last rec=XCODE
	   call find_(prop,xcode,alive,d$xbuf,error)
	   if (error.ne.0) goto 95000
	   p1=d$pos(next,prop)
	   p2=p1+linksz-1
	   read (d$xbuf(p1:p2),'(i<linksz>)',err=90007) xcode
10	continue	

	p1=d$pos(next,prop)
	p2=p1+linksz-1
	write (d$xbuf(p1:p2),'(i<linksz>)',
	1      err=90008) nil			!Unlink from the rest

	error=-16381744
	call modify2_(prop,lastrec,d$xbuf,.false.,error)
	if (error.ne.0) goto 95000
	call find_(prop,primeiro,alive,d$xbuf,error)
	if (error.ne.0) goto 95000
	p1=d$pos(last,prop)
	p2=p1+linksz-1
	write (d$xbuf(p1:p2),'(i<linksz>)',
	1      err=90008) lastrec		!the last rec

	error=-16381744
	call modify2_(prop,primeiro,d$xbuf,.false.,error)
	if (error.ne.0) goto 95000
	goto 100
c
c	Return
c
100	return
c
c	errors
c	======
c	Invalid base channel
90001	continue
	error=1
	goto 99000
c	Not opened or not opened for update
90002	continue
	d$rinf(1:10)='structure '
	d$rinf(11:)=d$unam(prop)		!tell him witch structure
	error=2
	goto 99000
c	Not the proper creature
90003	continue
	d$rinf(1:)=d$unam(prop)			!tell him witch creature
	error=3
	goto 99000
c	Not enough elements
90004	continue
	d$rinf(1:9)='PROPERTY '
	d$rinf(10:)=d$unam(prop)		!tell him witch creature
	error=4
	goto 99000
c	Could not find first rec or empty base
90005	continue
	d$rinf(1:9)='PROPERTY '
	d$rinf(10:)=d$unam(prop)		!tell him witch creature
	error=5
	goto 99000
c	Negative index
90006	continue
	d$rinf(1:9)='PROPERTY '
	d$rinf(10:)=d$unam(prop)		!tell him witch creature
	error=6
	goto 99000
c	Bad link to next record
90007	continue
	d$rinf(1:9)='PROPERTY '
	d$rinf(10:)=d$unam(prop)		!tell him witch creature
	error=7
	goto 99000
c	Error writing links
90008	continue
	d$rinf(1:9)='PROPERTY '
	d$rinf(10:)=d$unam(prop)		!tell him witch creature
	error=8
	goto 99000
c
99000	continue
	call errset_('DELSW',error)			!set my own error
	return						!return
c
c	Others error
c
95000	continue
	return
c
	end	
c
c
c
c
	subroutine chgsw_(prop,pai,win,element,error)
c	********************************************
c	Written by Paulo Alexandre Gonalves 14/12/87
c
	implicit none
c
c	Input
c	=====
	integer prop,pai
	integer element				!Record to be altereted
	character*(*) win(*)			!
c
c	Output
c	======
	integer error
c
c	Description
c	===========
c	It modify the "ELEMENT" record if it exists.
c
c	Var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagsr.own'
c
	integer xcode,alive,onenmb		!Call Variables
	logical eox				!Call variable
	character*10 txt			!Call Variables
	integer primeiro,lastrec			!First and Last records
	integer i				!Auxiliar variable
	logical indxf				!Index flag	
	integer linksz
	integer p1,p2
c
	integer father		!father position
	integer next		!next position
	integer last		!last position
	integer data1st		!first data field
	integer datanf		!number of data fields
	integer datalast	!last data field
c
c	Begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('CHGSW')
	error=0					!clear error
c
	if (prop.le.0.or.
	1   prop.gt.d$b ) goto 90001		!???
c
	if (d$base(prop).le.0.or.
	1   pp$fat(prop).le.0.or.
	1   d$pid(prop).le.0     ) then
	   goto 90002				!not properly open
	endif
c
	if (d$race(prop).ne.r$pp) goto 90003	!not the proper creature
c
	father=pp$fat(prop)		!father position
	next=pp$nxt(prop)		!next position
	last=pp$lst(prop)		!last position
	linksz=d$siz(father,prop)	!father/next/last size
c
	data1st=d$u1st(prop)			!first data field
	datanf=d$udnf(prop)			!number of data fields
	datalast=data1st+datanf-1		!last field data
c
	indxf=.false.
	if (element.le.0) goto 90006		!Negative index
c
	if (d$ixio(father,prop).le.0) then
	   call opnx_(prop,father,error)		!(Re)open index
	   if (error.ne.0) goto 95000
	endif
c
	call findx_(prop,father,pai,txt,xcode,eox,error)!Search for the first
	if (error.ne.0) goto 95000	
	primeiro=xcode				!First rec= XCODE
	if (eox) goto 90005			!Not find first rec
	do 10,i=1,element			!Look for ELEMENT 
	   if (xcode.eq.0) goto 90004
	   lastrec=xcode
	   call find_(prop,xcode,alive,d$xbuf,error)
	   p1=d$pos(next,prop)
	   p2=p1+linksz-1
	   read(d$xbuf(p1:p2),'(i<linksz>)',err=90007) xcode
10	continue

	do 20,i=1,datanf				!win1()=win()
	   p1=d$pos(i+data1st-1,prop)
	   p2=p1+d$siz(i+data1st-1,prop)-1
cx	   d$xbuf(p1:p2)=win(i)
	   d$xbuf(p1:p2)=' '			!clean !!!
	   onenmb=0
	   call cflt_(prop,win(i),onenmb,i,d$xbuf,error)
	   if (error.ne.0) goto 95000
20	continue
	if (lastrec.eq.primeiro) indxf=.true.	!Index the first rec
	error=-16381744
	call modify2_(prop,lastrec,d$xbuf,indxf,error)
	if (error.ne.0) goto 95000
	goto 100
c
c	Return
c
100	return
c
c	errors
c	======
c
c	Invalid base channel
90001	continue
	error=1
	goto 99000
c	Not opened or not opened for update
90002	continue
	d$rinf(1:10)='structure '
	d$rinf(11:)=d$unam(prop)		!tell him witch structure
	error=2
	goto 99000
c	Not the proper creature
90003	continue
	d$rinf(1:)=d$unam(prop)			!tell him witch creature
	error=3
	goto 99000
c	Element > Number of records
90004	continue
	d$rinf(1:9)='PROPERTY '
	d$rinf(10:)=d$unam(prop)		!tell him witch creature
	error=4
	goto 99000
c	Could not find first rec or empty base
90005	continue
	d$rinf(1:9)='PROPERTY '
	d$rinf(10:)=d$unam(prop)		!tell him witch creature
	error=5
	goto 99000
c	Negative index
90006	continue
	d$rinf(1:9)='PROPERTY '
	d$rinf(10:)=d$unam(prop)		!tell him witch creature
	error=6
	goto 99000
c	Bad link to next record
90007	continue
	d$rinf(1:9)='PROPERTY '
	d$rinf(10:)=d$unam(prop)		!tell him witch creature
	error=7
	goto 99000
c
99000	continue
	call errset_('CHGSW',error)			!set my own error
	return						!return
c
c	Others error
c
95000	continue
	return
c
	end
c
c
c
c
	subroutine getsw_(prop,pai,win,more,error)
c	******************************************
c	Written by Paulo Alexandre Gonalves 18/12/87
c
	implicit none
c
c	Input
c	=====
	integer prop,pai
	logical more			!True if I want the next record
c
c	Output
c	======
	integer error
	character*(*) win(*)
c	logical more			!TRUE if exists more records
c
c	Description
c	===========
c	If more is false gets the first record.If more is false gets the next
c	record until the last.If more returns false there is no more records.
c	
c	Var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagsr.own'
c
	integer nxtrec,onenmb		!Points to the next record 
	integer b2,mast,dbcode
	character*10 txt		!Call Variables
	integer i			!Auxiliar Variable			
	logical eox,goon,user		!Call Variable
	integer alive,xcode		!Call Variables
	integer linksz
	integer p1,p2
c
	integer father		!father position
	integer next		!next position
	integer last		!last position
	integer data1st		!first data field
	integer datanf		!number of data fields
	integer datalast	!last data field
c
c
c	Begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('GETSW')
	error=0					!clear error
c
	if (prop.le.0.or.
	1   prop.gt.d$b ) goto 90001		!???
	if (pp$fat(prop).le.0) goto 90002	!not opened
c
	if (d$race(prop).ne.r$pp) goto 90003	!not the proper creature
c
	father=pp$fat(prop)		!father position
	next=pp$nxt(prop)		!next position
	last=pp$lst(prop)		!last position
	linksz=d$siz(father,prop)	!father/next/last size
c
	data1st=d$u1st(prop)			!first data field
	datanf=d$udnf(prop)			!number of data fields
	datalast=data1st+datanf-1		!last field data
c
	goon=more
c
	if (.not.goon) then		!If more = .False. read the first rec
c
	   if (d$ixio(father,prop).le.0) then
	      call opnx_(prop,father,error)	!(Re)open index
	      if (error.ne.0) goto 95000
	   endif
c
	   call findx_(prop,father,pai,txt,xcode,eox,error)
	   if (error.ne.0) goto 95000
	   if (eox) goto 90004
	   call find_(prop,xcode,alive,d$xbuf,error)
	   if (error.ne.0) goto 95000
	   p1=d$pos(next,prop)
	   p2=p1+linksz-1
	   read (d$xbuf(p1:p2),'(i<linksz>)',
	1        err=90005) nxtrec		!Read pointer to next rec

	   pp$mor(prop)=nxtrec			!save it away
	   do 1,i=1,datanf			!Read record data
	      p1=d$pos(i+data1st-1,prop)
	      p2=p1+d$siz(i+data1st-1,prop)-1
cx	      win(i)=d$xbuf(p1:p2)
	      win(i)(1:)=' '			!clean !!!
	      call cunflt_(prop,win(i),onenmb,i,d$xbuf,error)
	      if (error.ne.0) goto 95000
c
	      b2=d$dbio(i,prop)
	      mast=d$mast(i,prop)
	      if (b2.gt.0.and.mast.gt.0) then	!o.d.b. field
	         read (win(i),'(i10)',err=101) dbcode
	         user=.true.			!external format
	         call dbtxt_(b2,win(i),onenmb,dbcode,mast,user,error)
	         if (error.ne.0) goto 101
	         goto 102
101	         continue
	         call errclr_('GETSW')		!clear error
	         error=0
	         win(i)='**********'
	         goto 102
102	         continue
	      endif
c
1	   continue
	else				!more=.true. read next record
	   nxtrec=pp$mor(prop)		!recover next
	   if (nxtrec.le.0) goto 80	!If more=true and next=0 end of property
	   call find_(prop,nxtrec,alive,d$xbuf,error)
	   if (error.ne.0) goto 95000
	   p1=d$pos(next,prop)
	   p2=p1+linksz-1
	   read (d$xbuf(p1:p2),'(i<linksz>)',
	1        err=90005) nxtrec	!Read next record

	   do 2,i=1,datanf		!Read Record Data
	      p1=d$pos(i+data1st-1,prop)
	      p2=p1+d$siz(i+data1st-1,prop)-1
cx	      win(i)=d$xbuf(p1:p2)
	      win(i)(1:)=' '			!clean !!!
	      call cunflt_(prop,win(i),onenmb,i,d$xbuf,error)
	      if (error.ne.0) goto 95000
c
	      b2=d$dbio(i,prop)
	      mast=d$mast(i,prop)
	      if (b2.gt.0.and.mast.gt.0) then	!o.d.b. field
	         read (win(i),'(i10)',err=201) dbcode
	         user=.true.			!external format
	         call dbtxt_(b2,win(i),onenmb,dbcode,mast,user,error)
	         if (error.ne.0) goto 201
	         goto 202
201	         continue
	         call errclr_('GETSW')		!clear error
	         error=0
	         win(i)='**********'
	         goto 202
202	         continue
	      endif
2	   continue
cxcxcx	   if (nxtrec.le.0) goto 80
	endif
c
	more=.true.
c
	goto 100
c
c	No more elements
c
80	continue
c
	more=.false.
	goto 100
c
c	Return
c
100	continue
c
	pp$mor(prop)=nxtrec		!save it away
c
	return
c
c	errors
c	======
c
c	Invalid base channel
90001	continue
	error=1
	goto 99000
c	Not opened
90002	continue
	d$rinf(1:10)='structure '
	d$rinf(11:)=d$unam(prop)		!tell him witch structure
	error=2
	goto 99000
c	Not the proper creature
90003	continue
	d$rinf(1:)=d$unam(prop)			!tell him witch creature
	error=3
	goto 99000
c	Could not find first rec or empty base
90004	continue
	d$rinf(1:9)='PROPERTY '
	d$rinf(10:)=d$unam(prop)		!tell him witch creature
	error=4
	goto 99000
c	Bad link to next record
90005	continue
	d$rinf(1:9)='PROPERTY '
	d$rinf(10:)=d$unam(prop)		!tell him witch creature
	error=5
	goto 99000
c
99000	continue
	call errset_('GETSW',error)			!set my own error
	return						!return
c
c	Others error
c
95000	continue
	return
	end
c
c
c
c
	subroutine opnsw_(prop,name,update,error)
c	*****************************************
c	Written by Paulo Alexandre Gonalves,18/12/1987
c
	implicit none
c
c	Input
c	=====
	character*(*) name			!Name of the struture of seq
	integer update			
c
c	Output
c	======
	integer prop				!channel to seq
	integer error
c
c	Description
c	===========
c
c	Performs the open of the base associated to the sequence of values.
c	Tries to open the owner base and fill the base channel.
c
c	Var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagsr.own'
c
	external istrip_
	integer istrip_
	integer mode,bb,fidx
	character*60 owname
	logical newopn
c
	integer father		!father position
c
c	Begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('OPNSW')
	error=0					!clear error
c	
	mode=0
	call open_(prop,name,update,mode,newopn,error)
	if (error.ne.0) goto 90003		!can't
c
	if (d$race(prop).ne.r$pp) goto 90001	!not the proper creature
c
	pp$fat(prop)=d$nfld(prop)-2	!father position
	pp$nxt(prop)=d$nfld(prop)-1	!next position
	pp$lst(prop)=d$nfld(prop)	!last position
c
	d$u1st(prop)=1			!first data field
	d$udnf(prop)=d$nfld(prop)-3	!number of data fields
c
	father=pp$fat(prop)
c
	if (d$ixio(father,prop).le.0) then
	   call opnx_(prop,father,error)	!(Re)open index
	   if (error.ne.0) then
	      if (d$itrv.eq.1) then		!interactive
	         goto 90002
	      else
                 goto 95000
	      endif
	   endif
	endif
c
c	Open owner base and fill in base channel
c	If UPDATE mode or non-interactive, set error; otherwise, just warn
c
	owname(1:)=' '
	owname=d$ownb(prop)			!open owner base
	mode=0					!usual mode
	call open_(bb,owname,update,mode,newopn,error)
	if (error.ne.0) goto 90003		!can't
	call znum_(bb,fidx,name,error)		!field number
	if (error.ne.0) goto 90004		!??? not there ???
	d$dbio(fidx,bb)=prop			!base channel
c
	goto 100
c
c	Return
c
100	return
c
c	errors
c	======
c
c	Not the proper creature
90001	continue
	d$rinf(1:)=d$unam(prop)			!tell him witch creature
	error=1
	goto 99000
c	Can't open "father" indexes
90002	continue
	d$rinf(1:9)='PROPERTY '
	d$rinf(10:)=d$unam(prop)		!tell him witch creature
	error=2
	goto 99000
c	Can't open owner base
90003	continue
	d$rinf(1:10)='owner base'
	d$rinf(12:)=owname
	d$rinf(istrip_(d$rinf)+1:)=', property'
	d$rinf(istrip_(d$rinf)+2:)=name
	error=3
	goto 99000
c	???No such property in owner base???
90004	continue
	d$rinf(1:10)='owner base'
	d$rinf(12:)=owname
	d$rinf(istrip_(d$rinf)+1:)=', property'
	d$rinf(istrip_(d$rinf)+2:)=name
	error=4
	goto 99000
c
99000	continue
	call errset_('OPNSW',error)			!set my own error
	return						!return
c
c	Others error
c
95000	continue
	return
c
	end
c
c
c
c
	subroutine clssw_(prop,error)
c	*********************************
c	Written by Paulo Alexandre Gonalves,18/12/1987
c
	implicit none
c
c	Input
c	=====
	integer prop			!number of the associated base to close	
c
c	Output
c	======
	integer error
c
c	Description
c	===========
c	Closes the database associated to the sequence.
c
c	Var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagsr.own'
c
	integer father		!father position
c
c	Begin
c	=====
c
c	init error handling
c	-------------------
c
	call errclr_('CLSSW')
	error=0					!clear error
c
	if (d$base(prop).le.0) then
	   goto 90002				!not properly open ???
	endif
c
	if (d$race(prop).ne.r$pp) goto 90002	!not the proper creature
c
	father=pp$fat(prop)			!father position
c
	if (d$ixio(father,prop).gt.0) then
	   call clsx_(prop,father,error)	!Close index if not yet
	   if (error.ne.0) then
	      call errclr_('CLSSW')		!ignore error
	      error=0
	   endif
	endif
c
	call clsbas_(prop,error)
	if (error.ne.0) goto 95000
c
	goto 100
c
c	Return
c
100	return
c
c	errors
c	======
c
c	Invalid base channel
90001	continue
	error=1
	goto 99000
c	Not the proper creature
90002	continue
	d$rinf(1:)=d$unam(prop)			!tell him witch creature
	error=2
	goto 99000
c
99000	continue
	call errset_('CLSSW',error)			!set my own error
	return						!return
c
c	Others error
c
95000	continue
	return
c
	end
c
c
c
c
