	subroutine stredt_(base,prop,edit,strname,new,full,erro)
c	******************************************************
c
	implicit none
c
	integer base,prop
	integer erro
	logical edit,new,full
	character*(*) strname
c
c	Description
c	===========
c
c	Implements CREATE, MODIFY and DISPLAY STRUCTURE commands in screen
c	mode (SET SCREEN ON).
c
c	If EDIT = .true., edit data base structure;
c	If EDIT = .false., show data base structure.
c
c	If NEW = .true., a new data base struct. will be created/modified/shown;
c	if NEW = .false., an existing data base struct. will be modified/shown.
c
c	If FULL = .true., full modify of data base BASE structure will be
c	allowed; if FULL = .false., only non-critical ("textual") data can
c	actually be modified.
c
c	If PROP .ne. 0, a property structure is beeing created/modified/shown,
c	and BASE isn't used at all.
c
c	If PROP .eq. 0, a common data base structure is beeing ...
c
c	STRNAME will be used as data base name to edit, if not empty.
c
c	BASE:
c		- OUTPUT argument if CREATING a new data base structure: base
c		    channel used to store data base structure defined by user;
c		- INPUT argument if MODIFYING or DISPLAYING an existing data
c		    base structure.
c
c	Obviously, if NEW = .false., STRNAME can't be empty and BASE should be
c	a base channel.
c
c	This procedure uses VEDITS with five independant screen "slices"
c	and mode = 4 or 5 if editing, mode = 6 if showing data base struct.
c
c	Screen "slices":
c
c	G	general data base info (name, designation, 1rst rec#)
c	F	field list (mnemonic, description)
c	T	field type
c	W	field width, dec. places
c	R	remaining field details:	R1	type 1 - integer (n)
c						R2	     2 - string  (c)
c						R3           3 - otherdb (db)
c						R4           4 - decimal (x)
c						R5           5 - date    (d)
c						R6           6 - logical (l)
c						R7           7 - real    (r)
c
c	Editor in mode 4/5 returns ?STAT 	>  0	^Z EXIT
c						=  0	^Z QUIT
c					  	-1	<ret> at the bottom
c					  	-2	up_arrow
c						-3	down_arrow
c						-4	gold/up_arrow
c						-5	gold/down_arrow
c						-6	help or gold/help
c
c	Editor in mode 7/8 returns ?STAT 	>  0	^Z EXIT
c						=  0	^Z QUIT
c					  	-1	<ret> ANYWHERE
c					  	-2	up_arrow
c						-3	down_arrow
c						-4	gold/up_arrow
c						-5	gold/down_arrow
c						-6	help or gold/help
c
c	Editor in mode 9/10 returns ?STAT 	>  0	^Z EXIT
c						=  0	^Z QUIT
c					  	-1	<ret> ANYWHERE
c					  	-2	up_arrow
c						-3	down_arrow at THE END of
c							page,OPEN LINE elsewuere
c						-4	gold/up_arrow
c						-5	gold/down_arrow
c						-6	help or gold/help
c
c	Var
c	===
c
	include 'own:DBAG0.OWN'
	include 'own:DBAGB.OWN'
	include 'own:dbagd.own'
	include 'own:vedit.own'
	include 'own:stredt.own'
c
	integer		quit,			!^Z QUIT
     1   		ret,			!<ret>
     1   		up,			!UP_ARROW
     1   		down,			!DOWN_ARROW
     1   		g_up,			!<GOLD>/UP_ARROW
     1   		g_down,			!<GOLD>/DOWM_ARROW
     1   		help			!HELP or <GOLD>/HELP
c
	parameter
     1   		( quit=0, ret=-1, up=-2, down=-3, g_up=-4,
     1   		  g_down=-5, help=-6 )
c
	logical
     1   		inidon/.false./,	!screen TEXT already initialized
						!(first call to STREDT)
     1   		dohlp,			!=.false. if my own help
     1   		fdohlp,			!(special for screen F* - bug)
     1   		hlpon			!true if help in progress
	character*80
     1   		whtmsg
	character*(20)
     1   		fmssg(fpline)		!mnemonic+description
	character*(1)
     1   		fhlp(fpline)		!help message space
	character*70
     1   		fdtmsg
	character*60
     1   		gmssg(gpline)
	character*20
     1   		tmssg(tpline),wmssg(wpline),
     1   		r1mssg(r1plin),r2mssg(r2plin),r3mssg(r3plin),
     1   		r4mssg(r4plin),	r5mssg(r5plin),r6mssg(r6plin),
     1			r7mssg(r7plin)
	character*1
     1   		ghlp(gpline),thlp(tpline),whlp(wpline),
     1   		r1hlp(r1plin),r2hlp(r2plin),r3hlp(r3plin),
     1   		r4hlp(r4plin),r5hlp(r5plin),r6hlp(r6plin),
     1			r7hlp(r7plin)
	integer
     1			gpl,
     1   		gmode,tmode,fmode,wmode,r1mode,r2mode,r3mode,
     1                  r4mode,	r5mode,r6mode,r7mode
	integer
     1   		gstt,gsize,fstt,fsize,tstt,tsize,wstt,wsize,
     1                  r1stt,r1size,r2stt,r2size,r3stt,r3size,r4stt,
     1                  r4size,r5stt,r5size,r6stt,r6size,r7stt,r7size
	integer
     1   		gsmax,fsmax,tsmax,wsmax,r1smax,r2smax,r3smax,
     1                  r4smax,r5smax,r6smax,r7smax
	integer
     1   		gkind(gpline),gmsiz(gpline),gmini(gpline),
     1   		gmaxi(gpline),gblink(gpline),gftyp(gpline),
     1                  gpsiz,
     1   		fkind(fpline),fmsiz(fpline),fmini(fpline),
     1                  fmaxi(fpline),
     1   		fblink(fpline),fftyp(fpline),fpsiz,tkind(tpline),
     1                  tmsiz(tpline),
     1   		tmini(tpline),tmaxi(tpline),tblink(tpline),
     1                  tftyp(tpline),tpsiz,
     1   		wkind(wpline),wmsiz(wpline),wmini(wpline),
     1                  wmaxi(wpline),
     1   		wblink(wpline),wftyp(wpline),wpsiz,
     1   		r1psiz,r2psiz,r3psiz,r4psiz,r5psiz,r6psiz,r7psiz,
     1   		r1mini(r1plin),r1maxi(r1plin),r2mini(r2plin),
     1   		r2maxi(r2plin),r3mini(r3plin),r3maxi(r3plin),
     1   		r4mini(r4plin),r4maxi(r4plin),r5mini(r5plin),
     1   		r5maxi(r5plin),r6mini(r6plin),r6maxi(r6plin),
     1			r7mini(r7plin),r7maxi(r7plin),
     1   		r1kind(r1plin),r1msiz(r1plin),r2kind(r2plin),
     1   		r2msiz(r2plin),r3kind(r3plin),r3msiz(r3plin),
     1   		r4kind(r4plin),r4msiz(r4plin),r5kind(r5plin),
     1   		r5msiz(r5plin),r6kind(r6plin),r6msiz(r6plin),
     1			r7kind(r7plin),r7msiz(r7plin),
     1   		r1blnk(r1plin),r2blnk(r2plin),r3blnk(r3plin),
     1   		r4blnk(r4plin),r5blnk(r5plin),r6blnk(r6plin),
     1			r7blnk(r7plin),
     1   		r1ftyp(r1plin),r2ftyp(r2plin),r3ftyp(r3plin),
     1   		r4ftyp(r4plin),r5ftyp(r5plin),r6ftyp(r6plin),
     1			r7ftyp(r7plin)
	integer
     1   		gtop,gmarg,glx,gcx,ftop,fmarg,
     1   		flx,fcx,ttop,tmarg,tlx,tcx,wtop,
     1   		wmarg,wlx,wcx,r1top,r1marg,r1lx,r1cx,
     1   		r2top,r2marg,r2lx,r2cx,r3top,
     1   		r3marg,r3lx,r3cx,r4top,r4marg,r4lx,r4cx,
     1   		r5top,r5marg,r5lx,r5cx,r6top,r7top,
     1   		r6marg,r6lx,r6cx,r7marg,r7lx,r7cx,
     1   		gused,fused,tused,wused,r1used,r2used,r3used,
     1                  r4used,r5used,r6used,r7used,
     1   		gstat,fstat,tstat,wstat,r1stat,r2stat,r3stat,
     1                  r4stat,r5stat,r6stat,r7stat,
     1   		r1wid,r2wid,r3wid,r4wid,r5wid,r6wid,r7wid
	integer
     1   		k,kk,f,b,valmax,ferr,f1siz,f2siz,form
	character*20
     1   		f1msg,f2msg
	integer
     1   		screen,edtlin
	real
     1   		wuser
c
	logical
     1   		dokill,doinsert,inuse,fexist,dolinks
	integer
     1   		lim1,lim2,lim3,ilow,iltmp,iupp,iutmp,idef,
     1                  ideci,rest,rec,irec,b3,
     1                  pos1,pos2,mnelin,width,ttwid,tmplf,tmplk,
     1                  totlen,xtotl,myxusr,nf,nfmax,mynfmx,nbad,fsz,
     1			chn,ix,xtype,df,dal
	double precision
     1   		rlow,rltmp,rupp,rutmp,rdef
	character*1
     1   		bell,yn
	character*9
     1   		obname,			!previous data base name
     1			ownname			!owner base name if prop.
	character*1
     1   		fmnem1*(cm$l1),		!field mnemonic (scratch)
     1   		fmnem2*(cm$l1)		!  "      "         "
	character*40
     1   		fspec			!file spec
	character*30
     1   		ltxt,			!lower bound
     1   		utxt			!upper bound
c
	character*4	rempty/'    '/		!used for defaults
	character*8	r8empty/'        '/	!...
c
c	Unused ...
c
	integer gxpos,gypos,fxpos,fypos,txpos,typos,wxpos,wypos,term
c
	integer ismallone,ibigone
	real smallone,bigone
	equivalence (ibigone,bigone)
	equivalence (ismallone,smallone)
c
	external istrip_,tty_putc_,tty_getc_,tty_echo_,strchl_
	integer istrip_,tty_getc_,tty_echo_,ttychr,ttypad
c
c	begin
c	=====
c
	call errclr_('STREDT')			!clear errors
	erro=0
c
	if (us$bat) goto 90015		!batch user, can't use the editor
c
	smallone=rlowest		!lowest real value
	bigone=rhigher			!and higher
c
	wuser=0.0				!EDTMSG: don't wait
c
	if (prop.gt.0) then		!property
	   gpl=2
	else
	   gpl=gpline
	endif
c
	if (.not.new) then		!*** OLD data base structure
	   if (base.le.0.or.
     1         base.gt.d$b) goto 90012		!base channel not valid or
	   if (istrip_(strname).le.0) goto 90012	!data base name empty
	else
	   if (.not.edit) goto 90014		!display NEW structure ???
	endif
c
c	Aliens/links
c
	dal=0
	dolinks=.false.
	if (prop.gt.0) then
	   if (.not.new) then
	      d$nfld(prop)=d$nfld(prop)-3	!pointers out
	   endif
	   dolinks=.true.			!don't forget links anyway
	else
	   if (.not.new) then
	      df=0
	      do k = 1, d$nfld(base)		!save aliens aside, if any
	         xtype=d$type(k,base)
	         if (xtype.le.ftusr$) then
	            df=k
	         else
	            dal=dal+1
	            tmpmne(dal)=d$fmne(k,base)
	            tmptyp(dal)=xtype
	         endif
	      enddo
	      d$nfld(base)=df		!forget aliens for the moment ...
	   endif
	endif
c
c	Miscellaneous
c	-------------
c
	bell=char(7)
c
c	Clean screen DATA area
c	----------------------
c
	fspec(1:)=' '				!data base file spec
	chn=0					!i/o channel (data base file)
	obname(1:)=' '				!previous data base name
	do 1001 k = 1, gpl
	   gpage(k)(1:)=' '			!G page
1001	continue
	do 1002 k = 1, fpline
	   fpage(k)(1:)=' '			!F page
1002	continue
c
c	Initialize editor
c	-----------------
c
	if (inidon) goto 50			!already done
c
	inidon=.true.
c
c	initialize editor characteristics
c
c	already done by DBAG main program (call i$init...)
c
c	message lines
c
	edtlin=24				!VEDITS_ messages at the bottom
c
	dohlp=.false.				!tell editor not to do help
	fdohlp=.true.				!except for F* screen (bug...)
c
c	initialize "text" for all screens, except field types (edit/noedit)
c
c	field list (F*)
c
	write (f1msg,108)			!Mnemonic:
	f1siz=istrip_(f1msg)				!mssg size
c
	write (f2msg,109)			!Description:
	f2siz=istrip_(f2msg)				!mssg size
c
	fmarg=-1				!margin
	fsz=2					!field # + mnemonic
c
	f=0
	do 1003 k = 1, fpline, fsz
	   fmssg(k)(1:)=' '			!mnemonic line
	   fmssg(k)=f1msg
	   f=f+1				!insert field number
	   write (fmssg(k)(7:9),fmt='(i3.3)',err=90004) f
	   fmsiz(k)=f1siz			!mssg size
	   fpics(k)=cm$l1			!field size
	   fmssg(k+1)(1:)=' '			!description line
	   fmssg(k+1)=f2msg
	   fmsiz(k+1)=f2siz			!mssg size
	   fpics(k+1)=cm$l2			!field size
1003	continue
c
c	field type, [KEY y/n] and [MANDATORY y/n] (T*)
c
	write (tmssg(1),113)			!Type:
	tmsiz(1)=istrip_(tmssg(1))			!mssg size
	tpics(1)=2					!field size
c
	write (tmssg(2),1141)			!KEY (y/n)
	tmsiz(2)=istrip_(tmssg(2))			!mssg size
	tpics(2)=1					!field size
c
	write (tmssg(3),1142)			!MANDATORY (y/n)
	tmsiz(3)=istrip_(tmssg(3))			!mssg size
	tpics(3)=1					!field size
c
	tstt=13					!editor first line
	tsize=15				!and last
	tsmax=tsize
	tmarg=-1				!margin
	tpsiz=tpline				!page size
c
c	field width, dec. places (W*)
c
	write (wmssg(1),115)			!Width:
	wmsiz(1)=istrip_(wmssg(1))			!mssg size
	wpics(1)=3					!field size
c
	write (wmssg(2),116)			!decimal places:
	wmsiz(2)=istrip_(wmssg(2))			!mssg size
	wpics(2)=2				!decimal places size
c
	wstt=16					!editor first line
	wsize=17				!and last
	wsmax=wsize
	wmarg=-1				!margin
	wpsiz=wpline				!page size
c
c	field remaining data (R*)
c
c	R1*	type 1 - integer
c
	write (r1mssg(1),1171)			!lower bound:
	r1msiz(1)=istrip_(r1mssg(1))			!mssg size
c
	write (r1mssg(2),1181)			!upper bound:
	r1msiz(2)=istrip_(r1mssg(2))			!mssg size
c
	write (r1mssg(3),1191)			!default value:
	r1msiz(3)=istrip_(r1mssg(3))			!mssg size
c
	r1stt=18				!editor first line
	r1size=20				!and last
	r1smax=r1size
	r1marg=-1				!margin
	r1psiz=r1plin				!page size
c
c	r2*	type 2 - string
c
	r2stt=18				!editor first line
	r2size=21				!and last
	r2smax=r2size
	r2marg=-1				!margin
	r2psiz=r2plin				!page size
c
c	r3*	type 3 - other data base
c
	write (r3mssg(1),1173)			!other db name:
	r3msiz(1)=istrip_(r3mssg(1))			!mssg size
	r3pics(1)=9					!field size
c
	write (r3mssg(2),1183)			!other db master field
	r3msiz(2)=istrip_(r3mssg(2))			!mssg size
	r3pics(2)=10					!field size
c
	write (r3mssg(3),1193)			!other db field to see
	r3msiz(3)=istrip_(r3mssg(3))			!mssg size
	r3pics(3)=10					!field size
c
	r3stt=18				!editor first line
	r3size=20				!and last
	r3smax=r3size
	r3marg=-1				!margin
	r3psiz=r3plin				!page size
c
c	R4*	type 4 - decimal
c
c
	write (r4mssg(1),1174)			!lower bound:
	r4msiz(1)=istrip_(r4mssg(1))			!mssg size
c
	write (r4mssg(2),1184)			!upper bound:
	r4msiz(2)=istrip_(r4mssg(2))			!mssg size
c
	write (r4mssg(3),1194)			!default value:
	r4msiz(3)=istrip_(r4mssg(3))			!mssg size
c
	r4stt=18				!editor first line
	r4size=20				!and last
	r4smax=r4size
	r4marg=-1				!margin
	r4psiz=r4plin				!page size
c
c	R5*	type 5 - date
c
	write (r5mssg(1),1175)			!lower bound:
	r5msiz(1)=istrip_(r5mssg(1))			!mssg size
	r5pics(1)=11					!field size
	r5mini(1)=18900101				!minimum (1/jan/1890)
	r5maxi(1)=30001231				!maximum (31/dez/3000)
c
	write (r5mssg(2),1185)			!upper bound:
	r5msiz(2)=istrip_(r5mssg(2))			!mssg size
	r5pics(2)=11					!field size
	r5mini(2)=18900101				!minimum (1/jan/1890)
	r5maxi(2)=30001231				!maximum (31/dez/3000)
c
	write (r5mssg(3),1195)			!default value:
	r5msiz(3)=istrip_(r5mssg(3))			!mssg size
	r5pics(3)=11					!field size
	r5mini(3)=18900101				!minimum (1/jan/1890)
	r5maxi(3)=30001231				!maximum (31/dez/3000)
c
	r5stt=18				!editor first line
	r5size=20				!and last
	r5smax=r5size
	r5marg=-1				!margin
	r5psiz=r5plin				!page size
c
c	R6*	type 6 - logical
c
	write (r6mssg(1),1176)			!default value:
	r6msiz(1)=istrip_(r6mssg(1))			!mssg size
	r6pics(1)=1					!field size
c
	r6stt=18				!editor first line
	r6size=18				!and last
	r6smax=r6size
	r6marg=-1				!margin
	r6psiz=r6plin				!page size
c
c	R7*	type 7 - real
c
	write (r7mssg(1),1175)			!lower bound:
	r7msiz(1)=istrip_(r7mssg(1))			!mssg size
	r7pics(1)=15					!field size
	r7mini(1)=ismallone				!minimum
	r7maxi(1)=ibigone				!maximum
c
	write (r7mssg(2),1185)			!upper bound:
	r7msiz(2)=istrip_(r7mssg(2))			!mssg size
	r7pics(2)=15					!field size
	r7mini(2)=ismallone				!minimum
	r7maxi(2)=ibigone				!maximum
c
	write (r7mssg(3),1195)			!default value:
	r7msiz(3)=istrip_(r7mssg(3))			!mssg size
	r7pics(3)=15					!field size
	r7mini(3)=ismallone				!minimum
	r7maxi(3)=ibigone				!maximum
c
	r7stt=18				!editor first line
	r7size=20				!and last
	r7smax=r7size
	r7marg=-1				!margin
	r7psiz=r7plin				!page size
c
50	continue				!end of initialization block
c
c	(Re)initialization (on each call to STREDT)
c	===========================================
c
	hlpon=.false.				!no help in progress
c
c	initialize "text" for G* screen
c
c	general data base info (G*)
c
	if (prop.gt.0) then			!property
c
	   write (gmssg(1),104)			!data base designation:
	   gmsiz(1)=istrip_(gmssg(1))			!mssg size
	   gpics(1)=ro$l3				!field size
c
	   write (gmssg(2),107)			!cripted ? (y/n)
	   gmsiz(2)=istrip_(gmssg(2))			!mssg size
	   gpics(2)=2					!field size
c
	   gstt=4				!editor first line
	   gsize=gstt+gpl-1			!and last (static)
	   gsmax=gsize
	   gmarg=-1				!margin
	   gpsiz=gpl				!page size (static)
c
	else					!regular base
	   write (gmssg(1),103)			!data base name:
	   gmsiz(1)=istrip_(gmssg(1))			!mssg size
	   gpics(1)=9					!field size
c
	   write (gmssg(2),104)			!data base designation:
	   gmsiz(2)=istrip_(gmssg(2))			!mssg size
	   gpics(2)=ro$l3				!field size
c
	   write (gmssg(3),105)			!first record#:
	   gmsiz(3)=istrip_(gmssg(3))			!mssg size
	   gpics(3)=10					!field size
	   gmini(3)=1					!minimum
	   gmaxi(3)=intmax				!maximum
c
	   write (gmssg(4),107)			!cripted ? (y/n)
	   gmsiz(4)=istrip_(gmssg(4))			!mssg size
	   gpics(4)=2					!field size
c
	   write (gmssg(5),1071)		!killed not frozen ? (y/n)
	   gmsiz(5)=istrip_(gmssg(5))			!mssg size
	   gpics(5)=2					!field size
c
	   gstt=3				!editor first line
	   gsize=gstt+gpl-1			!and last (static)
	   gsmax=gsize
	   gmarg=-1				!margin
	   gpsiz=gpl				!page size (static)
	endif
c
c	Maximum F* page size and total record size
c	--------------------
c
	if (prop.gt.0) then
	   fpsiz=fpline-(fsz*3)			!property, room for links
	   myxusr=x$usr-3*10			!same
	else
	   fpsiz=fpline
	   myxusr=x$usr
	endif
c
c	Set default values
c	------------------
c
	if (prop.gt.0) then				!property
	   yn='n'
	   write (gpage(2),fmt='(a)',err=90004) yn	!CRIPTED ?
	else						!regular base
	   yn='n'
	   write (gpage(4),fmt='(a)',err=90004) yn	!CRIPTED ?
	   yn='y'
	   write (gpage(5),fmt='(a)',err=90004) yn	!KILLED AVAILABLE ?
	endif
c
	yn='n'
	write (tpage(2),fmt='(a)',err=90004) yn	!KEY ?
	yn=' '
	write (tpage(3),fmt='(a)',err=90004) yn	!MANDATORY ?
c
c	Permanent lines
c	---------------
c
c	'what' message
c
	if (prop.gt.0) then			!property
	   lim1=istrip_(strname)
	   if (lim1.le.0) lim1=1
	   ownname=d$ownb(prop)
	   lim2=istrip_(ownname)
	   if (lim2.le.0) lim2=1
	   if (edit) then
	      if (new) then
	         write (whtmsg,10210)		!creating new prop. struc.
     1           strname(1:lim1),ownname(1:lim2)
	      else				!modifying old prop. struc.
	         if (full) then
	            write (whtmsg,10221)	!full
     1              strname(1:lim1),ownname(1:lim2)
	         else
	            write (whtmsg,10222)	!not full
     1              strname(1:lim1),ownname(1:lim2)
	         endif
	      endif
	   else
	      write (whtmsg,10230)		!displaying prop. struc.
     1        strname(1:lim1),ownname(1:lim2)
	   endif
	else					!regular base
	   if (edit) then
	      if (new) then
	         write (whtmsg,10110)		!creating new data base struc.
	      else				!modifying old data base struc.
	         if (full) then
	            write (whtmsg,10121)	!full
	         else
	            write (whtmsg,10122)	!not full
	         endif
	      endif
	   else
	      write (whtmsg,10130)		!displaying data base struc.
	   endif
	endif
c
	call vtext_(whtmsg,1,1,2)		!line 1
c
	nfmax=d$f
	call stridf_(dfbuf,nfmax,erro)		!init working space for def.val.
	if (erro.ne.0) goto 990			!error, carry
c
	if (prop.gt.0) then			!property
	   bcur=prop				!current property
	   if (.not.new) then			!*** OLD
	      nfmax=0
	      do k = 1, d$nfld(bcur)		!user fields only
	         if (d$type(k,bcur).gt.ftusr$) then
	            goto 123			!no more
	         endif
	         nfmax=k
	      enddo
123	      continue
	   endif
	else					!regular base
	   if (.not.new) then			!*** OLD
	      bcur=base				!current base
	      nfmax=0
	      do k = 1, d$nfld(bcur)		!user fields only
	         if (d$type(k,bcur).gt.ftusr$) then
	            goto 234			!no more
	         endif
	         nfmax=k
	      enddo
234	      continue
	   else
	      bcur=0				!no current base
	   endif
	endif
c
	if (prop.le.0) then			!regular base
	   gpage(1)(1:)=' '
	   gpage(1)=strname			!data base name
	endif
c
c	NEW/OLD structure
c	=================
c
c	Global characteristics
c	----------------------
c
c	Set field type/blink/cursor (assume *** FULL structure editing)
c	---------------------------------------------------------------
c
c					!G screen
	if (prop.gt.0) then			!property
	   gkind(1)=113				!description
	   gftyp(1)=vfrw$			!		read/write
	   gblink(1)=vedbli
	   gkind(2)=124				!data base cripted
	   gftyp(2)=vfrw$			!		read/write
	   gblink(2)=vedbli
	   glx=1				!cursor start line
	   gcx=1				!cursor start column
	else					!regular base
	   gkind(1)=112				!data base name type
	   gftyp(1)=vfrw$			!		read/write
	   gblink(1)=vedbli			!               blink
	   gkind(2)=113				!description
	   gftyp(2)=vfrw$			!		read/write
	   gblink(2)=vedbli
	   gkind(3)=121				!first record#
	   gftyp(3)=vfrw$			!		read/write
	   gblink(3)=vedbli
	   gkind(4)=124				!data base cripted
	   gftyp(4)=vfrw$			!		read/write
	   gblink(4)=vedbli
	   gkind(5)=125				!killed list available ?
	   gftyp(5)=vfrw$			!		read/write
	   gblink(5)=vedbli
	   glx=1				!cursor start line
	   gcx=1				!cursor start column
	endif
c
	if (nfmax.le.0) goto 456		!no user field, skip this
c					!F screen
	do 1004 k = 1, fpsiz, fsz
	   fkind(k)=114				!mnemonic type
	   fftyp(k)=vfrw$			!read/write
	   fblink(k)=vedbli			!blink
	   fkind(k+1)=117			!description type
	   fftyp(k+1)=vfrw$			!read/write
	   fblink(k+1)=vedbli			!blink
1004	continue
	flx=1					!cursor start line
	fcx=1					!cursor start column
c					!T screen
	tkind(1)=115				!field type
	tftyp(1)=vfrw$				!		read/write
	tblink(1)=vedbli
	tkind(2)=119				!key ?
	tftyp(2)=vfrw$				!		read/write
	tblink(2)=vedbli
	tkind(3)=123				!mandatory ?
	tftyp(3)=vfrw$				!		read/write
	tblink(3)=vedbli
	tlx=1					!cursor start line
	tcx=1					!cursor start column
c					!W screen
	wkind(1)=116				!field type
	wftyp(1)=vfrw$				!		read/write
	wblink(1)=vedbli
	wkind(2)=118				!decimal places
	wftyp(2)=vfrw$				!		read/write
	wblink(2)=vedbli
	wlx=1					!cursor start line
	wcx=1					!cursor start column
c					!R1 screen (integer)
	r1kind(1)=101				!lower
	r1ftyp(1)=vfrw$				!		read/write
	r1blnk(1)=vedbli
	r1kind(2)=101				!upper
	r1ftyp(2)=vfrw$				!		read/write
	r1blnk(2)=vedbli
	r1kind(3)=101				!default
	r1ftyp(3)=vfrw$				!		read/write
	r1blnk(3)=vedbli
	r1lx=1					!cursor start line
	r2cx=1					!cursor start column
c					!R2 screen (string) is special
c
c					!R3 screen (other data base)
	r3kind(1)=120				!o.d.b name
	r3ftyp(1)=vfrw$				!		read/write
	r3blnk(1)=vedbli
	r3kind(2)=126				!o.d.b. master field
	r3ftyp(2)=vfrw$				!		read/write
	r3blnk(2)=vedbli
	r3kind(3)=127				!o.d.b. field to see
	r3ftyp(3)=vfrw$				!		read/write
	r3blnk(3)=vedbli
	r3lx=1					!cursor start line
	r3cx=1					!cursor start column
c					!R4 screen (decimal)
	r4kind(1)=104				!lower
	r4ftyp(1)=vfrw$				!		read/write
	r4blnk(1)=vedbli
	r4kind(2)=104				!upper
	r4ftyp(2)=vfrw$				!		read/write
	r4blnk(2)=vedbli
	r4kind(3)=104				!default
	r4ftyp(3)=vfrw$				!		read/write
	r4blnk(3)=vedbli
	r4lx=1					!cursor start line
	r4cx=1					!cursor start column
c					!R5 screen (date)
	r5kind(1)=105				!lower
	r5ftyp(1)=vfrw$				!		read/write
	r5blnk(1)=vedbli
	r5kind(2)=105				!upper
	r5ftyp(2)=vfrw$				!		read/write
	r5blnk(2)=vedbli
	r5kind(3)=105				!default
	r5ftyp(3)=vfrw$				!		read/write
	r5blnk(3)=vedbli
	r5lx=1					!cursor start line
	r5cx=1					!cursor start column
c					!R6 screen (logical)
	r6kind(1)=106				!default
	r6ftyp(1)=vfrw$				!		read/write
	r6blnk(1)=vedbli
	r6lx=1					!cursor start line
	r6cx=1					!cursor start column
c					!R7 screen (real)
	r7kind(1)=107				!default
	r7ftyp(1)=vfrw$				!		read/write
	r7blnk(1)=vedbli
	r7kind(2)=107				!upper
	r7ftyp(2)=vfrw$				!		read/write
	r7blnk(2)=vedbli
	r7kind(3)=107				!default
	r7ftyp(3)=vfrw$				!		read/write
	r7blnk(3)=vedbli
	r7lx=1					!cursor start line
	r7cx=1					!cursor start column
c
456	continue
c
c	If property, fields can't be KEY, don't allow editing
c	-----------------------------------------------------
c
	if (prop.gt.0) then
	   tftyp(2)=vfr$		!KEY ? (read only)
	endif
c
	if (.not.new) then		!*** OLD data base structure
c
c	   set screen data
c	   ---------------
c
	   if (prop.gt.0) then			!property
	      gpage(1)(1:)=' '			!description
	      gpage(1)=d$bdes(bcur)		!...
c
	      if (d$crpt(bcur).eq.0) then
	         gpage(2)(1:1)='y'		!cripted
	      else
	         gpage(2)(1:1)='n'
	      endif
	   else					!regular base
	      gpage(1)(1:)=' '			!data base name
	      gpage(1)=strname			!...
	      gpage(2)(1:)=' '			!description
	      gpage(2)=d$bdes(bcur)		!...
	      irec=d$unus - d$offs(bcur) + 1	!first record#
	      rec=irec
	      call wrivar_(gpage(3),rec,gpics(3),erro)
	      if (erro.ne.0) goto 90004		!write error
	      if (d$crpt(bcur).eq.0) then
	         gpage(4)(1:1)='y'		!cripted
	      else
	         gpage(4)(1:1)='n'
	      endif
	      if (d$froz(bcur).eq.0) then
	         gpage(5)(1:1)='y'		!available
	      else
	         gpage(5)(1:1)='n'		!frozen
	      endif
	   endif
c
c	   don't allow editing of data base name;
c	   fix fields if *** NOT FULL ediditng (ftype=vfrw$, blink=0)
c	   ----------------------------------------------------------
c
c					!G screen
	   if (edit) then
	      if (prop.gt.0) then		!property
c	         ok
	      else				!regular base
	         gftyp(1)=vfr$			!data base name type (read only)
	         gblink(1)=0
	      endif
	   endif
c
	   if (edit.and.
     1         .not.full) then		!*** NOT FULL EDITING
c
c					!G screen
	      if (prop.gt.0) then		!property
	         gftyp(2)=vfr$			!(read only)
	         gblink(2)=0
	      else				!regular base
	         gftyp(3)=vfr$			!(read only)
	         gblink(3)=0
	         gftyp(4)=vfr$			!(read only)
	         gblink(4)=0
	      endif
c
	      if (nfmax.le.0) goto 567	!no user fields, skip this
c
c					!F screen
	      kk=fsz*nfmax+1			!don't allow new fields
	      do 1005 k = kk, fpsiz, fsz
	         fftyp(k)=vfr$			!(read only)
	         fblink(k)=0			!blink
	         fftyp(k+1)=vfr$			!(read only)
	         fblink(k+1)=0			!blink
1005	      continue
c					!T screen
	      tftyp(1)=vfr$			!(read only)
	      tblink(1)=0
	      tftyp(2)=vfr$			!(read only)
	      tblink(2)=0
	      tftyp(3)=vfr$			!(read only)
	      tblink(3)=0
c					!W screen
	      wftyp(1)=vfr$			!(read only)
	      wblink(1)=0
	      wftyp(2)=vfr$			!(read only)
	      wblink(2)=0
c					!R1 screen (integer)
c					!R2 screen (string) is special
c
c					!R3 screen (other data base)
	      r3ftyp(1)=vfr$			!(read only)
	      r3blnk(1)=0
c					!R4 screen (decimal)
c
c					!R5 screen (date)
c
c					!R6 screen (logical)
c
567	   continue
c
	   endif
c
	endif
c
c	Field characteristics if any
c	----------------------------
c
	if (nfmax.le.0) goto 678		!no user field, skip this
c
	pos2=1
	do 1006 k = 1, nfmax
	   if (new) then			!*** NEW data base structure
c
	      fsta(k)=0				!no field defined yet
	      fmin(k)=0				!no min.
	      fmax(k)=0				!no max.
c
	   else					!*** OLD data base structure
c
	      fsta(k)=2				!flag all fields defined
c
	      tmplk=(k-1)*2+1			!field mnemonic line
	      fpage(tmplk)(1:)=' '		!field mnemonic
	      fpage(tmplk)=d$fmne(k,bcur)	!...
	      fpage(tmplk+1)(1:)=' '		!description
	      fpage(tmplk+1)=d$fdes(k,bcur)	!...
	      width=d$siz(k,bcur)
	      pos1=pos2+1			!def. val. start pos
	      pos2=pos1+width-1			!end pos
	      if     (d$type(k,bcur).eq.r$) then
	         if (d$dflt(bcur)(pos1:pos2).eq.rnulltxt) then	!no default
	            call strpdf_(dfbuf,k,rempty,width,erro)
	         else
	            call strpdf_(dfbuf,k,
     1                   d$dflt(bcur)(pos1:pos2),width,erro)!store default
	         endif
	      elseif (d$type(k,bcur).eq.r8$) then	!no default at all
	         call strpdf_(dfbuf,k,r8empty,width,erro)
	      else
	         call strpdf_(dfbuf,k,
     1                d$dflt(bcur)(pos1:pos2),width,erro)!store default
	      endif
	      if (erro.ne.0) goto 90013		!can't get def. val.
	      if (d$type(k,bcur).eq.n$.or.
     1            d$type(k,bcur).eq.db$.or.
     1            d$type(k,bcur).eq.x$.or.
     1            d$type(k,bcur).eq.d$.or.
     1            d$type(k,bcur).eq.r$     ) then
	         fmin(k)=1			!min. defined
	         fmax(k)=1			!and max.
	      else
	         fmin(k)=0
	         fmax(k)=0
	      endif
	   endif
1006	continue
c
	do 1007 k = nfmax+1, d$b		!clean remaining fields anyway
	   fsta(k)=0				!no field defined yet
	   fmin(k)=0				!no min.
	   fmax(k)=0				!no max.
1007	continue
c
	do 1008 k = 1, r2plin
	   r2pics(k)=1				!special case for strings
1008	continue
c
678	continue
c
	if (edit) then
	   goto 90				!go EDIT data base structure
	else
	   goto 800				!go DISPLAY data base structure
	endif
c
c	>>>>>> EDIT (CREATE/MODIFY) DATA BASE STRUCTURE
c	===============================================
c
90	continue
c
c	Clean screen
c	------------
c
	call erase_page_(2,1)		!clean screen from line 2...
c
c	Initialize data base structure edit main loop
c	---------------------------------------------
c
	gmode=4					!edit mode = 4
	gtop=-1					!first line of page to show
c
c	Allow user to open new lines if creating a NEW data base structure
c
	if (nfmax.le.0) goto 789		!no user fields, skip this
c
	if (edit.and.full) then
	   fmode=9				!NEW LINE anywhere and if
						!DOWN-ARROW at the bottom
	   fused=2
	else
	   fmode=7				!exit if <ret> anywhere
	   fused=fsz*nfmax			!only # of base fields
	endif
c
	ftop=-1
c
	flx=1					!make sure F* screen starts at 1
	fcx=1					!force col=1 (bug in editor...)
c
	tmode=4
	ttop=-1
c
	wmode=4
	wtop=-1
c
	r1mode=4
	r1top=-1
c
	r2mode=4
	r2top=-1
c
	r3mode=4
	r3top=-1
c
	r4mode=4
	r4top=-1
c
	r5mode=4
	r5top=-1
c
	r6mode=4
	r6top=-1
c
	r7mode=4
	r7top=-1
c
c
789	continue
c
	screen=1				!begin at first screen...
	fcur=0					!no current field#
	tcur=0					!and type
	wcur=0					!no current width
	dcur=0					!no current decimal places
c
c	Structure editing main loop here
c	================================
c
99	continue
c
	goto (100,200,300,400,500) screen
c
	goto 90002				!???unknown screen?
c
c
c	Screen #1: G	general base info (name, desig., 1rst rec#, chk.dig)
c	==========
c
100	continue
c
	if (gmode.ne.5) then			!if screen rewriting
	   glx=1				!(G) cursor start line
	   gcx=1				!    cursor start column
	endif
c
	gcx=1					!force col=1 (bug in editor...)
c
	gused=gpl				!total lines
c
	dokill=.false.				!no ^Z KILL
	doinsert=.false.			!no ^Z INSERT
	call vedits_(strchl_,gmode,gstt,gsize,gtop,gmarg,glx,gcx,gmssg,
     1   	    gmsiz,gpage,gpsiz,gused,gmini,gmaxi,gpics,gkind,
     1   	    term,gxpos,gypos,gblink,edtlin,dohlp,ghlp,gsmax,
     1              gstat,gftyp,dokill,doinsert,erro)
	if (erro.ne.0) goto 990			!error, carry
c
c	G screen processing
c	-------------------
c
	if (gstat.eq.quit) goto 900			!***^Z QUIT (quit now)
c
	if (gstat.eq.help) then				!***HELP or GOLD/HELP
	   hlpon=.true.					!help in progress
	   call strhlp_(gkind(glx),edtlin,1,wuser)
	   goto 190
	else
	   hlpon=.false.
	endif
c
	if     (gstat.eq.up.or.
     1          gstat.eq.g_up    ) then
c	   nops					!***UP or G_UP, previous screen
	elseif (gstat.gt.0.or.
     1          gstat.eq.ret.or.
     1          gstat.eq.down.or.
     1          gstat.eq.g_down  ) then
	   					!***^Z EXIT,<ret>,DOWN or G_DOWN
c
c	   check data base name and ask for base channel if *** NEW base
c
	   if (prop.gt.0) then			!property
c	      ok
	   else					!regular base
	      if (new) then
	         lim1=istrip_(gpage(1))
	         if (lim1.le.0) goto 130	!no base specified
	         strname(1:)=' '
	         strname(1:lim1)=gpage(1)(1:lim1)!current base name
	         call uc_(strname)		!upper case it
	         lim2=istrip_(obname)		!and previous base name
	         if (lim1.eq.lim2.and.
     1               strname(1:lim1).eq.
     1               obname(1:lim2)   ) then
c	            ok
	         else
	            fspec(1:)=' '
	            fspec(1:)=strname(1:)	!built fspec (root file)
	            call newbas_(b3,fspec,inuse)!check if in memory
	            if (inuse) goto 110		!database already exists
	            if (bcur.le.0) then
	               bcur=b3			!save my own channel only once
	               d$dflt(bcur)(1:)=' '	!clear defaults only here!
	            else
	               call frebas_(b3)		!free it, was just to check...
	            endif
	            call givext_(fspec,'.roo')
	            call newc_(chn)		!ask for i/o channel
	            if (chn.le.0) goto 120	!no free i/o channel
	            inquire (file=fspec,exist=fexist)
	            call freec_(chn)		!give i/o channel back
	            if (fexist) goto 110	!database already exists
	            obname(1:)=' '		!save it
	            obname(1:)=strname(1:)	!...
	         endif
	      endif
	      if (istrip_(gpage(3)).le.0) then
	         rec=1				!default first record# = 1
	         irec=rec
	         call wrivar_(gpage(3),rec,gpics(3),erro)
	         if (erro.ne.0) goto 90004	!write error
	         gmode=4			!force rewrite G screen
	      else
	         call rdivar_(gpage(3),rec,gpics(3),erro)
	         if (erro.ne.0) goto 90004	!read error
	      endif
	   endif
c
	   if (gstat.gt.0) goto 750		!***^Z EXIT (exit now)
	   screen=screen+1			!next screen
	else
	   goto 90003				!unknown code from VEDITS
	endif
c
	goto 190				!exit screen
c
c	G screen warnings
c	-----------------
c
c	data base already exists
110	continue
c
	write (mssg(1:),11099)			!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 190				!exit screen
c
c	no more i/o channels
120	continue
c
	write (mssg(1:),12099)			!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 190				!exit screen
c
c	no data base specified
130	continue
c
	write (mssg(1:),13099)			!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 190				!exit screen
c
c	wrong check digit in first record#
140	continue
c
	write (mssg(1:),14099)			!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 190				!exit screen
c
c	G screen exit
c	-------------
c
190	continue
c
	gmode=5					!next calls in mode 5
c
	if (nfmax.le.0.and.
	1   .not.full      ) then
	   call tty_putc_(bell)			!ring
	   write (mssg,1230,err=90004)		!no regular field,^ZEXIT to exit
	   call vtext_(mssg(1:istrip_(mssg)),edtlin,1,2)
	   screen=1				!stay here
	   goto 99
	endif
c
	goto 700				!common "case" base
c
c
c	Screen #2: F	field list (mnemonic, description)
c	==========
c
200	continue
c
	fstt=9					!editor first line
	if (edit.and.full) then
	   fsize=fstt+fused-1			!and last
						!NEW LINE anywhere and if
						!DOWN-ARROW at the bottom
	   fsmax=22
	else
	   fsize=22				!and last
	   fsmax=fsize
	endif
c
	dokill=.false.				!no ^Z KILL
	doinsert=.false.			!no ^Z INSERT
	call vedits_(strchl_,fmode,fstt,fsize,ftop,fmarg,flx,fcx,fmssg,
     1   	    fmsiz,fpage,fpsiz,fused,fmini,fmaxi,fpics,fkind,
     1   	    term,xpos,ypos,fblink,edtlin,fdohlp,fhlp,fsmax,
     1              fstat,fftyp,dokill,doinsert,erro)
	if (erro.ne.0) goto 990			!error, carry
c
c	F screen processing
c	-------------------
c
	if     (fstat.eq.quit) goto 900			!***^Z QUIT (quit now)
c
	if (fstat.eq.help) then				!***HELP or GOLD/HELP
	   hlpon=.true.					!help in progress
	   call strhlp_(fkind(flx),edtlin,1,wuser)
	   if (edit.and.full) then
	      fmode=10				!don't re-display screen
	   else
	      fmode=8				!don't re-display screen
	   endif
	   goto 290
	else
	   hlpon=.false.
	   if (edit.and.full) then
	      fmode=9				!NEW LINE anywhere and if
						!DOWN-ARROW at the bottom
	   else
	      fmode=7				!exit if <ret> anywhere
	   endif
c
	endif
c
	fcur=flx/fsz				!current field#
	if (mod(flx,fsz).gt.0) fcur=fcur+1	!...
c
	if (fstat.eq.up.or.
     1      fstat.eq.g_up    ) then
						!***UP or G_UP, previous screen
c
	   if (fsta(fcur).eq.1) then		!field is'nt complete, warn
	      write (mssg(1:),1225)		!warning
	      write (mssg(istrip_(mssg)+1:),fmt='(i3)',err=90004) fcur!field#
	      call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	   endif
c
	   screen=screen-1
	   goto 290				!exit screen
	endif
c
	call strfsc_(screen,erro)		!save field in memory context
	if (erro.ne.0) goto 990			!error, carry
c
	if     (fstat.gt.0.or.
     1          fstat.eq.ret.or.
     1          fstat.eq.down.or.
     1          fstat.eq.g_down  ) then
	   					!***^Z EXIT,<ret>,DOWN or G_DOWN
c
	   if (fstat.gt.0) goto 750		!***^Z EXIT (exit now)
	else
	   goto 90003				!unknown code from VEDITS
	endif
c
	if     (fstat.eq.ret.or.
     1          fstat.eq.g_down ) then
						!<ret> or G_DOWN, field details
c
c	   Show witch field
c
	   mssg(1:)=' '
	   mnelin=fsz*(fcur-1)+1		!current mnemonic line#
c
	   mssg(2:)=fmssg(mnelin)		!message
	   lim1=fmsiz(mnelin)			!message size
	   mssg(lim1+1:lim1+1)=':'		! + :
	   mssg(lim1+2:)=fpage(mnelin)		! + mnemonic
	   call vtext_(mssg(1:80),9,1,0)	!mnemonic at line 9
c
	   mssg(2:)=fmssg(mnelin+1)		!message
	   lim1=fmsiz(mnelin+1)			!message size
	   mssg(lim1+1:lim1+1)=':'		! + :
	   mssg(lim1+2:)=fpage(mnelin+1)	! + description
	   call vtext_(mssg(1:80),10,1,0)	!description at line 10
c
	   call erase_page_(11,1)		!clean screen from line 11
c
	   ix=d$idx(fcur,bcur)
           if     (ix.le.0) then
	      write (fdtmsg,1110)		!field# message
	   elseif (ix.eq.1) then		!INDEX
	      write (fdtmsg,1111)
	   elseif (ix.eq.2) then		!KEY
	      write (fdtmsg,1112)
	   else	      
	      write (fdtmsg,1114)		!KWIC INDEX
	   endif
c
	   lim1=index(fdtmsg,'#')		!add field#
	   if (lim1.gt.0) then
	      lim1=lim1+2
	      write (fdtmsg(lim1:lim1+2),fmt='(i3.0)',err=90004) fcur
	   endif
	   call vtext_(fdtmsg,12,1,0)		!field# message at line 12
c
	   screen=screen+1			!next screen
c
	else
						!DOWN, end of F* screen
	   flx=1				!re-start at top of screen
	   fcx=1
c
	endif
c
	goto 290				!exit screen
c
c	F screen warnings
c	-----------------
c
c	F screen exit
c	-------------
c
290	continue
c
	goto 700				!common "case" base
c
c
c	Screen #3: T	field type (type)
c	==========
c
300	continue
c
	if (tmode.ne.5)  then			!if screen rewriting
	   tlx=1				!(T) cursor start line
	   tcx=1				!    cursor start column
	endif
c
	tcx=1					!force col=1 (bug in editor...)
c
	tused=tsize-tstt+1			!total lines
c
	dokill=.false.				!no ^Z KILL
	doinsert=.false.			!no ^Z INSERT
	call vedits_(strchl_,tmode,tstt,tsize,ttop,tmarg,tlx,tcx,tmssg,
     1   	    tmsiz,tpage,tpsiz,tused,tmini,tmaxi,tpics,tkind,
     1   	    term,xpos,ypos,tblink,edtlin,dohlp,thlp,tsmax,
     1              tstat,tftyp,dokill,doinsert,erro)
	if (erro.ne.0) goto 990			!error, carry
c
c	T screen processing
c	-------------------
c
	if (tstat.eq.quit) goto 900			!***^Z QUIT (quit now)
c
	if (tstat.eq.help) then				!***HELP or GOLD/HELP
	   hlpon=.true.					!help in progress
	   call strhlp_(tkind(tlx),edtlin,1,wuser)
	   tmode=5				!don't re-display screen
	   goto 390
	else
	   hlpon=.false.
	   tmode=4				!re-display screen (not HELP/GH)
	endif
c
	lim1=istrip_(tpage(1))
c
	if (lim1.le.0) then
	   tcur=0				!no type specified
	else
	   call chktyp_(tpage(1),tcur)		!(re)check field type, just to
						!set TCUR
	   if (tcur.gt.ftusr$) goto 90005	!no creatures here
	   if (tcur.le.0) goto 90005		!bad type (???)
	endif
c
	call strfsc_(screen,erro)		!save field in memory context
	if (erro.ne.0) goto 990			!error, carry
c
	call verase_(wstt,edtlin-1)		!erase screen down from here
c
	if     (tstat.eq.up.or.
     1          tstat.eq.g_up    ) then
	   					!***UP or G_UP, previous screen
	   screen=screen-1
c
	elseif (tstat.gt.0.or.
     1          tstat.eq.ret.or.
     1          tstat.eq.down.or.
     1          tstat.eq.g_down  ) then
	   					!***^Z EXIT,<ret>,DOWN or G_DOWN
c
	   if (tcur.le.0) then
	      if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	      goto 310				!no type, don't go down
	   endif
c
	   if (tpage(2)(1:1).eq.'y') then	!KEY,
	      if (tpage(3)(1:1).eq.'n') then	!should be mandatory
	         if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	         goto 320
	      endif
	      tpage(3)(1:1)='y'
	   endif
c
	   if (tcur.eq.n$.or.			!if integer,
     1         tcur.eq.c$.or.			!string
     1         tcur.eq.x$    ) then		!or decimal, next screen
c
	      if (tstat.gt.0) goto 750		!***^Z EXIT (exit now)
	      screen=screen+1			!next W screen
c
	   else					!skip next screen, so
c
	      if     (tcur.eq.db$) then		!fake W screen (db$)
	         wcur=10
	      elseif (tcur.eq.d$) then		!date
	         wcur=11
	      elseif (tcur.eq.r$) then		!real
	         wcur=15
	      elseif (tcur.eq.l$) then
	         wcur=1				!logical
	      else
	         wcur=10			!all creatures with size = 10
	      endif
	      call wrivar_(wpage(1),wcur,wpics(1),erro)
	      if (erro.ne.0) goto 90004		!write error
c
	      call strfsc_(screen+1,erro)	!save W field as well!!!!
	      if (erro.ne.0) goto 990		!error, carry
c
	      if (tstat.gt.0) goto 750		!***^Z EXIT (exit now)
c
	      screen=screen+2			!skip W screen (next R? screen)
	   endif
	else
	   goto 90003				!unknown code from VEDITS
	endif
c
	goto 390				!exit screen
c
c	T screen warnings
c	-----------------
c
c	no type specified
310	continue
c
	write (mssg(1:),31099)			!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 390				!exit screen
c
c	KEY field, should be mandatory
320	continue
c
	write (mssg(1:),32099)			!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 390				!exit screen
c
c	T screen exit
c	-------------
c
390	continue
c
	goto 700				!common "case" base
c
c
c	Screen #4: W	field width, dec. places (width)
c	==========
c
400	continue
c
	if (wmode.ne.5) then			!if rewriting screen
	   wlx=1				!(W) cursor start line
	   wcx=1				!    cursor start column
	endif
c
	wcx=1					!force col=1 (bug in editor...)
c
	if (tcur.eq.x$) then			!decimal
	   wused=wpline				!width + decimal pl.
	   wmini(1)=1				!minimum
	   wmaxi(1)=digmax			!and maximum for width
	   wmini(2)=1				!minimum
	   wmaxi(2)=digmax-1			!and maximum for dec. places
	else
	   wused=1				!alll others only WIDTH
	   if     (tcur.eq.n$) then
	      wmini(1)=1			!integer
	      wmaxi(1)=digmax
	   elseif (tcur.eq.c$) then
	      wmini(1)=1			!string
	      wmaxi(1)=x$fld
	   endif
	endif
c
	dokill=.false.				!no ^Z KILL
	doinsert=.false.			!no ^Z INSERT
	call vedits_(strchl_,wmode,wstt,wsize,wtop,wmarg,wlx,wcx,wmssg,
     1   	    wmsiz,wpage,wpsiz,wused,wmini,wmaxi,wpics,wkind,
     1   	    term,xpos,ypos,wblink,edtlin,dohlp,whlp,wsmax,
     1              wstat,wftyp,dokill,doinsert,erro)
	if (erro.ne.0) goto 990			!error, carry
c
c	W screen processing
c	-------------------
c
	if (wstat.eq.quit) goto 900			!***^Z QUIT (quit now)
c
	if (wstat.eq.help) then				!***HELP or GOLD/HELP
	   hlpon=.true.					!help in progress
	   call strhlp_(wkind(wlx),edtlin,1,wuser)
	   wmode=5				!don't re-display screen
	   goto 490
	else
	   hlpon=.false.
	   wmode=4				!re-display screen (not HELP/GH)
	endif
c
	if (istrip_(wpage(1)).le.0) then
	   wcur=0
	else
	   call rdivar_(wpage(1),wcur,wpics(1),erro)
	   if (erro.ne.0) goto 90004		!read error
	endif
c
	if (tcur.eq.x$) then			!if decimal
	   lim1=istrip_(wpage(2))
	   if (lim1.le.0) then
	      dcur=0
	   else
	      call rdivar_(wpage(2),dcur,wpics(2),erro)
	      if (erro.ne.0) goto 90004		!read error
	   endif
	endif
c
	call strfsc_(screen,erro)		!save field in memory context
	if (erro.ne.0) goto 990			!error, carry
c
	if (wcur.gt.120) then
	   write (mssg(1:),40009)		!exceeds editor max.,confirm ...
	   call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	   call padcmd_(d$cmdi,ttypad,ttychr,erro)
c	   if (erro.ne.0) noerror
	   if (ttypad.le.0.and.ttychr.eq.13) then	!<ret>
c	      ok
	   else
	      goto 490				!exit screen
	   endif
	endif
c
	if     (wstat.eq.up.or.
     1          wstat.eq.g_up    ) then
	   					!***UP or G_UP, previous screen
	   screen=screen-1
c
	elseif (wstat.gt.0.or.
     1          wstat.eq.ret.or.
     1          wstat.eq.down.or.
     1          wstat.eq.g_down  ) then
	   					!***^Z EXIT,<ret>,DOWN or G_DOWN
c
	   if (wcur.le.0) then
	      if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	      goto 410				!no width, don't go down
	   endif
c
	   if (tcur.eq.x$) then			!if decimal
	      lim1=istrip_(wpage(2))
	      if (lim1.le.0) then
	         if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	         goto 420			!no dec. pl., don't go down
	      else
	         call rdivar_(wpage(2),dcur,wpics(2),erro)
	         if (erro.ne.0) goto 90004	!read error
c
	         if (dcur.le.0.or.
     1               dcur.ge.wcur ) then
	            if (fsta(fcur).eq.2) fsta(fcur)=1	!no good anymore
	            goto 420			!dec. pl. .ge. width,
						!don't go down
	         endif
	      endif
	   endif
c
	   if (wstat.gt.0) goto 750		!***^Z EXIT (exit now)
	   screen=screen+1			!next screen
	else
	   goto 90003				!unknown code from VEDITS
	endif
c
	goto 490				!exit screen
c
c	W screen warnings
c	-----------------
c
c	no width specified
410	continue
c
	write (mssg(1:),41099)			!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 490				!exit screen
c
c	no dec. pl. specified or dec. pl. > width
420	continue
c
	write (mssg(1:),42099)			!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 490				!exit screen
c
c	W screen exit
c	-------------
c
490	continue
c
	goto 700				!common "case" base
c
c
c	Screen #5: R?	remaining field details
c	==========
c
500	continue
c
	goto (5101,5201,5301,5401,5501,5601,5701,5801) tcur
c
	if (tcur.eq.r8$) then			!double precision
	   fsta(fcur)=2			
	   call strfsc_(screen,erro)		!save field in memory context
	   if (erro.ne.0) goto 990		!error, carry
	   screen=2				!back to F* screen
	   goto 700				!"case" base
	else
	   goto 90006				!??unknown current field type??
						!or unexpected creature
	endif
c
c	R1 - integer
c
5101	continue
c
	if (r1mode.ne.5) then			!if rewriting screen
	   r1lx=1				!(R1)cursor start line
	   r1cx=1				!    cursor start column
	endif
c
	r1cx=1					!force col=1 (bug in editor...)
c
	r1wid=wcur+1				!room for +/-
c
	if (wcur.lt.10) then
	   valmax = 10 ** wcur - 1
	else
	   valmax = intmax
	endif
c
	do 1009 k = 1, r1plin
	   r1pics(k)=r1wid			!lower, upper, def.val. size
	   r1mini(k)=-valmax			!minimum
	   r1maxi(k)=valmax			!maximum
1009	continue
c
	r1used=r1size-r1stt+1			!total number of lines
c
	if (.not.new.and.
     1      .not.full    ) then
	   call rdivar_(r1page(1),iltmp,r1wid,erro)
	   if (erro.ne.0) goto 90004		!read error
	   call rdivar_(r1page(2),iutmp,r1wid,erro)
	   if (erro.ne.0) goto 90004		!read error
	   ltxt(1:)=' '
	   ltxt=r1page(1)			!as text
	   utxt(1:)=' '
	   utxt=r1page(2)			!as text
	endif
c
	dokill=.false.				!no ^Z KILL
	doinsert=.false.			!no ^Z INSERT
	call vedits_(strchl_,r1mode,r1stt,r1size,r1top,r1marg,r1lx,r1cx,r1mssg,
     1   	    r1msiz,r1page,r1psiz,r1used,r1mini,r1maxi,r1pics,
     1              r1kind,
     1   	    term,xpos,ypos,r1blnk,edtlin,dohlp,r1hlp,r1smax,
     1              r1stat,r1ftyp,dokill,doinsert,erro)
	if (erro.ne.0) goto 990			!error, carry
c
c	R1 screen processing
c	--------------------
c
	if (r1stat.eq.quit) goto 900			!***^Z QUIT (quit now)
c
	if (r1stat.eq.help) then			!***HELP or GOLD/HELP
	   hlpon=.true.					!help in progress
	   call strhlp_(r1kind(r1lx),edtlin,1,wuser)
	   r1mode=5				!don't re-display screen
	   goto 5190
	else
	   hlpon=.false.
	   r1mode=4				!re-display screen (not HELP/GH)
	endif
c
	call strfsc_(screen,erro)		!save field in memory context
	if (erro.ne.0) goto 990			!error, carry
c
	if     (r1stat.eq.up.or.
     1          r1stat.eq.g_up    ) then
	   					!***UP or G_UP, previous screen
	   if (tcur.eq.n$.or.			!if integer,
     1         tcur.eq.c$.or.			!string
     1         tcur.eq.x$    ) then		!or decimal
	      screen=screen-1			!next W screen
	   else
	      screen=screen-2			!skip W screen
	   endif
c
	elseif (r1stat.gt.0.or.
     1          r1stat.eq.ret.or.
     1          r1stat.eq.down.or.
     1          r1stat.eq.g_down  ) then
	   					!***^Z EXIT,<ret>,DOWN or G_DOWN
c
	   lim1=istrip_(r1page(1))
	   lim2=istrip_(r1page(2))
	   if (lim1.le.0.or.
     1         lim2.le.0    ) then
	      if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	      goto 5110				!no upper/lower, don't go down
	   endif
c
	   call rdivar_(r1page(1),ilow,r1wid,erro)
	   if (erro.ne.0) goto 90004		!read error
	   call rdivar_(r1page(2),iupp,r1wid,erro)
	   if (erro.ne.0) goto 90004		!read error
c
	   if (.not.new.and.
     1         .not.full    ) then
	      if (ilow.gt.iltmp) then
	         if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	         r1page(1)(1:)=' '		!restore lower/upper
	         r1page(1)=ltxt
	         r1page(2)(1:)=' '
	         r1page(2)=utxt
	         call strfsc_(screen,erro)	!(re)save field in memory
	         if (erro.ne.0) goto 990	!error, carry
	         goto 5140			!lower bound can't increase
	      endif
	      if (iupp.lt.iutmp) then
	         if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	         r1page(1)(1:)=' '		!restore lower/upper
	         r1page(1)=ltxt
	         r1page(2)(1:)=' '
	         r1page(2)=utxt
	         call strfsc_(screen,erro)	!(re)save field in memory
	         if (erro.ne.0) goto 990	!error, carry
	         goto 5150			!upper bound can't decrease
	      endif
c
	   endif
c
	   if (ilow.gt.iupp) then
	      if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	      goto 5120				!lower bound > upper bound
	   endif
c
	   lim1=istrip_(r1page(3))
	   if (lim1.gt.0) then
	      call rdivar_(r1page(3),idef,r1wid,erro)
	      if (erro.ne.0) goto 90004		!read error
	      if (idef.lt.ilow.or.
     1            idef.gt.iupp    ) then
	      if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	         goto 5130			!out of bounds
	      endif
	   endif
c
	   fsta(fcur)=2				!flag field completly checked
	   if (r1stat.gt.0) goto 750		!***^Z EXIT (exit now)
	   screen=2				!"next" screen (next field)
	else
	   goto 90003				!unknown code from VEDITS
	endif
c
	goto 5190				!exit screen
c
c	R1 screen warnings
c	------------------
c
c	upper or lower bound not specified
5110	continue
c
	write (mssg(1:),51109)			!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 5190				!exit screen
c
c	lower bound > upper bound
5120	continue
c
	write (mssg(1:),51209)			!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 5190				!exit screen
c
c	def value out of lower/upper bounds
5130	continue
c
	write (mssg(1:),51309)			!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 5190				!exit screen
c
c	lower bound can't increase
5140	continue
c
	write (mssg(1:),51409) ltxt		!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
c
	goto 5190				!exit screen
c
c	upper bound can't decrease
5150	continue
c
	write (mssg(1:),51509) utxt		!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
c
	goto 5190				!exit screen
c
c	R1 screen exit
c	--------------
c
5190	continue
c
	goto 700				!common "case" base
c
c	R2 - string
c
5201	continue
c
	if (r2mode.ne.5) then			!if rewriting screen
	   r2lx=1				!(R2)cursor start line
	   r2cx=1				!    cursor start column
	endif
c
	r2cx=1					!force col=1 (bug in editor...)
c
c	string: special case
c
	r2wid=wcur				!no extra room
	r2used=r2wid/r2slic			!total lines
	rest=mod(r2wid,r2slic)
	if (rest.gt.0) r2used=r2used+1		!total lines
	do 1010 k = 1, r2used
	   write (r2mssg(k),1172)		!default value:
	   r2msiz(k)=istrip_(r2mssg(k))		!mssg size
	   r2kind(k)=102			!type
	   r2ftyp(k)=vfrw$			!read/write
	   r2blnk(k)=vedbli			!blink
	   r2pics(k)=r2slic				!field size
1010	continue
c
	if (rest.gt.0) then
	   r2pics(r2used)=rest				!"fix" last line size
	endif
c
	dokill=.false.				!no ^Z KILL
	doinsert=.false.			!no ^Z INSERT
	call vedits_(strchl_,r2mode,r2stt,r2size,r2top,r2marg,r2lx,r2cx,r2mssg,
     1   	    r2msiz,r2page,r2psiz,r2used,r2mini,r2maxi,r2pics,
     1              r2kind,
     1   	    term,xpos,ypos,r2blnk,edtlin,dohlp,r2hlp,r2smax,
     1              r2stat,r2ftyp,dokill,doinsert,erro)
	if (erro.ne.0) goto 990			!error, carry
c
c	R2 screen processing
c	--------------------
c
	if (r2stat.eq.quit) goto 900			!***^Z QUIT (quit now)
c
	if (r2stat.eq.help) then			!***HELP or GOLD/HELP
	   hlpon=.true.					!help in progress
	   call strhlp_(r2kind(r2lx),edtlin,1,wuser)
	   r2mode=5				!don't re-display screen
	   goto 5290
	else
	   hlpon=.false.
	   r2mode=4				!re-display screen (not HELP/GH)
	endif
c
	fsta(fcur)=2				!flag field completly checked
						!(strings always ok)
c
	call strfsc_(screen,erro)		!save field in memory context
	if (erro.ne.0) goto 990			!error, carry
c
	if     (r2stat.eq.up.or.
     1          r2stat.eq.g_up    ) then
	   					!***UP or G_UP, previous screen
	   if (tcur.eq.n$.or.			!if integer,
     1         tcur.eq.c$.or.			!string
     1         tcur.eq.x$    ) then		!or decimal
	      screen=screen-1			!next W screen
	   else
	      screen=screen-2			!skip W screen
	   endif
c
	elseif (r2stat.gt.0.or.
     1          r2stat.eq.ret.or.
     1          r2stat.eq.down.or.
     1          r2stat.eq.g_down  ) then
	   					!***^Z EXIT,<ret>,DOWN or G_DOWN
c
	   if (r2stat.gt.0) goto 750		!***^Z EXIT (exit now)
	   screen=2				!"next" screen (next field)
	else
	   goto 90003				!unknown code from VEDITS
	endif
c
	goto 5290				!exit screen
c
c	R2 screen warnings
c	------------------
c
c	R2 screen exit
c	--------------
c
5290	continue
c
	goto 700				!common "case" base
c
c	R3 - other data base
c
5301	continue
c
	if (r3mode.ne.5) then			!if rewriting screen
	   r3lx=1				!(R3)cursor start line
	   r3cx=1				!    cursor start column
	endif
c
	r3cx=1					!force col=1 (bug in editor...)
c
	r3used=r3size-r3stt+1			!total number of lines
c
	db$bas(1)=bcur				!STRCHL ...
	db$fld(1)=fcur
c
	dokill=.false.				!no ^Z KILL
	doinsert=.false.			!no ^Z INSERT
	call vedits_(strchl_,r3mode,r3stt,r3size,r3top,r3marg,r3lx,r3cx,r3mssg,
     1   	    r3msiz,r3page,r3psiz,r3used,r3mini,r3maxi,r3pics,
     1              r3kind,
     1   	    term,xpos,ypos,r3blnk,edtlin,dohlp,r3hlp,r3smax,
     1              r3stat,r3ftyp,dokill,doinsert,erro)
	if (erro.ne.0) goto 990			!error, carry
c
c	R3 screen processing
c	--------------------
c
	if (r3stat.eq.quit) goto 900			!***^Z QUIT (quit now)
c
	if (r3stat.eq.help) then			!***HELP or GOLD/HELP
	   hlpon=.true.					!help in progress
	   call strhlp_(r3kind(r3lx),edtlin,1,wuser)
	   r3mode=5				!don't re-display screen
	   goto 5390
	else
	   hlpon=.false.
	   r3mode=4				!re-display screen (not HELP/GH)
	endif
c
	call strfsc_(screen,erro)		!save field in memory context
	if (erro.ne.0) goto 990			!error, carry
c
	if     (r3stat.eq.up.or.
     1          r3stat.eq.g_up    ) then
	   					!***UP or G_UP, previous screen
	   if (tcur.eq.n$.or.			!if integer,
     1         tcur.eq.c$.or.			!string
     1         tcur.eq.x$    ) then		!or decimal
	      screen=screen-1			!next W screen
	   else
	      screen=screen-2			!skip W screen
	   endif
c
	elseif (r3stat.gt.0.or.
     1          r3stat.eq.ret.or.
     1          r3stat.eq.down.or.
     1          r3stat.eq.g_down  ) then
	   					!***^Z EXIT,<ret>,DOWN or G_DOWN
c
	   if (prop.le.0) then			!regular base
c
	      lim1=istrip_(r3page(1))
	      lim2=istrip_(gpage(1))
	      call uc_(r3page(1))
	      call uc_(gpage(1))
c
	      if     (lim1.le.0) then
	         if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	         goto 5320				!no data base specified
	      elseif (lim1.eq.lim2.and.
     1                gpage(1)(1:lim2).eq.r3page(1)(1:lim1)) then
	         goto 5310				!don't point to yourself
	      endif
	   endif
c
	   fsta(fcur)=2				!flag field completly checked
	   if (r3stat.gt.0) goto 750		!***^Z EXIT (exit now)
	   screen=2				!"next" screen (next field)
	else
	   goto 90003				!unknown code from VEDITS
	endif
c
	goto 5390				!exit screen
c
c	R3 screen warnings
c	------------------
c
c	the data base can't "point" to itself
5310	continue
c
	write (mssg(1:),53109)			!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 5390				!exit screen
c
c	o.d.b. not specified
5320	continue
c
	write (mssg(1:),53209)			!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 5390				!exit screen
c
c	R3 screen exit
c	--------------
c
5390	continue
c
	goto 700				!common "case" base
c
c	R4 - decimal
c
5401	continue
c
	if (r4mode.ne.5) then			!if rewriting screen
	   r4lx=1				!(R4)cursor start line
	   r4cx=1				!    cursor start column
	endif
c
	r4cx=1					!force col=1 (bug in editor...)
c
	r4wid=1000*(dcur) + (wcur+1) + 1	!easy, isn't it ?
c
	if (wcur.lt.10) then
	   valmax = 10 ** wcur - 1
	else
	   valmax = intmax
	endif
c
	do 1011 k = 1, r4plin
	   r4pics(k)=r4wid			!lower, upper, def.val. size
	   r4mini(k)=-valmax			!minimum
	   r4maxi(k)=valmax			!maximum
1011	continue
c
	r4used=r4size-r4stt+1			!total number of lines
c
	if (.not.new.and.
     1      .not.full    ) then
	   					!save lower/upper
	   call rdfvar_(r4page(1),rltmp,wcur+2,ideci,erro)	!read lower
	   if (erro.ne.0) goto 90004				!read error
	   call rdfvar_(r4page(2),rutmp,wcur+2,ideci,erro)	!read upper
	   if (erro.ne.0) goto 90004				!read error
	   ltxt(1:)=' '
	   ltxt=r4page(1)			!as text
	   utxt(1:)=' '
	   utxt=r4page(2)			!as text
	endif
c
	dokill=.false.				!no ^Z KILL
	doinsert=.false.			!no ^Z INSERT
	call vedits_(strchl_,r4mode,r4stt,r4size,r4top,r4marg,r4lx,r4cx,r4mssg,
     1   	    r4msiz,r4page,r4psiz,r4used,r4mini,r4maxi,r4pics,
     1              r4kind,
     1   	    term,xpos,ypos,r4blnk,edtlin,dohlp,r4hlp,r4smax,
     1              r4stat,r4ftyp,dokill,doinsert,erro)
	if (erro.ne.0) goto 990			!error, carry
c
c	R4 screen processing
c	--------------------
c
	if (r4stat.eq.quit) goto 900			!***^Z QUIT (quit now)
c
	if (r4stat.eq.help) then			!***HELP or GOLD/HELP
	   hlpon=.true.					!help in progress
	   call strhlp_(r4kind(r4lx),edtlin,1,wuser)
	   r4mode=5				!don't re-display screen
	   goto 5490
	else
	   hlpon=.false.
	   r4mode=4				!re-display screen (not HELP/GH)
	endif
c
	call strfsc_(screen,erro)		!save field in memory context
	if (erro.ne.0) goto 990			!error, carry
c
	if     (r4stat.eq.up.or.
     1          r4stat.eq.g_up    ) then
	   					!***UP or G_UP, previous screen
	   if (tcur.eq.n$.or.			!if integer,
     1         tcur.eq.c$.or.			!string
     1         tcur.eq.x$    ) then		!or decimal
	      screen=screen-1			!next W screen
	   else
	      screen=screen-2			!skip W screen
	   endif
c
	elseif (r4stat.gt.0.or.
     1          r4stat.eq.ret.or.
     1          r4stat.eq.down.or.
     1          r4stat.eq.g_down  ) then
	   					!***^Z EXIT,<ret>,DOWN or G_DOWN
c
	   lim1=istrip_(r4page(1))
	   lim2=istrip_(r4page(2))
	   if (lim1.le.0.or.
     1         lim2.le.0    ) then
	      if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	      goto 5410				!no upper/lower, don't
						!go down
	   endif
	   ideci=d$deci(fcur,bcur)		!decimal places
	   call rdfvar_(r4page(1),rlow,wcur+2,ideci,erro)	!read lower
	   if (erro.ne.0) goto 90004				!read error
	   call rdfvar_(r4page(2),rupp,wcur+2,ideci,erro)	!read upper
	   if (erro.ne.0) goto 90004				!read error
c
	   if (.not.new.and.
     1         .not.full    ) then
	      if (rlow.gt.rltmp) then
	         if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	         r4page(1)(1:)=' '		!restore lower/upper
	         r4page(1)=ltxt
	         r4page(2)(1:)=' '
	         r4page(2)=utxt
	         call strfsc_(screen,erro)	!(re)save field in memory
	         if (erro.ne.0) goto 990	!error, carry
	         goto 5440			!lower bound can't increase
	      endif
	      if (rupp.lt.rutmp) then
	         if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	         r4page(1)(1:)=' '		!restore lower/upper
	         r4page(1)=ltxt
	         r4page(2)(1:)=' '
	         r4page(2)=utxt
	         call strfsc_(screen,erro)	!(re)save field in memory
	         if (erro.ne.0) goto 990	!error, carry
	         goto 5450			!upper bound can't decrease
	      endif
c
	   endif
c
	   if (rlow.gt.rupp) then
	      if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	      goto 5420				!lower bound > upper bound
	   endif
c
	   lim1=istrip_(r4page(3))
	   if (lim1.gt.0) then
	      call rdfvar_(r4page(3),rdef,wcur+2,ideci,erro)	!read default
	      if (erro.ne.0) goto 90004				!read error
	      if (rdef.lt.rlow.or.
     1            rdef.gt.rupp    ) then
	         if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	         goto 5430			!out of bounds
	      endif
	   endif
	   fsta(fcur)=2				!flag field completly checked
	   if (r4stat.gt.0) goto 750		!***^Z EXIT (exit now)
	   screen=2				!"next" screen (next field)
	else
	   goto 90003				!unknown code from VEDITS
	endif
c
	goto 5490				!exit screen
c
c	R4 screen warnings
c	------------------
c
c	decimal places, upper or lower bound not specified
5410	continue
c
	write (mssg(1:),54109)			!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 5490				!exit screen
c
c	lower bound > upper bound
5420	continue
c
	write (mssg(1:),54209)			!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 5490				!exit screen
c
c	def value out of lower/upper bounds
5430	continue
c
	write (mssg(1:),54309)			!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 5490				!exit screen
c
c	lower bound can't increase
5440	continue
c
	write (mssg(1:),54409) ltxt		!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
c
	goto 5490				!exit screen
c
c	upper bound can't decrease
5450	continue
c
	write (mssg(1:),54509) utxt		!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
c
	goto 5490				!exit screen
c
c	R4 screen exit
c	--------------
c
5490	continue
c
	goto 700				!common "case" base
c
c	R5 - date
c
5501	continue
c
	if (r5mode.ne.5) then			!if rewriting screen
	   r5lx=1				!(R5)cursor start line
	   r5cx=1				!    cursor start column
	endif
c
	r5cx=1					!force col=1 (bug in editor...)
c
	r5used=r5size-r5stt+1			!total number of lines
c
	if (.not.new.and.
     1      .not.full    ) then
						!save lower/upper
	   call numdat_(iltmp,r5page(1),r5pics(1),form,erro)
	   if (erro.ne.0) goto 90004
	   call numdat_(iutmp,r5page(2),r5pics(2),form,erro)
	   if (erro.ne.0) goto 90004
	   ltxt(1:)=' '
	   ltxt=r5page(1)			!as text
	   utxt(1:)=' '
	   utxt=r5page(2)			!as text
	endif
c
	dokill=.false.				!no ^Z KILL
	doinsert=.false.			!no ^Z INSERT
	call vedits_(strchl_,r5mode,r5stt,r5size,r5top,r5marg,r5lx,r5cx,r5mssg,
     1   	    r5msiz,r5page,r5psiz,r5used,r5mini,r5maxi,r5pics,
     1              r5kind,
     1   	    term,xpos,ypos,r5blnk,edtlin,dohlp,r5hlp,r5smax,
     1              r5stat,r5ftyp,dokill,doinsert,erro)
	if (erro.ne.0) goto 990			!error, carry
c
c	R5 screen processing
c	--------------------
c
	if (r5stat.eq.quit) goto 900			!***^Z QUIT (quit now)
c
	if (r5stat.eq.help) then			!***HELP or GOLD/HELP
	   hlpon=.true.					!help in progress
	   call strhlp_(r5kind(r5lx),edtlin,1,wuser)
	   r5mode=5				!don't re-display screen
	   goto 5590
	else
	   hlpon=.false.
	   r5mode=4				!re-display screen (not HELP/GH)
	endif
c
	call strfsc_(screen,erro)		!save field in memory context
	if (erro.ne.0) goto 990			!error, carry
c
	if     (r5stat.eq.up.or.
     1          r5stat.eq.g_up    ) then
	   					!***UP or G_UP, previous screen
	   if (tcur.eq.n$.or.			!if integer,
     1         tcur.eq.c$.or.			!string
     1         tcur.eq.x$    ) then		!or decimal
	      screen=screen-1			!next W screen
	   else
	      screen=screen-2			!skip W screen
	   endif
c
	elseif (r5stat.gt.0.or.
     1          r5stat.eq.ret.or.
     1          r5stat.eq.down.or.
     1          r5stat.eq.g_down  ) then
	   					!***^Z EXIT,<ret>,DOWN or G_DOWN
c
	   lim1=istrip_(r5page(1))
	   lim2=istrip_(r5page(2))
	   if (lim1.le.0.or.
     1         lim2.le.0   ) then
	      if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	      goto 5510				!lower and upper bound, or none
	   endif
c
	   call numdat_(ilow,r5page(1),r5pics(1),form,erro)
	   if (erro.ne.0) goto 90004
	   call numdat_(iupp,r5page(2),r5pics(2),form,erro)
	   if (erro.ne.0) goto 90004
c
	   if (.not.new.and.
     1         .not.full    ) then
	      if (ilow.gt.iltmp) then
	         if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	         r5page(1)(1:)=' '		!restore lower/upper
	         r5page(1)=ltxt
	         r5page(2)(1:)=' '
	         r5page(2)=utxt
	         call strfsc_(screen,erro)	!(re)save field in memory
	         if (erro.ne.0) goto 990	!error, carry
	         goto 5540			!lower bound can't increase
	      endif
	      if (iupp.lt.iutmp) then
	         if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	         r5page(1)(1:)=' '		!restore lower/upper
	         r5page(1)=ltxt
	         r5page(2)(1:)=' '
	         r5page(2)=utxt
	         call strfsc_(screen,erro)	!(re)save field in memory
	         if (erro.ne.0) goto 990	!error, carry
	         goto 5550			!upper bound can't decrease
	      endif
c
	   endif
c
	   if (ilow.gt.iupp) then
	      if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	      goto 5520				!lower bound > upper bound
	   endif
c
	   lim1=istrip_(r5page(3))
	   if (lim1.gt.0) then
	      call numdat_(idef,r5page(3),r5pics(3),form,erro)
	      if (erro.ne.0) goto 90004
	      if (idef.lt.ilow.or.
     1            idef.gt.iupp    ) then
	         if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	         goto 5530			!out of bounds
	      endif
	   endif
	   fsta(fcur)=2				!flag field completly checked
	   if (r5stat.gt.0) goto 750		!***^Z EXIT (exit now)
	   screen=2				!"next" screen (next field)
	else
	   goto 90003				!unknown code from VEDITS
	endif
c
	goto 5590				!exit screen
c
c	R5 screen warnings
c	------------------
c
c	lower AND upper bounds
5510	continue
c
	write (mssg(1:),55109)			!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 5590				!exit screen
c
c	lower bound > upper bound
5520	continue
c
	write (mssg(1:),55209)			!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 5590				!exit screen
c
c	def value out of lower/upper bounds
5530	continue
c
	write (mssg(1:),55309)			!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 5590				!exit screen
c
c	lower bound can't increase
5540	continue
c
	write (mssg(1:),55409) ltxt		!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 5590				!exit screen
c
c	upper bound can't decrease
5550	continue
c
	write (mssg(1:),55509) utxt		!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 5590				!exit screen
c
c	R5 screen exit
c	--------------
c
5590	continue
c
	goto 700				!common "case" base
c
c	R6 - logical
c
5601	continue
c
	if (r6mode.ne.5) then			!if rewriting screen
	   r6lx=1				!(R6)cursor start line
	   r6cx=1				!    cursor start column
	endif
c
	r6cx=1					!force col=1 (bug in editor...)
c
	r6used=r6size-r6stt+1			!total number of lines
c
	dokill=.false.				!no ^Z KILL
	doinsert=.false.			!no ^Z INSERT
	call vedits_(strchl_,r6mode,r6stt,r6size,r6top,r6marg,r6lx,r6cx,r6mssg,
     1   	    r6msiz,r6page,r6psiz,r6used,r6mini,r6maxi,r6pics,
     1              r6kind,
     1   	    term,xpos,ypos,r6blnk,edtlin,dohlp,r6hlp,r6smax,
     1              r6stat,r6ftyp,dokill,doinsert,erro)
	if (erro.ne.0) goto 990			!error, carry
c
c	R6 screen processing
c	--------------------
c
	if (r6stat.eq.quit) goto 900			!***^Z QUIT (quit now)
c
	if (r6stat.eq.help) then			!***HELP or GOLD/HELP
	   hlpon=.true.					!help in progress
	   call strhlp_(r6kind(r6lx),edtlin,1,wuser)
	   r6mode=5				!don't re-display screen
	   goto 5690
	else
	   hlpon=.false.
	   r6mode=4				!re-display screen (not HELP/GH)
	endif
c
	call strfsc_(screen,erro)		!save field in memory context
	if (erro.ne.0) goto 990			!error, carry
c
	if     (r6stat.eq.up.or.
     1          r6stat.eq.g_up    ) then
	   					!***UP or G_UP, previous screen
	   if (tcur.eq.n$.or.			!if integer,
     1         tcur.eq.c$.or.			!string
     1         tcur.eq.x$    ) then		!or decimal
	      screen=screen-1			!next W screen
	   else
	      screen=screen-2			!skip W screen
	   endif
c
	elseif (r6stat.gt.0.or.
     1          r6stat.eq.ret.or.
     1          r6stat.eq.down.or.
     1          r6stat.eq.g_down  ) then
	   					!***^Z EXIT,<ret>,DOWN or G_DOWN
c
	   fsta(fcur)=2				!flag field completly checked
	   if (r6stat.gt.0) goto 750		!***^Z EXIT (exit now)
	   screen=2				!"next" screen (next field)
	else
	   goto 90003				!unknown code from VEDITS
	endif
c
	goto 5690				!exit screen
c
c	R6 screen warnings
c	------------------
c
c	R6 screen exit
c	--------------
c
5690	continue
c
	goto 700				!common "case" base
c
c	R7 - real
c
5701	continue
c
	if (r7mode.ne.5) then			!if rewriting screen
	   r7lx=1				!(r7)cursor start line
	   r7cx=1				!    cursor start column
	endif
c
	r7cx=1					!force col=1 (bug in editor...)
c
	r7wid=wcur
c
	do 11009 k = 1, r7plin
	   r7pics(k)=r7wid			!lower, upper, def.val. size
	   r7mini(k)=ismallone			!minimum
	   r7maxi(k)=ibigone			!maximum
11009	continue
c
	r7used=r7size-r7stt+1			!total number of lines
c
	if (.not.new.and.
     1      .not.full    ) then
						!save lower/upper
	   read (r7page(1),*,err=90004) rltmp
	   read (r7page(2),*,err=90004) rutmp
	   ltxt(1:)=' '
	   ltxt=r7page(1)			!as text
	   utxt(1:)=' '
	   utxt=r7page(2)			!as text
	endif
c
	dokill=.false.				!no ^Z KILL
	doinsert=.false.			!no ^Z INSERT
	call vedits_(strchl_,r7mode,r7stt,r7size,r7top,r7marg,r7lx,r7cx,r7mssg,
     1   	    r7msiz,r7page,r7psiz,r7used,r7mini,r7maxi,r7pics,
     1              r7kind,
     1   	    term,xpos,ypos,r7blnk,edtlin,dohlp,r7hlp,r7smax,
     1              r7stat,r7ftyp,dokill,doinsert,erro)
	if (erro.ne.0) goto 990			!error, carry
c
c	r7 screen processing
c	--------------------
c
	if (r7stat.eq.quit) goto 900			!***^Z QUIT (quit now)
c
	if (r7stat.eq.help) then			!***HELP or GOLD/HELP
	   hlpon=.true.					!help in progress
	   call strhlp_(r7kind(r7lx),edtlin,1,wuser)
	   r7mode=5				!don't re-display screen
	   goto 5790
	else
	   hlpon=.false.
	   r7mode=4				!re-display screen (not HELP/GH)
	endif
c
	call strfsc_(screen,erro)		!save field in memory context
	if (erro.ne.0) goto 990			!error, carry
c
	if     (r7stat.eq.up.or.
     1          r7stat.eq.g_up    ) then
	   					!***UP or G_UP, previous screen
	   if (tcur.eq.n$.or.			!if integer,
     1         tcur.eq.c$.or.			!string
     1         tcur.eq.x$    ) then		!or decimal
	      screen=screen-1			!next W screen
	   else
	      screen=screen-2			!skip W screen
	   endif
c
	elseif (r7stat.gt.0.or.
     1          r7stat.eq.ret.or.
     1          r7stat.eq.down.or.
     1          r7stat.eq.g_down  ) then
	   					!***^Z EXIT,<ret>,DOWN or G_DOWN
c
	   lim1=istrip_(r7page(1))
	   lim2=istrip_(r7page(2))
	   if (lim1.le.0.or.
     1         lim2.le.0   ) then
	      if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	      goto 5710				!lower and upper bound, or none
	   endif
c
	   read (r7page(1),*,err=90004) rlow
	   read (r7page(2),*,err=90004) rupp
c
	   if (.not.new.and.
     1         .not.full    ) then
	      if (rlow.gt.rltmp) then
	         if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	         r7page(1)(1:)=' '		!restore lower/upper
	         r7page(1)=ltxt
	         r7page(2)(1:)=' '
	         r7page(2)=utxt
	         call strfsc_(screen,erro)	!(re)save field in memory
	         if (erro.ne.0) goto 990	!error, carry
	         goto 5740			!lower bound can't increase
	      endif
	      if (rupp.lt.rutmp) then
	         if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	         r7page(1)(1:)=' '		!restore lower/upper
	         r7page(1)=ltxt
	         r7page(2)(1:)=' '
	         r7page(2)=utxt
	         call strfsc_(screen,erro)	!(re)save field in memory
	         if (erro.ne.0) goto 990	!error, carry
	         goto 5750			!upper bound can't decrease
	      endif
c
	   endif
c
	   if (rlow.gt.rupp) then
	      if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	      goto 5720				!lower bound > upper bound
	   endif
c
	   lim1=istrip_(r7page(3))
	   if (lim1.gt.0) then
	      read (r7page(3),*,err=90004) rdef
	      if (rdef.lt.rlow.or.
     1            rdef.gt.rupp    ) then
	         if (fsta(fcur).eq.2) fsta(fcur)=1!no good anymore
	         goto 5730			!out of bounds
	      endif
	   endif
	   fsta(fcur)=2				!flag field completly checked
	   if (r7stat.gt.0) goto 750		!***^Z EXIT (exit now)
	   screen=2				!"next" screen (next field)
	else
	   goto 90003				!unknown code from VEDITS
	endif
c
	goto 5790				!exit screen
c
c	r7 screen warnings
c	------------------
c
c	lower AND upper bounds
5710	continue
c
	write (mssg(1:),57109)			!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 5790				!exit screen
c
c	lower bound > upper bound
5720	continue
c
	write (mssg(1:),57209)			!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 5790				!exit screen
c
c	def value out of lower/upper bounds
5730	continue
c
	write (mssg(1:),57309)			!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 5790				!exit screen
c
c	lower bound can't increase
5740	continue
c
	write (mssg(1:),57409) ltxt		!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 5790				!exit screen
c
c	upper bound can't decrease
5750	continue
c
	write (mssg(1:),57509) utxt		!warning
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	goto 5790				!exit screen
c
c	r7 screen exit
c	--------------
c
5790	continue
c
	goto 700				!common "case" base
c
c	R8 - double precision
c
5801	continue
c
	goto 90006				!funny type
						!or unexpected creature
c
c
c	"Case" base
c	-----------
c
700	continue
c
c	Check/set new field#, type, width
c
	if (istrip_(tpage(1)).le.0) then
	   tpage(1)(1:)=' '
	endif
c
	if (.not.hlpon) then			!if no help in progress,
	   call strfrs_(erro)			!restore current field
	   if (erro.ne.0) goto 990		!error, carry
	endif
c
c	back to structure editing main loop
c	-----------------------------------
c
	goto 99
c
c	Here if ^Z EXIT when editing structure
c	======================================
c
c	Fields with fsta(f) = 2 and non-empty mnemonic have been completly
c	accepted, not the others.
c	Check field mnemonics (duplicated). Ask user if everything ok or if
c	he (or she) wants to review structure.
c	Check total record size len.
c	When ok, set/complete memory context and return.
c
750	continue
c
	if (prop.gt.0) then			!property
	   nfmax=d$f-3				!check all fields (room for
						!3 pointers)
	else
	   nfmax=d$f				!check all fields
	endif
c
c	Check repeated field mnemonics; if *** NOT FULL editing, don't
c	accept empty mnemonics (= deleted fields)
c	--------------------------------------------------------------
c
	do 1013 k = 1, nfmax
	 if (fsta(k).eq.2) then			!if accepted field
	   mnelin=fsz*(k-1)+1			!current mnemonic line#
	   lim1=istrip_(fpage(mnelin))
	   if (lim1.le.0) then
	      if (.not.full) then
	         goto 766			!missing mnemonic
	      endif
	   else
	      fmnem1(1:)=' '			!check repeated mnemonics
	      fmnem1(1:)=fpage(mnelin)(1:lim1)
	      call uc8to7_(fmnem1(1:lim1))
	      do 1014 kk = 1, k-1		!search previous mnemonics
	         mnelin=fsz*(kk-1)+1		!current mnemonic line#
	         lim2=istrip_(fpage(mnelin))
	         if (fsta(kk).eq.2.and.
     1               lim2.gt.0         ) then
	            fmnem2(1:)=' '
	            fmnem2=fpage(mnelin)(1:lim2)
	            call uc8to7_(fmnem2(1:lim2))
	            if (fmnem1.eq.fmnem2) then
	               ferr=kk			!field#
	               goto 765			!already exists
	            endif
	         endif
1014	      continue
	   endif
	 endif
1013	continue
	goto 780				!data base structure ok ?
c
c	mnemonic already exists
765	continue
c
	write (mssg(1:),22099)			!warning
	write (mssg(istrip_(mssg)+1:),fmt='(i3)',err=90004) ferr!field#
	call erase_line_(edtlin-1,1)		!erase line
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin-1,1,wuser)
	write (mssg(1:),21199)			!<ret>
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	call padcmd_(d$cmdi,ttypad,ttychr,erro)
c	if (erro.ne.0) noerror
	goto 90					!go back to main editing loop
c
c	no mnemonic
766	continue
c
	write (mssg(1:),23099)			!warning
	write (mssg(istrip_(mssg)+1:),fmt='(i3)',err=90004) k!field#
	call erase_line_(edtlin-1,1)		!erase line
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin-1,1,wuser)
	write (mssg(1:),21199)			!<ret>
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	call padcmd_(d$cmdi,ttypad,ttychr,erro)
c	if (erro.ne.0) noerror
	goto 90					!go back to main editing loop
c
c	Data base structure ok (?)
c	--------------------------
c
780	continue
c
	mynfmx=0
	do 1022 k = d$f, 1, -1
	   tmplk=(k-1)*2+1			!field mnemonic line
	   lim1=istrip_(fpage(tmplk))
	   if (fsta(k).eq.2.or.
     1         lim1.gt.0        ) then		!last field in structure
	      mynfmx=k
	      goto 10242
	   endif
1022	continue
10242	continue
c
	nbad=0
	totlen=0				!record size
	xtotl=0					!external (properties)
	f=0
	if (mynfmx.gt.0) then
	   do 1023 k = 1, mynfmx
	      tmplk=(k-1)*2+1			!field mnemonic line
	      lim1=istrip_(fpage(tmplk))
	      if (fsta(k).eq.2.and.
     1            lim1.gt.0        ) then	!field is ok
c
	         totlen=totlen+d$siz(k,bcur)	!recompute total len
	         if (prop.gt.0) then		!and external len
	            xtype=d$type(k,bcur)
	            if     (xtype.eq.d$) then
	               xtotl=xtotl+11		!DATE size
	            elseif (xtype.eq.x$) then	!decimals, extra room for "."
	               xtotl=xtotl+d$siz(k,bcur)+1
	            elseif (xtype.eq.r$) then	!reals have fixed format
	               xtotl=xtotl+15
	            elseif (xtype.eq.r8$) then	!double precision too
	               xtotl=xtotl+24
	            else
	               xtotl=xtotl+d$siz(k,bcur)
	            endif
	         endif
	         if (totlen.gt.myxusr.or.
	1            (prop.gt.0.and.
	1             xtotl.gt.myxusr)   ) then
	            write (mssg(1:),1224)	!warning
	            call erase_line_(edtlin-1,1)!erase line
	            call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin-1,1,wuser)
	            write (mssg(1:),21199)	!<ret>
	            call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	            call padcmd_(d$cmdi,ttypad,ttychr,erro)
c	            if (erro.ne.0) noerror
	            goto 90			!go back to main editing loop
	         endif
c
	         f=f+1
c
	      else
	         write (mssg(1:),1227)		!no mnemonic or not completed
	         write (mssg(istrip_(mssg)+1:),fmt='(i3)',err=90004) k!field#
	         call erase_line_(edtlin-1,1)	!clean line
	         call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin-1,1,wuser)
	         nbad=nbad+1
	      endif
1023      continue
	endif
c
	if (nbad.gt.0) then			!unfinished field(s)
	   write (mssg(1:),1228)		!<ret> to proceed
	   call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	   call padcmd_(d$cmdi,ttypad,ttychr,erro)
c	   if (erro.ne.0) noerror
	   call erase_line_(edtlin-1,1)		!clean line
	   if (ttypad.le.0.and.ttychr.eq.13) then	!<ret>
	      goto 782				!procedd
	   else
	      goto 90				!loop back, edit structure again
	   endif
	endif
c
	if (f.le.0) then			!no field at all
	   write (mssg(1:),1226)
	   call erase_line_(edtlin-1,1)	!clean line
	   call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin-1,1,wuser)
	   write (mssg(1:),1228)		!<ret> to proceed
	   call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	   call padcmd_(d$cmdi,ttypad,ttychr,erro)
c	   if (erro.ne.0) noerror
	   call erase_line_(edtlin-1,1)	!clean line
	   if (ttypad.le.0.and.ttychr.eq.13) then	!<ret>
	         goto 90008
	   else
	         goto 90			!loop back, edit structure again
	   endif
	else
	   write (mssg(1:),1229)
	   write (mssg(istrip_(mssg)+1:),fmt='(i3)',err=90004) f!# of fields
	   write (mssg(istrip_(mssg)+1:),1239)
	   call erase_line_(edtlin-1,1)	!clean line
	   call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin-1,1,wuser)
	   write (mssg(1:),1228)		!<ret> to proceed
	   call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	   call padcmd_(d$cmdi,ttypad,ttychr,erro)
c	   if (erro.ne.0) noerror
	   call erase_line_(edtlin-1,1)	!clean line
	   if (ttypad.le.0.and.ttychr.eq.13) then	!<ret>
	      goto 782				!procedd
	   else
	      goto 90				!loop back, edit structure again
	   endif
	endif
c
c	Review data base strucure (?)
c	-----------------------------
c
782	continue
c
	call tty_putc_(bell)			!ring
	write (mssg,1222,err=90004)		!review struct. ? (y/n)
	call vtext_(mssg(1:istrip_(mssg)),edtlin,1,2)
c
781	continue
c
	call padcmd_(d$cmdi,ttypad,ttychr,erro)
c	if (erro.ne.0) noerror
	if     (ttypad.le.0.and.
	1       (ttychr.eq.121.or.		!'y'
     1           ttychr.eq.89     ) ) then	!'Y'
	   call erase_line_(edtlin,1)	!clean line
	   goto 800				!display structure
	elseif (ttypad.le.0.and.
	1       (ttychr.eq.110.or.		!'n'
     1           ttychr.eq.78.or.		!'N'
     1           ttychr.eq.13    ) ) then	!<ret>=n
	   call erase_line_(edtlin,1)	!clean line
	   goto 850				!set/complete memory context
	else
	   goto 781				!try again
	endif
c
c
c	>>>>>> DISPLAY DATA BASE STRUCTURE
c	==================================
c
c	Here to execute DISPLAY STRUCTURE command, or to show data base struct.
c	just created or modified by user.
c
c
800	continue
c
c	Clean screen
c	------------
c
	call erase_page_(2,1)		!clean screen from line 2...
c
c	Display screen #1: G
c
801	continue
c
	gmode=6					!"display" mode
	gused=gpl				!total lines
c
	dokill=.false.				!no ^Z KILL
	doinsert=.false.			!no ^Z INSERT
	call vedits_(strchl_,gmode,gstt,gsize,gtop,gmarg,glx,gcx,gmssg,
     1   	    gmsiz,gpage,gpsiz,gused,gmini,gmaxi,gpics,gkind,
     1   	    term,gxpos,gypos,gblink,edtlin,dohlp,ghlp,gsmax,
     1              gstat,gftyp,dokill,doinsert,erro)
	if (erro.ne.0) goto 990			!error, carry
c
c	Loop on accepted and complete fields
c	------------------------------------
c
	fcur=0					!begin at first field
c
8021	continue
c
	fcur=fcur+1
c
	if (fcur.gt.nfmax) goto 8302		!hops
c
	mnelin=fsz*(fcur-1)+1			!current mnemonic line#
	lim1=istrip_(fpage(mnelin))
	if (fsta(fcur).ne.2.or.
     1      lim1.le.0          ) goto 8021	!skip undefined fields
c
c	Display screen #2: F (field mnemonic, description)
c	--------------------------------------------------
c
802	continue
c
	tcur=d$type(fcur,bcur)			!field type
c
	if (tcur.gt.ftusr$) then		!no creatures here
	   goto 8021				!next field
	endif
c
	if     (tcur.eq.n$) then		!integer
	   wcur=d$siz(fcur,bcur)-1
	   wused=1
	   do 1015 k = 1, r1plin
	      r1pics(k)=wcur+1			!size
1015	   continue
	elseif (tcur.eq.c$) then		!string: special case
	   wcur=d$siz(fcur,bcur)
	   wused=1
	   r2wid=wcur				!no extra room
	   r2used=r2wid/r2slic			!total lines
	   rest=mod(r2wid,r2slic)
	   if (rest.gt.0) r2used=r2used+1	!total lines
	   do 1016 k = 1, r2used
	      write (r2mssg(k),1172)		!default value:
	      r2msiz(k)=istrip_(r2mssg(k))	!mssg size
	      r2kind(k)=102			!type
	      r2ftyp(k)=vfrw$			!read/write
	      r2blnk(k)=vedbli			!blink
	      r2pics(k)=r2slic			!field size
1016	   continue
	   if (rest.gt.0) then
	      r2pics(r2used)=rest		!"fix" field size
	   endif
	elseif (tcur.eq.db$) then
	   wcur=10
	   wused=1
	   pics(1)=9
	elseif (tcur.eq.x$) then		!decimal
	   wcur=d$siz(fcur,bcur)-1		!size
	   dcur=d$deci(fcur,bcur)		!decimal places
	   wused=wpline				!width + decimal pl.
	   r4wid=1000*(dcur) + (wcur+1) + 1	!easy, isn't it ?
	   do 1017 k = 1, r4plin
	      r4pics(k)=r4wid			!lower, upper, def.val. size
1017	   continue
	elseif (tcur.eq.d$) then
	   wcur=11
	   wused=1
	   do 1018 k = 1, r5plin
	      r5pics(k)=wcur			!lower, upper, def.val. size
1018	   continue
	elseif (tcur.eq.l$) then
	   wcur=1
	   wused=1
	   do 1019 k = 1, r6plin
	      r6pics(k)=wcur			!lower, upper, def.val. size
1019	   continue
	elseif (tcur.eq.r$) then
	   wcur=15
	   wused=1
	   do 1020 k = 1, r7plin
	      r7pics(k)=wcur			!lower, upper, def.val. size
1020	   continue
	endif
c
	call strfrs_(erro)			!restore current field
	if (erro.ne.0) goto 990			!error, carry
c
	fstt=9					!editor first line
	fsize=10					!and last
	fsmax=fsize
	ftop=fsz*(fcur-1)+1			!first line of page to show
c
	fmode=6					!"display" mode
c
	fused=fpsiz
c
	dokill=.false.				!no ^Z KILL
	doinsert=.false.			!no ^Z INSERT
	call vedits_(strchl_,fmode,fstt,fsize,ftop,fmarg,flx,fcx,fmssg,
     1   	    fmsiz,fpage,fpsiz,fused,fmini,fmaxi,fpics,fkind,
     1   	    term,xpos,ypos,fblink,edtlin,dohlp,fhlp,fsmax,
     1              fstat,fftyp,dokill,doinsert,erro)
	if (erro.ne.0) goto 990			!error, carry
c
	call erase_page_(11,1)		!clean screen from line 11
c
	ix=d$idx(fcur,bcur)
        if     (ix.le.0) then
	   write (fdtmsg,1110)		!field# message
	elseif (ix.eq.1) then		!INDEX
	   write (fdtmsg,1111)
	elseif (ix.eq.2) then		!KEY
	   write (fdtmsg,1112)
	else	      
	   write (fdtmsg,1114)		!KWIC INDEX
	endif
c
	lim1=index(fdtmsg,'#')		!add field#
	if (lim1.gt.0) then
	   lim1=lim1+2
	   write (fdtmsg(lim1:lim1+2),fmt='(i3.0)',err=90004) fcur
	endif
	call vtext_(fdtmsg,12,1,0)		!field# message at line 12
c
c	Display screen #3: T
c
803	continue
c
	tmode=6					!"display" mode
	tused=tsize-tstt+1			!total lines
c
	dokill=.false.				!no ^Z KILL
	doinsert=.false.			!no ^Z INSERT
	call vedits_(strchl_,tmode,tstt,tsize,ttop,tmarg,tlx,tcx,tmssg,
     1   	    tmsiz,tpage,tpsiz,tused,tmini,tmaxi,tpics,tkind,
     1   	    term,xpos,ypos,tblink,edtlin,dohlp,thlp,tsmax,
     1              tstat,tftyp,dokill,doinsert,erro)
	if (erro.ne.0) goto 990			!error, carry
c
	if (tcur.eq.n$.or.			!if integer,
     1      tcur.eq.c$.or.			!string
     1      tcur.eq.x$    ) then		!or decimal, next screen
	   goto 804				!next W screen
	else
	   call verase_(wstt,wsize)		!erase W screen
	   goto 805				!next R? screen
	endif
c
c	Display screen #4: W
c
804	continue
c
	wmode=6					!"display" mode
c
	dokill=.false.				!no ^Z KILL
	doinsert=.false.			!no ^Z INSERT
	call vedits_(strchl_,wmode,wstt,wsize,wtop,wmarg,wlx,wcx,wmssg,
     1   	    wmsiz,wpage,wpsiz,wused,wmini,wmaxi,wpics,wkind,
     1   	    term,xpos,ypos,wblink,edtlin,dohlp,whlp,wsmax,
     1              wstat,wftyp,dokill,doinsert,erro)
	if (erro.ne.0) goto 990			!error, carry
c
c	Display screen #5: R?
c
805	continue
c
	goto (821,822,823,824,825,826,827,828) tcur
c
	if (tcur.eq.r8$) then			!double precision
	   goto 830				!"case" base (creatures)
	else
	   goto 90006				!??unknown current field type??
						!or unexpected creature
	endif
c
c	R1 - integer
c
821	continue
c
	r1mode=6				!"display" mode
	r1used=r1size-r1stt+1			!total number of lines
c
	dokill=.false.				!no ^Z KILL
	doinsert=.false.			!no ^Z INSERT
	call vedits_(strchl_,r1mode,r1stt,r1size,r1top,r1marg,r1lx,r1cx,r1mssg,
     1   	    r1msiz,r1page,r1psiz,r1used,r1mini,r1maxi,r1pics,
     1              r1kind,
     1   	    term,xpos,ypos,r1blnk,edtlin,dohlp,r1hlp,r1smax,
     1              r1stat,r1ftyp,dokill,doinsert,erro)
	if (erro.ne.0) goto 990			!error, carry
c
	goto 830				!"case" base
c
c	R2 - string
c
822	continue
c
	r2lx=1					!(R2)cursor start line
	r2cx=1					!and column
	r2top=-1				!from first line
	r2mode=4				!force "edit" mode always
c
	dokill=.false.				!no ^Z KILL
	doinsert=.false.			!no ^Z INSERT
	call vedits_(strchl_,r2mode,r2stt,r2size,r2top,r2marg,r2lx,r2cx,r2mssg,
     1   	    r2msiz,r2page,r2psiz,r2used,r2mini,r2maxi,r2pics,
     1              r2kind,
     1   	    term,xpos,ypos,r2blnk,edtlin,dohlp,r2hlp,r2smax,
     1              r2stat,r2ftyp,dokill,doinsert,erro)
	if (erro.ne.0) goto 990			!error, carry
c
c	R2 screen processing
c	--------------------
c
	if (r2mode.ne.6) then
	   if (r2stat.eq.quit) then		!***^Z QUIT (quit now = return)
	         goto 990			!just return
	   endif
	   if (r2stat.gt.0) then		!***^Z EXIT (exit now = return)
	         goto 990			!just return
	   endif
	endif
c
	goto 830				!"case" base
c
c	R3 - other data base
c
823	continue
c
	r3mode=6				!"display" mode
	r3used=r3size-r3stt+1			!total number of lines
c
	dokill=.false.				!no ^Z KILL
	doinsert=.false.			!no ^Z INSERT
	call vedits_(strchl_,r3mode,r3stt,r3size,r3top,r3marg,r3lx,r3cx,r3mssg,
     1   	    r3msiz,r3page,r3psiz,r3used,r3mini,r3maxi,r3pics,
     1              r3kind,
     1   	    term,xpos,ypos,r3blnk,edtlin,dohlp,r3hlp,r3smax,
     1              r3stat,r3ftyp,dokill,doinsert,erro)
	if (erro.ne.0) goto 990			!error, carry
c
	goto 830				!"case" base
c
c	R4 - decimal
c
824	continue
c
	r4mode=6				!"display" mode
	r4used=r4size-r4stt+1			!total number of lines
c
	dokill=.false.				!no ^Z KILL
	doinsert=.false.			!no ^Z INSERT
	call vedits_(strchl_,r4mode,r4stt,r4size,r4top,r4marg,r4lx,r4cx,r4mssg,
     1   	    r4msiz,r4page,r4psiz,r4used,r4mini,r4maxi,r4pics,
     1              r4kind,
     1   	    term,xpos,ypos,r4blnk,edtlin,dohlp,r4hlp,r4smax,
     1              r4stat,r4ftyp,dokill,doinsert,erro)
	if (erro.ne.0) goto 990			!error, carry
c
	goto 830				!"case" base
c
c	R5 - date
c
825	continue
c
	r5mode=6				!"display" mode
	r5used=r5size-r5stt+1			!total number of lines
c
	dokill=.false.				!no ^Z KILL
	doinsert=.false.			!no ^Z INSERT
	call vedits_(strchl_,r5mode,r5stt,r5size,r5top,r5marg,r5lx,r5cx,r5mssg,
     1   	    r5msiz,r5page,r5psiz,r5used,r5mini,r5maxi,r5pics,
     1              r5kind,
     1   	    term,xpos,ypos,r5blnk,edtlin,dohlp,r5hlp,r5smax,
     1              r5stat,r5ftyp,dokill,doinsert,erro)
	if (erro.ne.0) goto 990			!error, carry
c
	goto 830				!"case" base
c
c	R6 - logical
c
826	continue
c
	r6mode=6				!"display" mode
	r6used=r6size-r6stt+1			!total number of lines
c
	dokill=.false.				!no ^Z KILL
	doinsert=.false.			!no ^Z INSERT
	call vedits_(strchl_,r6mode,r6stt,r6size,r6top,r6marg,r6lx,r6cx,r6mssg,
     1   	    r6msiz,r6page,r6psiz,r6used,r6mini,r6maxi,r6pics,
     1              r6kind,
     1   	    term,xpos,ypos,r6blnk,edtlin,dohlp,r6hlp,r6smax,
     1              r6stat,r6ftyp,dokill,doinsert,erro)
	if (erro.ne.0) goto 990			!error, carry
c
	goto 830				!"case" base
c
c	R7 - real
c
827	continue
c
	r7mode=6				!"display" mode
	r7used=r7size-r7stt+1			!total number of lines
c
	dokill=.false.				!no ^Z KILL
	doinsert=.false.			!no ^Z INSERT
	call vedits_(strchl_,r7mode,r7stt,r7size,r7top,r7marg,r7lx,r7cx,r7mssg,
     1   	    r7msiz,r7page,r7psiz,r7used,r7mini,r7maxi,r7pics,
     1              r7kind,
     1   	    term,xpos,ypos,r7blnk,edtlin,dohlp,r7hlp,r7smax,
     1              r7stat,r7ftyp,dokill,doinsert,erro)
	if (erro.ne.0) goto 990			!error, carry
c
	goto 830				!"case" base
c
c	R8 - other data base with check digit (???)
c
828	continue
c
	goto 90006				!funny type
						!or unexpected creature
c
c	"Case" base
c	-----------
c
830	continue
c
8301	continue
	fcur=fcur+1				!next field#
c
8302	continue
c
	if (fcur.gt.nfmax) then
	   call tty_putc_(bell)			!ring
	   if (nfmax.gt.0) then
	      write (mssg,1223,err=90004)	!all fields shown,<ret> to exit
	   else
	      write (mssg,1230,err=90004)	!no regular field,^ZEXIT to exit
	   endif
	   call vtext_(mssg(1:istrip_(mssg)),edtlin,1,2)
	   call padcmd_(d$cmdi,ttypad,ttychr,erro)
c	   if (erro.ne.0) noerror
	   call erase_line_(edtlin,1)	!clean line
	   if     (ttypad.le.0.and.ttychr.eq.13) then	!<ret>
	      if (.not.edit) then
	         goto 990			!return
	      else
	         goto 850			!set memory context and return
	      endif
	   else
	      if (.not.edit) then
	         goto 800			!loop back, show structure again
	      else
	         goto 90			!loop back, edit structure again
	      endif
	   endif
	else
	   mnelin=fsz*(fcur-1)+1		!current mnemonic line#
	   lim1=istrip_(fpage(mnelin))
	   if (fsta(fcur).ne.2.or.
     1         lim1.le.0          ) goto 8301	!skip undefined fields
	   write (mssg,1221,err=90004)		!<ret> to proceed
	   call vtext_(mssg(1:istrip_(mssg)),edtlin,1,2)
	   call padcmd_(d$cmdi,ttypad,ttychr,erro)
c	   if (erro.ne.0) noerror
	   call erase_line_(edtlin,1)	!clean line
	   if     (ttypad.ne.0.or.ttychr.ne.13) then	!.not. <ret>
	      if (.not.edit) then
	         goto 990			!return
	      else
	         goto 850			!set memory context and return
	      endif
	   else
	      goto 802				!loop back to show next field
	   endif
	endif
c
c	Recover/set memory context for data base BCUR
c	---------------------------------------------
c
850	continue
c
c	Global characteristics
c
	b=bcur
c
	if (prop.gt.0) then			!property
	   d$bdes(b)(1:)=' '			!description
	   d$bdes(b)=gpage(1)
c
	   irec=1				!1st record# = 1 for properties
c
	   if (gpage(3)(1:1).eq.'y') then
	      d$crpt(b)=0			!cripted
	   else
	      d$crpt(b)=1
	   endif
c
	   d$froz(b)=1				!killed records frozen
c
	else					!regular base
	   strname(1:)=' '			!data base name
	   strname(1:)=gpage(1)
	   d$bdes(b)(1:)=' '			!description
	   d$bdes(b)=gpage(2)
	   if (istrip_(gpage(3)).le.0) then	!first record #
	      irec=1				!default = 1
	   else
	      call rdivar_(gpage(3),rec,gpics(3),erro)
	      if (erro.ne.0) goto 90004		!read error
	      irec=rec
	   endif
	   if (gpage(4)(1:1).eq.'y') then
	      d$crpt(b)=0			!cripted
	   else
	      d$crpt(b)=1
	   endif
	   if (gpage(5)(1:1).eq.'y') then
	      d$froz(b)=0			!available
	   else
	      d$froz(b)=1			!frozen
	   endif
	endif
c
	d$offs(b)=d$unus - irec + 1		!compute record# offset
c
c	Field characteristics
c
	d$dflt(bcur)(1:)=' '			!default values template
	f=0					!field#
	pos2=1
	totlen=0				!just in case...
	do 11020 k = 1, nfmax
	   tmplk=(k-1)*2+1			!field mnemonic line
	   lim1=istrip_(fpage(tmplk))
	   if (fsta(k).eq.2.and.
     1         lim1.gt.0        ) then
c
	      totlen=totlen+d$siz(k,b)		!recompute total len
	      if (totlen.gt.myxusr) goto 90011	!??!!!
c
	      f=f+1				!field#
c
	      d$fmne(f,b)(1:)=' '		!field mnemonic
	      d$fmne(f,b)=fpage(tmplk)		!...
	      d$fdes(f,b)=' '			!description
	      d$fdes(f,b)=fpage(tmplk+1)	!...
c
	      if (f.ne.k) then			!if different sequence #, copy
	         fsta(f)=2			!field defined
	         tmplf=(f-1)*2+1		!field mnemonic line
	         fpage(tmplf)(1:)=' '		!field mnemonic
	         fpage(tmplf)=fpage(tmplk)	!...
	         fpage(tmplf+1)(1:)=' '		!field description
	         fpage(tmplf+1)=fpage(tmplk+1)	!...
	         d$type(f,b)=d$type(k,b)	!type,
	         d$siz(f,b)=d$siz(k,b)		!size,
	         d$idx(f,b)=d$idx(k,b)		!KEY,
	         d$min(f,b)=d$min(k,b)		!minimum,
	         d$max(f,b)=d$max(k,b)		!maximum,
	         d$deci(f,b)=d$deci(k,b)	!dec. places,
	         d$fnam(f,b)(1:)=' '		!o.d.b. name
	         d$fnam(f,b)=d$fnam(k,b)
	         d$mast(f,b)=d$mast(k,b)	!master field
	         d$see(f,b)=d$see(k,b)		!see field
	      endif
c
c	      default values in the rigth place
c
	      width=d$siz(f,b)
	      pos1=pos2+1				!start pos
	      pos2=pos1+width-1				!end pos
	      call strgdf_(dfbuf,k,d$cbuf,width,erro)	!get default
	      if (erro.ne.0) then
	         if     (d$type(f,b).eq.r$) then	!no default
	            d$dflt(bcur)(pos1:pos2)=rnulltxt
	         endif
	         erro=0
	      else
	         if     (d$type(f,b).eq.r$) then
	            if (d$cbuf.eq.rempty) then		!no default
	               d$cbuf=rnulltxt
	            endif
	         elseif (d$type(f,b).eq.r8$) then	!no default at all
	            d$cbuf=ddnulltxt
	         endif
	         d$dflt(bcur)(pos1:pos2)=d$cbuf		!store
	         if (f.ne.k) then			!if different sequence #
	            call strddf_(dfbuf,k,erro)		!delete it
c	            if (erro.ne.0) noerror
	            call strpdf_(dfbuf,f,d$cbuf,	!store in right place
     1                           width,erro)
	            if (erro.ne.0) goto 90013		!error
	         endif
	      endif
	      d$pos(f,b)=pos1				!dont' forget !
	   endif
11020	continue
c
	do 1021 k = f+1, d$f
	   fsta(k)=0				!clean remaining fields
1021	continue
c
	d$nfld(bcur)=f				!# of fields
c
	goto 990				!return
c
c	Here if ^Z QUIT
c	===============
c
900	continue
c
	if (new) call frebas_(bcur)		!new structure,free base context
c
	goto 90001				!command execution suspended
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	execution suspended (^Z quit)
90001	continue
	erro=1
	goto 99000				!set error and return
c	internal error (unknown screen)
90002	continue
	erro=2
	goto 99000				!set error and return
c	internal error (unknown return code from VEDITS)
90003	continue
	erro=3
	goto 99000				!set error and return
c	internal error (read/write error)
90004	continue
	erro=4
	goto 99000				!set error and return
c	internal error (bad field type detected)
90005	continue
	erro=5
	goto 99000				!set error and return
c	internal error (unknown or unimplemented current field type)
90006	continue
	erro=6
	goto 99000				!set error and return
c	internal error (can't close or get first/last rec's of o.d.b)
90007	continue
	erro=7
	goto 99000				!set error and return
c	no base or field specified
90008	continue
	erro=8
	goto 99000				!set error and return
c	internal error (default value vanished!)
90009	continue
	erro=9
	goto 99000				!set error and return
c	internal error (found wrong check digit!)
90010	continue
	erro=10
	goto 99000				!set error and return
c	internal error (record lenght exceeds maximum!)
90011	continue
	erro=11
	goto 99000				!set error and return
c	internal error (wrong base channel or empty base name!)
90012	continue
	erro=12
	goto 99000				!set error and return
c	internal error (can't get/store default value!)
90013	continue
	erro=13
	goto 99000				!set error and return
c	internal error (display NEW data base structure!)
90014	continue
	erro=14
	goto 99000				!set error and return
c	batch user, can't use the editor
90015	continue
	erro=15
	goto 99000				!set error and return
c
c	Set error and return
c
99000	continue
	call errset_('STREDT',erro)
	if (prop.le.0) then
	   base=bcur				!return current base anyway
	endif
	goto 990				!return
c
c	Return
c	======
c
990	continue
c
c	Restore aliens/links
c
	if (prop.gt.0) then
	   b=prop
	   d$race(b)=r$pp			!property
	   d$pdim(b)=1				!dimension = 1
	   d$psiz(b)=0				!size of elements
	   d$pdec(b)=0				!decimal places
	else
	   b=base
	endif
c
	if     (dolinks) then			!restore links
	   call i$lnks_(b)
	elseif (dal.gt.0) then			!restore aliens
	   do k = 1, dal
	      call i$alie_(b,tmpmne(k),tmptyp(k))
	   enddo
	endif
c
c	Go away now
c
	if (prop.le.0) then
	   base=bcur				!return current base anyway
	endif
c
	if (.not.s$set(s$talk)) then
	   call tty_echo_(.false.)		!as before
	endif
c
	return
c
c	Formats
c	=======
c
	include 'fmt:STREDT.fmt'
c
	end
c
c
c
c
	subroutine credt_(base,alien,edit,strname,new,full,erro)
c	********************************************************
c
	implicit none
c
	integer base,alien,erro
	logical edit,new,full
	character*(*) strname
c
c	Description
c	===========
c
c	Implements CREATE, MODIFY and DISPLAY "creatures" STRUCTURE in screen
c	mode (SET SCREEN ON).
c
c	ALIEN =	p$	properties
c		s$	series
c		...
c
c	If EDIT = .true., edit structure;
c	If EDIT = .false., show structure.
c
c	If NEW = .true., a new struct. will be created/modified/shown;
c	if NEW = .false., an existing struct. will be modified/shown.
c
c	STRNAME will be used as structure name to edit, if not empty.
c
c	This procedure uses VEDITS with mode = 4 or 5 if editing, mode = 6
c	if showing structure.
c
c	Editor in mode 4/5 returns ?STAT 	>  0	^Z EXIT
c						=  0	^Z QUIT
c					  	-1	<ret> at the bottom
c					  	-2	up_arrow
c						-3	down_arrow
c						-4	gold/up_arrow
c						-5	gold/down_arrow
c						-6	help or gold/help
c
c	Editor in mode 7/8 returns ?STAT 	>  0	^Z EXIT
c						=  0	^Z QUIT
c					  	-1	<ret> ANYWHERE
c					  	-2	up_arrow
c						-3	down_arrow
c						-4	gold/up_arrow
c						-5	gold/down_arrow
c						-6	help or gold/help
c
c	Editor in mode 9/10 returns ?STAT 	>  0	^Z EXIT
c						=  0	^Z QUIT
c					  	-1	<ret> ANYWHERE
c					  	-2	up_arrow
c						-3	down_arrow at THE END of
c							page,OPEN LINE elsewuere
c						-4	gold/up_arrow
c						-5	gold/down_arrow
c						-6	help or gold/help
c
c	Var
c	===
c
	include 'own:DBAG0.OWN'
	include 'own:DBAGB.OWN'
	include 'own:dbagd.own'
	include 'own:vedit.own'
	include 'own:stredt.own'
c
	integer		quit,			!^Z QUIT
     1   		ret,			!<ret>
     1   		up,			!UP_ARROW
     1   		down,			!DOWN_ARROW
     1   		g_up,			!<GOLD>/UP_ARROW
     1   		g_down,			!<GOLD>/DOWM_ARROW
     1   		help			!HELP or <GOLD>/HELP
c
	parameter
     1   		( quit=0, ret=-1, up=-2, down=-3, g_up=-4,
     1   		  g_down=-5, help=-6 )
c
	logical
     1   		dokill,doinsert,crdohlp
	character*80
     1   		whtmsg
	character*30
     1   		crmssg(crpline)		!creature name
	character*(1)
     1   		crhlp(1)		!help message space
	integer
     1   		crmode,crstt,crsize,crsmax,crkind(crpline),
     1			crmsiz(crpline),
     1			crmini(crpline),crmaxi(crpline),
     1   		crblink(crpline),crtyp(crpline),crpsiz,
     1			crtop,crmarg,crlx,crcx,crused,crstat
	integer
     1   		k,kk,p,pidx,oldp,b,valmax,perr,cr1siz,form,f,fidx,
     1			df,dal,dtype,pmax
	character*30
     1   		cr1msg
	integer
     1   		screen,edtlin
	real
     1   		wuser
c
	logical
     1   		inuse,fexist,outopn
	integer
     1   		lim1,lim2,aliensz
	character*1
     1   		bell,yn
	character*1
     1   		pnam1*(cm$l1),		!alien name (scratch)
     1   		pnam2*(cm$l1)		!  "      "         "
c
	character*30
     1			curralien		!current alien name

	integer	b2,upd2,mod2,irace,idim,isize,ideci
	character*30 race
	character*10 owname,basename
c
c	Unused ...
c
	integer term
c
	external istrip_,tty_putc_,tty_getc_,tty_echo_,strchl_
	integer istrip_,tty_getc_,tty_echo_,ttychr,ttypad
c
c	begin
c	=====
c
	call errclr_('CREDT')			!clear errors
	erro=0
c
	if (us$bat) goto 90004		!batch user, can't use the editor
c
	curralien(1:)=' '
	if     (alien.eq.p$) then
	   curralien='property'
	elseif (alien.eq.s$) then
	   curralien='series'
	elseif (alien.eq.mm$) then
	   curralien='"memo"'
	else
	   goto 90005			!????
	endif
	aliensz=istrip_(curralien)
	if (aliensz.le.0) aliensz=1	!...
c
	wuser=0.0				!EDTMSG: don't wait
c
	if (.not.new) then		!*** OLD structure
	   if (istrip_(strname).le.0) goto 90002	!structure name empty
	else
	   if (.not.edit) goto 90003		!display NEW structure ???
	endif
c
c	Miscellaneous
c	-------------
c
	bell=char(7)
c
c	Clean screen DATA area
c	----------------------
c
	do 1002 k = 1, crpline
	   crpage(k)(1:)=' '
1002	continue
c
c	Initialize editor
c	-----------------
c
c	message lines
c
	edtlin=24				!VEDITS_ messages at the bottom
c
	crdohlp=.true.				!except for F* screen (bug...)
c
c	initialize "text" for all screens, except field types (edit/noedit)
c
c	alien list
c
	write (cr1msg,108) curralien(1:aliensz)	!name of creature
	cr1siz=istrip_(cr1msg)			!mssg size
c
	crmarg=-1				!margin
c
	p=0
	do 1003 k = 1, d$f
	   crmssg(k)(1:)=' '			!name line
	   crmssg(k)=cr1msg
	   p=p+1				!insert alien number
	   write (crmssg(k)(20:22),fmt='(i3.3)',err=90001) p
	   crmsiz(k)=cr1siz			!mssg size
	   crpics(k)=cm$l1			!alien size
1003	continue
c
c	initialize "text" for screen header
c
	lim1=istrip_(strname)
	if (edit) then
	   if (new) then
	      write (whtmsg,10110)		!creating new struc.
	1            curralien(1:aliensz),
	1            strname(1:lim1)
	   else					!modifying old struc.
	      if (full) then
	         write (whtmsg,10121)		!full
	1               curralien(1:aliensz),
	1               strname(1:lim1)
	      else
	         write (whtmsg,10122)		!not full
	1               curralien(1:aliensz),
	1               strname(1:lim1)
	      endif
	   endif
	else
	   write (whtmsg,10130)			!displaying struc.
	1         curralien(1:aliensz),
	1         strname(1:lim1)
	endif
c
	call vtext_(whtmsg,1,1,2)		!line 1
c
c	NEW/OLD structure
c	=================
c
c	old aliens
c	----------
c
	p=0
c
	if (new) then			!*** NEW structure
	   do k = 1, d$f
	      crpage(k)(1:)=' '		!no alien
	   enddo
	else				!*** OLD structure
	   do k = 1, d$nfld(base)
	      if (d$type(k,base).eq.alien) then
	         p=p+1
	         crpage(p)(1:)=' '		!alien name
	         crpage(p)=d$fmne(k,base)
	      endif
	   enddo	      
	   do kk = p+1, d$f			!clean rest of it
	      crpage(kk)(1:)=' '
	   enddo
	endif
c
	oldp=p
c
c	If not FULL editing and no property name, return
c
	if (.not.full.and.
	1   oldp.le.0     ) goto 990		!just return
c
c	Allow user to open new lines if editing structure
c
	if (edit.and.full) then
	   crmode=9				!NEW LINE anywhere and if
						!DOWN-ARROW at the bottom
	else
	   crmode=7				!exit if <ret> anywhere
	endif
c
	if (.not.full) then
	   crused=oldp				!# of base aliens
	else
	   crused=d$f
	endif
c
c	Set alien type/blink/cursor
c	---------------------------
c
	do 1004 k = 1, d$f
	   crkind(k)=128			!creature name type
	   crtyp(k)=vfrw$			!read/write
	   crblink(k)=vedbli			!blink
1004	continue
	crlx=1					!cursor start line
	crcx=1					!cursor start column
c
c
c	>>>>>> CREATE/MODIFY/DISPLAY STRUCTURE
c	======================================
c
90	continue
c
c	Clean screen
c	------------
c
	call erase_page_(2,1)			!clean screen from line 2...
c
c	Initialize structure edit main loop
c	-----------------------------------
c
	crtop=-1
c
c	Main loop here
c	==============
c
99	continue
c
c	alien list (name)
c	=================
c
	crstt=9					!editor first line
	crsize=22				!and last
	crpsiz=crused
	if (crsize.gt.crstt+crused-1) crsize=crstt+crused-1
	crsmax=crsize
c
	crlx=1					!make sure screen starts at 1
	crcx=1
c
200	continue
c
	dokill=.false.				!no ^Z KILL
	doinsert=.false.			!no ^Z INSERT
	call vedits_(strchl_,crmode,crstt,crsize,crtop,crmarg,crlx,crcx,
     1               crmssg,
     1   	     crmsiz,crpage,crpsiz,crused,crmini,crmaxi,crpics,crkind,
     1   	     term,xpos,ypos,crblink,edtlin,crdohlp,crhlp,crsmax,
     1               crstat,crtyp,dokill,doinsert,erro)
	if (erro.ne.0) goto 990			!error, carry
c
c	screen processing
c	-----------------
c
	if     (crstat.eq.quit) goto 900	!***^Z QUIT (quit now)
c
	if (crstat.eq.help) then		!***HELP or GOLD/HELP
	   call strhlp_(crkind(crlx),edtlin,1,wuser)
	   if (edit.and.full) then
	      crmode=10				!NEW LINE anywhere and if
						!DOWN-ARROW at the bottom
	   else
	      crmode=6				!exit if <ret> anywhere
	   endif
	   goto 200				!back to editor
	endif
c
	if (crstat.gt.0) then			!***^Z EXIT
	   goto 750
	endif
c
	if (edit.and.full) then
	   crmode=9				!NEW LINE anywhere and if
						!DOWN-ARROW at the bottom
	else
	   crmode=7				!exit if <ret> anywhere
	endif
	if (crstat.eq.ret) then			!<ret>
	   crlx=crlx+1				!next line
	   crcx=1				!col 1
	endif
	goto 200				!back to editor
c
c
c	Here if ^Z EXIT when editing structure
c	======================================
c
c	Check alien names (duplicated). Ask user if everything ok or if
c	he (or she) wants to review structure.
c	When ok, set/complete memory context and return.
c
750	continue
c
c	Check repeated/empty/used alien names
c	-------------------------------------
c
	if (full) then
	   pmax=d$f
	else
	   pmax=oldp
	endif
c
	basename=d$unam(base)			!my future papa
	call uc8to7_(basename)
	p=0					!aliens
	do 1013 k = 1, pmax
	   lim1=istrip_(crpage(k))
	   if (lim1.le.0) then
	      if (full) then
c	         ok, ignore empty names
	      else
	         goto 766			!restricted, can't be left empty
	      endif
	   else
	      pnam1(1:)=' '			!check repeated names
	      pnam1(1:)=crpage(k)(1:lim1)
	      call uc8to7_(pnam1(1:lim1))
c
c	      search previous same-type aliens
c
	      do kk = 1, k-1
	         lim2=istrip_(crpage(kk))
	         if (lim2.gt.0) then
	            pnam2(1:)=' '
	            pnam2=crpage(kk)(1:lim2)
	            call uc8to7_(pnam2(1:lim2))
	            if (pnam1.eq.pnam2) then
	               perr=kk			!alien#
	               goto 765			!already exists
	            endif
	         endif
	      enddo
c
c	      search old different-type aliens
c
	      do kk = 1, dal
	         dtype=tmptyp(kk)
	         if (dtype.ne.alien) then
	            pnam2(1:)=' '
	            pnam2=crpage(kk)(1:lim2)
	            call uc8to7_(pnam2(1:lim2))
	            if (pnam1.eq.pnam2) then
	               perr=k			!alien#
	               goto 765			!already exists
	            endif
	         endif
	      enddo
c
c	      search common fields as well
c
	      do kk = 1, d$nfld(base)
	         dtype=d$type(kk,base)
	         if (dtype.le.ftusr$) then
	            lim2=10
	            pnam2(1:)=' '
	            pnam2=d$fmne(kk,base)
	            call uc8to7_(pnam2(1:lim2))
	            if (pnam1.eq.pnam2) then
	               perr=k			!alien#
	               goto 765			!already exists
	            endif
	         endif
	      enddo
c
c	      see if aliens already exist with other owner base
c
 	      upd2=-1
	      mod2=0
	      call open_(b2,pnam1,upd2,mod2,outopn,erro)
	      if (erro.ne.0) then
	         if (d$rsub.eq.'OPNBAS'.and.
	1            erro.eq.3              ) then
c	            ok, no such base
	         else
	            perr=k			!alien#
	            goto 765			!already exists or ???
	         endif
	      else				!already exists
	         call zrace_(b2,race,irace,idim,isize,ideci,erro)
c	         if (error) noerror
	         if (irace.eq.alien) then	!myself ?
	            owname=d$ownb(b2)		!owner base
	            call uc8to7_(owname)
	            if (basename.eq.owname) then
c	               ok, myself
	            else
	               perr=k			!alien#
	               goto 765			!already exists
	            endif
	         else
	            perr=k			!alien#
	            goto 765			!already exists
	         endif
	      endif
	      p=p+1
	   endif
1013	continue
c
	goto 780				!structure ok ?
c
c	alien name already exists
765	continue
c
	write (mssg(1:),22099) curralien(1:aliensz)!warning
	write (mssg(istrip_(mssg)+1:),fmt='(i3)',err=90001) perr!alien#
	call erase_line_(edtlin-1,1)		!erase line
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin-1,1,wuser)
	goto 7656
c
c	restricted editing, name can't be left empty
766	continue
c
	write (mssg(1:),21099)
	call erase_line_(edtlin-1,1)		!erase line
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin-1,1,wuser)
	goto 7656
c
7656	continue
	write (mssg(1:),21199)			!<ret> to go back
	call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	call padcmd_(d$cmdi,ttypad,ttychr,erro)
c	if (erro.ne.0) noerror
	goto 90					!go back to main editing loop
c
c	Structure ok (?)
c	----------------
c
780	continue
c
	if (p.le.0) then
	   goto 850				!no mase at all, proceed
	else
	   write (mssg(1:),1229)
	   write (mssg(istrip_(mssg)+1:),fmt='(i3)',err=90004) p!# of names
	   write (mssg(istrip_(mssg)+1:),1239) curralien(1:aliensz)
	   call erase_line_(edtlin-1,1)	!clean line
	   call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin-1,1,wuser)
	   write (mssg(1:),1228)		!<ret> to proceed
	   call edtmsg_(mssg(1:istrip_(mssg)+1),edtlin,1,wuser)
	   call padcmd_(d$cmdi,ttypad,ttychr,erro)
c	   if (erro.ne.0) noerror
	   call erase_line_(edtlin-1,1)	!clean line
	   if (ttypad.le.0.and.ttychr.eq.13) then	!<ret>
	      goto 850				!ok, proceed
	   else
	      goto 90				!loop back, edit structure again
	   endif
	endif
c
c	^Z EXIT and structure ok
c	------------------------
c
c
850	continue
c
c	Update structure (insert new aliens)
c
	df=0				!last user data field
	dal=0				!# of old aliens
c
	do k = 1, d$nfld(base)
	   dtype=d$type(k,base)
	   if (dtype.le.ftusr$) then
	      df=k
	   else
	      dal=dal+1
	      tmpmne(dal)=d$fmne(k,base)
	   endif
	enddo
c
	d$nfld(base)=df			!forget non-user data fields
c
c	Copy properties
c
	if (alien.ne.p$) then		!copy old properties
	   do k = 1, dal
	      dtype=tmptyp(k)
	      if (dtype.eq.p$) then
	         call i$alie_(base,tmpmne(k),p$)	!add alien to structure
	      endif
	   enddo
	else				!copy new properties
	   if (p.gt.0) then		!if any
	      do k = 1, d$f
	         if (istrip_(crpage(k)(1:10)).gt.0) then
	            call i$alie_(base,crpage(k)(1:10),p$)!add alien to structure
	         endif
	      enddo
	   endif
	endif
c
c	Copy series
c
	if (alien.ne.s$) then		!copy old series
	   do k = 1, dal
	      dtype=tmptyp(k)
	      if (dtype.eq.s$) then
	         call i$alie_(base,tmpmne(k),s$)	!add alien to structure
	      endif
	   enddo
	else				!copy new series
	   if (p.gt.0) then		!if any
	      do k = 1, d$f
	         if (istrip_(crpage(k)(1:10)).gt.0) then
	            call i$alie_(base,crpage(k)(1:10),s$)!add alien to structure
	         endif
	      enddo
	   endif
	endif
c
c	Copy memos
c
	if (alien.ne.mm$) then		!copy old memos
	   do k = 1, dal
	      dtype=tmptyp(k)
	      if (dtype.eq.mm$) then
	         call i$alie_(base,tmpmne(k),mm$)	!add alien to structure
	      endif
	   enddo
	else				!copy new memos
	   if (p.gt.0) then		!if any
	      do k = 1, d$f
	         if (istrip_(crpage(k)(1:10)).gt.0) then
	            call i$alie_(base,crpage(k)(1:10),mm$)!add alien to struct.
	         endif
	      enddo
	   endif
	endif
c
	goto 900			!return
c
c	Here if ^Z QUIT
c	===============
c
900	continue
c
	goto 990				!just return
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	internal error (read/write error)
90001	continue
	erro=1
	goto 99000				!set error and return
c	internal error (wrong base channel or empty base name!)
90002	continue
	erro=2
	goto 99000				!set error and return
c	internal error (display NEW structure!)
90003	continue
	erro=3
	goto 99000				!set error and return
c	batch user, can't use the editor
90004	continue
	erro=4
	goto 99000				!set error and return
c	unknown creature
90005	continue
	erro=5
	goto 99000				!set error and return
c
c	Set error and return
c
99000	continue
	call errset_('CREDT',erro)
c
	goto 990				!return
c
c	Return
c	======
c
990	continue
c
	if (.not.s$set(s$talk)) then
	   call tty_echo_(.false.)		!as before
	endif
c
	return
c
c	Formats
c	=======
c
	include 'fmt:credt.fmt'
c
	end
c
c
c
c
	subroutine strhlp_(type,line,col,wait)
c	**************************************
c
	implicit none
c
	integer type,line,col
	real wait
c
c	Description
c	===========
c
c	Call EDTMSG_ to display help message for line type TYPE at line
c	LINE, column COL, waiting WAIT seconds before erasing help line.
c
c	Var
c	===
c
	include 'own:dbagthin.own'
c
	external istrip_
	integer istrip_
	character*80 msg
	integer t,lim1
c
	msg(1:)=' '
	msg(1:)=' HELP:'
c
	t=type-100
c
	goto ( 1, 2, 3, 4, 5, 6, 7, 8,99,99,11,12,13,
     1        14,15,16,17,18,19,20,21,22,23,24,25,26,
	1     27,28) t
c
	write (msg(istrip_(msg)+3:),9100)	!can't help you
	goto 98
c
1	write (msg(istrip_(msg)+3:),9101)
	goto 98
2	write (msg(istrip_(msg)+3:),9102)
	goto 98
3	write (msg(istrip_(msg)+3:),9103)
	goto 98
4	write (msg(istrip_(msg)+3:),9104)
	goto 98
5	write (msg(istrip_(msg)+3:),9105)
	goto 98
6	write (msg(istrip_(msg)+3:),9106)
	goto 98
7	write (msg(istrip_(msg)+3:),9107)
	goto 98
8	write (msg(istrip_(msg)+3:),9108)
	goto 98
11	write (msg(istrip_(msg)+3:),9111)
	goto 98
12	write (msg(istrip_(msg)+3:),9112)
	goto 98
13	write (msg(istrip_(msg)+3:),9113)
	goto 98
14	write (msg(istrip_(msg)+3:),9114)
	goto 98
15	continue
	if (reals) then
	   write (msg(istrip_(msg)+3:),9115)
	else
	   write (msg(istrip_(msg)+3:),9215)
	endif
	goto 98
16	write (msg(istrip_(msg)+3:),9116)
	goto 98
17	write (msg(istrip_(msg)+3:),9117)
	goto 98
18	write (msg(istrip_(msg)+3:),9118)
	goto 98
19	write (msg(istrip_(msg)+3:),9119)
	goto 98
20	write (msg(istrip_(msg)+3:),9120)
	goto 98
21	write (msg(istrip_(msg)+3:),9121)
	goto 98
22	write (msg(istrip_(msg)+3:),9122)
	goto 98
23	write (msg(istrip_(msg)+3:),9123)
	goto 98
24	write (msg(istrip_(msg)+3:),9124)
	goto 98
25	write (msg(istrip_(msg)+3:),9125)
	goto 98
26	write (msg(istrip_(msg)+3:),9126)
	goto 98
27	write (msg(istrip_(msg)+3:),9127)
	goto 98
28	write (msg(istrip_(msg)+3:),9128)
	goto 98
c
98	continue
	lim1=istrip_(msg)+1
	if (lim1.gt.80) lim1=80
	call edtmsg_(msg(1:lim1),line,col,wait)	!display message
c
99	continue
c
	return
c
c	Formats
c	=======
c
	include 'fmt:stredt.fmt'
c
	end
c
c
c
c
	subroutine strfrs_(erro)
c	************************
c
	implicit none
c
	integer erro
c
c	Description
c	===========
c
c	For current base and current field, restore field related
c	screens.
c
c	Var
c	===
c
	include 'own:dbag0.own'
	include 'own:stredt.own'
c
	external istrip_
	integer istrip_
	integer k,min,max,def,width,p,nline,rest,pos1,pos2,lim1,mydcur,mywcur
	integer b2,mast,see
	double precision dd
	character*10 fmnem
c
	real rdef,rmax,rmin
	integer imax,imin
	character*4 txtdef
	equivalence (rdef,txtdef)
	equivalence (imin,rmin)
	equivalence (imax,rmax)
c
	call errclr_('STRFRS')			!clear error
	erro=0
c
	if (fcur.le.0) return			!no field to save
	if (fsta(fcur).le.0) return		!never used field
c
c	Restore field
c	-------------
c
	tcur=d$type(fcur,bcur)	 		!field type
	if (tcur.gt.0) then
c
	tpage(1)(1:2)=ft$(tcur)(1:2)		!T page field type
	if (d$idx(fcur,bcur).eq.2) then
	   tpage(2)='y'				!field is KEY
	else
	   tpage(2)='n'				!it isn't
	endif
	if (d$oblg(fcur,bcur).eq.1) then
	   tpage(3)='y'				!field is MANDATORY
	else
	   tpage(3)='n'				!it isn't
	endif
c
c R* screen
c
	   width=0				!width defined ?
	   mydcur=0				!decimal places ?
c
	   if     (tcur.eq.n$) then		!R1 page (integer)
c
	      width=d$siz(fcur,bcur)		!field size
	      r1page(1)(1:)=' '
	      r1page(2)(1:)=' '
	      r1page(3)(1:)=' '
	      if (width.gt.0) then
	         min=d$min(fcur,bcur)		!minimum value
	         max=d$max(fcur,bcur)		!maximum value
	         if (fmin(fcur).eq.1) then
	            call wrivar_(r1page(1),min,width,erro)
	            if (erro.ne.0) goto 101	!write error, ignore
101	            continue
	         endif
	         if (fmax(fcur).eq.1) then
	            call wrivar_(r1page(2),max,width,erro)
	            if (erro.ne.0) goto 102	!write error, ignore
102	            continue
	         endif
	         call strgdf_(dfbuf,fcur,d$cbuf,width,erro)
	         if (erro.ne.0) then				!no default
	            erro=0
	         else
	            r1page(3)(1:width)=d$cbuf(1:width)
	         endif
	      endif
	      if (width.gt.0) mywcur=width-1			!remake mywcur
c
	   elseif (tcur.eq.c$) then		!R2 page (string)
c
	      width=d$siz(fcur,bcur)			!field size
	      nline=width/r2slic			!total lines
	      rest=mod(width,r2slic)
	      if (rest.gt.0) nline=nline+1		!total lines
	      do 1024 k = 1, nline
	         r2page(k)(1:)=' '
1024	      continue
	      if (width.gt.0) then
	         call strgdf_(dfbuf,fcur,d$cbuf,width,erro)
	         if (erro.ne.0) then			!no default
	            erro=0
	         else
c
c	            string: special case
c
	            do 1023 k = 1, nline
	               r2pics(k)=r2slic			!field size
1023	            continue
	            if (rest.gt.0) then
	               r2pics(nline)=rest		!"fix" last line size
	            endif
c
	            pos2=0
	            do 1022 k = 1, nline
	               lim1=len(r2page(k))
	               if (lim1.gt.r2pics(k)) lim1=r2pics(k)
	               if (lim1.gt.0) then		!default
	                  pos1=pos2+1			!start pos
	                  pos2=pos1+lim1-1		!end pos
	                  r2page(k)(1:r2pics(k))=d$cbuf(pos1:pos2)
	               endif
1022	            continue
	         endif
	      endif
	      if (width.gt.0) mywcur=width	!remake mywcur
c
	   elseif (tcur.eq.db$) then		!R3 page (o.d.b.)
c
	      width=d$siz(fcur,bcur)		!field size
	      r3page(1)(1:)=' '
	      r3page(2)(1:)=' '
	      r3page(3)(1:)=' '
	      if (width.gt.0) then
	         r3page(1)=d$fnam(fcur,bcur)	!o.d.b name
	         b2=d$dbio(fcur,bcur)
	         if (b2.gt.0) then
	            mast=d$mast(fcur,bcur)
	            see=d$see(fcur,bcur)
	            if (mast.gt.0) then
	               r3page(2)=d$fmne(mast,b2)!master field
	            endif
	            if (see.gt.0) then
	               r3page(3)=d$fmne(see,b2)	!see field
	            endif
	         endif
c
	      endif
	      if (width.gt.0) mywcur=10		!remake mywcur
c
	   elseif (tcur.eq.x$) then		!R4 page (decimal)
c
	      width=d$siz(fcur,bcur)		!field size
	      mydcur=d$deci(fcur,bcur)		!decimal places
	      r4page(1)(1:)=' '
	      r4page(2)(1:)=' '
	      r4page(3)(1:)=' '
	      if (width.gt.0.and.mydcur.gt.0) then
	         min=d$min(fcur,bcur)		!minimum value
	         max=d$max(fcur,bcur)		!maximum value
	         if (fmin(fcur).eq.1) then
	            dd=min
	            dd=dd/(10.0**mydcur)
	            call wrfvar_(r4page(1),dd,width+1,mydcur,erro)
	            if (erro.ne.0) goto 90001	!write error
	         endif
	         if (fmax(fcur).eq.1) then
	            dd=max
	            dd=dd/(10.0**mydcur)
	            call wrfvar_(r4page(2),dd,width+1,mydcur,erro)
	            if (erro.ne.0) goto 90001	!write error
	         endif
	         call strgdf_(dfbuf,fcur,d$cbuf,width,erro)	!default
	         if (erro.ne.0) then				!no default
	            erro=0
	         else
	            if (istrip_(d$cbuf).gt.0) then
	               p=width-mydcur+1
	               r4page(3)(1:p-1)=d$cbuf(1:p-1)
	               r4page(3)(p:p)='.'
	               r4page(3)(p+1:p+1+mydcur-1)=d$cbuf(p:)
	            endif
	         endif
	      endif
	      if (width.gt.0) mywcur=width-1	!remake mywcur
c
	   elseif (tcur.eq.d$) then		!R5 page (date)
c
	      width=d$siz(fcur,bcur)		!field size
	      r5page(1)(1:)=' '
	      r5page(2)(1:)=' '
	      r5page(3)(1:)=' '
	      if (width.gt.0) then
	         min=d$min(fcur,bcur)		!minimum value
	         max=d$max(fcur,bcur)		!maximum value
	         if (fmin(fcur).eq.1.and.
     1              min.ge.19000101) then	!1/1/1900
	            call txtdat_(min,r5page(1)(1:r5pics(1)),erro)	!minimum
	            if (erro.ne.0) then
	               r5page(1)(1:)=' '
	               erro=0
	            endif
	         endif
	         if (fmax(fcur).eq.1.and.
     1              max.ge.19000101) then	!1/1/1900
	            call txtdat_(max,r5page(2)(1:r5pics(2)),erro)	!maximum
	            if (erro.ne.0) then
	               r5page(2)(1:)=' '
	               erro=0
	            endif
	         endif
	         call strgdf_(dfbuf,fcur,d$cbuf,width,erro)
	         if (erro.ne.0) then				!no default
	            erro=0
	         else
	            if (istrip_(d$cbuf).gt.0) then
	               call rdivar_(d$cbuf,def,width,erro)
	               if (erro.ne.0) goto 103		!read error, ignore
	               if (def.ge.19000101) then		!1/1/1900
	                  call txtdat_(def,r5page(3)(1:r5pics(3)),erro)
	                  if (erro.ne.0) then
	                     r5page(3)(1:)=' '
	                     erro=0
	                  endif
	               endif
103	               continue
	            endif
	         endif
	      endif
	      if (width.gt.0) mywcur=11		!remake mywcur
c
	   elseif (tcur.eq.l$) then		!R6 page (logical)
c
	      width=d$siz(fcur,bcur)		!field size
	      r6page(1)(1:)=' '
	      if (width.gt.0) then
	         call strgdf_(dfbuf,fcur,d$cbuf,width,erro)
	         if (erro.ne.0) then			!no default
	            erro=0
	         else
	            r6page(1)(1:width)=d$cbuf(1:width)
	         endif
	      endif
	      if (width.gt.0) mywcur=1		!remake mywcur
c
	   elseif (tcur.eq.r$) then		!R7 page (real)
c
	      width=d$siz(fcur,bcur)		!field size
c
	      r7page(1)(1:)=' '
	      r7page(2)(1:)=' '
	      r7page(3)(1:)=' '
	      if (width.gt.0) then
	         imin=d$min(fcur,bcur)		!minimum value
	         if (fmin(fcur).eq.1) then
	            write (r7page(1)(1:r7pics(1)),*,err=90001) rmin
	            call rjust_(r7page(1)(1:r7pics(1)))
	         endif
	         imax=d$max(fcur,bcur)		!maximum value
	         if (fmax(fcur).eq.1) then
	            write (r7page(2)(1:r7pics(2)),*,err=90001) rmax
	            call rjust_(r7page(2)(1:r7pics(2)))
	         endif
	         call strgdf_(dfbuf,fcur,txtdef,width,erro)
	         if (erro.ne.0) then		!no default
	            erro=0
	         else
	            if (istrip_(txtdef).gt.0) then
	               write (r7page(3)(1:r7pics(3)),*,err=90001) rdef
	               call rjust_(r7page(3)(1:r7pics(3)))
	            endif
	         endif
	      endif
	      if (width.gt.0) mywcur=width		!remake mywcur
	   endif
c
	   if (width.le.0) then
	      wpage(1)(1:)=' '
	   else
	      call wrivar_(wpage(1),mywcur,wpics(1),erro)
	      if (erro.ne.0) goto 104		!write error, ignore
104	      continue
	   endif
c
	   if (mydcur.le.0) then
	      wpage(2)(1:)=' '
	   else
	      call wrivar_(wpage(2),mydcur,wpics(2),erro)
	      if (erro.ne.0) goto 105		!write error, ignore
105	      continue
	   endif
c
	endif
c
	return
c
c	Errors
c	------
c
c	internal error: read/write error
90001	continue
	erro=1
	goto 99000
c
99000	continue
	call errset_('STRFRS',erro)
	return
c
	end
c
c
c
c
	subroutine strfsc_(scr,erro)
c	****************************
c
	implicit none
c
	integer scr,erro
c
c	Description
c	===========
c
c	For current base and current field, save field related data for
c	screen SCR, if appliable. Clean everything if first time field
c	is used.
c
c	Var
c	===
c
	include 'own:dbag0.own'
	include 'own:stredt.own'
c
	integer istrip_
	external istrip_
	integer k,kk,l1,l1dec,l2,l2dec,lim1,lim2,deci,width,inwid,cwid,def
	integer min,max,pos1,pos2,rest,p,nline,form,b2,mast,see,sign
	character*10 fmnem
	integer typ,val,dec,lgth,p1,p2
	real rval
	character*40 intmsg
c
	real rdef,rmin,rmax
	integer imin,imax,idef
	character*4 txtdef
	equivalence (rmin,imin)
	equivalence (rmax,imax)
	equivalence (rdef,idef)
	equivalence (idef,txtdef)
c
	call errclr_('STRFSC')			!clear error
	erro=0
c
	if (bcur.le.0.or.fcur.le.0) return	!no current base/field, nops
c
c	Clean everything if never used before
c	-------------------------------------
c
	if (fsta(fcur).eq.0) then
c
c	   Clean memory context if first time field is used
c
	   fsta(fcur)=1
	   d$fnam(fcur,bcur)(1:)=' '		!file name for field (if o.d.b)
	   d$mast(fcur,bcur)=0			!master field
	   d$see(fcur,bcur)=0			!see field
	   d$type(fcur,bcur)=0			!field type
	   d$siz(fcur,bcur)=0			!field size
	   d$idx(fcur,bcur)=0			!field is NOT indexed, NOR key
	   d$deci(fcur,bcur)=0			!# of decimal places
	   d$oblg(fcur,bcur)=0			!field is not mandatory
	   d$dbio(fcur,bcur)=0			!other base channel
	   fmin(fcur)=0				!MINimum value not defined
	   fmax(fcur)=0				!MAXimum value not defined
	   call strddf_(dfbuf,fcur,erro)	!no default value
c
c	   T screen
c
	   tpage(1)(1:)=' '			!erase only TYPE: line
	   tpage(2)(1:)=' '			!KEY: line
	   tpage(2)(1:1)='n'
	   tpage(3)(1:)=' '			!MANDATORY: line
	   tpage(3)(1:1)=' '
c
c	   W screen
c
	   do 1023 k = 1, wpline
	      wpage(k)(1:)=' '			!W page
1023	   continue
c
	   if (tcur.le.0) return		!no current type, all done!
c
c	   R* screen
c
	   if     (tcur.eq.n$) then		!R1 page (integer)
	      do 1024 k = 1, r1plin
	         r1page(k)(1:)=' '			!R1 page
1024	      continue
c
	   elseif (tcur.eq.c$) then		!R2 page (string)
	      do 1025 k = 1, r2plin
	         r2page(k)(1:)=' '			!R2 page
1025	      continue
c
	   elseif (tcur.eq.db$) then		!R3 page (o.d.b.)
	      do 1026 k = 1, r3plin
	         r3page(k)(1:)=' '			!R3 page
1026	      continue
c
	   elseif (tcur.eq.x$) then		!R4 page (decimal)
	      do 1027 k = 1, r4plin
	         r4page(k)(1:)=' '			!R4 page
1027	      continue
c
	   elseif (tcur.eq.d$) then		!R5 page (date)
	      do 1028 k = 1, r5plin
	         r5page(k)(1:)=' '			!R5 page
1028	      continue
c
	   elseif (tcur.eq.l$) then		!R6 page (logical)
	      do 1029 k = 1, r6plin
	         r6page(k)(1:)=' '			!R6 page
1029	      continue
c
	   elseif (tcur.eq.r$) then		!R7 page (real)
	      do 1030 k = 1, r7plin
	         r7page(k)(1:)=' '			!R7 page
1030	      continue
	   endif
	endif
c
c	Save field
c	----------
c
	if (scr.eq.1) then			!G screen
c	   nops, nothing to save
	   if (fsta(fcur).le.0) fsta(fcur)=1	!used field
	   return
	endif
c
	if (scr.eq.2) then			!F screen
c	   nops, nothing to save
	   if (fsta(fcur).le.0) fsta(fcur)=1	!used field
	   return
	endif
c
	if (scr.eq.3) then			!T screen
	   if (tcur.gt.0) then
	      d$type(fcur,bcur)=tcur			!field type
	      if (tpage(2)(1:1).eq.'y') then
	         d$idx(fcur,bcur)=2			!field is KEY
	      else
	         d$idx(fcur,bcur)=0			!it isn't
	      endif
	      if (tpage(3)(1:1).eq.'y') then
	         d$oblg(fcur,bcur)=1			!field is MANDATORY
	      else
	         d$oblg(fcur,bcur)=0			!it isn't
	      endif
	   endif
	   if (fsta(fcur).le.0) fsta(fcur)=1	!used field
	   return
	endif
c
	if (scr.eq.4) then			!W screen
	   if (wcur.gt.0) then
	      if     (tcur.eq.n$) then
	         d$siz(fcur,bcur)=wcur+1
	      elseif (tcur.eq.c$) then
	         d$siz(fcur,bcur)=wcur
	      elseif (tcur.eq.db$) then
	         d$siz(fcur,bcur)=10
	      elseif (tcur.eq.x$) then
	         d$siz(fcur,bcur)=wcur+1
	      elseif (tcur.eq.d$) then
	         d$siz(fcur,bcur)=8
	      elseif (tcur.eq.l$) then
	         d$siz(fcur,bcur)=1
	      elseif (tcur.eq.r$) then
	         d$siz(fcur,bcur)=4
	      else
	         d$siz(fcur,bcur)=10		!all creatures have size = 10
	      endif
	      if (fsta(fcur).le.0) fsta(fcur)=1	!used field
	   endif
	   return
	endif
c
	if (scr.eq.5) then			!R* screen
c
	 if (tcur.gt.0) then
	   if     (tcur.eq.n$) then			!R1 page (integer)
	      if (wcur.gt.0) then
	         width=wcur+1				!new external size
	         inwid=width				!and internal
	         if (istrip_(r1page(1)).gt.0) then	!minimum
	            call rdivar_(r1page(1),min,width,erro)
	            if (erro.ne.0) goto 90001		!read error
	            d$min(fcur,bcur)=min
	            fmin(fcur)=1			!minimum defined
	         else
	            fmin(fcur)=0
	         endif
c
	         if (istrip_(r1page(2)).gt.0) then	!maximum
	            call rdivar_(r1page(2),max,width,erro)
	            if (erro.ne.0) goto 90001		!read error
	            d$max(fcur,bcur)=max
	            fmax(fcur)=1			!maximum defined
	         else
	            fmax(fcur)=0
	         endif
c
	         if (istrip_(r1page(3)).gt.0) then	!default
	            call strpdf_(dfbuf,fcur,r1page(3),inwid,erro)
	            if (erro.ne.0) goto 90001
	         else
	            call strddf_(dfbuf,fcur,erro)
c	            if (erro.ne.0) noerror
	         endif
c
	      endif
c
	   elseif (tcur.eq.c$) then			!R2 page (string)
	      if (wcur.gt.0) then
	         width=wcur				!new external size
	         inwid=width				!and internal
c
	         nline=inwid/r2slic			!total lines
	         rest=mod(inwid,r2slic)
	         if (rest.gt.0) nline=nline+1		!total lines
	         pos2=0
	         cwid=0
	         do 11030 k = 1, nline
	            lim1=len(r2page(k))
	            if (lim1.gt.r2pics(k)) lim1=r2pics(k)
	            lim2=istrip_(r2page(k))
		    if (lim2.gt.0) then
	               if (lim2.lt.lim1) then
	                  r2page(k)(lim2+1:lim1)=' '	!get rid of nulls...
	               endif
	            endif
	            if (lim1.gt.0) then			!default
	               cwid=cwid+lim1
	               pos1=pos2+1			!start pos
	               pos2=pos1+lim1-1			!end pos
	               d$cbuf(pos1:pos2)=r2page(k)
	            endif
11030	         continue
	         if (cwid.gt.0) then
	            call strpdf_(dfbuf,fcur,d$cbuf(1:pos2),cwid,erro)!default
	            if (erro.ne.0) goto 90001
	         else
	            call strddf_(dfbuf,fcur,erro)
c	            if (erro.ne.0) noerror
	         endif
c
	      endif
c
	   elseif (tcur.eq.db$) then			!R3 page (o.d.b.)
	      if (wcur.gt.0) then
	         width=10				!new external size
	         inwid=width				!and internal
	         d$fnam(fcur,bcur)=r3page(1)		!o.d.b. name
	         b2=d$dbio(fcur,bcur)			!and channel
c
	         d$mast(fcur,bcur)=0			!assume no master field
	         d$see(fcur,bcur)=0			!and no see field
c
	         if (istrip_(r3page(2)).gt.0) then	!master field
	            fmnem(1:)=' '
	            fmnem=r3page(2)
	            call znum_(b2,mast,fmnem,erro)!get field#
	            if (erro.eq.0.and.
	1               mast.gt.0      ) then
	                d$mast(fcur,bcur)=mast
	            endif
	         endif
c
	         if (istrip_(r3page(3)).gt.0) then	!see field
	            fmnem(1:)=' '
	            fmnem=r3page(3)
	            call znum_(b2,see,fmnem,erro)!get field#
	            if (erro.eq.0.and.
	1               see.gt.0      ) then
	                d$see(fcur,bcur)=see
	            endif
	         endif
c
	      endif
c
	   elseif (tcur.eq.x$) then			!R4 page (decimal)
	      if (wcur.gt.0) then
	         width=wcur+2				!new external size
	         inwid=wcur+1				!and internal
	         d$deci(fcur,bcur)=dcur
c
	         if (dcur.gt.0) then
	            l1=width-dcur-1			!ignore '.'
	            l2=l1+2
c
	            if (istrip_(r4page(1)).gt.0) then	!minimum
	               call rdivar_(r4page(1),l1dec,l1,erro)
	               if (erro.ne.0) goto 90001	!read error
	               call rdivar_(r4page(1)(l2:),l2dec,dcur,erro)
	               if (erro.ne.0) goto 90001	!read error
	               if (l1dec.ge.0) then
	                  sign=+1
	               else
	                  sign=-1
	                  l1dec=-l1dec
	               endif
	               d$min(fcur,bcur)=l1dec * (10.0**dcur) + l2dec
	               d$min(fcur,bcur)= sign * d$min(fcur,bcur)
	               fmin(fcur)=1		!minimum defined
	            else
	               fmin(fcur)=0
	            endif
c
	            if (istrip_(r4page(2)).gt.0) then	!maximum
	               call rdivar_(r4page(2),l1dec,l1,erro)
	               if (erro.ne.0) goto 90001	!read error
	               call rdivar_(r4page(2)(l2:),l2dec,dcur,erro)
	               if (erro.ne.0) goto 90001	!read error
	               if (l1dec.ge.0) then
	                  sign=+1
	               else
	                  sign=-1
	                  l1dec=-l1dec
	               endif
	               d$max(fcur,bcur)=l1dec * (10.0**dcur) + l2dec
	               d$max(fcur,bcur)= sign * d$max(fcur,bcur)
	               fmax(fcur)=1		!maximum defined
	            else
	               fmax(fcur)=0
	            endif
c
	            if (istrip_(r4page(3)).gt.0) then	!default
	               p=index(r4page(3),'.')
	               d$cbuf(1:p-1)=r4page(3)(1:p-1)
	               d$cbuf(p:)=r4page(3)(p+1:p+1+dcur-1)
	               call strpdf_(dfbuf,fcur,d$cbuf,inwid,erro)
	               if (erro.ne.0) goto 90001
	            else
	               call strddf_(dfbuf,fcur,erro)
c	               if (erro.ne.0) noerror
	            endif
c
	         else
	            dcur=0
	         endif
c
	      endif
c
	   elseif (tcur.eq.d$) then			!R5 page (date)
	      if (wcur.gt.0) then
	         width=11				!new external size
	         inwid=8				!and internal
c
	         if (istrip_(r5page(1)).gt.0) then	!minimum
	            call numdat_(d$min(fcur,bcur),r5page(1),r5pics(1),
     1                           form,erro)
	            if (erro.ne.0) goto 90001
	            fmin(fcur)=1			!minimum defined
	         else
	            fmin(fcur)=0
	         endif
c
	         if (istrip_(r5page(2)).gt.0) then	!maximum
	            call numdat_(d$max(fcur,bcur),r5page(2),r5pics(2),
     1                           form,erro)
	            if (erro.ne.0) goto 90001
	            fmax(fcur)=1			!maximum defined
	         else
	            fmax(fcur)=0
	         endif
c
	         if (istrip_(r5page(3)).gt.0) then	!default
	            call numdat_(def,r5page(3),r5pics(3),form,erro)
	            if (erro.ne.0) goto 90001
	            call wrivar_(d$cbuf,def,inwid,erro)
	            if (erro.ne.0) goto 90001		!read error
	            call strpdf_(dfbuf,fcur,d$cbuf,inwid,erro)
	            if (erro.ne.0) goto 90001
	         else
	            call strddf_(dfbuf,fcur,erro)
c	            if (erro.ne.0) noerror
	         endif
c
	      endif
c
	   elseif (tcur.eq.l$) then			!R6 page (logical)
	      if (wcur.gt.0) then
	         width=1
	         inwid=width				!and internal
c
	         if (istrip_(r6page(1)).gt.0) then	!maximum
	            call strpdf_(dfbuf,fcur,r6page(1),inwid,erro)!default
	            if (erro.ne.0) goto 90001
	         else
	            call strddf_(dfbuf,fcur,erro)
c	            if (erro.ne.0) noerror
	         endif
c
	      endif
c
	   elseif (tcur.eq.r$) then			!R7 page (real)
	      if (wcur.gt.0) then
	         width=15
	         inwid=4				!and internal
c
	         if (istrip_(r7page(1)).gt.0) then	!minimum
	            read (r7page(1),*,err=90001) rmin
	            d$min(fcur,bcur)=imin
	            fmin(fcur)=1			!minimum defined
	         else
	            fmin(fcur)=0
	         endif
	         if (istrip_(r7page(2)).gt.0) then	!maximum
	            read (r7page(2),*,err=90001) rmax
	            d$max(fcur,bcur)=imax
	            fmax(fcur)=1			!maximum defined
	         else
	            fmax(fcur)=0
	         endif
	         if (istrip_(r7page(3)).gt.0) then	!maximum
	            read (r7page(3),*,err=90001) rdef
	            call strpdf_(dfbuf,fcur,txtdef,inwid,erro)!default
	            if (erro.ne.0) goto 90001
	         else
	            call strddf_(dfbuf,fcur,erro)
c	            if (erro.ne.0) noerror
	         endif
c
	      endif
c
	   endif
c
	   if (fsta(fcur).le.0) fsta(fcur)=1	!used field
c
	 endif
c
	 return
c
	endif
c
c	Errors
c	------
c
c	internal error: read/write error
90001	continue
	erro=1
	goto 99000
c
99000	continue
	call errset_('STRFSC',erro)
	return
c
	end
c
c
c
c
	subroutine stridf_(wbuf,maxnbr,erro)
c	************************************
c
	implicit none
c
	character*(*) wbuf
	integer maxnbr,erro
c
c	Description
c	===========
c
c	For current base, initialize working areas WBUF reserved to handle
c	defaut values.
c
c	Var
c	===
c
	include 'own:dbag0.own'
	include 'own:strdef.own'
c
	integer istrip_
	external istrip_
	integer k
c
	call errclr_('STRIDF')			!clear error
	erro=0
c
	if (maxnbr.le.0.or.
     1      fldmax) 	goto 90001	!<0 or too many!
c
	maxdf$=maxnbr			!max # of fields
	lendf$=len(wbuf)		!work area size
	wbuf(1:)=' '			!clear work area
	do 1001 k = 1, maxdf$
	   flddf$(k)=0			!all space is free
1001	continue
	flddf$(maxdf$+1)=0		!end-of-slots
c
	return
c
c	Errors
c	------
c
c	internal error (#fields < 0 or too many)
90001	continue
	erro=1
	goto 99000
c
99000	continue
	call errset_('STRIDF',erro)
	return
c
	end
c
c
c
c
	subroutine strpdf_(wbuf,fld,deftxt,size,erro)
c	*********************************************
c
	implicit none
c
	character*(*) wbuf,deftxt
	integer fld,size,erro
c
c	Description
c	===========
c
c	For field FLD, save in WBUF its DEFTXT value with size SIZE.
c
c	Var
c	===
c
	include 'own:dbag0.own'
	include 'own:strdef.own'
c
	integer istrip_
	external istrip_
	integer k,kk,jj,jjj,j,pos,pos2,sz,lim1
	logical garbag
c
	call errclr_('STRPDF')			!set error
	erro=0
c
	if (fld.le.0) goto 90003		!no jokes...
c
	k=0					!free slot
	garbag=.false.				!no garbage
c
	do 1001 kk = 1, maxdf$
	   if (flddf$(kk).eq.0) then		!last (free) slot
	      k=kk
	      goto 100
	   endif
	   if (flddf$(kk).eq.-1) then
	      garbag=.true.			!remove garbage if you need
	   endif
	   if (flddf$(kk).eq.fld) then
	      flddf$(kk)=-1			!already exists, suppress it
	      garbag=.true.			!remove garbage if you need
	   endif
1001	continue
c
c	Free slot = k or 0 if none
c	Garbag=.true. if any garbage to remove
c
100	continue
c
	if (.not.garbag) then			!no garbage
	   if (k.le.0) goto 90002		!no slot available
	   if (k.le.1) then
	      pos=1				!next pos
	      sz=lendf$				!available room
	   else
	      pos=posdf$(k-1)+sizdf$(k-1)	!...
	      sz=lendf$-pos+1			!...
	   endif
	   if (size.gt.sz) goto 90001		!no room
	   goto 300				!ok, store text (slot k)
	else					!garbage
	   if (k.gt.0) then
	      if (k.le.1) then
	         pos=1				!next pos
	         sz=lendf$			!available room
	      else
	         pos=posdf$(k-1)+sizdf$(k-1)	!...
	         sz=lendf$-pos+1		!...
	      endif
	      if (size.gt.sz) then
	         call strcdf_(wbuf)		!no room, remove garbage
	         goto 220			!try again
	      else
	         goto 300			!ok, store text (slot k)
	      endif
	   else
	      call strcdf_(wbuf)		!no room, remove garbage
	      goto 220				!try again
	   endif
	endif
c
c	Try again
c
220	continue
c
	do 1002 kk = 1, maxdf$
	   if (flddf$(kk).eq.0) then
	      if (kk.le.1) then
	         pos=1				!next pos
	         sz=lendf$			!available room
	      else
	         pos=posdf$(kk-1)+sizdf$(kk-1)	!...
	         sz=lendf$-pos+1		!...
	      endif
	      if (size.gt.sz) then
	         goto 90001			!no room
	      else
	         k=kk
	         goto 300			!ok, store text (slot k)
	      endif
	   endif
1002	continue
	goto 90002				!no slot available
c
c	Store FLD DEFTXT into pos:, size SIZE, slot k
c
300	continue
c
cx	wbuf(pos:pos+size-1)=' '		!clean everything...
cx	lim1=istrip_(deftxt)
cx	if (lim1.gt.size) lim1=size		!????
cx	if (lim1.le.0) then
c	   nops
cx	else
cx	   pos2=pos+lim1-1
cx	   wbuf(pos:pos2)=deftxt(1:lim1)	!store
cx	endif
c
	pos2=pos+size-1
	wbuf(pos:pos2)=deftxt(1:size)	!store
c
	posdf$(k)=pos				!actual pos
	sizdf$(k)=size				!and size
	flddf$(k)=fld				!field #
c
	return
c
c	Errors
c	------
c
c	not enough room
90001	continue
	erro=1
	goto 99000
c
c	no available slot
90002	continue
	erro=2
	goto 99000
c
c	field# .le.0
90003	continue
	erro=3
	goto 99000
c
99000	continue
	call errset_('STRPDF',erro)
	return
c
	end
c
c
c
c
	subroutine strgdf_(wbuf,fld,deftxt,size,erro)
c	*********************************************
c
	implicit none
c
	character*(*) wbuf,deftxt
	integer fld,size,erro
c
c	Description
c	===========
c
c	For field FLD, read from WBUF its DEFTXT value and extend/truncate
c	it, left-justified, to size SIZE.
c
c	Var
c	===
c
	include 'own:dbag0.own'
	include 'own:strdef.own'
c
	integer istrip_
	external istrip_
	integer k,l,p1,p2,mysize
c
	call errclr_('STRGDF')			!set error
	erro=0
c
	if (size.le.0) goto 90002		!size .le. 0
c
	mysize=size
	if (mysize.gt.len(deftxt)) mysize=len(deftxt)
	if (mysize.le.0) return			!nops!
c
	do 1001 k = 1, maxdf$
	   if (flddf$(k).eq.0) goto 90001	!end-of-space, no such field
	   if (flddf$(k).eq.fld) then
	      deftxt(1:mysize)=' '
	      p1=posdf$(k)
	      p2=p1+sizdf$(k)-1
	      deftxt(1:mysize)=wbuf(p1:p2)
	      return				!return
	   endif
1001	continue
	goto 90001				!no such field
c
c	Errors
c	------
c
c	no such field
90001	continue
	erro=1
	goto 99000
c
c	size .le. 0
90002	continue
	erro=2
	goto 99000
c
c
99000	continue
	call errset_('STRGDF',erro)
	return
c
	end
c
c
c
c
	subroutine strddf_(wbuf,fld,erro)
c	*********************************
c
	implicit none
c
	character*(*) wbuf
	integer fld,erro
c
c	Description
c	===========
c
c	For field FLD, delete from WBUF its default value if any.
c
c	Var
c	===
c
	include 'own:dbag0.own'
	include 'own:strdef.own'
c
	integer k
c
	call errclr_('STRDDF')			!set error
	erro=0
c
	do 1001 k = 1, maxdf$
	   if (flddf$(k).eq.0) return		!end-of-space, no such field
	   if (flddf$(k).eq.fld) then
	      flddf$(k)=-1			!delete it
	      return				!return
	   endif
1001	continue
c
c	Errors
c	------
c
99000	continue
	call errset_('STRDDF',erro)
	return
c
	end
c
c
c
c
	subroutine strcdf_(wbuf)
c	************************
c
	implicit none
c
	character*(*) wbuf
c
c	Description
c	===========
c
c	Remove garbage from WBUF.
c
c	Var
c	===
c
	include 'own:dbag0.own'
	include 'own:strdef.own'
c
	integer istrip_
	external istrip_
	integer k,j,l,f1,f2,top,p1,p2,siz1,siz2,delta,nsh
c
	do 1001 k = 1, maxdf$			!all fields
	   if (flddf$(k).eq.0) then
	      top=k				!last field
	      goto 300				!all done
	   endif
	   if (flddf$(k).eq.-1) then
	      f1=k				!destination field
	      nsh=0				!# of shifted fields
c
	      do 1002 j = f1+1, maxdf$		!look for a "good" one
	         nsh=nsh+1
	         if (flddf$(j).eq.0) goto 200	!last field, all done
	         if (flddf$(j).gt.0) then
	            f2=j				!source field
	            write (6,11) f2,f1
11	            format ('   ',i2,' -> ',i2)
	            p2=posdf$(f2)			!source start pos
	            siz2=sizdf$(f2)			!source size
	            if (f1.eq.1) then
	               p1=1				!destination start pos
	            else
	               p1=posdf$(f1-1)+sizdf$(f1-1)
	            endif
	            siz1=siz2				!same size
	            wbuf(p1:)=wbuf(p2:)			!move text
	            delta=p2-p1				!moved bytes
	            posdf$(f1)=p1			!first field start pos
	            sizdf$(f1)=siz1			!size
	            flddf$(f1)=flddf$(f2)		!and field #
	            do 1003 l = f1+1, maxdf$		!all others
	               if (flddf$(j).eq.0) goto 100	!last field, all done
	               posdf$(l)=posdf$(l+nsh)-delta
	               sizdf$(l)=sizdf$(l+nsh)
	               flddf$(l)=flddf$(l+nsh)
1003	            continue
100	            continue
c
	            goto 200				!and proceed
	         endif
1002	      continue
200	      continue
c
	   endif
c
1001	continue
300	continue
c
	do 1004 k = top, 1, -1
	   if (flddf$(k).gt.0) then
	      flddf$(k+1)=0		!mark end
	      goto 400
	   endif
1004	continue
c
400	continue
c
	return
c
	end
c
c
c
c
	subroutine strchl_(buffer,field,mandat,
     1                     lgth,kind,min,max,pic,mymssg,error)
c	*****************************************************
c
	implicit none
c
	character*(*) buffer,mymssg
	integer field,lgth,kind,min,max,pic,error
	logical mandat
c
c	Description
c	===========
c
c	First of all, if MANDAT = .true. checks if buffer is empty. Then
c	verifies, according to  type of line given in  KIND,  whether
c	BUFFER is  acceptable in its form and in  regard  to MIN, MAX,
c	PIC.  PIC gives size for strings;for integer or decimal types
c	it   means  the  number_of_digits  for  the first,1000*number_
c	_of_decimal_places+number_of_digits  for the latter  ( what a
c	messy trick !!! ).
c	KIND equal  to  100 means  no  checking  is  wanted  at all.
c	Oh!, by the  way, MIN and MAX give the limits for number-like
c	types. For logical they dont matter. As usual ERROR if > zero.
c	If line is  empty  no check is actually done, also if PIC  is
c	zero.
c	BUFFER  is  used  up to  LGTH, of course.  In MYMSSG a possible
c	error message is given back.
c	If  all  OK the buffer is  perhaps re-arrenged for prettyness.
c
c       Remember that the original types of fields are :
c
c	n$  =1	integer
c	c$  =2	string
c	db$ =3	other data base
c	x$  =4	decimal
c	d$  =5	date
c	l$  =6	logical
c	r$  =7	real
c	r8$ =8	double precision
c
c	 0	not to be checked
c
c	>= 100  user defined
c
c	"Our" types of fields are (in input):
c	-------------------------------------
c
c	100	no checking
c	101	integer
c	102	string
c	103	other data base rec#
c	104	decimal
c	105	date
c	106	logical
c	107	real
c	108	other data base rec# (with check digit)
c	109	(unused)
c	110	(unused)
c	111	existing data base name
c	112	non-existing data base name
c	113	data base designation
c	114	field mnemonic
c	115	      type (text, eg c, n, db, ...)
c	116	      width
c	117	      description
c	118	      decimal places
c	119	      KEY ? (y/n)
c	120	other data base name
c	121	(unused)
c	122	data base with check digit ? (y/n)
c	123	      MANDATORY ? (y/n)
c	124	data base file (.dbf) cripted ? (y/n)
c	125	killed list available ? (y/n)
c	126	other data base master field (name or number)
c	127	other data base field to see (name or number)
c	128	creature name
c
c	100		not to be checked
c
c	Types will be converted into:
c
c	1	integer
c	2	string
c	3	other data base rec#
c	4	decimal
c	5	date
c	6	logical
c	7	real
c	8	other db rec# (with check digit)
c
c	9	field type (text)
c	10	field is KEY ? (y/n)
c	11	data base with check digit ? (y/n)
c	12	field mnemonic
c	13	data base name
c	14	field is mandatory ? (y/n)
c	15	data base cripted ? (y/n)
c	16	killed list available ? (y/n)
c	17	o.d.b. master field (name or number)
c	18	o.d.b. field to see (name or number)
c	19	o.d.b. name
c	20	creature name
c
c
c	So, [field type - 100] will recover original field types for type
c	= 100, ..., 108 and new converted types 109, 110, 111, 112, 113, 114,
c	116.
c
c	Var
c	===
c
	include 'own:dbag0.own'
	include 'own:vedit.own'
c
	external istrip_,dummy_
	integer istrip_
c
	integer lzero/0/,mykind,mytype,typ,val,dec,p1,p2,len
	real rval
	integer nodig,lim,k,b2,f2,upd2,mod2,mast,see,pos1,pos2,
	1	irace,idim,isize,ideci
	character*30 race
	character*12 odbname,fmnem
	logical outopn
c
c	Begin
c	=====
c
	error=0
	call errclr_('STRCHL')
	mymssg(1:)=' '
c
c	Nocheck ?
c	---------
c
	if (kind.lt.100) goto 400	!ignore abnormal types
	if (kind.eq.109.or.
     1      kind.eq.110    ) goto 400	!and unused types
c
c	Convert KIND into value between 1 and 19 (MYKIND)
c
	mykind=kind-100
c
	if (mykind.eq.13.or.		!data base designation
     1      mykind.eq.17    ) then	!or field description
	   mykind=2				!treat as common strings
	endif
c
	if (mykind.eq.16.or.		!field width
     1      mykind.eq.21.or.		!record#
     1      mykind.eq.18    ) then	!or field decimal places
	   mykind=1				!treat as common integers
	endif
c
	if     (mykind.eq.15) then
	   mykind=9				!field type (text)
	elseif (mykind.eq.19) then
	   mykind=10				!field is KEY (y/n)
	elseif (mykind.eq.22) then
	   mykind=11				!check digit ? (y/n)
	elseif (mykind.eq.14) then
	   mykind=12				!field mnemonic
	elseif (mykind.eq.11.or.
     1          mykind.eq.12   ) then
	   mykind=13				!data base name
	elseif (mykind.eq.20) then
	   mykind=19				!o.d.b. name
	elseif (mykind.eq.23) then
	   mykind=14				!MANDATORY ? (y/n)
	elseif (mykind.eq.24) then
	   mykind=15				!CRIPTED ? (y/n)
	elseif (mykind.eq.25) then
	   mykind=16				!CRIPTED ? (y/n)
	elseif (mykind.eq.26) then
	   mykind=17				!o.d.b field name or number
	elseif (mykind.eq.27) then
	   mykind=18				!o.d.b field name or number
	elseif (mykind.eq.28) then
	   mykind=20				!creature name
	endif
c
c	Carry on
c	--------
c
	if (mykind.lt.9) then			!general procedure CHKLIN
	   call chklin_(dummy_,buffer,lzero,mandat,
     1                 lgth,mykind,min,max,pic,mymssg,error)
	   return				!return!! (don't set any error)
	endif
c
c	See if empty and mandatory
c
	if (istrip_(buffer).le.0.and.
     1       mandat                  ) then
	   write(mymssg(1:),10008)
	   error=8
	   goto 400
	endif
c
c	dispatch on "our" types (mykind=9,10,11,12,13,14,15,16,17,18,19,20)
c
	mykind=mykind-8
	goto (109,110,111,112,113,114,115,116,117,118,119,120) mykind
c
	goto 400
c
c	field type (text)
c	-----------------
c
109	continue
c
c	if buffer is empty do nothing
c
	if (istrip_(buffer).le.0) goto 400
c
	call chktyp_(buffer(1:),mytype)
	if (mytype.gt.ftusr$.or.		!creatures not here
	1   mytype.le.0     ) then
	   if (reals) then
	      write(mymssg(1:),10002)
	      error=2
	   else
	      write(mymssg(1:),10016)
	      error=16
	   endif
	else
	   buffer(1:)=ft$(mytype)		!pretty
	endif
c
	goto 400
c
c	field is key ? (y/n)
c	--------------------
c
110	continue
c
c	if buffer is empty do nothing
c
	if (istrip_(buffer).le.0) goto 400
c
	lim=istrip_(buffer(1:))
	if     (lim.gt.1) then
	   write(mymssg(1:),10003)		!y/n only
	   error=3
	elseif (lim.le.0.or.			!"n" is also the default
     1          buffer(1:1).eq.'n'      .or.
     1          buffer(1:1).eq.'N'         ) then
	   buffer(1:1)='n'
	elseif (buffer(1:1).eq.'y'.or.
     1          buffer(1:1).eq.'Y'    ) then
	   buffer(1:1)='y'
	else
	   write(mymssg(1:),10003)		!y/n only
	   error=3
	endif
c
	goto 400
c
c	data base with check digit ? (y/n)
c	----------------------------------
c
111	continue
c
	lim=istrip_(buffer(1:))
	if     (lim.gt.1) then
	   write(mymssg(1:),10003)		!y/n only
	   error=3
	elseif  (lim.le.0.or.
     1          buffer(1:1).eq.'n'      .or.
     1          buffer(1:1).eq.'N'         ) then
	   buffer(1:1)='n'			!NO is also the default
	elseif (buffer(1:1).eq.'y'.or.
     1          buffer(1:1).eq.'Y'    ) then
	   buffer(1:1)='y'
	else
	   write(mymssg(1:),10003)		!y/n only
	   error=3
	endif
c
	goto 400
c
c	field mnemonic
c	--------------
c
112	continue
c
	if (istrip_(buffer).le.0) then
c	   ok
	else
c
	   call rstok_(buffer,1,error)	!start at beginning of buffer
	   error=0			!silence intok
	   call intok_(typ,val,dec,rval,buffer,lgth,p1,p2,mymssg,error)
	   if (error.ne.0) goto 350
	   if (typ.ne.1.and.		!identifier
     1         typ.ne.24    ) then	!+ underlines
	      write(mymssg(1:),10004)
	      error=4
	   else
	      pos1=p1
	      pos2=p2
	      call intok_(typ,val,dec,rval,buffer,len,p1,p2,mymssg,error)
	      if (error.ne.0) goto 350
	      if (typ.ne.0) then
	         write(mymssg(1:),10004)
	         error=4
	      endif
	   endif
	endif
c
	if (error.eq.0) then
	   call ljust_(buffer)
	endif
c
	goto 400
c
c
c	data base name
c	--------------
c
113	continue
c
c	if buffer is empty do nothing
c
	lim=istrip_(buffer)
	if (lim.le.0) goto 400
c
	call rstok_(buffer(1:lim),1,error)	!start at beginning of buffer
	error=0					!silence intok
	call intok_(typ,val,dec,rval,buffer(1:lim),lgth,p1,p2,mymssg,error)
	if (error.ne.0) goto 350
	if (typ.ne.1.and.
     1      typ.ne.24    ) then			!identifiers only
	   write(mymssg(1:),10007)
	   error=7
	else
	   call intok_(typ,val,dec,rval,buffer(1:lim),len,p1,p2,mymssg,error)
	   if (error.ne.0) goto 350
	   if (typ.ne.0) then
	      write(mymssg(1:),10004)
	      error=4
	   endif
	endif
c
	if (error.eq.0) then
	   call ljust_(buffer)
	endif
c
	goto 400
c
c	field is mandatory ? (y/n)
c	--------------------------
c
114	continue
c
	lim=istrip_(buffer(1:))
	if     (lim.gt.1) then
	   write(mymssg(1:),10003)		!y/n only
	   error=3
	elseif (buffer(1:1).eq.'n'.or.
     1          buffer(1:1).eq.'N'    ) then
	   buffer(1:1)='n'
	elseif (buffer(1:1).eq.'y'.or.
     1          buffer(1:1).eq.'Y'    ) then
	   buffer(1:1)='y'
	else
	   if (lim.gt.0) then
	      write(mymssg(1:),10003)		!y/n only
	      error=3
	   endif
	endif
c
	goto 400
c
c	data base cripted ? (y/n)
c	-------------------------
c
115	continue
c
	lim=istrip_(buffer(1:))
	if     (lim.gt.1) then
	   write(mymssg(1:),10003)		!y/n only
	   error=3
	elseif  (lim.le.0.or.
     1          buffer(1:1).eq.'n'      .or.
     1          buffer(1:1).eq.'N'         ) then
	   buffer(1:1)='n'			!NO is also the default
	elseif (buffer(1:1).eq.'y'.or.
     1          buffer(1:1).eq.'Y'    ) then
	   buffer(1:1)='y'
	else
	   write(mymssg(1:),10003)		!y/n only
	   error=3
	endif
c
	goto 400
c
c	killed list available ? (y/n)
c	-----------------------------
c
116	continue
c
	lim=istrip_(buffer(1:))
	if     (lim.gt.1) then
	   write(mymssg(1:),10003)		!y/n only
	   error=3
	elseif  (lim.le.0.or.
     1          buffer(1:1).eq.'y'      .or.
     1          buffer(1:1).eq.'Y'         ) then
	   buffer(1:1)='y'			!YES is also the default
	elseif (buffer(1:1).eq.'n'.or.
     1          buffer(1:1).eq.'N'    ) then
	   buffer(1:1)='n'
	else
	   write(mymssg(1:),10003)		!y/n only
	   error=3
	endif
c
	goto 400
c
c	master field (mnemonic or n or %n)
c	----------------------------------
c
117	continue
c
	d$mast(db$fld(1),db$bas(1))=0
	b2=d$dbio(db$fld(1),db$bas(1))
	lim=istrip_(buffer)
c
	if (lim.le.0) goto 400
c
	if (b2.le.0) then
	   write(mymssg(1:),10012)		!specify data base name
	   error=12
	   goto 400
	else
c
	   call rstok_(buffer(1:lim),1,error)	!start at beginning
	   error=0				!silence intok
	   typ=0
	   call intok_(typ,val,dec,rval,buffer(1:lim),len,p1,p2,mymssg,
	1              error)
	   if (error.eq.0.and.
	1      typ.eq.33) then			!"%"
	      error=0				!silence intok
	      call intok_(typ,val,dec,rval,buffer(1:lim),len,p1,p2,mymssg,
	1                 error)
	   endif
	   if (error.ne.0) then
	      goto 1171				!bad field
	   else
	      if (typ.eq.2) then		!n or %n
	         error=0			!see if line is clean
	         call intok_(typ,val,dec,rval,buffer(1:lim),len,p1,p2,
	1                    mymssg,error)
	         if (typ.ne.0.or.error.ne.0) goto 1171	!bad field
	         f2=val
	         if (f2.gt.0.and.
     1               f2.le.d$nfld(b2)) then
	            if (d$type(f2,b2).eq.db$) then
	               write(mymssg(1:),10011)	!sorry...
	               error=11
	               goto 400
	            else
	               buffer=' '		!mnemonic ...
	               buffer=d$fmne(f2,b2)
	               d$mast(db$fld(1),db$bas(1))=f2
	            endif
	         else
	            goto 1171			!bad field
	         endif
	      else
	         fmnem(1:)=' '
	         fmnem=buffer(p1:p2)
	         call znum_(b2,f2,fmnem,error)	!get field#
	         if (error.eq.0.and.
	1            f2.gt.0      ) then
	            d$mast(db$fld(1),db$bas(1))=f2
	         else
	            goto 1171			!bad field
	         endif
	      endif	
	   endif
	endif
c
	if (error.eq.0) then
	   call ljust_(buffer)
	endif
c
	goto 400
c
c	Bad field name or number
c
1171	continue
c
	write(mymssg(1:),10010)
	error=10
	goto 400
c
c	field to see (mnemonic or n or %n)
c	----------------------------------
c
118	continue
c
	d$see(db$fld(1),db$bas(1))=0
	b2=d$dbio(db$fld(1),db$bas(1))
	lim=istrip_(buffer)
c
	if (lim.le.0) return
c
	if (b2.le.0) then
	   write(mymssg(1:),10012)		!specify data base name
	   error=12
	   goto 400
	else
c
	   call rstok_(buffer(1:lim),1,error)	!start at beginning
	   error=0				!silence intok
	   typ=0
	   call intok_(typ,val,dec,rval,buffer(1:lim),len,p1,p2,mymssg,
	1              error)
	   if (error.eq.0.and.
	1      typ.eq.33) then			!"%"
	      error=0				!silence intok
	      call intok_(typ,val,dec,rval,buffer(1:lim),len,p1,p2,mymssg,
	1                 error)
	   endif
	   if (error.ne.0) then
	      goto 1181				!bad field
	   else
	      if (typ.eq.2) then		!n or %n
	         error=0			!see if line is clean
	         call intok_(typ,val,dec,rval,buffer(1:lim),len,p1,p2,
	1                    mymssg,error)
	         if (typ.ne.0.or.error.ne.0) goto 1181	!bad field
	         f2=val
	         if (f2.gt.0.and.
     1               f2.le.d$nfld(b2)) then
	            buffer=' '			!mnemonic ...
	            buffer=d$fmne(f2,b2)
	            d$see(db$fld(1),db$bas(1))=f2
	         else
	            goto 1181			!bad field
	         endif
	      else
	         fmnem(1:)=' '
	         fmnem=buffer(p1:p2)
	         call znum_(b2,f2,fmnem,error)	!get field#
	         if (error.eq.0.and.
	1            f2.gt.0      ) then
	            d$see(db$fld(1),db$bas(1))=f2
	         else
	            goto 1181			!bad field
	         endif
	      endif	
	   endif
	endif
c
	if (error.eq.0) then
	   call ljust_(buffer)
	endif
c
	goto 400
c
c	Bad field name or number
c
1181	continue
c
	write(mymssg(1:),10010)
	error=10
	goto 400
c
c	other data base name
c	--------------------
c
119	continue
c
	d$fnam(db$fld(1),db$bas(1))(1:)=' '
	d$dbio(db$fld(1),db$bas(1))=0
c
	lim=istrip_(buffer)
	if (lim.le.0) return
c
	call rstok_(buffer(1:lim),1,error)	!start at beginning of buffer
	error=0					!silence intok
	call intok_(typ,val,dec,rval,buffer(1:lim),len,p1,p2,mymssg,error)
	if (error.ne.0) goto 350
	if (typ.ne.1.and.
     1      typ.ne.24    ) then			!identifiers only
	   write(mymssg(1:),10007)
	   error=7
	   goto 400
	else
	   odbname(1:)=' '
	   odbname=buffer(p1:p2)
	   call intok_(typ,val,dec,rval,buffer(1:lim),len,p1,p2,mymssg,
	1              error)
	   if (error.ne.0) goto 350
	   if (typ.ne.0) then
	      write(mymssg(1:),10007)
	      error=7
	      goto 400
	   endif
	endif
c
	upd2=-1				!open base
	mod2=0
	call open_(b2,odbname,upd2,mod2,outopn,error)
	if (error.ne.0) then		!can't find it
	   write(mymssg(1:),10009)
	   error=9
	   goto 400
	endif
c
	call zrace_(b2,race,irace,idim,isize,ideci,error)
c	if (error) noerror
	if (irace.ne.r$b) then		!not a regular base
	   write(mymssg(1:),10015)
	   error=15
	   goto 400
	endif
c
	d$fnam(db$fld(1),db$bas(1))(1:)=odbname
	d$dbio(db$fld(1),db$bas(1))=b2
c
	if (error.eq.0) then
	   call ljust_(buffer)
	endif
c
	goto 400
c
c	creature name
c	-------------
c
120	continue
c
	lim=istrip_(buffer)
	if (lim.le.0) return
c
	call rstok_(buffer(1:lim),1,error)	!start at beginning of buffer
	error=0					!silence intok
	call intok_(typ,val,dec,rval,buffer(1:lim),len,p1,p2,mymssg,error)
	if (error.ne.0) goto 350
	if (typ.ne.1.and.
     1      typ.ne.24    ) then			!identifiers only
	   write(mymssg(1:),10007)
	   error=7
	   goto 400
	else
	   odbname(1:)=' '
	   odbname=buffer(p1:p2)
	   call intok_(typ,val,dec,rval,buffer(1:lim),len,p1,p2,mymssg,
	1              error)
	   if (error.ne.0) goto 350
	   if (typ.ne.0) then
	      write(mymssg(1:),10007)
	      error=7
	      goto 400
	   endif
	endif
c
	if (error.eq.0) then
	   call ljust_(buffer)
	endif
c
	goto 400
c
c
c	intok error
c
350	continue
	write(mymssg(1:),10005)
	error=5
	goto 400			!common error "exit"
c
c
400	continue
c
	if (error.gt.0) then
	   call errset_('STRCHL',error)	!set my errors
	endif
c
	return
c
c
c	formats
c	=======
c
	include 'fmt:STRCHL.FMT'
c
c
	end
c
c
c
c
	subroutine STROUT_(base,strname,new,full,erro)
c	**********************************************
c
	implicit none
c
	integer base,erro
	character*(*) strname
	logical new,full
c
c	Description
c	===========
c
c	Create and output root and base files STRNAME.ROO and STRNAME.DBF
c	for BASE memory context if new data base structure (NEW=.true.).
c	Update root and base files for BASE memory context if old data
c	base structure and not full editing (NEW=.false. and FULL=.false.).
c	Update root file and create new base file if old data base structure
c	and full editing (NEW=.false. and FULL=.true.).
c	If updating root and base files, FULL=.true. means everything has
c	been updated, otherwise only non-critical items have been updated,
c	so some records in the dbf file don't have to be re-written.
c
c	(called by modules C$REAT, M$ODIF, J$OIN)
c
c	All KEY fields are forced to MANDATORY !!!!.
c	All db$ fields are forced to be indexed.
c	WARN if o.d.b. field isn't KEY
c
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	character*1   tmplt
	character*120 fspec
	logical inuse,ropen,outopn
c
	integer i,ego,kkk,answr,sysid,sys$getsyi
c
	integer*2 w1,w2
	integer*4 l1,l2
c
	common/sysego/
     1         w1,w2,l1,l2
c
	data w1/4/
	data w2/'00000201'x/
c
	integer me,f,k,l,p1,p1siz,p2,dbflen,maybe,dbvers,b2,upd2,mod2
	integer rdir,type,min,max,idx,oprt,wprt,ownr,oblg,mast,see,deci
	integer		root,	!i/o channel for root file
     1   		dbf	!same for dbf
	logical fexist
	character*120 inidir
	character*10 odbname
	character*4 rtxtmin,rtxtmax
	equivalence (min,rtxtmin)
	equivalence (max,rtxtmax)
c
c	begin
c	=====
c
	call errclr_('STROUT')				!clear errors
c
	dbf=0						!just in case...
	root=0
c
	if (d$nfld(base).le.0) goto 90001		!no field specified
c
c	Signature
c	---------
c
	if (new) then
	   call pid_(me)		!new signature
	else
	   me=d$sign(base)		!old signature
	endif
c
c	Today's date and time
c	---------------------
c
	call date(today)
	call time(hour)
c
c	Version
c	-------
c
	if (new.or.full) then		!my new version number !!!
	   dbvers=1
	else
	   dbvers=d$nver(base)		!keep previous version number !!!
	endif
c
c	Remember machine
c	----------------
c
	l1=%loc(ego)
	l2=%loc(kkk)
c
	i=sys$getsyi(,,,w1,,,)
c
	ropen=.false.			!assume root file is closed
	root=0
	dbf=0
c
c	.INI if old
c	-----------
c
	if (new) then
	   rdir=0
	   inidir(1:)=' '
	else
	   rdir=index(d$bfil(base), ']')		!remember
	   if (rdir.le.0) rdir=index(d$bfil(base), ':')
	   if (rdir.gt.0) inidir(1:rdir)=d$bfil(base)(1:rdir)	!store inidir
	endif
c
c	Open data base files with name in STRNAME if *** NEW
c	--------------------------------------------------
c
	if (new) then
c
	   fspec(1:)=strname(1:)
	   call givext_(fspec,'.roo')			!built fspec (root file)
	   call newc_(root)				!ask for i/o channel
	   if (root.le.0) then
	      goto 90002				!no channel
	   endif
c
	   inquire (file=fspec,exist=fexist)
	   if (fexist) goto 90005			!database already exists
c
	   maybe=cm$max
	   if (maybe.lt.ro$max) maybe=ro$max
	   open (unit=root, file=fspec, status='new', recl=maybe,
     1           organization='relative', access='direct',
     1           form='formatted', err=90003)
c
	else
	   maybe=cm$max
	   if (maybe.lt.ro$max) maybe=ro$max
	   root=d$rio(base)
	   if (root.le.0) then				!open root file
	      ropen=.true.				!don't forget to close
	      fspec(1:)=strname(1:)
	      if (rdir.gt.0) call givdir_(fspec,inidir)
	      call givext_(fspec,'.roo')		!built fspec (root file)
	      call newc_(root)				!ask for i/o channel
	      if (root.le.0) then
	         goto 90002				!no channel
	      endif
	      open (unit=root, file=fspec, status='old', recl=maybe,
     1              organization='relative', access='direct',
     1              form='formatted', err=90003)
	   endif
	endif
c
c	No. of fields
c	-------------
c
	f=d$nfld(base)						!# fields
	dbflen=0						!.dbf file
c
c	Record 1
c	--------
c
	d$root(1:)=' '						!clean up
c
	if (new) then
	   d$date(base)(1:9)   = today(1:)			!date/time
	   d$date(base)(10:10) = ':'
	   d$date(base)(11:20) = hour(1:)
	endif
c
	d$root(ro$s4:ro$s4+ro$l4-1)=d$date(base)		!store
c
	call wrivar_(d$root(ro$s1:ro$s1+ro$l1-1),f,ro$l1,erro)	!# fields
	if (erro.ne.0) goto 90009				!write error
c
	call wrivar_(d$root(ro$s2:ro$s2+ro$l2-1),me,ro$l2,erro)	!signature
	if (erro.ne.0) goto 90009				!write error
c
	d$root(ro$s5:ro$s5+6)='version'
	call wrivar_(d$root(ro$s5+7:ro$s5+8),dbvers,2,erro)	!version
	if (erro.ne.0) goto 90009				!write error
	d$root(ro$s5+9:ro$s5+ro$l5-1)='.0'
c
	d$root(ro$s3:ro$s3+ro$l3-1)=d$bdes(base)		!designation
c
	call cript_(d$root,maybe)
c
	write (root,rec=1,fmt='(a)',err=90006) d$root(1:maybe)
c
c	Next f records
c	--------------
c
	do 1001 k = 1, f
	   d$root(1:)=' '				!clean up
c
	   l=istrip_(d$fmne(k,base))			!field mnemonic
	   d$root(cm$s1:cm$s1+l-1)=d$fmne(k,base)
	   l=istrip_(d$fdes(k,base))			!field description
	   if (l.gt.0) then
	      d$root(cm$s2:cm$s2+l-1)=d$fdes(k,base)
	   endif
c
	   odbname=' '
	   odbname=d$fnam(k,base)
	   call uc_(odbname)
	   if     (d$type(k,base).eq.db$) then
	      l=istrip_(odbname)			!other D.B. name
	      if (l.le.0) then
	         write(mssg,10001) strname,k		!empty !!!
	         call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	      else
	         upd2=-1				!open base
	         mod2=0
	         call open_(b2,odbname,upd2,mod2,outopn,erro)
	         if (erro.ne.0) then
	            write(mssg,10002) odbname		!can't open o.d.b.
	            call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	         else
	            if (d$itrv.eq.1) then		!interactive
	               mast=d$mast(k,base)		!master field
	               if (mast.gt.0) then
	                  if (d$idx(mast,b2).ne.2) then	!not KEY
	                     write (mssg,10003) odbname,mast
	                     call i$mess_(0,d$cmdo,-1,mssg,-1,erro)
	                  endif
	               endif
	            endif
	         endif
	      endif
	      d$root(cm$s3:cm$s3+l-1)=odbname
	   else
	      if (d$type(k,base).gt.ftusr$) then
	         l=istrip_(odbname)		!other D.B. name for creatures
	         if (l.gt.0) d$root(cm$s3:cm$s3+l-1)=odbname
	      endif
	   endif
c
	   call cript_(d$root,maybe)
	   write (root,rec=k+1,fmt='(a)',err=90006) d$root(1:maybe)
c
	   dbflen=dbflen+d$siz(k,base)			!.dbf len.
1001	continue
c
c	Compute total .dbf record size
c	------------------------------
c
	dbflen=dbflen+1				!sign for dead or alive (*)
	if (dbflen.lt.10) then			!make sure (i10) formats work
	   dbflen=10
	endif
c
c	Open dbf file if *** NEW, delete it and re-open if *** OLD, FULL
c	----------------------------------------------------------------
c
	if (new) then
c
	   call givext_(fspec,'.dbf')			!built fspec (dbf file)
	   call newc_(dbf)				!ask for i/o channel
	   if (dbf.le.0) then
	      goto 90002				!no i/o channel
	   endif
c
	   open (unit=dbf, file=fspec, status='new', recl=dbflen,
     1           organization='relative', access='direct',
     1           form='formatted', err=90004)
c
	else
	   if (full) then
	      dbf=d$bio(base)
	      close (unit=dbf,dispose='delete',err=90008)
	      if (rdir.gt.0) call givdir_(fspec,inidir)
	      call givext_(fspec,'.dbf')		!built fspec (dbf file)
	      open (unit=dbf, file=fspec, status='new', recl=dbflen,
     1              organization='relative', access='direct',
     1              form='formatted', err=90004)
	      d$recl(base)=dbflen			!new record lenght
	   else
	      dbf=d$bio(base)
	      dbflen=d$recl(base)
	   endif
	endif
c
c	Clean everything (except "race") if *** NEW
c
	if (new) then
c
	   d$last(base) = d$unus		!last used "physical" record
	   d$head(base) = 0			!1st. record in killed list
	   d$tail(base) = 0			!last record in killed list
	   d$kill(base) = 0			!# killed records
	   d$opr(base)  = 0			!# opens/read
	   d$opw(base)  = 0			!# opens/update
	   d$prt(base)  = 0			!protection on/off
	   d$spy(base)  = 0			!LOGging on/off
	   d$kgb        = 0			!KGB on/off
	   d$stat(base) = 0			!statistics on/off
	   d$hash(base) = 0			!base hashed if 1
	   d$pid(base)  = 0			!current owner
	endif
c
c	Create all records if *** NEW or *** FULL, otherwise update only
c	non-critical records; "last update date" will be updated if *** OLD.
c
	if (new.or.full) then
	   d$xbuf(1:)=' '
	   write(d$xbuf(1:),fmt='(i10)') f		!# fields
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=1,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	   d$xbuf(1:)=' '
	   write(d$xbuf(1:),'(i10)')me		!signature
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=2,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	   d$xbuf(1:)=' '
	   write(d$xbuf(1:),'(i10)')d$last(base)	!last record
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=3,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	   d$xbuf(1:)=' '
	   write(d$xbuf(1:),'(i10)')d$tail(base)
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=4,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	   d$xbuf(1:)=' '
	   write(d$xbuf(1:),'(i10)')d$offs(base)
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=5,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	   d$xbuf(1:)=' '
	   write(d$xbuf(1:),'(i10)')d$kill(base)
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=6,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	   d$xbuf(1:)=' '
	   d$xbuf=d$ownb(base)
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=7,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	   d$xbuf(1:)=' '
	   write(d$xbuf(1:),'(i10)')d$opr(base)
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=8,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	   d$xbuf(1:)=' '
	   write(d$xbuf(1:),'(i10)')d$opw(base)
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=9,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	   d$xbuf(1:)=' '
	   write(d$xbuf(1:),'(i10)')d$head(base)
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=34,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	endif
c
	if (new) then				!last update date
	   d$xbuf(1:)=' '
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=10,fmt='(a)',err=90007) d$xbuf(1:dbflen)
	   d$xbuf(1:)=' '
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=11,fmt='(a)',err=90007) d$xbuf(1:dbflen)
	else
	   d$xbuf(1:)=' '
	   d$xbuf(1:)=today			!last update date
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=10,fmt='(a)',err=90007) d$xbuf(1:dbflen)
	   d$xbuf(1:)=' '
	   d$xbuf(1:)=hour
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=11,fmt='(a)',err=90007) d$xbuf(1:dbflen)
	endif
c
	if (new.or.full) then
	   d$xbuf(1:)=' '
	   write(d$xbuf(1:),'(i10)')d$prt(base)
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=12,fmt='(a)',err=90007) d$xbuf(1:dbflen)
	   d$xbuf(1:)=' '
	   write(d$xbuf(1:),'(i10)')d$spy(base)
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=13,fmt='(a)',err=90007) d$xbuf(1:dbflen)
	   d$xbuf(1:)=' '
	   write(d$xbuf(1:),'(i10)')d$kgb
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=14,fmt='(a)',err=90007) d$xbuf(1:dbflen)
	   d$xbuf(1:)=' '
	   write(d$xbuf(1:),'(i10)')d$stat(base)
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=15,fmt='(a)',err=90007) d$xbuf(1:dbflen)
	   d$xbuf(1:)=' '
	   write(d$xbuf(1:),'(i10)')d$hash(base)
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=16,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	endif
c
	if (new.or.full) then
c
	   tmplt='.'				!basic template
c
	   d$xbuf(1:)=' '				!just in case...
	   do 1003 k=1,f
	      do 1002 l=d$pos(k,base),d$pos(k,base)+d$siz(k,base)-1
	         d$xbuf(l:l)=tmplt
1002	      continue
	      if (tmplt.eq.'.') then
	         tmplt='!'
	      else
	         tmplt='.'
	      endif
1003	   continue
c
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=17,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	   d$xbuf(1:)=' '
	   do 1004 k=1,f
	      p1=d$pos(k,base)
	      p1siz=d$siz(k,base)
	      type=d$type(k,base)
	      call wrivar_(d$xbuf(p1:),type,p1siz,erro)
	      if (erro.ne.0) goto 90009			!write error
1004	   continue
c
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=18,fmt='(a)',err=90007) d$xbuf(1:dbflen)
	endif
c
	d$xbuf(1:)=' '
	do 1005 k=1,f				!minimum values template
	   type=d$type(k,base)
	   p1=d$pos(k,base)
	   p1siz=d$siz(k,base)
	   p2=p1+p1siz-1
	   min=d$min(k,base)
	   if     (type.eq.n$.or.
     1             type.eq.x$.or.
     1             type.eq.d$    ) then
	      call wrivar_(d$xbuf(p1:),min,p1siz,erro)
	      if (erro.ne.0) goto 90009			!write error
	   elseif (type.eq.r$) then
	      d$xbuf(p1:p2)=rtxtmin
	   endif
1005	continue
c
	if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	write (dbf,rec=19,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	d$xbuf(1:)=' '
	do 1006 k=1,f				!maximum values template
	   type=d$type(k,base)
	   p1=d$pos(k,base)
	   p1siz=d$siz(k,base)
	   p2=p1+p1siz-1
	   max=d$max(k,base)
	   if     (type.eq.n$.or.
     1             type.eq.x$.or.
     1             type.eq.d$    ) then
	      call wrivar_(d$xbuf(p1:),max,p1siz,erro)
	      if (erro.ne.0) goto 90009			!write error
	   elseif (type.eq.r$) then
	      d$xbuf(p1:p2)=rtxtmax
	   endif
1006	continue
c
	if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	write (dbf,rec=20,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	d$xbuf(1:dbflen)=d$dflt(base)(1:dbflen)	!default values template
	if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	write (dbf,rec=21,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	if (new.or.full) then
c
	   d$xbuf(1:)=' '
	   do 1007 k=1,f				!indexed fields
	      p1=d$pos(k,base)
	      p1siz=d$siz(k,base)
	      type=d$type(k,base)
	      idx=d$idx(k,base)
	      call wrivar_(d$xbuf(p1:),idx,p1siz,erro)
	      if (erro.ne.0) goto 90009			!write error
1007	   continue
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=22,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	   d$xbuf(1:)=' '
	   do 1008 k=1,f				!protection
	      p1=d$pos(k,base)
	      p1siz=d$siz(k,base)
	      oprt=d$oprt(k,base)
	      call wrivar_(d$xbuf(p1:),oprt,p1siz,erro)
	      if (erro.ne.0) goto 90009			!write error
1008	   continue
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=23,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	   d$xbuf(1:)=' '
	   do 1099 k=1,f				!protection
	      p1=d$pos(k,base)
	      p1siz=d$siz(k,base)
	      wprt=d$wprt(k,base)
	      call wrivar_(d$xbuf(p1:),wprt,p1siz,erro)
	      if (erro.ne.0) goto 90009			!write error
1099	   continue
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=24,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	   d$xbuf(1:)=' '
	   do 1098 k=1,f				!owner
	      p1=d$pos(k,base)
	      p1siz=d$siz(k,base)
	      ownr=d$ownr(k,base)
	      call wrivar_(d$xbuf(p1:),ownr,p1siz,erro)
	      if (erro.ne.0) goto 90009			!write error
1098	   continue
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=25,fmt='(a)',err=90007) d$xbuf(1:dbflen)
	endif
c
	d$xbuf(1:)=' '
	do 1097 k=1,f				!mandatory
	   p1=d$pos(k,base)
	   p1siz=d$siz(k,base)
	   idx=d$idx(k,base)
	   if (idx.eq.2) then			!KEY field
	      oblg=1				!always mandatory
	   else
	      oblg=d$oblg(k,base)
	   endif
	   call wrivar_(d$xbuf(p1:),oblg,p1siz,erro)
	   if (erro.ne.0) goto 90009		!write error
1097	continue
	if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	write (dbf,rec=26,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	d$xbuf(1:)=' '
	do 1096 k=1,f				!see field (o.d.b)
	   p1=d$pos(k,base)
	   p1siz=d$siz(k,base)
	   if (d$type(k,base).eq.db$) then
	      see=d$see(k,base)
	   else
	      see=0
	   endif
	   call wrivar_(d$xbuf(p1:),see,p1siz,erro)
	   if (erro.ne.0) goto 90009			!write error
1096	continue
	if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	write (dbf,rec=27,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	if (new.or.full) then
c
	   d$xbuf(1:)=' '
	   do 1095 k=1,f				!decimal places
	      p1=d$pos(k,base)
	      p1siz=d$siz(k,base)
	      if (d$type(k,base).eq.x$) then
	         deci=d$deci(k,base)
	      else
	         deci=0
	      endif
	      call wrivar_(d$xbuf(p1:),deci,p1siz,erro)
	      if (erro.ne.0) goto 90009			!write error
1095	   continue
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=28,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	   d$xbuf(1:)=' '
	   write(d$xbuf(1:),'(i10)')d$pid(base)
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=29,fmt='(a)',err=90007) d$xbuf(1:dbflen)
	   d$xbuf(1:)=' '
	   write(d$xbuf(1:),'(i10)')ego
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=30,fmt='(a)',err=90007) d$xbuf(1:dbflen)
	   d$xbuf(1:)=' '
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=31,fmt='(a)',err=90007) d$xbuf(1:dbflen)
	   d$xbuf(1:)=' '
	   write(d$xbuf(1:),'(i10)')d$csig(base)
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	   write (dbf,rec=32,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	   write(d$xbuf(1:),'(i10)')d$crpt(base)
	   call cript_(d$xbuf,dbflen)
	   write (dbf,rec=33,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	endif
c
	d$xbuf(1:)=' '
	write(d$xbuf(1:),'(i10)')d$froz(base)
	if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	write (dbf,rec=35,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	d$xbuf(1:)=' '
	write(d$xbuf(1:),'(i10)')d$race(base)
	if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	write (dbf,rec=36,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	d$xbuf(1:)=' '
	read(d$xbuf,fmt='()',err=90007) 
	1        !dimensions of "thing"
c
	write(d$xbuf(1:),'(i6,i2,i2)')
	1                d$psiz(base),d$pdec(base),d$pdim(base)
	if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	write (dbf,rec=38,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	d$xbuf(1:)=' '
	do 1093 k=1,f				!master field
	   p1=d$pos(k,base)
	   p1siz=d$siz(k,base)
	   if (d$type(k,base).eq.db$) then
	      mast=d$mast(k,base)
	   else
	      mast=0
	   endif
	   call wrivar_(d$xbuf(p1:),mast,p1siz,erro)
	   if (erro.ne.0) goto 90009			!write error
1093	continue
	if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
	write (dbf,rec=37,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	if (new.or.full) then
c
c	   Unused records now...
c
	   d$xbuf(1:)=' '
	   if (d$crpt(base).eq.0) call cript_(d$xbuf,dbflen)
c
	   write (dbf,rec=32,fmt='(a)',err=90007) d$xbuf(1:dbflen)
c
	   do 1094 k=39,d$unus
	      write (dbf,rec=k,fmt='(a)',err=90007) d$xbuf(1:dbflen)
1094	   continue
c
	endif
c
c	Close root and dbf files if *** NEW
c	Close root file if *** OLD and open before
c
	if (new) then
	   if (root.gt.0) close (unit=root)
	   if (dbf.gt.0) close (unit=dbf)
	else
	   if (ropen) then
	      if (root.gt.0) close (unit=root)
	   endif
	endif
	call freec_(root)
	call freec_(dbf)
c
c	Close base if open
c	------------------
c
	if (d$base(base).gt.0) then
	   call close_(base,erro)	!close base if open
	   if (erro.ne.0) return	!error, carry
	endif
c
	return				!return to caller
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	no field specified
90001	continue
	if (root.gt.0) close (unit=root)
	erro=1
	goto 99000				!set error and return
c	no free i/o channel
90002	continue
	erro=2
	goto 99000				!set error and return
c	error open root file
90003	continue
	erro=3
	goto 99000				!set error and return
c	error open dbf file
90004	continue
	erro=4
	goto 99000				!set error and return
c	<strname.ROO> already exists
90005	continue
	erro=5
	goto 99000				!set error and return
c	error writing root file
90006	continue
	erro=6
	goto 99000				!set error and return
c	error writing dbf file
90007	continue
	erro=7
	goto 99000				!set error and return
c	error deleting dbf file
90008	continue
	erro=8
	goto 99000				!set error and return
c	internal error: read/write error
90009	continue
	erro=9
	goto 99000				!set error and return
c
c	SET error and return
c	====================
c
99000	continue
c
	d$rinf(1:5)='base '
	d$rinf(6:)=strname			!tell him witch base
c
	call errset_('STROUT',erro)
	call freec_(root)
	call freec_(dbf)
	return					!and return
c
c	Formats
c	=======
c
	include 'fmt:strout.fmt'
c
	end
c
c
c
c
c
