c	DBAGU.FOR
c	*********
c
c	User-callable subroutines "into DBAG commands".
c		
c
c	====================================================================
c
c	    It's already available a general procedure - x$comm_ - to
c	    execute any DBAG interactive command, see XCOMM.DOC for
c	    details.
c
c	    Every call to old procedures U$???? should be replaced by
c	    a similar call to x$comm_.
c
c	    U$sear_ is the only procedure not directly replaced by
c	    a single call to x$comm_, but you can replace
c
c	    call u$sear_(base,buf,keys,nkey,mark,erro)
c
c	    by
c
c	    call x$comm_(.....)		- to execute the SEARCH command
c	    call zsear_(......)		- to get the result of the search
c		
c	====================================================================
c
c
c	CAUTION:	The argument BUF will be used as an internal working
c			space and may come back CHANGED:  any  call to these
c			procedures should never use a "local" string such as
c			        call u$xpto (..., ' whatever   ',...)
c
c	Procedures U$SET and U$EXIT have only 3 arguments: BUF, MARK, ERRO;
c	all the others have at least 4: BASE, BUF, ... , MARK, ERRO.
c
c	Summary of procedure calls:
c
c	u$appe	"APPEND ..."
c	u$crea	"CREATE ..."
c	u$dele	"DELETE ..."
c	u$defi	"DEFINE DISPLAY ..."
c	u$disp	"DISPLAY ..."
c	u$edit	"EDIT ..."
c	u$exit	"EXIT/QUIT ..."
c	u$help	"HELP ..."
c	u$join	"JOIN ..."
c	u$copy	"COPY ..."
c	u$modi	"MODIFY ..."
c	u$use	"USE/OPEN ..."
c	u$repl	"REPLACE ..."
c	u$rest	"RESTORE ... FROM file.ext"
c	u$save	"SAVE ... TO file.ext"
c	u$sear	"SEARCH DATABASE... SCOPE... FOR ..."
c	u$set	"SET ..."
c	u$zero	"ZERO ..."
c
c
	subroutine u$defi_(base,buf,mark,erro)
c	**************************************
c
	implicit none
c
	integer base,mark,erro
	character*(*) buf
c
c	Description
c	===========
c
c	Executes DEFINE command stored in BUF. BUF is supposed to contain
c	something like "DEFINE DISPLAY" or just "DISPLAY", into data base
c	BASE context.
c
c	MARK, if .gt. 0, will point to expected error location in BUF.
c
c	ERRO = 0 if ok.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer type,val,dec,lim,p1,p2
	real rval
c
c	begin
c	=====
c
	call errclr_('U$DEFI')
	erro=0
c
	d$itrv=0			!tell I am not interactive
	call init_(erro)		!init DBAG
	if (erro.ne.0) goto 900
c
	if (base.lt.0.or.
     1      base.gt.d$b  ) goto 90001	!invalid base channel
c
	if (istrip_(buf).le.0) goto 90002!buffer is empty
c
	if (base.gt.0) then
	   if (d$base(base).le.0) goto 90003	!base not open
	   call i$scur_(base,0,0)		!make it the current one
	endif
c
	call rstok_(buf,1,erro)			!reset buffer
	if (erro.ne.0) goto 900
c
c	Get rid of DEFINE keyword if present
c
	erro=0					!only my own messages
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (erro.ne.0) goto 900
c
	call seetab_(cmdtok,cmdtop,cmdpos,buf(p1:p2),minchr)	!see if there
	if (cmdpos.ne.45) then			!it isn't DEFINE
	   call rstok_(buf,1,erro)		!reset buffer again
	   if (erro.ne.0) goto 900
	else
	   if (istrip_(buf(p2+1:)).le.0)
     1        goto 90002			!buffer has just DEFINE
	endif
c
	mark=0
	call d$efin_(buf,mark)			!do define
	if (d$erro.ne.0) then
	   erro=d$erro
	   goto 900				!error, return
	endif
c
c	Return
c
900	continue
c
	base=c$base				!return used base channel
c
	return
c
c	Errors
c	======
c
c	invalid base channel
90001	continue
	erro=1
	goto 99000
c	no DEFINE command
90002	continue
	erro=2
	goto 99000
c	base not open
90003	continue
	erro=3
	goto 99000
c
99000	continue
	call errset_('U$DEFI',erro)
	return
c
	end
c
c
c
c
	subroutine u$join_(ibase1,ibase2,obase,buf,blind,mark,erro)
c	***********************************************************
c
	implicit none
c
	integer ibase1,ibase2,obase,mark,erro
	logical blind
	character*(*) buf
c
c	Description
c	===========
c
c	Executes JOIN command stored in BUF. BUF is supposed to contain
c	something like "JOIN whatever", or just "whatever", into data base
c	OBASE context.
c
c	No confirm will be needed (!) about number of output records if
c	BLIND = .true.
c
c	OBASE returns the base channel of new base produced by JOIN.
c
c	IBASE1 and IBASE2 aren't used yet.
c
c	MARK, if .gt. 0, will point to expected error location in BUF.
c
c	ERRO = 0 if ok.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer type,val,dec,lim,p1,p2
	real rval
	logical sconf
c
c	begin
c	=====
c
	call errclr_('U$JOIN')
	erro=0
c
	obase=0
	d$itrv=0			!tell I am not interactive
	call init_(erro)		!init DBAG
	if (erro.ne.0) goto 900
c
	if (istrip_(buf).le.0) goto 90001!buffer is empty
c
c	Set DBAG global parameters
c
	sconf=s$set(s$conf)			!save them for later
c
	if (blind) then
	   s$set(s$conf)=.false.
	else
	   s$set(s$conf)=.true.
	endif
c
	call rstok_(buf,1,erro)			!reset buffer
	if (erro.ne.0) goto 900
c
c	Get rid of JOIN keyword if present
c
	erro=0					!only my own messages
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (erro.ne.0) goto 900
c
	call seetab_(cmdtok,cmdtop,cmdpos,buf(p1:p2),minchr)	!see if there
	if (cmdpos.ne.17) then			!it isn't JOIN
	   call rstok_(buf,1,erro)		!reset buffer again
	   if (erro.ne.0) goto 900
	else
	   if (istrip_(buf(p2+1:)).le.0)
     1        goto 90001			!buffer has just JOIN
	endif
c
	mark=0
	call j$oin_(buf,mark)			!do join
	if (d$erro.ne.0) then
	   erro=d$erro
	   goto 900				!error, return
	endif
c
c	Return
c
900	continue
c
c	Restore DBAG global parameters
c
	s$set(s$conf)=sconf
c
	obase=c$base				!return new base channel
c
	return
c
c	Errors
c	======
c
c	no JOIN command
90001	continue
	erro=1
	goto 99000
c
99000	continue
	call errset_('U$JOIN',erro)
	return
c
	end
c
c
c
c
	subroutine u$appe_(base,buf,mark,erro)
c	**************************************
c
	implicit none
c
	integer base,mark,erro
	character*(*) buf
c
c	Description
c	===========
c
c	Executes APPEND command stored in BUF. BUF is supposed to contain
c	something like "APPEND whatever", or just "whatever".
c	BASE, if > 0, is supposed to be open and will be used as "current base"
c	by APPEND comand.
c
c	MARK, if .gt. 0, will point to expected error location in BUF.
c
c	ERRO = 0 if ok.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer type,val,dec,lim,p1,p2
	real rval
c
c	begin
c	=====
c
	call errclr_('U$APPE')
	erro=0
c
	d$itrv=0				!tell I am not interactive
	call init_(erro)			!init DBAG
	if (erro.ne.0) goto 900
c
	if (istrip_(buf).le.0) goto 90002	!buffer is empty
c
	if (base.lt.0.or.
     1      base.gt.d$b  ) goto 90001		!invalid base channel
c
	if (base.gt.0) then
	   if (d$base(base).gt.0) call i$scur_(base,0,0)!make it the current one
	endif
c
	call rstok_(buf,1,erro)			!reset buffer
	if (erro.ne.0) goto 900
c
c	Get rid of APPEND keyword if present
c
	erro=0					!only my own messages
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (erro.ne.0) goto 900
c
	call seetab_(cmdtok,cmdtop,cmdpos,buf(p1:p2),minchr)	!see if there
	if (cmdpos.ne.1) then			!it isn't APPEND
	   call rstok_(buf,1,erro)		!reset buffer again
	   if (erro.ne.0) goto 900
	endif
c
	mark=0
	call a$ppen_(buf,mark)			!do append
	if (d$erro.ne.0) then
	   erro=d$erro
	   goto 900				!error, return
	endif
c
c	Return
c
900	continue
c
	if (c$base.gt.0) then
	   base=c$base				!return current base
	endif
c
	return
c
c	Errors
c	======
c
c	invalid base channel
90001	continue
	erro=1
	goto 99000
c	no APPEND command
90002	continue
	erro=2
	goto 99000
c
99000	continue
	call errset_('U$APPE',erro)
	return
c
	end
c
c
c
c
	subroutine u$kill_(base,buf,blind,mark,erro)
c	********************************************
c
	implicit none
c
	integer base,mark,erro
	logical blind
	character*(*) buf
c
c	Description
c	===========
c
c	Executes KILL command stored in BUF. BUF is supposed to contain
c	something like "KILL whatever", or just "whatever".
c	BASE, if > 0, is supposed to be open and will be used as "current base"
c	by KILL comand.
c
c	No confirm will be needed (!) if BLIND = .true.
c
c	MARK, if .gt. 0, will point to expected error location in BUF.
c
c	ERRO = 0 if ok.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer type,val,dec,lim,p1,p2
	real rval
	logical sconf
c
c	begin
c	=====
c
	call errclr_('U$KILL')
	erro=0
c
	d$itrv=0				!tell I am not interactive
	call init_(erro)			!init DBAG
	if (erro.ne.0) goto 900
c
	if (istrip_(buf).le.0) goto 90002	!buffer is empty
c
	if (base.lt.0.or.
     1      base.gt.d$b  ) goto 90001		!invalid base channel
c
	if (base.gt.0) then
	   if (d$base(base).gt.0) call i$scur_(base,0,0)!make it the current one
	endif
c
c	Set DBAG global parameters
c
	sconf=s$set(s$conf)			!save them for later
c
	if (blind) then
	   s$set(s$conf)=.false.
	else
	   s$set(s$conf)=.true.
	endif
c
	call rstok_(buf,1,erro)			!reset buffer
	if (erro.ne.0) goto 900
c
c	Get rid of KILL keyword if present
c
	erro=0					!only my own messages
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (erro.ne.0) goto 900
c
	call seetab_(cmdtok,cmdtop,cmdpos,buf(p1:p2),minchr)	!see if there
	if (cmdpos.ne.24) then			!it isn't KILL
	   call rstok_(buf,1,erro)		!reset buffer again
	   if (erro.ne.0) goto 900
	endif
c
	mark=0
	call k$ill_(buf,mark)			!do kill
	if (d$erro.ne.0) then
	   erro=d$erro
	   goto 900				!error, return
	endif
c
c	Return
c
900	continue
c
	if (c$base.gt.0) then
	   base=c$base				!return current base
	endif
c
c	Restore DBAG global parameters
c
	s$set(s$conf)=sconf
c
	return
c
c	Errors
c	======
c
c	invalid base channel
90001	continue
	erro=1
	goto 99000
c	no KILL command
90002	continue
	erro=2
	goto 99000
c
99000	continue
	call errset_('U$KILL',erro)
	return
c
	end
c
c
c
c
	subroutine u$edit_(base,buf,mark,erro)
c	**************************************
c
	implicit none
c
	integer base,mark,erro
	character*(*) buf
c
c	Description
c	===========
c
c	Executes EDIT command stored in BUF. BUF is supposed to contain
c	something like "EDIT whatever", or just "whatever".
c	BASE, if > 0, is supposed to be open and will be used as "current base"
c	by EDIT comand.
c
c	MARK, if .gt. 0, will point to expected error location in BUF.
c
c	ERRO = 0 if ok.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer type,val,dec,lim,p1,p2
	real rval
c
c	begin
c	=====
c
	call errclr_('U$EDIT')
	erro=0
c
	d$itrv=0				!tell I am not interactive
	call init_(erro)			!init DBAG
	if (erro.ne.0) goto 900
c
	if (istrip_(buf).le.0) goto 90002	!buffer is empty
c
	if (base.lt.0.or.
     1      base.gt.d$b  ) goto 90001		!invalid base channel
c
	if (base.gt.0) then
	   if (d$base(base).gt.0) call i$scur_(base,0,0)!make it the current one
	endif
c
	call rstok_(buf,1,erro)			!reset buffer
	if (erro.ne.0) goto 900
c
c	Get rid of EDIT keyword if present
c
	erro=0					!only my own messages
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (erro.ne.0) goto 900
c
	call seetab_(cmdtok,cmdtop,cmdpos,buf(p1:p2),minchr)	!see if there
	if (cmdpos.ne.10) then			!it isn't EDIT
	   call rstok_(buf,1,erro)		!reset buffer again
	   if (erro.ne.0) goto 900
	endif
c
	mark=0
	call e$dit_(buf,mark)			!do edit
	if (d$erro.ne.0) then
	   erro=d$erro
	   goto 900				!error, return
	endif
c
c	Return
c
900	continue
c
	if (c$base.gt.0) then
	   base=c$base				!return current base
	endif
c
	return
c
c	Errors
c	======
c
c	invalid base channel
90001	continue
	erro=1
	goto 99000
c	no EDIT command
90002	continue
	erro=2
	goto 99000
c
99000	continue
	call errset_('U$EDIT',erro)
	return
c
	end
c
c
c
c
	subroutine u$repl_(base,buf,mark,erro)
c	**************************************
c
	implicit none
c
	integer base,mark,erro
	character*(*) buf
c
c	Description
c	===========
c
c	Executes REPLACE command stored in BUF. BUF is supposed to contain
c	something like "REPLACE whatever", or just "whatever".
c	BASE, if > 0, is supposed to be open and will be used as "current base"
c	by REPLACE comand.
c
c	MARK, if .gt. 0, will point to expected error location in BUF.
c
c	ERRO = 0 if ok.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer type,val,dec,lim,p1,p2
	real rval
c
c	begin
c	=====
c
	call errclr_('U$REPL')
	erro=0
c
	d$itrv=0				!tell I am not interactive
	call init_(erro)			!init DBAG
	if (erro.ne.0) goto 900
c
	if (istrip_(buf).le.0) goto 90002	!buffer is empty
c
	if (base.lt.0.or.
     1      base.gt.d$b  ) goto 90001		!invalid base channel
c
	if (base.gt.0) then
	   if (d$base(base).gt.0) call i$scur_(base,0,0)!make it the current one
	endif
c
	call rstok_(buf,1,erro)			!reset buffer
	if (erro.ne.0) goto 900
c
c	Get rid of REPLACE keyword if present
c
	erro=0					!only my own messages
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (erro.ne.0) goto 900
c
	call seetab_(cmdtok,cmdtop,cmdpos,buf(p1:p2),minchr)	!see if there
	if (cmdpos.ne.27) then			!it isn't REPLACE
	   call rstok_(buf,1,erro)		!reset buffer again
	   if (erro.ne.0) goto 900
	endif
c
	mark=0
	call r$epla_(buf,mark)			!do replace
	if (d$erro.ne.0) then
	   erro=d$erro
	   goto 900				!error, return
	endif
c
c	Return
c
900	continue
c
	if (c$base.gt.0) then
	   base=c$base				!return current base
	endif
c
	return
c
c	Errors
c	======
c
c	invalid base channel
90001	continue
	erro=1
	goto 99000
c	no REPLACE command
90002	continue
	erro=2
	goto 99000
c
99000	continue
	call errset_('U$REPL',erro)
	return
c
	end
c
c
c
c
	subroutine u$disp_(base,buf,wait,mnem,spacin,mark,erro)
c	*******************************************************
c
	implicit none
c
	integer base,mark,erro
	logical wait,mnem,spacin
	character*(*) buf
c
c	Description
c	===========
c
c	Executes DISPLAY command stored in BUF. BUF is supposed to contain
c	something like "DISPLAY DATABASE... SCOPE ... FOR ..." or just
c	WAIT  =.true., waits every n (usually 15) lines;
c	MNEM  =.true., field mnemonics are shown;
c	SPACIN=.true., a space is inserted between fields.
c	"DATABASE... SCOPE... FOR...".
c	If DATABASE keyword is specified in BUF, that data base is displayed;
c	if not, base channel BASE is used as data base to display.
c
c	MARK, if .gt. 0, will point to expected error location in BUF.
c
c	CAUTION: if user specifies DATABASE XPTO in DISPLAY command string, BASE
c	         will be changed into XPTO base channel upon completion.
c		 if display is executed on the terminal, scrolling may come back
c		 changed!
c
c	ERRO = 0 if ok.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer type,val,dec,lim,p1,p2
	real rval
	logical sname,sraw
c
c	begin
c	=====
c
	call errclr_('U$DISP')
	erro=0
c
	d$itrv=0			!tell I am not interactive
	call init_(erro)		!init DBAG
	if (erro.ne.0) goto 900
c
	if (base.lt.0.or.
     1      base.gt.d$b  ) goto 90001	!invalid base channel
c
	if (base.gt.0) then
	   if (d$base(base).gt.0) call i$scur_(base,0,0)!make it the current one
	endif
c
c	Set DBAG global parameters
c
	sname=s$set(s$name)		!save them for later
	sraw=s$set(s$raw)
c
	if (mnem) then
	   s$set(s$name)=.true.
	else
	   s$set(s$name)=.false.
	endif
c
	if (spacin) then
	   s$set(s$raw)=.false.
	else
	   s$set(s$raw)=.true.
	endif
c
	call rstok_(buf,1,erro)			!reset buffer
	if (erro.ne.0) goto 900
c
c	Get rid of DISPLAY keyword if present
c
	if (istrip_(buf).gt.0) then
	   erro=0				!only my own messages
	   call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	   if (erro.ne.0) goto 900
c
	   call seetab_(cmdtok,cmdtop,cmdpos,buf(p1:p2),minchr)	!see if there
	   if (cmdpos.ne.9) then			!it isn't DISPLAY
	      call rstok_(buf,1,erro)		!reset buffer again
	      if (erro.ne.0) goto 900
	   endif
	endif
c
	mark=0
	if (wait) then
	   call d$ispl_(buf,mark)		!do display (wait)
	else
	   call l$ist_(buf,mark)		!do list (don't wait)
	endif
	if (d$erro.ne.0) then
	   erro=d$erro
	   goto 900
	endif
c
c	Return
c
900	continue
c
c	Restore DBAG global parameters
c
	s$set(s$name)=sname
	s$set(s$raw)=sraw
c
	if (erro.ne.0.and.
     1      c$base.ne.0.and.
     1      c$base.ne.base  ) base=c$base	!return used base channel
c
	return
c
c	Errors
c	======
c
c	invalid base channel
90001	continue
	erro=1
	goto 99000
c
99000	continue
	call errset_('U$DISP',erro)
	return
c
	end
c
c
c
c
c
	subroutine u$sear_(base,buf,keys,nkey,mark,erro)
c	************************************************
c
	implicit none
c
	integer base,keys(*),nkey,mark,erro
	character*(*) buf
c
c	Description
c	===========
c
c	Executes SEARCH command stored in BUF. BUF is supposed to contain
c	something like "SEARCH DATABASE... SCOPE ... FOR ..." or just
c	"DATABASE... SCOPE... FOR...".
c	If DATABASE to search is specified in BUF, that data base is
c	searched; if not, base channel BASE is used as data base to
c	search.
c
c	Record numbers that satisfy search command are returned in
c	array KEYS, up to NKEY. NKEY = 0 if no such record found.
c
c	MARK, if .gt. 0, will point to expected error location in BUF.
c
c	Note that only alive records will be searched.
c
c	CAUTION: if user specifies DATABASE XPTO in SEARCH command string, BASE
c	         will be changed into XPTO base channel upon completion.
c
c
c	ERRO = 0 if ok.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer irec,recnum,type,val,dec,lim,p1,p2
	real rval
	logical eobm
c
c	begin
c	=====
c
	call errclr_('U$SEAR')
	erro=0
c
	d$itrv=0			!tell I am not interactive
	call init_(erro)		!init DBAG
	if (erro.ne.0) goto 900
c
	nkey=0
c
	if (base.lt.0.or.
     1      base.gt.d$b  ) goto 90001	!invalid base channel
c
	if (istrip_(buf).le.0) goto 90002!buffer is empty
c
	if (base.gt.0) then
	   if (d$base(base).gt.0) call i$scur_(base,0,0)!make it the current one
	endif
c
	call rstok_(buf,1,erro)			!reset buffer
	if (erro.ne.0) goto 900
c
c	Get rid of SEARCH keyword if present
c
	erro=0					!only my own messages
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (erro.ne.0) goto 900
c
	call seetab_(cmdtok,cmdtop,cmdpos,buf(p1:p2),minchr)	!see if there
	if (cmdpos.ne.39) then			!it isn't SEARCH
	   call rstok_(buf,1,erro)		!reset buffer again
	   if (erro.ne.0) goto 900
	else
	   if (istrip_(buf(p2+1:)).le.0)
     1        goto 90002			!buffer has just SEARCH
	endif
c
	mark=0
	call s$earc_(buf,mark)			!do search
	if (d$erro.ne.0) then
	   erro=d$erro
	   goto 900
	endif
c
c	return search bit map as an integer array
c
	irec=0					!internal (begin at first)
	eobm=.false.				!...
	call bitnxt_(%val(bitpnt(c$base)),irec,eobm,erro)!first selected rec.
	if (erro.ne.0) goto 900			!error, carry
	if (eobm) goto 900			!no record found
c
cwhile	do while (.not.eobm)
1098	continue
	   if (eobm) goto 1099
c
	   call in3ex_(c$base,irec,recnum,erro)	!external form
	   if (erro.ne.0) goto 900
	   nkey=nkey+1
	   keys(nkey)=recnum
	   call bitnxt_(%val(bitpnt(c$base)),irec,eobm,erro)!next selected rec.
	   if (erro.ne.0) goto 900		!error, carry
c
	   goto 1098
1099	continue
cwhile	enddo
c
c	Return
c
900	continue
c
	if (erro.ne.0.and.
     1      c$base.ne.0.and.
     1      c$base.ne.base  ) base=c$base	!return used base channel
c
	return
c
c	Errors
c	======
c
c	invalid base channel
90001	continue
	erro=1
	goto 99000
c	no SEARCH command
90002	continue
	erro=2
	goto 99000
c
99000	continue
	call errset_('U$SEAR',erro)
	return
c
	end
c
c
c
c
c
	subroutine u$rest_(base,buf,mark,erro)
c	**************************************
c
	implicit none
c
	integer base,mark,erro
	character*(*) buf
c
c	Description
c	===========
c
c	Executes RESTORE command stored in BUF. BUF is supposed to contain
c	something like "RESTORE SEARCH!DISPLAY!COMMANDS FROM <file.ext>"
c	or just "SEARCH!DISPLAY!COMMANDS FROM <file.ext>", into data base
c	BASE context.
c
c	MARK, if .gt. 0, will point to expected error location in BUF.
c
c	ERRO = 0 if ok.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer type,val,dec,lim,p1,p2
	real rval
c
c	begin
c	=====
c
	call errclr_('U$REST')
	erro=0
c
	d$itrv=0			!tell I am not interactive
	call init_(erro)		!init DBAG
	if (erro.ne.0) goto 900
c
	if (base.lt.0.or.
     1      base.gt.d$b  ) goto 90001	!invalid base channel
c
	if (istrip_(buf).le.0) goto 90002!buffer is empty
c
	if (base.gt.0) then
	   if (d$base(base).le.0) goto 90003	!base not open
	   call i$scur_(base,0,0)		!make it the current one
	endif
c
	call rstok_(buf,1,erro)			!reset buffer
	if (erro.ne.0) goto 900
c
c	Get rid of RESTORE keyword if present
c
	erro=0					!only my own messages
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (erro.ne.0) goto 900
c
	call seetab_(cmdtok,cmdtop,cmdpos,buf(p1:p2),minchr)	!see if there
	if (cmdpos.ne.42) then			!it isn't RESTORE
	   call rstok_(buf,1,erro)		!reset buffer again
	   if (erro.ne.0) goto 900
	else
	   if (istrip_(buf(p2+1:)).le.0)
     1        goto 90002			!buffer has just RESTORE
	endif
c
	mark=0
	call r$esto_(buf,mark)			!do restore
	if (d$erro.ne.0) then
	   erro=d$erro
	   goto 900				!error, return
	endif
c
c	Return
c
900	continue
c
	base=c$base				!return used base channel
c
	return
c
c	Errors
c	======
c
c	invalid base channel
90001	continue
	erro=1
	goto 99000
c	no RESTORE command
90002	continue
	erro=2
	goto 99000
c	base not open
90003	continue
	erro=3
	goto 99000
c
99000	continue
	call errset_('U$REST',erro)
	return
c
	end
c
c
c
c
	subroutine u$save_(base,buf,mark,erro)
c	**************************************
c
	implicit none
c
	integer base,mark,erro
	character*(*) buf
c
c	Description
c	===========
c
c	Executes SAVE command stored in BUF. BUF is supposed to contain
c	something like "SAVE SEARCH!DISPLAY!COMMANDS FROM <file.ext>"
c	or just "SEARCH!DISPLAY!COMMANDS FROM <file.ext>", into data base
c	BASE context.
c
c	MARK, if .gt. 0, will point to expected error location in BUF.
c
c	ERRO = 0 if ok.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer type,val,dec,lim,p1,p2
	real rval
c
c	begin
c	=====
c
	call errclr_('U$SAVE')
	erro=0
c
	d$itrv=0			!tell I am not interactive
	call init_(erro)		!init DBAG
	if (erro.ne.0) goto 900
c
	if (base.lt.0.or.
     1      base.gt.d$b  ) goto 90001	!invalid base channel
c
	if (istrip_(buf).le.0) goto 90002!buffer is empty
c
	if (base.gt.0) then
	   if (d$base(base).le.0) goto 90003	!base not open
	   call i$scur_(base,0,0)		!make it the current one
	endif
c
	call rstok_(buf,1,erro)			!reset buffer
	if (erro.ne.0) goto 900
c
c	Get rid of SAVE keyword if present
c
	erro=0					!only my own messages
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (erro.ne.0) goto 900
c
	call seetab_(cmdtok,cmdtop,cmdpos,buf(p1:p2),minchr)	!see if there
	if (cmdpos.ne.41) then			!it isn't SAVE
	   call rstok_(buf,1,erro)		!reset buffer again
	   if (erro.ne.0) goto 900
	else
	   if (istrip_(buf(p2+1:)).le.0)
     1        goto 90002			!buffer has just SAVE
	endif
c
	mark=0
	call s$ave_(buf,mark)			!do save
	if (d$erro.ne.0) then
	   erro=d$erro
	   goto 900				!error, return
	endif
c
c	Return
c
900	continue
c
	base=c$base				!return used base channel
c
	return
c
c	Errors
c	======
c
c	invalid base channel
90001	continue
	erro=1
	goto 99000
c	no SAVE command
90002	continue
	erro=2
	goto 99000
c	base not open
90003	continue
	erro=3
	goto 99000
c
99000	continue
	call errset_('U$SAVE',erro)
	return
c
	end
c
c
c
c
	subroutine u$use_(base,buf,mark,erro)
c	*************************************
c
	implicit none
c
	integer base,mark,erro
	character*(*) buf
c
c	Description
c	===========
c
c	Executes USE/OPEN command stored in BUF. BUF is supposed to contain
c	something like "USE/OPEN whatever ..." or just "whatever ...".
c
c	MARK, if .gt. 0, will point to expected error location in BUF.
c
c	BASE returns used base channel, if any.
c
c	ERRO = 0 if ok.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer type,val,dec,lim,p1,p2
	real rval
c
c	begin
c	=====
c
	call errclr_('U$USE')
	erro=0
c
	base=0
	d$itrv=0			!tell I am not interactive
	call init_(erro)		!init DBAG
	if (erro.ne.0) goto 900
c
	if (istrip_(buf).le.0) goto 90001!buffer is empty
c
	call rstok_(buf,1,erro)			!reset buffer
	if (erro.ne.0) goto 900
c
c	Get rid of USE/OPEN keyword if present
c
	erro=0					!only my own messages
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (erro.ne.0) goto 900
c
	call seetab_(cmdtok,cmdtop,cmdpos,buf(p1:p2),minchr)	!see if there
	if (cmdpos.ne.36.and.cmdpos.ne.44) then	!it isn't USE/OPEN
	   call rstok_(buf,1,erro)		!reset buffer again
	   if (erro.ne.0) goto 900
	else
	   if (istrip_(buf(p2+1:)).le.0)
     1        goto 90001			!buffer has just USE/OPEN
	endif
c
	mark=0
	call u$se_(buf,mark)			!do use/open
	if (d$erro.ne.0) then
	   erro=d$erro
	   goto 900				!error, return
	endif
c
	base=c$base				!return used base
c
c	Return
c
900	continue
c
	return
c
c	Errors
c	======
c
c	no USE/OPEN command
90001	continue
	erro=1
	goto 99000
c
99000	continue
	call errset_('U$USE',erro)
	return
c
	end
c
c
c
c
	subroutine u$clos_(base,buf,mark,erro)
c	**************************************
c
	implicit none
c
	integer base,mark,erro
	character*(*) buf
c
c	Description
c	===========
c
c	Executes CLOSE command stored in BUF. BUF is supposed to contain
c	something like "CLOSE whatever ..." or just "whatever ...".
c
c	MARK, if .gt. 0, will point to expected error location in BUF.
c
c	ERRO = 0 if ok.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer type,val,dec,lim,p1,p2
	real rval
c
c	begin
c	=====
c
	call errclr_('U$CLOSE')
	erro=0
c
	d$itrv=0			!tell I am not interactive
	call init_(erro)		!init DBAG
	if (erro.ne.0) goto 900
c
	if (base.lt.0.or.
     1      base.gt.d$b  ) goto 90001	!invalid base channel
c
	if (base.gt.0) then
	   if (d$base(base).gt.0) call i$scur_(base,0,0)!make it the current one
	endif
c
	call rstok_(buf,1,erro)			!reset buffer
	if (erro.ne.0) goto 900
c
c	Get rid of CLOSE keyword if present
c
	erro=0					!only my own messages
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (erro.ne.0) goto 900
c
	call seetab_(cmdtok,cmdtop,cmdpos,buf(p1:p2),minchr)	!see if there
	if (cmdpos.ne.43) then			!it isn't CLOSE
	   call rstok_(buf,1,erro)		!reset buffer again
	   if (erro.ne.0) goto 900
	else
	   if (istrip_(buf(p2+1:)).le.0)
     1        goto 90001			!buffer has just CLOSE
	endif
c
	mark=0
	call c$lose_(buf,mark)			!do close
	if (d$erro.ne.0) then
	   erro=d$erro
	   goto 900				!error, return
	endif
c
c	Return
c
900	continue
c
	return
c
c	Errors
c	======
c
c	invalid base channel
90001	continue
	erro=1
	goto 99000
99000	continue
	call errset_('U$CLOS',erro)
	return
c
	end
c
c
c
c
	subroutine u$crea_(base,buf,mark,erro)
c	**************************************
c
	implicit none
c
	integer base,mark,erro
	character*(*) buf
c
c	Description
c	===========
c
c	Executes CREATE command stored in BUF. BUF is supposed to contain
c	something like "CREATE whatever ..." or just "whatever ...".
c
c	MARK, if .gt. 0, will point to expected error location in BUF.
c
c	BASE isn't used yet.
c
c	ERRO = 0 if ok.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer type,val,dec,lim,p1,p2
	real rval
c
c	begin
c	=====
c
	call errclr_('U$CREA')
	erro=0
c
	d$itrv=0			!tell I am not interactive
	call init_(erro)		!init DBAG
	if (erro.ne.0) goto 900
c
	if (istrip_(buf).le.0) goto 90001!buffer is empty
c
	call rstok_(buf,1,erro)			!reset buffer
	if (erro.ne.0) goto 900
c
c	Get rid of CREATE keyword if present
c
	erro=0					!only my own messages
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (erro.ne.0) goto 900
c
	call seetab_(cmdtok,cmdtop,cmdpos,buf(p1:p2),minchr)	!see if there
	if (cmdpos.ne.7) then			!it isn't CREATE
	   call rstok_(buf,1,erro)		!reset buffer again
	   if (erro.ne.0) goto 900
	else
	   if (istrip_(buf(p2+1:)).le.0)
     1        goto 90001			!buffer has just CREATE
	endif
c
	mark=0
	call c$reat_(buf,mark)			!do create
	if (d$erro.ne.0) then
	   erro=d$erro
	   goto 900				!error, return
	endif
c
c	Return
c
900	continue
c
	return
c
c	Errors
c	======
c
c	no CREATE command
90001	continue
	erro=1
	goto 99000
c
99000	continue
	call errset_('U$CREA',erro)
	return
c
	end
c
c
c
c
	subroutine u$modi_(base,buf,mark,erro)
c	**************************************
c
	implicit none
c
	integer base,mark,erro
	character*(*) buf
c
c	Description
c	===========
c
c	Executes MODIFY command stored in BUF. BUF is supposed to contain
c	something like "MODIFY whatever ..." or just "whatever ...".
c
c	MARK, if .gt. 0, will point to expected error location in BUF.
c
c	BASE isn't used yet.
c
c	ERRO = 0 if ok.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer type,val,dec,lim,p1,p2
	real rval
c
c	begin
c	=====
c
	call errclr_('U$MODI')
	erro=0
c
	d$itrv=0			!tell I am not interactive
	call init_(erro)		!init DBAG
	if (erro.ne.0) goto 900
c
	if (istrip_(buf).le.0) goto 90001!buffer is empty
c
	call rstok_(buf,1,erro)			!reset buffer
	if (erro.ne.0) goto 900
c
c	Get rid of MODIFY keyword if present
c
	erro=0					!only my own messages
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (erro.ne.0) goto 900
c
	call seetab_(cmdtok,cmdtop,cmdpos,buf(p1:p2),minchr)	!see if there
	if (cmdpos.ne.20) then			!it isn't MODIFY
	   call rstok_(buf,1,erro)		!reset buffer again
	   if (erro.ne.0) goto 900
	else
	   if (istrip_(buf(p2+1:)).le.0)
     1        goto 90001			!buffer has just MODIFY
	endif
c
	mark=0
	call m$odif_(buf,mark)			!do modify
	if (d$erro.ne.0) then
	   erro=d$erro
	   goto 900				!error, return
	endif
c
c	Return
c
900	continue
c
	return
c
c	Errors
c	======
c
c	no MODIFY command
90001	continue
	erro=1
	goto 99000
c
99000	continue
	call errset_('U$MODI',erro)
	return
c
	end
c
c
c
c
	subroutine u$copy_(base,buf,mark,erro)
c	**************************************
c
	implicit none
c
	integer base,mark,erro
	character*(*) buf
c
c	Description
c	===========
c
c	Executes COPY command stored in BUF. BUF is supposed to contain
c	something like "COPY whatever ..." or just "whatever ...".
c
c	MARK, if .gt. 0, will point to expected error location in BUF.
c
c	BASE isn't used yet.
c
c	ERRO = 0 if ok.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer type,val,dec,lim,p1,p2
	real rval
	logical sconf
c
c	begin
c	=====
c
	call errclr_('U$COPY')
	erro=0
c
	d$itrv=0			!tell I am not interactive
	call init_(erro)		!init DBAG
	if (erro.ne.0) goto 900
c
	if (istrip_(buf).le.0) goto 90001!buffer is empty
c
	call rstok_(buf,1,erro)			!reset buffer
	if (erro.ne.0) goto 900
c
c	Get rid of COPY keyword if present
c
	erro=0					!only my own messages
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (erro.ne.0) goto 900
c
	call seetab_(cmdtok,cmdtop,cmdpos,buf(p1:p2),minchr)	!see if there
	if (cmdpos.ne.5) then			!it isn't COPY
	   call rstok_(buf,1,erro)		!reset buffer again
	   if (erro.ne.0) goto 900
	else
	   if (istrip_(buf(p2+1:)).le.0)
     1        goto 90001			!buffer has just COPY
	endif
c
	mark=0
	call c$opy_(buf,mark)			!do COPY
	if (d$erro.ne.0) then
	   erro=d$erro
	   goto 900				!error, return
	endif
c
c	Return
c
900	continue
c
	return
c
c	Errors
c	======
c
c	no COPY command
90001	continue
	erro=1
	goto 99000
c
99000	continue
	call errset_('U$COPY',erro)
	return
c
	end
c
c
c
c
	subroutine u$dele_(base,buf,blind,mark,erro)
c	********************************************
c
	implicit none
c
	integer base,mark,erro
	logical blind
	character*(*) buf
c
c	Description
c	===========
c
c	Executes DELETE command stored in BUF. BUF is supposed to contain
c	something like "DELETE whatever ..." or just "whatever ...".
c
c	No confirm will be needed (!) if BLIND = .true.
c
c	MARK, if .gt. 0, will point to expected error location in BUF.
c
c	BASE isn't used yet.
c
c	ERRO = 0 if ok.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer type,val,dec,lim,p1,p2
	real rval
	logical sconf
c
c	begin
c	=====
c
	call errclr_('U$DELE')
	erro=0
c
	d$itrv=0			!tell I am not interactive
	call init_(erro)		!init DBAG
	if (erro.ne.0) goto 900
c
	if (istrip_(buf).le.0) goto 90001!buffer is empty
c
c	Set DBAG global parameters
c
	sconf=s$set(s$conf)			!save them for later
c
	if (blind) then
	   s$set(s$conf)=.false.
	else
	   s$set(s$conf)=.true.
	endif
c
	call rstok_(buf,1,erro)			!reset buffer
	if (erro.ne.0) goto 900
c
c	Get rid of DELETE keyword if present
c
	erro=0					!only my own messages
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (erro.ne.0) goto 900
c
	call seetab_(cmdtok,cmdtop,cmdpos,buf(p1:p2),minchr)	!see if there
	if (cmdpos.ne.8) then			!it isn't DELETE
	   call rstok_(buf,1,erro)		!reset buffer again
	   if (erro.ne.0) goto 900
	else
	   if (istrip_(buf(p2+1:)).le.0)
     1        goto 90001			!buffer has just DELETE
	endif
c
	mark=0
	call d$elet_(buf,mark)			!do delete
	if (d$erro.ne.0) then
	   erro=d$erro
	   goto 900				!error, return
	endif
c
c	Return
c
900	continue
c
c	Restore DBAG global parameters
c
	s$set(s$conf)=sconf
c
	return
c
c	Errors
c	======
c
c	no DELETE command
90001	continue
	erro=1
	goto 99000
c
99000	continue
	call errset_('U$DELE',erro)
	return
c
	end
c
c
c
c
	subroutine u$zero_(base,buf,blind,mark,erro)
c	********************************************
c
	implicit none
c
	integer base,mark,erro
	logical blind
	character*(*) buf
c
c	Description
c	===========
c
c	Executes ZERO command stored in BUF. BUF is supposed to contain
c	something like "ZERO whatever ..." or just "whatever ...".
c
c	No confirm will be needed (!) if BLIND = .true.
c
c	MARK, if .gt. 0, will point to expected error location in BUF.
c
c	BASE isn't used yet.
c
c	ERRO = 0 if ok.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer type,val,dec,lim,p1,p2
	real rval
	logical sconf
c
c	begin
c	=====
c
	call errclr_('U$ZERO')
	erro=0
c
	d$itrv=0			!tell I am not interactive
	call init_(erro)		!init DBAG
	if (erro.ne.0) goto 900
c
	if (istrip_(buf).le.0) goto 90001!buffer is empty
c
c	Set DBAG global parameters
c
	sconf=s$set(s$conf)			!save them for later
c
	if (blind) then
	   s$set(s$conf)=.false.
	else
	   s$set(s$conf)=.true.
	endif
c
	call rstok_(buf,1,erro)			!reset buffer
	if (erro.ne.0) goto 900
c
c	Get rid of ZERO keyword if present
c
	erro=0					!only my own messages
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (erro.ne.0) goto 900
c
	call seetab_(cmdtok,cmdtop,cmdpos,buf(p1:p2),minchr)	!see if there
	if (cmdpos.ne.48) then			!it isn't ZERO
	   call rstok_(buf,1,erro)		!reset buffer again
	   if (erro.ne.0) goto 900
	else
	   if (istrip_(buf(p2+1:)).le.0)
     1        goto 90001			!buffer has just ZERO
	endif
c
	mark=0
	call z$ero_(buf,mark)			!do zero
	if (d$erro.ne.0) then
	   erro=d$erro
	   goto 900				!error, return
	endif
c
c	Return
c
900	continue
c
c	Restore DBAG global parameters
c
	s$set(s$conf)=sconf
c
	return
c
c	Errors
c	======
c
c	no ZERO command
90001	continue
	erro=1
	goto 99000
c
99000	continue
	call errset_('U$ZERO',erro)
	return
c
	end
c
c
c
c
	subroutine u$set_(buf,mark,erro)
c	********************************
c
	implicit none
c
	integer mark,erro
	character*(*) buf
c
c	Description
c	===========
c
c	Executes SET command stored in BUF. BUF is supposed to contain
c	something like "SET WIDTH 132" or just "WIDTH 132".
c
c	MARK, if .gt. 0, will point to expected error location in BUF.
c
c	ERRO = 0 if ok.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer type,val,dec,lim,p1,p2
	real rval
c
c	begin
c	=====
c
	call errclr_('U$SET')
	erro=0
c
	d$itrv=0			!tell I am not interactive
	call init_(erro)		!init DBAG
	if (erro.ne.0) goto 900
c
	if (istrip_(buf).le.0) goto 90001!buffer is empty
c
	call rstok_(buf,1,erro)			!reset buffer
	if (erro.ne.0) goto 900
c
c	Get rid of SET keyword if present
c
	erro=0					!only my own messages
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (erro.ne.0) goto 900
c
	call seetab_(cmdtok,cmdtop,cmdpos,buf(p1:p2),minchr)	!see if there
	if (cmdpos.ne.30) then			!it isn't SET
	   call rstok_(buf,1,erro)		!reset buffer again
	   if (erro.ne.0) goto 900
	else
	   if (istrip_(buf(p2+1:)).le.0)
     1        goto 90001			!buffer has just SET
	endif
c
	mark=0
	call s$et_(buf,mark)			!do set
	if (d$erro.ne.0) then
	   erro=d$erro
	   goto 900				!error, return
	endif
c
c	Return
c
900	continue
c
	return
c
c	Errors
c	======
c
c	no SET command
90001	continue
	erro=1
	goto 99000
c
99000	continue
	call errset_('U$SET',erro)
	return
c
	end
c
c
c
c
	subroutine u$exit_(buf,mark,erro)
c	*********************************
c
	implicit none
c
	integer mark,erro
	character*(*) buf
c
c	Description
c	===========
c
c	Executes EXIT/QUIT command stored in BUF. BUF is supposed to contain
c	something like "EXIT/QUIT whatever ..." or just "whatever ...".
c
c	MARK, if .gt. 0, will point to expected error location in BUF.
c
c	ERRO = 0 if ok.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer type,val,dec,lim,p1,p2
	real rval
c
c	begin
c	=====
c
	call errclr_('U$EXIT')
	erro=0
c
	d$itrv=0			!tell I am not interactive
	call init_(erro)		!init DBAG
	if (erro.ne.0) goto 900
c
	call rstok_(buf,1,erro)			!reset buffer
	if (erro.ne.0) goto 900
c
c	Get rid of EXIT/QUIT keyword if present
c
	erro=0					!only my own messages
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (erro.ne.0) goto 900
c
	call seetab_(cmdtok,cmdtop,cmdpos,buf(p1:p2),minchr)	!see if there
	if (cmdpos.ne.11.and.cmdpos.ne.22) then	!it isn't EXIT/QUIT
	   call rstok_(buf,1,erro)		!reset buffer again
	   if (erro.ne.0) goto 900
	endif
c
	mark=0
	call e$xit_(buf,mark)			!do exit/quit
	if (d$erro.ne.0) then
	   erro=d$erro
	   goto 900				!error, return
	endif
c
c	Return
c
900	continue
c
	return
c
c	Errors
c	======
c
	end
c
c
c
c
	subroutine u$help_(buf,mark,erro)
c	*********************************
c
	implicit none
c
	integer mark,erro
	character*(*) buf
c
c	Description
c	===========
c
c	Executes HELP command stored in BUF. BUF is supposed to contain
c	something like "HELP whatever ..." or just "whatever ...".
c
c	MARK, if .gt. 0, will point to expected error location in BUF.
c
c	ERRO = 0 if ok.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer type,val,dec,lim,p1,p2
	real rval
c
c	begin
c	=====
c
	call errclr_('U$HELP')
	erro=0
c
	d$itrv=0			!tell I am not interactive
	call init_(erro)		!init DBAG
	if (erro.ne.0) goto 900
c
	call rstok_(buf,1,erro)			!reset buffer
	if (erro.ne.0) goto 900
c
c	Get rid of HELP keyword if present
c
	erro=0					!only my own messages
	call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	if (erro.ne.0) goto 900
c
	call seetab_(cmdtok,cmdtop,cmdpos,buf(p1:p2),minchr)	!see if there
	if (cmdpos.ne.11.and.cmdpos.ne.22) then	!it isn't HELP
	   call rstok_(buf,1,erro)		!reset buffer again
	   if (erro.ne.0) goto 900
	endif
c
	mark=0
	call h$elp_(buf,mark)			!do help
	if (d$erro.ne.0) then
	   erro=d$erro
	   goto 900				!error, return
	endif
c
c	Return
c
900	continue
c
	return
c
c	Errors
c	======
c
	end
c
c
c
c
