c	DBAGVMS.FOR
c	===========
c
c	All (?) machine dependant procedures.
c
c	Screen manipulation
c
c	set_cursor_(line,col)
c	set_scroll_(scrol1,scrol2)
c	erase_page_(line,col)
c	erase_line_(line,col)
c	put_screen_(text,line,col,blink)
c	up_scroll_
c	down_scroll_
c
c	Terminal i/o
c
c	tty_putc_(char)
c	tty_echo_(onoff)
c
c	Variable formats (i<n>, f<m<.<n>)
c
c	rdfvar_(buf,dd,totd,deci,error)
c	wrfvar_(buf,dd,totd,deci,error)
c	rdivar_(buf,ival,dig,error)
c	wrivar_(buf,ival,dig,error)
c	wrivar2_(buf,ival,dig,out,error)
c
c	File searching/sorting
c
c	find_file_(fspec,respec,contxt,status)
c	nsort_(fname1,fname2,key)
c
c	Process identification, uesr's name, etc.
c
c	getpid_(mypid)
c	monkey_(ego,ok)
c	myself_(name)
c	mydir_(direct)
c
c	Miscellaneous
c
c	get_lun_(lun)	*** not used anymore ***
c	free_lun_(lun)	*** not used anymore ***
c	spawn_(cmmd)
c	wait_(wait)
c	ttybrd_(broadcast)
c	usrbat_(batch)
c
c
c
	subroutine get_vm_(bytes,where,erro)
c
	implicit none
c
	integer bytes,where,erro
c
c	Description
c	===========
c
c	Allocate a certain number of BYTES someWHERE.
c	ERRO = 1 if memory allocation failure.
c
c	var
c	===
c
	external lib$get_vm
	integer lib$get_vm
	integer i
c
c	begin
c	=====
c
	erro=0
	i=lib$get_vm(bytes,where)
	if (i.ne.1) erro=1
c
	return
c
	end
c
c
c
c
	subroutine free_vm_(bytes,where,erro)
c
	implicit none
c
	integer bytes,where,erro
c
c	Description
c	===========
c
c	De-allocate a certain number of BYTES someWHERE.
c	ERRO = 1 if memory de-allocation failure.
c
c	var
c	===
c
	external lib$free_vm
	integer lib$free_vm
	integer i
c
c	begin
c	=====
c
	erro=0
	i=lib$free_vm(bytes,where)
	if (i.ne.1) erro=1
c
	return
c
	end
c
c
c
c
	subroutine set_cursor_(line,col)
c
	implicit none
c
	integer line,col
c
c	Description
c	===========
c
c	Set the screen cursor to line LINE, column COL.
c
c	var
c	===
c
c	begin
c	=====
c
	call lib$set_cursor(line,col)
c
	return
c
	end
c
c
c
c
	subroutine erase_page_(line,col)
c
	implicit none
c
	integer line,col
c
c	Description
c	===========
c
c	Erase screen down from line LINE, column COL.
c
c	var
c	===
c
c	begin
c	=====
c
	call lib$erase_page(line,col)
c
	return
c
	end
c
c
c
c
	subroutine set_scroll_(scrol1,scrol2)
c
	implicit none
c
	integer scrol1,scrol2
c
c	Description
c	===========
c
c	Set scroll from line SCROL1 thru line SCROL2.
c
c	var
c	===
c
c	begin
c	=====
c
	call lib$set_scroll(scrol1,scrol2)
c
	return
c
	end
c
c
c
c
	subroutine erase_line_(line,col)
c
	implicit none
c
	integer line,col
c
c	Description
c	===========
c
c	Erase line LINE from column COL.
c
c	var
c	===
c
c	begin
c	=====
c
	call lib$erase_line(line,col)
c
	return
c
	end
c
c
c
c
	subroutine put_screen_(text,line,col,blink)
c
	implicit none
c
	character*(*) text
	integer line,col,blink
c
c	Description
c	===========
c
c	Display TEXT onto line LINE, column COL, with BLINK attributes.
c
c	var
c	===
c
c	begin
c	=====
c
	call lib$put_screen(text,line,col,blink)
c
	return
c
	end
c
c
c
c
	subroutine up_scroll_
c
	implicit none
c
c	Description
c	===========
c
c	Set up scrolling.
c
c	var
c	===
c
c	begin
c	=====
c
	call lib$up_scroll
c
	return
c
	end
c
c
c
c
	subroutine down_scroll_
c
	implicit none
c
c	Description
c	===========
c
c	Set down scrolling.
c
c	var
c	===
c
c	begin
c	=====
c
	call lib$down_scroll
c
	return
c
	end
c
c
c
c
	subroutine tty_putc_(char)
c
	implicit none
c
	character*1 char
c
c	Description
c	===========
c
c	Writes character CHAR to the terminal.
c
c	var
c	===
c
c	begin
c	=====
c
	call tty$putc(char)
c
	return
c
	end
c
c
c
c
	integer function tty_getc_
c
	implicit none
c
	integer char
c
c	Description
c	===========
c
c	Read character (ascii code) from terminal.
c
c	var
c	===
c
	external tty$getc
	integer tty$getc
c
c	begin
c	=====
c
	tty_getc_=tty$getc()
c
	return
c
	end
c
c
c
c
	subroutine tty_echo_(onoff)
c
	implicit none
c
	logical onoff
c
c	Description
c	===========
c
c	Sets echo on/off.
c
c	var
c	===
c
c	begin
c	=====
c
	call tty$echo(onoff)
c
	return
c
	end
c
c
c
c
	subroutine getpid_(mypid)
c	*************************
c
	implicit none
c
	integer mypid
c
c	Description
c	===========
c
c	Machine process identification, diferent for each user.
c	Used typically for locking,  non-locking the access to
c	a data bag for updates.  It is  NOT the signature used
c	in data bags at creation time.
c
c	var
c	===
c
	integer*4 junk
	include '($JPIDEF)'
	integer*2 item_code, buffer_length
	integer*4 buffer_address, return_length_address
	common /xpto/ buffer_length, item_code,
     1   	      buffer_address, return_length_address
c
c	begin
c	=====
c
	mypid=0
	item_code = JPI$_PID
	buffer_length = 4
	buffer_address = %loc(mypid)
	return_length_address = %loc(junk)
	call sys$getjpi(,,,buffer_length,,,)
	return
c
	end
c
c
c
c
	subroutine monkey_(ego,ok)
c	**************************
c
	integer ego
	logical ok
c
c	description
c	===========
c
c	Gets the machine identification number and
c	checks if ok.
c
c	var
c	===
c
	integer me/20453409/
	integer sysid
c
	integer sys$getsyi
	integer*2 w1,w2
	integer*4 l1,l2
c
	common/sysego/
     1         w1,w2,l1,l2
c
	data w1/4/
	data w2/'00000201'x/
c
c	begin
c	=====
c
	l1=%loc(ego)
	l2=%loc(kkk)
c
	i=sys$getsyi(,,,w1,,,)
c
	if (ego.eq.me) then
	   ok=.true.
	else
	   ok=.false.
	endif
c
	return
c
c
	end
c
c
c
c
c
	subroutine myself_(name)
c	************************
c
	implicit none
c
	character*(*) name
c
c	Description
c	===========
c
c	Gives the current user name in string NAME (=<12 char).
c
c	var
c	===
c
	include '($jpidef)'
c
	integer sys$getjpiw
	integer dummy
c
	character*12	txt
c
	structure/itmlst/
	    integer*2 w1,w2
	    integer*4 l1,l2
	end structure
c
	record/itmlst/ parm
c
c	begin
c	=====
c
	parm.w1 = 12
	parm.w2 = jpi$_username
	parm.l1=%loc(txt(1:1))
	parm.l2=%loc(dummy)
	call sys$getjpiw(,,,parm,,,)
c
	name(1:)=' '
	name=txt
c
	return
c
c
	end
c
c
c
c
	subroutine myname_(name)
c	************************
c
	implicit none
c
	character*(*) name
c
c	Description
c	===========
c
c	Gives the current image name in string NAME.
c
c	var
c	===
c
	include '($jpidef)'
c
	integer sys$getjpiw
	integer dummy
c
	character*39	txt
	integer lim1,lim2
c
	structure/itmlst/
	    integer*2 w1,w2
	    integer*4 l1,l2
	end structure
c
	record/itmlst/ parm
c
c	begin
c	=====
c
	parm.w1 = 39
	parm.w2 = jpi$_imagname
	parm.l1=%loc(txt(1:1))
	parm.l2=%loc(dummy)
	call sys$getjpiw(,,,parm,,,)
c
	name(1:)=' '
c
	lim1=index(txt,']')
	if (lim1.gt.0) then
	   lim1=lim1+1
	   lim2=index(txt(lim1:),'.')
	   if (lim2.gt.0) then
	      lim2=lim1+lim2-2
	      if (lim2.lt.lim1) lim2=lim1
	      name=txt(lim1:lim2)
	   else
	      name=txt(lim1:)
	   endif
	else
	   name='?'
	endif
c
	return
c
c
	end
c
c
c
c
	subroutine mydir_(direct)
c	*************************
c
	implicit none
c
	character*(*) direct
c
c	Description
c	===========
c
c	Gives the current directory in string DIRECT.
c
c	var
c	===
c
	integer sys$setddir
c
c	begin
c	=====
c
	call sys$setddir(0,0,direct)
	return
c
c
	end
c
c
c
c
	subroutine get_lun_(lun)
c
	implicit none
c
	integer lun
c
c	Description
c	===========
c
c	Ask for a new i/o logical unit number in LUN, return 0 if none
c	available.
c
c		*** not used anymore ***
c
c	var
c	===
c
c	begin
c	=====
c
	call lib$get_lun(lun)
c
	return
c
	end
c
c
c
c
	subroutine free_lun_(lun)
c
	implicit none
c
	integer lun
c
c	Description
c	===========
c
c	Release logical i/o unit LUN to the system.
c
c		*** not used anymore ***
c
c	var
c	===
c
c	begin
c	=====
c
	call lib$free_lun(lun)
c
	return
c
	end
c
c
c
c
	subroutine spawn_(cmmd,fast,erro)
c
	implicit none
c
	character*(*) cmmd
	logical fast
	integer erro
c
c	Description
c	===========
c
c	Submit CMMD to the operating system.
c	If FAST = .true., as quick as possible.
c
c	var
c	===
c
	external cli$m_noclisym,cli$m_nolognam,cli$m_nokeypad
	external lib$spawn
	integer flags,lib$spawn
	integer i
c
c	begin
c	=====
c
	erro=0
c
	if (fast) then
	   flags=%loc(cli$m_noclisym).or.		!no CLI symbols
     1           %loc(cli$m_nolognam).or.		!no logical names
     1           %loc(cli$m_nokeypad)    		!no keypad symbols
	   i=lib$spawn(cmmd,,,flags)
	else
	   i=lib$spawn(cmmd)
	endif
c
	if (i.ne.1) erro=1
c
	return
c
	end
c
c
c
c
	subroutine wait_(wait)
c
	implicit none
c
	real wait
c
c	Description
c	===========
c
c	Wait WAIT seconds.
c
c	var
c	===
c
c	begin
c	=====
c
	call lib$wait(wait)
c
	return
c
	end
c
c
c
c
	subroutine rdfvar_(buf,dd,totd,deci,error)
c
	implicit none
c
	character*(*) buf
	integer totd,deci,error
	double precision dd
c
c	Description
c	===========
c
c	Read BUF into double precision value DD with total digits TOTD and
c	DECI decimals places.
c
c	ERROR # 0 if read error.
c
c	var
c	===
c
c	begin
c	=====
c
	error=0
	read (buf,fmt='(f<totd>.<deci>)',err=100) dd
	return
100	continue
	error=1
	return
c
	end
c
c
c
c
	subroutine wrfvar_(buf,dd,totd,deci,error)
c
	implicit none
c
	character*(*) buf
	integer totd,deci,error
	double precision dd
c
c	Description
c	===========
c
c	Write double precision value DD into BUF with total digits TOTD and
c	DECI decimals places.
c
c	ERROR # 0 if write error.
c
c	var
c	===
c
c	begin
c	=====
c
	error=0
	write (buf,fmt='(f<totd>.<deci>)',err=100) dd
	return
100	continue
	error=1
	return
c
	end
c
c
c
c
	subroutine rdivar_(buf,ival,dig,error)
c
	implicit none
c
	character*(*) buf
	integer ival,dig,error
c
c	Description
c	===========
c
c	Read BUF into integer value IVAL with DIG digits.
c
c	ERROR # 0 if read error.
c
c	var
c	===
c
c	begin
c	=====
c
	error=0
	read (buf,fmt='(i<dig>)',err=100) ival
	return
100	continue
	error=1
	return
c
	end
c
c
c
c
	subroutine wrivar_(buf,ival,dig,error)
c
	implicit none
c
	character*(*) buf
	integer ival,dig,error
c
c	Description
c	===========
c
c	Write into BUF integer value IVAL with DIG digits.
c
c	ERROR # 0 if write error.
c
c	var
c	===
c
c	begin
c	=====
c
	error=0
	write (buf,fmt='(i<dig>)',err=100) ival
	return
100	continue
	error=1
	return
c
	end
c
c
c
c
	subroutine wrivar2_(buf,ival,dig,out,error)
c
	implicit none
c
	character*(*) buf
	integer ival,dig,out,error
c
c	Description
c	===========
c
c	Write into BUF integer value IVAL with DIG max digits and OUT minimum
c	digits.
c
c	ERROR # 0 if write error.
c
c	var
c	===
c
c	begin
c	=====
c
	error=0
	write (buf,fmt='(i<dig>.<out>)',err=100) ival
	return
100	continue
	error=1
	return
c
	end
c
c
c
c
	subroutine find_file_(fspec,respec,contxt,eof)
c
	implicit none
c
	character*(*) fspec,respec
	integer contxt
	logical eof
c
c	Description
c	===========
c
c	Search for next file spec (RESPEC) that satisfies a given file spec,
c	optionally "wild carded" (FSPEC).
c	EOF = .false. means new file spec returned.
c
c	var
c	===
c
	external istrip_
	integer istrip_
	integer status
c
c	begin
c	=====
c
	eof=.false.
c
	call lib$find_file(fspec,respec,contxt,,,status)
c
	if (status.ne.0.or.
	1   istrip_(respec).le.0) eof=.true.
c
	return
c
	end
c
c
c
c
	subroutine nsort_(fname1,fname2,key)
c	************************************
c
	implicit none
c
	character*(*) fname1,fname2
	integer*2 key(*)
c
c	Description
c	===========
c
c	Calls VAX/VMS's SORT32. The input file to sort is FNAME1, sorted file
c	is FNAME2 (may be the same file); KEY goes as follows:
c
c	key( 1)	how many keys are used (see blocks that follow)
c
c	key( 2)	1 key type	|	(text, signed, etc)
c	key( 3)	0 ascending	|	refers to first key
c	key( 4) start position	|	(0 = first byte!)
c	key( 5) size of key	|	(as usual)
c
c	key( 6)	1		|
c	key( 7)	1 descending	|	refers to second key
c	key( 8) start position	|
c	key( 9) size of key	|
c
c	etc...
c
c	var
c	===
c
	integer*2 numwrk/3/,sortyp/1/	!3 work files, sort by record
c
c	begin
c	=====
c
	call sor$pass_files(fname1,fname2)
c
	call sor$begin_sort(key,,,,,,sortyp,numwrk)
c
	call sor$sort_merge()
c
	call sor$end_sort()
c
	return
c
	end
c
c
c
c
	subroutine ttybrd_(broadcast)
c
	implicit none
c
	logical broadcast
c
c	Returns BROADCAST = .true. if broadcast or error reading terminal
c	status, .false. otherwise.
c
	integer nc
	parameter (nc=2)
c
	external sys$getdvi
	integer sys$getdvi
	logical istat
	character*20 devnam
	integer*4 lcl_values(nc)
	integer*4 lcl_retlen(0:nc)
	include '($dvidef)'
	structure /getdvi_str/
	  union
	    map
	      integer*2 buflen,itmcod
	      integer*4 bufadr,retlen 
	    end map
	    map
	      integer*4 end_list
	    end map
	  end union
	end structure
	record /getdvi_str/ list(nc)
c
	list(1).itmcod=dvi$_tt_nobrdcst
	list(1).buflen=4
	list(1).bufadr=%loc(lcl_values(1))
	list(1).retlen=%loc(lcl_retlen(1))
	list(2).end_list=0
c
	devnam='tt:'
	istat=sys$getdvi(,,devnam,list,,,,)
	if (.not.istat) then
	   broadcast=.true.
	else
	   if (lcl_values(1).eq.1) then
	      broadcast=.false.
	   else
	      broadcast=.true.
	   endif
	endif
c
	return
c
	end
c
c
c
c
	subroutine usrbat_(batch)
c	*************************
c
	implicit none
c
	logical batch
c
c	Description
c	===========
c
c	Returns BATCH = .true. if a batch user.
c
c	var
c	===
c
	integer*4 junk,mymode
	include '($JPIDEF)'
	integer*2 item_code, buffer_length
	integer*4 buffer_address, return_length_address
	common /xpto/ buffer_length, item_code,
     1   	      buffer_address, return_length_address
c
c	begin
c	=====
c
	mymode=0
	item_code = JPI$_MODE
	buffer_length = 4
	buffer_address = %loc(mymode)
	return_length_address = %loc(junk)
	call sys$getjpi(,,,buffer_length,,,)
	if (mymode.eq.2) then
	   batch=.true.
	else
	   batch=.false.
	endif
c
	return
c
	end
c
c
c
c
