c	DBAGW.FOR
c	*********
c
c
c	Miscellaneous purpose facilities for the DBAG system
c
c
c	Written by Luis Arriaga da Cunha, Antonio Mota 1984
c	===================================================
c
c	Synopsisof procedures:
c
c	chklin  checks a line for min, max, etc
c	valida	validates field values
c	dummy	does strictly nothing, see CHKLIN
c	ttwdth	returns TTY with
c
c
c
	subroutine chklin_(fuser_,buffer,field,mandat,
     1                     lgth,kind,min,max,pic,mymssg,
     1                     error)
c	**********************************************
c
	implicit none
c
	external fuser_
	character*(*) buffer,mymssg
	integer field,lgth,kind,min,max,pic,error
	logical mandat
c
c	Description
c	===========
c
c	First of all, if MANDAT = .true., BUFFER shouldn't be empty. Then
c	verifies, according to  type of field FIELD given in  KIND,  whether
c	BUFFER is  acceptable in its form and in  regard  to MIN, MAX,
c	PIC.  PIC gives size for strings;for integer or decimal types
c	it   means  the  number_of_digits  for  the first,1000*number_
c	_of_decimal_places+number_of_digits  for the latter  ( what a
c	messy trick !!! ).
c	KIND equal  to  zero  means  no  checking  is  wanted  at all.
c	KIND  equal to  50  means  line  can NOT be changed so CHKLIN
c	shopuldn't    have    been    called (  cynical,  isn't it ?).
c	Types above 100 are user definable and can be verified by the
c	user supplied FUSER procedure.
c	Oh!, by the  way, MIN and MAX give the limits for number-like
c	types. For logical they dont matter. As usual ERROR if > zero.
c	If line is  empty  no check is actually done, also if PIC  is
c	zero.
c	BUFFER  is  used  up to  LGTH, of course.  In MYMSSG a possible
c	error message is given back.
c	If  all  OK the buffer is  perhaps re-arrenged for prettyness.
c
c       Remember that the types of fields are :
c
c	n$  =1	integer
c	c$  =2	string
c	db$ =3	other data base
c	x$  =4	decimal
c	d$  =5	date
c	l$  =6	logical
c	r$  =7  real
c	r8$ =8  double precision
c
c	 0	not to be checked
c
c	>= 100  user defined
c
c	>= 40, 60 or 80 - special fields, user defined as well ...
c
c	Var
c	===
c
	include 'own:dbagthin.own'
c
	external istrip_,lstrip_
	integer istrip_,lstrip_
c
	integer typ,val,dec,p1,p2,top,d,m,y,form
	real rval
	double precision ddval
	integer myerr,nodig,lim,k,sign,dot,siz,dis,v1,v2,dig1,xkind
	integer ty0,va0,de0,p01,p02
	real rva0
	character*15 adate,bdate,small*10,follw*5
	double precision dd
c
	real rmin,rmax
	integer imin,imax
	equivalence (imin,rmin)
	equivalence (imax,rmax)
c
c	Begin
c	=====
c
	call errclr_('CHKLIN')
	error=0
c
	if (lgth.le.0) return		!no jokes
c
	mymssg(1:)=' '
c
c	Nocheck ?
c	---------
c
	if (kind.eq.0) return
c
c	User defined ?
c	--------------
c
	if ( kind.ge.40) then
	   xkind=kind			!save field type
	   call fuser_(buffer,field,mandat,lgth,kind,min,max,pic,mymssg,
     1                 error)
	   kind=xkind			!restore field type
	   return
	endif
c
c	No, carry on
c	------------
c
	sign=+1
	dot=0
c
c	if buffer is empty do nothing, unless mandatory field
c
	k=istrip_(buffer)
	if (k.le.0) then
	   if (mandat) then
	      write(mymssg(1:),10033)	!mandatory, ca't be empty
	      error=29
	      goto 400
	   else
	      return			!empty, nothing to do
	   endif
	endif
c
	if (pic.eq.0) return		!size = 0, return
c
	if (kind.eq.c$.or.kind.eq.d$.or.
	1   kind.eq.r$.or.kind.eq.r8$  ) then
c	   nops		!dont scan buffer here for strings and dates !!
c			!and reals and double precisions
	else
	   call rstok_(buffer,1,error)	!start at beginning of buffer
	   error=0	!silence intok
	   call intok_(typ,val,dec,rval,buffer,lgth,p1,p2,mymssg,error)
	   if (error.ne.0) goto 110
	   if     (typ.eq.13) then	!"-"
	      sign=-1
	      call intok_(typ,val,dec,rval,buffer,lgth,p1,p2,mymssg,error)
	      if (error.ne.0) goto 110
	   elseif (typ.eq.12) then	!"+"
	      sign=+1
	      call intok_(typ,val,dec,rval,buffer,lgth,p1,p2,mymssg,error)
	      if (error.ne.0) goto 110
	   elseif (typ.eq.21) then	!"."
	      dot=1
	      call intok_(typ,val,dec,rval,buffer,lgth,p1,p2,mymssg,error)
	      if (error.ne.0) goto 110
	   endif
	   ty0=typ
	   call intok_(ty0,va0,de0,rva0,buffer,lgth,p01,p02,mymssg,error)
	   if (error.ne.0) goto 110
	   if (ty0.ne.0) then
	      write(mymssg(1:),10001)
	      error=1
	      goto 400
	   endif
	endif
c
c	dispatch
c
	goto (101,102,103,104,105,106,107,108) kind
c
	return
c
c	integer
c	-------
c
101	continue
	   if (dot.eq.1) then
	      write(mymssg(1:),10003)
	      error=3
	   else
	      val=val*sign
	      if (typ.eq.2) then
	         if (val.ge.min.and.val.le.max) then
c	            ok
	            siz=pic	!make room for sign !!!  pretty
	            call wrivar_(buffer,val,siz,myerr)	!pretty
	            if (myerr.ne.0) goto 90028		!write error
	         else
	            siz=pic
	            write(mymssg(1:),10002)		!limits ...
	            lim=istrip_(mymssg)+2
	            call wrivar_(mymssg(lim:),min,siz,myerr)!pretty minimum
	            if (myerr.ne.0) goto 90028		!write error
	            lim=istrip_(mymssg)+2
	            mymssg(lim:lim+2)=' , '
	            lim=lim+3
	            call wrivar_(mymssg(lim:),max,siz,myerr)!pretty maximum
	            if (myerr.ne.0) goto 90028		!write error
	            error=2
	         endif
	      else
	         write(mymssg(1:),10003)
	         error=3
	      endif
	   endif
	goto 400
c
c	string
c	------
c
102	continue
	   lim=istrip_(buffer)
	   if (lim.gt.pic) then
	      small(1:)=buffer(pic+1:lim)
	      if ( (lim-pic).gt.10) then
	         follw='...  '
	      else
	         follw='<ret>'
	      endif
	      lim=istrip_(small)
	      if (lim.le.0) lim=1		!hum...
	      write(mymssg(1:),10004)small(1:lim),follw(1:istrip_(follw)),pic
	      error=4
	   endif
	goto 400
c
c	other data base
c	---------------
c
103	continue
	   if (typ.eq.2) then
	      val=val*sign
	      if (min.eq.0.and.max.eq.0) then
	         write(mymssg(1:),10031)
	         error=27
	      elseif (val.lt.0) then
	         write(mymssg(1:),10017)
	         error=24
	      else
	         if (val.ge.min.and.val.le.max) then
c	            ok
	            siz=pic
	            call wrivar_(buffer,val,siz,myerr)	!pretty
	            if (myerr.ne.0) goto 90028		!write error
	         else
	            siz=pic
	            write(mymssg(1:),10005)		!limits ...
	            lim=istrip_(mymssg)+2
	            call wrivar_(mymssg(lim:),min,siz,myerr)!pretty minimum
	            if (myerr.ne.0) goto 90028		!write error
	            lim=istrip_(mymssg)+2
	            mymssg(lim:lim+2)=' , '
	            lim=lim+3
	            call wrivar_(mymssg(lim:),max,siz,myerr)!pretty maximum
	            if (myerr.ne.0) goto 90028		!write error
	            error=5
	         endif
	      endif
	   else
	      write(mymssg(1:),10006)
	      error=6
	   endif
	goto 400
c
c	decimal number
c	--------------
c
104	continue
	   val=val*sign
c
c	   special cases
c
	   if (dot.eq.1.and.typ.eq.2) then	!accept eg ".375" as decimal
	      typ=3
	      dec=p2-p1+1
	   elseif (typ.eq.2) then	   	!change integers -> decimals
	      typ=3
	      dec=0
	   endif
c
c	   here normal
c
	   if (typ.eq.3) then
c
c	      check decimal places
c
	      siz =mod(pic,1000)	!number of digits
	      dig1=pic/1000		!number of decimal places
	      if (dec.gt.dig1) then
	         write(mymssg(1:),10016)dig1
	         error=7
	         goto 400
	      else
	         if (dec.lt.dig1) then
	            dis=10.0**(dig1-dec)
	            v1=min/dis
	            v2=max/dis
	            if (val.lt.v1.or.val.gt.v2) then
	               error=8
	               goto 1044 	!forgive me GOD !!!
	            endif
	            val=val*dis
	            dec=dig1
	         endif
	      endif
c
	      if (val.ge.min.and.val.le.max) then
c	         ok
	         dd=val
	         dd=dd/(10.0**dec)
	         call wrfvar_(buffer,dd,siz,dec,myerr)	!pretty
	         if (myerr.ne.0) goto 90028		!write error
	      else
	         error=9
	         goto 1044 	!forgive me GOD !!!
	      endif
	   else
	      write(mymssg(1:),10008)
	      error=10
	   endif
	goto 400
c
1044	continue
	mymssg(1:)=' '
	write(mymssg(1:),10007)
	lim=istrip_(mymssg)+2
c
	dd=min
	dd=dd/(10.0**dig1)
	call wrfvar_(mymssg(lim:),dd,siz,dig1,myerr)	!pretty
	if (myerr.ne.0) goto 90028			!write error
	lim=istrip_(mymssg)+3
c
	dd=max
	dd=dd/(10.0**dig1)
	call wrfvar_(mymssg(lim:),dd,siz,dig1,myerr)	!pretty
	if (myerr.ne.0) goto 90028			!write error
	lim=istrip_(mymssg)+1
	goto 400
c
c	date
c	----
c
105	continue
	   call numdat_(val,buffer(1:),top,form,error)
	   if (error.eq.0) then
	      if (val.ge.min.and.val.le.max) then
c	         ok
	         call txtdat_(val,buffer(1:),error)	!pretty
	      else
	         call txtdat_(min,adate,error)
	         call txtdat_(max,bdate,error)
	         write(mymssg(1:),10009)adate(1:11),bdate(1:11)
	         error=11
	      endif
	   else
	      if (error.eq.1) then
	         write(mymssg(1:),10010)
	         error=12
	      elseif (error.eq.2) then
	         write(mymssg(1:),10012)
	         error=13
	      elseif (error.eq.3) then
	         write(mymssg(1:),10013)
	         error=14
	      elseif (error.eq.4) then
	         write(mymssg(1:),10029)
	         error=15
	      elseif (error.eq.5) then
	         write(mymssg(1:),10014)
	         error=16
	      elseif (error.eq.6) then
	         write(mymssg(1:),10025)
	         error=17
	      elseif (error.eq.7) then
	         write(mymssg(1:),10026)
	         error=18
	      elseif (error.eq.8) then
	         write(mymssg(1:),10027)
	         error=25
	      elseif (error.eq.9) then
	         write(mymssg(1:),10028)
	         error=26
	      else
	         write(mymssg(1:),10015)
	         error=19
	      endif
	   endif
	goto 400
c
c	logical
c	-------
c
106	continue
	   if (typ.eq.2) then
	      if (val.eq.0) then
c	         ok
	         buffer(1:)='f'		!pretty
	      elseif (val.eq.1) then
c	         ok
	         buffer(1:)='t'		!pretty
	      else
	         write(mymssg(1:),10011)
	         error=20
	      endif
	   else
	      if (typ.eq.1) then
	         if     (buffer(p1:p2).eq.'T'.or.buffer(p1:p2).eq.'t') then
c	            ok
	            buffer(1:)='t'	!pretty
	         elseif (buffer(p1:p2).eq.'F'.or.buffer(p1:p2).eq.'f') then
c	            ok
	            buffer(1:)='f'	!pretty
	         else
	            write(mymssg(1:),10011)
	            error=21
	         endif
	      else
	         write(mymssg(1:),10011)
	         error=22
	      endif
	   endif
	goto 400
c
c	real number
c	-----------
c
107	continue
c
	read (buffer(1:pic),*,err=1076) rval
	if (rval.lt.rlowest.or.
	1   rval.gt.rhigher    ) goto 1076		!....
c
	imin=min
	imax=max
c
	if (rval.ge.rmin.and.rval.le.rmax) then
c	   ok
	   write (buffer(1:pic),*,err=90028) rval	!pretty
	   call rjust_(buffer(1:pic))
	else
	   goto 1077 	!forgive me GOD !!!
	endif
	goto 400
c
1076	continue
	write(mymssg(1:),10035)
	error=31
	goto 400
c
1077	continue
	mymssg(1:)=' '
	write(mymssg(1:),10034)
	lim=istrip_(mymssg)+2
	write (mymssg(lim:),*,err=90028) rmin	!pretty
	lim=istrip_(mymssg)+3
	write (mymssg(lim:),*,err=90028) rmax	!pretty
	error=30
	goto 400
c
c	double precision number
c	-----------------------
c
108	continue
c
	read (buffer(1:lgth),*,err=1086) ddval
c
	write (buffer(1:pic),*,err=90028) ddval	!pretty
	call rjust_(buffer(1:pic))
	goto 400
c
1086	continue
	write(mymssg(1:),10036)
	error=32
	goto 400
c
c
c	intok error
110	continue
	error=23
	goto 400			!common error "exit"
c
400	continue
c
	if (error.gt.0) then
c
	   if (field.gt.0) then
c
c	      Add extra info to common location
c
	      d$rinf(1:5)='fld# '
	      write (d$rinf(6:),fmt='(i3)',err=90028) field
	      d$rinf(12:24)=' of data base'
	   endif
c
	   goto 99000			!set my errors
c
	endif
c
	return
c
c	Errors
c	======
c
c	internal error: read/write error
90028	continue
c
	mymssg(1:1)='?'		!fatal error
	write(mymssg(2:),10032)
	error=28
	goto 99000
c
99000	continue
	call errset_('CHKLIN',error)
	return
c
c
c	formats
c	=======
c
	include 'fmt:CHKLIN.FMT'
c
c
	end
c
c
c
c
c
	subroutine valida_(base,image,error)
c	************************************
c
	implicit none
c
	integer base,error
	character*(*) image
c
c	Description
c	===========
c
c	Given  an  huge  string  with  flattened  lines IMAGE
c	and  where  each line  refers  to a field of BASE,  a
c	check is   performed  for  correctness. ERROR will be
c	zero if all ok. The good services of procedure CHKLIN
c	are used, line by line.
c
c	Var
c	===
c
	include 'own:dbag0.own'
c
	external dummy_,istrip_
	integer istrip_
	integer field,lgth,kind,min,max,pic,dec,nops,b,f,b2,mast,dbcode
	integer lim,first,last
	logical mandat
c
c	begin
c	=====
c
	error=0
	call errclr_('VALIDA')
c
c	go thru fields
c
	first=d$u1st(base)		!first user data field
	last=first+d$udnf(base)-1	!last user data field
c
	do 1001 field=first,last
c
	   min =d$min (field,base)
	   max =d$max (field,base)
	   kind=d$type(field,base)
	   pic =d$siz (field,base)
c
	   if (kind.eq.db$) then
c
	      b2=d$dbio(field,base)
	      mast=d$mast(field,base)
	      if (b2.gt.0.and.mast.gt.0) then	!o.d.b. field
	         d$cbuf(1:)=' '
	         d$cbuf=image(d$pos(field,base):
	1                     d$pos(field,base)+d$siz(field,base)-1)
	      else
	         if (b2.gt.0) then
	            call cunflt_(base,d$cbuf,nops,field,image,error)
	            if (error.ne.0) goto 95000
	         else
	            goto 90001			!can't validate o.d.b. field
	         endif
	      endif
	   else
c
	      call cunflt_(base,d$cbuf,nops,field,image,error)
	      if (error.ne.0) goto 95000
c
	      if (kind.eq.x$) then		!decimal, pic is very tricky !!!
	            dec= d$deci (field,base)
	            pic=pic+1000*dec+1
	      elseif (kind.eq.d$) then	!dates have standard size
	            pic=11
	      elseif (kind.eq.r$) then	!reals "
	            pic=15
	      elseif (kind.eq.r8$) then	!double precision "
	            pic=24
	      endif
c
	   endif
c
	   if (d$oblg(field,base).eq.0) then
	      mandat=.false.
	   else
	      mandat=.true.		!mandatory field
	   endif
c
	   lgth=istrip_(d$cbuf)
	   call chklin_(dummy_,d$cbuf,field,mandat,lgth,kind,min,max,
     1                  pic,mssg,error)
	   if (mssg(1:1).eq.'?') then	!fatal error
	      error=d$erro		!recover error
	      goto 95000
	   endif
	   if (error.ne.0) goto 95000
c
1001	continue
c
	return
c
c	errors
c	======
c
c	can't validate o.d.b. field
90001	continue
	d$rinf(1:5)='base '
	d$rinf(6:)=d$unam(base)		!tell him which base
	lim=istrip_(d$rinf)
	d$rinf(lim+1:lim+6)=', fld#'
	write (d$rinf(lim+7:),fmt='(i3)',err=90011) field
90011	continue
	error=1
	goto 99000
c
99000	continue
	call errset_('VALIDA',error)		!my own error, now...
	return					!return
c
c	inherited errors
95000	continue
	return
c
c
	end
c
c
c
c
	subroutine dummy_(buffer,lgth,kind,min,max,pic,mymssg,error)
c	************************************************************
c
	implicit none
c
	character*(*) buffer,mymssg
	integer lgth,kind,min,max,pic,error
c
c	Description
c	===========
c
c	Dummy procedure to satisfy CHKLIN appetites.Does strictly
c	NOTHING !!!
c
c	var
c	===
c
c	begin
c	=====
c
	return
c
	end
c
c
c
c
	subroutine ttwdth_(width)
c	*************************
c
c
	implicit none
c
	integer width
c
c	Description
c	===========
c
c	This procedure returns tt WIDTH as set by SET WIDTH TO <value>
c	command (widthv). Default value is widthd (see dbagb.own).
c	As it can be called just before issuing error messages, this
c	procedure does't clear global error settings!!!!!!.
c
c	Var
c	===
c
	include 'own:DBAG0.OWN'
	include 'own:DBAGB.OWN'
c
c					!don't!!!!!!!!!
cdon't	call errclr_('TTWDTH')		!clear errors
c					!don't clear the errors!!!!!!!!
c
	width=widthv			!read current value
	if (width.le.0) width=widthd	!force default if none
c
	return
c
c	errors
c	======
c
	end
c
c
c
c
