c	DBAGX.FOR
c	*********
c
c
c	Miscellaneous general purpose facilities for the DBAG system
c
c
c	Written by Luis Arriaga da Cunha, Antonio Mota 1984,1985,1986
c	=============================================================
c
c	Summary of procedure calls:
c
c	word4	get next word from text
c	chkmne	see if mnemonic already exists
c	txtdat	converts dates eg 19851106 into 06-Nov-1985
c	txtda1	converts dates eg 19851106 into 06/11/1985
c	numdat	converts dates eg 30-Nov-1983 into 19831103
c	chkdat	checks whether date is correct; date eg 19841103
c	chkda1	same as above; date with separate day, month year
c	days	gives difference in days between two dates
c	d1900	gives number of days since 01-Jan-1900
c       iweek	gives day of the week for a date
c	cript	cripts string
c	uncript	uncripts string
c	seetab	searches for mnemonic in table
c	pid	gives a number that is alawys different for identification
c	getpid	gives the system's process identification
c	givdir	gives a directory specificationto a file name
c	givext	gives an extension on a file name if none exists
c	chkext	checks that an extension is not forbidden
c	rjust	right justifies text
c	ljust	left justifies text
c	center	centers text
ccccc	txtdec	given decimal number a pretty text is produced
c	stddec	standardizes decimal number for decimal palces
c	monkey	gives the current CPU number
c	in2ex	converts number without check digit into one with it
c	ex2in	opposite of above
c	outk	write element "k" of dynamic array
c	ink	read element "k" of dynamic array
c	myself	gives VAX user name of current job
c	mydir	gives VAX current directory of current job
c	newfil	invents a always different file name
c	slim	in a string changes multiple spaces into single
c	strsec
c	chktyp
c	ex3in
c	in3ex
c	nozero	remove left-trailing zeros
c
c
	subroutine word4_(txt,word,eo,trunc)
c	************************************
c
	implicit none
c
	character*(*) txt,word
	logical eo,trunc
c
c	Description
c	===========
c
c	Given  TXT, its  various  WORDS  are given back in
c	succession  until  EO becomes true. Separators are
c	spaces,  ","  for  the  moment, given in WORD4.OWN.
c	Returns TRUNC = .true. if word doesn't fit.
c
c	var
c	===
c
	external istrip_
	integer istrip_
	integer wlen,ll,lim,pos/1/,j
	logical fini/.false./
	save pos,fini
c
	include 'own:word4.own'
c
c	begin
c	=====
c
	trunc=.false.
	wlen=len(word)
	lim=istrip_(txt)
	if (eo) then
	   pos=1
	   fini=.false.
	elseif (fini.or.lim.eq.0) then
	   fini=.false.
	   word(1:)=' '
	   eo=.true.
	   pos=1
	   return
	endif
c
	word(1:)=' '
	eo=.false.
c
1	continue
	if (pos.gt.lim) goto 10
c	******
cx	if (txt(pos:pos).ne.' '.and.
cx	1   txt(pos:pos).ne.','      )  goto 2
cx	   pos=pos+1
cx	goto 1
c	******
	do j=1,word9_
	   if (txt(pos:pos).eq.word1_(j)) then
	      pos=pos+1
	      goto 1
	   endif
	enddo
c	******
2	continue
c
	ll=1
3	continue
	if (pos.gt.lim) goto 10
c	******
cx	if (txt(pos:pos).eq.' ') goto 4
c	******
	do j=1,word9_
	   if (txt(pos:pos).eq.word1_(j)) goto 4
	enddo
c	******
	   if (ll.le.wlen) then
	      word(ll:ll)=txt(pos:pos)
	   else
	      trunc=.true.
	   endif
	   ll=ll+1
	   pos=pos+1
	goto 3
4	continue
	return
c
10	continue
	fini=.true.
	return
c
c
	end
c
c
c
c
	subroutine chkmne_(mnem,base,nf,fidx,erro)
c	******************************************
c
	implicit none
c
	character*(*) mnem
	integer base,nf,fidx,erro
c
c	For base BASE, see if MNEMonic exists already, for first NF fields.
c	If it does, returns FIDX = position of existing mnemonic, otherwise
c	FIDX = 0.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
	character*10 mymnem,tmp
	integer k,lim,mynf
c
	call errclr_('CHKMNE')
	erro=0
c
	fidx=0
c
	if     (base.le.0.or.base.gt.d$b) then
	   goto 90001				!bad database number
	elseif (d$base(base).le.0) then
	   goto 90002				!not open
	endif
c
	if (nf.gt.d$f.or.
	1   nf.lt.0     ) then
	   mynf=d$nfld(base)
	else
	   mynf=nf
	endif
c
	if (mynf.le.0) return
c
	mymnem(1:)=' '
	mymnem=mnem
	lim=istrip_(mymnem)
c
	if (lim.le.0) return
c
	call uc8to7_(mymnem)
c
	do 1002 k = 1, mynf
	   tmp=d$fmne(k,base)
	   call uc8to7_(tmp)
	   if (tmp.eq.mymnem) then
	      fidx=k
	      goto 100
	   endif
1002	continue
c
100	continue
c
	return
c
c	errors
c	======
c
c	illegal database number
90001	continue
	erro=1
	goto 99000
c
c	base not open
90002	continue
	erro=2
	goto 99000
c
c	reserved mnemonic
90003	continue
	erro=3
	goto 99000
c
99000	continue
	call errset_('CHKMNE',erro)		!my own error, now...
	return					!return
c
	end
c
c
c
c
	subroutine txtdat_(date,text,error)
c	***********************************
c
	implicit none
c
	integer date,error
	character*(*) text
c
c	Description
c	===========
c
c	Given  a DATE in the format, eg 19840831 standing
c	for 31-Aug-1984, its validity is checked in terms
c	of day, month, year and if all ok a conversion is
c	done into the text format in TEXT.Copes with wild
c	card also.
c
c	It works only after year 1900 (no antiques please)
c
c	var
c	===
c
	integer dia,mes,ano,tmp
	character*3 mois(0:24),ucmois
c
	data mois/'  *',
     1            'Jan','Feb','Mar','Apr','May','Jun',
     1            'Jul','Aug','Sep','Oct','Nov','Dec',
     1            'Jan','Fev','Mar','Abr','Mai','Jun',
     1            'Jul','Ago','Set','Out','Nov','Dez'/
c
	common/mois$/mois
c
c	begin
c	=====
c
c	check date validity
c
	call chkdat_(date,error)
	if (error.ne.0) return
c
c	here ok, dismount date
c
	if (date.eq.0) then
	   text=' *-  *-   *'
	   return
	endif
c
	dia=mod(date,100)
	tmp=date/100
	mes=mod(tmp,100)
	ano=tmp/100
c
c	compose string
c
	if (dia.ne.0) then
	   write(text(1:2),'(i2.2)')dia
	else
	   text(1:2)=' *'
	endif
	write(text(3:7),'(''-'',a,''-'')')mois(mes)(1:3)
	if (ano.ne.0) then
	   write(text(8:11),'(i4.4)')ano
	else
	   text(8:11)='   *'
	endif
c
	return
c
c
	end
c
c
c
c
	subroutine txtda1_(date,text,error)
c	***********************************
c
	implicit none
c
	integer date,error
	character*(*) text
c
c	Description
c	===========
c
c	Very much the same as TXTDAT but giving back a
c	different  text  format. If in  DATE  we  have
c	eg 19840831 standing for 31-Aug-1984, the TEXT
c	format will be 31/08/1984.
c
c	Again it works only after year 1900.
c
c	var
c	===
c
	integer dia,mes,ano,tmp
c
c	begin
c	=====
c
c	check date validity
c
	call chkdat_(date,error)
	if (error.ne.0) return
c
c	here ok, dismount date
c
	if (date.eq.0) then
	   text=' */ */   *'
	   return
	endif
c
	dia=mod(date,100)
	tmp=date/100
	mes=mod(tmp,100)
	ano=tmp/100
c
c	compose string
c
	if (dia.ne.0) then
	   write(text(1:2),'(i2.2)')dia
	else
	   text(1:2)=' *'
	endif
	if (mes.ne.0) then
	   write(text(3:6),'(''/'',i2.2,''/'')')mes
	else
	   text(3:6)='/ */'
	endif
	if (ano.ne.0) then
	   write(text(7:10),'(i4.4)')ano
	else
	   text(7:10)='   *'
	endif
c
	return
c
c
	end
c
c
c
c
	subroutine numdat_(date,text,lim,form,error)
c	********************************************
c
	implicit none
c
	integer date,lim,form,error
	character*(*) text
c
c	Description
c	===========
c
c	Given a date in TEXT in text format, eg 20-Aug-1984
c	or in short format, eg 20/08/1984 or  even 20081984
c	the  numerical  format  is  given back in DATE. The
c	format is the horrid 19840820 for the above example.
c	TEXT is used up to LIM if all ok.
c
c	N.B.!!!! Error = 9 if wild card format found!!!!!
c
c	More  precisely  FORM  tells which format was found:
c
c	form  = 1		20-aug-1984 or 20-aug-84
c	form  = 2 		20/08/1984 or 20/08/84
c	form  = 3		20081984 or 200884
c	form  = 4		84-aug-20
c	form  = 5 		84/08/20
c	form  = 6		840820
c
c	Errors can be :
c
c	error = 1		wrong day
c	error = 2		wrong month
c	error = 3		wrong year
c	error = 4		wrong day or month
c	error = 5		wrong format
c	error = 6		wrong format for day
c	error = 7		wrong format for month
c	error = 8		wrong format for year
c	error = 9		wild card date
c
c	var
c	===
c
	external istrip_
	integer istrip_
c
	integer dia,mes,ano,tmp,er,odia,omes,oano
	logical txt,cee
	real rval
	integer typ,ntyp,dec,val,lgth,p1,p2
	integer l1,l2,k,l,m0
	character*3 month,mois(0:24),ucmois,mssg*80
c
	data mois/'  *',
     1            'Jan','Feb','Mar','Apr','May','Jun',
     1            'Jul','Aug','Sep','Oct','Nov','Dec',
     1            'Jan','Fev','Mar','Abr','Mai','Jun',
     1            'Jul','Ago','Set','Out','Nov','Dez'/
c
	common/mois$/mois
c
c	begin
c	=====
c
	error=0
	month='   '
	mssg(1:)=' '
	form=0
	cee=.false.
	txt=.true.
c
c	decompose text, let's admit date is 20-Aug-1985
c
	lim=1
	call rstok_(text,1,error)
c
	call intok_(typ,dia,dec,rval,text,lgth,p1,p2,mssg,error)
	if (typ.eq.0) goto 13	!eol, wrong format altogether
	lim=p2
c
	if (typ.eq.2) then	!can be number (day or whole date, eg 200885 ?)
	   l=p2-p1+1		!remember length
	elseif (typ.eq.10) then !or "*" (wild day)
c	   ok
	else
	   goto 15
	endif
c
	m0=p1
	call intok_(typ,val,dec,rval,text,lgth,p1,p2,mssg,error)
	lim=p2
cx	if (typ.eq.0) then			!eol, admit whole date
	if (typ.ne.13.and.typ.ne.11) then	!if not / or - admit whole date
	   form=3
	   p1=m0
	   if     (l.eq.8) then
	      read (text(p1:p1+1),'(i2)')dia
	      read (text(p1+2:p1+3),'(i2)')mes
	      read (text(p1+4:p1+7),'(i4)')ano
	      goto 100			!straight to checkin
	   elseif (l.eq.6) then
	      read (text(p1:p1+1),'(i2)')dia
	      read (text(p1+2:p1+3),'(i2)')mes
	      read (text(p1+4:p1+5),'(i2)')ano
	      goto 100			!straight to checkin
	   elseif (l.eq.5) then
	      read (text(p1:p1),'(i1)')dia
	      read (text(p1+1:p1+2),'(i2)')mes
	      read (text(p1+3:p1+4),'(i2)')ano
	      goto 100			!straight to checkin
	   else
	      goto 13
	   endif
	else
	   if (l.gt.2) goto 13
	endif
c
	if (typ.eq.13.or.typ.eq.11) then	!can be "-" or "/"
	   call intok_(typ,val,dec,rval,text,lgth,p1,p2,mssg,error)
	   if (typ.eq.0) goto 13	!eol
	   lim=p2
	else
c	   space is also ok
	endif
c
	if (typ.eq.1) then	!can be 3 letter identifier ( month ?)
	   if ((p2-p1+1).ne.3) goto 16
	   form=1
	   month=text(p1:p2)
	elseif (typ.eq.2) then	!or number ( month ?)
	   if ((p2-p1+1).gt.2) goto 16
	   form=2
	   mes=val
	   txt=.false.
	elseif (typ.eq.10) then	!or "*" (wild month)
	   mes=0
	   txt=.false.
	else
	   goto 16		!complete rubbish
	endif
	call intok_(typ,val,dec,rval,text,lgth,p1,p2,mssg,error)
	if (typ.eq.0) goto 13	!eol
	lim=p2
c
	if (typ.eq.13.or.typ.eq.11) then	!can be "-" or "/"
	   call intok_(typ,val,dec,rval,text,lgth,p1,p2,mssg,error)
	   if (typ.eq.0) goto 13	!eol
	   lim=p2
	else
c	   space is also ok
	endif
c
	if (typ.eq.2) then	!can be number (year ?)
	   if ((p2-p1+1).gt.4) goto 17
	   ano=val
	elseif (typ.eq.10) then !or "*" (wild year)
c	   ok
	   ano=0
	else
	   goto 17
	endif
c
c	change month into number if the case
c
	if (txt) then
	   call uc_(month)
	   do 1001 k=0,12
	      mes=k
	      ucmois=mois(k)
	      call uc_(ucmois)
	      if (month.eq.ucmois) goto 1
1001	   continue
	   do 1002 k=13,24
	      mes=k-12
	      ucmois=mois(k)
	      call uc_(ucmois)
	      if (month.eq.ucmois) goto 1
1002	   continue
	   goto 11
1	   continue
	endif
c
c	check ingrediants and build date
c
100	continue
	odia=dia
	omes=mes
	oano=ano
	call chkda1_(dia,mes,ano,error)
	if (error.ne.0) then
	   if (dia.gt.31) then			!CEE format ?
	      er=error
	      call chkda1_(oano,omes,odia,error)!last chance...
	      if (error.ne.0) then
	         error=er
	         return
	      else
	         cee=.true.
	         dia=oano
	         mes=omes
	         ano=odia
	      endif
	   else
	      return
	   endif
	endif
	if (dia.eq.0.or.mes.eq.0.or.ano.eq.0) then
	   error=9
	endif
	date=ano*10000+mes*100+dia
c
	if (cee) then
	   form=form+3	!1->4, 2->5, 3->6
	endif
c
	return
c
c	misbehaviour
c	============
c
c	wrong day
c
10	continue
	error=1
	return
c
c	wrong month
c
11	continue
	error=2
	return
c
c	wrong year
c
12	continue
	error=3
	return
c
c	wrong format
c
13	continue
	lim=1
	error=5
	return
c
c	wrong format for day
c
15	continue
	error=6
	return
c
c	wrong format for month
c
16	continue
	error=7
	return
c
c	wrong format for year
c
17	continue
	error=8
	return
c
c	formats
c	=======
c
	include 'fmt:NUMDAT.FMT'
c
	end
c
c
c
c
	subroutine chkdat_(date,error)
c	******************************
c
	implicit none
c
	integer date,error
c
c	Description
c	===========
c
c	Given DATE in the format 19840820 standing for 20-Aug-1984
c	its  correctnes  is  checked  and  told  back  in  error=0.
c	If  the date  comes without the 19.. part things are still
c	ok and  the  part  is  added  to  the  user's  given  DATE.
c
c	error = 1		wrong day
c	error = 2		wrong month
c	error = 3		wrong year
c
c	var
c	===
c
	integer d,m,y
c
c	begin
c	=====
c
	error=0
	y=date/10000
	if (y.eq.0) then
c	   wild card year
	elseif (y.lt.100) then
	   y=y+1900
	   date=date+19000000
	endif
	d=mod(date,100)
	m=mod((date/100),100)
c
	call chkda1_(d,m,y,error)
c
	return
c
c
	end
c
c
c
c
	subroutine chkda1_(d,m,y,error)
c	*******************************
c
	implicit none
c
	integer d,m,y,error
c
c	Description
c	===========
c
c	This is the true worker !!!
c
c	Given D,M,Y in numeric form, eg D=20, M=08, Y=1984 standing
c	for 20-Aug-1984 its correctnes is  checked  and  told  back
c	in  error=0.If the date  comes without the 19.. part things
c	are  still  ok  and   the  part  is  added  to  the  user's
c	given  date.
c
c	error = 1		wrong day
c	error = 2		wrong month
c	error = 3		wrong year
c	error = 4		wrong day or month
c
c	var
c	===
c
	integer mm(0:12),lim,bi,nobi
	data mm/31,31,28,31,30,31,30,31,31,30,31,30,31/
c
c	begin
c	=====
c
	error=0
	if (y.eq.0) then
c	   wild
	elseif (y.lt.100) then
	   y=y+1900
	endif
c
c	check day independent of month
c
	if (d.eq.0) then
c	   wild
	elseif(d.lt.1.or.d.gt.31) then
	   error=1
	   return
	endif
c
c	check month
c
	if (m.eq.0) then
c	   wild
	elseif (m.lt.1.or.m.gt.12) then
	   error=2
	   return
	endif
c
c	check day related to month
c
	bi=mod(y,4)
	lim=mm(m)
	if (bi.eq.0) then
	   nobi=mod(y,100)
	   if (nobi.eq.0) bi=1	!not leap year after all
	endif
	if (m.eq.2.and.bi.eq.0) lim=lim+1
	if (d.gt.lim) then
	   error=4
	   return
	endif
c
c	check year
c
	if (y.eq.0) then
c	   wild year
	elseif (y.lt.1900.or.y.gt.2999) then
	   error=3
	endif
c
	return
c
c
	end
c
c
c
c
	subroutine d1900_(dat,num)
c	**************************
c
	implicit none
c
	integer dat,num
c
c	description
c	===========
c
c	Given in  DAT  a date in CEE format, e.g. 831008
c	or 19831008 standing for 08-Oct-1983, the number
c	of  days since 01-Jan-1900 is calculated in  NUM.
c	If an error occurrs NUM will be -1.
c
c	var
c	===
c
	integer d,m,y,k,b,n
	integer mon(12)/31,28,31,30,31,30,31,31,30,31,30,31/
c
c	begin
c	=====
c
	y=dat/10000
	m=mod(dat,10000)
	m=m/100
	d=mod(dat,100)
	if (y.le.0) goto 99
	if (y.ge.1900) y=mod(y,100)
	if (y.gt.99) goto 99
	if (m.lt.1.or.m.gt.12) goto 99
	b=mod(y,4)
	if (b.eq.0) then
	   mon(2)=29
	else
	   mon(2)=28
	endif
	if (d.lt.1.or.d.gt.mon(m)) goto 99
	num=y*365+(y-1)/4+d
	n=0
	do 1001 k=1,m-1
	   n=n+mon(k)
1001	continue
	num=num+n
	return
c
99	continue
	num=-1
	return
c
c
	end
c
c
c
c
	subroutine days_(first,last,dif)
c	********************************
c
	implicit none
c
	integer first,last,dif
c
c	description
c	===========
c
c	Given  two dates FIRST and LAST in CEE format, e.g.
c	831008 or 19831008  standing for  08-Oct-1983, the
c	number  of days  between them is calculated in DIF.
c	Valid for dates in the 20th century only. If error
c	DIF will be -1.
c
c	var
c	===
c
	integer n1,n2
c
c	begin
c	=====
c
	call d1900_(first,n1)
	call d1900_(last,n2)
	if (n1.lt.0.or.n2.lt.0) goto 99
	dif=n2-n1
	return
c
99	continue
	dif=-1
	return
c
c
	end
c
c
c
c
        subroutine iweek_(d,m,y,wday,wtxt,country,ierr)
c	***********************************************
c
	implicit none
c
	integer d,m,y,wday,country,ierr
	character*(*) wtxt
c
c	Description
c	===========
c
c	Adapted   by   Jose  da  Conceicao  Silva    1984   from
c	a  routine  written  in  BASIC  of  unknown  origin, and
c	completely  un-understandable   apart  from  the geniuos
c	that wrote it !
c
c	Given a date  in  D,M,Y  (day,month,year)  the procedure
c	will give back the day of the week, in WDAY in numerical
c	form, in WTXT  in text form. Dates should be bigger than
c	1-Jan-1800. By the  way  years  must be in the form 19%%
c	for  example. COUNTRY  tells  the  language, so far 1 is
c	English, 2 is Portuguese, 3 is French.
c
c	If date is wrong IERR=1, zero otherwise.
c
c	wday = 1 means	wtxt=Sunday
c	wday = 2 means	wtxt=Monday
c	.
c	.
c	.
c	wday = 7 means	wtxt=Saturday
c
c	var
c	===
c
	integer i,z,a,l,l1,g1,j1,q
	integer idesv(12), imes(12)
	data  (idesv(i),i=1,12)/0,3,3,6,1,4,6,2,5,0,3,5/
	data (imes(i),i=1,12)/31,28,31,30,31,30,31,31,30,31,30,31/
	character*9 gb(0:7)/'-----',
     1                    'Sunday',
     1                    'Monday',
     1                    'Tuesday',
     1                    'Wednesday',
     1                    'Thursday',
     1                    'Friday',
     1                    'Saturday'/
	character*9 p(0:7) /'-----',
     1                    'Domingo',
     1                    'Segunda',
     1                    'Terca',
     1                    'Quarta',
     1                    'Quinta',
     1                    'Sexta',
     1                    'Sabado'/
	character*9 f(0:7) /'-----',
     1                    'Dimanche',
     1                    'Lundi',
     1                    'Mardi',
     1                    'Mercredi',
     1                    'Jeudi',
     1                    'Vendredi',
     1                    'Samedi'/
c
c	begin
c	=====
c
	ierr=0
c
	if (y.le.1800)         ierr=1
	if (m.lt.1.or.m.gt.12) ierr=1
	if (d.lt.1.or.d.gt.31) ierr=1
	if (ierr.eq.1)         goto 50
c
	g1 = 1
	j1 = 0
	l1 = 0
	y  = y - 400*(y/400)
	a  = y + (y+3)/4 - (y-1)/100
	if (y.ne.(y/4)*4)      goto 20
	if (y.eq.0)            goto 10
	if (y.eq.100*(y/100))  goto 20
10	l1 = 1
	if (m.lt.3)            goto 20
	l = 1
	goto 30
20	l =0
30	z = a + d + l + idesv(m)
	z = z - (z/7)*7
	q = imes(m)
	if (m.ne.2)            goto 40
	q = q + l1
40	if (d.gt.q)            ierr=1
	if (ierr.eq.1)         goto 50
	if (z.ge.2.and.z.le.6) wday=z-1
	if (z.eq.0.or.z.eq.1)  wday=z+6
50	continue
c
c	get text
c
	if (country.eq.1) then
	   wtxt(1:)=gb(wday)(1:)
	elseif (country.eq.2) then
	   wtxt(1:)= p(wday)(1:)
	elseif (country.eq.3) then
	   wtxt(1:)= f(wday)(1:)
	else
	   wtxt(1:)=' '
	endif
c
	return
c
c
	end
c
c
c
c
        subroutine numtim_(time,text,lim,error)
c	***************************************
c
	implicit none
c
	integer time,lim,error
	character*(*) text
c
c	Description
c	===========
c
c	Given  a  time  in  TEXT in text  format, eg 18:20:45
c	or 18:20 or 18 or 182045 or 1820 or 18 the  numerical
c	format  is  given   back  in TIME . The format  is  a
c	horrid  182045 for the above example. TEXT is used up
c	to LIM if all ok.
c
c	error = 1		wrong hour
c	error = 2		wrong minute
c	error = 3		wrong second
c	error = 4		wrong format for hour
c	error = 5		wrong format for minute
c	error = 6		wrong format for second
c	error = 7		wild card time
c
c	var
c	===
c
	external istrip_
	integer istrip_
c
	integer hor,min,seg,tmp
	logical txt
	real rval
	integer typ,ntyp,dec,val,lgth,p1,p2
	integer l1,l2,k,l
	character*80 mssg
c
c	begin
c	=====
c
	error=0
c
c	decompose text, let's admit time is 18:20:45
c
	call rstok_(text,1,error)
c
	call intok_(typ,hor,dec,rval,text,lgth,p1,p2,mssg,error)
	if (typ.eq.0) goto 13	!eol, wrong format altogether
c
	if (typ.eq.2) then	!can be number (hour or whole time, eg 182045?)
	   l=p2-p1+1		!remember length
	elseif (typ.eq.10) then !or "*" (wild hour)
c	   ok
	else
	   goto 15
	endif
c
	call intok_(typ,val,dec,rval,text,lgth,p1,p2,mssg,error)
	if (typ.eq.0) then		!eol, admit whole time
	   if     (l.eq.6) then
	      read (text(p1:p1+1),'(i2)')hor
	      read (text(p1+2:p1+3),'(i2)')min
	      read (text(p1+4:p1+7),'(i2)')seg
	      goto 100			!straight to checkin
	   elseif (l.eq.5) then
	      read (text(p1:p1+1),'(i1)')hor
	      read (text(p1+2:p1+3),'(i2)')min
	      read (text(p1+4:p1+5),'(i2)')seg
	      goto 100			!straight to checkin
	   elseif (l.eq.4) then
	      read (text(p1:p1+1),'(i2)')hor
	      read (text(p1+2:p1+3),'(i2)')min
	      seg=0
	      goto 100			!straight to checkin
	   elseif (l.eq.3) then
	      read (text(p1:p1+1),'(i1)')hor
	      read (text(p1+2:p1+3),'(i2)')min
	      seg=0
	      goto 100			!straight to checkin
	   elseif (l.eq.2) then
	      read (text(p1:p1+1),'(i2)')hor
	      min=0
	      seg=0
	      goto 100			!straight to checkin
	   elseif (l.eq.1) then
	      read (text(p1:p1+1),'(i1)')hor
	      min=0
	      seg=0
	      goto 100			!straight to checkin
	   else
	      goto 13
	   endif
	else
	   if (l.gt.2) goto 13
	endif
c
	if (typ.eq.18) then		!can be ":"
	   call intok_(typ,val,dec,rval,text,lgth,p1,p2,mssg,error)
	   if (typ.eq.0) goto 13	!eol
	else
c	   space is also ok
	endif
c
	if (typ.eq.2) then		!number ( minute ?)
	   if ((p2-p1+1).gt.2) goto 16
	   min=val
	elseif (typ.eq.10) then		!or "*" (wild month)
	   min=0
	else
	   goto 16			!complete rubbish
	endif
	call intok_(typ,val,dec,rval,text,lgth,p1,p2,mssg,error)
	if (typ.eq.0) goto 13	!eol
c
	if (typ.eq.18) then		!can be ":"
	   call intok_(typ,val,dec,rval,text,lgth,p1,p2,mssg,error)
	   if (typ.eq.0) goto 13	!eol
	else
c	   space is also ok
	endif
c
	if (typ.eq.2) then	!can be number second ?)
	   if ((p2-p1+1).gt.4) goto 17
	   seg=val
	elseif (typ.eq.10) then !or "*" (wild year)
c	   ok
	   seg=0
	else
	   goto 17
	endif
c
c	check ingrediants and build time
c
100	continue
cx	call chktim_(hor,min,seg,error)
cx	if (error.ne.0) return
	time=hor*10000+min*100+seg
c
	return
c
c	misbehaviour
c	============
c
c	wrong hour
c
10	continue
	error=1
	return
c
c	wrong minute
c
11	continue
	error=2
	return
c
c	wrong second
c
12	continue
	error=3
	return
c
c	wrong format for hour
c
13	continue
	error=5
	return
c
c	wrong format for minute
c
15	continue
	error=6
	return
c
c	wrong format for second
c
16	continue
	error=7
	return
c
c	wrong format for second
c
17	continue
	error=8
	return
c
c	formats
c	=======
c
	include 'fmt:NUMDAT.FMT'
c
	end
c
c
c
c
	subroutine seetab_(table,top,pos,cmmnd,minchr)
c	**********************************************
c
	implicit none
c
	character*(*) table(*),cmmnd
	integer top,pos,minchr
c
c	Written by Luis Arriaga da Cunha 1984
c
c	Description
c	===========
c
c	Given  a  table of commands (identifiers)  in TABLE
c	up  to TOP, the string CMMND is  searched for until
c	a non-ambiguous possibly abbreviated match is found
c	(TABLE is supposed to be "uppercased"!!!!!!!!!!!!!).
c	If  found  POS gives where in  TABLE, otherwise POS
c	will be zero. If ambiguous  POS will be -1.  MINCHR
c	is the minimum number of characters CMMND MUST have,
c	otherwise POS will be -2.
c
c	CAUTION: as SEETAB uses a local copy of CMMND,if it
c	doesn't fit POS is returned = 0.
c
c	var
c	===
c
	external istrip_
	integer istrip_
c
	integer k,l,ls,lim,hit
	character*50 cmdtmp,tabtmp
c
c	begin
c	=====
c
	pos=0				!not found
c
	lim=istrip_(cmmnd)
	if     (lim.lt.minchr) then
	   pos=-2
	   return
	elseif (lim.gt.len(cmdtmp)) then
	   goto 1
	endif
c
	cmdtmp(1:)=' '			!local copy
	cmdtmp(1:)=cmmnd
	call uc8to7_(cmdtmp)
c
	hit=0
c
	do 1001 k = 1, top
	   tabtmp=table(k)
	   call uc8to7_(tabtmp)
	   l=index(tabtmp,cmdtmp(1:lim))
	   if (l.eq.1) then
	      pos=k
	      hit=hit+1
	      ls=istrip_(table(k))
	      if (ls.eq.lim) goto 1	!dont go further
	   endif
1001	continue
c
	if (hit.gt.1) then
	   pos=-1
	endif
c
1	continue
	return
c
c
	end
c
c
c
c
	subroutine seetab2_(table,top,pos,cmmnd,minchr,frw,error)
c	*********************************************************
c
	implicit none
c
	character*(*) table(*),cmmnd
	integer top,pos,minchr,error
	logical frw
c
c	Written by Luis Arriaga da Cunha 1987
c
c	Description
c	===========
c
c	Given  a  table  of commands (identifiers)  in TABLE
c	up  to TOP, the string CMMND  is  searched for until
c	a  non-ambiguous possibly abbreviated match is found.
c	MINCHR   is   the   minimum   number  of  characters
c	CMMND must have. FRW, id true, tells the TABLE to be
c	searched forward, if false backwards.
c
c	If found POS gives where in TABLE and ERROR is     0
c
c	If ambiguous ERROR will be                         1
c	If not enough characters supplied ERROR will be    2
c	If CMMND too long for local buffer ERROR will be   3
c	If a TABLE entry is too long (") ERROR will be     4
c
c	POS will be zero in any error condition, except if
c	ambiguous. If ambiguous, POS will return 1st position.
c
c
c	var
c	===
c
	external istrip_
	integer istrip_
c
	integer l1,l9,ld,k,l,ls,lim,hit
	character*50 cmdtmp,tabtmp
c
c	begin
c	=====
c
	pos=0				!not found
	error=0
c
	lim=istrip_(cmmnd)
	if     (lim.lt.minchr) then
	   goto 92
	elseif (lim.gt.len(cmdtmp)) then
	   goto 93
	endif
c
	cmdtmp(1:)=' '			!local copy
	cmdtmp(1:)=cmmnd
	call uc8to7_(cmdtmp)
c
	hit=0
c
	if (frw) then
	   l1=1
	   l9=top
	   ld=1
	else
	   l1=top
	   l9=1
	   ld=-1
	endif
c
	do 1001 k = l1,l9,ld
	   ls=istrip_(table(k))
	   if (ls.gt.len(tabtmp)) then
	      error=4
cx	      goto 94			!too long
	   endif
	   tabtmp(1:)=table(k)
	   call uc8to7_(tabtmp)
	   l=index(tabtmp,cmdtmp(1:lim))
	   if (l.eq.1) then
	      hit=hit+1
	      if (hit.gt.1) then
	         goto 91
	      endif
	      pos=k
	      if (ls.eq.lim) goto 1	!dont go further
	   endif
1001	continue
c
1	continue
	return
c
c
c	errors
c	======
c
c	ambiguous command
91	continue
	error=1
	return
c
c	not enough characters
92	continue
	error=2
	return
c
c	command too long for internal buffer
93	continue
	error=3
	return
c
c	table entry too long for internal buffer
94	continue
	error=4
	return
c
	end
c
c
c
c
	subroutine pid_(myself)
c	***********************
c
	implicit none
c
	integer myself
c
c	Description
c	===========
c
c	A  unique  (hopefully) identification is given in
c	MYSELF. It is  build messing around with the date,
c 	and the time  of the  procedure  call. It will be
c	typically be  used as a signature for a data base.
c	at creation time. We hope the same signature will
c	NEVER be repeated. Do not confuse with an identi-
c	fication given by PID  (see below) because it  is
c	very confusing.
c
c	var
c	===
c
	integer t,d,m,y
c
c	begin
c	=====
c
	call idate(m,d,y)
	t=secnds(0.0)*100.0
	myself=(m*31+d)*864000+t
c
	return
c
c
	end
c
c
c
c
	subroutine givdir_(fspec,dir)
c	*****************************
c
	implicit none
c
	character*(*) fspec,dir
c
c	Description
c	===========
c
c	Given  a   file   name  in  FSPEC ,  a   directory   DIR
c	is   put   in   front   of   it   if   NONE  exists  yet.
c	E.g.  if  FSPEC   is  XPTO.TXT  and  DIR  is  [103.dbag]
c	the procedure will give back in FSPEC [103.DBAG]XPTO.TXT
c	But  if  FSPEC  is  [LAC]XPTO.TXT  nothing  will be done.
c
c	var
c	===
c
	external istrip_
	integer istrip_
	integer right, size, limit, k, j
c
c	begin
c	=====
c
	right=index(fspec,']')
	if (right.le.0) right=index(fspec,':')
	if (right.le.0) then
	   size=index(dir,']')
	   if (size.le.0) size=index(dir,':')
	   if (size.gt.0) then
	      limit=istrip_(fspec)
	      do 1001 k=limit,1,-1
	         j=k+size
	         fspec(j:j)=fspec(k:k)
1001	      continue
	      fspec(1:size)=dir(1:size)
	   endif
	endif
c
	return
c
c
	end
c
c
c
c
	subroutine givext_(fspec,ext)
c	*****************************
c
	implicit none
c
	character*(*) fspec,ext
c
c	Description
c	===========
c
c	Given a file name in FSPEC , a extension EXT is forced
c	into, it  perhaps  overriding  any  existing extension.
c
c	var
c	===
c
	external istrip_
	integer istrip_
	integer right, limit, dot
c
c	begin
c	=====
c
	right=index(fspec,']')
	if (right.le.0) right=index(fspec,':')
	right=right+1
	dot=index(fspec(right:), '.')
	if (dot.gt.0) then
	   limit=right+dot-2
	else
	   limit=istrip_(fspec)
	endif
	if (limit.le.0) then
	   fspec(1:)=' '
	else
	   fspec(1:)=fspec(1:limit)//ext
	endif
c
	return
c
c
	end
c
c
c
c
	subroutine chkext_(fspec,error)
c	*******************************
c
	implicit none
c
	character*(*) fspec
	integer error
c
c	Description
c	===========
c
c	Given a filespec in FSPEC, its extension, if any, is checked
c	against a list of forbidden extensions to avoid possible conflicts.
c
c	ERROR is returned non-zero if unauthorized extension found. No-op
c	if no extension or empty filespec.
c
c	var
c	===
c
	include 'own:dbagthin.own'
c
	external istrip_
	integer istrip_
	integer lim,dot,sq,esize,nnn
	integer next/16/,k
	character*3 ext(16),myext
	data
     1   		ext( 1)/'ALT'/,		!alternate file
     1   		ext( 2)/'CMD'/,		!DBAG command files
     1   		ext( 3)/'ULD'/,		!unload (backup) files
     1   		ext( 4)/'DBF'/,		!database data file
     1   		ext( 5)/'EXE'/,		!better not...
     1   		ext( 6)/'FOR'/,		!heard about...
     1   		ext( 7)/'HLP'/,		!DBAG help files
     1   		ext( 8)/'INI'/,		!DBAG initialization files
     1   		ext( 9)/'MSG'/,		!DBAG message files
     1   		ext(10)/'OBJ'/,		!well...
     1   		ext(11)/'OLB'/,		!don't remember...
     1   		ext(12)/'OWN'/,		!include files
     1   		ext(13)/'ROO'/,		!database root file
     1   		ext(14)/'SDF'/,		!(DBAG) system file data format
     1   		ext(15)/'DBA'/,		!(DBAG) "ascii"file data format
     1   		ext(16)/'BAT'/		!alias for "CMD"
c
c	begin
c	=====
c
	call errclr_('CHKEXT')			!clear errors
	error=0
c
	lim=istrip_(fspec)
	if (lim.le.0) return			!no extension, return	
c
	sq=index(fspec(1:),']')
	if (sq.le.0) sq=index(fspec(1:),':')
	dot=index(fspec(sq+1:), '.')
	if (dot.le.0.or.
     1      dot.ge.lim) return			!no extension, return
	esize=lim-(dot+sq)
	if (esize.gt.3) esize=3
	myext(1:)=' '
	myext(1:)=fspec(dot+sq+1:dot+sq+1+esize-1)
c
c	Check extension
c
	if (istrip_(myext).gt.2) then
	   read (myext,'(i3)',err=100) nnn	!see if integer
	   goto 90001				!reserved
	endif
100	continue
c
	call uc8to7_(myext)
c
	do 1001 k = 1, next
	   if (myext(1:3).eq.ext(k)(1:3)) goto 90001
1001	continue
c
	return
c
c	Errors
c	======
c
c	unauthorized extension
90001	continue
	d$rinf(1:1)='.'
	d$rinf(2:)=myext
	error=1
	goto 99000
c
c	Set error and return
c
99000	continue
	call errset_('CHKEXT',error)
	return
c
	end
c
c
c
c
	subroutine rjust_(buf)
c	**********************
c
	implicit none
c
	character*(*) buf
c
c	Description
c	===========
c
c	Given a string in BUF, it will be rigth-justified,
c	adding spaces to the left hand side.
c
c	var
c	===
c
	external istrip_
	integer istrip_, leng, pos
c
c	begin
c	=====
c
	leng=istrip_(buf)
c
	pos=len(buf)
c
	if (leng.eq.pos) return
c
	if (leng.eq.0) then
	   buf(1:)=' '
	   return
	endif
c
cwhile	do while (leng.gt.0)
1098	continue
	   if (leng.le.0) goto 1099
c
	   buf(pos:pos)=buf(leng:leng)
	   buf(leng:leng)=' '
	   pos=pos-1
	   leng=leng-1
c
	   goto 1098
1099	continue
cwhile	enddo
c
	return
c
c
	end
c
c
c
c
	subroutine ljust_(buf)
c	**********************
c
	implicit none
c
	character*(*) buf
c
c	Description
c	===========
c
c	Given a string in BUF, it will be left-justified,
c	adding spaces to the right hand side.
c
c	var
c	===
c
	external trim_
	integer trim_, leng, pos
c
c	begin
c	=====
c
	leng=trim_(buf)
c
	if (leng.eq.1) return
c
	buf(1:)=buf(leng:)
c
	return
c
c
	end
c
c
c
c
	subroutine center_(buf)
c	***********************
c
	implicit none
c
	character*(*) buf
c
c	Description
c	===========
c
c	Given a string in BUF, it will be centered
c	in its own space (!?).
c
c	var
c	===
c
	external trim_, istrip_
	integer  trim_, istrip_
c
	integer leng, used, l0, lx, left
	character*132 tmp
c
c	begin
c	=====
c
	l0=trim_(buf)
	lx=istrip_(buf)
	leng=len(buf)
c
	if (lx.eq.0) return
c
	used=lx-l0+1
	if (leng.le.used) return
c
	tmp(1:)=buf(1:)
	left=(leng-used)/2+1
	buf(1:)=' '
	buf(left:)=tmp(l0:)
	return
c
c
	end
c
c
c
c
	integer function ndigi_(number)
c	*******************************
c
	implicit none
c
	integer number
c
c	Description
c	***********
c
c	Given integer NUMBER the number of digits is found
c	as the function's value.
c
c	var
c	===
c
	integer absn
	double precision ref
c
c	begin
c	=====
c
	ndigi_=0
	ref=10.0
	absn=abs( number )
1	continue
	ndigi_=ndigi_+1
	if (absn.lt.ref) goto 2
	ref=ref*10.0
	goto 1
2	continue
c
	return
c
c
	end
c
c
c
c
	subroutine stddec_(int,given,stnd)
c	**********************************
c
	implicit none
c
	integer int,given,stnd
c
c	Description
c	===========
c
c	Given  a  decimal  number in INT  in  "integerized" form
c	with GIVEN decimal places, a  "corrected" value is found
c	with the standard STND decimal places, perhaps truncated.
c
c	var
c	===
c
	integer delta,k
c
c	begin
c	=====
c
	if (given.eq.stnd) then
c	   ok
	elseif (given.gt.stnd) then
	   delta=given-stnd
	   k=10.0**delta
	   int=int/k
	else
	   delta=stnd-given
	   k=10.0**delta
	   int=int*k
	endif
c
	return
c
c
	end
c
c
c
c
	subroutine in2ex_(icode,xcode,error)
c	************************************
c
	implicit none
c
	integer xcode,icode
c
c	Description
c	===========
c
c	Given a code without check digit in ICODE (internal
c	code), a  version  with check digit appended to the
c	right is given back in XCODE (external code) .
c	ERROR always = 0.
c
c	Probably noone is using it.
c
c	var
c	===
c
	external makdig_
	integer makdig_
	integer error
c
c	begin
c	=====
c
	error=0
	xcode=icode*10+makdig_(icode)
c
	return
c
	end
c
c
c
c
	subroutine ex2in_(xcode,icode,error)
c	************************************
c
	implicit none
c
	integer xcode,icode,error
c
c	Description
c	===========
c
c	Given  a code with check digit in XCODE (external
c	code), a version without the check digit is given
c	back  in  ICODE  (internal code) . If check digit
c	is not right ERROR will be non zero.
c
c	Probably noone is using it.
c
c	var
c	===
c
	integer makdig_
	integer rest,dig
c
c	begin
c	=====
c
	icode=xcode/10
	rest=abs(mod(xcode,10))
	dig=makdig_(icode)
	if (rest.eq.dig) then
	   error=0
	else
	   error=1
	endif
c
	return
c
	end
c
c
c
c
	integer function makdig_(code)
c	*****************************
c
	implicit none
c
	integer code
c
c	Description
c	===========
c
c	Calculates a check digit for CODE and gives it back
c	as the value of the function.
c
c	var
c	===
c
	integer ich1(0:9),ich2(0:9)
	data
     1   	ich1/0,1,2,3,4,5,6,7,8,9/,
     1   	ich2/0,2,4,6,8,1,3,5,7,9/
c
	integer acum,iq,ir,ii
c
c	begin
c	=====
c
	acum=0
	iq=code
1	continue
	ir=abs(mod(iq,10))
	iq=iq/10
	acum=acum+ich2(ir)
	if (iq.eq.0) goto 2
	ir=abs(mod(iq,10))
	iq=iq/10
	acum=acum+ich1(ir)
	if (iq.ne.0) goto 1
2	continue
	ii=mod(acum,10)
	makdig_=10-ii
	if (ii.eq.0) makdig_=0
c
	return
c
	end
c
c
c
c
	subroutine outk_(array,k,val)
c	*****************************
c
	implicit none
c
	integer array(*),k,val
c
c	Description
c	===========
c
c	Gives back the VALue of the Kth position of ARRAY.
c	Necessary for %val( )  stuff...
c
c	begin
c	=====
c
	val=array(k)
	return
c
c
	end
c
c
c
c
	subroutine ink_(array,k,val)
c	****************************
c
	implicit none
c
	integer array(*),k,val
c
c	Description
c	===========
c
c	Writes the VALue in the Kth position of ARRAY.
c	Necessary for %val( )  stuff...
c
c	begin
c	=====
c
	array(k)=val
	return
c
c
	end
c
c
c
c
	integer function istrip_(string)
c	*******************************
c
	implicit none
c
	character*(*) string
c
c	Description
c	===========
c
c	Trailing  blanks and spaces are removed from string
c	string. The last  used position in string  is given
c	as the function value.
c
c	var
c	===
c
	integer lim,k,ichrt
	character*1 chrt
c
c	begin
c	=====
c
	lim=len(string)
	do 1001 k=lim,1,-1
	   chrt=string(k:k)
	   ichrt=ichar(chrt)
	   if (chrt.ne.' '.and.
     1          .not.(ichrt.lt.32.or.
     1               (ichrt.gt.126.and.ichrt.lt.161).or.
     1                ichrt.gt.253                    )) goto 1
cmota     1          (ichrt.gt.32.and.ichrt.le.126)) goto 1
c
1001	continue
c
	istrip_=0
	return
c
1	continue
	istrip_=k
	return
c
c
	end
c
c
c
c
	subroutine strip0_(txt,lim)
c	***************************
c
	implicit none
c
	character*(*) txt
	integer lim
c
c	var
c	===
c
	external istrip_
	integer	 istrip_
c
c	begin
c	=====
c
	lim=istrip_(txt)
	return
c
	end
c
c
c
c
	subroutine strip_(txt,lim)
c	**************************
c
	implicit none
c
	character*(*) txt
	integer lim
c
c	var
c	===
c
	external istrip_
	integer	 istrip_
c
c	begin
c	=====
c
	lim=istrip_(txt)
	if (lim.le.0) then
	   txt(1:1)=' '
	   lim=1
	endif
	return
c
	end
c
c
c
c
	integer function trim_(string)
c	*****************************
c
	implicit none
c
	character*(*) string
c
c	Description
c	===========
c
c	The first used position (ie <> space ) in STRING
c	is the function value.
c
c	var
c	===
c
	integer lim,k
	character*1 chrt
c
c	begin
c	=====
c
	lim=len(string)
	do 1001 k=1,lim
	   trim_=k
	   chrt=string(k:k)
	   if (chrt.ne.' '.and.chrt.ne.'	') goto 10
1001	continue
	trim_=1
c
10	continue
	return
c
c
	end
c
c
c
c
	subroutine newfil_(fname)
c	*************************
c
	implicit none
c
	character*(*) fname
c
c	Description
c	===========
c
c	A new and unique file name is invented and given
c	back  in  FNAME . It  is  based on the number of
c	seconds  since  midnight  with  extension  .TMP.
c
c	var
c	===
c
	integer i
c	begin
c	=====
c
	i=secnds(0.0)*10.0
	write(fname,'(i6.6,''.TMP'')')i
	return
c
c
	end
c
c
c
c
	subroutine slim_(txt,lim)
c	*************************
c
	implicit none
c
	character*(*) txt
	integer lim
c
c	Description
c	===========
c
c	Given TXT, multiple spaces or tabs are reduced to one.
c	the  remaining  "usefull" length is given back in LIM.
c
c	var
c	===
c
	external istrip_,trim_
	integer istrip_,trim_
	integer l,k,low
	logical fst
c
c	begin
c	=====
c
	lim=istrip_(txt)
	if (lim.le.0) return
	low=trim_(txt)
	l=0
	fst=.true.
	do 1001 k=low,lim
	   l=l+1
	   if (txt(k:k).eq.' '.or.txt(k:k).eq.' ') then
	      txt(l:l)=' '
	      if (fst) then
	         fst=.false.
	      else
	         l=l-1
	      endif
	   else
	      txt(l:l)=txt(k:k)
	      fst=.true.
	   endif
1001	continue
	if (l.lt.len(txt)) txt(l+1:)=' '
	lim=l
c
	return
c
c
	end
c
c
c
c
	subroutine strsec_ (inpstr,outstr,pos,eostr)
c	********************************************
c
	implicit none
c
	character*(*) inpstr,outstr
	integer pos
	logical eostr
c
c	Description
c	===========
c
c	This procedure returns in string OUTSTR the consecutive portions
c	of INPSTR that fit, until exhausted. POS will contain next start
c	position within INPSTR.                 EOSTR =.true. at the end.
c	No-op (EOSTR = .true.) if nothing to do.
c
c	To start, POS should contain - 1 in input.
c
c	Var
c	===
c
	external istrip_
	integer istrip_
	integer p1,endp1,inplen,outlen
c
c	begin
c	=====
c
	inplen=istrip_(inpstr)
	outlen=len(outstr)
c
	if (inplen.le.0.or.			!INPSTR empty
     1      outlen.le.0.or.			!OUTSTR size 0
     1      pos.eq.0   .or.			!???
     1      pos.lt.-1  .or.			!???
     1      pos.gt.inplen  ) then		!???
	   eostr=.true.
	   return
	endif
c
	if (pos.eq.-1) then
	   eostr=.false.			!start everything
	   p1=1					!first input start position
	else
	   p1=pos
	endif
c
	endp1=p1+inplen-1			!last position
c
	if (inplen.gt.outlen) then
	   endp1 = endp1 - inplen + outlen
	endif
c
	if (endp1.ge.inplen) then
	   endp1=inplen				!make sure...
	   eostr=.true.				!all done
	endif
c
	outstr(1:)=' '
	outstr(1:)=inpstr(p1:endp1)
	p1=endp1+1				!next p1
	pos=p1					!return it
c
	return					!return to caller
c
c	Error
c	=====
c
c	Warnings
c	--------
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine chktyp_(buf,type)
c	****************************
c
	implicit none
c
c	Description
c	===========
c
c	This procedure checks field type in BUF and returns it in TYPE
c	or 0 if wrong type.
c
	character*(*) buf
	integer type
c
c	Var
c	===
c
	include 'own:dbag0.own'
	external istrip_
	integer istrip_
	integer k
c
c	check field type
c	----------------
c
	k=istrip_(buf)
	if     (k.gt.2) then
	   goto 2			!bad field type
	elseif (k.eq.1) then
	   buf(2:2)=' '			!avoid confusion ('d' and 'db','dx')
	endif
c
	call lc_(buf(1:2))		!lower case
c
	do 1001 k=1,ftmax$
	   if (buf(1:2).eq.ft$(k)(1:2)) then
	      type=k			!field type
	      goto 1
	   endif
1001	continue
	goto 2				!bad field type
c
c	Field type found
c
1	continue
	return
c
c	Bad field type
c
2	continue
c
	type=0				!return 0
	return
c
	end
c
c
c
c
	subroutine ex3in_(base,xcode,code,error)
c	****************************************
c
	implicit none
c
	integer base,xcode,code,error
c
c	description
c	===========
c
c	For BASE converts external code XCODE into
c	internal code CODE. Actually does nothing.
c
c	var
c	===
c
	include 'own:DBAG0.OWN'
c
c	begin
c	=====
c
	call errclr_('EX3IN')			!clear errors
	error=0
c
	code=xcode
c
	return
c
c	errors
c	======
c	Wrong check digit
90001	continue
	error=1
	goto 99000
c
c	Set error and return
c
99000	continue
	call errset_('EX3IN',error)
	return
c
c
	end
c
c
c
c
	subroutine in3ex_(base,code,xcode,error)
c	****************************************
c
	implicit none
c
	integer base,xcode,code,error
c
c	description
c	===========
c
c	For  BASE  converts internal code CODE into
c	external code XCODE. Actually does nothing.
c
c	var
c	===
c
	include 'own:DBAG0.OWN'
c
c	begin
c	=====
c
	call errclr_('IN3EX')			!clear errors
	error=0
c
	xcode=code
c
	return
c
c	errors
c	======
c
c	Wrong check digit
90001	continue
	error=1
	goto 99000
c
c	Set error and return
c
99000	continue
	call errset_('IN3EX',error)
	return
c
c
	end
c
c
c
c
	subroutine inqr_( fname, ohyes)
c	*******************************
c
	implicit none
c
	character*(*) fname
	logical ohyes
c
c	descrption
c	==========
c
c	It performs what the instruction
c
c	INQUIRE ( FNAME, INUSE=OHYES )
c
c	should  do, in  my  humble  opinion.  More
c	precisely OHYES goes back true if the file
c	FNAME is  in  use  by  anyone   whatsoever,
c	false if no one is using it.
c
c	var
c	===
c
	integer istrip_
	external istrip_
c
	integer l,chan
c
c	begin
c	=====
c
	call newc_(chan)
	l=istrip_(fname)
	open(unit=chan,
     1       file=fname,
     1       status='unknown',
     1       err=90
     1      )
	ohyes=.false.
	if (chan.gt.0) then
	   close(unit=chan)
	   call freec_(chan)
	endif
	return
c
90	continue
	ohyes=.true.
	if (chan.gt.0) then
	   close(unit=chan)
	   call freec_(chan)
	endif
	return
c
	end
c
c
c
c
	subroutine nozero_(txt)
c
	implicit none
c
	character*(*) txt
c
c	Description
c	===========
c
c	Remove left-trailing zeros from TXT.
c
c	var
c	===
c
	external trim_,istrip_
	integer trim_,istrip_
	integer k,lim1,lim2
c
	lim2=istrip_(txt)
	if (lim2.le.0) return
c
	lim1=trim_(txt)
	lim2=lim2-1
	do k = lim1,lim2
	  if (txt(k:k).eq.'0') then
	      txt(k:k)=' '
	   else
	      goto 100
	   endif
	enddo
c
100	return
c
	end
c
c
c
c
