c	DBAGY.FOR
c	*********
c
c
c	Miscellaneous error handling facilities for the DBAG system
c
c
c	Written by Luis Arriaga da Cunha, Antonio Mota 1984
c	===================================================
c
c	Summary of procedures :
c
c	errclr	(errwho)
c	errset	(errwho,errcod)
c	errtrc	(errwho,errcod)
c	errmsg	(errwho,errcod,errtxt,errchr)
c	errdpl  (message,channel)
c	errbkb	(message,who,errcod)
c
c
c
c	General description
c	===================
c
c	There is  only  one file with  error  messages. It is BAG:DBAG.MSG.
c	Notice  the need to define the symbol BAG: to whatever it actually
c	is. In this file each  message is accessed by a two_key consisting
c	of procedure_name//error_number. Within  each procedure the errors
c	are  numbered  1, 2, 3, etc .
c
c
c
c
	subroutine errclr_(errwho)
c	*************************
c
	implicit none
c
	character*(*) errwho
c
c	Description
c	===========
c
c	This  procedure  clears error context and sets d$rsub  to
c	current  active procedure  name in ERRWHO. If trace is on
c	the  name  of  the  procedure  is  typed at  the terminal.
c	Therefore IT SHOULD BE CALLED when entering any procedure
c	within the system.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
c	begin
c	=====
c
c	Clear global error locations and set current procedure name
c
	if (d$kgb.gt.0.or.s$set(s$trac)) then
	   type '('' Procedure '',a)',errwho
	endif
	d$rsub = errwho
	d$rinf(1:)=' '
	d$erro = 0
c
	return
c
c
	end
c
c
c
c
	subroutine errset_(errwho,errcod)
c	********************************
c
	implicit none
c
	character*(*) errwho
	integer errcod
c
c	Description
c	===========
c
c	This  procedure  sets, in  the  memory context, an error
c	ERRCOD  for  the  procedure  given in ERRWHO. Should be
c	used typically for own errors ( as opposed to enherited
c	errors ).
c
c	var
c	===
c
	include 'own:dbagthin.own'
c
c	begin
c	=====
c
c	Set error code and current procedure name.
c
	d$rsub = errwho
	d$erro = errcod
c
	return
c
c
	end
c
c
c
c
	subroutine errmsg_(errwho,errcod,errtxt,errchr)
c	***********************************************
c
	implicit none
c
	integer errcod
	character*(*) errwho,errtxt,errchr
c
c	Description
c	===========
c
c	There is one file only for all error messages in the
c	system, BAG:DBAG.MSG. This procedure finds the error
c	message   associated  with  the   key procedure_name,
c	error_number  given in ERRWHO//ERRCOD.  The  message
c	is  given  back in ERRTXT.
c	This message has the format:
c			space
c			errwho
c			4 spaces
c			rest of message from error file (the 11th
c			character being replaced by errchr)
c
c	If first character of "rest of message" is "?", a FATALLLL error
c	occurred: appropriate information will be displayed in channel 6
c	and program execution suspended.
c
c	If first character of "rest of message" is "\" AND DBAG is beeing
c	used interactively, same action as for "?".
c
c	If no i/o channel available for messages, the appropriate message
c	is stored into ERRTXT and same procedure as "\" found will be
c	executed.
c
c	In any other case of ERRMSG failure, same procedure as "?" found
c	will be followed.
c
c	var
c	===
c
	include 'own:dbagu.own'
c
	external istrip_
	integer istrip_
	integer ch, lim1, lim2, lim3, lim
	logical dejavu/.false./
c
	save ch,dejavu
c
	logical itdoes
	character*4 number
	character*6 mywho
	character*132 mytxt
c
c	begin
c	=====
c
c
	mytxt(1:)=' '
	lim1=istrip_(errwho)
	if (lim1.le.0) lim1=1
	mywho(1:)=' '
	mywho=errwho(1:lim1)
c
	if (.not.dejavu) then
	   inquire(file=errfil,exist=itdoes)
	   if (.not.itdoes) then
	      mytxt(1:20)=' Error message file '
	      mytxt(21:)=errfil
	      mytxt(istrip_(mytxt)+2:)=' not found'
	      goto 100						!as "?" found
	   endif
	   call newc_(ch)
	   if (ch.le.0) then
	      mytxt(1:)=' ?No more i/o channels to get error message from'
	      mytxt(51:)=mywho(1:lim1)
	      mytxt(58:70)=', error code'
	      write (mytxt(72:74),'(i3.3)') errcod
	      goto 90						!as "\" found
	   endif
	   open(unit=ch,file=errfil,status='old',
     1          carriagecontrol='list',readonly,err=10)
	   dejavu=.true.
	   goto 20
c
10	continue
	mytxt(1:)=' ?Can''t open file '
	mytxt(19:)=errfil
	goto 100						!as "?" found
c
20	continue
c
	endif
c
c	mytxt is built with a space in (1:1) so write(5,a)mytxt works ok
c
	rewind(ch)
	write(number,'(i3.3)')errcod
1	continue
	   read(ch,'(a)',end=2) mytxt(2:)
	   if (mytxt(2:7).eq.mywho(1:6).and.
     1     mytxt(9:11).eq.number)         goto 3	!success
c
	goto 1
c
2	continue
	mytxt(1:)=' %No error message found for '
	mytxt(30:30+lim1-1)=mywho(1:lim1)
	mytxt(36:48)=', error code'
	write (mytxt(49:52),'(i3,1x)') errcod
	goto 100						!as "?" found
c
3	continue
	mytxt(1:1)=' '
	mytxt(8:11)='    '
	mytxt(12:12)=errchr(1:1)
c
c	Add extra info about error, if any
c
	lim1=istrip_(d$rinf)+2			!extra info, "=>"
	if (lim1.gt.2) then
	   lim2=istrip_(mytxt)+1		!message size + space
	   lim3=lim1+lim2+2
	   if (lim3.le.len(mytxt)) then
	      lim2=lim2+1
	      mytxt(lim2:)='=> '
	      lim2=lim2+3
	      mytxt(lim2:)=d$rinf
	   endif
	endif
c
c	See if \ or ?
c
	if     (mytxt(14:14).eq.'\') then
	   mytxt(14:14)='?'		!'?' as usual in error messages...
	   goto 90			!interactive fatal error
	elseif (mytxt(14:14).eq.'?') then
	   goto 100			!absolute fatal error
	endif
c
	goto 200			!return
c
90	continue				!!!! "/" !!!!
	if (d$itrv.ne.0) goto 100		!interactive usage, same as "?"
	goto 200				!non-interactive, return
c
c	Return
c
200	continue
c
	errtxt(1:)=' '
	errtxt=mytxt
c
	return
c
100	continue				!!!! "?" !!!!
	lim=istrip_(mywho)
	if (lim.le.0) then
	   lim=6
	   mywho='unknwn'
	endif
	lim1=istrip_(mytxt)
	if (lim1.le.0) lim1=1
	write (6,1001) mytxt(1:lim1),mywho(1:lim),errcod
1001	format (/,
     1   ' ???Fatal error!!!',/,
     1   a,/,
     1   '    Call from    : ',a,/,
     1   '    Error code   : ',i6,/,
     1   '    Please report to DBAG manager!')
c
	call errbkb_(mytxt(1:lim1),mywho(1:lim),errcod)	!black box!
c
	call exit				!E X I T! !
c
	end
c
c
c
c
	subroutine errdpl_(msgtxt,chan)
c	*******************************
c
	implicit none
c
	character*(*) msgtxt
	integer chan
c
c	Description
c	===========
c
c	This procedure displays in full the error context kept
c	in memory + error message MSGTXT.
c	The full message is written in channel CHAN.
c	As this procedure SHOULD be called only at UNRECOVERABLE
c	errors, write to CHAN is used instead of standard output
c	message routine (I$MESS).
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
c
	integer lim
c
c	begin
c	=====
c
	lim=istrip_(msgtxt)
	if (lim.le.0) lim=1
	write (chan,10001) d$rsub,
     1      		   d$erro,
     1   		   msgtxt(1:lim)
c
	call errbkb_(msgtxt(1:lim),d$rsub,d$erro)	!black box!
c
	return
c
c	Formats
c	=======
c
	include 'fmt:ERRDPL.FMT'
c
c
	end
c
c
c
c
	subroutine errbkb_(errmsg,errwho,errcod)
c	****************************************
c
	implicit none
c
	character*(*) errmsg,errwho
	integer errcod
c
c	Description
c	===========
c
c	This procedure appends some information to a "black box"
c	file, in the behalf of a smart black boxer.
c
c	var
c	===
c
	include 'own:dbag0.own'
c
	external istrip_
	integer istrip_
c
	character*132 line
	character*60 fnam,who,where
	character*12 dat,tim,fext
	character*1 ff
	integer irace,pdim,psize,pdeci,b,f,ix,io,limf,
	1	pos,lim1,lim2,lim3,chn,ierr
	logical fok
c
c	begin
c	=====
c
	limf=istrip_(bkbfil)
	if (limf.le.0) limf=1
c
	call newc_(chn)
	if (chn.le.0) goto 100	!no i/o channel
c
	open (unit=chn,file=bkbfil(1:limf),status='unknown',recl=500,
     1        access='append',carriagecontrol='list',err=100)
c
	ff=char(12)		!form feed
c
c	date and version
c
	call date(dat)
	call time(tim)
	lim1=istrip_(dat)
	if (lim1.le.0) lim1=1
	lim2=istrip_(tim)
	if (lim2.le.0) lim2=1
	lim3=istrip_(d$vers)
	if (lim3.le.0) lim3=1
	write (chn,1001,err=100) ff,d$vers,dat(1:lim1),tim(1:lim2)
1001	format (a,/,
     1   '****** DBAG ',a,' fatal error, ',a,', at ',a,' ******')
c
c	error
c
	lim1=istrip_(errmsg)
	if (lim1.le.0) lim1=1
	lim2=istrip_(errwho)
	if (lim2.le.0) lim2=1
	write (chn,10020,err=100) errmsg(1:lim1),errwho(1:lim2),errcod
10020	format (/,
     1   ' Error      : ',a,/,
     1   ' Call from  : ',a,/,
     1   ' Error code : ',i6)
c
c	who and where
c
	call myself_(who)
	call mydir_(where)
	lim1=istrip_(who)
	if (lim1.le.0) lim1=1
	lim2=istrip_(where)
	if (lim2.le.0) lim2=1
	write (chn,10021,err=100) who(1:lim1),where(1:lim2)
10021	format (/,
     1   ' WHO   : ',a,/,
     1   ' WHERE : ',a)
c
c	general info
c
	if     (d$itrv.le.0) then
	   write (chn,10030,err=100)
	elseif (d$itrv.eq.1) then
	   write (chn,10031,err=100)
	elseif (d$itrv.eq.2) then
	   write (chn,10032,err=100)
	else
	   write (chn,10033,err=100)
	endif
10030	format (/' === Usage : non-interactive (user program)')
10031	format (/' === Usage : interactive (command driven)')
10032	format (/' === Usage : interactive (short-menu driven)')
10033	format (/' === Usage : interactive (full-menu driven)')
c
c	command buffer
c
	write (chn,1004,err=100)
1004	format (/' === Comand buffer ===',/)
	do 1 b = 1, d$cmmd
	   lim1=istrip_(cmdbuf(b))
	   if (lim1.le.0) goto 10	!the end
	   write (chn,'(a)',err=100) cmdbuf(b)(1:lim1)
1	continue
10	continue
c
c	Global i/o channels (d$cmdi,d$cmdo,d$alte)
c
	write (chn,10041,err=100)
10041	format (/' === Global i/o channels ===',/)
c
	io=d$cmdi
	if (io.gt.0) then			!active
	   if (io.ne.5.and.io.ne.6) then
	      line(1:)=' '
	      line (1:32)='  command input file (d$cmdi) : '
	      inquire (unit=io,name=fnam)
	      lim2=istrip_(fnam)
	      if (lim2.le.0) then
	               line(33:45)='?????????????'
	               lim1=45
	      else
	               line(33:33+lim2-1)=fnam
	               lim1=33+lim2-1
	      endif
c
	      write (chn,'(a)',err=100) line(1:lim1)
c
	   endif
c
	endif
c
	io=d$cmdo
	if (io.gt.0) then			!active
	   if (io.ne.5.and.io.ne.6) then
	      line(1:)=' '
	      line (1:32)='         output file (d$cmdo) : '
	      inquire (unit=io,name=fnam)
	      lim2=istrip_(fnam)
	      if (lim2.le.0) then
	               line(33:45)='?????????????'
	               lim1=45
	      else
	               line(33:33+lim2-1)=fnam
	               lim1=33+lim2-1
	      endif
c
	      write (chn,'(a)',err=100) line(1:lim1)
c
	   endif
c
	endif
c
	io=d$alte
	if (io.gt.0) then			!active
	   line(1:)=' '
	   line (1:32)='      alternate file (d$alte) : '
	   inquire (unit=io,name=fnam)
	   lim2=istrip_(fnam)
	   if (lim2.le.0) then
	      line(33:45)='?????????????'
	      lim1=45
	   else
	      line(33:33+lim2-1)=fnam
	      lim1=33+lim2-1
	   endif
c
	   write (chn,'(a)',err=100) line(1:lim1)
c
	endif
c
c	open bases
c
	write (chn,1005,err=100)
1005	format (/' === Structures currently open ===',/)
c
	do 1099 b = 1, d$b
	   if (d$base(b).ne.0) then
	      line(1:)=' '
	      call zrace_(b,line(1:30),irace,pdim,psize,pdeci,ierr)
	      pos=istrip_(line)+1
	      line(pos:pos+1)=': '
	      pos=pos+2
	      line(pos:pos+9)=d$unam(b)
	      line(pos+10:pos+17)=', file: '
	      line(pos+18:)=d$bfil(b)
	      lim1=istrip_(line)+2
	      line(lim1:lim1+7)=', open: '
	      if     (d$pid(b).eq.0) then
	         line(lim1+8:lim1+17)='NOUPDATE, '
	         lim1=lim1+17
	      else
	         line(lim1+8:lim1+15)='UPDATE, '
	         lim1=lim1+15
	      endif
	      if (b.eq.c$base) then
	         line(lim1+1:lim1+8)='IN USE, '
	         lim1=lim1+9
	      endif
c
	      write (chn,'(a)',err=100) line(1:lim1)
c
c	      root and dbf files (d$rio,d$bio)
c
	      io=d$rio(b)
	      if (io.gt.0) then			!active
	         line(1:)=' '
	         line (1:32)='            .ROO file (d$rio) : '
	         inquire (unit=io,name=fnam)
	         lim2=istrip_(fnam)
	         if (lim2.le.0) then
	            line(33:45)='?????????????'
	            lim1=45
	         else
	            line(33:33+lim2-1)=fnam
	            lim1=33+lim2-1
	         endif
c
	         write (chn,'(a)',err=100) line(1:lim1)
c
	      endif
c
	      io=d$bio(b)
	      if (io.gt.0) then			!active
	         line(1:)=' '
	         line (1:32)='            .DBF file (d$bio) : '
	         inquire (unit=io,name=fnam)
	         lim2=istrip_(fnam)
	         if (lim2.le.0) then
	            line(33:45)='?????????????'
	            lim1=45
	         else
	            line(33:33+lim2-1)=fnam
	            lim1=33+lim2-1
	         endif
c
	         write (chn,'(a)',err=100) line(1:lim1)
c
	      endif
c
c	      active index files
c
	      do 1098 f = 1, d$nfld(b)
	         ix=d$idx(f,b)
	         io=0			!i/o channel
	         if (ix.ne.0) then	!field indexed/keyed/key part/kwic
 	            line(1:)=' '
	            line (1:7)='  fld# '
	            call wrivar_(line(8:10),f,3,ierr)
	            line(11:12)=', '
	            line(13:22)=d$fmne(f,b)
	            line(23:24)=', '
	            lim1=24
	            if     (ix.eq.1.or.
	1                   ix.eq.4.or.
	1                   ix.eq.2    ) then	!index/kwic index/key
	               io=d$ixio(f,b)
	               if (io.gt.0) then
	                  if     (ix.eq.1) then
	                     line(25:44)='INDEXED and active, '
	                     lim1=44
	                  elseif (ix.eq.4) then
	                     line(25:49)='KWIC INDEXED and active, '
	                     lim1=49
	                  else
	                     line(25:40)='KEY and active, '
	                     lim1=40
	                  endif
	               else
	                  if     (ix.eq.1) then
	                     line(25:48)='INDEXED but not active, '
	                     lim1=48
	                  elseif (ix.eq.4) then
	                     line(25:53)='KWIC INDEXED but not active, '
	                     lim1=53
	                  else
	                     line(25:44)='KEY but not active, '
	                     lim1=44
	                  endif
	               endif
c
	               line(lim1:lim1+11)='index file: '
	               lim1=lim1+12
                       fok=.false.
	               if (io.gt.0) then
	                  inquire (unit=io,name=fnam)
	                  lim2=istrip_(fnam)
                          if (lim2.gt.0) fok=.true.
	               else
	                  fnam=d$bfil(b)
	                  write(fext,'(''.'',i3.3)',err=1234) f!make ext as .003
	                  call givext_(fnam,fext)
	                  inquire (file=fnam,exist=fok)
	                  if (fok) lim2=istrip_(fnam)
1234	                  continue
	               endif
c
	               if (fok) then
	                  line(lim1:lim1+lim2-1)=fnam
	                  lim1=lim1+lim2-1
	               else
	                  line(lim1:lim1+13)='?????????????'
	                  lim1=lim1+13
	               endif
	            else
	               line(25:32)='KEY PART'
	               lim1=32
	            endif
c
	            write (chn,'(a)',err=100) line(1:lim1)
c
	         endif
c
1098	      continue
c
c	      permanent sort file
c
	      if (bitsiz(b).gt.0) then
	         call outk_(%val(bitpnt(b)),3,io)	!hard to read, bitmap...
	         if (io.gt.0) then			!active
	            line(1:)=' '
	            line (1:23)='  permanent sort file: '
	            inquire (unit=io,name=fnam)
	            lim2=istrip_(fnam)
	            if (lim2.le.0) then
	               line(24:36)='?????????????'
	               lim1=36
	            else
	               line(24:24+lim2-1)=fnam
	               lim1=24+lim2-1
	            endif
c
	            write (chn,'(a)',err=100) line(1:lim1)
c
	         endif
c
	      endif
c
	   endif
c
1099	continue
c
c	tell him (her)
c
	write (6,1999) bkbfil(1:limf)
1999	format (' (more details in file "',a,'")')
c
	if (chn.gt.0) then
	   close (chn)
	   call freec_(chn)
	endif
c
	return
c
c	can't append to black box file!
100	continue
	write (6,1998) bkbfil(1:limf)
1998	format (' ?Can''t append to file "',a,
     1          '", ( or no more i/o channels)')
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
