c	DBAGZ.FOR
c	*********
c
c
c	Miscellaneous scanning and parsing facilities for the DBAG system
c
c
c	Written by Luis Arriaga da Cunha, Antonio Mota 1984
c	===================================================
c
c	Summary of procedure calls:
c
c	inline  (chan, buffer, lgth, cont, trunc, erro)
c	inchr   (chr, kind, buffer, pos, eol)
c	rstok   (buffer, pos, erro)
c	intok   (type, value, decim, rvalue, buffer, lim, pos1, pos2, erro)
c	inwht   (type, value, decim, rvalue, buffer, lim, pos1, pos2, erro)
c	infspc  (type,what,name,ext,val,dec,rval,buffer,lim,pos1,pos2,msg,erro)
c
c
c
c
	subroutine inline_(chan,buffer,lgth,cont,trunc,erro)
c	****************************************************
c
	implicit none
c
	integer chan
	character*(*) buffer, cont*1
	integer lgth,erro
	logical trunc
c
c	Written by Luis Arriaga da cunha 1984
c
c	Description
c	===========
c
c	Given a BUFFER with maximum size max, lines
c	are  input from the unit CHAN to fill it up.
c	Continuation  lines are allowed to end with
c	CONT mark. LGTH will give the actually used
c	space  in  BUFFER, or 0 if a <ret> is typed,
c	or  -1  if ^Z is typed. Lines starting with
c	"!"   character   are  comment  lines; LGTH
c	will be -2 if only comment lines seen.
c	If line too long TRUNC will be returned =
c	.true.
c
c	Note that BUFFER (max:max) will  be  filled
c	with a space and MAX set to MAX-1 so  "line
c	too long" error only occurs for really BIGG
c	lines (err= path on read is assumed  to  be
c	line too long...).
c
c	As CHN may refer to user terminal as well to
c	an @file, the end-of-file condition will be
c	properly handled.
c
c	Var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	external istrip_
	integer istrip_
	integer max,k,l1,nline
	logical commen,cseen,switch
	character*5 fake/'     '/
c
c	Begin
c	=====
c
	call errclr_('INLINE')
	erro=0
c
	cseen=.false.			!continuation character not seen
	switch=.false.
	l1=1
	max=len(buffer)
	buffer(1:)=' '
	commen=.false.					!no command line seen
	nline=0						!# of non-comment l.
	trunc=.false.					!no truncation
	if (max.le.0) goto 100				!"eol"...
c
123	continue
c
	   if (l1.gt.max) goto 500			!line too long
c
124	   continue
c
	   if (switch) goto 150				!switching, as ^Z
c
	   read (chan,'(a)',err=90001,end=150) buffer(l1:)
	   goto 160					!ok, proceed
c
c	   ^Z or eof found
c
150	   continue
	   if (at$lvl.le.0) then
	      goto 200				!^Z found
	   else
	      call i$atup_(erro)		!@ file active, go up
	      if (erro.ne.0) return		!error, carry
	      if (at$lvl.le.0) switch=.true.	!switch from @file to terminal
	      goto 124				!try next @file or terminal
	   endif
c
160	   continue
c
	   if (buffer(l1:l1).eq.'!') then
	      commen=.true.				!comment line seen
	      goto 123					!loop for more
	   endif
c
	   lgth=istrip_(buffer)				!line size
	   if (lgth.gt.0) then
	      nline=nline+1
	   else
	      goto 100					!blank line
	   endif
c
	   if (cont.eq.' ') then			!carry on
	      cseen=.true.
	      l1=lgth+1
	      buffer(l1:l1)=' '				!put a blank
	      goto 123					!go back for more
	   elseif (buffer(lgth:lgth).eq.cont) then	!carry on, so
	      cseen=.true.
	      buffer(lgth:lgth)=' '			!put a blank
	      l1=lgth+1
	      goto 123					!go back for more
	   endif
c
100	continue
c
	if (nline.le.0) then
	   if (commen) then
	      goto 400			!comment line(s)
	   else
	      goto 300			!<ret>
	   endif
	endif
c
	return
c
c	^Z or end-of-@file
c
200	continue
c
	lgth=-1
	return
c
c	<ret>
c
300	continue
c
	lgth=0
	return
c
c	comment line(s) only
c
400	continue
c
	lgth=-2
	return
c
c	line too long, truncated
c
500	continue
c
	trunc=.true.
	return
c
c	Errors
c	======
c
c	i/o error
c
90001	continue
c
	erro=1
	goto 99000
c
99000	continue
	call errset_('INLINE',erro)
	return
c
c	formats
c	=======
c
	end
c
c
c
c
	subroutine inchr_(chr,kind,buffer,pos,eol)
c	*****************************************
c
	implicit none
c
	character*1 chr
	integer kind,pos
	character*(*) buffer
	logical eol
c
c	Written by Luis Arriaga da Cunha 1984
c
c	Description
c	===========
c
c	From  BUFFER, characters are given back one at a
c	time until end of buffer,when  EOL  becomes true.
c	The character given back will be in position POS
c	in BUFFER. KIND is  the class  of  character  as
c	shown below, typically 	telling   whether  it is
c	a  digit, letter, etc.
c	If  POS  comes in (achtung!!) as zero user wants
c	to start at the beginning of BUFFER !!!
c
c	var
c	===
c
	external istrip_
	integer istrip_
c
	integer top
	save top
	integer class(0:255),k
c
	data
     1        class(0)/1/
     1      , class(ichar(' ')),class(ichar('	'))/2*1/
     1      ,(class(k),k=ichar('A'),ichar('Z'))/26*2/
     1      ,(class(k),k=ichar('a'),ichar('z'))/26*2/
     1      ,(class(k),k=ichar('0'),ichar('9'))/10*3/
     1      , class(ichar(''''))/4/
     1      , class(ichar('('))/5/
     1      , class(ichar(')'))/6/
     1      , class(ichar(','))/7/
     1      , class(ichar('='))/8/
     1      , class(ichar('*'))/9/
     1      , class(ichar('/'))/10/
     1      , class(ichar('+'))/11/
     1      , class(ichar('-'))/12/
     1      , class(ichar('?'))/13/
     1      , class(ichar('<'))/14/
     1      , class(ichar('>'))/15/
     1      , class(ichar(':'))/16/
     1      , class(ichar('@'))/17/
     1      , class(ichar('^'))/18/
     1      , class(ichar('.'))/19/
     1      , class(ichar('_'))/20/
     1      , class(ichar('$'))/21/
     1      , class(ichar('%'))/22/
     1      , class(ichar('['))/23/
     1      , class(ichar(']'))/24/
     1      , class(ichar('#'))/25/
     1      , class(ichar('!'))/26/
     1      , class(ichar('"'))/27/
     1      ,(class(k),k=161,253)/93*2/	!8 bit characters
c
c	begin
c	=====
c
	top=istrip_(buffer)
	if (pos.eq.0) then
	   eol=.false.
	endif
c
	pos=pos+1
	if (pos.gt.top) then
	   eol=.true.
	   pos=0
	   chr=' '
	   kind=0
	else
	   chr=buffer(pos:pos)
	   k=ichar(chr)
	   kind=class(k)
	endif
c
	return
c
c
	end
c
c
c
c
	subroutine rstok_(buffer,str,erro)
c	*********************************
c
	implicit none
c
	integer str,erro
	character*(*) buffer
c
c	Written by Luis Arriaga da Cunha 1984
c
c	Description
c	===========
c
c	BUFFER is reset (hence the name of the procedure...)
c	for  lexical  analysis  by  INTOK and the like. That
c	analysis  will  start  at position STR of the buffer.
c	To  start  from the beginning use STR = 1, of course.
c
c	var
c	===
c
	character*1 chr
	integer k,kind,where
	logical eol,finito
	common /lexi/chr,kind,where,finito
c
c	begin
c	=====
c
c	lets start where user wants
c
	k=len(buffer)
	if (str.gt.k) then
	   finito=.true.
	   return
	endif
	if (str.le.0) str=1
	where=str-1	!force inchr to reset buffer from str
	eol=.false.
	finito=.false.
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) then
	   finito=.true.
	   return
	endif
c
	return
c
c
	end
c
c
c
c
	subroutine intok_(type,value,decim,rvalue,
     1                    buffer,lim,pos1,pos2,msg,erro)
c	************************************************
c
	implicit none
c
	integer type,value,decim,lim,pos1,pos2,erro
	real rvalue
	character*(*) buffer,msg
c
c	Written by Luis Arriaga da Cunha 1984
c
c	Description
c	===========
c
c	Lexical  analysis  is performed on contents of buffer
c	giving  tokens  one at a time. Tokens have a TYPE,  a
c	possible VALUE, their string is between POS1 and POS2
c	of  BUFFER. This later is used up to LIM but not here.
c	If  the token is a "decimal integer", eg 362.92, then
c	DECIM  tells  the number of decimal places and  value
c	the  value  with  the dot dropped, for instance 2 and
c	36292 for the example. If the token  is a real number
c	RVALUE is the one. In MSG a possible error message is
c	given back to the user.
c
c	Note that BUFFER can be changed by INTOK (namely if a
c	double quoted string is found, eg 'a''bc'), so caller
c	should have his own copy if needed!!!!!!!!!!!!!!!!!!!
c
c	ACHTUNG !!! If ERRO comes in as zero no error message
c	is written on the terminal, otherwise message will be
c	displayed in channel 5.
c
c	Types of tokens can be :
c
c		0	end of buffer ( "false token" )
c		1	identifier with NO underlines( XPTO3 )
c		2	integer ( 347 )
c		3	decimal ( 120.53 )
c		4	real ( ??? )
c		5	string ( 'Luis Arriaga da Cunha ' )
c			Note that an eol ends a string.
c		6	(
c		7	)
c		8	,
c		9	=
c		10	*
c		11	/
c		12	+
c		13	-
c		14	?
c		15	<
c		16	>
c		17	<>
c		18	:
c		19	@
c		20	^ or **
c		21	.
c		22	<= or =<
c		23	>= or =>
c		24	identifier with underlines ( John_Smith )
c		25	$
c		26	**********defined elsewhere**********
c		27	**********defined elsewhere**********
c		28	**********defined elsewhere**********
c		29	**********defined elsewhere**********
c		30	**********defined elsewhere**********
c		31	**********defined elsewhere**********
c		32	**********defined elsewhere**********
c		33	%
c		34	**********defined elsewhere**********
c		35	**********defined elsewhere**********
c		36	**********defined elsewhere**********
c		37	[
c		38	]
c		39	empty string '' or '<ret>
c		40	#
c		41	// catenation symbol
c		42	!
c		43	"
c
c	ACHTUNG !!! If TYPE comes in as zero, user wants
c	to initialize the scanning of the BUFFER. A call
c	to INCHR with WHERE zero is therefore performed.
c
c	The lexical analyser works with a small  context
c	kept  in common LEXI (see var section) where the
c	currnt character CHR,KIND and position in buffer
c	WHERE are stored to be shared with perhaps other
c	lexical analysers.
c
c	Values have meaning for integers.
c	From 6 to 19 we could call them operators.
c	Please  dont  confuse types with dispatch values
c	given in kind.
c
c	var
c	===
c
	include 'own:dbagthin.own'
c
	character*1 chr
	integer k,kind,where,ndigit
	logical eol,finito,show,acumul
	common /lexi/chr,kind,where,finito
c
	integer zero
c
	data zero/48/	!ichar('0')
c
c	begin
c	=====
c
c	are we to finish ?
c
	if (finito) then
	   type=0
	   erro=0		!fix bug...
	   eol=.false.
	   finito=.false.
	   return
	endif
c
	if (erro.eq.0) then
	   show=.false.
	else
	   show=.true.
	   erro=0
	endif
	eol=.false.
	value=0
	decim=0
	rvalue=0.0
c
	if (digmax.le.0) digmax=9
	if (intmax.le.0) intmax=999999999
c
100	continue
c
	pos1=where
	pos2=where
c
	goto (1,2,3,4,5,6,7,8,9,10,
     1        11,12,13,14,15,16,17,18,19,20,
     1        21,22,23,24,25,26,27) kind
c
c	here error
c	----------
c
20	continue
	erro=1
	if (ichar(chr).lt.ichar(' ')
     1      .or.
     1      ichar(chr).gt.ichar('}')) then
	   write(msg(1:),10001)ichar(chr)
	   if (show) then
	      write(5,10003)ichar(chr)
	   endif
	else
	   write(msg(1:),10002)chr
	   if (show) then
	      write(5,10004)ichar(chr)
	   endif
	endif
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
	goto 100
c
c	separators ( no token produced)
c	-------------------------------
c
1	continue
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
cwhile	do while (chr.eq.' '.or.chr.eq.'	')	!space or tab
1098	continue
	   if (.not.(chr.eq.' '.or.chr.eq.'	')) goto 1099
c
	   call inchr_(chr,kind,buffer,where,eol)
	   if (eol) goto 200
c
	   goto 1098
1099	continue
cwhile	enddo
	goto 100
c
c	identifiers
c	-----------
c
2	continue
	type=1
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
cwhile	do while (kind.eq.2.or.kind.eq.3.or.kind.eq.20)!letters ! digits ! "_"
1096	continue
	   if (.not.(kind.eq.2.or.kind.eq.3.or.kind.eq.20)) goto 1097
c
	   if (kind.eq.20) type=24
	   pos2=where
	   call inchr_(chr,kind,buffer,where,eol)
	   if (eol) goto 200
c
	   goto 1096
1097	   continue
cwhile	enddo
	return
c
c	integers or decimals
c	--------------------
c
3	continue
	type=2
	acumul=.true.
	ndigit=1
	value=ichar(chr)-zero
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
cwhile	do while (kind.eq.3)
1094	continue
	   if (kind.ne.3) goto 1095
c
	   ndigit=ndigit+1
	   pos2=where
	   if (ndigit.gt.digmax) then
	      erro=2
	      acumul=.false.
	      write(msg(1:),10005)
	      if (show) then
	         write(5,10006)
	      endif
	   endif
	   if (acumul) value=value*10+( ichar(chr)-zero )
	   if (abs(value).gt.intmax) then
	      erro=2
	      acumul=.false.
	      write(msg(1:),10005)
	      if (show) then
	         write(5,10006)
	      endif
	   endif
	   call inchr_(chr,kind,buffer,where,eol)
	   if (eol) goto 200
c
	   goto 1094
1095	continue
cwhile	enddo
	if (chr.eq.'.') then
	   type=3
	   call inchr_(chr,kind,buffer,where,eol)
	   if (eol) then
	      rvalue=(float(value))/(10.0**decim)
	      goto 200
	   endif
cwhile	   do while (kind.eq.3)
1092	   continue
	      if (kind.ne.3) goto 1093
c
	      ndigit=ndigit+1
	      decim=decim+1
	      pos2=where
	      if (ndigit.gt.digmax) then
	         erro=2
	         acumul=.false.
	         write(msg(1:),10005)
	         if (show) then
	            write(5,10006)
	         endif
	      endif
	      if (acumul) value=value*10+( ichar(chr)-zero )
	      if (abs(value).gt.intmax) then
	         erro=2
	         acumul=.false.
	         write(msg(1:),10005)
	         if (show) then
	            write(5,10006)
	         endif
	      endif
	      call inchr_(chr,kind,buffer,where,eol)
	      if (eol) then
	         rvalue=(float(value))/(10.0**decim)
	         goto 200
	      endif
c
	      goto 1092
1093	   continue
cwhile	   enddo
	endif
c
	rvalue=(float(value))/(10.0**decim)
c
	return
c
c	string (proper ones)
c	--------------------
c
4	continue
	type=5
	pos1=where+1
	pos2=0
	call inchr_(chr,kind,buffer,where,eol)
cx	if (eol) goto 200
	if (eol) goto 444
	k=where
cwhile	do while (kind.ne.4)
1090	continue
	   if (kind.eq.4) goto 1091
c
44	   continue		!oh  yeh
	   buffer(k:k)=buffer(where:where)
	   pos2=k
	   call inchr_(chr,kind,buffer,where,eol)
cx	   if (eol) goto 200
	   if (eol) goto 444
	   k=k+1
c
	   goto 1090
1091	continue
cwhile	enddo
	call inchr_(chr,kind,buffer,where,eol)
cx	if (eol) then
cx	   if (pos1.gt.0.and.pos2.eq.0) then
cx	      pos2=pos1
cx	      type=39		!empty string, new token
cx	   endif
cx	   goto 200
cx	endif
	if (eol) goto 444
	if (kind.eq.4) goto 44
c
c	Check empty strings on normal return!
c
	if (pos1.gt.0.and.pos2.eq.0) then
	   pos2=pos1
	   type=39		!empty string, new token
	endif
	return
c
c	Check empty strings on eol!
c
444	continue
	if (pos1.gt.0.and.pos2.eq.0) then
	   pos2=pos1
	   type=39		!empty string, new token
	endif
	goto 200
c
c	(
c
5	continue
	type=6
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	)
c
6	continue
	type=7
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	,
c
7	continue
	type=8
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	= or =< or =>
c
8	continue
	type=9
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
	if (chr.eq.'<') then
	   pos2=pos2+1
	   type=22
	   call inchr_(chr,kind,buffer,where,eol)
	   if (eol) goto 200
	elseif (chr.eq.'>') then
	   pos2=pos2+1
	   type=23
	   call inchr_(chr,kind,buffer,where,eol)
	   if (eol) goto 200
	endif
	return
c
c	* or **
c
9	continue
	type=10
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
	if (chr.eq.'*') then
	   pos2=pos2+1
	   type=20
	   call inchr_(chr,kind,buffer,where,eol)
	   if (eol) goto 200
	endif
	return
c
c	/ or //
c
10	continue
	type=11
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
	if (chr.eq.'/') then
	   pos2=pos2+1
	   type=41
	   call inchr_(chr,kind,buffer,where,eol)
	   if (eol) goto 200
	endif
	return
c
c	+
c
11	continue
	type=12
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	-
c
12	continue
	type=13
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	?
c
13	continue
	type=14
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	< or <> or <=
c
14	continue
	type=15
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
	if (chr.eq.'>') then
	   pos2=pos2+1
	   type=17
	   call inchr_(chr,kind,buffer,where,eol)
	   if (eol) goto 200
	elseif (chr.eq.'=') then
	      pos2=pos2+1
	      type=22
	      call inchr_(chr,kind,buffer,where,eol)
	      if (eol) goto 200
	endif
	return
c
c	> or >=
c
15	continue
	type=16
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
	if (chr.eq.'=') then
	   pos2=pos2+1
	   type=23
	   call inchr_(chr,kind,buffer,where,eol)
	   if (eol) goto 200
	endif
	return
c
c	:
c
16	continue
	type=18
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	@
c
17	continue
	type=19
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	^
c
18	continue
	type=20
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	.
c
19	continue
	type=21
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	$
c
21	continue
	type=25
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	%
c
22	continue
	type=33
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	[
c
23	continue
	type=37
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	]
c
24	continue
	type=38
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	#
c
25	continue
	type=40
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	!
c
26	continue
	type=42
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	"
c
27	continue
	type=43
	call inchr_(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c
c
c
c	end of buffer (false token)
c	---------------------------
c
200	continue
	finito=.true.	!for next time
	return
c
c	formats
c	=======
c
	include 'fmt:INTOK.FMT'
c
c
	end
c
c
c
c
	subroutine inwht_(type,value,decim,rvalue,
     1                    buffer,lim,pos1,pos2,msg,erro)
c	************************************************
c
	implicit none
c
	integer type,value,decim,lim,pos1,pos2,erro
	real rvalue
	character*(*) buffer,msg
c
c	Written by Luis Arriaga da Cunha 1984
c
c	Description
c	===========
c
c	False  lexical  analyser, specialized for DBAG expressions.
c	Calls  INTOK  and  is transparent for most tokens. However,
c	some new tokens are recognized, namely :
c
c		24	this type of identifier becomes as token 1
c		26	date in format, eg "20-aug-1984" or 20/08/84
c			NOT as an integer, eg 200884 !!!
c		27	T or t for logical true
c		28	F or f for logical false
c		29	.NOT.
c		30	.AND.
c		31	.OR.
c		32	.XOR.
c	       (33	% ) see below
c**********	34	number:number (frozen for now...)
c**********	35	%number (frozen for now...)
c		36	file specification (NOT HERE ! SEE INFSPC!!!)
c		37	used, see below
c		38	used, see below
c		39	used, see below
c		40	used, see below
c		41	used, see below
c		42	used, see below
c		 9	.EQ. ( same as =  )
c		17	.NE. ( same as <> )
c		16	.GT. ( same as >  )
c		15	.LT. ( same as <  )
c		23	.GE. ( same as >= )
c		22	.LE. ( same as <= )
c
c	All  other  aspects  are exactly like INTOK, including the
c	calling arguments and its meaning.
c
c	Reminder from INTOK :
c
c	ACHTUNG !!! If ERRO comes in as zero no error message
c	is written on the terminal, otherwise message will be
c	displayed in channel 5.
c
c	Types of tokens can be :
c
c		0	end of buffer ( "false token" )
c		1	identifier with NO underlines( XPTO3 )
c		2	integer ( 347 )
c		3	decimal ( 120.53 )
c		4	real ( ??? )
c		5	string ( 'Luis Arriaga da Cunha ' )
c		6	(
c		7	)
c		8	,
c		9	=
c		10	*
c		11	/
c		12	+
c		13	-
c		14	?
c		15	<
c		16	>
c		17	<>
c		18	:
c		19	@
c		20	^ or **
c		21	.
c		22	<= or =<
c		23	>= or =>
c		24	identifier with underlines ( John_Smith )
c		25	$
c		33	%
c	        37	[
c		38	]
c		39	empty string '' or '<ret>
c		40	#
c		41	// catenation symbol
c		42	!
c
c	ACHTUNG !!! If TYPE comes in as zero, user wants
c	to initialize the scanning of the BUFFER. A call
c	to INCHR with WHERE zero is therefore performed.
c
c	var
c	===
c
	integer opos1,opos2
	real orvalue
	integer l1,l2,m,k,form
	character*5 logal
c
c	begin
c	=====
c
c	call INTOK straight away
c
	call intok_(type,value,decim,rvalue,
     1                    buffer,lim,pos1,pos2,msg,erro)
	if (erro.ne.0) return
c
c	dispatch on TOKEN TYPE !!!, not char type !!!
c
	goto (100,1,2,3,4,5,6,7,8,9,10,
     1       11,12,13,14,15,16,17,18,19,20,
     1       21,22,23,24,25,
     1       100,100,100,100,100,100,100,
     1       33) type+1
c
c	here nothing to do
c	------------------
c
100	continue
3	continue
4	continue
5	continue
6	continue
7	continue
8	continue
9	continue
11	continue
12	continue
13	continue
14	continue
15	continue
16	continue
17	continue
18	continue
19	continue
20	continue
22	continue
23	continue
25	continue
33	continue
	return
c
c	identifiers might become T or F (true or false)
c	-----------------------------------------------
c
1	continue
c
	l1=pos1
	l2=pos2
	if ( (l2-l1).gt.0 ) then
	   goto 101	!too long whatever it is
	else
	   logal(1:)=buffer(l1:l2)
	   call uc_ (logal(1:1))
	endif
	if (logal(1:1).eq.'T') then
	   type=27
	   value=1
	elseif (logal(1:1).eq.'F') then
	   type=28
	   value=0
	else
	   goto 101
	endif
101	continue
	return
c
c	identifiers with underline become normal identifiers
c	----------------------------------------------------
c
24	continue
	type=1
	return
c
c	integers might produce x:y or dates
c	-----------------------------------
c
2	continue
c
c	remember where you are
c
	opos1=pos1
c
c	see if x:y
c
cx	call intok_(type,m,decim,rvalue,
cx     1                 buffer,lim,pos1,pos2,msg,erro)
cx	if (type.eq.18) then	!":"
cx	   call intok_(type,m,decim,rvalue,
cx     1                    buffer,lim,pos1,pos2,msg,erro)
cx	   if (type.eq.2) then	!number
cx	      decim=m
cx	      type=34
cx	   else
cx	      goto 102
cx	   endif
cx	else
cx	   goto 1002
cx	endif
cx	pos1=opos1	!token is the whole string
cxc
cx	return
c
c	see if possible date, code also shared if wild card date
c
c	go back to buffer as it was from original INTOK
c
1002	continue
	call rstok_(buffer,opos1,erro)
	call intok_(type,value,decim,rvalue,
     1                    buffer,lim,pos1,pos2,msg,erro)
c
	call numdat_(value,buffer(pos1:),k,form,erro)
	if (form.ne.3.and.form.ne.6) then	!NOT a whole number
	   if (erro.eq.0.or.erro.eq.9) then	!completely ok or wild card
	      erro=0
	      type=26	!a date found !!!
	   else
	      erro=0
	      goto 102	!give up
	   endif
	   pos1=opos1	!token starts in the 1st integer given
	   pos2=pos1+k-1!and ends where it should
	   call rstok_(buffer,pos2+1,erro)
cmota
	else
	   erro=0
	   goto 102	!give up
cmota
	endif
c
	return
c
c	go back to buffer as it was from original INTOK
c
102	continue
	call rstok_(buffer,opos1,erro)
	call intok_(type,value,decim,rvalue,
     1                    buffer,lim,pos1,pos2,msg,erro)
	return
c
c	"*" might be date in wild card format
c	-------------------------------------
c
10	continue
c
c	remember where you are
c
	opos1=pos1
c
	goto 1002	!join other code, sorry
c
c	"." might become  .NOT.  .AND.  .OR.  .XOR.  .T.  .F.
c	or .EQ. .NE. .GT. LT. .GE. .LE.
c	-----------------------------------------------------
c
21	continue
c
c	remember where you are
c
	opos1=pos1
c
	l1=pos1
	call intok_(type,value,decim,rvalue,
     1                    buffer,lim,pos1,pos2,msg,erro)
	if (type.eq.1) then	!identifier
	   call intok_(type,value,decim,rvalue,
     1                       buffer,lim,pos1,pos2,msg,erro)
	   if (type.eq.21) then	! "."
	      l2=pos2
	      if ( (l2-l1).gt.4 ) then
	         goto 121	!too long whatever it is
	      else
	         logal(1:)=buffer(l1:l2)
	         call uc_ (logal(1:))
	      endif
	      if (logal(1:5).eq.'.NOT.') then
	         type=29
	      elseif (logal(1:5).eq.'.AND.') then
	         type=30
	      elseif (logal(1:4).eq.'.OR.')  then
	         type =31
	      elseif (logal(1:5).eq.'.XOR.') then
	         type=32
	      elseif (logal(1:3).eq.'.T.') then
	         type=27
	      elseif (logal(1:3).eq.'.F.') then
	         type=28
	      elseif (logal(1:5).eq.'.EQ.') then
	         type= 9
	      elseif (logal(1:5).eq.'.NE.') then
	         type=17
	      elseif (logal(1:5).eq.'.GT.') then
	         type=16
	      elseif (logal(1:5).eq.'.LT.') then
	         type=15
	      elseif (logal(1:5).eq.'.GE.') then
	         type=23
	      elseif (logal(1:5).eq.'.LE.') then
	         type=22
	      else
	         goto 121
	      endif
	   else
	      goto 121
	   endif
	else
	   goto 121
	endif
	pos1=opos1	!token is the whole string
	return
c
c	go back to buffer as it was from original INTOK
c
121	continue
	call rstok_(buffer,opos1,erro)
	call intok_(type,value,decim,rvalue,
     1                    buffer,lim,pos1,pos2,msg,erro)
	return
c
c
c	what foloow is frozen for now...
c
c	"%" might produce reference by number ( eg %65 )
c	------------------------------------------------
c
cx33	continue
c
c	remember where you are
c
cx	opos1=pos1
c
cx	l1=pos1
cx	call intok_(type,value,decim,rvalue,
cx     1                 buffer,lim,pos1,pos2,msg,erro)
cx	if (type.eq.2) then	!number
cx	   type=35
cx	else
cx	   goto 133
cx	endif
cx	pos1=opos1	!token is the whole string
cx	return
c
c	go back to buffer as it was from original INTOK
c
cx133	continue
cx	call rstok_(buffer,opos1,erro)
cx	call intok_(type,value,decim,rvalue,
cx     1                 buffer,lim,pos1,pos2,msg,erro)
cx	return
c
	end
c
c
c
c
	subroutine infspc_(type,what,name,ext,val,dec,rval,
     1                     buffer,lim,pos1,pos2,msg,erro)
c	***************************************************
c
	implicit none
c
	integer type,what,val,dec,lim,pos1,pos2,erro
	real rval
	character*(*) name,ext,buffer,msg
c
c	Written by Luis Arriaga da Cunha , Antonio Mota, 1985
c
c	Description
c	===========
c
c	False  lexical  analyser, specialized for file specification
c	recognition. It recognizes the following things:
c
c	Possible dev:directory specification [.....] followed by:
c
c		name.ext	-> what = 1
c		name.		-> what = 2
c		name		-> what = 3
c
c	In  any case type will be 36 for a proper file specification.
c	NAME  gives  back the name that was found, EXT the extension.
c
c
c	var
c	===
c
	integer lim1,lim2,opos1,opos2,nxtpos
c
c	begin
c	=====
c
	erro=0
	what=0
c
c	call INWHT straight away
c
	call inwht_(type,val,dec,rval,
     1                    buffer,lim,pos1,pos2,msg,erro)
	if (erro.ne.0) goto 90001
	if (type.eq.0) return			!why was I called ?...
	opos1=pos1
	opos2=pos2
	nxtpos=pos2+1				!save next position in buffer
c
c	dev: specification ?
c
	lim1=index(buffer(pos1:),':')
	if (lim1.le.0) goto 22			!none
	lim2=index(buffer(pos1:),' ')		!no spaces allowed "in-between"
	if (lim2.gt.0.and.
     1      lim2.lt.lim1  ) goto 22		!none
c
11	continue				!loop until ":"
	   if (type.eq.18) then			!":"
	      call inwht_(type,val,dec,rval,
     1                    buffer,lim,pos1,pos2,msg,erro)
	      if (erro.ne.0) goto 90001
	      opos2=pos2
	      nxtpos=pos2+1			!save next position in buffer
	      goto 22
	   endif
c
	   call inwht_(type,val,dec,rval,
     1                 buffer,lim,pos1,pos2,msg,erro)
	   if (erro.ne.0) goto 90001
	goto 11
c
22	continue
c
c	perhaps directory specification
c
	if (type.eq.37) then			! "[" loop until "]"
1	   continue
	   call inwht_(type,val,dec,rval,
     1                       buffer,lim,pos1,pos2,msg,erro)
	   if (erro.ne.0) goto 90001
	   opos2=pos2
	   nxtpos=pos2+1			!save next position in buffer
	   if (type.eq.38.or.type.eq.0) then 	! "]" or <ret>, break now!!!
	      call inwht_(type,val,dec,rval,
     1                    buffer,lim,pos1,pos2,msg,erro)
	      if (erro.ne.0) goto 90001
	      opos2=pos2
	      nxtpos=pos2+1			!save next position in buffer
	      goto 2
	   endif
	   goto 1
2	   continue
	endif
c
c	identifier, t or f must follow
c
	if (type.eq.1.or.			!id. without "_"
     1      type.eq.24.or.			!or with "_"
     1      type.eq.27.or.type.eq.28) then	!identifier must follow
	   name(1:)=buffer(opos1:pos2)		!remember name
c
c	   look for ".ext"
c
	   call inwht_(type,val,dec,rval,buffer,lim,pos1,pos2,msg,erro)
	   if (erro.ne.0) goto 90001
c
	   if (type.eq.21.and.pos1.eq.nxtpos) then	! "." with no spaces
	      opos2=pos2
	      nxtpos=pos2+1
	      call inwht_(type,val,dec,rval,buffer,lim,pos1,pos2,msg,erro)
	      if (erro.ne.0) goto 90001
cx	      opos2=pos2
	      if ((type.eq.1.or.type.eq.2.or.
     1             type.eq.27.or.type.eq.28).and.
     1            ( pos1.eq.nxtpos)     )     then	!identifier/number
	         what=1
	         ext(1:)=buffer(pos1-1:pos2)		!give back extension
	         pos1=opos1
	         type=36
	      else
	         what=2					!empty extension
	         ext(1:)='. '
	         if (type.gt.0) then
	            pos2=opos2
	            call rstok_(buffer,opos2+1,erro)
	         else
	            call rstok_(buffer,opos2+1,erro)
	         endif
	         pos1=opos1
	         type=36
	      endif
	   else
	      what=3				!no extension at all
	      ext(1:)=' '
	      if (type.gt.0) then
	         pos2=opos2
	         call rstok_(buffer,opos2+1,erro)
	      else
	         call rstok_(buffer,opos2+1,erro)
	      endif
	      pos1=opos1
	      type=36				!file spec type
	   endif
	else
c	   nothing to do, return fisrt token in buffer...
	   name(1:)=' '
	   ext(1:)=' '
cx	   if (type.gt.0) then
              call rstok_(buffer,opos1,erro)
cx	   else
cx	      call rstok_(buffer,opos2+1,erro)
cx	   endif
	   call inwht_(type,val,dec,rval,
     1                 buffer,lim,pos1,pos2,msg,erro)
	   if (erro.ne.0) goto 90001
	endif
c
	return
c
c	errors
c	------
c
c	inherited error
90001	continue
	return
c
c
	end
c
c
c
c
