	program dbimport
c	****************
c
	implicit none
c
c	Formats sequential files into DBAG files.
c
c	var
c	===
c
	include 'own:dbagf.own'
c
	integer nfmax,nlmax,fsizemax,linemax
	parameter (nfmax=120,nlmax=100,fsizemax=120,linemax=1500)

c
	external istrip_
	integer istrip_
	logical at,save,free,unify,user1,usern,first,minus,zeroe
	integer tti,tto,lim1,lim2,k,k1,kkk,nf,nl,recsiz,erro,ichn,ochn,cchn
	integer start,size,reclin,srclin(nfmax),inipos(nfmax),endpos(nfmax)
	integer inpform,opcao,field(nfmax),record,inprec,nok,nbad,ntrunc
	integer blnktozero(nfmax),nbtoz,zerotoblnk(nfmax),nztob,numax
	integer base,bbb,rec,f,type,val,dec,lim,p1,p2
	double precision rval
	character*10 bnam,mymnem,mnem(nfmax)
	character*132 buf,mssg
	character*(linemax) inplin
	character*60 ifnam,ofnam,cfnam,what
	character*200 cmmd
	character*3 newold
	character*1 bell,nobell,nada,fldsep,strsep,yesno
	character*(fsizemax) page(nfmax)
	character*50 numtxt
	integer pos1,pos2
c
c	begin
c	=====
c
	bell=char(7)
	nobell=char(32)
	numax=len(numtxt)
c
	call newc_(tti)
	call newc_(tto)
	call newc_(ichn)
	call newc_(ochn)
	call newc_(cchn)
c
	call init_(erro)		!init DBAG
	if (erro.ne.0) goto 980
c
	nok=0
	nbad=0
	ntrunc=0
c
	recsiz=fsizemax+40		!output file record lenght
c
	open (unit=tto,file='sys$output',status='unknown',recl=recsiz+30)
c
	write (tto,456)
456	format (//,15x,' 		*** DBIMPORT ***',//,
	1 15x,'  Convert sequencial files into DBAG files')
c
c	Loop to convert files
c
800	continue
c
	open (unit=tti,file='sys$input',status='unknown')
c
	do k = 1, nfmax
	   mnem(k)(1:)=' '
	enddo
c
	nbtoz=0			!(replace) blanks to zeroes
	nztob=0			!          zeroes by blanks
c
c	Format of input file or previous dialog
c
99	continue
c
	at=.false.		!not reading @file
c
	write (tto,2801)
2801	format (//'   0 -     exit',/,
	1         '   1 -     use previous dialogue',/,
	1       /,'             input file format is :',//,
	1         '   2 -     user-defined, multiline',/,
	1         '   3 -     free        ( supply field and strings ',
	1                                   'separator)',/,
	1         '   4 -     user-defined, one input line/record ',
	1                                   '(e.g. SDF files)'/,
	1         '   5 -     UNIFY       ( fields separated by "|")',/,
	1         '   6 -     UNIFY-like  ( supply field separator )',/,
	1       /,'   Answer : ',$)
	read (tti,'(q,a)',err=99,end=900) lim2,numtxt
	if (lim2.le.0.or.lim2.gt.numax) goto 900
	read (numtxt(1:lim2),'(i<lim2>)',err=99) opcao
c
	if (opcao.eq.0) goto 900
	if (opcao.lt.0.or.opcao.gt.6) goto 99
c
	if (opcao.eq.1) then
109	   continue
	   write (tto,100)
100	   format (/' Dialogue file : ',$)
	   read (tti,'(a)',err=109,end=900) cfnam
	   lim1=istrip_(cfnam)
	   if (lim1.le.0) goto 99
	   open (unit=tti,file=cfnam,status='old',readonly,err=1001)
	   goto 1002
1001	   continue
	   write (tto,10011) bell
10011	   format (1x,a,/' %Can''t open dialogue file')
	   if (.not.at) open (unit=tti,file='sys$input',status='unknown')
	   open (unit=tti,file='sys$input',status='unknown')
	   goto 109
1002	   continue
	   at=.true.
	   read (tti,*,err=99,end=900) opcao
	endif
c
	free=.false.
	unify=.false.
	user1=.false.
	usern=.false.
	fldsep=' '		!field separator
	strsep=' '		!string separator
c
	if (opcao.eq.3.or.
	1   opcao.eq.6    ) then
999	   continue
	   write (tto,9991)
9991	   format (/' Field separator : ',$)
	   read (tti,'(a)',err=999,end=900) fldsep
	   if (opcao.eq.3) then
	      call rstok_(fldsep,1,erro)	!reset buffer
	      erro=0		!only my own messages
	      call intok_(type,val,dec,rval,fldsep,lim,p1,p2,mssg,erro)
	      if (erro.ne.0) then	!can't use that !
	         write (tto,8884) bell
8884	         format (1x,a,/,' %Sorry, can''t use that separator !...')
	         goto 888
	      endif
	   endif
	   if (at) write (tto,'(1x,a)') fldsep
	endif
c
	if     (opcao.eq.1) then
	   usern=.true.		!can''t be = 1 !!!
	   inpform=f$user
	elseif (opcao.eq.2) then
	   usern=.true.
	   inpform=f$user
	elseif (opcao.eq.4) then
	   user1=.true.
	   inpform=f$user
	elseif (opcao.eq.3) then
	   free=.true.
	   inpform=f$free
888	   continue
	   write (tto,8881)
8881	   format (/' String delimiter : ',$)
	   read (tti,'(a)',err=888,end=900) strsep
	   call rstok_(strsep,1,erro)	!reset buffer
	   erro=0		!only my own messages
	   call intok_(type,val,dec,rval,strsep,lim,p1,p2,mssg,erro)
	   if (erro.ne.0) then	!can't use that !
	      write (tto,8882) bell
8882	      format (1x,a,/,' %Sorry, can''t use that delimiter !...')
	      goto 888
	   endif
	   if (strsep.eq.fldsep) then	!can't be the same
	      write (tto,8883) bell
8883	      format (1x,a,/,' %Can''t be equal to the field separator !')
	      goto 888
	   endif
	   if (at) write (tto,'(1x,a)') strsep
	elseif (opcao.eq.5) then
	   unify=.true.
	   fldsep='|'
	   inpform=f$unify
	elseif (opcao.eq.6) then
	   unify=.true.
	   inpform=f$unify
	endif
c
c	Input file
c
9999	continue
c
	save=.false.		!don't save dialogue
c
	write (tto,103)
103	format (/' Input file    : ',$)
	read (tti,'(a)',err=9999,end=900) ifnam
	if (at) write (tto,'(1x,a)') ifnam
	lim1=istrip_(ifnam)
	if (lim1.le.0) goto 9999
c
	open (ichn,file=ifnam,status='old',readonly,err=101)
	goto 102
c
101	continue
	write (tto,110) bell
110	format (1x,a,/' %Can''t open input file')
	if (.not.at) open (unit=tti,file='sys$input',status='unknown')
	goto 9999
102	continue
c
c	Output file
c
199	continue
	write (tto,200)
200	format (' Output file   : ',$)
	read (tti,'(a)',err=199,end=900) ofnam
	if (at) write (tto,'(1x,a)') ofnam
	lim1=istrip_(ofnam)
	if (lim1.le.0) goto 199
c
	if (.not.at) then
c
119	   continue
	   write (tto,120)
120	   format (/' File to save dialogue (<ret> if none) : ',$)
	   read (tti,'(a)',err=119,end=900) cfnam
	   lim1=istrip_(cfnam)
	   if (lim1.gt.0) then
	      open (cchn,file=cfnam,status='new',carriagecontrol='list',
	1           err=121)
	      goto 122
121	      continue
	      write (tto,130) bell
130	      format (1x,a,' %Can''t open save file')
	      if (.not.at) open (unit=tti,file='sys$input',status='unknown')
	      goto 119
122	      continue
	      save=.true.
	   endif
	else
	   read (tti,'(a)',err=99,end=900) nada
	endif
c
	if (save) then
	   write (cchn,'(i3)') opcao
	   if (free.or.unify) write (cchn,'(a)') fldsep
	   if (free) write (cchn,'(a)') strsep
	   write (cchn,'(a)') ifnam
	   write (cchn,'(a)') ofnam
	   lim1=istrip_(cfnam)
	   if (lim1.le.0) lim1=1
	   write (cchn,'(a)') cfnam(1:lim1)
	endif
c
2799	continue
c
	if     (free) then		!free format
	   first=.true.
	elseif (unify) then		!UNIFY or UNIFY-like format
	   first=.true.
	elseif (usern) then			!user-defined format, multiline
c
c	   "Lines/record"
c
	   write (tto,261)
261	   format(/,
	1  5x,'  The user-defined formatted files have a fixed number of',/,
	1  5x,'  lines and a fixed number of fields.  These can exist on',/,
	1  5x,'  any fixed portion of any input line')
c
249	   continue
	   write (tto,250) nlmax
250	   format (/' No. of input lines / record" (max.',i4,') : ',$)
	   read (tti,'(q,a)',err=249,end=900) lim2,numtxt
	   if (lim2.le.0.or.lim2.gt.numax) goto 249
	   read (numtxt(1:lim2),'(i<lim2>)',err=249) nl
c
	   if (at) write (tto,*) nl
	   if (nl.lt.0) goto 249
	   if (nl.eq.0) goto 249
	   if (nl.gt.nlmax) goto 249
	   if (save) write (cchn,*) nl
c
c	   Specify fields (mnemonic, initial position, size, "record line")
c
299	   continue
	   write (tto,300) nfmax
300	   format (/' No. of fields (max.',i3,') : ',$)
	   read (tti,'(q,a)',err=299,end=900) lim2,numtxt
	   if (lim2.le.0.or.lim2.gt.numax) goto 299
	   read (numtxt(1:lim2),'(i<lim2>)',err=299) nf
c
	   if (at) write (tto,*) nf
	   if (nf.lt.0) goto 299
	   if (nf.eq.0) goto 299
	   if (nf.gt.nfmax) goto 299
	   if (save) write (cchn,*) nf
c
	   write (tto,400)
400	   format (/' For each field, enter : mnemonic, start,',
	1           ' size [,"input line"]',/,
	1           '    ("input line" defaults to 1)'/)
c
	   recsiz=-1
	   do k = 1, nf
c
399	      continue
	      write (tto,401) k
401	      format (' field',i3,' > ',$)
	      read (tti,'(a)',err=399,end=900) buf
	      lim1=istrip_(buf)
	      if (lim1.le.0) goto 399
	      if (at) write (tto,'(1x,a)') buf(1:lim1)
c
	      reclin=-1			!force error if problem somewhere
c
	      call rstok_(buf,1,erro)		!reset buffer
c
c	      get mnemonic
c
	      erro=0				!only my own messages
	      call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	      if (erro.ne.0) goto 350
c
	      if (type.eq.0) goto 350		!eol
	      if (type.ne.1.and.
	1         type.ne.24    ) goto 350	!no mnemonic (abc or ab_c)
c
	      lim1=p2-p1+1
	      if (lim1.gt.10) then
	         lim1=10
	         write (tto,3599) bell,buf(p1:p1+lim1-1)
	      endif
	      mymnem(1:)=' '
	      mymnem=buf(p1:p1+lim1-1)
	      call uc8to7_(mymnem)
c
	      do k1 = 1, k-1
	         if (istrip_(mymnem).gt.0) then
	            if (mymnem.eq.mnem(k1)) then
	               write (tto,3598) bell,mymnem	!mnem already exists
	               goto 399
	            endif
	         endif
	      enddo
c
c	      get start or ", start"
c
	      erro=0				!only my own messages
	      call intok_(type,start,dec,rval,buf,lim,p1,p2,mssg,erro)
	      if (erro.ne.0) goto 350
c
	      if (type.eq.0) goto 350		!eol
c
	      if (type.eq.8) then		!","
	         erro=0				!only my own messages
	         call intok_(type,start,dec,rval,buf,lim,p1,p2,mssg,erro)
	         if (erro.ne.0) goto 350
	      endif
c
	      if (type.ne.2) goto 350		!no integer
c
c	      get size or ", size"
c
	      erro=0	   			!only my own messages
	      call intok_(type,size,dec,rval,buf,lim,p1,p2,mssg,erro)
	      if (erro.ne.0) goto 350
c
	      if (type.eq.8) then		!","
	         erro=0				!only my own messages
	         call intok_(type,size,dec,rval,buf,lim,p1,p2,mssg,erro)
	         if (erro.ne.0) goto 350
	      endif
c
	      if (type.eq.0) goto 350		!eol
	      if (type.ne.2) goto 350		!no integer
c
c	      get record line or ", record line" or eol
c
	      erro=0				!only my own messages
	      call intok_(type,reclin,dec,rval,buf,lim,p1,p2,mssg,erro)
	      if (erro.ne.0) goto 350
c
	      if (type.eq.0) then
	         reclin=1
	      else
	         if (type.eq.8) then		!","
	            erro=0			!only my own messages
	            call intok_(type,reclin,dec,rval,buf,lim,p1,p2,mssg,erro)
	            if (erro.ne.0) goto 350
	         endif
	         if (type.ne.2) then
	            reclin=-1			!force error
	            goto 350			!no integer
	         endif
c
c	         see if line is clean
c
	         if (type.ne.0) then
	            erro=0				!only my own messages
	            call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	            if (erro.ne.0) goto 350
	            if (type.ne.0) then
	               reclin=-1			!force error
	               goto 350			!no eol
	            endif
	         endif
	      endif
c
c	      Here if ok or error
c
350	      continue
c
	      if (reclin.le.0.or.
	1         reclin.gt.nl.or.
	1         start.le.0.or.
	1         start.gt.linemax.or.
	1         size.le.0.or.
	1         start+size-1.gt.linemax) then
	         write (tto,402) bell
402	         format (1x,a,/' ???')
	         write (tto,400)
	         goto 399
	      endif
c
	      if (save) then
	         lim1=istrip_(buf)
	         if (lim1.le.0) lim1=1
	         write (cchn,'(a)') buf(1:lim1)
	      endif
c
	      srclin(k)=reclin
	      inipos(k)=start
	      endpos(k)=start+size-1
	      mnem(k)(1:)=' '
	      mnem(k)=mymnem
	      field(k)=k
c
	      if (start+size-1.gt.recsiz) recsiz=start+size-1
c
	   enddo
c
	   recsiz=recsiz+40
c
	else				!user-defined, one input line
c
	   nl=1				!one input line
	   pos1=1			!first field starts at position 1
c
c	   Specify fields (mnemonic, size)
c
699	   continue
	   write (tto,600) nfmax
600	   format (/' No. of fields (max.',i3,') : ',$)
	   read (tti,'(q,a)',err=699,end=900) lim2,numtxt
	   if (lim2.le.0.or.lim2.gt.numax) goto 699
	   read (numtxt(1:lim2),'(i<lim2>)',err=699) nf
c
	   if (at) write (tto,*) nf
	   if (nf.lt.0) goto 699
	   if (nf.eq.0) goto 699
	   if (nf.gt.nfmax) goto 699
	   if (save) write (cchn,*) nf
c
	   write (tto,608)
608	   format (/' For each field, enter : mnemonic, size',/)
c
	   recsiz=-1
	   do k = 1, nf
c
619	      continue
	      write (tto,629) k
629	      format (' field',i3,' > ',$)
	      read (tti,'(a)',err=619,end=900) buf
	      lim1=istrip_(buf)
	      if (lim1.le.0) goto 619
	      if (at) write (tto,'(1x,a)') buf(1:lim1)
c
	      reclin=-1			!force error if problem somewhere
c
	      call rstok_(buf,1,erro)		!reset buffer
c
c	      get mnemonic
c
	      erro=0				!only my own messages
	      call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
	      if (erro.ne.0) goto 659
c
	      if (type.eq.0) goto 659		!eol
	      if (type.ne.1.and.
	1         type.ne.24    ) goto 659	!no mnemonic (abc or ab_c)
c
	      lim1=p2-p1+1
	      if (lim1.gt.10) then
	         lim1=10
	         write (tto,3599) bell,buf(p1:p1+lim1-1)
	      endif
	      mymnem(1:)=' '
	      mymnem=buf(p1:p1+lim1-1)
	      call uc8to7_(mymnem)
c
	      do k1 = 1, k-1
	         if (istrip_(mymnem).gt.0) then
	            if (mymnem.eq.mnem(k1)) then
	               write (tto,3598) bell,mymnem	!mnem already exists
	               goto 619
	            endif
	         endif
	      enddo
c
	      start=pos1
c
c	      get size or ", size"
c
	      erro=0	   			!only my own messages
	      call intok_(type,size,dec,rval,buf,lim,p1,p2,mssg,erro)
	      if (erro.ne.0) goto 659
c
	      if (type.eq.8) then		!","
	         erro=0				!only my own messages
	         call intok_(type,size,dec,rval,buf,lim,p1,p2,mssg,erro)
	         if (erro.ne.0) goto 659
	      endif
c
	      if (type.eq.0) goto 659		!eol
	      if (type.ne.2) goto 659		!no integer
c
	      reclin=1
c
c	      Here if ok or error
c
659	      continue
c
	      if (reclin.le.0.or.
	1         reclin.gt.nl.or.
	1         start.le.0.or.
	1         start.gt.linemax.or.
	1         size.le.0.or.
	1         start+size-1.gt.linemax) then
	         write (tto,669) bell
669	         format (1x,a,/' ???')
	         write (tto,608)
	         goto 619
	      endif
c
	      if (save) then
	         lim1=istrip_(buf)
	         if (lim1.le.0) lim1=1
	         write (cchn,'(a)') buf(1:lim1)
	      endif
c
	      srclin(k)=reclin
	      inipos(k)=start
	      endpos(k)=start+size-1
	      mnem(k)(1:)=' '
	      mnem(k)=mymnem
	      field(k)=k
c
	      pos1=start+size
c
	      if (start+size-1.gt.recsiz) recsiz=start+size-1
c
	   enddo
c
	   recsiz=recsiz+40
c
	endif
c
c	Replace zeroes by blanks or blanks by zeroes ?
c
	write (tto,700)
700	format(/,
	1     5x,'  For numerical fields, you can replace a zero value by ',
	1        '  spaces',/,
	1     5x,'  or spaces by a zero value')
c
710	continue
c
	nztob=0
c
	write (tto,720)
720	format (/,
	1        '  Enter a list of fields (zero -> spaces), or <ret> if ',
	1        'none')
c
721	continue
	write (tto,7211)
7211	format ('  : ',$)
c
	call getint_(tti,tto,zerotoblnk,nfmax,nztob,1,nfmax,inplin)
c
	if (save.or.at) then
	   lim=istrip_(inplin)
	   if (lim.le.0) lim=1
	   if (save) write (cchn,'(a)') inplin(1:lim)
	   if (at) write (tto,'(1x,a)') inplin(1:lim)
	endif
c
730	continue
c
	nbtoz=0
c
	write (tto,740)
740	format (/,
	1        '  Enter a list of fields (spaces -> zero), or <ret> if ',
	1        'none')
c
741	continue
	write (tto,7411)
7411	format ('  : ',$)
c
	call getint_(tti,tto,blnktozero,nfmax,nbtoz,1,nfmax,inplin)
c
	if (save.or.at) then
	   lim=istrip_(inplin)
	   if (lim.le.0) lim=1
	   if (save) write (cchn,'(a)') inplin(1:lim)
	   if (at) write (tto,'(1x,a)') inplin(1:lim)
	endif
c
c	Output file header
c
	base=1
	newold='NEW'
	what(1:)=' '
	what='DBAG'
	cmmd(1:)=' '
	cmmd(1:)='= DBIMPORT program, input file : '
	cmmd(34:)=ifnam
	cmmd(istrip_(cmmd)+2:)=' ='
	if (recsiz.lt.132) recsiz=132
	erro=0
	call f$ohdr_(ochn,base,ofnam,newold,recsiz,what,cmmd,erro)
	if (erro.ne.0) goto 980
c
c	Process input records now
c
	inprec=0
	record=0
c
c	Read record(s)
c
500	continue
c
	record=record+1
c
	call f$import_(inpform,fldsep,strsep,ichn,inplin,inprec,
	1              nl,srclin,inipos,endpos,page,field,nf,
	1              nfmax,fsizemax,erro)
c
	if (erro.eq.-1) goto 550		!end-of-file
c
	if (erro.ne.0) then
	   if    (erro.eq.1) then
	      goto 358				!1=unknowm format
	   elseif (erro.eq.2) then
	      goto 357				!2=error processing record
	   elseif (erro.eq.3) then
	      goto 354				!3=too many fields
	   else
	      write (tto,4531) bell,fsizemax
4531	      format (1x,a,/,' %Field truncated to DBAG max. ',i3,' !')
	      if ((user1.or.usern).and.nl.gt.1) then
	         lim1=istrip_(inplin)
	         if (lim1.le.0) lim1=1
	         write (tto,4572) bell,inprec,inplin(1:lim1)
4572	         format (1x,a,
	1        '  (last line ',i10,' : ',/,
	1        '   "',a,'")')
	      else
	         lim1=istrip_(inplin)
	         if (lim1.le.0) lim1=1
	         write (tto,4571) bell,inprec,inplin(1:lim1)
4571	         format (1x,a,
	1        '  (input line ',i10,' :',/,
	1        '   "',a,'" )')
	      endif
	      ntrunc=ntrunc+1
	   endif
	endif
c
	if (first) then
c
	   if (free.or.unify) then		!ask for mnemonics
c
	      write (tto,356) nf
356	      format (/,' %Fields found in 1st. input record: ',i5,/)
c
	      do kkk = 1, nf
c
234	         continue
	         write (tto,345) kkk
345	         format (' Mnemonic for field ',i3,' (or <ret>) > ',$)
	         read (tti,'(a)',err=234,end=900) buf
	         lim1=istrip_(buf)
	         if (lim1.le.0) lim1=1
	         if (at) write (tto,'(1x,a)') buf(1:lim1)
c
	         call rstok_(buf,1,erro)	   !reset buffer
c
c	         get mnemonic
c
	         erro=0			!only my own messages
	         call intok_(type,val,dec,rval,buf,lim,p1,p2,mssg,erro)
cxcx	         if (erro.ne.0) 	!ignore error
c
	         if (type.ne.1.and.
	1            type.ne.24.and.
	1            type.ne.0     ) then	!no mnemonic (abc or ab_c)
	            write (tto,902) bell
902	            format (1x,a,/' ???')
	            goto 234
	         endif
c
	         if (save) then
	            lim1=istrip_(buf)
	            if (lim1.le.0) lim1=1
	            write (cchn,'(a)') buf(1:lim1)
	         endif
c
	         if (type.eq.0) then
	            mnem(kkk)(1:)=' '
	         else
	            lim1=p2-p1+1
	            if (lim1.gt.10) then
	               lim1=10
	               write (tto,3599) bell,buf(p1:p1+lim1-1)
	            endif
	            mnem(kkk)(1:)=' '
	            mnem(kkk)=buf(p1:p1+lim1-1)
	         endif
	         call uc8to7_(mnem(kkk))
c
	      do k1 = 1, kkk-1
	         if (istrip_(mnem(kkk)).gt.0) then
	            if (mnem(kkk).eq.mnem(k1)) then
	               write (tto,3598) bell,mnem(kkk)	!mnem already exists
	               goto 234
	            endif
	         endif
	      enddo
c
	      enddo
c
	   endif
c
	   first=.false.
c
        endif
c
3599	format (1x,a,' %Mnemonic truncated to : ',a)
3598	format (1x,a,' %That mnemonic already exists - ',a)
c
	goto 359				!output record
c
c	unknown format
c
358	continue
c
	write (tto,3581) bell,inpform
3581	format (1x,a,/,' ?Internal error, unknown format : ',i3)
	goto 900
c
c	error processing input file
c
357	continue
c
	if ((user1.or.usern).and.nl.gt.1) then
c
	   lim1=istrip_(inplin)
	   if (lim1.le.0) lim1=1
	   write (tto,3572) bell,inprec,inplin(1:lim1)
3572	   format (1x,a,/,
	1  ' %Error converting input file, no field found!',/,
	1  '  (input record discarded, last line ',i10,' : ',/,
	1  '   "',a,'" )')
c
	else
c
	   lim1=istrip_(inplin)
	   if (lim1.le.0) lim1=1
	   write (tto,3571) bell,inprec,inplin(1:lim1)
3571	   format (1x,a,/,
	1  ' %Error converting input line ',i10,', discarded : ',/,
	1  ' "',a,'"')
c
	endif
c
	nbad=nbad+1
c
	goto 500			!next record
c
c	too many fields
c
354	continue
c
	write (tto,3541) bell,nfmax
3541	format (1x,a,/,' ?Too many fields (max. ',i3,', parameter NFMAX!')
	goto 900
c
c	Do any changes and output record in DBAG format
c
359	continue
c
	if (nztob.gt.0) then			!zero -> blank
	   zeroe=.false.			!put blanks
	   call makbz(zerotoblnk,nztob,page,field,nf,zeroe,inplin)
	endif
c
	if (nbtoz.gt.0) then			!blank -> zero
	   zeroe=.true.				!put zeros
	   call makbz(blnktozero,nbtoz,page,field,nf,zeroe,inplin)
	endif
c
	bbb=0					!no specific base
	call f$odbf_(ochn,base,record,nf,field,mnem,page,erro)
	if (erro.ne.0) goto 980
c
	write (tto,501) record
501	format (' record ',i10,' ...')
c
	nok=nok+1
c
	goto 500			!next "record"
c
c	eof
c
550	continue
c
	close (ichn)
	close (ochn)
	close (cchn)
c
	if (save) then
	   write (tto,801) ifnam(1:istrip_(ifnam)),
	1                  ofnam(1:istrip_(ofnam)),
	1                  cfnam(1:istrip_(cfnam))
801	   format (/' File "',a,'" formated into "',a,'",',
	1           ' dialogue in "',a,'"')
	else
	   write (tto,802) ifnam(1:istrip_(ifnam)),
	1                  ofnam(1:istrip_(ofnam))
802	   format (/' File "',a,'" formated into "',a,'"')
	endif
c
	if (nok.le.0) then
	   write (tto,803) bell
803	   format (1x,a,/' %No record converted !')
	else
	   write (tto,804) nok,nbad,ntrunc
804	   format (/,
	1  '   Converted records ',i10,/,
	1  '   Rejected          ',i10,/,
	1  '   Truncated         ',i10)
	endif
c
	close (tti)
c
	goto 800		!next file to convert
c
c	DBAG error
c
980	continue
c
	call zerr2_(mssg,erro)
	lim1=istrip_(mssg)
	if (lim1.le.0) lim1=1
	write (tto,981) bell,erro,mssg(1:lim1)
981	format(1x,a,/' %DBAG error: ',i4,1x,a)
c
	goto 800
c
900	continue
c
	write (tto,'(///)')
c
	close (tti)
	close (tto)
	close (ichn)
	close (ochn)
	call freec_(ichn)
	call freec_(ochn)
	call freec_(tti)
	call freec_(tto)
c
	call exit
c
	end
c
c
c
c
	subroutine makbz(bzfield,nbz,page,field,nf,zeroe,wrktxt)
c	********************************************************
c
	implicit none
c
	integer nbz,nf,bzfield(*),field(*)
	character*(*) page(*),wrktxt
	logical zeroe
c
c	Description
c	===========
c
c	Change the contents of PAGE(FIELD(1:NBZ)) :
c	If ZEROE = .true., change blanks to zeros; otherwise, zeros to blanks.
c	Ignore any error.
c
c	var
c	===
c
	external istrip_
	integer istrip_
c
	integer f,k,kkk,idx,type,val,dec,lim,p1,p2,erro
	real rval
	character*40 mssg
	logical found,znumber,blank
c
c	begin
c	=====
c
10	continue
c
	do k = 1, nbz
c
	   znumber=.false.				!0 or 0.0
	   blank=.false.				!blanks only
c
	   f=bzfield(k)
	   found=.false.
c
	   do kkk = 1, nf
	      if (field(kkk).eq.f) then
	         idx=kkk
	         goto 50				!got it
	      endif
	   enddo
	   goto 100					!no such field, try next
50	   continue
c
	   wrktxt(1:)=' '
	   wrktxt=page(idx)				!use a copy
	   call rstok_(wrktxt,1,erro)			!reset buffer
c
	   erro=0					!only my own messages
	   call intok_(type,val,dec,rval,wrktxt,lim,p1,p2,mssg,erro)
	   if (erro.ne.0) goto 100			!error, next field
c
	   if     (type.eq.0) then
	      blank=.true.
	   elseif (type.eq.13) then			!"-"
	      erro=0					!only my own messages
	      call intok_(type,val,dec,rval,wrktxt,lim,p1,p2,mssg,erro)
	      if (erro.ne.0) goto 100			!error, next field
c
	      if     (type.eq.2) then			!integer
	         if (val.eq.0) znumber=.true.	         
	      elseif (type.eq.3) then			!decimal
	         if (rval.eq.0.0) znumber=.true.
	      elseif (type.eq.0) then			!blank line
c	         ok, proceed
	      endif
c
	   else
c
	      if    (type.eq.2) then			!integer
	         if (val.eq.0) znumber=.true.	         
	      elseif (type.eq.3) then			!decimal
	         if (rval.eq.0.0) znumber=.true.
	      endif
c
	   endif
c
100	   continue
c
	   if (znumber) then				!see if line is clean
	      erro=0					!only my own messages
	      call intok_(type,val,dec,rval,wrktxt,lim,p1,p2,mssg,erro)
	      if (erro.ne.0) then			!error, ignore
	         znumber=.false.
	      else
	         if (type.ne.0) then			!...
	            znumber=.false.
	         endif
	      endif
	   endif
c
	   if (znumber.or.blank) then
	      if (blank.and.zeroe)        page(idx)(1:1)='0'
	      if (znumber.and..not.zeroe) page(idx)(1:)=' '
	   endif
c
	enddo
c

c
c	Return
c
900	return
c
	end
c
c
c
c
	subroutine getint_(tti,tto,field,nfmax,nf,min,max,inplin)
c	*********************************************************
c
	implicit none
c
	integer tti,tto,nf,nfmax,min,max,field(nfmax)
	character*(*) inplin
c
c	Description
c	===========
c
c	Reads from channel TTI a list of NF field numbers beteewn MIN and MAX,
c	returning it in FIELD(1:NF). Input line is returned in INPLIN
c
c	var
c	===
c
	external istrip_
	integer istrip_
	integer type,val,dec,lim,p1,p2,erro
	real rval
	character*40 mssg
	character*132 tmplin
	character*1 bell
	logical minus
c
c	begin
c	=====
c
	bell=char(7)
c
50	continue
c
	   nf=0
c
	   read (tti,'(a)',end=900,err=50) inplin
	   lim=istrip_(inplin)
	   if (lim.le.0) goto 900			!return
c
	   tmplin(1:)=' '
	   tmplin=inplin				!use a copy
c
	   call rstok_(tmplin,1,erro)			!reset buffer
c
c	   get next value
c
100	   continue
c
	      minus=.false.
	      erro=0					!only my own messages
	      call intok_(type,val,dec,rval,tmplin,lim,p1,p2,mssg,
	1                 erro)
cxcx	      if (erro.ne.0) 				!ignore error
c
	      if (type.eq.13) then			!"-"
	         minus=.true.
	         erro=0					!only my own messages
	         call intok_(type,val,dec,rval,tmplin,lim,p1,p2,mssg,
	1                    erro)
	         if (erro.ne.0) goto 801
c
	         if (type.ne.2) goto 801		!not integer, error
c
	      endif
c
	      if (type.eq.0) goto 900			!eol, return
c
	      if (type.ne.2) goto 801			!not integer, error
c
	      if (minus) val=-val
c
	      if (val.lt.min.or.
	1         val.gt.max   ) goto 802		!out of bounds
c
	      nf=nf+1
	      if (nf.gt.nfmax) goto 803			!too many velues
c
	      field(nf)=val
c
c	      Get "," or eol
c
	      erro=0					!only my own messages
	      call intok_(type,val,dec,rval,tmplin,lim,p1,p2,mssg,
	1                    erro)
	      if (erro.ne.0) goto 801
c
	      if     (type.eq.0) then
	         goto 900				!eol, return
	      elseif (type.eq.8) then
	         goto 100				!',', next field
	      else
	         goto 801				!error
	      endif
c
c	Errors
c
801	continue
c
	write (tto,8010) bell
8010	format (1x,a,' %Error in list of values, try again ...')
	goto 50						!start again
c
802	continue
c
	write (tto,8020) bell,min,max
8020	format (1x,a,' %Wrong value, bounds are',i9,',',i9,
	1            ' , try again ...')
	goto 50						!start again
c
803	continue
c
	write (tto,8030) bell,nfmax
8030	format (1x,a,' %Too many values, max. is ',i4,' , try again ...')
	goto 50						!start again
c
c	Return
c
900	return
c
	end
c
c
c
c
