	subroutine dforma_(fnam1,fnam2,inlin1,inlin2,pos,size,ncol,skip,
     1                     initial,format,names,erro)
c	****************************************************************
c
	implicit none
c
	character*(*) fnam1,fnam2,inlin1,inlin2,names(*)
	integer pos(*),size(*),ncol,skip,format,erro
	logical initial
c
c	Description
c	===========
c
c	Given an input ascii file FNAM1 with NCOL columns starting at POS
c	position, size SIZE ("one line/record"), it is converted into an
c	output file FNAM2, re-organized in one line/field.
c
c	In FNAM1/2 the complete file spec's are returned to caller.
c
c	INLIN1/2 are supposed big enough to hold any input line.
c
c	SKIP = # of initial input lines to skip (eg. header).
c	The skip+1 nth. line holds the mnemonics of each
c	field, followed by an empty line, if INITIAL = .true.
c
c	The output file format depends on FORMAT:
c
c	Format = 1 :
c
c		if FNAM1 .ne. FNAM2, a single file copy will be performed
c		(no-op if same file name).
c
c	Format = 2 :
c
c		each item of output file will be preceeded by 1 blank line;
c		the mnemonics will be truncated to a fixed size of 10 and
c		":" will separate mnemonics from data.
c
c	Format = 3 :
c
c		as format = 2, but without mnemonics.
c
c	Format = 4 :
c
c		as format = 2, but without blank lines.
c
c	Format = 5 :
c
c		only the data portion of each field will be displayed, no
c		blank lines and no mnemonics.
c
c	ERRO .ne. 0 means some i/o error (1-NEWC,2-open,3-read,4-write failure)
c		    or INLINE too short (5).
c
c	var
c	===
c
	external istrip_
	integer istrip_
	integer ch1,ch2,long1,long2,k,m,l,inlen,siz,lim,nbef,naft
	integer p1,p2
	character*10 mnem
c
c	begin
c	=====
c
	erro=0
	ch1=0
	ch2=0
c
	l=pos(ncol)+size(ncol)-1		!...
c
	inlen=len(inlin1)			!line lenght
	if (l.gt.inlen) goto 90005		!doesn't fit
c
	inlen=len(inlin2)			!line lenght
	if (l.gt.inlen) goto 90005		!doesn't fit
c
	call newc_(ch1)				!input channel
	call newc_(ch2)				!output channel
	if (ch1.le.0) goto 90001
	open (unit=ch1,file=fnam1,status='old',err=90002)
c
c	Format 1
c	--------
c
	if (format.eq.1) then			!*** format 1
	   if (fnam1.ne.fnam2)  then
c
	      long2=long1			!same lenght
	      open (unit=ch2,file=fnam2,status='new',recl=long2,
     1              carriagecontrol='list',err=90002)
100	      continue
c
	         read(ch1,'(a)',end=110,err=90003) inlin1(1:long1)
	         lim=istrip_(inlin1)
	         if (lim.le.0) lim=1
	         write(ch2,'(a)',err=90004) inlin1(1:lim)
c
110	      continue
	   endif
	   goto 900					!all done
	endif
c
c	read first skip lines + mnemonics line + blank line
c
	do 1001 k = 1, skip				!skip header if any
	   read (ch1,'(a)',err=90003,end=90003) inlin1(1:1)
1001	continue
c
	if (initial) then
	   read (ch1,'(a,/)',err=90003,end=90003) inlin1!mnemonics + blank line
	endif
c
	long2=0
c
	do 1002 k = 1, ncol
	   siz=size(k)
	   if (siz.gt.long2) long2=siz	!data lenght
1002	continue
c
	long2=long2+10+1		!output record lenght (mnemonic:)
	open (unit=ch2,file=fnam2,status='new',recl=long2,
     1        carriagecontrol='list',err=90002)
c
c	blank lines before/after
c
	if     (format.eq.2) then			!format 2
	   nbef=1
	   naft=0
	elseif (format.eq.3) then			!format 3
	   nbef=1
	   naft=0
	elseif (format.eq.4) then			!format 4
	   nbef=0
	   naft=0
	elseif (format.eq.5) then			!format 5
	   nbef=0
	   naft=0
	endif
c
c	Loop on input file
c	------------------
c
200	continue
c
	   read (ch1,'(a)',err=90003,end=290) inlin2
c
	   do 1003 l = 1, nbef
	      write (ch2,'(1x)',err=90004)		!blank lines before
1003	   continue
c
	   do 1004 k = 1, ncol
	      p1=pos(k)
	      p2=p1+size(k)-1
	      lim=istrip_(inlin2(p1:p2))		!no multiple blanks
	      if (lim.le.0) then
	         p2=p1
	      else
	         p2=p1+lim-1
	      endif
	      mnem(1:)=' '
	      mnem=names(k)
c
	      if     (format.eq.2) then			!format 2
c
	         write (ch2,'(a,'':'',a)',err=90004)   mnem,
     1                                                 inlin2(p1:p2)
c
	      elseif (format.eq.3) then			!format 3
c
	         write (ch2,'(a)',err=90004)           inlin2(p1:p2)
c
	      elseif (format.eq.4) then			!format 4
c
	         write (ch2,'(a,'':'',a)',err=90004)   mnem,
     1                                                 inlin2(p1:p2)
c
	      elseif (format.eq.5) then			!format 5
c
	         write (ch2,'(a)',err=90004)           inlin2(p1:p2)
	      endif
1004	   continue
c
	   do 1005 l = 1, naft
	      write (ch2,'(1x)',err=90004)		!blank lines after
1005	   continue
c
	   goto 200					!loop back for more
c
290	continue
c
	goto 900
c
c	Errors
c	------
c
c	no i/o channel
90001	continue
	erro=1
	goto 900
c
c	open failure
90002	continue
	erro=2
	goto 900
c
c	read failure
90003	continue
	erro=3
	goto 900
c
c	write failure
90004	continue
	erro=4
	goto 900
c
c	line doesn't fit
90005	continue
	erro=5
	goto 900
c
c	return properly
c	---------------
c
900	continue
c
	if (ch1.gt.0) then
	   inquire (unit=ch1,name=fnam1)
	   close (unit=ch1)
	   call freec_(ch1)
	endif
c
	if (ch2.gt.0) then
	   inquire (unit=ch2,name=fnam2)
	   close (unit=ch2)
	   call freec_(ch2)
	endif
c
c	Formats
c	=======
c
	end
c
c
c
c
