	subroutine forchk_(base,all,whowho,whats,allsiz,erro)
c	*****************************************************
c
c	Written by Luis Arriaga da Cunha 1985
c
	implicit none
c
	integer base,all,whowho(all),whats(all),allsiz,erro
c
c	Description
c	===========
c
c	This  procedure  should  be  fed  proper  FOR  expressions already
c	resolved  into  the   semantic  arrays.  It  begins  by   checking
c	for   the   validity   of  left   and  right  hand  side  possible
c	data  base references if "." notation was used. It then checks the
c	the  validity  of  fields  given  by  number ,  the  existence  of
c	mnemonics,   and   the  accordance  of  the  types field/arguments.
c	Any  field  that  is  not  alright goes into WHOWHO with  the  dia-
c	gnostic in WHATS. These latter  will be  used  up  to ALLSIZ.  For
c	the moment the values of WHATS are:
c
c		0	ok
c		1	invalid field number
c		2	non-existent mnemonic
c		3	type conflict
c		4	invalid base reference in dot notation lhs
c		5	invalid base reference in dot notation rhs
c		6-8	see JFRCHK_
c		9	ovni
c
c	ERRO <> 0 will, in general, tell that  something  is  not well.
c
c	If  EVERYTHING IS OK it  TRANSFORMS the semantic arrays into a
c	"numerical"  form  for  performance  purposes , to  be used by
c	FORSEM procedure.
c
c	The changes are as follows:
c
c	In hug$ :
c
c	.not.		-4
c	.and.		-3
c	.or.		-2
c	true		-1
c	false		 0
c	#field		 # (direct...)
c	arity		 arity (direct...)
c
c	Coming in, in huge2$ (reminder) :
c
c	normal, standard types :
c
c	1 integer,2 string,3 other db,4 decimal,5 date,6 logical,7 real,
c
c	extended types :
c
c	8  not  in  use,  9  bitmap,  10  field  in  "other"   db,
c	11 bitmap with check digit, 12 date  with  some wild card,
c	13 ovni (non identified identifier)
c
c	with that in mind :
c
c	 1,3,4,5,6,7	become  1 (number-like)
c	 2		becomes 2 (text-like)
c	 8		becomes 1 (number-like)
c	 9		becomes 4 (bitmap number-like)
c	10		becomes 5 (field in other D.B.)
c	11		becomes 6 (bitmap number-like with check digit)
c	12		becomes 3 (number-like date with wild card)
c	13		becomes 5 or
c			        7 if EMPTY keyword
c
c	In huge1$ :
c	(see variable cnv for what follows )
c
c	=		 1
c	<>		 2
c	<		 3
c	>		 4
c	>=		 5
c	<=		 6
c	between		 7
c	not_between	 8
c	string_in	 9
c	= KWIC field 	11
c
c
c	If field is decimal in hnum$ we have pairs value//#of decimal places.
c
c	The  semantic  arrays  are  handed via common STACK.OWN block (buuu).
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:stack.own'
c
	external lstrip_
	integer lstrip_
c
	integer cnv(0:25)/0,
     1                    0,0,0,0,0,0,0,0,1,0,
     1                    0,0,0,0,3,4,2,7,10,8,
     1                    0,6,5,0,9/
	integer o,l,k,m,l1,l2,l3,lm,ls,std,kind,numb,max,form,val,interr
	character*30 myname,tmp*20
	integer kwic
c
c	begin
c	=====
c
	call errclr_('FORCHK')		!error init
	erro=0				!clear error
	interr=0
c
	allsiz=all
c
c	number of fields
c
	call znfld_(base,ls,erro)
	if (erro.ne.0) goto 95000
	if (ls.eq.0) goto 100		!break!, nothing to do here
c
c	get base's name
c
	call zname_(base,myname,erro)
	if (erro.ne.0) goto 95000
	lm=lstrip_(myname)
	call uc8to7_(myname(1:lm))
c
c	where is first logical operator ?
c
	if (chuge$.eq.0) goto 100	!break!, nothing to do here
	mhug$=1
	do 1001 k=chuge$,1,-1
	   if (huge$(k)(1:1).eq.'.') mhug$=k
1001	continue
c
c	go thru the semantic array to identify fields
c
	if (chuge$.gt.allsiz) goto 90002
	allsiz=chuge$
	do 1004 k=1,chuge$
c
	   whowho(k)=0
	   whats (k)=0
	   hug$(k)=0
c
c	   data base validity, if any, for fields
c	   ======================================
c
	   if (huge$(k)(1:1).eq.'%'.or.
     1         huge$(k)(1:1).eq.' ') then	!field (by number or mnemonic)
c
	      if (hubl$(k)(1:1).ne.' ') then
	         l1=lstrip_(hubl$(k))
	         call uc8to7_(hubl$(k)(1:l1))
	         if (hubl$(k)(1:l1).ne.myname(1:lm)) then
	            interr=1
	            whowho(k)=k
	            whats(k)=4			!invalid base name lhs
	            goto 80			!don't carry on
	         endif
	      endif
	      if (hubr$(k)(1:1).ne.' ') then
	         l2=lstrip_(hubr$(k))
	         call uc8to7_(hubr$(k)(1:l2))
	         if (hubr$(k)(1:l2).ne.myname(1:lm)) then
	            interr=1
	            whowho(k)=k
	            whats(k)=5			!invalid base name rhs
	            goto 80			!don't carry on
	         endif
	      endif
c
	   endif
c
c	   field validity
c	   ==============
c
	   if (huge$(k)(1:1).eq.'%') then	!field by number
						!---------------
	      huge1$(k)=cnv(huge1$(k))		!convert relational operator
	      read(huge$(k)(2:),'(i4.4)')numb
	      call zidx_(base,numb,kwic,erro)
	      if (erro.ne.0) goto 95000
	      if (huge1$(k).eq.1.and.kwic.eq.4) then
	         huge1$(k)=11			!= KWIC field
	      endif
	      if (numb.lt.0.or.numb.gt.ls) then
	         interr=1
	         whowho(k)=numb
	         whats(k)=1			!invalid field number
	         goto 80			!don't carry on
	      else
	         hug$(k)=numb			!numerical form
	      endif
c
	   elseif (huge$(k)(1:1).eq.' ') then	!by mnemonic
c						!-----------
	      huge1$(k)=cnv(huge1$(k))		!convert relational operator
	      call znum_(base,numb,huge$(k)(2:),erro)
	      if (erro.ne.0) goto 95000
	      if (numb.eq.-1) then
	         interr=1
	         whowho(k)=k
	         whats(k)=2			!non existent mnemonic
	      else
	         write(huge$(k)(1:),'(''%'',i4.4)')numb
	         hug$(k)=numb			!numerical form
cmota
	         call zidx_(base,numb,kwic,erro)
	         if (erro.ne.0) goto 95000
	         if (huge1$(k).eq.1.and.kwic.eq.4) then
	            huge1$(k)=11		!= KWIC field
	         endif
cmota
	      endif
cmota	      call zidx_(base,numb,kwic,erro)
cmota	      if (erro.ne.0) goto 95000
cmota	      if (huge1$(k).eq.1.and.kwic.eq.4) then
cmota	         huge1$(k)=11			!= KWIC field
cmota	      endif
	   elseif (huge$(k)(1:5).eq.'.not.') then	!logical .not.
	      hug$(k)=-4
	   elseif (huge$(k)(1:5).eq.'.and.') then	!logical .and.
	      hug$(k)=-3
	   elseif (huge$(k)(1:5).eq.'.or.' ) then	!logical .or.
	      hug$(k)=-2
	   elseif (huge$(k)(1:1).eq.'*')     then	!arity
	      read(huge$(k)(2:),'(i4.4)')numb
	      hug$(k)=numb
	   endif
c
c	   check type accordance between fields<->arguments
c	   ================================================
c
	   if (huge$(k)(1:1).eq.'%') then
	      call zkind_(base,numb,kind,erro)
	      if (erro.ne.0) goto 95000
	      if (huge2$(k).eq.9.or.
     1           huge2$(k).eq.11) then		!***bitmap "list"
	         if (kind.eq.db$.or.
     1              kind.eq.n$)   then		!has to be D.B. or integer
	            if (huge2$(k).eq.9) then
	               huge2$(k)=4
	            else
	               huge2$(k)=6		!with check digit
	            endif
	         else
	            interr=1
	            whowho(k)=numb
	            whats(k)=3			!type conflict
	         endif
	      elseif (huge2$(k).eq.13) then	!***identifier
	         tmp(1:)=htxt$(hnum$(huge3$(k)):hnum$(huge4$(k)))
	         call uc8to7_(tmp)
	         if (tmp(1:7).ne.' EMPTY ') then
	            interr=1
	            whowho(k)=numb
	            whats(k)=9			!true ovni
	         else
	            huge2$(k)=7			!transform...
	         endif
	      elseif (huge2$(k).eq.10) then	!***same DB field reference ?!
	         huge2$(k)=5			!transform...
	      elseif (huge2$(k).eq.12) then	!***date wild card
	         if (kind.eq.d$) then		!has to be date
	            huge2$(k)=3			!transform...
	         else
	            interr=1
	            whowho(k)=numb
	            whats(k)=3			!type conflict
	         endif
	      else				!***"normal" standard types
	         if (kind.eq.db$) kind=1	!D.B. becomes number-like
c
	         if (kind.eq.d$.and.huge2$(k).eq.n$) then
	            huge2$(k)=d$		!last chance...
	            l1=huge3$(k)
	            l2=huge4$(k)
	            do 1002 l=l1,l2
	               write(tmp,'(i10)')hnum$(l)
	               call numdat_(val,tmp,o,form,erro)
	               if (erro.ne.0) then
	                  huge2$(k)=n$
	                  goto 66		!break loop straight away
	               else
	                  hnum$(l)=val
	               endif
1002	            continue
c
66	            continue
	         endif
c
	         if (huge2$(k).ne.kind) then
	            interr=1
	            whowho(k)=numb
	            whats(k)=3			!type conflict
	         else
	            if (kind.eq.c$) then
	               huge2$(k)=2		!text-like
	            elseif (kind.eq.d$) then
	               huge2$(k)=1		!date becomes number-like
	            elseif (kind.eq.x$) then
	               call zdeci_(base,numb,std,erro)
	               if (erro.ne.0) goto 95000
	               l1=huge3$(k)
	               l2=huge4$(k)		!normalize
	               l3=l1
	               do 1003 l=l1,l2,2
	                  call stddec_(hnum$(l),hnum$(l+1),std)
	                  hnum$(l3)=hnum$(l)
	                  l3=l3+1
1003	               continue
	               huge4$(k)=l3-1		!compact
	               huge2$(k)=1		!number-like decimal
	            else
	               huge2$(K)=1		!number-like
	            endif
	         endif
	      endif
	   endif
c
c	   sort number-like values
c	   =======================
c
	   if (huge$(k)(1:1).eq.'%') then
	      if (huge2$(k).eq.2.or.		!avoid text-like
     1            huge2$(k).eq.4.or.		!avoid bitmap's
     1            huge2$(k).eq.6.or.
     1            huge2$(k).eq.5)    then
c	         do not sort !!!
	      else
	         call nsort0_(huge3$(k),huge4$(k),hnum$)
	      endif
	   endif
c
c
80	continue
1004	continue
c
100	continue
c
	if (interr.ne.0) then
	   erro=interr
	   goto 99000		!set error and return
	endif
c
	return
c
c	errors
c	======
c
c	erro=1 if	invalid field number 			   (1)
c	======		non-existent mnemonic			   (2)
c		  	type conflict        			   (3)
c			invalid base reference in dot notation lhs (4)
c			invalid base reference in dot notation rhs (5)
c
c	not enough room in working arrays
90002	continue
	erro=2
	goto 99000				!set error and return
c
99000	continue
	call errset_('FORCHK',erro)
	return
c
c	inherited errors
95000	continue
	return
c
c
	end
c
c
c
c
	logical function separ(txt)
c	***************************
c
	implicit none
c
	character*(*) txt
c
c	var
c	===
c
	include 'own:word4.own'
c
	integer j,l
c
c	begin
c	=====
c
	call strip(txt,l)
	do j=1,word9_
	   if (txt(1:l).eq.word1_(j)) then
	      separ=.true.
	      return
	   endif
	enddo
c
	separ=.false.
	return
c
c
	end
c
c
c
c
