	subroutine forsem_(base,alive,bmap,bsiz,tpage,ipage,erro)
c	*********************************************************
c
c	Written by Luis Arriaga da Cunha 1985, 1986
c
	implicit none
c
	integer base,alive,bmap(*),bsiz,ipage(0:*),erro
	character*(*) tpage(0:*)
c
c
c	Description
c	===========
c
c	This procedure should  be fed  proper FOR expressions already
c	resolved  into  the  semantic arrays and "calculates" it. The
c	records  it  will  consider, to start with, are given in BMAP,
c	a  bit  map  representation  of  size  BSIZ.  The  arrays are
c	passed  via common STACK.OWN block.IPAGE must be supplied  by
c	the  caller  to  hold the field values of each record visited.
c	The same for  TPAGE  where the field values are "integerized".
c	The  format for the FOR expressions is a unique post-fix list
c	notation (!?). Each operator (.and.,.or,...) is written after
c	the  arguments. These  are  a list whose arity is right after
c	the operator (got it ?):
c
c	...arg1,arg2,arg3,...,argn,operator,arity...
c
c	Reminder...
c
c	Logical operators and other things in array HUG$ are :
c
c	.not.		-4
c	.and.		-3
c	.or.		-2
c	true		-1
c	false		 0
c	#field		 # (direct...)
c	arity		 value of arity (direct...)
c
c	Relational operators in array HUGE1$ are :
c
c	=		 1
c	<>		 2
c	<		 3
c	>		 4
c	>=		 5
c	<=		 6
c	between		 7
c	not_between	 8
c	string_in	 9
c	= KWIC field	11
c
c	The  semantic  arrays  are  handed via common STACK.OWN block.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:stack.own'
c
	real rpage(1)			!to become argument when REAL type
c
	integer  lstrip_,istrip_
	external lstrip_,istrip_
c
c	integer newbit(whatever)	!if no dynamic core available
	integer newbit			!VAX, dynamic core
c
	integer rec,irec,start,many,here,top,noerr
	integer oper,roper,loads,hugk
	integer kind,field
	integer z0,z1,iz0,iz1
	integer interr,ierr
	logical result,eobm,eox,idxyes,tryit,bit,user
	integer j,l,m,k,n,k0,kkk,seq,ixx,l1,l2,p1,p2,off,jump
	integer xval,tmpxval,arity,b2,mast,dbcode
	character*100 val
	logical sensitive
c
c*****
c	real 	watch,delta(20)
c	integer ph1,ph2,ph3,ph4,ph5,phase
c	character*30 now,talk(20)
c	data talk(1),talk(2),talk(3),talk(4),talk(5)/
c	1				   'record from bitmap',
c	1				   'read record from disk',
c	1				   'get relevant fields',
c	1     				   'evaluate single expression',
c	1  				   'evaluate complex expression'/
c*****
c
c	begin
c	=====
c
	call errclr_('FORSEM')		!error init
	erro=0				!clear error
c
	sensitive=s$set(s$case)		!case sensitive in searches
	if (.not.sensitive) then
	   l=istrip_(htxt$)
	   if (l.gt.0) then
	      call uc8to7_(htxt$(1:l))	!once and for all
	   endif
	endif
c
c	anything to do at all ?
c	-----------------------
c
	if (chuge$.eq.0) goto 900	!break!, nothing to do...
c
c
c	1) go thru selected records and set bitmap via indexed fields
c	-------------------------------------------------------------
c
c	go thru stack to find: top level .and. -> "=" -> indexed fields
c
	idxyes=.false.
c
	k=chuge$-1			!just a try for top level...
	if (chuge$.eq.1) then		!stack has one position,implicit .and.
	   k=1
	   start=1
	   m=1
	   tryit=.true.
	elseif (hug$(k).eq.-3) then	! .and. operator found !!!
	   many=hug$(k+1)
	   start=1
	   m=k-1
	   tryit=.true.
	else
	   tryit=.false.		!sorry, no chance...
	endif
c
	if (tryit) then
	   arity=chuge$			!arity position in stack
c
c	   loop in stack
c	   -------------
c
	   here=m
100	   continue
	   if (here.lt.start) goto 101	!break loop
c
	      loads=hug$(here)		!perhaps arity or
	      roper=huge1$(here)	!perhaps relational operator
	      if (roper.eq.0) then
	         here=here-loads-2	!after all it was arity, jump in array
	         goto 100		!and re-try
	      endif
c
	      field=hug$(here)		! field number
c
c	      If O.d.b. field but not indexed itself, forget indexes !!!
c
	      b2=d$dbio(field,base)
	      mast=d$mast(field,base)
	      if ((b2.gt.0.and.
	1          mast.gt.0  ).and.		!O.d.b. field
	1          d$idx(field,base).le.0) then	!but not indexed itself
	         ixx=0				!forget it
	      else
	         call zidx_(base,field,ixx,erro)
	         if (erro.ne.0) goto 95000
	      endif
c
	      if (roper.eq.1.or.	 ! "=" or
	1         roper.eq.11) then	 ! "=" with KWIC field
c
	         if (ixx.ne.0) then	! and field is indexed !!!
c
c	         here with "top level .and.", "=" and "indexed_field" !!!
c	         --------------------------------------------------------
c
	         if (.not.idxyes) then !first time,
	            idxyes=.true.	  !make room for extra bitmap
	            call get_vm_(bsiz*4,newbit,erro)	!size in bytes!!!
	            if (erro.ne.0) goto 90002		!no memory!
ccccc	            call zstart_(base,z0,erro)
ccccc	            if (erro.ne.0) goto 95000
ccccc	            call ex3in_(base,z0,iz0,erro)
ccccc	            if (erro.ne.0) goto 95000
	            z0=d$unus-d$offs(base)+1		!first record
	            iz0=z0
	            call zend_(base,z1,erro)
	            if (erro.ne.0) goto 95000
	            call ex3in_(base,z1,iz1,erro)
	            if (erro.ne.0) goto 95000
	            call bitini_(%val(newbit),bsiz,iz0,iz1,erro)
	            if (erro.ne.0) goto 95000
	         endif
c
	         kind=huge2$(here)
	         if (kind.eq.7) goto 101	!empty, give up...
	         call opnx_(base,field,erro)
	         if (erro.ne.0) goto 95000
	         if (kind.eq.2) then		!text like
	            l1=huge3$(here)
	            l2=huge4$(here)-1
	            jump=2
	         else				!number like
	            l1=huge3$(here)
	            l2=huge4$(here)
	            jump=1
	         endif
c
c	         loop in argument list
c	         .....................
c
	         if (kind.eq.4.or.kind.eq.6) then
	            bit=.true.
	            xval=0
	         else
	            bit=.false.
	            seq=l1-jump
	         endif
c
401	         continue
	         if (bit) then
	            call bitnxt_(hnum$(l1),xval,eobm,erro)
	            if (erro.ne.0) goto 95000
	            if (eobm) goto 402
	         else
	            seq=seq+jump
	            if (seq.gt.l2) goto 402
	         endif
c
c
	         if (kind.eq.2) then			!text like
	            p1=hnum$(seq)
	            p2=hnum$(seq+1)
	            val(1:)=htxt$(p1:p2)
	            xval=0
	         elseif (kind.eq.4.or.kind.eq.6) then	!bitmap
	            val(1:)=' '
	            if (kind.eq.6) then
	               tmpxval=xval
	               call ex3in_(base,tmpxval,xval,erro)
	            endif
	         else					!number like
	            val(1:)=' '
	            xval=hnum$(seq)
	         endif
c
c	         loop in records with this field_value
c
	         if (ixx.eq.4) then	!$ and KWIC index
	            kkk=lstrip_(val)
	         else
	            call zsize_(base,field,kkk,erro)
	            if (erro.ne.0) goto 95000
	         endif
	         call findx_(base,field,xval,val(1:kkk),rec,eox,erro)
	         if (erro.ne.0) goto 95000
	         if (eox) goto 111
	         call ex3in_(base,rec,irec,erro)
	         if (erro.ne.0) goto 95000
	         call bitput_ (%val(newbit),irec,erro)
	         if (erro.ne.0) goto 95000
c
110	         continue
	            call thrux_(base,field,xval,val(1:kkk),rec,eox,erro)
	            if (erro.ne.0) goto 95000
	            if (eox) goto 111
	            call ex3in_(base,rec,irec,erro)
	            if (erro.ne.0) goto 95000
	            call bitput_ (%val(newbit),irec,erro)
	            if (erro.ne.0) goto 95000
	         goto 110
111	         continue
c
c	         end of loop in records
c
	         goto 401
402	         continue
c
c	         .....................
c	         end of loop in argument list
c
c
c	         restrict to selected records
c
	         call bitand_ (bmap,%val(newbit),erro)
	         if (erro.ne.0) goto 95000
	         call bitclr_ (%val(newbit),erro)
	         if (erro.ne.0) goto 95000
c
	         call clsx_(base,field,erro)
	         if (erro.ne.0) then
	            call errclr_('FORSEM')	!ignore error
	            erro=0
	         endif
c
c	         re-arrange array
c
	         n=hug$(arity)-1		!new value for arity
	         hug$(arity)=n			!correct arity
	         chuge$=chuge$-1		!correct stack size
c
	         if (chuge$.le.2) then		!exausted this stack !
	            chuge$=0
	         elseif (hug$(arity).eq.0) then !exausted this expression !
	            chuge$=0
	         else
	            off=1
	            do 1002 n=here,chuge$
	               hug$(n)=hug$(n+off)
	               huge1$(n)=huge1$(n+off)
	               huge2$(n)=huge2$(n+off)
	               huge3$(n)=huge3$(n+off)
	               huge4$(n)=huge4$(n+off)
1002	            continue
	            arity=arity-off
	            hug$(chuge$+off)=0
	            huge1$(chuge$+off)=0
	            if (mhug$.ge.here) mhug$=mhug$-off
	         endif
c
	         endif	!of field is indexed
c
	      endif	!of roper.eq.1
c
	      here=here-1
	      goto 100
101	      continue
c
c	      end of loop in stack
c	      --------------------
c
	endif	!of tryit
c
c	tidy up...
c
	if (idxyes) then
c
	   call free_vm_(bsiz*4,newbit,noerr)
c
	endif
c
c	1) end
c	------
c
c	2) go thru selected records and try to use hash signatures
c	----------------------------------------------------------
c
	if (d$hash(base).eq.1) then
200	continue
	  goto 200
299	continue
	endif
c
c	3) go thru selected records and apply sequencially the FOR expression

c	---------------------------------------------------------------------
c
300	continue
c
c	see if nothing else to do
c
	if (chuge$.eq.0) then
	   call forall_(base,alive,bmap,erro)
	   if (erro.ne.0) goto 95000
	   goto 399			!quit now
	endif
c
c	loop in selected records
c
	rec=0				!reset bit map
	irec=0
c*****
c	do k=1,5
c	   delta(k)=0.0
c	enddo
c	ph1=1	!get record # from bitmap
c	ph2=1	!read record from base
c	ph3=1	!get field to use in expression
c	ph4=1	!evaluate single expression
c	ph5=1	!evaluate complex expression
c*****
301	continue
c*****
c	watch=secnds(0.0)
c*****
	call bitnxt_(bmap,irec,eobm,erro)
	if (erro.ne.0) goto 95000
	if (eobm) goto 399		!the end
	call in3ex_(base,irec,rec,erro)
	if (erro.ne.0) goto 95000
c*****
c	watch=secnds(watch)
c	delta(1)=delta(1)+watch
c	ph1=ph1+1
c	watch=0.0
c*****
c
c	get record
c
c*****
c	watch=secnds(0.0)
c*****
	call find_ (base, rec, alive, d$xbuf, erro)
	if (erro.ne.0) then
	   if (d$rsub.eq.'FIND'.and.
	1      d$erro.eq.5) then
	      call bitzer_ (bmap,irec,erro)	!killed record, ignore
	      if (erro.ne.0) goto 95000
	      goto 301
	   else
	      goto 95000
	   endif
	endif
	ipage(0)=rec			!field zero is record #
	tpage(0)(1:)='#'
c
	if (erro.ne.0) goto 95000
c*****
c	watch=secnds(watch)
c	delta(2)=delta(2)+watch
c	ph2=ph2+1
c	watch=0.0
c*****
c
c
c
	if (chuge$.eq.1) then		!single condition
c					!****************
	   m=hug$(1)			!which field
	   if (m.gt.0) then
c*****
c	watch=secnds(0.0)
c*****
	      call cunflt_(base,tpage(m),ipage(m),m,d$xbuf,erro)
	      if (erro.ne.0) goto 95000
	      b2=d$dbio(m,base)
	      mast=d$mast(m,base)
	      if (b2.gt.0.and.
	1         mast.gt.0) then	!O.d.b. field
	         read (tpage(m),'(i10)',err=202) dbcode
	         user=.false.		!internal format
	         call dbtxt_(b2,tpage(m),ipage(m),dbcode,mast,user,erro)
	         goto 203
202	         continue
	         erro=1					!fake error
203	         continue
	         if (erro.ne.0) then
	            call bitzer_ (bmap,irec,erro)	!error, ignore record
	            if (erro.ne.0) goto 95000
	            goto 301
	         endif
	      endif
c*****
c	watch=secnds(watch)
c	delta(3)=delta(3)+watch
c	ph3=ph3+1
c	watch=0.0
c*****
	   endif
c*****
c	watch=secnds(0.0)
c*****
	   call eval_(huge1$(1),ipage(m),tpage(m),1,result,erro)
c*****
c	watch=secnds(watch)
c	delta(4)=delta(4)+watch
c	ph4=ph4+1
c	watch=0.0
c*****
	   if (erro.ne.0) goto 90001
c
	else				!expression proper
c					!*****************
	   k=1
13	   continue			!make scratch copy of stack
	   if (hug$(k).le.0) then
	      hugtmp(k)=hug$(k)		!operator or true/false
	      if (hug$(k).le.-2) then	!operator
	         k=k+1
	         hugtmp(k)=hug$(k)	!arity
	      endif
	   else
	      hugtmp(k)=k		!position
	   endif
	   k=k+1
	   if (k.gt.chuge$) goto 14
	   goto 13
14	   continue
c
	   l=1
	   k0=mhug$
	   do 1005 k=k0,chuge$
	      if (hugtmp(k).lt.-1) then
c
c	         here operator found !!!
c
	         oper=hugtmp(k)
	         top=k-1
	         many=hugtmp(k+1)
	         start=k-many
c*****
c	watch=secnds(0.0)
c*****
	         do 1003 n=start,top
	            hugk=hugtmp(n)
	            if (hugk.gt.0) then		!field
	               m=hug$(hugk)		!which field
	               if (m.gt.0) then
	                  call cunflt_(base,tpage(m),ipage(m),m,
     1                    d$xbuf,erro)
	                  if (erro.ne.0) goto 95000
	                  b2=d$dbio(m,base)
	                  mast=d$mast(m,base)
	                  if (b2.gt.0.and.
	1                    mast.gt.0) then	!O.d.b. field
	                     read (tpage(m),'(i10)',err=303) dbcode
	                     user=.false.	!internal format
	                     call dbtxt_(b2,tpage(m),ipage(m),dbcode,
	1                                mast,user,erro)
	                     goto 304
303	                     continue
	                     erro=1		!fake error
304	                     continue
	                     if (erro.ne.0) then
	                        call bitzer_ (bmap,irec,erro)!error, ignore rec.
	                        if (erro.ne.0) goto 95000
	                        goto 301
	                     endif
	                  endif
	               endif
	            endif
1003	         continue
c*****
c	watch=secnds(watch)
c	delta(3)=delta(3)+watch
c	ph3=ph3+1
c	watch=0.0
c*****
c*****
c	watch=secnds(0.0)
c*****
	         call applic_(oper,ipage,tpage,start,top,result,erro)
c*****
c	watch=secnds(watch)
c	delta(5)=delta(5)+watch
c	ph5=ph5+1
c	watch=0.0
c*****
	         if (erro.ne.0) goto 90001
	         n=k+1
	         hugtmp(n)=result
	         do 1004 j=start-1,l,-1
	            n=n-1
	            hugtmp(n)=hugtmp(j)
1004	         continue
	         l=n
	      endif
1005	   continue
c
	endif
c
	if (result) then
c	   nothing to do here
	else
	   call ex3in_(base,rec,irec,erro)
	   if (erro.ne.0) goto 95000
	   call bitzer_ (bmap,irec,erro)
	   if (erro.ne.0) goto 95000
	endif
c
	goto 301
399	continue
c
c	3) end
c	------
c
900	continue
c*****
c	call newc_(phase)
c	open(unit=phase,file='forsem.sta',status='unknown',
c	1    access='append',err=98765)
c	if (ph1.gt.1) delta(1)=delta(1)/ph1
c	if (ph2.gt.1) delta(2)=delta(2)/ph2
c	if (ph3.gt.1) delta(3)=delta(3)/ph3
c	if (ph4.gt.1) delta(4)=delta(4)/ph4
c	if (ph5.gt.1) delta(5)=delta(5)/ph5
c	call time(now)
c	write(phase,'(a)')now
c	do k=1,5
c	   write(phase,'(1x,a,f12.3)')talk(k),delta(k)*1000
c	enddo
c	call freec_(phase)
c98765	continue
c*****
	return
c
c	errors
c	======
c
c	error evaluating damned semantic array
90001	continue
	erro=1
	goto 99000			!set error and return properly
c
c	memory (get_vm_) failure
90002	continue
	erro=2
	goto 99000			!set error and return properly
c
99000	continue
c
	call errset_('FORSEM',erro)	!set error
	return				!return
c
c	inherited errors, just carry on
95000	continue
c
	return
c
c
	end
c
c
c
c
	subroutine applic_(oper,val,valtxt,
     1                     start,finish,result,erro)
c	********************************************
c
c	Written by Luis Arriaga da Cunha, 1985
c
	implicit none
c
	integer oper,val(0:*)
	character*(*) valtxt(0:*)
	integer finish,start,erro
	logical result
c
c	Description
c	===========
c
c	Applies the logical OPERator to its  arguments  given
c	in the 	semantic  stack  HUGTMP, from   START  up  to
c	FINISH. The  result  is  given  back in   RESULT. The
c	semantic arrays are passed via common, STACK.OWN. The
c	values 	to  apply  are  in  VALTXT or VAL(for text or
c	number-like field values).
c
c	Reminder...
c
c	Logical operators and other things in array HUG$ are :
c
c	.not.		-4
c	.and.		-3
c	.or.		-2
c	true		-1
c	false		 0
c	#field		 # (direct...)
c	arity		 value of arity (direct...)
c
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:stack.own'
c
	integer roper,typ,hugk,k,m,fld
c
c	begin
c	=====
c
	goto (400,300,200,100,100) oper+5
c
c	true, false (-1, 0) or rubbish, just in case...
100	continue
	return
c
c	.not. (-4)
400	continue				!unary operator
	hugk=hugtmp(start)
	if (hugk.eq.0.or.hugk.eq.-1) then	!already false or true
	   result=hugk
	else
	   fld=hug$(hugk)			!which field
	   roper=huge1$(hugk)
	   typ=huge2$(hugk)
	   if (typ.eq.1.or.typ.eq.3) then
c	      val=valtxt
	   endif
	   call eval_(roper,val(fld),valtxt(fld),hugk,result,erro)
	endif
	result=.not.result
	goto 900
c
c	.and. (-3)
300	continue
	do 1001 k=start,finish
	   hugk=hugtmp(k)
	   if     (hugk.eq.0) then	!false
	      result=.false.
	      goto 900			!failure, break now !!!
	   elseif (hugk.eq.-1)then 	!true
c	      do nothing
	   else
	      fld=hug$(hugk)		!which field
	      roper=huge1$(hugk)
	      typ=huge2$(hugk)
	      if (typ.eq.1.or.typ.eq.3) then
c	         val=valtxt
	      endif
	      call eval_(roper,val(fld),valtxt(fld),hugk,result,erro)
	      if (.not.result) then	!false
	         goto 900		!failure, break now !!!
	      endif
	   endif
1001	continue
	goto 900
c
c	.or.  (-2)
200	continue
	result=.false.
	do 1002 k=start,finish
	   hugk=hugtmp(k)
	   if     (hugk.eq.0) then	!false
c	      do nothing
	   elseif (hugk.eq.-1)then 	!true
	      result=.true.
	      goto 900			!success, break now !!!
	   else
	      fld=hug$(hugk)		!which field
	      roper=huge1$(hugk)
	      typ=huge2$(hugk)
	      if (typ.eq.1.or.typ.eq.3) then
c	         val=valtxt
	      endif
	      call eval_(roper,val(fld),valtxt(fld),hugk,result,erro)
	      if (result) then		!true
	         goto 900		!success, break now !!!
	      endif
	   endif
1002	continue
	goto 900
900	continue
c
	return
c
c
	end
c
c
c
c
	subroutine eval_(roper,val,valtxt,pos,result,erro)
c	**************************************************
c
c	Written by Luis Arriaga da Cunha, 1985
c
	implicit none
c
	integer roper,val,pos,erro
	character*(*) valtxt
	logical result
c
c	Description
c	===========
c
c	Applies the relational operator OPER to its arguments
c	given in the  semantic  stacks. The result  is  given
c	back  in RESULT. The  semantic arrays  are passed via
c	common,  STACK.OWN,  the  position  to be used is POS.
c	From this  later the value(s) of the arguments can be
c	collect wether number-like or text-like, respectively
c	from  hnum$  or  htxt$. The  value  to be used in the
c	relational  operation , ie the field value, is  given
c	in  VAL  for  number-like  arguments,  in  VALTXT  if
c	text-like arguments.
c
c	Reminder
c
c	Relational operators in array HUGE1$ are :
c
c	=		1
c	<>		2
c	<		3
c	>		4
c	>=		5
c	<=		6
c	between		7
c	not_between	8
c	string_in	9
c	= KWIC field	11
c
c	Type of argument in array HUGE2$ can be :
c
c	number-like argument			1
c	text-like argument			2
c	date with possible wild card		3
c	bit map "list"				4
c	other D.B. field reference		5
c	bit map "list" with check digit		6
c	empty					7
c
c	cons
c	====
c
	integer godctm	!list of values above this are binary searched
	parameter ( godctm = 20 )
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:stack.own'
c
	external lstrip_
	integer  lstrip_
	external istrip_
	integer  istrip_
c
	integer k,tp,l,l1,l2,lg,lg2,wht,ival,ltxt
	integer ymd,d,m,y,dv,mv,yv,d2,m2,y2,p1,p2
	logical trunc,found,empty,eo,perfect,sensitive
	character*132 tmp1,tmp2
c
c	begin
c	=====
c
	tp=huge2$(pos)		!type of args
	l1=huge3$(pos)		!start position
	l2=huge4$(pos)		!end position
	ltxt=istrip_(valtxt)	!empty or not empty
	if (ltxt.le.0) then
	   empty=.true.
	else
	   empty=.false.
	endif
	perfect=s$set(s$perf)	!perfect match FOR %x='string'
	sensitive=s$set(s$case)	!case or mult_nat_char_set sensitive
c
	goto (100,200,300,400,500,600,700,800,900,1000,1100) roper
c
c	=
100	continue
1100	continue
	if (tp.eq.1) then	!number
	   if (empty) then
	      result=.false.
	      goto 9000		!failure
	   endif
	   if ((l2-l1).lt.godctm) then	!sequencial search
	      do 1001 k=l1,l2
	         if (val.eq.hnum$(k)) then
	            result=.true.
	            goto 9000	!success, break now !
	         endif
1001	      continue
	   else				!binary search
	      call ndctm1_(val,hnum$,l1,l2,k,found)
	      if (found) then
	         result=.true.
	         goto 9000	!success, break now !
	      endif
	   endif
	   result=.false.	!failure
	elseif (tp.eq.2) then	!text
	   do 1002 k=l1,l2,2
	      lg=lstrip_(valtxt)
	      tmp1=valtxt(1:lg)		!field value
	      if (.not.sensitive) then
	         call uc8to7_(tmp1(1:lg))
	      endif
	      p1=hnum$(k)
	      p2=hnum$(k+1)
	      tmp2=htxt$(p1:p2)
	      lg2=p2-p1+1
	      if (roper.eq.1) then	!normal
	         if (perfect) then	!perfect match
	            if (tmp1(1:lg).eq.tmp2(1:lg2)) then
	               result=.true.
	               goto 9000	!success, break now !
	            endif
	         else			!non perfect match
	            l=index(tmp1(1:lg),tmp2(1:lg2))
	            if (l.eq.1) then
	               result=.true.
	               goto 9000	!success, break now !
	            endif
	         endif
c	         if perfect match wanted
	      else			!KWIC indexed
	         eo=.true.
1011	         continue
	         call word4_(tmp1(1:lg),d$cbuf,eo,trunc)	!go thru words
	                                                        !of field value
	         if (eo) goto 1012
	         l=index(d$cbuf,tmp2(1:lg2))
	         if (l.eq.1) then
	            result=.true.
	            goto 9000	!success, break now !
	         endif
	         goto 1011
1012	         continue
	      endif
1002	   continue
	   result=.false.
	elseif (tp.eq.3) then	!possible wild card
	   if (empty) then
	      result=.false.
	      goto 9000		!failure
	   endif
	   ymd=val		!decompose field
	   dv=mod(ymd,100)
	   mv=ymd/100
	   mv=mod(mv,100)
	   yv=ymd/10000
	   do 1003 k=l1,l2
	      ymd=hnum$(k)	!decompose argument
	      d=mod(ymd,100)
	      m=ymd/100
	      m=mod(m,100)
	      y=ymd/10000
	      if ( (dv.eq.d.or.d.eq.0 ) .and.
     1             (mv.eq.m.or.m.eq.0 ) .and.
     1             (yv.eq.y.or.y.eq.0 )       ) then
	         result=.true.
	         goto 9000	!success, break now !
	      endif
1003	   continue
	   result=.false.	!failure
	elseif (tp.eq.4.or.tp.eq.6) then !bit map "list"
	   if (empty) then
	      result=.false.
	      goto 9000		!failure
	   endif
	   wht=0
	   ival=val
	   if (tp.eq.6) then
	   endif
	   call bitget_(hnum$(l1),ival,wht,erro)
	   if (erro.ne.0) erro=0
	   if (wht.eq.1) then
	      result=.true.
	      goto 9000		!success, break !
	   endif
	   result=.false.
	elseif (tp.eq.5) then	!other D.B. field
c	   future
	elseif (tp.eq.7) then	!empty argument
	   if (empty) then
	      result=.true.
	      goto 9000		!success, break !
	   else
	      result=.false.
	   endif
	else
c	   future
	endif
	goto 9000
c
c	<>
200	continue
	if (tp.eq.1.or.tp.eq.3) then	!number or wild card
	   if (empty) then
	      result=.true.
	      goto 9000		!success
	   endif
	   if ((l2-l1).lt.godctm) then	!sequencial search
	      do 1004 k=l1,l2
	         if (val.eq.hnum$(k)) then
	            result=.false.
	            goto 9000	!failure, don't proceed
	         endif
1004	      continue
	   else				!binary search
	      call ndctm1_(val,hnum$,l1,l2,k,found)
	      if (.not.found) then
	         result=.false.
	         goto 9000	!failure, don't proceed
	      endif
	   endif
	   result=.true.	!success
	elseif (tp.eq.2) then 		!text
	   p1=hnum$(l1)
	   p2=hnum$(l2)
	   lg=lstrip_(valtxt)
	   tmp1=valtxt(1:lg)		!field value
	   if (.not.sensitive) then
	      call uc8to7_(tmp1(1:lg))
	   endif
	   tmp2=htxt$(p1:p2)
	   lg2=p2-p1+1
	   if (tmp1(1:lg).eq.tmp2(1:lg2)) then
	      result=.false.
	   else
	      result=.true.
	   endif
	elseif (tp.eq.4.or.tp.eq.6) then	!bit map "list"
	   if (empty) then
	      result=.true.
	      goto 9000		!success
	   endif
	   wht=0
	   ival=val
	   if (tp.eq.6) then
	   endif
	   call bitget_(hnum$(l1),ival,wht,erro)
	   if (erro.ne.0) erro=0
	   if (wht.eq.0) then
	      result=.false.
	      goto 9000		!failure, break !
	   endif
	   result=.false.
	elseif (tp.eq.5) then		!other D.B. field
c	   future
	elseif (tp.eq.7) then	!empty argument
	   if (empty) then
	      result=.false.
	      goto 9000		!failure, break !
	   else
	      result=.true.
	   endif
	else
c	   future
	endif
	goto 9000
c
c	<
300	continue
	if (tp.eq.1) then	!number
	   if (empty) then
	      result=.false.
	      goto 9000		!failure
	   endif
	   if (val.lt.hnum$(l1)) then
	      result=.true.
	   else
	      result=.false.
	   endif
	elseif (tp.eq.2) then	!text
	   p1=hnum$(l1)
	   p2=hnum$(l2)
	   lg=lstrip_(valtxt)
	   tmp1=valtxt(1:lg)
	   if (.not.sensitive) then
	      call uc8to7_(tmp1(1:lg))
	   endif
	   tmp2=htxt$(p1:p2)
	   lg2=p2-p1+1
	   if (tmp1(1:lg).lt.tmp2(1:lg2) ) then
	      result=.true.
	   else
	      result=.false.
	   endif
	elseif (tp.eq.3) then	!possible wild card
	   if (empty) then
	      result=.false.
	      goto 9000		!failure
	   endif
	   ymd=val		!decompose field
	   dv=mod(ymd,100)
	   mv=ymd/100
	   mv=mod(mv,100)
	   yv=ymd/10000
	   ymd=hnum$(l1)	!decompose argument
	   d=mod(ymd,100)
	   m=ymd/100
	   m=mod(m,100)
	   y=ymd/10000
	   if ( y.eq.0.or.y.eq.yv) then
	      if  (m.eq.0.or.m.eq.mv) then
	         if (d.eq.0.or.d.lt.dv) then
	            result=.true.
	         else
	            result=.false.
	         endif
	      elseif (m.gt.mv) then
	         result=.false.
	      else
	         result=.true.
	      endif
	   elseif (y.gt.yv) then
	      result=.false.
	   else
	      result=.true.
	   endif
	elseif (tp.eq.5) then	!other D.B. field
c	   future
	elseif (tp.eq.7) then	!empty argument
c	   future
	else
c	   future
	endif
	goto 9000
c
c	>
400	continue
	if (tp.eq.1) then	!number
	   if (empty) then
	      result=.false.
	      goto 9000		!failure
	   endif
	   if (val.gt.hnum$(l1)) then
	      result=.true.
	   else
	      result=.false.
	   endif
	elseif (tp.eq.2) then	!text
	   p1=hnum$(l1)
	   p2=hnum$(l2)
	   lg=lstrip_(valtxt)
	   tmp1=valtxt(1:lg)
	   if (.not.sensitive) then
	      call uc8to7_(tmp1(1:lg))
	   endif
	   tmp2=htxt$(p1:p2)
	   lg2=p2-p1+1
	   if (tmp1(1:lg).gt.tmp2(1:lg2) ) then
	      result=.true.
	   else
	      result=.false.
	   endif
	elseif (tp.eq.3) then	!possible wild card
	   if (empty) then
	      result=.false.
	      goto 9000		!failure
	   endif
	   ymd=val		!decompose field
	   dv=mod(ymd,100)
	   mv=ymd/100
	   mv=mod(mv,100)
	   yv=ymd/10000
	   ymd=hnum$(l1)	!decompose argument
	   d=mod(ymd,100)
	   m=ymd/100
	   m=mod(m,100)
	   y=ymd/10000
	   if ( y.eq.0.or.y.eq.yv) then
	      if  (m.eq.0.or.m.eq.mv) then
	         if (d.eq.0.or.d.gt.dv) then
	            result=.true.
	         else
	            result=.false.
	         endif
	      elseif (m.lt.mv) then
	         result=.false.
	      else
	         result=.true.
	      endif
	   elseif (y.lt.yv) then
	      result=.false.
	   else
	      result=.true.
	   endif
	elseif (tp.eq.5) then	!other D.B.
c	   future
	elseif (tp.eq.7) then	!empty argument
c	   future
	else
c	   future
	endif
	goto 9000
c
c	>=
500	continue
	if (tp.eq.1) then	!number
	   if (empty) then
	      result=.false.
	      goto 9000		!failure
	   endif
	   if (val.ge.hnum$(l1)) then
	      result=.true.
	   else
	      result=.false.
	   endif
	elseif (tp.eq.2) then	!text
	   p1=hnum$(l1)
	   p2=hnum$(l2)
	   lg=lstrip_(valtxt)
	   tmp1=valtxt(1:lg)
	   if (.not.sensitive) then
	      call uc8to7_(tmp1(1:lg))
	   endif
	   tmp2=htxt$(p1:p2)
	   lg2=p2-p1+1
	   if (tmp1(1:lg).ge.tmp2(1:lg2) ) then
	      result=.true.
	   else
	      result=.false.
	   endif
	elseif (tp.eq.3) then	!possible wild card
	   if (empty) then
	      result=.false.
	      goto 9000		!failure
	   endif
	   ymd=val		!decompose field
	   dv=mod(ymd,100)
	   mv=ymd/100
	   mv=mod(mv,100)
	   yv=ymd/10000
	   ymd=hnum$(l1)	!decompose argument
	   d=mod(ymd,100)
	   m=ymd/100
	   m=mod(m,100)
	   y=ymd/10000
	   if ( y.eq.0.or.y.eq.yv) then
	      if  (m.eq.0.or.m.eq.mv) then
	         if (d.eq.0.or.d.ge.dv) then
	            result=.true.
	         else
	            result=.false.
	         endif
	      elseif (m.lt.mv) then
	         result=.false.
	      else
	         result=.true.
	      endif
	   elseif (y.lt.yv) then
	      result=.false.
	   else
	      result=.true.
	   endif
	elseif (tp.eq.5) then	!other D.B.
c	   future
	elseif (tp.eq.7) then	!empty argument
	   if (empty) then
	      result=.true.
	      goto 9000		!success, break !
	   else
	      result=.false.
	   endif
	else
c	   future
	endif
	goto 9000
c
c	<=
600	continue
	if (tp.eq.1) then	!number
	   if (empty) then
	      result=.false.
	      goto 9000		!failure
	   endif
	   if (val.le.hnum$(l1)) then
	      result=.true.
	   else
	      result=.false.
	   endif
	elseif (tp.eq.2) then	!text
	   p1=hnum$(l1)
	   p2=hnum$(l2)
	   lg=lstrip_(valtxt)
	   tmp1=valtxt(1:lg)
	   if (.not.sensitive) then
	      call uc8to7_(tmp1(1:lg))
	   endif
	   tmp2=htxt$(p1:p2)
	   lg2=p2-p1+1
	   if (tmp1(1:lg).le.tmp2(1:lg2) ) then
	      result=.true.
	   else
	      result=.false.
	   endif
	elseif (tp.eq.3) then	!possible wild card
	   if (empty) then
	      result=.false.
	      goto 9000		!failure
	   endif
	   ymd=val		!decompose field
	   dv=mod(ymd,100)
	   mv=ymd/100
	   mv=mod(mv,100)
	   yv=ymd/10000
	   ymd=hnum$(l1)	!decompose argument
	   d=mod(ymd,100)
	   m=ymd/100
	   m=mod(m,100)
	   y=ymd/10000
	   if ( y.eq.0.or.y.eq.yv) then
	      if  (m.eq.0.or.m.eq.mv) then
	         if (d.eq.0.or.d.le.dv) then
	            result=.true.
	         else
	            result=.false.
	         endif
	      elseif (m.gt.mv) then
	         result=.false.
	      else
	         result=.true.
	      endif
	   elseif (y.gt.yv) then
	      result=.false.
	   else
	      result=.true.
	   endif
	elseif (tp.eq.5) then	!other D.B.
c	   future
	elseif (tp.eq.7) then	!empty argument
	   if (empty) then
	      result=.true.
	      goto 9000		!success, break !
	   else
	      result=.false.
	   endif
	else
c	   future
	endif
	goto 9000
c
c	between
700	continue
	if (tp.eq.1) then	!number
	   if (empty) then
	      result=.false.
	      goto 9000		!failure
	   endif
	   if (val.ge.hnum$(l1).and.val.le.hnum$(l2)) then
	      result=.true.
	   else
	      result=.false.
	   endif
	elseif (tp.eq.2) then	!text
	   p1=hnum$(l1)
	   p2=hnum$(l2)
	   lg=lstrip_(valtxt)
	   tmp1=valtxt(1:lg)
	   if (.not.sensitive) then
	      call uc8to7_(tmp1(1:lg))
	   endif
	   tmp2=htxt$(p1:p2)
	   lg2=p2-p1+1
	   if (tmp1(1:lg).ge.tmp2(1:lg2).and.
     1         tmp1(1:lg).le.tmp2(1:lg2) ) then
	      result=.true.
	   else
	      result=.false.
	   endif
	elseif (tp.eq.3) then	!possible wild card
	   if (empty) then
	      result=.false.
	      goto 9000		!failure
	   endif
	   ymd=val		!decompose field
	   dv=mod(ymd,100)
	   mv=ymd/100
	   mv=mod(mv,100)
	   yv=ymd/10000
	   ymd=hnum$(l1)	!decompose argument
	   d=mod(ymd,100)
	   m=ymd/100
	   m=mod(m,100)
	   y=ymd/10000
	   ymd=hnum$(l2)	!decompose argument
	   d2=mod(ymd,100)
	   m2=ymd/100
	   m2=mod(m2,100)
	   y=ymd/10000
	   if ( ((dv.ge.d.and.dv.le.d2).or.d.eq.0 ) .and.
     1          ((mv.ge.m.and.mv.le.m2).or.m.eq.0 ) .and.
     1          ((yv.ge.y.and.yv.le.y2).or.y.eq.0 )       ) then
	      result=.true.	!success
	   else
	      result=.false.	!failure
	   endif
	elseif (tp.eq.5) then	!other D.B.
c	   future
	elseif (tp.eq.7) then	!empty argument
c	   future
	else
c	   future
	endif
	goto 9000
c
c	not_between
800	continue
	if (tp.eq.1) then	!number
	   if (empty) then
	      result=.false.
	      goto 9000		!failure
	   endif
	   if (val.lt.hnum$(l1).or.val.gt.hnum$(l2)) then
	      result=.true.
	   else
	      result=.false.
	   endif
	elseif (tp.eq.2) then	!text
	   p1=hnum$(l1)
	   p2=hnum$(l2)
	   lg=lstrip_(valtxt)
	   tmp1=valtxt(1:lg)
	   if (.not.sensitive) then
	      call uc8to7_(tmp1(1:lg))
	   endif
	   tmp2=htxt$(p1:p2)
	   lg2=p2-p1+1
	   if (tmp1(1:lg).lt.tmp2(1:lg2).or.
     1         tmp1(1:lg).gt.tmp2(1:lg2) ) then
	      result=.true.
	   else
	      result=.false.
	   endif
	elseif (tp.eq.3) then	!possible wild card
	   if (empty) then
	      result=.false.
	      goto 9000		!failure
	   endif
	   ymd=val		!decompose field
	   dv=mod(ymd,100)
	   mv=ymd/100
	   mv=mod(mv,100)
	   yv=ymd/10000
	   ymd=hnum$(l1)	!decompose argument
	   d=mod(ymd,100)
	   m=ymd/100
	   m=mod(m,100)
	   y=ymd/10000
	   ymd=hnum$(l2)	!decompose argument
	   d2=mod(ymd,100)
	   m2=ymd/100
	   m2=mod(m2,100)
	   y=ymd/10000
	   if ( ((dv.lt.d.and.dv.gt.d2).or.d.eq.0 ) .and.
     1          ((mv.lt.m.and.mv.gt.m2).or.m.eq.0 ) .and.
     1          ((yv.lt.y.and.yv.gt.y2).or.y.eq.0 )       ) then
	      result=.true.	!success
	   else
	      result=.false.	!failure
	   endif
	elseif (tp.eq.5) then	!other D.B.
c	   future
	elseif (tp.eq.7) then	!empty argument
c	   future
	else
c	   future
	endif
	goto 9000
c
c	sub-string
900	continue
c
	do 1009 k=l1,l2,2
	   lg=lstrip_(valtxt)
	   tmp1=valtxt(1:lg)		!field value
	   if (.not.sensitive) then
	      call uc8to7_(tmp1(1:lg))
	   endif
	   p1=hnum$(k)
	   p2=hnum$(k+1)
	   tmp2=htxt$(p1:p2)
	   lg2=p2-p1+1
	   l=index(tmp1(1:lg),tmp2(1:lg2))
	   if (l.gt.0) then
	      result=.true.
	      goto 9000		!break now
	   else
	      result=.false.
	   endif
1009	continue
	goto 9000
c
c	@file
1000	continue
	goto 9000
c
9000	continue
	return
c
c	errors
c	======
c
c	inherited errors
95000	continue
	goto 99000
c
99000	continue
	return
c
c
c
	end
c
c
c
c
