	subroutine forsyn_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1                    mark,interr,erro)
c	*********************************************************
c
	implicit none
c
	integer type,val,dec,lim,p1,p2,mark,interr,erro
	character*(*) buf,mymssg
	real rval
c
c
c	Description
c	===========
c
c	This procedure analyses  FOR  expressions, checks for syntatical
c	correctness  and  collects  arguments  and  operatos  for  later
c	evaluation in post-fix notation in a  stack. Internal procedures
c	are used RECURSIVELY !!! (uau!).
c
c	Valid syntax for expressions:
c
c	<logical expression> =	<condition> ,
c				{
c				".OR." ,
c				<condition>
c				}* .
c
c	<condition> =	<cond1> ,
c			{
c			 ( ".AND." ),
c			<cond1>
c			}* .
c
c	<cond1> =	[ ".NOT." ] ,
c			(
c			"(" , <logical expression>, ")"
c			!
c			( "%",NUMBER  ! IDENTIFIER ),
c			    ( "="!"<>"!">"!"<"!">="!"<=" )
c			    ,
c			    ( <arithm expression>,
c				( { ",", <arithm expression>}
c				! ":", <arithm expression>
c				)
c			    ! <string expression>
c			    !  DATE,
c				( { "," , DATE }
c				! ":", DATE
c				)
c			    ! "@" FILE_SPECIFICATION
c			    !  LOGICAL
c			    )
c			!
c			STRING, "$", IDENTIFIER .
c			)
c
c	FOR THE MOMENT :
c
c	<arithm expression> = NUMBER ! DECIMAL.
c
c	PERHAPS LATER :
c
c	<arithm expression> =	( "+" ! "-" ),
c				<term>,
c				{ ( "+" ! "-" ), <term> }* .
c
c	<term> =	<fact>, { ( "*" ! "/" ), <fact> }* .
c
c	<fact> =	( "(", <arithm expression>, ")"
c			!
c			NUMBER
c			!
c			DECIMAL ) ,
c			[ "^", NUMBER ].
c
c	END OF FOR THE MOMENT, PERHAPS LATER...
c
c	<string expression> =	STRING ,
c				{ ( "," ), STRING }* .
c
c	NOT ALL syntactical figures correspond to a procedure, some
c	have  been  substituted. If a syntactical error exists MARK
c	will tell the position in the buffer where FORSYN got stuck.
c	ERRO = 0 means no error, as usual, -1 means INWHT error, >0
c	means own error of procedure.By the way, INTERR tells which
c	INWHT error occcurred.
c
c	var
c	===
c
	include 'own:stack.own'
c
	external istrip_
	integer istrip_,ierr
c
c	begin
c	=====
c
	call errclr_('FORSYN')		!error init
	erro=0				!clear error
	mark=0
c
	chuge$=0
c
c	get 1st token
c	-------------
c
	call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	if (interr.ne.0) goto 90000
cx	if (type.eq.0) return
	if (type.eq.0) goto 90002		!empty!
c
c	logical expression level
c	------------------------
c
	chuge$=1
	chtxt$=1
	chnum$=1
	chrl4$=1
	call pzero_(ierr)
	call lexp$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   	   mark,interr,erro)
	if (erro.ne.0) then
	   call pzero_(ierr)
	   goto 95000
	else
	   chuge$=chuge$-1
	endif
c
c	normally next line should be removed as other things can follow
c
cx	if (type.ne.0)   goto 90001	!extraneous tokens in line
c
	return
c
c	errors
c	======
c
c	intok error in forsyn initialization
90000	continue
	erro=-1
	return
c
c	extraneous tokens after FOR expression
90001	continue
	erro=1
ccxx	mark=istrip_(buf)
	mark=p1
	goto 99000			!set error
c
c	empty!
90002	continue
	erro=2
	mark=p1
	goto 99000			!set error
c
c	inherited syntax error
95000	continue
	return				!just return
c
c	Set error and return
c
99000	continue
	call errset_('FORSYN',erro)
	return
c
c
c	Formats
c	=======
c
	end
c
c
c
c
	subroutine lexp$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1                   mark,interr,erro)
c	********************************************************
c
	implicit none
c
	integer type,val,dec,lim,p1,p2,mark,interr,erro
	real rval
	character*(*) buf,mymssg
c
c	Description
c	===========
c
c	It implements <logical expression> figure, see above in FORSYN.
c
c	Eg : blabla .OR. blabla .OR. blabla...
c
c	var
c	===
c
	include 'own:stack.own'
c
	integer argcnt,ierr
c
c	begin
c	=====
c
	erro=0
	mark=0
c
c	logical expression level
c	------------------------
c
	call cond$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   	   mark,interr,erro)
	if (erro.ne.0) goto 90002
	argcnt=1
c
cwhile	do while (type.eq.31)		! .OR.
1099	continue
	   if (type.ne.31) goto 1098
c
	   call push_(argcnt,ierr)
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (erro.ne.0) goto 90001
	   call cond$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   	      mark,interr,erro)
	   if (erro.ne.0) goto 90002
	   call pop_(argcnt,ierr)
	   argcnt=argcnt+1
c
	   goto 1099
1098	continue
cwhile	enddo
c
	if (argcnt.gt.1) then
	   huge$(chuge$)='.or.'
	   huge1$(chuge$)=0
	   huge2$(chuge$)=0
	   chuge$=chuge$+1
	   write(huge$(chuge$),'(''*'',i4)')argcnt
	   huge1$(chuge$)=0
	   huge2$(chuge$)=0
	   chuge$=chuge$+1
	endif
c
	return
c
c	errors
c	======
c
c	intok error in logical expression
90001	continue
	erro=-1
	mark=p1
	return
c
c	inherited syntax error
90002	continue
	return
c
c
	end
c
c
c
c
	subroutine cond$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1                   mark,interr,erro)
c	********************************************************
c
	implicit none
c
	integer type,val,dec,lim,p1,p2,mark,interr,erro
	real rval
	character*(*) buf,mymssg
c
c	Description
c	===========
c
c	It implements <condition> figure, see above in FORSYN.
c
c	Ex : blabla .AND. blabla .AND. blabla...
c
c	var
c	===
c
	include 'own:stack.own'
c
	integer argcnt,ierr
c
c	begin
c	=====
c
	erro=0
	mark=0
c
c	condition level
c	---------------
c
	call cond1$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   	    mark,interr,erro)
	if (erro.ne.0) goto 90002
	argcnt=1
c
cwhile	do while (type.eq.30)		! .AND.
1099	continue
	   if (type.ne.30) goto 1098
c
	   call push_(argcnt,ierr)
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (erro.ne.0) goto 90001
	   call cond1$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   	       mark,interr,erro)
	   if (erro.ne.0) goto 90002
	   call pop_(argcnt,ierr)
	   argcnt=argcnt+1
c
	   goto 1099
1098	continue
cwhile	enddo
c
	if (argcnt.gt.1) then
	   huge$(chuge$)='.and.'
	   huge1$(chuge$)=0
	   huge2$(chuge$)=0
	   chuge$=chuge$+1
	   write(huge$(chuge$),'(''*'',i4)')argcnt
	   huge1$(chuge$)=0
	   huge2$(chuge$)=0
	   chuge$=chuge$+1
	endif
c
	return
c
c	errors
c	======
c
c	intok error in logical expression
90001	continue
	erro=-1
	mark=p1
	return
c
c	inherited syntax error
90002	continue
	return
c
c
	end
c
c
c
c
	subroutine cond1$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1                    mark,interr,erro)
c	*********************************************************
c
	implicit none
c
	integer type,val,dec,lim,p1,p2,mark,interr,erro
	real rval
	character*(*) buf,mymssg
c
c	Description
c	===========
c
c	It implements <condition> figure, see above in FORSYN.
c
c	Ex : .NOT. %3 = 23,45,12
c
c	var
c	===
c
	include 'own:stack.own'
c
	integer istrip_
	external istrip_
	logical eqdif,wild,decin
	integer ierr,l,k,what,minus,form,itmp
	character*60 name
	character*12 ext,tmpchr
c
c	begin
c	=====
c
	erro=0
	mark=0
c
	if (type.eq.29) then		! .NOT.
	   call push_(-2,ierr)		! -2 means unary .not.
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 90001
	else
	   call push_(-1,ierr)		! -1 means unary nothing
	endif
c
	if (type.eq.6) then		! "("
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 90001
	   call lexp$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   	      mark,interr,erro)
	   if (erro.ne.0) goto 90002
	   if (type.eq.7) then		! ")"
	      call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1                    interr)
	      if (interr.ne.0) goto 90001
	   else
	      goto 90002
	   endif
c
c
c
	elseif (type.eq.1.or.type.eq.33.or.		!IDENTIFIER or "%n"
     1          type.eq.40)                then		!or # (record ref)
c
	   hubl$(chuge$)(1:)=' '		! try current base left
	   hubr$(chuge$)(1:)=' '		! try current base right
60	   continue
	   if (type.eq.33) then	! "%"
	      call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1                    interr)
	      if (interr.ne.0) goto 90001
	      if (type.eq.2) then		! NUMBER
	         huge$(chuge$)(1:1)='%'		! semantic
	         write(huge$(chuge$)(2:5),'(i4.4)')val
	      else
	         goto 90002
	      endif
	      call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	      if (interr.ne.0) goto 90001
	   else
	      huge$(chuge$)(1:1)=' '		! semantic
	      huge$(chuge$)(2:)=buf(p1:p2)
	      call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	      if (interr.ne.0) goto 90001
	      if (type.eq.21) then		! '.' notation
	         hubl$(chuge$)(1:)=huge$(chuge$)(2:)
	         call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1                       interr)
	         if (interr.ne.0) goto 90001
	         if (type.eq.1.or.type.eq.33) then
	            goto 60	!loop back
	         else
	            goto 90002
	         endif
	      endif
	   endif
c
c
c
c
	   if (type.eq.9.or.type.eq.17.or.type.eq.16.or.
     1        type.eq.15.or.type.eq.22.or.type.eq.23.or.
	1     type.eq.25)                           then	!=,<>,<,>...
	      if (type.eq.9.or.type.eq.17) then
	         eqdif=.true.	!= or <>
	      else
	         eqdif=.false.	!others...
	      endif
	      huge1$(chuge$)=type
	      call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1                    interr)
	      if (interr.ne.0) goto 90001
c
c
c
	      if (type.eq.19) then	! "@", file spec must follow
	         call infspc_(type,what,name,ext,val,dec,rval,
     1                    buf,lim,p1,p2,mymssg,interr)
	         if (interr.ne.0) goto 90001
	         if (type.eq.36) then	!file spec, perhaps with directory
	            huge2$(chuge$)=1	!pure guess, might come as 9 (bitmap)
	            call atfile_(name,ext,interr)!contents into semantic arrays
	            if (interr.ne.0) goto 90004
	         else
	            goto 90002
	         endif
	         call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1                       interr)
	         if (interr.ne.0) goto 90001
c
	      elseif (type.eq.5) then	! STRING
	         huge2$(chuge$)=2	!semantic string
c*
	         huge3$(chuge$)=chnum$
	         hnum$(chnum$)=chtxt$
	         chnum$=chnum$+1
	         htxt$(chtxt$:)=buf(p1:p2)
	         chtxt$=chtxt$+p2-p1
	         hnum$(chnum$)=chtxt$
	         chtxt$=chtxt$+1
	         chnum$=chnum$+1
c*
cx	         huge3$(chuge$)=chtxt$
cx	         htxt$(chtxt$:)=buf(p1:p2)
cx	         chtxt$=chtxt$+p2-p1
cx	         huge4$(chuge$)=chtxt$
cx	         chtxt$=chtxt$+1
c*
	         call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1                       interr)
	         if (interr.ne.0) goto 90001
cwhile	         do while (type.eq.8)			!","
1099	         continue
	            if (type.ne.8) goto 1098
c
	            call inwht_(type,val,dec,rval,
     1                         buf,lim,p1,p2,mymssg,interr)
	            if (interr.ne.0) goto 90001
	            if (type.eq.5) then	! STRING
c*
	               hnum$(chnum$)=chtxt$
	               chnum$=chnum$+1
	               htxt$(chtxt$:)=buf(p1:p2)
	               chtxt$=chtxt$+p2-p1
	               hnum$(chnum$)=chtxt$
	               chtxt$=chtxt$+1
	               chnum$=chnum$+1
c*
cx	               htxt$(chtxt$:)=buf(p1:p2)
cx	               chtxt$=chtxt$+p2-p1
cx	               huge4$(chuge$)=chtxt$
cx	               chtxt$=chtxt$+1
c*
	               call inwht_(type,val,dec,rval,buf,
     1                            lim,p1,p2,mymssg,interr)
	               if (interr.ne.0) goto 90001
	            else
	               goto 90002
	            endif
c
	            goto 1099
1098	         continue
cwhile	         enddo
	         huge4$(chuge$)=chnum$-1
c
	      elseif (type.eq.26) then	! DATE
	         call numdat_(val,buf(p1:p2),k,form,interr)
	         if (interr.eq.0) then
c	            ok
	            interr=0
	            wild=.false.
	            huge2$(chuge$)=5	!semantic date
	         elseif (interr.eq.9) then
c	            wild card
	            interr=0
	            wild=.true.
	            huge2$(chuge$)=12	!semantic date wild card
	         else
	            goto 90003
	         endif
	         call rstok_(buf,p2+1,interr)
	         if (interr.ne.0) goto 90002
	         huge3$(chuge$)=chnum$
	         hnum$(chnum$)=val
	         if (wild) then
	            htyp$(chnum$)=12
	         else
	            htyp$(chnum$)=5
	         endif
	         chnum$=chnum$+1
	         call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1                       interr)
	         if (interr.ne.0) goto 90001
	         if (type.eq.18) then		! ":"
	            k=huge1$(chuge$)
	            if (k.eq.9) then		!=
	               huge1$(chuge$)=18	!after all we have between
	               eqdif=.false.
	            elseif (k.eq.17) then	! <>
	               huge1$(chuge$)=20	!after all we have not_between
	               eqdif=.false.
	            endif
	            call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1                          interr)
	            if (interr.ne.0) goto 90001
	            if (type.eq.26) then	! DATE
	               call numdat_(val,buf(p1:p2),k,form,interr)
	               if (interr.eq.0) then
c	                  ok
	                  interr=0
	                  wild=.false.
	                  huge2$(chuge$)=5	!semantic date
	               elseif (interr.eq.9) then
c	                  wild card
	                  interr=0
	                  wild=.true.
	                  huge2$(chuge$)=12	!semantic date wild card
	               else
	                  goto 90003
	               endif
	               call rstok_(buf,p2+1,interr)
	               if (interr.ne.0) goto 90002
	               hnum$(chnum$)=val
	               chnum$=chnum$+1
	               call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1                             interr)
	               if (interr.ne.0) goto 90001
	            else
	               goto 90002
	            endif
	         else
	            if (eqdif) then			! "," for = or <>
cwhile	               do while (type.eq.8)
1097	               continue
	                  if (type.ne.8) goto 1096
c
	                  call inwht_(type,val,dec,rval,
     1                               buf,lim,p1,p2,mymssg,interr)
	                  if (interr.ne.0) goto 90001
	                  if (type.eq.26) then	! DATE
	                     call numdat_(val,buf(p1:p2),k,form,interr)
	                     if (interr.eq.0) then
c	                        ok
	                        interr=0
	                        wild=.false.
	                        huge2$(chuge$)=5	!semantic date
	                     elseif (interr.eq.9) then
c	                        wild card
	                        interr=0
	                        wild=.true.
	                        huge2$(chuge$)=12	!semantic date wild card
	                     else
	                        goto 90003
	                     endif
	                     call rstok_(buf,p2+1,interr)
	                     if (interr.ne.0) goto 90002
	                     hnum$(chnum$)=val
	                     chnum$=chnum$+1
	                     call inwht_(type,val,dec,rval,buf,
     1                                  lim,p1,p2,mymssg,interr)
	                     if (interr.ne.0) goto 90001
	                  else
	                     goto 90002
	                  endif
c
	                  goto 1097
1096	               continue
cwhile	               enddo
	            else
cx	               goto 90002
	            endif
	         endif
	         huge4$(chuge$)=chnum$-1
cx	         call nsort0_(huge3$(chuge$),huge4$(chuge$),hnum$)
c
	      elseif (type.eq.27.or.type.eq.28) then	! LOGICAL
	         huge2$(chuge$)=6	!semantic logical
	         huge3$(chuge$)=chnum$
	         hnum$(chnum$)=val
	         huge4$(chuge$)=chnum$
	         chnum$=chnum$+1
	         call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1                       interr)
	         if (interr.ne.0) goto 90001
c
	      elseif (type.eq.1.or.type.eq.33.or.	! IDENTIFIER or "%n"
     1                type.eq.40)                then	! or #
c
61	         continue
	         if (type.eq.33) then	! "%"
	            call inwht_(type,val,dec,rval,
     1              buf,lim,p1,p2,mymssg,interr)
	            if (interr.ne.0) goto 90001
	            if (type.eq.2) then			! NUMBER
	               tmpchr(1:1)='%'		! semantic
	               write(tmpchr(2:5),'(i4.4)')val
	            else
	               goto 90002
	            endif
	            call inwht_(type,val,dec,rval,
     1              buf,lim,p1,p2,mymssg,interr)
	            if (interr.ne.0) goto 90001
	            huge2$(chuge$)=10			!D.B. field ref
	         else
	            tmpchr(1:1)=' '			! IDENTIFIER or #
	            tmpchr(2:)=buf(p1:p2)		! semantic
	            if (type.eq.40) then
	               huge2$(chuge$)=10		!rec # ref
	            else
	               huge2$(chuge$)=13		!IDENTIFIER
	            endif
	            call inwht_(type,val,dec,rval,buf,lim,
     1              p1,p2,mymssg,interr)
	            if (interr.ne.0) goto 90001
	            if (type.eq.21) then		! '.' notation
	               huge2$(chuge$)=10		!D.B. field ref
	               hubr$(chuge$)(1:)=tmpchr(2:)
	               call inwht_(type,val,dec,rval,
     1                 buf,lim,p1,p2,mymssg,interr)
	               if (interr.ne.0) goto 90001
	               if (type.eq.1.or.type.eq.33) then
	                  goto 61	!loop back
	               else
	                  goto 90002
	               endif
	            endif
	         endif
c
	         l=istrip_(tmpchr)
c
	         huge3$(chuge$)=chnum$
	         hnum$(chnum$)=chtxt$
	         chnum$=chnum$+1
	         htxt$(chtxt$:)=tmpchr(1:l)
	         chtxt$=chtxt$+l
	         hnum$(chnum$)=chtxt$
	         chtxt$=chtxt$+1
	         chnum$=chnum$+1
	         huge4$(chuge$)=chnum$-1
cx	         call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
cx     1                    interr)
cx	         if (interr.ne.0) goto 90001
c
	      else					!NUMBER LIKE
	         decin=.false.
cx	         call apzero_(ierr)
cx	         call aexp$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
cx     1	    mark,interr,erro)
cx	         if (erro.ne.0) then
cx	            call apzero_(ierr)
cx	            goto 90002
cx	         else
cx	            call apop_(val,ierr)
	            minus=+1
	            if (type.eq.12) then	! "+"
	               call inwht_(type,val,dec,rval,buf,
     1                 lim,p1,p2,mymssg,interr)
	               if (interr.ne.0) goto 90001
	            elseif (type.eq.13) then	! "-"
	               minus=-1
	               call inwht_(type,val,dec,rval,buf,
     1                 lim,p1,p2,mymssg,interr)
	               if (interr.ne.0) goto 90001
	            endif
	            if (type.eq.2) then
	               huge2$(chuge$)=1	!semantic integer
	            elseif (type.eq.3) then
	               decin=.true.
	               huge2$(chuge$)=4	!semantic decimal
	            else
	               goto 90001
	            endif
	            huge3$(chuge$)=chnum$
	            hnum$(chnum$)=minus*val
	            chnum$=chnum$+1
	            if (decin) then
	               hnum$(chnum$)=dec
	               chnum$=chnum$+1
	            endif
cx	         endif
	         call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1                       interr)
	         if (interr.ne.0) goto 90001
	         if (type.eq.18) then		! ":"
	            k=huge1$(chuge$)
	            if (k.eq.9) then		!=
	               huge1$(chuge$)=18	!after all we have between
	               eqdif=.false.
	            elseif (k.eq.17) then	! <>
	               huge1$(chuge$)=20	!after all we have not_between
	               eqdif=.false.
	            endif
	            call inwht_(type,val,dec,rval,buf,
     1              lim,p1,p2,mymssg,interr)
	            if (interr.ne.0) goto 90001
cx	            call apzero_(ierr)
cx	            call aexp$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
cx     1           mark,interr,erro)
cx	            if (erro.ne.0) then
cx	               call apzero_(ierr)
cx	               goto 90002
cx	            else
cx	               call apop_(val,ierr)
	               minus=+1
	               if (type.eq.12) then	! "+"
	                  call inwht_(type,val,dec,rval,buf,
     1                    lim,p1,p2,mymssg,interr)
	               if    (interr.ne.0) goto 90001
	               elseif (type.eq.13) then	! "-"
	                  minus=-1
	                  call inwht_(type,val,dec,rval,buf,
     1                    lim,p1,p2,mymssg,interr)
	                  if (interr.ne.0) goto 90001
	               endif
	               hnum$(chnum$)=minus*val
	               chnum$=chnum$+1
	               if (decin) then
	                  hnum$(chnum$)=dec
	                  chnum$=chnum$+1
	               endif
cx	            endif
	            call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1                          interr)
	            if (interr.ne.0) goto 90001
	         else
cx	            call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
cx     1                       interr)
cx	            if (interr.ne.0) goto 90001
	            if (eqdif) then		! "," for = or <>
cwhile	               do while (type.eq.8)
1095	               continue
	                  if (type.ne.8) goto 1094
c
	                  call inwht_(type,val,dec,rval,buf,
     1                    lim,p1,p2,mymssg,interr)
	                  if (interr.ne.0) goto 90001
cx	                  call apzero_(ierr)
cx	                  call aexp$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
cx     1	          mark,interr,erro)
cx	                  if (erro.ne.0) then
cx	                     call apzero_(ierr)
cx	                     goto 90002
cx	                  else
cx	                     call apop_(val,ierr)
	                     minus=+1
	                     if (type.eq.12) then	! "+"
	                        call inwht_(type,val,dec,rval,buf,
     1                          lim,p1,p2,mymssg,interr)
	                        if (interr.ne.0) goto 90001
	                     elseif (type.eq.13) then	! "-"
	                        minus=-1
	                        call inwht_(type,val,dec,rval,buf,
     1                          lim,p1,p2,mymssg,interr)
	                        if (interr.ne.0) goto 90001
	                     endif
	                     hnum$(chnum$)=minus*val
	                     chnum$=chnum$+1
	                     if (decin) then
	                        hnum$(chnum$)=dec
	                        chnum$=chnum$+1
	                     endif
cx	                  endif
	                  call inwht_(type,val,dec,rval,buf,
     1                    lim,p1,p2,mymssg,interr)
	                  if (interr.ne.0) goto 90001
c
	                  goto 1095
1094	               continue
cwhile	               enddo
	            else
cx	               goto 90002
	            endif
	         endif
	         huge4$(chuge$)=chnum$-1
cx	         call nsort0_(huge3$(chuge$),huge4$(chuge$),hnum$)
	      endif
	   else
	      goto 90002		!syntax error
	   endif
c
	chuge$=chuge$+1
c
	elseif (type.eq.5) then		! STRING for "$"
c
	   hubl$(chuge$)(1:)=' '		! try current base left
	   hubr$(chuge$)(1:)=' '		! try current base right
cx
	   huge3$(chuge$)=chnum$
	   hnum$(chnum$)=chtxt$
	   chnum$=chnum$+1
	   htxt$(chtxt$:)=buf(p1:p2)
	   chtxt$=chtxt$+p2-p1
	   hnum$(chnum$)=chtxt$
	   chtxt$=chtxt$+1
	   chnum$=chnum$+1
	   huge4$(chuge$)=chnum$-1
c*
cx	   huge3$(chuge$)=chtxt$
cx	   htxt$(chtxt$:)=buf(p1:p2)
cx	   itmp=chtxt$+p2-p1
cx	   chtxt$=itmp
cx	   huge4$(chuge$)=chtxt$
cx	   chtxt$=chtxt$+1
c*
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 90001
	   huge2$(chuge$)=2		!semantic string
	   if (type.eq.25) then		! "$"
	      huge1$(chuge$)=type
	      call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1                    interr)
	      if (interr.ne.0) goto 90001
	      if (type.eq.1) then	! IDENTIFIER
	         huge$(chuge$)(1:1)=' '	!semantic
	         huge$(chuge$)(2:)=buf(p1:p2)
	         call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	         if (interr.ne.0) goto 90001
	      elseif (type.eq.33) then	! "%"
	         call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	         if (interr.ne.0) goto 90001
	         if (type.eq.2) then		! NUMBER
	            huge$(chuge$)(1:1)='%'		! semantic
	            write(huge$(chuge$)(2:5),'(i4.4)')val
	            call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1                          interr)
	            if (interr.ne.0) goto 90001
	         else
	            goto 90002
	         endif
	      else
	         goto 90002		!syntax error
	      endif
	   else
	      goto 90002		!syntax error
	   endif
c
	chuge$=chuge$+1
c
	else
	   goto 90002			!syntax error
	endif
c
	call pop_(k,ierr)
	if (k.eq.-2) then	! unary .not.
	   huge$(chuge$)='.not.'
	   huge1$(chuge$)=0
	   huge2$(chuge$)=0
	   chuge$=chuge$+1
	   write(huge$(chuge$),'(''*'',i4)')1
	   chuge$=chuge$+1
	endif
c
	return				!all done, return
c
c	errors
c	======
c
c	intok error in condition expression
90001	continue
	erro=-1
	mark=p1
	return
c
c	condition expression syntax error
90002	continue
	erro=1
	mark=p1
	goto 99000			!set error
c
c	date error in condition expression
90003	continue
	erro=-2
	mark=p1
	return
c
c	at file reading error in condition expression
90004	continue
	erro=2
	mark=p1
	goto 99000			!set error
c
c	Set error and return
c
99000	continue
	call errset_('COND1$',erro)
	return
c
c
	end
c
c
c
c
	subroutine aexp$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1                   mark,interr,erro)
c	********************************************************
c
	implicit none
c
	integer type,val,dec,lim,p1,p2,mark,interr,erro
	real rval
	character*(*) buf,mymssg
c
c	Description
c	===========
c
c	It implements <arith expression> figure, see above in FORSYN.
c
c	var
c	===
c
	include 'own:stack.own'
c
	integer ierr,oper,resul
c
c	begin
c	=====
c
	erro=0
	mark=0
c
	if (type.eq.12.or.type.eq.13) then		! "+" or "-" optional
	   if (type.eq.13) then
	      call push_(1,ierr)		! - unary
	   else
	      call push_(0,ierr)		! + unary
	   endif
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 90001
	else
	   call push_(0,ierr)		! nikles unary
	endif
c
	call term$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   	   mark,interr,erro)
	if (erro.ne.0) goto 90002
c
	call pop_(oper,ierr)
	call apply$_(oper,resul,ierr)
	if (ierr.ne.0) goto 90002
	call apush_(resul,ierr)
c
cwhile	do while (type.eq.12.or.type.eq.13)		! "+" or "-" mandatory
1099	continue
	   if (.not.(type.eq.12.or.type.eq.13)) goto 1098
c
	   call push_(type,ierr)
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 90001
	   call term$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   	      mark,interr,erro)
	   if (erro.ne.0) goto 90002
	   call pop_(oper,ierr)
	   call apply$_(oper,resul,ierr)
	   if (ierr.ne.0) goto 90002
	   call apush_(resul,ierr)
c
	   goto 1099
1098	continue
cwhile	enddo
c
c
	return				!all done, return
c
c	errors
c	======
c
c	intok error in arithm expression
90001	continue
	erro=-1
	mark=p1
	return
c
c	inherited syntax error
90002	continue
	return
c
c
	end
c
c
c
c
	subroutine term$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1                   mark,interr,erro)
c	********************************************************
c
	implicit none
c
	integer type,val,dec,lim,p1,p2,mark,interr,erro
	real rval
	character*(*) buf,mymssg
c
c	Description
c	===========
c
c	It implements <term> figure, see above in FORSYN.
c
c	var
c	===
c
	include 'own:stack.own'
c
	integer ierr,oper,resul
c
c	begin
c	=====
c
	erro=0
	mark=0
c
	call fact$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   	   mark,interr,erro)
	if (erro.ne.0) goto 90002
cwhile	do while (type.eq.10.or.type.eq.11)	! "*" or "/"
1099	continue
	   if (.not.(type.eq.10.or.type.eq.11)) goto 1098
c
	   call push_(type,ierr)
	   call inwht_(type,val,dec,rval,
     1                buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 90001
	   call fact$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   	      mark,interr,erro)
	   if (erro.ne.0) goto 90002
	   call pop_(oper,ierr)
	   call apply$_(oper,resul,ierr)
	   if (ierr.ne.0) goto 90002
	   call apush_(resul,ierr)
c
	   goto 1099
1098	continue
cwhile	enddo
c
c
	return				!all done, return
c
c	errors
c	======
c
c	intok error in term expression
90001	continue
	erro=-1
	mark=p1
	return
c
c	inherited syntax error
90002	continue
	return
c
c
	end
c
c
c
c
	subroutine fact$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1                   mark,interr,erro)
c	********************************************************
c
	implicit none
c
	integer type,val,dec,lim,p1,p2,mark,interr,erro
	real rval
	character*(*) buf,mymssg
c
c	Description
c	===========
c
c	It implements <fact> figure, see above in FORSYN.
c
c	var
c	===
c
	include 'own:stack.own'
c
	integer ierr,oper,resul
c
c	begin
c	=====
c
	erro=0
	mark=0
c
	if (type.eq.6) then		! "("
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 90001
	   call aexp$_(type,val,dec,rval,buf,lim,p1,p2,mymssg,
     1   	      mark,interr,erro)
	   if (erro.ne.0) goto 90002
	   if (type.eq.7) then		! ")"
	      call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	      if (interr.ne.0) goto 90001
	   else
	      goto 90003		!syntax error
	   endif
	elseif (type.eq.2.or.type.eq.3) then	! NUMBER or DECIMAL
	   call apush_(val,ierr)
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 90001
cx	elseif (type.eq.1) then		! IDENTIFIER
cx	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
cx	   if (interr.ne.0) goto 90001
	else
	   goto 90003			!syntax error
	endif
c
	if (type.eq.20) then		! ^ or ** ( optional )
	   oper=20
	   call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	   if (interr.ne.0) goto 90001
	   if (type.eq.2) then		! NUMBER
	      call apush_(val,ierr)
	      call apply$_(oper,resul,ierr)
	      if (ierr.ne.0) goto 90002
	      call apush_(resul,ierr)
	      call inwht_(type,val,dec,rval,buf,lim,p1,p2,mymssg,interr)
	      if (interr.ne.0) goto 90001
	   else
	      goto 90003		!syntax error
	   endif
	endif
c
	return				!all done, return
c
c	errors
c	======
c
c	intok error in fact expression
90001	continue
	erro=-1
	mark=p1
	return
c
c	inherited syntax error
90002	continue
	return
c
c	fact expression syntax error
90003	continue
	erro=1
	mark=p1
	goto 99000			!set error
c
c	Set error
c
99000	continue
	call errset_('FACT$',erro)
	return
c
c
	end
c
c
c
c
	subroutine apply$_(oper,resul,erro)
c	**********************************
c
	implicit none
c
	integer oper,resul,erro
c
c	Description
c	===========
c
c	It applies OPER to the one/two top element(s) of ASTACK,
c	giving  RESUL. It  supports "+","-" (perhaps unary),"*",
c	"/","^".
c
c	var
c	===
c
	include 'own:stack.own'
c
	integer item1,item2
c
c	begin
c	=====
c
	erro=0
c
	if (oper.eq.1.or.oper.eq.0) then	! + - unary
	   call apop_(item1,erro)
	else					! binary
	   call apop_(item1,erro)
	   call apop_(item2,erro)
	endif
c
	if (oper.eq.12) then		! +
	   resul=item1+item2
	elseif (oper.eq.13) then	! -
	   resul=item2-item1
	elseif (oper.eq.10) then	! *
	   resul=item1*item2
	elseif (oper.eq.11) then	! /
	   if (item1.ne.0) then
	      resul=item2/item1
	   else
	      resul=0
	      erro=1
	   endif
	elseif (oper.eq.1)  then	! - unary
	   resul=-item1
	elseif (oper.eq.20) then	! ^
	   resul=item2**item1
	else
	   resul=item1			! + unary
	endif
c
c
	return
c
c
	end
c
c
c
c
	subroutine atfile_(name,ext,interr)
c	***********************************
c
	implicit none
c
	character*(*) name,ext
	integer interr
c
c	Description
c	===========
c
c	Reads  from  a  file  NAME.EXT  numbers  that are  records numbers of
c	other  D.B.. Therefore  only normally valid (there are subtleties...)
c	for fields that are other data bases.
c
c	The  file  can  come  in various formats :
c
c	1) "free" format, one number per line.
c	2) "search" format (bitmap), where a header exists (SEARCH).
c	3) "display" format where a header exists (DISPLAY) (future)
c
c	NOTE that huge2$, if bit map, will be given back as 9 or 11.
c	f NOT bit map  the  values  will  always  be sorted in hnum$.
c
c	var
c	===
c
	include 'own:stack.own'
c
	integer istrip_
	external istrip_
	integer ch,val,l,lim,erro
	logical ohyes,free,search,display,nocheck
	character*20 line
	character*1  cmmd,basenm*200,when,who,where
c
c	begin
c	=====
c
	lim=istrip_(ext)
	if (lim.le.0) then
c	   call givext_(name,whatever)	!default extension here, if any
	else
	   call givext_(name,ext)	!give extension, so "a." works ...
	endif
c
	call newc_(ch)
	if (ch.le.0) goto 90003
	call f$ihdr_(ch,name,line,
     1              cmmd,basenm,when,who,where,erro)
c
c	see which type of file
c
	free=.false.
	search=.false.
	display=.false.
	if     (erro.eq.4) then
	   erro=0
	   free=.true.				!free format (pure guess...)
	elseif (line(1:7).eq.'DISPLAY') then
	   display=.true.			!display format (was ist das?)
	elseif (line(1:6).eq.'SEARCH'.or.
	1       line(1:11).eq.'SEARCH/SORT') then
	   search=.true.
	   nocheck=.true.			!see if check digit exists
	   l=istrip_(basenm)
	   if (l.gt.0) then
	      if (basenm(l:l).eq.'*') nocheck=.false.
	   endif
	   if (nocheck) then
	      huge2$(chuge$)=9			!after all bitmap...
	   else
	      huge2$(chuge$)=11 		!bitmap with check digit...
	   endif
	elseif (erro.ne.0) then
	   goto 90001				!can't find file, break
	endif
c
c	loop in file
c
	huge3$(chuge$)=chnum$
1	continue
	if (chnum$.gt.hh1$) goto 90002
	read(ch,*,end=2,err=90002)val
	hnum$(chnum$)=val
	chnum$=chnum$+1
	goto 1
2	continue
	huge4$(chuge$)=chnum$-1
	if (.not.search) then
	   call nsort0_(huge3$(chuge$),huge4$(chuge$),hnum$)
	endif
c
c	end of loop in file
c
	close (ch)
	call freec_(ch)
c
	return
c
c
c	errors
c	======
c
c	can't find file
90001	continue
	interr=1
	goto 99000
c
c	problems with file
90002	continue
	interr=2
	goto 99000
c
c	no more i/o channels
90003	continue
	interr=3
	goto 99000
c
99000	continue
	if (ch.gt.0) then
	   close (ch)
	   call freec_(ch)
	endif
	return
c
c
	end
c
c
c
c
c
