	subroutine INIT_(erro)
c	**********************
c
	implicit none
c
	integer erro
c
c	Description
c	===========
c
c	This procedure performs initial DBAG settings.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
	include 'own:stack.own'
	include 'own:strdef.own'
c
	external istrip_
	integer istrip_
	character*1 endc,pad,ring
	integer ttlen,blink
	logical done/.false./,broad,batch
c
c	begin
c	=====
c
	call errclr_('INIT')			!error init
	erro=0
c
	if (done) then				!do it just once
	   return
	else
	   done=.true.
	endif
c
c	Name, version, prompt
c	=====================
c
	d$name='DBAG data base system'
	d$vers='version 1.5'
	d$prmt='BAG> '
	d$prsz=5		!prompt size
c
c	User's terminal with extra long size
c	====================================
c
	ttlen=d$cmds+20			!room for comand line + promptings
c
	if (istrip_(ttinam).le.0) ttinam='sys$input'	!tt: name for input
	if (istrip_(ttonam).le.0) ttonam='sys$output'	!tt: name for output
c
	call newc_(tti)			!allocate input channel for tt:
	if (tti.le.0) goto 90002	!?? no channel
c
	open (unit=tti,file=ttinam,status='unknown',recl=ttlen,
     1        err=90003)
c
	call newc_(tto)			!allocate output channel for tt:
	if (tti.le.0) goto 90002	!?? no channel
c
	open (unit=tto,file=ttonam,status='unknown',recl=ttlen,
     1        err=90004)
c
	d$cmdi=tti				!start reading from tt:
	d$cmdo=tto				!start writing to tt:
c
c	See if a batch user
c	===================
c
	call usrbat_(batch)
c
	us$bat=batch				!remember that
c
c	Initialize DBAG screen editor if not batch
c	==========================================
c
	if (.not.us$bat) then
	   call vedini_(1,endc,pad,ring,blink,tti)!1=initialize editor
	   paddin=pad				!set current padding character
	   ending=endc				!and ending character
	   call i$sscr_(erro)			!set editor according to
						!DBAG status (colon, padd, etc)
	   if (erro.ne.0) return		!error, carry
	endif
c
c	Set defaults
c	============
c
	s$set(s$alte)=.false.	!ALTERNATE	OFF
	s$set(s$bell)=.true.	!BELL		ON
	s$set(s$carr)=.false.	!CARRY		OFF
	s$set(s$colo)=.true.	!COLON		ON
	s$set(s$conf)=.true.	!CONFIRM 	ON
	s$set(s$echo)=.true.	!ECHO	 	ON
	s$set(s$erro)=.true.	!ERRORSTOP	ON
	s$set(s$head)=.true.	!HEADER		ON
	s$set(s$inde)=.true.	!INDEXES	ON
	s$set(s$inte)=.true.	!INTENSITY	ON
	s$set(s$name)=.true.	!NAMES		ON
	s$set(s$padd)=.true.	!PADDING	ON
	s$set(s$paus)=.false.	!PAUSE		OFF
	s$set(s$raw )=.false.	!RAW		OFF
	s$set(s$scre)=.false.	!SCREEN		OFF
	s$set(s$talk)=.true.	!TALK		ON
	s$set(s$trac)=.false.	!TRACE (KGB)	OFF
	s$set(s$veri)=.false.	!VERIFY	 	OFF
	s$set(s$widt)=.false.	!WIDTH		OFF (if OFF, tt width = default)
c
c	Field types
c	===========
c
	ft$(n$)='n'			!integer
	ft$(c$)='c'			!string
	ft$(db$)='db'			!o.d.b
	ft$(x$)='x'			!decimal
	ft$(d$)='d'			!date
	ft$(l$)='l'			!logical
	ft$(r$)='r'			!real*4
	ft$(r8$)='r8'			!real*8
	ft$(p$)='p'			!property
	ft$(s$)='sr'			!series
	ft$(mm$)='mm'			!memo's
	ft$(lk$)='lk'			!link
c
c	Current base, record, field
c	===========================
c
	c$base=0			!current database channel
	c$rec=0				!current record # of c$base
	c$fld=0				!current field # of c$rec within c$base
	c$pbas=0			!previous current base
	c$prec=0			!previous current rec# of c$pbas
	c$pfld=0			!prev. c. field of c$prec within c$pbas
c
c	Logical expressions
c	===================
c
	index$=1	!current position in the array store$
	chuge$=1	!counter in huge*$ arrays
	mhug$=1		!where first logical operator is in hug$ (see FORCHK)

	chtxt$=1	!counter
	chnum$=1	!counter
	chrl4$=1	!counter
	andex$=1	!current position in the array store$
c
c	Creatures and reals
c	===================
c
	reals=.false.			!no real values
	ftusr$=6			!..............
c
cccc	reals=.true.			!real values (r and r8)
cccc	ftusr$=8			!..............
c
	creatures=.false.		!no creatures
c
cccc	creatures=.true.		!creatures (series, properties,...)
c
c	Miscellaneous
c	=============
c
	d$cnch=1			!current position in cache
c
	fldmax=d$f			!absolute max for maxdf$ (STRDEF)
c
	cmcont=';'			!commands continuation character
	linmax=15			!max # lines to DISPLAY
c
	digmax=9			!max # digits for any value
	intmax=999999999		!and max value
c
 	altefl(1:)=' '			!ALTERNATE file standard name
	altefl='DBAG.ALT'
	altext='.ALT'			!and extension
	alteln=500			!and file record length
	d$alte=0			!output i/o channel
c
c	SPY i/o channel and file extension
c
	spy=0
	spyext='.SPY'
c
c	error, help, news and blackbox files
c
	errfil='bag:dbag.msg'
	hlpfil='bag:dbag.hlp'
	nwsfil='bag:dbag.new'
	bkbfil='dbag.bkb'
c
	call ttybrd_(broad)	!broadcast ?
	tt$brd=broad		!remember that
c
c	set terminal width=default, nobroadcast, ...
c
	if (d$itrv.eq.1) then
	   broad=.false.	!not anymore
	   widthd=80		!tt WIDTH default value
	   widthv=80		!and current
	   call i$tset_(widthd,broad,erro)!set terminal (spawn a sub-process)
	   if (erro.ne.0) erro=0!ignore error
	endif
c
	minchr=2		!minimum #characters in command/keyword
c
	at$ext1='.BAT'		!@ file standard extension
	at$ext2='.CMD'		!alias
	at$lvl=0		!current @ level
c
	src$ext='.SEA'		!search (SAVE) standard extension
	srt$ext='.SRT'		!sort (SAVE) standard extension
	dsp$ext='.DSP'		!display (SAVE) standard extension
	cmd$ext='.CMD'		!command (SAVE) standard extension
c
c	Make sure that ERRMSG reserves a channel (funny way ...)
c	========================================================
c
	erro=1					!...
	call errmsg_('INIT',erro,mssg,'%')	!...
	call errclr_('INIT')			!...
	erro=0					!...
c
	return					!return now
c
c	Errors
c	======
c
c	erro = 1 is used to initialize errmsg !!!
c
c	no i/o channel available ?
90002	continue
	erro=2
	goto 99000
c	can't open tt: for input ?
90003	continue
	d$rinf=ttinam
	erro=3
	goto 99000
c	can't open tt: for output ?
90004	continue
	d$rinf=ttonam
	erro=4
	goto 99000
c
c	Set error
c	---------
99000	continue
	call errset_('INIT',erro)
	return

c
	end
c
c
c
c
