	subroutine seemenu_(mode,title,prompt,
	1                   options,noptions,first,
	1                   choice,nchoice,xchoice,
	1	            l,c,lsiz,csiz,
	1                   help,error)
c	*****************************************************
c
	implicit none
c
c	input
c	-----
	integer	mode			!0 is non-screen
	character*(*)	title			!name of menu
	character*(*)	prompt			!prompt for choice
	integer	noptions		!how many options
	character*(*)	options(noptions)	!the menu proper
	integer	first			!number for 1st option
	integer 	l,c,lsiz,csiz		!line,columns upp/left,size
	integer	nchoice			!size of choice array
c
c	output
c	------
	integer	xchoice			!how many choices given by user
	integer	choice(*)		!user's choice
	logical		help			!user wants help
	integer	error			!if 0 all ok
c
c	Description
c	===========
c
c	Given  a  menu  of  OPTIONS the  user's CHOICE is obtained.
c	CHOICE can be more  than  one; XCHOICE tells how many were
c	given by the user. Size of CHOICE is NCHOICE.
c	Options  are  numbered from FIRST. This later must be >= 0.
c	The  number  of  options is (guess) NOPTIONS. The menu can 
c	have  a  TITLE  and  PROMPTS  for the user's answer.
c	If  the  user types a <ret> the first choice is given back.
c	If  the  user  types  ^Z  the  first  choice is given back.
c	HELP will be  true if the user typed "help" or "?". CHOICE
c	will be -1. If  the  user  typed  "help 5" or "? 5" he/she
c	wants  help  on  option 5, for instance; HELP will be true 
c	and CHOICE will be 5 (5 is just an example dope...).
c
c	var
c	===
c
	character*80 tmp
	integer j,n,k,lim,number,shift,lmax,nsiz,many
c
c	begin
c	=====
c
c	preliminaries
c	-------------
c
	error=0
	if (first.lt.0) goto 90		!error
	if (c.eq.0) c=1			!where menu starts in columns
	if (l.eq.0) l=1			!where menu starts in lines
	if (csiz.eq.0) csiz=80-c	!size in columns of window
	if (lsiz.eq.0) lsiz=20-l	!size in lines of window
	call strip0_(title,lim)
	if (lim.eq.0) then
	   nsiz=lsiz
	else
	   nsiz=lsiz-3			!if title give title+2 empty lines
	endif
	if (nsiz.gt.noptions) nsiz=noptions
c
c	menu presentation
c	-----------------
c
c	find miscellaneous information
c
	lmax=0
	do 1003 k=1,noptions
	   call strip_(options(k),lim)
	   if (lim.gt.lmax) lmax=lim
1003	continue
	lmax=lmax+5			!5 places for option number
	         			!see tmp(c+shift+5:)=...
c
	many=noptions/nsiz
	k=mod(noptions,nsiz)
	if (k.gt.0) many=many+1
c
c	do show menu
c
1	continue
c
c	clean and position yourself
c
	call erase_page_(1,1)
	do 1000 k=1,l
	   write(6,'(a)')' '
1000	continue
c
c	give title
c
	tmp(1:)=' '
	tmp(c:)=title(1:)
	call strip_(tmp,lim)
	write(6,'(a//)')tmp(1:lim)
c
c	write options
c
	do 1001 k=1,nsiz		!go thru lines in one column
	   tmp(1:)=' '
	   n=k
	   shift=0
	   number=k+first-1
	   do 1002 j=1,many		!go thru columns
	      if (n.le.noptions) then
	         write(tmp(c+shift:),'(i2,a)') number,' - '
	         tmp(c+shift+5:)=options(n)(1:)
	      endif
	      n=n+nsiz
	      shift=shift+lmax+3	!3 spaces between options columns
	      number=number+nsiz
1002	   continue
	   call strip_(tmp,lim)
	   if (lim.gt.csiz) goto 92
	   write(6,'(a)')tmp(1:lim)
1001	continue
c
c
c
c	get user's choice
c	-----------------
c
	xchoice=1
	help=.false.
	tmp(1:)=' '
	tmp(c:)=prompt(1:)		!prompt
	call strip_(tmp,lim)
	write(6,'(/a$)')tmp(1:lim+1)
c
	read(5,'(a)',end=20,err=1) tmp
	call strip0_(tmp,lim)
	if (lim.eq.0) then		!empty answer, give first choice
	   choice(1)=first
	   goto 800
	endif
c
c	see if help wanted
c
	l=lim
	call uc_(tmp(1:4))
	if (tmp(1:4).eq.'HELP') then
	   help=.true.
	   choice(k)=-1
	   if (lim.eq.4) goto 800
	   l=5
	elseif (tmp(1:1).eq.'?') then
	   help=.true.
	   choice(k)=-1
	   if (lim.eq.1) goto 800
	   l=2
	endif
	l=l+1
	tmp(l:l)='/'
	do 5 k=1,nchoice
	   choice(k)=-999
5	continue
c
c	don't panic on error, goto 10
c
	read(tmp(1:),*,err=10) (choice(k),k=1,nchoice)
	do 6 k=1,nchoice
	   if (choice(k).eq.-999) goto 7
	   xchoice=k
6	continue
7	continue
	do 8 k=1,xchoice
	   if (choice(k).lt.first.or.
	1      choice(k).gt.first+noptions-1) then
cx	      call erase_page_(1,1)
	      tmp(1:)=' '
	      write(tmp(c:),10000)		!out of bounds
	      call strip_(tmp,lim)
cx	      write(6,'(1x,a/a)')char(7),tmp(1:lim)
	      call vtext_(tmp(1:lim),24,1,2)
	      call wait_(1.0)
cx	      call attoff
	      goto 1
	   endif
8	continue
	goto 800
c
c	not a number, give him/her a second chance, could be mnemonic
c
10	continue
c
	tmp(l:l)=' '
	call seetab_(options,noptions,choice(1),tmp(1:lim),1)
	if (choice(1).gt.0) then
	   choice(1)=choice(1)+first-1
	   goto 800
	endif
c
cx	call erase_page_(1,1)
	tmp(1:)=' '
	if (choice(1).eq.-1) then
	   write(tmp(c:),10002)
	else
	   write(tmp(c:),10001)
	endif
	call strip_(tmp,lim)
cx	write(6,'(1x,a/a)')char(7),tmp(1:lim)
	call vtext_(tmp(1:lim),24,1,2)
	call wait_(1.0)
cx	call attoff
	goto 1
c
c	^Z typed
c
20	continue
	rewind(5)
	tmp(1:)=' '
	xchoice=1
	choice(1)=first
	goto 800
c
c	errors
c	======
c
c	options must be >= 0
90	continue
	error=1
	goto 800
c
c	not enough room to show options
91	continue
	error=2
	goto 800
c
c	window too narrow to show options
92	continue
	error=3
	goto 800
c
c	the end
c
800	continue
	call erase_page_(1,1)
	return
c
c	formats
c	=======
c
	include 'fmt:seemenu.fmt'
c
	end
c
c
c
c
c
	subroutine strip_(text,lim)
	character*(*) text
	integer lim

	lim=istrip_(text)
	if (lim.le.0) lim=1
	return
	end

	subroutine strip0_(text,lim)
	character*(*) text
	integer lim

	lim=istrip_(text)
	return
	end
