	subroutine seetab_(table,top,pos,cmmnd,minchr)
c	**********************************************
c
	implicit none
c
	character*(*) table(*),cmmnd
	integer top,pos,minchr
c
c	Written by Luis Arriaga da Cunha 1984
c
c	Description
c	===========
c
c	Given  a  table of commands (identifiers)  in TABLE
c	up  to TOP, the string CMMND is  searched for until
c	a non-ambiguous possibly abbreviated match is found
c	(TABLE is supposed to be "uppercased"!!!!!!!!!!!!!).
c	If  found  POS gives where in  TABLE, otherwise POS
c	will be zero. If ambiguous  POS will be -1.  MINCHR
c	is the minimum number of characters CMMND MUST have,
c	otherwise POS will be -2.
c
c	CAUTION: as SEETAB uses a local copy of CMMND,if it
c	doesn't fit POS is returned = 0.
c
c	var
c	===
c
	external istrip_
	integer istrip_
c
	integer k,l,ls,lim,hit
	character*50 cmdtmp,tabtmp
c
c	begin
c	=====
c
	pos=0				!not found
c
	lim=istrip_(cmmnd)
	if     (lim.lt.minchr) then
	   pos=-2
	   return
	elseif (lim.gt.len(cmdtmp)) then
	   goto 1
	endif
c
	cmdtmp(1:)=' '			!local copy
	cmdtmp(1:)=cmmnd
	call uc8to7_(cmdtmp)
c
	hit=0
c
	do 1001 k = 1, top
	   tabtmp=table(k)
	   call uc8to7_(tabtmp)
	   l=index(tabtmp,cmdtmp(1:lim))
	   if (l.eq.1) then
	      pos=k
	      hit=hit+1
	      ls=istrip_(table(k))
	      if (ls.eq.lim) goto 1	!dont go further
	   endif
1001	continue
c
	if (hit.gt.1) then
	   pos=-1
	endif
c
1	continue
	return
c
c
	end
c
c
c
c
