c	stack.for
c	*********
c
c	Stack implementation for logical and arithmetic expressions
c
c	Written by Luis Arriaga da Cunha 1985
c	=====================================
c
c	Logical expression primitives:
c
c	push	(item,error)
c	pop	(item,error)
c	pzero	(error)
c
c	Arithmetic expression primitives:
c
c	apush	(item,error)
c	apop	(item,error)
c	apzero  (error)
c
c
c
c
	subroutine push_(item,error)
c	***************************
c
	implicit none
c
	integer item, error
c
c
c	var
c	===
c
	include 'own:stack.own'
c
c
c	begin
c	=====
c
	error=0
c
	if (index$.gt.stck$) goto 90001	!overflow
	store$(index$)=item
	index$=index$+1
	return
c
c	errors
c	======
c
c	stack overflow
90001	continue
	error=1
	return
c
c
	end
c
c
c
c
	subroutine pop_(item,error)
c	**************************
c
	implicit none
c
	integer item, error
c
c
c	var
c	===
c
	include 'own:stack.own'
c
c
c	begin
c	=====
c
	error=0
c
	index$=index$-1
	if (index$.le.0) goto 90001	!underflow
	item=store$(index$)
	return
c
c	errors
c	======
c
c	stack underflow
90001	continue
	index$=1
	error=1
	return
c
c
	end
c
c
c
c
	subroutine pzero_(error)
c	***********************
c
	implicit none
c
	integer item, error
c
c
c	var
c	===
c
	include 'own:stack.own'
c
c
c	begin
c	=====
c
	error=0
c
	index$=1
	return
c
c
	end
c
c
c
c
	subroutine apush_(item,error)
c	****************************
c
	implicit none
c
	integer item, error
c
c
c	var
c	===
c
	include 'own:stack.own'
c
c
c	begin
c	=====
c
	error=0
c
	if (andex$.gt.astck$) goto 90001	!overflow
	atore$(andex$)=item
	andex$=andex$+1
	return
c
c	errors
c	======
c
c	stack overflow
90001	continue
	error=1
	return
c
c
	end
c
c
c
c
	subroutine apop_(item,error)
c	***************************
c
	implicit none
c
	integer item, error
c
c
c	var
c	===
c
	include 'own:stack.own'
c
c
c	begin
c	=====
c
	error=0
c
	andex$=andex$-1
	if (andex$.le.0) goto 90001	!underflow
	item=atore$(andex$)
	return
c
c	errors
c	======
c
c	stack underflow
90001	continue
	andex$=1
	error=1
	return
c
c
	end
c
c
c
c
	subroutine apzero_(error)
c	************************
c
	implicit none
c
	integer item, error
c
c
c	var
c	===
c
	include 'own:stack.own'
c
c
c	begin
c	=====
c
	error=0
c
	andex$=1
	return
c
c
	end
c
c
c
c
