	program vms2rm
c	**************
c
	implicit none
c
c	Help to convert VMS fortran sources into RMFORTRAN.
c
c	Featuring now:
c
c	1. "_" become "$", unless within a string (eg 'a_b');
c	2. Comment sign "!..." becomes "<ret>c!...";
c	3. "Implicit none" statment becomes comment;
c	4. "<tab>1-9,*" becomes "bbbbb1bbb";
c	5. Within formats:	- "$" (prompt) becomes "\";
c				- x becomes 1x;
c	6. TYPE/ACCEPT become READ(*,/WRITE(*,;
c	7. PARAMETER without "(" is flagged;
c	8. ENDDO and WHILE are flagged;
c	   (only "ENDDO", "END DO" and "WHILE" strings are searched)
c	9. VMS variable formats (eg. <n>x, i<n>, f<m>.<n>) are flagged;
c
c	allows replacing/removing of sub-strings, e.g. 'own: a.b' -> 'a:a.b',
c	given in a file "VMS2RM.RPL":
c
c	own:		!replace own: by a:
c	a:
c	fmt:		!replace fmt: by nothing at all
c
c	bag		!replace bag: by c:
c	c:
c
c	Options:
c
c	- suppress all comment and blank lines
c	- "left justify" (almost) all lines, except if trailing blanks
c	- replace first 6 spaces by <tab>,     "    "      "      "
c	- lower case all the code (except strings)
c
c	var
c	===
c
	external istrip,trim
	integer istrip,trim
c
c
c	VMS2RM own file
c
c
	integer rplmax			!max # of strings to replace
	parameter (rplmax=50)
c
	integer
	1	log,			!output log file channel
	1	ichn,			!input file channel
	1	ochn,			!output file channel
	1	atchan,			!@file.ext channel
	1	tmpch,			!temp file channel
	1	contxt			!used by find_file, if msdos = .false.
c
	common/io/	log,ichn,ochn,atchan,tmpch,contxt
c
	logical	msdos,flipflop
	common/env/	msdos,flipflop
c
	character*150 line1,line2,warn,linetmp,mssg
	character*40 verb
	character*90 rplnam,ifnam,ofnam,ifspec,respec
	character*60 outdev,outext,tmpext,tmp
	character*20 inpstr(rplmax),outstr(rplmax)
	character*1  yesno,bell,nobell
	integer k,m,kkk,lim1,lim2,inpl,outl,beg,c1,l1,nstr,shift,ncomm,
	1       m1,m2,lim3,rplnbr
	integer nwarn,type,val,dec,lim,p1,p2,pos1,pos2,linsiz,rstpos,sz
	real rval
	integer	str1(10),str2(10),nf,locnf,erro
	logical ok,eow,eof,reset,at
c
	logical
	1	comment,	!.true. if comment line found
	1	spcfn,		!.true. if special comm. (!) found
	1	typefn,		!.true. if TYPE found
	1	parafn,		!.true. if PARAMETER without "(" found
	1	accefn,		!.true. if ACCEPT found
	1	dofn,		!.true. if DO found
	1	whilfn,		!.true. if WHILE found
	1	enddfn,		!.true. if ENDDO found
	1	iofmt,		!.true. if within format
	1	lcont,		!.true. if continuation line
	1	blnk,		!.true. if line has meaningless charact.
	1	newsiz,		!.true. if line was changed (diff. size)
	1	first		!temp...
c
	integer
	1	spcp1,		!where "!" ends
	1	typep2,		!where "TYPE" ends
	1	parap2,		!where "PARAMETER" ends
	1	accep2,		!where "ACCEPT" ends
	1	dop1,		!where "DO" starts
	1	whilp1,		!where "WHILE" starts
	1	enddp1,		!where "ENDDO" starts
	1	enddp2		!where "ENDDO" ends (may be "end do")
c
	integer
	1	ndo,		!# if DO found
	1	nenddo		!# of enddo found
c
	logical
	1	nocomm,		!.true.: no comments/blank lines
	1	noindent,	!.true.: no indents
	1	tabs,		!.true.: replace 6*' ' by <tab>
	1	lower,		!.true.: lower case everything
	1	rpl		!.true.: replace sub-strings
c
	data	rplnam/'vms2rm.rpl'/
c
c	begin
c	=====
c
	msdos=.false.		!VMS version
c
	bell=char(7)
	nobell=char(32)
c
	write (*,10001)
10001	format (//,
	1'                        *** VMS2RM ***',//,
	1'       Helps to translate VMS fortran ',
	1'programs into RMFORTRAN',/)
c
	nf=0		!total # of input files
	nwarn=0		!total # of warnings
c
c	Allocate i/o channels
c
	call newc(log)
	call newc(ichn)
	call newc(ochn)
	call newc(atchan)
	call newc(tmpch)
c
	if (msdos) then
	   open (log,file='VMS2RM.LOG',status='unknown',recl=250)
	else
	   open (log,file='VMS2RM.LOG',carriagecontrol='list',
	1        status='new',recl=250)
	endif
c
	rpl=.false.
	rplnbr=0
	k=0
c
	open (tmpch,file=rplnam,status='old',err=15)
	ok=.true.
	goto 16
15	continue
	ok=.false.
16	continue
c
	if (ok) then
c
	   write (*,10054) bell,rplnam(1:istrip(rplnam))
	   write (log,10054) nobell,rplnam(1:istrip(rplnam))
10054	   format (1x,a,/,
	1'          Sub-strings replacement (file "',a,'") :',/)
13	   continue
	      k=k+1
	      read (tmpch,'(a)',err=14,end=14) inpstr(k)
	      lim1=istrip(inpstr(k))
	      if (lim1.le.0) goto 14
	      read (tmpch,'(a)',err=14,end=14) outstr(k)
	      lim2=istrip(outstr(k))
	      if (lim2.le.0) lim2=1
	      write (*,'(15x,''"'',a,''"	-->  "'',a,''"'')') 
	1            inpstr(k)(1:lim1),
	1            outstr(k)(1:lim2)
	      write (log,'(15x,''"'',a,''"	-->  "'',a,''"'')') 
	1            inpstr(k)(1:lim1),
	1            outstr(k)(1:lim2)
	      goto 13
14	   continue
c
	   close (tmpch)
c
	   rplnbr=k-1
	   if (rplnbr.gt.0) rpl=.true.
c
	else
c
	   write (*,10055) bell,rplnam(1:istrip(rplnam))
	   write (log,10055) nobell,rplnam(1:istrip(rplnam))
10055	   format (1x,a,/,
	1'          Standard sub-strings replacement (file "',a,'"',
	1' not found) :',/)
c
	   inpstr(1)(1:)=' '
	   inpstr(1)(1:)='sys$input:'	!sys$input becomes "tt:"
	   outstr(1)(1:)=' '
	   outstr(1)(1:)='tt:'
c
	   inpstr(2)(1:)=' '
	   inpstr(2)(1:)='sys$output:'	!sys$output becomes "tt:"
	   outstr(2)(1:)=' '
	   outstr(2)(1:)='tt:'
c
	   inpstr(3)(1:)=' '
	   inpstr(3)(1:)='sys$login:'	!sys$login becomes " "
	   outstr(3)(1:)=' '
c
	   rpl=.true.
	   rplnbr=3
c
	   do 1011 k = 1, rplnbr
	      lim1=istrip(inpstr(k))
	      if (lim1.le.0) lim1=1	!??
	      lim2=istrip(outstr(k))
	      if (lim2.le.0) lim2=1
	      write (*,'(15x,''"'',a,''"	-->  "'',a,''"'')') 
	1            inpstr(k)(1:lim1),
	1            outstr(k)(1:lim2)
	      write (log,'(15x,''"'',a,''"	-->  "'',a,''"'')') 
	1            inpstr(k)(1:lim1),
	1            outstr(k)(1:lim2)
1011	   continue
c
	endif
c
1000	continue
c
	nocomm=.false.			!dont' get rid of comments & blank lines
	noindent=.false.		!don't "un-indent"
	tabs=.false.			!don't replace 1st 6 spaces by <tab>
	lower=.false.			!don't lowwer case the program
c
	write (*,10088)
10088	format (/,
	1' 	   display info ? (default is "n") : ',$)
c
	read (*,'(a)',end=1500) yesno
	lim1=istrip(yesno)
	if (lim1.le.0) goto 2000
	call uc(yesno)
	if (yesno.eq.'N') goto 10100
c
	write (*,10002)
10002	format (//////,
	1'	Standard:		- ',
	1'transform  "implicit none" into comment line',/,
	1'                      	  ',
	1'           "TYPE/ACCEPT"   into "READ(*,/WRITE(*,"',//,
	1'                      	- ',
	1'replace    "<tab>1" by "bbbbb1bbb" (cont. lines)',/,
	1'                      	  ',
	1'           "_"      by "$" within identifiers',/,
	1'                      	  ',
	1'           "$"      by "\" within formats (prompts)',/,
	1'                      	  ',
	1'           "x"      by "1x" within formats',//,
	1'                      	- ',
	1'flag       "PARAMETER" without "("',/,
	1'                      	  ',
	1'           "ENDDO", "END DO" and "WHILE"''s',/,
	1'                      	  ',
	1'            VMS "variable" formats (i<n>, ...)',//,
	1'	Options:		- ',
	1'suppress all comment and blank lines',/,
	1'                      	- ',
	1'"left justify" (almost) all lines',/,
	1'                      	- ',
	1'replace first 6 spaces by <tab>',/,
	1'                      	- ',
	1'lower case all the code (except strings)')
c
10100	continue
c
	write (*,10077)
10077	format (/,
	1' 	   do you want to use any of the options ? ',
	1'(default is "n") : ',$)
c
	read (*,'(a)',end=1500) yesno
	lim1=istrip(yesno)
	if (lim1.le.0) goto 2000
	call uc(yesno)
	if (yesno.eq.'N') goto 2000
c
	write (*,10010)
10010	format (/,
	1'      suppress all comment ',
	1'and blank lines ? ',$)
	read (*,'(a)',end=1500) yesno
	call uc(yesno)
	if (yesno.eq.'Y') nocomm =.true.
c
	write (*,10020)
10020	format (/,
	1'      "left justify" (almost) all lines ? ',$)
	read (*,'(a)',end=1500) yesno
	call uc(yesno)
	if (yesno.eq.'Y') noindent=.true.
c
	write (*,10030)
10030	format (/,
	1'      replace first 6 spaces by <tab> ? ',$)
	read (*,'(a)',end=1500) yesno
	call uc(yesno)
	if (yesno.eq.'Y') tabs=.true.
c
	write (*,10040)
10040	format (/,
	1'      lower case all the code (except strings) ? ',$)
	read (*,'(a)',end=1500) yesno
	call uc(yesno)
	if (yesno.eq.'Y') lower=.true.
c
2000	continue
c
c	Input/output file spec's
c
	flipflop=.false.
	reset=.true.
	locnf=0
	call inpout(reset,ifspec,at,outdev,outext,erro)
	if (erro.ne.0) goto 1500		!^Z
	reset=.false.
c
c	Loop here
c
	eow=.false.
c
	call nxtfil(ifspec,at,respec,eof)
c
cwhile	do while (.not.eow)
1009	continue
	   if (eow) goto 1010
c
	   if (eof) goto 40
c
c	   input file
c
	   ifnam(1:)=' '
	   ifnam=respec
c
c	   output file = input file name + output extension
c
	   tmp(1:)=' '
	   tmp=respec
c
	   if (msdos) then
	      lim3=index(tmp,':')
	      if (lim3.gt.0) tmp(1:)=tmp(lim3+1:)	!get rid of dev:[...]
	      lim3=index(tmp,'\')
	      if (lim3.gt.0) lim3=index(tmp,'/')
	      if (lim3.gt.0) tmp(1:)=tmp(lim3+1:)	!and directory
	   else
	      lim3=index(tmp,']')
	      if (lim3.le.0) lim3=index(tmp,':')
	      if (lim3.gt.0) tmp(1:)=tmp(lim3+1:)	!get rid of dev:[...]
	      lim3=index(tmp,';')
	      if (lim3.gt.0) tmp(lim3:)=' '		!and version#
	   endif
c
	   ofnam(1:)=' '
	   lim3=istrip(outdev)
	   if (lim3.le.0) then
	      lim3=1
	   else
	      ofnam(1:)=outdev(1:lim3)
	      lim3=lim3+1
	   endif
c
	   ofnam(lim3:)=tmp
c
	   call givext(ofnam,outext)
c
c	   Say him (or her)
c
	   lim1=istrip(ifnam)
	   if (lim1.le.0) lim1=1
	   lim2=istrip(ofnam)
	   if (lim2.le.0) lim2=1
c
	   write (*,'('' *** '',a,''	-->	'',a)')
	1            ifnam(1:lim1),ofnam(1:lim2)
	   write (log,'(/,'' *** '',a,''	-->	'',a)')
	1            ifnam(1:lim1),ofnam(1:lim2)
c
c	   open input/output files
c
	   inpl=0
	   outl=0
	   if (msdos) then
	      open (ichn,file=ifnam,status='old',err=35)
	      open (ochn,file=ofnam,
	1           status='unknown',recl=250,err=36)
	   else
	      open (ichn,file=ifnam,
	1           carriagecontrol='list',
	1           status='old',err=35)
	      open (ochn,file=ofnam,carriagecontrol='list',
	1           status='new',recl=250,err=36)
	   endif
c
	   nf=nf+1
	   locnf=locnf+1
c
	   ndo=0
	   nenddo=0
c
	   iofmt=.false.
c
c	   loop here within file
c
20	      continue
c
	      comment=.false.
	      lcont=.false.
	      spcfn=.false.
	      typefn=.false.
	      parafn=.false.
	      accefn=.false.
	      dofn=.false.
	      whilfn=.false.
	      enddfn=.false.
	      newsiz=.false.
c
	      if (msdos) then
	         read (ichn,'(a)',end=30,err=35) line1
	         inpl=inpl+1
	         lim1=istrip(line1)
	         linsiz=lim1
	      else
	         read (ichn,'(q,a)',end=30,err=35) linsiz,line1
	         inpl=inpl+1
	         lim1=istrip(line1)
	      endif
c
	      if (lim1.lt.linsiz) then
	         blnk=.true.		!blanks (.....8H    )
	      else
	         blnk=.false.
	      endif
c
	      if (lim1.le.0) then
c
c	         empty line, treat as comment
c
	         line2(1:)=' '
	         comment=.true.
c
	      else
c
c		 got a line
c
c	         === comment lines ===
c
	         if (line1(1:1).eq.'C'.or.
	1               line1(1:1).eq.'c'.or.
	1               line1(1:1).eq.'*'   ) then
	            comment=.true.			!regular comment line
	            line2(1:)=' '
	            line2=line1(1:lim1)
	         endif
c
	         if (.not.comment) then		!*** .not. comment
c
	         lim3=trim(line1)
	         if (lim3.gt.0) then
	            if (line1(lim3:lim3).eq.'!') then
	               comment=.true.		!special comment line
	               line2(1:)=' '
	               line2=line1(1:lim1)
	               line2(1:1)='c'
	            endif
	         endif
c
	         endif				!*** .not. comment
c
	         if (.not.comment) then		!*** .not. comment
c
	         if     (lim1.ge.2.and.
	1                line1(1:1).eq.'	') then
c
c	            === <tab>1-9 (cont. lines) ===
c
	            read (line1(2:2),'(i1)',err=345) kkk
	            if (kkk.le.0) goto 345
	            line2(6:6)=line1(2:2)	!continuation line
	            line2(1:5)='     '		!bbbbb
	            line2(7:9)='   '		!same format as before
	            line2(10:)=line1(3:lim1+1)
	            lcont=.true.
	            newsiz=.true.		!line has new size
	            goto 346
c
345	            continue
	            line2=line1(1:lim1)		!just copy the line
	            goto 346
c
	         elseif (.not.blnk.and.
	1                 tabs.and.lim1.ge.6.and.
	1                 line1(1:6).eq.'      ' ) then
c
c	            === multiple (6) spaces ===
c
	            line2(1:1)='	'		!a tab
	            line2(2:)=line1(7:lim1+1)
	            newsiz=.true.			!line has new size
c
	         else
c
c	            === neither ===
c
	            do 1001 k = 1, 6
	             if (line1(k:k).eq.'	') goto 300
1001	            continue
c
c	            === standard continuation lines ===
c
	            if (line1(6:6).ne.' ') lcont=.true.
c
300	            continue
c
	            line2=line1(1:lim1)		!just copy the line
c
	         endif
c
346	         continue
c
	         endif				!*** .not. comment
c
c	         === strings, "_" (identifiers), "$" (prompt)  ===
c	             FORMAT, ACCEPT, TYPE, DO, WHILE, ENDDO,
c		     IMPLICIT NONE and x within formats
c
	         if (.not.lcont.and..not.comment) iofmt=.false.
c
	         linetmp(1:)=' '		!use a copy, line may
	         linetmp=line2			!come back changed...
c
	         nstr=0
	         first=.true.
	         beg=1
	         call rstok(linetmp,beg,erro)
200	         continue
	            erro=0
	            call intok(type,val,dec,rval,linetmp,lim,
	1                          p1,p2,mssg,erro)
	            pos1=p1
	            pos2=p2
c
	            if (.not.comment) then	!*** .not. comment
c
	            if     (type.eq.1.and.first) then
c
c	               forget it if xpto = ...
c
	               rstpos=pos2+1
	               erro=0
	               call intok(type,val,dec,rval,linetmp,lim,
	1                          p1,p2,mssg,erro)
	               call rstok(linetmp,rstpos,erro)	!recover position
c
	               if (type.ne.9) then	!not "="
c
	                  sz=pos2-pos1+1
	                  if (sz.le.0) sz=1	!...
	                  first=.false.
	                  verb(1:)=' '
	                  verb(1:sz)=linetmp(pos1:pos2)
	                  call uc(verb(1:sz))
c
c	                  FORMAT
c
	                  if (.not.lcont) then
	                     if (sz.eq.6.and.
	1                        verb(1:sz).eq.'FORMAT') iofmt=.true.
	                  endif
c
c	                  TYPE, ACCEPT, WHILE, ENDDO, END DO
c
	                  if (.not.iofmt) then
c
	                     if     (sz.eq.4.and.
	1                            verb(1:sz).eq.'TYPE') then
c
	                        typefn=.true.
	                        typep2=pos2
c
	                     elseif (sz.eq.6.and.
	1                            verb(1:sz).eq.'ACCEPT') then
c
	                        accefn=.true.
	                        accep2=pos2
c
	                     elseif (sz.eq.2.and.
	1                            verb(1:sz).eq.'DO') then
c
	                        dofn=.true.
	                        dop1=pos1
c
	                        erro=0
	                        call intok(type,val,dec,rval,
	1                                  linetmp,
	1                                  lim,p1,p2,mssg,erro)
	                          pos1=p1
	                          pos2=p2
c
	                        if (type.eq.1) then	!identifier
c
	                           verb(1:)=' '
	                           verb=linetmp(pos1:pos2)
	                           call uc(verb)
	                           if (verb(1:6).eq.'WHILE ') then
	                              whilfn=.true.
	                              whilp1=pos1		!starts here
	                           else
	                              beg=pos2+1
	                              call rstok(linetmp,beg,erro)
	                           endif
c
	                        elseif (type.eq.2) then	!integer, DO 100
c
	                           dofn=.false.
	                           beg=pos2+1
	                           call rstok(linetmp,beg,erro)
c
	                        endif
c
	                     elseif (sz.eq.8.and.
	1                            verb(1:sz).eq.'IMPLICIT') then
c
	                        erro=0
	                        call intok(type,val,dec,rval,
	1                                  linetmp,
	1                                  lim,p1,p2,mssg,erro)
	                          pos1=p1
	                          pos2=p2
c
	                        if (type.eq.1) then	!identifier
c
	                           verb(1:)=' '
	                           verb=linetmp(pos1:pos2)
	                           call uc(verb)
	                           if (verb(1:4).eq.'NONE') then
	                              comment=.true.	!special comment line
	                              line2(1:1)='c'
	                              line2(2:)=' '
	                              line2(2:)=line1
	                           else
	                              beg=pos2+1
	                              call rstok(linetmp,beg,erro)
	                           endif
c
	                        endif
c
	                     elseif (sz.eq.5.and.
	1                            verb(1:sz).eq.'ENDDO') then
c
	                        enddfn=.true.
	                        enddp1=pos1		!enddo starts here
	                        enddp2=pos2		!and ends here
c
	                     elseif (sz.eq.3.and.
	1                            verb(1:sz).eq.'END') then
c
	                        enddp1=pos1		!end do starts here
c
	                        erro=0
	                        call intok(type,val,dec,rval,
	1                                  linetmp,
	1                                  lim,p1,p2,mssg,erro)
	                        pos1=p1
	                        pos2=p2
	                        verb(1:)=' '
	                        verb=linetmp(pos1:pos2)
	                        call uc(verb)
	                        if (verb(1:sz).eq.'DO ') then
	                           enddfn=.true.
	                           enddp2=pos2		!end do ends here
	                        else
	                           beg=pos2+1
	                          call rstok(linetmp,beg,erro)
	                        endif
c
	                     elseif (sz.eq.9.and.
	1                            verb(1:sz).eq.'PARAMETER') then
c
	                        parap2=pos2		!parameter ends here
c
	                        erro=0
	                        call intok(type,val,dec,rval,
	1                                  linetmp,
	1                                  lim,p1,p2,mssg,erro)
	                        pos1=p1
	                        pos2=p2
c
	                        if (type.ne.6) then	!not "("
	                           parafn=.true.
	                        endif
c
	                        beg=pos2+1
	                        call rstok(linetmp,beg,erro)
c
	                     endif
c
	                  endif
c
	              endif
c
	            elseif (type.eq.24) then	!identifier with "_"
c
600	               continue
c
	                  c1=index(line2(pos1:pos2),'_')
	                  if (c1.le.0) goto 650
	                  line2(pos1+c1-1:pos1+c1-1)='$'
	                  goto 600		!loop for more
c
650	               continue
c
	            elseif (type.eq.25) then	!"$"
	               if (iofmt) then	!within format
	                  line2(pos1:pos2)='\'
	               endif
c
	            elseif (type.eq.42) then	!"!"
	               if (.not.spcfn) then	!only the first one
	                  spcfn=.true.
	                  spcp1=pos1
	               endif
	            endif
c
c	            === "(x,", ",x," or ",x)" within format ? ===
c
	            if     (type.eq.1.and.
	1                      iofmt         ) then
c
	               if (pos1.eq.pos2.and.
	1                  pos1.gt.1       ) then
	                  if (linetmp(pos1:pos2).eq.'X'.or.
	1                     linetmp(pos1:pos2).eq.'x'    ) then
	                     if ( (linetmp(pos1-1:pos1-1).eq.'('.and.
	1                          linetmp(pos1+1:pos1+1).eq.','    )
	1                                     .or.
	1                           (linetmp(pos1-1:pos1-1).eq.','.and.
	1                          linetmp(pos1+1:pos1+1).eq.','    )
	1                                     .or.
	1                           (linetmp(pos1-1:pos1-1).eq.','.and.
	1                          linetmp(pos1+1:pos1+1).eq.')'    ) )
	1                                     then
	                        lim2=istrip(line2)
	                        do 1002 k = lim2, pos2+1, -1
	                           linetmp(k+1:k+1)=linetmp(k:k)
	                           line2(k+1:k+1)=line2(k:k)
1002	                        continue
	                        line2(pos2+1:pos2+1)=line2(pos2:pos2)
	                        line2(pos2:pos2)='1'
	                        beg=pos2+1
	                        call rstok(linetmp,beg,erro)
	                        newsiz=.true.		!line has new size
	                     endif
	                  endif
	               endif
c
	            endif
c
	            endif			!*** .not. comment
c
c	            Keep track of ALL strings
c
	            if (type.eq.5) then	!string
c
	               nstr=nstr+1
	               str1(nstr)=pos1
	               str2(nstr)=pos2
c
	            endif
c
	            if (type.ne.0) goto 200	!while .not. eol
c
	         continue
c
	         if (.not.comment) then		!*** .not. comment
c
	         if (spcfn) then
c
c	            === special comment sign ("!") ===
c
	            if (nocomm) then		!no comments, please
	               line2(spcp1:)=' '
	            else
	               lim2=istrip(line2(spcp1+1:))
	               if (lim2.le.0) lim2=1
	               if (lower) then
	                  call lc(line2(spcp1+1:spcp1+lim2))
	               endif
	               write (ochn,'(''c!'',a)',err=36)
	1                     line2(spcp1+1:spcp1+lim2)
	               outl=outl+1
	               line2(spcp1:)=' '
	            endif
	         endif
c
	         if (typefn.or.accefn) then
c
c	            === TYPE or ACCEPT ===
c
	            if (typefn) then
	               c1=typep2	!ending position within line2
	            else
	               c1=accep2	!ending position within line2
	            endif
c
	            k=index(line2,',')
	            if (k.ne.0) then
	               line2(k:k)=')'
	            else
	               m=istrip(line2)
	               m=m+1
	               line2(m:m)=')'
	            endif
c
	            lim2=istrip(line2)
	            if (lim2.eq.0) lim2=1
	            if (typefn) then
	               line2=line2(1:c1-4)//'WRITE(*,'//line2(c1+1:lim2)
	            else
	               line2=line2(1:c1-6)//'READ(*,'//line2(c1+1:lim2)
	            endif
c
	            newsiz=.true.		!line has new size
c
	         endif
c
	         endif				!*** .not. comment
c
	         if (rpl.or.lower) then
c
c	         Sub-string replacement and lower case
c
	            if (rpl) then
c
c	               === sub-string replacement, inside all strings  ===
c
	               do 1005 k = 1, nstr		!for all strings
c
	                  do 1006 kkk = 1, rplnbr	!strings to replace
	                     call replac(line2(str1(k):),str2(k),
	1                                inpstr(kkk),outstr(kkk),
	1                                shift)
	                     if (shift.ne.0) then
	                        str2(k)=str2(k)+shift
	                        do 1007 m = k+1, nstr
	                           str1(m)=str1(m)+shift
	                           str2(m)=str2(m)+shift
1007	                        continue
	                        newsiz=.true.		!line has new size
	                     endif
1006	                  continue
c
1005	               continue
c
	            endif
c
	            if (lower) then
c
c	               === lower case everything but the strings ===
c
	               if (nstr.le.0) then
	                  lim2=istrip(line2)
	                  if (lim2.gt.0) call lc(line2(1:lim2))
	               else
	                  m1=1
	                  m2=str1(1)-1
	                  if (m2.ge.m1) call lc(line2(m1:m2))
	                  do 1008 k = 1, nstr-1
	                     m1=str2(k)+1
	                     m2=str1(k+1)-1
	                     if (m2.ge.m1) call lc(line2(m1:m2))
1008	                  continue
	                  m1=str2(nstr)+1
	                  m2=istrip(line2)	                  
	                  if (m2.ge.m1) call lc(line2(m1:m2))
c
	               endif
c
	            endif
c
	         endif
c
	      endif
c
	      if (comment.and.nocomm) then
	         ncomm=ncomm+1
	      else
c
	         if (.not.blnk.and.
	1             noindent    ) then
c
c	            === suppress indents ===
c
	            if (lcont) then
	               c1=trim(line2(9:))
	               if (c1.gt.1) then
	                  newsiz=.true.		!line has new size
	                  line2(9:)=line2(c1+8:)	         
	               endif
	            elseif (line2(1:1).eq.'	') then
	               c1=trim(line2(2:))
	               if (c1.gt.1) then
	                  newsiz=.true.		!line has new size
	                  line2(2:)=line2(c1+1:)	         
	               endif
	            endif
	         endif
c
c	         write output line
c
	         if (blnk.and..not.newsiz) then
	            lim2=linsiz
	         else
	            lim2=istrip(line2)
	         endif
	         if (lim2.le.0) lim2=1
c
	         write (ochn,'(a)',err=36) line2(1:lim2)
	         outl=outl+1
c
c	         Variable formats
c	         ----------------
c
	         if (.not.comment) then
c
	            if (lim2.gt.1) then
	               linetmp(1:)=' '
	               linetmp(1:lim2)=line2(1:lim2)
	               call uc(linetmp(1:lim2))
	               if (index(linetmp(1:lim2),
	1                  'I<').gt.0.or.
	1                  index(linetmp(1:lim2),
	1                  '>X').gt.0.or.
	1                  index(linetmp(1:lim2),
	1                  'F<').gt.0    ) then
	                  warn(1:)=' '
	                  warn(1:8)='   lines'
	                  write (warn(10:),456) inpl,outl
456	                  format (i7.0,'  -->',i7.0,
	1                         ' : "variable formats"')
	                  lim3=istrip(warn)
	                  if (lim3.le.0) lim3=1
	                  write (*,'(a)') warn(1:lim3)
	                  write (log,'(a)') warn(1:lim3)
	                  nwarn=nwarn+1
	               endif
	            endif
c
	            if (parafn) then
c
c	            === PARAMETER without "(" ===
c
	               warn(1:)=' '
	               warn(1:8)='   lines'
	               write (warn(10:),7788) inpl,outl
7788	               format (i7.0,'  -->',i7.0,
	1                      ' : PARAMETER without "("')
	               lim3=istrip(warn)
	               if (lim3.le.0) lim3=1
	               write (*,'(a)') warn(1:lim3)
	               write (log,'(a)') warn(1:lim3)
	               nwarn=nwarn+1
c
	            endif
c
	            if (dofn.or.enddfn) then
c
c	               === DO, DO WHILE or ENDDO ===
c
	               warn(1:)=' '
	               warn(1:8)='   lines'
	               write (warn(10:),567) inpl,outl
567	               format (i7.0,'  -->',i7.0,
	1                      ' : DO/WHILE/ENDDO')
	               lim3=istrip(warn)
	               if (lim3.le.0) lim3=1
	               write (*,'(a)') warn(1:lim3)
	               write (log,'(a)') warn(1:lim3)
	               nwarn=nwarn+1
c
	            endif
c
	         endif
c
	      endif
c
	      if (newsiz.and.blnk) then
c
	         warn(1:)=' '
	         warn(1:8)='   lines'
	         write (warn(10:),890) inpl,outl
890	         format (i7.0,'  -->',i7.0,
	1                 ' : line with trailing blanks ',
	1                     'has been changed')
	         lim3=istrip(warn)
	         if (lim3.le.0) lim3=1
	         write (*,'(a)') warn(1:lim3)
	         write (log,'(a)') warn(1:lim3)
	         nwarn=nwarn+1
	      endif
c
	      goto 20		!read next line
c
c	      end-of-file
c
30	      continue
c
	      close (ichn)
	      close (ochn)
c
	      write (*,371) inpl,outl
	      write (log,372) inpl,outl
371	      format (/,10x,' input / output lines : ',i5,' /',i5,/)
372	      format (/,10x,' input / output lines : ',i5,' /',i5)
c
	      goto 40
c
35	      continue
	      lim1=istrip(ifnam)
	      if (lim1.le.0) lim1=1
	      write (*,351) bell,ifnam(1:lim1)
	      write (log,351) nobell,ifnam(1:lim1)
351	      format (1x,a,' ?Problems accessing "',a,'"',/)
c
	      eof=.true.
	      flipflop=.false.
	      reset=.true.
	      goto 40
c
36	      continue
	      lim1=istrip(ofnam)
	      if (lim1.le.0) lim1=1
	      write (*,361) bell,ofnam(1:lim1)
	      write (log,361) nobell,ofnam(1:lim1)
361	      format (1x,a,' ?Problems writing "',a,'"',/)
c
	      eof=.true.
	      flipflop=.false.
	      reset=.true.
	      goto 40
c
40	      continue
c
	      if (eof) then
c
	         if (locnf.le.0) then
	            lim1=istrip(ifspec)
	            if (lim1.le.0) lim1=1
	            write (*,678) bell,ifspec(1:lim1)
	            write (log,678) nobell,ifspec(1:lim1)
678	            format (1x,a,/,'   %No match for "',a,'"')
	            flipflop=.false.
	            reset=.true.
	         else
	            reset=.false.
	            locnf=0
	         endif
	         call inpout(reset,ifspec,at,outdev,outext,
	1                    erro)
	         if (erro.ne.0) goto 1500		!^Z
c
	      else
c
	         if (ndo.ne.nenddo) then
	            write (*,789) bell,ndo,nenddo
	            write (log,789) nobell,ndo,nenddo
789	            format (1x,a,' ?# of "DO''s" .ne. # of "ENDDO''s" : ',
	1                   2i4,/)
	         endif
c
	      endif
c
	   call nxtfil(ifspec,at,respec,eof)
c
	   goto 1009
c
cwhile	enddo
1010	continue
c
1500	continue
c
	write (*,10022) nf
	write (log,10022) nf
10022	format (/,' 	= total # of files converted : ',i4,' =')
c
	if (nwarn.gt.0) then
	   write (*,10023) bell
10023	   format (1x,a,/,
	1' 	***** conversion problems, see log file *****')
	endif
c
	write (*,'(/''  Log file in VMS2RM.LOG''/)')
c
c	The end
c
	close (log)
	close (atchan)
c
	call freec(log)
	call freec(ichn)
	call freec(ochn)
	call freec(atchan)
	call freec(tmpch)
c
	stop
c
	end
c
c
c
c
	subroutine replac(line,lim,istr,ostr,shift)
c
	implicit none
c
	character*(*) line,istr,ostr
	integer shift,lim
c
c	Replace, if it exists, string ISTR by string OSTR, in string LINE.
c	Search for string ISTR in LINE(1:LIM).
c	Returns SHIFT = characters shifted.
c
	external istrip
	integer istrip
c
c	VMS2RM own file
c
c
	integer rplmax			!max # of strings to replace
	parameter (rplmax=50)
c
	integer
	1	log,			!output log file channel
	1	ichn,			!input file channel
	1	ochn,			!output file channel
	1	atchan,			!@file.ext channel
	1	tmpch,			!temp file channel
	1	contxt			!used by find_file
c
	common/io/	log,ichn,ochn,atchan,tmpch,contxt
c
	integer l,mylim,first,last,diff,k,lis,los
	character*132 linetmp,strtmp
c
	shift=0
	mylim=lim
c
	if (mylim.le.0) return
c
	lis=istrip(istr)	
	if (lis.le.0) return
c
	strtmp(1:lis)=istr(1:lis)
	call uc(strtmp(1:lis))
c
10	continue
c
	if (mylim.le.0) return		!just in case...?
c
	linetmp(1:mylim)=line(1:mylim)
	call uc(linetmp(1:mylim))
	l=index(linetmp(1:mylim),strtmp(1:lis))
	if (l.le.0) return
c
	los=istrip(ostr)
cxc
cx	if (los.le.0) then		!just suppress it
cx	   line(l:)=line(l+lis:)
cx	   shift=shift-lis
cx	   mylim=mylim-lis
cx	   goto 10			!all of them!
cx	endif
c
	if (los.le.0) los=1
c
	diff=los-lis
	shift=shift+diff
	mylim=mylim+diff
	if (diff.gt.0) then		!doesn't fit
	   last=istrip(line)
	   first=l+lis
	   do 1001 k = last, first, -1	!room, please
	      line(k+diff:k+diff)=line(k:k)
1001	   continue
	   line(l:l+los-1)=ostr(1:los)
	else				!ok, go
	   line(l:l+los-1)=ostr(1:los)
	   if (diff.ne.0) then
	      line(los+1:)=line(lis+1:)
	   endif
	endif
c
	goto 10				!all of them!
c
	end
c
c
c
c
	subroutine inpout(first,ifspec,at,outdev,outext,erro)
c
	implicit none
c
	character*(*) ifspec,outdev,outext
	integer erro
	logical at,first
c
c	Ask user for input file spec and output device and extension.
c
c	Return AT = .true. if "@file.ext".
c
c	ERRO .ne. 0 if "^Z".
c
	external istrip,trim
	integer istrip,trim
c
c	VMS2RM own file
c
c
	integer rplmax			!max # of strings to replace
	parameter (rplmax=50)
c
	integer
	1	log,			!output log file channel
	1	ichn,			!input file channel
	1	ochn,			!output file channel
	1	atchan,			!@file.ext channel
	1	tmpch,			!temp file channel
	1	contxt			!used by find_file
c
	common/io/	log,ichn,ochn,atchan,tmpch,contxt
c
	logical	msdos,flipflop
	common/env/	msdos,flipflop
c
	integer lim1,lim2
	character*60 tmpchr,fnam,idev
	character*20 ifext
c
	erro=0
	contxt=0
c
	write (*,10080)
10080	format (/,1x,'	= ^Z to quit =')
c
	if (first) then
	   idev(1:)=' '
	   ifspec(1:)=' '
10	   write (*,10010)
10010	   format (/,
	1   ' 	 Location of input file(s)   : ',$)
	   read (*,'(a)',end=100,err=10) tmpchr
	   lim1=istrip(tmpchr)
	   if (lim1.le.0) then
	      lim2=1
	   else
	      call uc(tmpchr(1:lim1))
	      ifspec(1:)=tmpchr
	      lim2=lim1+2
	   endif
	   idev=tmpchr
	else
	   tmpchr(1:)=' '
	   tmpchr=idev
	   lim2=istrip(tmpchr)+2
	endif
c
20	continue
c
	if (msdos) then
	   write (*,10220)
10220	   format (/,
	1'          Next file to convert, or @file.ext : ',$)
	else
	   if (first) then
	      write (*,10120)
10120	      format (
	1'          input file(s) to convert, or @file.ext',/,
	1'                               (default is *.FOR) : ',$)
	   else
	      write (*,10020)
10020	      format (/,
	1'          Next file(s) to convert, or @file.ext',/,
	1'                              (default is *.FOR) : ',$)
	   endif
	endif
c
	read (*,'(a)',end=100,err=20) tmpchr
	lim1=istrip(tmpchr)
	if (lim1.le.0) then
	   at=.false.
	   if (msdos) then
	      write (*,10080)
	      goto 20
	   else
	      ifspec(lim2:)='*.FOR'			!default is "*.FOR"
	   endif
	else
	   if (tmpchr(1:1).eq.'@') then
	      close (atchan)
	      open (atchan,file=tmpchr(2:lim1),
	1           status='old',err=21)
	      at=.true.
	      goto 22
21	      continue
	      write (*,10021) tmpchr(2:lim1)
10021	      format (/,' % Can''t open file "',a,'", try again')
	      goto 20
22	      continue
	   else						!either a.b or *.b
	      at=.false.
	      call uc(tmpchr(1:lim1))
	      ifspec(lim2:)=tmpchr
	   endif
	endif
c
30	continue
c
	if (first) then
c
	   write (*,10030)
10030	   format (/,
	1' 	 Location of output files  : ',$)
	   read (*,'(a)',end=100,err=30) outdev
c
	   outext(1:)=' '
c
40	   write (*,10040)
10040	   format (
	1' 	 extension of output files (default is ".RMF") : ',$)
	   read (*,'(a)',end=100,err=40) tmpchr
	   if (istrip(tmpchr).le.0) then
	      outext='.RMF'
	   else
	      lim1=trim(tmpchr)
	      if (lim1.gt.1) tmpchr(1:)=tmpchr(lim1:)
	      if (tmpchr(1:1).ne.'.') then
	         outext(1:1)='.'
	         outext(2:)=tmpchr
	      else
	         outext=tmpchr
	      endif
	   endif
c
	endif
c
c	Default extension is ".FOR"
c
	lim1=index(ifspec,']')
	if (lim1.le.0) lim1=index(ifspec,':')
	if (lim1.le.0) then
	   lim2=index(ifspec,'.')
	else
	   lim2=index(ifspec(lim1:),'.')
	endif
c
	if (lim2.le.0) call givext(ifspec,'.FOR')
c
	return
c
c	^Z
100	continue
	erro=1
	return
c
	end
c
c
c
c
	subroutine nxtfil(fspec,at,respec,eof)
c
	implicit none
c
	character*(*) fspec,respec
	logical at,eof
c
c	Returns RESPEC = next file to convert if EOF=.false.
c
c	AT = .false.	Ask system to return next file.
c	   = .true.	Read file name from i/o channel ATCHAN
c
	external istrip
	integer istrip
	integer lim1,lim2
c
c	VMS2RM own file
c
c
	integer rplmax			!max # of strings to replace
	parameter (rplmax=50)
c
	integer
	1	log,			!output log file channel
	1	ichn,			!input file channel
	1	ochn,			!output file channel
	1	atchan,			!@file.ext channel
	1	tmpch,			!temp file channel
	1	contxt			!used by find_file
c
	common/io/	log,ichn,ochn,atchan,tmpch,contxt
c
	respec(1:)=' '
	eof=.false.
c
	if (at) then
10	   continue
	   read (atchan,'(a)',err=10,end=100) respec
	   if (istrip(respec).le.0) goto 10
c
c	   Default extension is ".FOR"
c
	   lim1=index(respec,']')
	   if (lim1.le.0) lim1=index(respec,':')
	   if (lim1.le.0) then
	      lim2=index(respec,'.')
	   else
	      lim2=index(respec(lim1:),'.')
	   endif
c
	   if (lim2.le.0) call givext(respec,'.FOR')

	else
	   call findfile(fspec,respec,contxt,eof)
	endif
c
	call uc(respec)
c
	return
c
100	continue
c
	eof=.true.
	return
c
	end
c
c
c
c
	subroutine inchr(chr,kind,buffer,pos,eol)
c	*****************************************
c
	implicit none
c
	character*1 chr
	integer kind,pos
	character*(*) buffer
	logical eol
c
c	Written by Luis Arriaga da Cunha 1984
c
c	Description
c	===========
c
c	From  BUFFER, characters are given back one at a
c	time until end of buffer,when  EOL  becomes true.
c	The character given back will be in position POS
c	in BUFFER. KIND is  the class  of  character  as
c	shown below, typically 	telling   whether  it is
c	a  digit, letter, etc.
c	If  POS  comes in (achtung!!) as zero user wants
c	to start at the beginning of BUFFER !!!
c
c	var
c	===
c
	external istrip
	integer istrip
c
	integer top
	save top
	integer class(0:255),k
c
	logical first
	data first/.true./
c
cc	data
cc     1        class(0)/1/
cc     1      , class(ichar(' ')),class(ichar('	'))/2*1/
cc     1      ,(class(k),k=ichar('A'),ichar('Z'))/26*2/
cc     1      ,(class(k),k=ichar('a'),ichar('z'))/26*2/
cc     1      ,(class(k),k=ichar('0'),ichar('9'))/10*3/
cc     1      , class(ichar(''''))/4/
cc     1      , class(ichar('('))/5/
cc     1      , class(ichar(')'))/6/
cc     1      , class(ichar(','))/7/
cc     1      , class(ichar('='))/8/
cc     1      , class(ichar('*'))/9/
cc     1      , class(ichar('/'))/10/
cc     1      , class(ichar('+'))/11/
cc     1      , class(ichar('-'))/12/
cc     1      , class(ichar('?'))/13/
cc     1      , class(ichar('<'))/14/
cc     1      , class(ichar('>'))/15/
cc     1      , class(ichar(':'))/16/
cc     1      , class(ichar('@'))/17/
cc     1      , class(ichar('^'))/18/
cc     1      , class(ichar('.'))/19/
cc     1      , class(ichar('_'))/20/
cc     1      , class(ichar('$'))/21/
cc     1      , class(ichar('%'))/22/
cc     1      , class(ichar('['))/23/
cc     1      , class(ichar(']'))/24/
cc     1      , class(ichar('#'))/25/
cc     1      , class(ichar('!'))/26/
cc     1      ,(class(k),k=161,253)/93*2/	!8 bit characters
c
c	begin
c	=====
c
	if (first) then
	   first=.false.
c
	   class(0)=1
	   class(ichar(' '))=1
	   class(ichar('	'))=1
	   do 1001 k = ichar('A'), ichar('Z')
	      class(k)=2
1001	   continue
	   do 1002 k = ichar('a'), ichar('z')
	      class(k)=2
1002	   continue
	   do 1003 k = ichar('0'), ichar('9')
	      class(k)=3
1003	   continue
	   class(ichar(''''))=4
	   class(ichar('('))=5
	   class(ichar(')'))=6
	   class(ichar(','))=7
	   class(ichar('='))=8
	   class(ichar('*'))=9
	   class(ichar('/'))=10
	   class(ichar('+'))=11
	   class(ichar('-'))=12
	   class(ichar('?'))=13
	   class(ichar('<'))=14
	   class(ichar('>'))=15
	   class(ichar(':'))=16
	   class(ichar('@'))=17
	   class(ichar('^'))=18
	   class(ichar('.'))=19
	   class(ichar('_'))=20
	   class(ichar('$'))=21
	   class(ichar('%'))=22
	   class(ichar('['))=23
	   class(ichar(']'))=24
	   class(ichar('#'))=25
	   class(ichar('!'))=26
	   do 1004 k = 161, 253
	      class(k)=2
1004	   continue
c
	endif
c
	top=istrip(buffer)
	if (pos.eq.0) then
	   eol=.false.
	endif
c
	pos=pos+1
	if (pos.gt.top) then
	   eol=.true.
	   pos=0
	   chr=' '
	   kind=0
	else
	   chr=buffer(pos:pos)
	   k=ichar(chr)
	   kind=class(k)
	endif
c
	return
c
c
	end
c
c
c
c
	subroutine rstok(buffer,str,erro)
c	*********************************
c
	implicit none
c
	integer str,erro
	character*(*) buffer
c
c	Written by Luis Arriaga da Cunha 1984
c
c	Description
c	===========
c
c	BUFFER is reset (hence the name of the procedure...)
c	for  lexical  analysis  by  INTOK and the like. That
c	analysis  will  start  at position STR of the buffer.
c	To  start  from the beginning use STR = 1, of course.
c
c	var
c	===
c
	character*1 chr
	integer k,kind,where
	logical eol,finito
	common /lexi/chr,kind,where,finito
c
c	begin
c	=====
c
c	lets start where user wants
c
	k=len(buffer)
	if (str.gt.k) then
	   finito=.true.
	   return
	endif
	if (str.le.0) str=1
	where=str-1	!force inchr to reset buffer from str
	eol=.false.
	finito=.false.
	call inchr(chr,kind,buffer,where,eol)
	if (eol) then
	   finito=.true.
	   return
	endif
c
	return
c
c
	end
c
c
c
c
	subroutine intok(type,value,decim,rvalue,
     1                    buffer,lim,pos1,pos2,msg,erro)
c	************************************************
c
	implicit none
c
	integer type,value,decim,lim,pos1,pos2,erro
	real rvalue
	character*(*) buffer,msg
c
c	Written by Luis Arriaga da Cunha 1984
c
c	Description
c	===========
c
c	Lexical  analysis  is performed on contents of buffer
c	giving  tokens  one at a time. Tokens have a TYPE,  a
c	possible VALUE, their string is between POS1 and POS2
c	of  BUFFER. This later is used up to LIM but not here.
c	If  the token is a "decimal integer", eg 362.92, then
c	DECIM  tells  the number of decimal places and  value
c	the  value  with  the dot dropped, for instance 2 and
c	36292 for the example. If the token  is a real number
c	RVALUE is the one. In MSG a possible error message is
c	given back to the user.
c
c	Note that BUFFER can be changed by INTOK (namely if a
c	double quoted string is found, eg 'a''bc'), so caller
c	should have his own copy if needed!!!!!!!!!!!!!!!!!!!
c
c	ACHTUNG !!! If ERRO comes in as zero no error message
c	is written on the terminal, otherwise message will be
c	displayed in channel 5.
c
c	Types of tokens can be :
c
c		0	end of buffer ( "false token" )
c		1	identifier with NO underlines( XPTO3 )
c		2	integer ( 347 )
c		3	decimal ( 120.53 )
c		4	real ( ??? )
c		5	string ( 'Luis Arriaga da Cunha ' )
c			Note that an eol ends a string.
c		6	(
c		7	)
c		8	,
c		9	=
c		10	*
c		11	/
c		12	+
c		13	-
c		14	?
c		15	<
c		16	>
c		17	<>
c		18	:
c		19	@
c		20	^ or **
c		21	.
c		22	<= or =<
c		23	>= or =>
c		24	identifier with underlines ( John_Smith )
c		25	$
c		26	**********defined elsewhere**********
c		27	**********defined elsewhere**********
c		28	**********defined elsewhere**********
c		29	**********defined elsewhere**********
c		30	**********defined elsewhere**********
c		31	**********defined elsewhere**********
c		32	**********defined elsewhere**********
c		33	%
c		34	**********defined elsewhere**********
c		35	**********defined elsewhere**********
c		36	**********defined elsewhere**********
c		37	[
c		38	]
c		39	empty string '' or '<ret>
c		40	#
c		41	// catenation symbol
c		42	!
c
c	ACHTUNG !!! If TYPE comes in as zero, user wants
c	to initialize the scanning of the BUFFER. A call
c	to INCHR with WHERE zero is therefore performed.
c
c	The lexical analyser works with a small  context
c	kept  in common LEXI (see var section) where the
c	currnt character CHR,KIND and position in buffer
c	WHERE are stored to be shared with perhaps other
c	lexical analysers.
c
c	Values have meaning for integers.
c	From 6 to 19 we could call them operators.
c	Please  dont  confuse types with dispatch values
c	given in kind.
c
c	var
c	===
c
	character*1 chr
	integer k,kind,where,ndigit
	logical eol,finito,show,acumul
	integer intmax,digmax
	common /lexi/chr,kind,where,finito
c
	integer zero
c
	data zero/48/,		!ichar('0')
	1    intmax/999999999/,digmax/9/
c
c	begin
c	=====
c
c	are we to finish ?
c
	if (finito) then
	   type=0
	   erro=0		!fix bug...
	   eol=.false.
	   finito=.false.
	   return
	endif
c
	if (erro.eq.0) then
	   show=.false.
	else
	   show=.true.
	   erro=0
	endif
	eol=.false.
	value=0
	decim=0
	rvalue=0.0
c
100	continue
c
	pos1=where
	pos2=where
c
	goto (1,2,3,4,5,6,7,8,9,10,
     1        11,12,13,14,15,16,17,18,19,20,
     1        21,22,23,24,25,26) kind
c
c	here error
c	----------
c
20	continue
	erro=1
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
	goto 100
c
c	separators ( no token produced)
c	-------------------------------
c
1	continue
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
cwhile	do while (chr.eq.' '.or.chr.eq.'	')	!space or tab
1098	continue
	   if (.not.(chr.eq.' '.or.chr.eq.'	')) goto 1099
c
	   call inchr(chr,kind,buffer,where,eol)
	   if (eol) goto 200
c
	   goto 1098
1099	continue
cwhile	enddo
	goto 100
c
c	identifiers
c	-----------
c
2	continue
	type=1
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
cwhile	do while (kind.eq.2.or.kind.eq.3.or.kind.eq.20)!letters ! digits ! "_"
1096	continue
	   if (.not.(kind.eq.2.or.kind.eq.3.or.kind.eq.20)) goto 1097
c
	   if (kind.eq.20) type=24
	   pos2=where
	   call inchr(chr,kind,buffer,where,eol)
	   if (eol) goto 200
c
	   goto 1096
1097	   continue
cwhile	enddo
	return
c
c	integers or decimals
c	--------------------
c
3	continue
	type=2
	acumul=.true.
	ndigit=1
	value=ichar(chr)-zero
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
cwhile	do while (kind.eq.3)
1094	continue
	   if (kind.ne.3) goto 1095
c
	   ndigit=ndigit+1
	   pos2=where
	   if (ndigit.gt.digmax) then
	      erro=2
	      acumul=.false.
	   endif
	   if (acumul) value=value*10+( ichar(chr)-zero )
	   if (abs(value).gt.intmax) then
	      erro=2
	      acumul=.false.
	   endif
	   call inchr(chr,kind,buffer,where,eol)
	   if (eol) goto 200
c
	   goto 1094
1095	continue
cwhile	enddo
	if (chr.eq.'.') then
	   type=3
	   call inchr(chr,kind,buffer,where,eol)
	   if (eol) goto 200
cwhile	   do while (kind.eq.3)
1092	   continue
	      if (kind.ne.3) goto 1093
c
	      ndigit=ndigit+1
	      decim=decim+1
	      pos2=where
	      if (ndigit.gt.digmax) then
	         erro=2
	         acumul=.false.
	      endif
	      if (acumul) value=value*10+( ichar(chr)-zero )
	      if (abs(value).gt.intmax) then
	         erro=2
	         acumul=.false.
	      endif
	      call inchr(chr,kind,buffer,where,eol)
	      if (eol) goto 200
c
	      goto 1092
1093	   continue
cwhile	   enddo
	endif
	value=value
	return
c
c	string (proper ones)
c	--------------------
c
4	continue
	type=5
	pos1=where+1
	pos2=0
	call inchr(chr,kind,buffer,where,eol)
cx	if (eol) goto 200
	if (eol) goto 444
	k=where
cwhile	do while (kind.ne.4)
1090	continue
	   if (kind.eq.4) goto 1091
c
44	   continue		!oh  yeh
	   buffer(k:k)=buffer(where:where)
	   pos2=k
	   call inchr(chr,kind,buffer,where,eol)
cx	   if (eol) goto 200
	   if (eol) goto 444
	   k=k+1
c
	   goto 1090
1091	continue
cwhile	enddo
	call inchr(chr,kind,buffer,where,eol)
cx	if (eol) then
cx	   if (pos1.gt.0.and.pos2.eq.0) then
cx	      pos2=pos1
cx	      type=39		!empty string, new token
cx	   endif
cx	   goto 200
cx	endif
	if (eol) goto 444
	if (kind.eq.4) goto 44
c
c	Check empty strings on normal return!
c
	if (pos1.gt.0.and.pos2.eq.0) then
	   pos2=pos1
	   type=39		!empty string, new token
	endif
	return
c
c	Check empty strings on eol!
c
444	continue
	if (pos1.gt.0.and.pos2.eq.0) then
	   pos2=pos1
	   type=39		!empty string, new token
	endif
	goto 200
c
c	(
c
5	continue
	type=6
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	)
c
6	continue
	type=7
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	,
c
7	continue
	type=8
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	= or =< or =>
c
8	continue
	type=9
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
	if (chr.eq.'<') then
	   pos2=pos2+1
	   type=22
	   call inchr(chr,kind,buffer,where,eol)
	   if (eol) goto 200
	elseif (chr.eq.'>') then
	   pos2=pos2+1
	   type=23
	   call inchr(chr,kind,buffer,where,eol)
	   if (eol) goto 200
	endif
	return
c
c	* or **
c
9	continue
	type=10
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
	if (chr.eq.'*') then
	   pos2=pos2+1
	   type=20
	   call inchr(chr,kind,buffer,where,eol)
	   if (eol) goto 200
	endif
	return
c
c	/ or //
c
10	continue
	type=11
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
	if (chr.eq.'/') then
	   pos2=pos2+1
	   type=41
	   call inchr(chr,kind,buffer,where,eol)
	   if (eol) goto 200
	endif
	return
c
c	+
c
11	continue
	type=12
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	-
c
12	continue
	type=13
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	?
c
13	continue
	type=14
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	< or <> or <=
c
14	continue
	type=15
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
	if (chr.eq.'>') then
	   pos2=pos2+1
	   type=17
	   call inchr(chr,kind,buffer,where,eol)
	   if (eol) goto 200
	elseif (chr.eq.'=') then
	      pos2=pos2+1
	      type=22
	      call inchr(chr,kind,buffer,where,eol)
	      if (eol) goto 200
	endif
	return
c
c	> or >=
c
15	continue
	type=16
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
	if (chr.eq.'=') then
	   pos2=pos2+1
	   type=23
	   call inchr(chr,kind,buffer,where,eol)
	   if (eol) goto 200
	endif
	return
c
c	:
c
16	continue
	type=18
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	@
c
17	continue
	type=19
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	^
c
18	continue
	type=20
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	.
c
19	continue
	type=21
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	$
c
21	continue
	type=25
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	%
c
22	continue
	type=33
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	[
c
23	continue
	type=37
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	]
c
24	continue
	type=38
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	#
c
25	continue
	type=40
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c	!
c
26	continue
	type=42
	call inchr(chr,kind,buffer,where,eol)
	if (eol) goto 200
	return
c
c
c
c
c	end of buffer (false token)
c	---------------------------
c
200	continue
	finito=.true.	!for next time
	return
c
c	formats
c	=======
c
c
	end
c
c
c
c
	SUBROUTINE UC(STRING)
C	**********************
C
	IMPLICIT NONE
C
C	DESCRIPTION
C	===========
C
C	Given a STRING, lower case letters are changed
C	into upper case. Usable in file   or  data bag
C	names.
C
C	VAR
C	===
C
	EXTERNAL istrip
	INTEGER istrip
	INTEGER LIM,IC,K
	CHARACTER*(*) STRING
	CHARACTER*1 VOCAB(0:25),UPC
C
	DATA VOCAB/'A','B','C','D','E','F','G','H','I',
     1            'J','K','L','M','N','O','P','Q','R',
     1            'S','T','U','V','W','X','Y','Z'/
C
C	BEGIN
C	=====
C
	lim=istrip(STRING)
	DO 1001 K=1,LIM
	  IC=ICHAR(STRING(K:K))-ICHAR('a')
	  IF (IC.GE.0.AND.IC.LE.25) THEN
	    UPC=VOCAB(IC)
	    STRING(K:K)=UPC
	  ENDIF
1001	CONTINUE
C
	RETURN
C
	END
C
C
C
C
	subroutine lc(string)
c	*********************
c
	implicit none
c
	character*(*) string
c
c	Given a STRING letters are changed into lower case.
c
c	var
c	===
c
	external istrip
	integer istrip
	character*1 ch
	integer l,k
c
c	begin
c	=====
c
	l=istrip(string)
	do 1001 k=1,l
	   ch=string(k:k)
	   if (ch.ge.'A'.and.ch.le.'Z') then
	      ch=char(ichar(ch)+(ichar('a')-ichar('A')))
	      string(k:k)=ch
	   endif
1001	continue
c
	return
c
c
	end
c
c
c
c
	
	subroutine givext(fspec,ext)
c	*****************************
c
	implicit none
c
	character*(*) fspec,ext
c
c	Description
c	===========
c
c	Given a file name in FSPEC , a extension EXT is forced
c	into, it  perhaps  overriding  any  existing extension.
c
c	var
c	===
c
	external istrip
	integer istrip
	integer right, limit, dot
c
c	begin
c	=====
c
	right=index(fspec,']')
	if (right.le.0) right=index(fspec,':')
	right=right+1
	dot=index(fspec(right:), '.')
	if (dot.gt.0) then
	   limit=right+dot-2
	else
	   limit=istrip(fspec)
	endif
	if (limit.le.0) then
	   fspec(1:)=' '
	else
	   fspec(1:)=fspec(1:limit)//ext
	endif
c
	return
c
c
	end
c
c
c
c
	integer function trim(string)
c	*****************************
c
	implicit none
c
	character*(*) string
c
c	Description
c	===========
c
c	The first used position (ie <> space ) in STRING
c	is the function value.
c
c	var
c	===
c
	integer lim,k
	character*1 chrt
c
c	begin
c	=====
c
	lim=len(string)
	do 1001 k=1,lim
	   trim=k
	   chrt=string(k:k)
	   if (chrt.ne.' '.and.chrt.ne.'	') goto 10
1001	continue
	trim=1
c
10	continue
	return
c
c
	end
c
c
c
c
	integer function istrip(string)
c	*******************************
c
	implicit none
c
	character*(*) string
c
c	Description
c	===========
c
c	Trailing  blanks and spaces are removed from string
c	string. The last  used position in string  is given
c	as the function value.
c
c	var
c	===
c
	integer lim,k,ichrt
	character*1 chrt
c
c	begin
c	=====
c
	lim=len(string)
	do 1001 k=lim,1,-1
	   chrt=string(k:k)
	   ichrt=ichar(chrt)
	   if (chrt.ne.' '.and.
     1          .not.(ichrt.lt.32.or.
     1               (ichrt.gt.126.and.ichrt.lt.161).or.
     1                ichrt.gt.253                    )) goto 1
1001	continue
c
	istrip=0
	return
c
1	continue
	istrip=k
	return
c
c
	end
c
c
c
c
	subroutine newc(ch)
c
	implicit none
c
	integer ch
c
	integer channel(20),top
c
	common /iochn/ channel,top
c
	logical first
	integer k
c
	data first/.true./
c
	if (first) then
	   top=20
	   do 1001 k = 1, top
	      channel(k)=0
1001	   continue
	   first=.false.
	endif
c
	ch=-1
c
	do 1002 k = 1, top
	   if (channel(k).eq.0) then
	      ch=119-k+1
	      channel(k)=ch
	      return
	   endif	
1002	continue
c
	return
c
	end
c
c
c
c
	subroutine freec(ch)
c
	implicit none
c
	integer ch
c
	integer channel(20),top
c
	common /iochn/ channel,top
c
	integer k
c
	logical first
	data first/.true./
c
	if (first) then
	   top=20
	endif
c
	do 1001 k = 1, top
	   if (channel(k).eq.ch) then
	      channel(k)=0
	      return
	   endif	
1001	continue
c
	return
c
	end
c
c
c
c
	subroutine findfile(fspec,respec,contxt,eos)
c
	implicit none
c
	character*(*) fspec,respec
	integer contxt
	logical eos
c
c	Description
c	===========
c
c	Search for next file spec (RESPEC) that satisfies a given file spec,
c	optionally "wild carded" (FSPEC), if MSDOS is set to .false.;
c	RESPEC = FSPEC if MSDOS is set to .true.
c	EOS = .false. means new file spec returned.
c
c	var
c	===
c
	external istrip
	integer istrip
	integer status
c
	logical msdos,flipflop
	common/env/	msdos,flipflop
c
c	begin
c	=====
c
	eos=.false.
c
	if (msdos) then
	   if (.not.flipflop) then
	      respec(1:)=' '
	      respec=fspec
	      if (istrip(respec).le.0) then
	         eos=.true.
	         flipflop=.false.
	      else
	         flipflop=.true.
	      endif
	   else
	      eos=.true.
	      flipflop=.false.
	   endif
	else
	   call lib$find_file(fspec,respec,contxt,,,status)
	   if (status.ne.0.or.
	1      istrip(respec).le.0) eos=.true.
	endif
c
	return
c
	end
c
c
c
c
