	subroutine x$comm_(cmmd,mark,msgerr,erro)
c
	implicit none
c
	character*(*) cmmd,msgerr
	integer mark,erro
c
c	Description
c	===========
c
c	DBAG command executor. Checks and executes command in CMMD.
c
c	The commands @, UP, RECALL and PAUSE can't be executed in user
c	mode (non-interactive usage).
c
c	CAUTION:	CMMD may come back changed !
c
c	ERRO	0	ok
c		<0	Dbag fatal error, error in MSGERR
c		>0	Dbag error, error in MSGERR
c
c	MARK, if >0, will point CMMD problem area.
c
c	var
c	===
c
	include 'own:dbag0.own'
	include 'own:dbagb.own'
c
	integer lim,interr,type,val,dec,p1,p2
	real rval
	logical user
c
c	begin
c	=====
c
c	set error status
c
	call errclr_('X$COMM')
	erro=0
	msgerr(1:)=' '
c
c	User call or interactive ?
c	--------------------------
c
	if (d$itrv.eq.0) then
	   user=.true.
	else
	   user=.false.
	endif
c
c	Initialize DBAG usage if user call
c	----------------------------------
c
	if (user) then
	   call init_(erro)
	   if (erro.ne.0) goto 95000	!fatal error
	endif
c
	mark=0					!clear mark
c
	call rstok_(cmmd,1,erro)		!reset command line
	if (erro.ne.0) goto 95000		!fatal error
	erro=0					!only my own messages
						!get 1rst token
	call intok_(type,val,dec,rval,cmmd,lim,p1,p2,mssg,erro)
	if (erro.ne.0) then
	   if (.not.user) then
	      call i$stcm_(cmmd,erro)		!store command into buffer
	      if (erro.ne.0) goto 95000		!fatal error
	   endif
	   goto 90000				!syntax error
	endif
	if (type.eq.0) goto 9901		!eol, just return
	if (type.eq.42) goto 9901		!comment line, just return
c
c	Lookup special commands (SPCTOK)
c	--------------------------------
c
	call seetab_(spctok,spctop,spcpos,cmmd(p1:p2),0)
c
	if (spcpos.le.0) then
	   if (type.eq.1) then			!not a special command,
	      goto 2				!lookup usual commands
	   else	
	      goto 3				!try other junk...
	   endif
	endif
c
c	Dispatch on special commands
c	----------------------------
c
	if (.not.user) then
	   call i$stcm_(cmmd,erro)		!store command into buffer
	   if (erro.ne.0) goto 95000		!fatal error
	endif
c
	goto ( 10, 20 ) spcpos
c
c
c					@ (spc$at)
c					$$$$$$$$$$
c
10	continue
	if (user) goto 90005		!sorry, no @ command
	call spc$at_(cmmd,mark)
	goto 9901
c
c					? (h$elp)
c					$$$$$$$$$
c
20	continue
	call h$elp_ (cmmd,mark)		!same as HELP
	goto 9901
c
c	Lookup usual commands (CMDTOK)
c	------------------------------
c
2	continue
c
	call seetab_(cmdtok,cmdtop,cmdpos,cmmd(p1:p2),minchr)	!check cmdtok
	if (cmdpos.le.0) then
	   if (.not.user) then
	      call i$stcm_(cmmd,erro)		!store command into buffer
	      if (erro.ne.0) goto 95000		!fatal error
	   endif
	   if (cmdpos.eq.0) goto 90002			!unknown command
	   if (cmdpos.eq.-1) goto 90003			!ambiguous command
	   if (cmdpos.eq.-2) goto 90004			!too few characters
	   goto 90007					!???
	endif
c
c	Don't save UP/RECALL command
c
	if (cmdpos.eq.47.or.
	1   cmdpos.eq.23    ) then
c	   ok, don't save command
	else
	   if (.not.user) then
	      call i$stcm_(cmmd,erro)		!store command into buffer
	      if (erro.ne.0) goto 95000		!fatal error
	   endif
	endif
c
c	Dispatch on usual commands
c	--------------------------
c
	goto ( 100, 200, 300, 400, 500, 600, 700, 800, 900, 1000,
     1         1100,1200,1300,1400,1500,1600,1700,1800,1900,2000,
     1         2100,2200,2300,2400,2500,2600,2700,2800,2900,3000,
     1         3100,3200,3300,3400,3500,3600,3700,3800,3900,4000,
     1         4100,4200,4300,4400,4500,4600,4700,4800,4900,5000,
     1         5100,5200     ) cmdpos
c
c
c					APPEND
c					$$$$$$
c
100	continue
	call a$ppen_(cmmd,mark)
	goto 9901
c
c					BROWSE
c					$$$$$$
c
200	continue
	call b$rows_(cmmd,mark)
	goto 90002
c
c					CHANGE
c					$$$$$$
c
300	continue
	call c$hang_(cmmd,mark)
	goto 90002
c
c					CONTINUE
c					$$$$$$$$
c
400	continue
	call c$onti_(cmmd,mark)
	goto 90002
c
c					COPY
c					$$$$
c
500	continue
	call c$opy_(cmmd,mark)
	goto 9901
c
c					COUNT
c					$$$$$
c
600	continue
	call c$ount_(cmmd,mark)
	goto 90002
c
c					CREATE
c					$$$$$$
c
700	continue
	call c$reat_(cmmd,mark)
	goto 9901
c
c					DELETE
c					$$$$$$
c
800	continue
	call d$elet_(cmmd,mark)
	goto 9901
c
c					DISPLAY
c					$$$$$$$
c
900	continue
	call d$ispl_(cmmd,mark)
	goto 9901
c
c					EDIT
c					$$$$
c
1000	continue
	call e$dit_(cmmd,mark)
	goto 9901
c
c					EXIT
c					$$$$
c
1100	continue
	call e$xit_(cmmd,mark)
	goto 9901
c
c					FIND
c					$$$$
c
1200	continue
	call f$ind_(cmmd,mark)
	goto 90002
c
c					GO or GOTO
c					$$$$$$$$$$
c
1300	continue
	call g$oto_(cmmd,mark)
	goto 9901
c
c					HELP
c					$$$$
c
1400	continue
	call h$elp_(cmmd,mark)
	goto 9901
c
c					INDEX
c					$$$$$
c
1500	continue
	call i$ndex_(cmmd,mark)
	goto 9901
c
c					UNLOAD
c					$$$$$$
c
1600	continue
	call u$nloa_(cmmd,mark)
	goto 9901
c
c					JOIN
c					$$$$
c
1700	continue
	call j$oin_(cmmd,mark)
	goto 9901
c
c					LIST
c					$$$$
c
1800	continue
	call l$ist_(cmmd,mark)
	goto 9901
c
c					HOST
c					$$$$
c
1900	continue
	call h$ost_(cmmd,mark)
	goto 9901
c
c					MODIFY
c					$$$$$$
c
2000	continue
	call m$odif_(cmmd,mark)
	goto 9901
c
c					PACK
c					$$$$
c
2100	continue
	call p$ack_(cmmd,mark)
	goto 90002
c
c					QUIT
c					$$$$
c
2200	continue
	call e$xit_(cmmd,mark)		!same as EXIT
	goto 9901
c
c					RECALL
c					$$$$$$
c
2300	continue
	if (user) goto 90005		!sorry, no RECALL command
	call u$p_(cmmd,mark)		!same as UP
	goto 9901
c
c					KILL
c					$$$$
c
2400	continue
	call k$ill_(cmmd,mark)
	goto 9901
c
c					REINDEX
c					$$$$$$$
c
2500	continue
	call r$eind_(cmmd,mark)
	goto 9901
c
c					RENAME
c					$$$$$$
c
2600	continue
	call r$enam_(cmmd,mark)
	goto 90002
c
c					REPLACE
c					$$$$$$$
c
2700	continue
	call r$epla_(cmmd,mark)
	goto 9901
c
c					REPORT
c					$$$$$$
c
2800	continue
	call r$epor_(cmmd,mark)
	goto 90002
c
c					SELECT
c					$$$$$$
c
2900	continue
	call s$elec_(cmmd,mark)
	goto 90002
c
c					SET
c					$$$
c
3000	continue
	call s$et_(cmmd,mark)
	goto 9901
c
c					SUM
c					$$$
c
3100	continue
	call s$um_(cmmd,mark)
	goto 90002
c
c					RELOAD
c					$$$$$$
c
3200	continue
	call r$eloa_(cmmd,mark)
	goto 9901
c
c					SORT
c					$$$$
c
3300	continue
	call s$ort_(cmmd,mark)
	goto 9901
c
c					TOTAL
c					$$$$$
c
3400	continue
	call t$otal_(cmmd,mark)
	goto 90002
c
c					UPDATE
c					$$$$$$
c
3500	continue
	call u$pdat_(cmmd,mark)
	goto 90002
c
c					USE
c					$$$
c
3600	continue
	call u$se_(cmmd,mark)
	goto 9901
c
c					VMS
c					$$$
c
3700	continue
	call v$ms_(cmmd,mark)
	goto 9901
c
c					MENU
c					$$$$
c
3800	continue
	call m$enu_(cmmd,mark)
	goto 9901
c
c					SEARCH
c					$$$$$$
c
3900	continue
	call s$earc_ (cmmd,mark)
	goto 9901
c
c					CANCEL
c					$$$$$$
c
4000	continue
	call c$ance_ (cmmd,mark)
	goto 9901
c
c					SAVE
c					$$$$
c
4100	continue
	call s$ave_ (cmmd,mark)
	goto 9901
c
c					RESTORE
c					$$$$$$$
c
4200	continue
	call r$esto_ (cmmd,mark)
	goto 9901
c
c					CLOSE
c					$$$$$
c
4300	continue
	call c$lose_ (cmmd,mark)
	goto 9901
c
c					OPEN
c					$$$$
c
4400	continue
	call u$se_ (cmmd,mark)		!same as USE
	goto 9901
c
c					DEFINE
c					$$$$$$
c
4500	continue
	call d$efin_ (cmmd,mark)
	goto 9901
c
c					NOINDEX
c					$$$$$$*
c
4600	continue
	call n$oind_(cmmd,mark)
	goto 9901
c
c					UP
c					$$
c
4700	continue
	if (user) goto 90005		!sorry, no UP command
	call u$p_(cmmd,mark)
	goto 9901
c
c					ZERO
c					$$$$
c
4800	continue
	call z$ero_(cmmd,mark)
	goto 9901
c
c					PAUSE
c					$$$$$
c
4900	continue
	if (user) goto 90005		!sorry, no PAUSE command
c
c	dont't pause if already done
c
	if (.not.s$set(s$paus)) call p$ause_(cmmd,mark)
c
	goto 9901
c
c					EDT
c					$$$
c
5000	continue
	call e$dt_(cmmd,mark)
	goto 9901
c
c					TPU
c					$$$
c
5100	continue
	call t$pu_(cmmd,mark)
	goto 9901
c
c					NEWS
c					$$$$
c
5200	continue
	call n$ews_(cmmd,mark)
	goto 9901
c
c	"Junk" here
c	-----------
c
3	continue
c
	if (.not.user) then
	   call i$stcm_(cmmd,erro)		!store command into buffer
	   if (erro.ne.0) goto 95000		!fatal error
	endif
c
	if (type.eq.2) then
	   call junk$r_(cmmd,mark)		!record#, probably...
	   goto 9901
	endif
c
	goto 90002				!unknown command
c
c	"Case" base
c	-----------
c
9901	continue
c
	if (d$erro.ne.0) then
	   erro=d$erro
	   call errmsg_(d$rsub,d$erro,msgerr,'%')!return message
	endif
	return
c
c	Error
c	=====
c
c	Warnings
c	--------
c	syntax error (erro=1 illegal character, erro=2 too many digits)
90000	continue
	if (erro.eq.1) then
	   goto 90001
	else
	   goto 90006
	endif
c	illegal character in command line
90001	continue
	erro=1						!set error code
	mark=p1
	d$edit=1		!edit mode
	goto 99000
c	unknown command
90002	continue
	erro=2						!set error code
	mark=p1
	d$edit=1		!edit mode
	goto 99000
c	ambiguous command
90003	continue
	erro=3						!set error code
	mark=p1
	d$edit=1		!edit mode
	goto 99000
c	Too few characters in command
90004	continue
	erro=4						!set error code
	mark=p1
	d$edit=1		!edit mode
	goto 99000
c	No @, UP, RECALL or PAUSE command if non-interactive
90005	continue
	erro=5						!set error code
	mark=p1
	d$edit=1		!edit mode
	goto 99000
c	too many digits
90006	continue
	erro=6						!set error code
	mark=p1
	d$edit=1		!edit mode
	goto 99000
c	Error looking up command table
90007	continue
	erro=7						!set error code
	mark=p1
	goto 99000
c
c	Set error code
c	--------------
c
99000	continue
	call errset_('X$COMM',erro)
	call errmsg_(d$rsub,d$erro,msgerr,'%')!return message
	return
c
c	Errors
c	------
c
c	Fatal error
c	-----------
95000	continue
	erro=-d$erro
	call errmsg_(d$rsub,d$erro,msgerr,'%')!return message
	return
c
c	Formats
c	=======
c
	end
c
c
c
c
