< /* OPT.C	Decus C compiler branch optimizer.  Use on *.S file( 		after compiling but before assembling." 		Eliminates unnecessary branches.   		Clifford C. Geschke	02-Aug-82F   		Usage:	OPT <input >output!   RSX TASK BUILDER COMMANDS:   OPT=OPTt LB:[1,1]CU/LB,CX/LB,C/LB /P ACTFIL=4 UNITS=4o LIBR=FCSRES:RO //   */   #include <stdio2.h>    /* Assembly switches */   < #define VSPLEN 50	/* Number of successive labels possible */: #define PNDMAX 50	/* Number of pending defines possible */: #define LABMAX 500	/* Maximum number of labels possible */  ! /* Codes returned by getline() */e  ' #define ORD 0		/* Ordinary statement */b #define LAB 1		/* Label */( #define BR 2		/* Unconditional branch */  * char *lpt;		/* Pointer into line buffer */" char linbuf[82];	/* Line buffer */ int value;		/* Value save */$ int *vsp;		/* Value stack pointer */% int vsptop[VSPLEN];	/* Value stack */S& int brpend;		/* Pending branch save */2 int pndr[PNDMAX];	/* Pending equate, right side */1 int pndl[PNDMAX];	/* Pending equate, left side */u, int deflst[LABMAX];	/* Defined label list */2 int *defpt;		/* Pointer into defined label list */7 int *pndmax;		/* Pointer past maximum pending equate */U   $$narg = 1;a  0 getch()		/* Get a single character, buffer it */   {l     FAST int c;e  8     if ( ( ( c = getchar() ) < 0 ) 	/* If end of file */0     ||   ( c == '\n' ) ) {		/* or end of line */& 	*lpt = NULL;			/* Mark end of line */     }/
     else {) 	*lpt++ = c;			/* Else store character */n     }P)     return( c );			/* Return character */n }e t  skipws()		/* Skip white space */ {n     FAST int c;n  +     do ; while ( ( ( c = getch() ) == ' ' )* 	 ||	 ( c == '\t' ) );       return( c ); }a =% getlin()		/* Get a line from stdin */a   /*   	Returns  EOF if end of file 		 ORD if ordinary statement 		 LAB if labelI 		 BR  if branch    8 		 If LAB or BR return, "value" contains the label value 		 (in binary).f  A 	Upon return, lunbuf contains the new line, lpt points to the end*2 	of the line+1.  The line is terminated by a null.   	Ignores blank lines.S */   { (     FAST int c;		/* Current character */!     FAST int v;		/* Value save */*       do {* 	lpt = linbuf;				/* Reset line pointer */B     } while ( ( c = skipws() ) == '\n' );	/* Ignore blank lines */       switch( c ) {i  /     case EOF: return( c );		/* Return if EOF */   '     case '.': {				/* Possible label */s 	v = 0;				/* Scan for label */f' 	while ( ( ( c = getch() - '0' ) >= 0 )  	&&      ( c < 8 ) ) { 		v = v * 8 + c; 	}3 	if ( ( c == ':' - '0' )		/* If : followed by \n */l/ 	&&   ( getch() == '\n' ) ) {	/* Its a label */r" 	    value = v;			/* Save value */& 	    return( LAB );		/* Its a label */ 	} 	break;      }   $     case 'b': {				/* Possible BR */* 	if ( getch() != 'r' ) break;	/* not br */5 	if ( skipws() != '.' ) break;	/* Not br to .ddddd */F 	v = 0;				/* Scan for label */s  ' 	while ( ( ( c = getch() - '0' ) >= 0 )l 	&&      ( c < 8 ) ) { 		v = v * 8 + c; 	}  6 	if ( c == '\n' - '0' ) {	/* If end of line, branch */" 	    value = v;			/* Save value */& 	    return( BR );		/* Its a branch */ 	} 	break;*     }        } /* End of switch *//       /* Ordinary label */  ;     do ; while ( ( ( c = skipws() ) > 0 )	/* Copy to EOL */s 	 &&	 ( c != '\n' ) );  (     return( ORD );			/* Ordinary line */ }! .# vpush()			/* Push value on stack */v {0     if ( vsp == vsptop ) {- 	fprint( stderr, "Value stack overflow.\n" ); 	 	exitt();8     } $     *--vsp = value;	/* Push value */ }        # vpop()			/* Pop value from stack */l {=C     if ( vsp == &vsptop[VSPLEN] ) return( NULL );	/* Empty stack */b0     return( *vsp++ );		/* Return top of stack */ }* d. isdef( v )		/* TRUE if the value is defined */* FAST int v;		/* The value to be checked */ {n5     FAST int *d;	/* Pointer to the definition list */   )     d = defpt;		/* Get current pointer */   2     while ( d > deflst ) {	/* If non-empty list */! 	if ( *--d == v ) return( TRUE );      }        return( FALSE ); }a  ? outpnd( v )	/* Output any label depending on v, and define v */(* FAST int v;	/* Value on right of equate */ {p5     FAST int *p;	/* Index into pending label array */t.     FAST int l;		/* Value on left of equate */  %     if ( defpt == &deflst[LABMAX] ) { 2 	fprintf( stderr, "Too many labels. Exiting.\n" );	 	exitt();t     }t  (     *defpt++ = v;	/* Define the label */  8     p = pndr;		/* Point to pending label array, right */  0     while ( p < pndmax ) {	/* Search the list */% 	if ( *p++ == v ) {	/* If a match */	*1 	    if ( p == pndmax ) pndmax--;	/* Reset max */ ' 	    l = pndl[p-pndr-1];	/* Get left *//7 	    printf( ".%o = .%o\n", l, v );	/* output equate */*' 	    *(p-1) = NULL;	/* Reset pending */e  	    outpnd(l);		/* Recursion */ 	}     }  }  f, putpnd( l, r )	/* Define a pending equate */% int r;	/* Value on right of equate */=$ int l;	/* Value on left of equate */ {r5     FAST int *p;	/* Index into pending label array */l     FAST int num;	/* Scratch */l  8     p = pndr;		/* Point to pending label array, right */       while ( p < pndmax ) { 	if ( *p++ == NULL ) {	 	    p--;/ 	    goto insert;  	}     }%        pndmax++;		/* Set new max */       if ( p == &pndr[PNDMAX] ) {p? 	fprintf( stderr, "Too many pending definitions. Exiting.\n" ); 	 	exitt();r     }e   insert:i!     num = p-pndr;	/* Get index */g  "     pndr[num] = r;	/* Set right */!     pndl[num] = l;	/* Set left */* }/ n main()   {i-     FAST int code;		/* Code from getline() */h.     FAST int v;			/* Value from value stack */  )     lpt = linbuf;		/* Init line buffer */{3     vsp = &vsptop[VSPLEN];	/* Init stack pointer */t2     brpend = NULL;		/* Init branch pending save */5     defpt = deflst;		/* Init defined label pointer */T2     pndmax = pndr;		/* Init pending label array */  
     FOREVER {n  7 	while ( ( code = getline() ) == LAB ) {	/* If label */ G 	    if ( brpend == value ) brpend = NULL; /* Delete spurious branch */ ! 	    vpush();				/* Save label */r 	}  4 	if ( code == BR ) {		/* Label followed by branch */8 	    if ( isdef(value) )	{	/* If branch label defined */7 		while( ( v = vpop() ) != NULL ) {	/* Output equate */d( 		    printf( ".%o = .%o\n", v, value );/ 		    outpnd( v );	/* Output dependent label */r 		}  	    } 	    else {*8 		while( ( v = vpop() ) != NULL ) {	/* Pending equate */ 		    putpnd( v, value );B 		}/ 	    }7 	    if ( brpend == NULL ) {	/* If no branch pending */e) 		brpend = value;		/* There is one now */  	    } 	    continue; 	}    	/* Ordinary statement */  1 	if ( brpend != NULL ) {		/* If branch pending */a5 	    printf( "\tbr\t.%o\n", brpend );	/* Output it */ * 	    brpend = NULL;		/* Not pending now */ 	}  " 	while( ( v = vpop() ) != NULL ) {. 	    printf( ".%o:\n", v );	/* Define label */3 	    outpnd( v );		/* Output any dependent label */i 	}, 	puts( linbuf );			/* Output current line */+ 	brpend = FALSE;			/* Set no branch seen */r  , 	if ( code == EOF ) break;	/* Exit if EOF */       } /* End of forever */       if ( pndmax != pndr ) {tC 	fprint( stderr, "Optimization error: pending equates at EOF.\n" );p     }" }r