 /*  *	*******************  *	*  C P R N T . C  *  *	*******************  *7  * C-callable interface to P/OS callable print services   *  * Bob Denny  02-Jan-84   *  */    #ifdef DOCUMENTATION  , title    p$cprnt     Callable Print Services, index                Callable Print Serivces   synopsis  % 	 unsigned req;    /* Request Code */ ( 	 char *file       /* File name or "" */0 	 int *stat        /* --> 2-word status block */  # 	 p$cprnt(request, filespec, stat);    description   J 	Cprnt is a callable routine that allows your application to print a file,J 	stop, continue, abandon or restart a print job, or obtain printer status.: 	A request to print a file creates a non-interactive task. 	.s  	Request codes:  		+1 print file  		+2 abandon current print job 		+3 pause current print job" 		+4 continue the paused print job" 		+5 restart the current print job 		+6 report printer condition  	.s > 	Remainder of the 75-word integer array is used as a temporary! 	scratch pad by the CPRNT routine  	.s B 	For more information please refer to the Professional Developer's 	Toolkit Reference Manual.   diagnostics   E 	The following codes may appear in the first word of the status array  	.s G 	+1 -- Request accepted. If the request was "report printer condition", E 	the second word returns one of the decimal condition codes expounded  	upon in the P/OS manual.  	.pgG 	-1 -- Error occured. Second element of array contains DSW error codes.  	.s H 	-21 --  Print service error occured. Second word contains decimal error 	code explained in the manual.   author  
 	Bob Denny   #endif   /*	  * Edits:   */    extern cprnt();    p$cprnt(req, file, stat)# unsigned req;				/* Request code */  char *file;				/* File name */+ int *stat;				/* --> 2-word status block */     {?    unsigned req_array[75];		/* 75-word request/scratch array */ *    unsigned flen;			/* File name length */  3    req_array[0] = req;			/* Fill in request code */ 2    if(req == 1)				/* If "print file" requested */5       flen = strlen(file);		/* Get filename length */ (    else					/* For other requests ... */:       file = flen = 0;			/* ... force file & length = 0 */  J    call(cprnt, 4, stat, req_array, file, &flen);  /* Call print service */  2    return(stat[0]);			/* Return 1st status word */    }