   #ifdef public_domain_notice   J Copyright (c) 1996 David P. Murphy for Datametrics Systems Corporation ---I please send all comments and bug reports to murphy@connor.datametrics.com   G Permission is granted to any individual or institution to use, copy, or M redistribute this software so long as all of the original files are included, K that it is not sold for profit, and that this copyright notice is retained. M Use at your own risk.  Neither Murphy nor Datametrics assumes responsibility.  Do not taunt Happy Fun Ball.   #endif  5 	/* add an entry to the Hardware Exceptions Report */    #include "dscstd.h"  #include <descrip.h> #include <stdio.h> #include <errno.h> #include <signal.h>  #include <ssdef.h> #include <libdef.h>  #include <chfdef.h>  #include <stsdef.h>  #ifdef __VAX #include <sfdef.h> #endif #ifdef __ALPHA #include <ints.h>  #include <pdscdef.h> #include <psigdef.h> #include <libicb.h>  #endif  % 	/* macros specific to this module */    #undef MAYBE #define MAYBE  2  # #define HER$_USERABORT   0x00060001    #define MAX_ARGS            250  #define MAX_SIGNALS         250    #ifdef __VAX( #define REG_AP                        12( #define REG_FP                        13( #define REG_SP                        14( #define REG_PC                        15( #define NUMBER_OF_REGISTERS           16( #define NUMBER_OF_SPECIAL_REGISTERS    4 #endif #ifdef __ALPHA( #define NUMBER_OF_INT_REGISTERS       32( #define NUMBER_OF_FLOAT_REGISTERS     32( #define NUMBER_OF_REGISTERS           64( #define NUMBER_OF_SPECIAL_REGISTERS    0 #endif   #ifdef __VAX* #define SPECIAL_PC   ((char *) 0x80000014) #endif   	/* internal data structures */    typedef union VMS_REGISTER { #ifdef __VAX 	long lval;  	float fval; #endif #ifdef __ALPHA 	__int64 qval; 	unsigned long ulvals[2]; 
 	double dval;  #endif 	void *pval; } VMSRegister;  % typedef struct VMS_PROC_STATUS_WORD {  	unsigned cBit            :  1;  	unsigned vBit            :  1;  	unsigned zBit            :  1;  	unsigned nBit            :  1;  	unsigned traceBit        :  1;  	unsigned intOverflow     :  1;  	unsigned floatUnderflow  :  1;  	unsigned decimalOverflow :  1;  	unsigned                 :  8;  } PSW;  ) typedef struct VMS_PROC_STATUS_LONGWORD {  	PSW thepsw; 	unsigned iplValue       : 5;  	unsigned                : 1;  	unsigned prevMode       : 2;  	unsigned currentMode    : 2;  	unsigned interruptStack : 1;  	unsigned firstPartDone  : 1;  	unsigned                : 2;  	unsigned tracePending   : 1;  	unsigned pdp11mode      : 1;  } PSL;   #ifdef __VAX# typedef struct VMS_ARGUMENT_STACK {  	unsigned char argCount; 	unsigned : 24;  	void *args[MAX_ARGS]; } ArgStack;    typedef struct VMS_CALL_FRAME { ) 	struct VMS_CALL_FRAME *conditionHandler;  	unsigned           :  5;  	unsigned miniPSW   : 11;  	unsigned entryMask : 12;  	unsigned           :  1;  	unsigned isCALLS   :  1;  	unsigned spa       :  2;  	ArgStack *savedAP;   	struct VMS_CALL_FRAME *savedFP; 	char *savedPC; J 	VMSRegister savedRegs[NUMBER_OF_REGISTERS - NUMBER_OF_SPECIAL_REGISTERS]; } CallFrame; typedef CallFrame FrameData; #endif #ifdef __ALPHA typedef void ArgStack;! typedef struct pdscdef CallFrame; * typedef struct invo_context_blk FrameData; #endif  $ typedef struct VMS_CONDITION_STACK { 	CONDVAL condValue;  	unsigned char argCount; 	unsigned : 24;  	void *args[MAX_ARGS]; } CondStack;  ! typedef struct VMS_SIGNAL_ARRAY {  	long totalArgCount;  	CondStack signals[MAX_SIGNALS]; } SignalArray;   typedef struct VMS_MECH_ARRAY {  #ifdef __VAX; 	long totalArgCount;		/* always four longwords following */  	CallFrame *frame; 	long depth; 	long savedR0; 	long savedR1; #endif #ifdef __ALPHAB 	long totalArgCount;	/* always eighty-seven longwords following */ 	long mch_flags; 	CallFrame *frame; 	long mch_xxx; 	long depth; 	long mch_resvd1;  	uint64 mch_daddr; 	uint64 mch_esf_addr;  	uint64 mch_sig_addr;  	uint64 savedR0; 	uint64 savedR1; 	uint64 savedR16;  	uint64 savedR17;  	uint64 savedR18;  	uint64 savedR19;  	uint64 savedR20;  	uint64 savedR21;  	uint64 savedR22;  	uint64 savedR23;  	uint64 savedR24;  	uint64 savedR25;  	uint64 savedR26;  	uint64 savedR27;  	uint64 savedR28;  	uint64 savedF0; 	uint64 savedF1; 	uint64 savedF10;  	uint64 savedF11;  	uint64 savedF12;  	uint64 savedF13;  	uint64 savedF14;  	uint64 savedF15;  	uint64 savedF16;  	uint64 savedF17;  	uint64 savedF18;  	uint64 savedF19;  	uint64 savedF20;  	uint64 savedF21;  	uint64 savedF22;  	uint64 savedF23;  	uint64 savedF24;  	uint64 savedF25;  	uint64 savedF26;  	uint64 savedF27;  	uint64 savedF28;  	uint64 savedF29;  	uint64 savedF30;  #endif } MechArray;  - 	/* operating-system function declarations */    #ifdef __VAX. #  define sys$asctim                SYS$ASCTIM. #  define sys$assign                SYS$ASSIGN. #  define sys$dassgn                SYS$DASSGN. #  define sys$putmsg                SYS$PUTMSG1 #  define lib$establish             LIB$ESTABLISH 9 #  define lib$find_image_symbol     LIB$FIND_IMAGE_SYMBOL = #  define lib$get_curr_invo_context LIB$GET_CURR_INVO_CONTEXT = #  define lib$get_prev_invo_context LIB$GET_PREV_INVO_CONTEXT . #  define lib$signal                LIB$SIGNAL #endifD #include <starlet.h>		/* prototypes for the SYS$xxxxx() functions */H #include <lib$routines.h>	/*     "       "   "  LIB$xxxxx()     "     */  A extern void lib$get_curr_invo_context(struct invo_context_blk *); I extern unsigned int lib$get_prev_invo_context(struct invo_context_blk *);   % 	/* external function declarations */   * extern int DSC_CanReadMemory(int, void *);7 extern void DSC_ShowSystemData(void *, FILE *, void *); 8 extern void DSC_ShowProcessData(void *, FILE *, void *);' extern CallFrame *DSC_GetMyFrame(void);  #ifdef __VAX. extern void DSC_GetMyRegisters(VMSRegister *); #endif  % 	/* internal function declarations */     void HER_SetUserMessage(char *);* void HER_SetUserFunction(int (*fncptr)());" void HER_TrackDummyError(CONDVAL);2 int HER_CheckForException(CONDVAL, SignalArray *); CONDVAL HER_Init(void); 8 CONDVAL HER_HandleException(SignalArray *, MechArray *);8 CONDVAL HER_ReportException(SignalArray *, MechArray *);  ! 	/* external data declarations */   ! 	/* internal data declarations */   ) LOCALDATA $DESCRIPTOR(NullDevice, "NL:");   8 LOCALDATA $DESCRIPTOR(SherlockImage, "SHERLOCK_HOLMES");0 LOCALDATA $DESCRIPTOR(SherlockName,  "SH_SHOW");* LOCALDATA CONDVAL (*SherlockPtr)() = NULL;    LOCALDATA FILE *ReportFP = NULL;  LOCALDATA long TrackChannel = 0;  LOCALDATA long FrameCount   = 0;4 LOCALDATA VMSRegister TrueRegs[NUMBER_OF_REGISTERS];  ! LOCALDATA BOOL Reporting = FALSE;    #define MAX_IMAGES  32 LOCALDATA int nImageCount = 0; LOCALDATA struct { 	char imgname[39 + 1]; 	void *vastart; 
 	void *vaend;  } ImageInfo[MAX_IMAGES];  # LOCALDATA char *UserMessage = NULL; ' LOCALDATA int (*UserFunction)() = NULL;    #ifdef __VAX LOCALDATA char *RegLabels[] = { 0 	"R0", "R1", "R2", "R3", "R4", "R5", "R6", "R7",3 	"R8 ", "R9 ", "R10", "R11", "AP", "FP", "SP", "PC"  }; #endif    " MEP__ PRIVATE void HER_I_SaveChan( 	void  )  { ? 	/* try to keep a channel reserved for error-tracking purposes, = 	 * so that the calling program does not consume all channels  	 * (ignore any error) 	 */ 	if (TrackChannel == 0) { / 		sys$assign(&NullDevice, &TrackChannel, 0, 0);  	}   	return; }     ! MEP__ UNIVERSAL CONDVAL HER_Init(  	void  )  {  	HER_I_SaveChan();   	return(SS$_NORMAL); }     # MEP__ PRIVATE void HER_I_CauseDump(  	long exitargs[] )  { 
 	CONDVAL cv0;    	IFBAD(exitargs[0]) { % 		lib$establish(HER_HandleException);   		lib$signal(HER$_USERABORT, 0); 	}   	return; }     - MEP__ PRIVATE CONDVAL HER_I_HandleDummyError(  	SignalArray *sigargs, 	MechArray *mechargs )  { ( 	HER_ReportException(sigargs, mechargs);   	return(SS$_CONTINUE); }     ) MEP__ UNIVERSAL void HER_TrackDummyError(  	CONDVAL cv0 )  { $ 	if (cv0 == 0) cv0 = HER$_USERABORT;' 	lib$establish(HER_I_HandleDummyError);  	lib$signal(cv0, 0);   	return; }     ( MEP__ UNIVERSAL void HER_SetUserMessage(
 	char *msgptr  )  {  	UserMessage = msgptr;   	return; }     ) MEP__ UNIVERSAL void HER_SetUserFunction(  	int (*fncptr)() )  {  	UserFunction = fncptr;    	return; }     , MEP__ UNIVERSAL CONDVAL HER_HandleException( 	SignalArray *sigargs, 	MechArray *mechargs )  { 
 	CONDVAL cv0;   ) 	if (HER_CheckForException(0, sigargs)) { 1 		IFBAD(HER_ReportException(sigargs, mechargs)) { : 			fprintf(stderr, "\nunable to report the exception!\n"); 			if (cv0 == SS$_RESIGNAL) { 7 				fprintf(stderr, "\n\tcoding error within HER.C\n");  			}	 			else { 4 				fprintf(stderr, "\n\tcan't open the logfile, ");1 				fprintf(stderr, "status is (hex) %x\n", cv0);  			} 			fflush(stderr); 			fsync(fileno(stderr)); 
 			sleep(10);  		}  	}   	return(SS$_RESIGNAL); }     * MEP__ UNIVERSAL int HER_CheckForException(
 	CONDVAL cv0,  	SignalArray *sigargs  )  {  	if (sigargs != NULL) { & 		cv0 = sigargs->signals[0].condValue; 	}   	switch (cv0) {    	case SS$_ACCVIO:  	case SS$_ASTFLT:  	case SS$_BREAK: 	case SS$_CMODSUPR:  	case SS$_CMODUSER:  	case SS$_DECOVF:  	case SS$_FLTDIV:  	case SS$_FLTOVF:  	case SS$_FLTUND:  	case SS$_FLTDIV_F:  	case SS$_FLTOVF_F:  	case SS$_FLTUND_F:  	case SS$_INTDIV:  	case SS$_INTOVF:  	case SS$_OPCDEC:  	case SS$_PAGRDERR:  	case SS$_ROPRAND: 	case SS$_SSFAIL:  #ifdef __VAX 	case SS$_ARTRES:  	case SS$_COMPAT:  	case SS$_OPCCUS:  	case SS$_RADRMOD: 	case SS$_SUBRNG:  	case SS$_TBIT:  #endif #ifdef __ALPHA 	case SS$_ALIGN: 	case SS$_HPARITH: #endif #ifdef HER$_USERABORT  	case HER$_USERABORT:  #endif 		return(TRUE);    	case SS$_EXQUOTA: 	case SS$_EXASTLM: 	case SS$_EXBIOLM: 	case SS$_EXBYTLM: 	case SS$_EXDIOLM: 	case SS$_EXENQLM: 	case SS$_EXFILLM: 	case SS$_EXPRCLM: 	case SS$_EXTQELM: 	case SS$_EXPGFLQUOTA: 		return(MAYBE);  	 	default:  		return(FALSE); 	} }     , MEP__ PRIVATE CONDVAL HER_I_ShowMessageText( 	struct dsc$descriptor_s *msdp,  	long unused )  { 
 	int trimlen;  	char *endptr;  7 	endptr = msdp->dsc$a_pointer + msdp->dsc$w_length - 1;  	trimlen = msdp->dsc$w_length;' 	while (endptr > msdp->dsc$a_pointer) { . 		if (*endptr == '\0' || *endptr > ' ') break; 		--trimlen; 		--endptr;  	}I 	fprintf(ReportFP, "\t\t%*.*s\n", trimlen, trimlen, msdp->dsc$a_pointer);   5 	/* must return an even value to prevent sys$putmsg() * 	 * from echoing this string to SYS$ERROR: 	 */ 	return(0);  }     - MEP__ PRIVATE void HER_I_ShowExceptionHeader(  	SignalArray *sigargs  )  {   	struct dsc$descriptor_s tempsd; 	char timebuf[23 + 1];    	tempsd.dsc$a_pointer = timebuf;' 	tempsd.dsc$w_length = sizeof(timebuf);  	tempsd.dsc$b_dtype = 0; 	tempsd.dsc$b_class = 0;$ 	sys$asctim(NULL, &tempsd, NULL, 0); 	timebuf[23] = '\0';> 	fprintf(ReportFP, "\f\nEXCEPTION occurred at %s\n", timebuf);   	if (UserMessage != NULL) { I 		fprintf(ReportFP, "\n\tApplication Message:\n\n\t\t%s\n", UserMessage);  	} 	if (UserFunction != NULL) { 		(*UserFunction)(ReportFP); 	}  ) 	fprintf(ReportFP, "\n\tCondition:\n\n");    	sigargs->totalArgCount -= 2; 5 	sys$putmsg(sigargs, HER_I_ShowMessageText, NULL, 0);  	sigargs->totalArgCount += 2;    	return; }      #ifdef __VAX  # MEP__ PRIVATE int HER_I_CanProcess(  	CallFrame *fp )  { - 	if (DSC_CanReadMemory(sizeof(void *), fp)) { 7 		if (DSC_CanReadMemory(sizeof(void *), fp->savedPC)) {  			return(TRUE); 		}  	}   	return(FALSE);  }    #endif    # MEP__ PRIVATE int HER_I_GetMaxArgs(  	MechArray *mechargs )  {  	int largestArgCount;  #ifdef __VAX 	ArgStack *ap; 	CallFrame *fp;  #endif #ifdef __ALPHA 	struct aidef *airptr; 	FrameData icbblock; #endif   	largestArgCount = 0;  #ifdef __VAX; 	for (fp = mechargs->frame; fp != NULL; fp = fp->savedFP) { & 		if (HER_I_CanProcess(fp) == FALSE) {	 			break;  		} # 		if ((ap = fp->savedAP) == NULL) {  		} 3 		else if (! DSC_CanReadMemory(sizeof(long), ap)) {  		} 4 		else if (ap->argCount == 0 || ap->argCount > 32) { 		} , 		else if (ap->argCount > largestArgCount) {" 			largestArgCount = ap->argCount; 		}  	} #endif #ifdef __ALPHA& 	lib$get_curr_invo_context(&icbblock); 	for (;;) { 8 		airptr = (struct aidef *) &icbblock.libicb$q_ireg[25];1 		if (airptr->ai$b_arg_count > largestArgCount) { , 			largestArgCount = airptr->ai$b_arg_count; 		} 7 		if (lib$get_prev_invo_context(&icbblock) == 0) break;  	} #endif   	return(largestArgCount);  }     $ MEP__ PRIVATE int HER_I_CountFrames( 	MechArray *mechargs )  {  	int j;  #ifdef __VAX 	CallFrame *fp;  #endif #ifdef __ALPHA 	FrameData icbblock; #endif   	j = 0;  #ifdef __VAX; 	for (fp = mechargs->frame; fp != NULL; fp = fp->savedFP) { + 		if (HER_I_CanProcess(fp) == FALSE) break;  		++j; 	} #endif #ifdef __ALPHA& 	lib$get_curr_invo_context(&icbblock); 	for (;;) { 7 		if (lib$get_prev_invo_context(&icbblock) == 0) break;  		++j; 	} #endif   	return(j);  }     ' MEP__ PRIVATE void HER_I_ShowCallStack(  	MechArray *mechargs )  {  	int j;  	int depth; 
 	int maxargs;  	int argcnt; 	unsigned long curPC;  #ifdef __VAX 	ArgStack *ap; 	CallFrame *fp;  #endif #ifdef __ALPHA, 	unsigned long rim;	/* register info mask */ 	unsigned long onearg; 	struct aidef *airptr; 	FrameData icbblock; #endif  A 	/* we don't want to show the Program Counter per se at this time M 	 * (that gets shown later in the per-frame data printout in ShowFrame below) S 	 * but the address which can be compared to the "jacket" addresses in the .MAP --- i 	 * for vax, it is the address of the entry point of the function (i.e., the two byte register save mask) ; 	 * for axp, it is the address of the procedure descriptor.  	 */& 	maxargs = HER_I_GetMaxArgs(mechargs); #ifdef __VAX> 	fprintf(ReportFP, "\n\tCall Stack:\n\n\t\t       abs PC   "); #endif #ifdef __ALPHA> 	fprintf(ReportFP, "\n\tCall Stack:\n\n\t\t      PD addr   "); #endifG 	for (j = 0; j < maxargs; j++) fprintf(ReportFP, "     arg %d", j + 1); . 	fprintf(ReportFP, "\n\t\t      --------   ");? 	for (j = 0; j < maxargs; j++) fprintf(ReportFP, "  --------");  	fprintf(ReportFP, "\n");   % 	depth = HER_I_CountFrames(mechargs);    #ifdef __VAX; 	for (fp = mechargs->frame; fp != NULL; fp = fp->savedFP) { + 		if (HER_I_CanProcess(fp) == FALSE) break;  		curPC = fp->savedPC; #endif #ifdef __ALPHA& 	lib$get_curr_invo_context(&icbblock); 	for (;;) { R 		curPC = (unsigned long) ((CallFrame *) icbblock.libicb$ph_procedure_descriptor); #endif: 		fprintf(ReportFP, "\t\t(%2d)  %08X  :", depth--, curPC); #ifdef __VAX# 		if ((ap = fp->savedAP) == NULL) { # 			fprintf(ReportFP, "    <none>");  		} 3 		else if (! DSC_CanReadMemory(sizeof(long), ap)) { # 			fprintf(ReportFP, "    <none>");  		} 4 		else if (ap->argCount == 0 || ap->argCount > 32) {# 			fprintf(ReportFP, "    <none>");  		}  		else {' 			for (j = 0; j < ap->argCount; j++) { , 				fprintf(ReportFP, "  %8X", ap->args[j]); 			} 		}  #endif #ifdef __ALPHA8 		airptr = (struct aidef *) &icbblock.libicb$q_ireg[25];/ 		if ((argcnt = airptr->ai$b_arg_count) == 0) { # 			fprintf(ReportFP, "    <none>");  		}  		else { 			rim = 0x03;! 			for (j = 0; j < argcnt; j++) {  				int huh;* 				huh = airptr->ai$v_arg_reg_info & rim; 				if (huh == AI$K_AR_I64) { - 					onearg = icbblock.libicb$q_ireg[16 + j];  				} ! 				else if (huh == AI$K_AR_FF) { - 					onearg = icbblock.libicb$q_freg[16 + j];  				} 
 				else { 					onearg = 0x0A11Beef;  				} ' 				fprintf(ReportFP, "  %8X", onearg);  				rim <<= 3; 			} 		}  #endif 		fprintf(ReportFP, "\n"); #ifdef __ALPHA7 		if (lib$get_prev_invo_context(&icbblock) == 0) break;  #endif 	}   	return; }     ' MEP__ PRIVATE void HER_I_ShowRegisters(  	FrameData *fdp  )  {  	int j;    #ifdef SAMPLE_VAX_OUTPUT   	Registers:   @ 		R0 = 00000000   R4 = 00000000   R8  = 00000000   AP = 00000000@ 		R1 = 00000000   R5 = 00000000   R9  = 00000000   FP = 00000000@ 		R2 = 00000000   R6 = 00000000   R10 = 00000000   SP = 00000000@ 		R3 = 00000000   R7 = 00000000   R11 = 00000000   PC = 00000000 #endif   #ifdef SAMPLE_AXP_OUTPUT   	Registers:   7 		IR0  =       61        0      FR0  =     0.0000000000i7 		IR1  =        1        0      FR1  =     0.0000000000r7 		IR2  =        4        0      FR2  =     0.0000000000m7 		IR3  = 7FF34280        0      FR3  =     0.0000000000 7 		IR4  = 7FFBF80C        0      FR4  =     0.0000000000 7 		IR5  = 7FFBF91C        0      FR5  =     0.0000000000 7 		IR6  = 7FFA0944        0      FR6  =     0.0000000000 7 		IR7  = 7FFA0944        0      FR7  =     0.0000000000 7 		IR8  = 7FFA0208        0      FR8  =     0.0000000000u7 		IR9  = 7FFA0410        0      FR9  =     0.0000000000d7 		IR10 = 7FFA1190        0      FR10 =     0.0000000000*7 		IR11 = 7FFBE3E0        0      FR11 =     0.0000000000e7 		IR12 =       5D        0      FR12 =     0.0000000000c7 		IR13 = 7FEDBF70        0      FR13 =     0.0000000000 7 		IR14 =        0        0      FR14 =     0.0000000000 7 		IR15 =  2024061        0      FR15 =     0.0000000000c7 		IR16 =   2D2EF0        0      FR16 =     0.0000000000f7 		IR17 =        0        1      FR17 =     0.0000000000E7 		IR18 =   2D35D8  A00010A      FR18 =     0.0000000000 7 		IR19 =        0    80000      FR19 =     0.0000000000 7 		IR20 =        0        0      FR20 =     0.0000000000 7 		IR21 =   2D35D9        0      FR21 =     0.0000000000d7 		IR22 =        0        0      FR22 =     0.0000000000 7 		IR23 =        0        0      FR23 =     0.0000000000 7 		IR24 =        0   2D35F6      FR24 =     0.0000000000 7 		IR25 =        1        0      FR25 =     0.0000000000 7 		IR26 =    3024C        0      FR26 =     0.0000000000O7 		IR27 =   13FB20        0      FR27 =     0.0000000000T7 		IR28 = 80161188 FFFFFFFF      FR28 =     0.0000000000c7 		IR29 = 7FE4FBB0        0      FR29 =     0.0000000000s7 		IR30 = 7FE4FBA0        0      FR30 =     0.0000000000 7 		IR31 =        0 48000700      FR31 =     0.0000000000a #endif  ) 	fprintf(ReportFP, "\n\tRegisters:\n\n");f   #ifdef __VAX 	for (j = 0; j < 4; j++) {F 		fprintf(ReportFP, "\t\t%s = %8X   %s = %8X   %s = %8X   %s = %8X\n",' 			RegLabels[j],      TrueRegs[j].lval, + 			RegLabels[j +  4], TrueRegs[j + 4].lval, + 			RegLabels[j +  8], TrueRegs[j + 8].lval,g- 			RegLabels[j + 12], TrueRegs[j + 12].lval);r 	} #endif #ifdef __ALPHAJ 	/* don't bother printing IR31 and FR31 --- they are both permanently zero 	 */4 	for (j = 0; j < NUMBER_OF_INT_REGISTERS - 1; j++) {D 		fprintf(ReportFP, "\t\tIR%-2d = %8X %8X      FR%-2d = %16.10lf\n",3 			j, TrueRegs[j].ulvals[1], TrueRegs[j].ulvals[0], 2 			j, TrueRegs[j + NUMBER_OF_INT_REGISTERS].dval); 	} #endif   	return; }:    & MEP__ PRIVATE int HER_I_CheckAsciiArg(
 	int thesize, 
 	char *theptr  )i {f 	int worksize;  ! 	if ((worksize = thesize) == 0) {e 		worksize = 255;u 	} 	else { . 		if (! DSC_CanReadMemory(worksize, theptr)) { 			return(FALSE);R 		}  	} 	while (worksize-- > 0) {t 		if (thesize == 0) { ( 			if (! DSC_CanReadMemory(1, theptr)) { 				return(FALSE); 			} 			if (*theptr == '\0') {  				return(TRUE);A 			} 		} ) 		if (*theptr != '\t' && *theptr < ' ') {v 			return(FALSE);_ 		}F 		++theptr;; 	}  ' 	return((thesize == 0) ? FALSE : TRUE);E }F   S+ MEP__ PRIVATE int HER_I_CheckDescriptorArg(r 	struct dsc$descriptor_s *sdptr; )e {f( 	/* <sigh> at this time, we only support- 	 * fixed-length character string descriptorsu 	 */  = 	if (sdptr->dsc$w_length == 0 || sdptr->dsc$w_length > 255) {S 		return(FALSE); 	}F 	if (sdptr->dsc$b_dtype != 0 && sdptr->dsc$b_dtype != DSC$K_DTYPE_T) { 		return(FALSE); 	}F 	if (sdptr->dsc$b_class != 0 && sdptr->dsc$b_class != DSC$K_CLASS_S) { 		return(FALSE); 	}  H 	return(HER_I_CheckAsciiArg(sdptr->dsc$w_length, sdptr->dsc$a_pointer)); }n   *' MEP__ PRIVATE void HER_I_ShowArguments(l 	ArgStack *ap,	 	int argc; )l {  	int j;  	int expandLimit;d 	void *thisarg;A! 	struct dsc$descriptor_s *dscptr;g  > 	fprintf(ReportFP, "\n\tArgument Stack: (count is %d)", argc); #ifdef __ALPHA( 	fprintf(ReportFP, " (probably bogus)"); #endif 	fprintf(ReportFP, "\n\n");r   	if (argc == 0) {d$ 		fprintf(ReportFP, "\t\t<none>\n");	 		return;  	}   #ifdef SAMPLE_VAX_OUTPUT 		A0  =  00000000 ( 		A1  =  00000000  :  00  0000  00000000( 		A2  =  00000000  :  00  0000  000000007 		A3  =  00000000  :  00  0000  00000000  "hello world"u #endif   #ifdef SAMPLE_AXP_OUTPUT #endif   #ifdef __VAX 	for (j = 0; j < argc; j++) {; 		thisarg = ap->args[j];7 		fprintf(ReportFP, "\t\tA%d  =  %8X", j + 1, thisarg);u 		expandLimit = 8;4 		while (DSC_CanReadMemory(sizeof(long), thisarg)) {! 			if (--expandLimit <= 0) break;e, 			fprintf(ReportFP, "  -->  %2X  %4X  %8X",2 				(unsigned long) *((unsigned char  *) thisarg),2 				(unsigned long) *((unsigned short *) thisarg),3 				(unsigned long) *((unsigned long  *) thisarg));90 			dscptr = (struct dsc$descriptor_s *) thisarg;* 			if (HER_I_CheckDescriptorArg(dscptr)) {; 				fprintf(ReportFP, "  \"%-*.*s\"", dscptr->dsc$w_length,T2 					dscptr->dsc$w_length, dscptr->dsc$a_pointer); 				thisarg = NULL;  			}7 			else if (HER_I_CheckAsciiArg(0, (char *) thisarg)) {Y4 				fprintf(ReportFP, "  \"%s\"", (char *) thisarg); 				thisarg = NULL;$ 			}	 			else { + 				thisarg = (void *) *((long *) thisarg);_ 			} 		}o 		fprintf(ReportFP, "\n"); 	} #endif #ifdef __ALPHA 	fprintf(ReportFP, "\n");I #endif   	return; }    i) MEP__ UNIVERSAL void HER_K_SaveImageInfo(c 	char *pcImageName,p 	void *pvStart,  	void *pvEnd )i {   	if (nImageCount < MAX_IMAGES) {6 		strcpy(ImageInfo[nImageCount].imgname, pcImageName);+ 		ImageInfo[nImageCount].vastart = pvStart;x) 		ImageInfo[nImageCount].vaend   = pvEnd;v 		++nImageCount; 	}   	return; }     * MEP__ PRIVATE void HER_I_PrintImageOffset( 	char *pcLabel,n 	void *pvPCt )o {* 	int j;n  : 	fprintf(ReportFP, "\n\t\t%s = %8X", pcLabel, (int) pvPC);$ 	for (j = 0; j < nImageCount; j++) {C 		if (ImageInfo[j].vastart <= pvPC && pvPC <= ImageInfo[j].vaend) {ec 			fprintf(ReportFP, " (%s + %8X)", ImageInfo[j].imgname, (int) pvPC - (int) ImageInfo[j].vastart);H	 			break;e 		}( 	}   	return; }S   r# MEP__ PRIVATE void HER_I_ShowFrame(T 	FrameData *fdpN )L {  	int j;h 	int k;e 	int numberOfArgs; 	unsigned long entrymask;t 	long stackptr;  	ArgStack *ap; 	void *framepc;, #ifdef __ALPHA 	struct pdscdef *procdescptr;n #endif  e 	/* title and PC for this call frame.  notice that axp-vms has two possible PCs, so i show them both:  	 *RJ 	 * (from _The OpenVMS Calling Standard_, chapter 3, section 6, table 3-3) 	 *E 	 *         PDSC$Q_ENTRYg 	 *         The absolute address of the first instruction of the entry code sequence for the procedure.L 	 *O 	 * (from table 3-10)e 	 *;$ 	 *         LIBICB$Q_PROGRAM_COUNTERZ 	 *         A quadword that contains the current value of the procedure's program counter.] 	 *         For interrupted procedures, this is the same as the continuation program counter;1W 	 *         for active procedures, this is the return address back into that procedure.s 	 */ #ifdef __VAX! 	framepc = (void *) fdp->savedPC;  #endif #ifdef __ALPHA5 	framepc = (void *) fdp->libicb$q_program_counter[0];, #endif5 	fprintf(ReportFP, "\n\tFrame #%d:\n", FrameCount--);P4 	HER_I_PrintImageOffset("Program Counter", framepc); #ifdef __ALPHAF 	procdescptr = (struct pdscdef *) fdp->libicb$ph_procedure_descriptor;R 	HER_I_PrintImageOffset("Entry Point    ", (void *) procdescptr->pdsc$q_entry[0]);8 	HER_I_PrintImageOffset("Procedure Desc ", procdescptr); #endif 	fprintf(ReportFP, "\n");}   	/* restore any saved registersR 	 */ #ifdef __VAX, 	entrymask = (unsigned long) fdp->entryMask;# 	for (j = k = 0; j < REG_AP; j++) {V 		if (entrymask & (1 << j)) {n% 			TrueRegs[j] = fdp->savedRegs[k++];  		}D 	}& 	TrueRegs[REG_AP].pval = fdp->savedAP;& 	TrueRegs[REG_FP].pval = fdp->savedFP;& 	TrueRegs[REG_PC].pval = fdp->savedPC; #endif #ifdef __ALPHA 	/* VAXman says:] 	 *         You need to get the offset to the register save area from the procedure's PDSC at b 	 *         PDSC$W_RSA_OFFSET then, apply that offset to the frame pointer.  The RA register (R26)b 	 *         is saved first and then, the registers in accending order as specified by the registerZ 	 *         save masks in PDSC->PDSC$L_IREG_MASK and PDSC->PDSC$L_FREG_MASK, repsectively.` 	 *         As on the VAX, you can *only* obtain the register values which were masked (saved on3 	 *         the stack) by the procedure's prologue.; 	 * d 	 * unfortunately, i've checked the source listings --- [Vxx.LIBRTL.LIS]LIB$CALLING_STANDARD.LIS ---a 	 * only to verify that the lib$get_curr_invo_context() and lib$get_prev_invo_context() functionsgg 	 * already do all of the register restoring vaxman describes above, yet the numbers are *still* wrong! j 	 * i finally realized that the compiler plays fast & loose with not only the argument registers (R16-R21)h 	 * but the argument-information register itself (R25), and is in fact allowed to do so by the standard;5 	 * Table 3-1 of _The OpenVMS Calling Standard_ says:r 	 *(
 	 *       AXP  	 *       IntegerV 	 *       Register  Usaget 	 * p 	 *         R0      Function value register. In a standard call that returns a nonfloating-point function resultr 	 *                 in a register, the result must be returned in this register. In a standard call, this registern 	 *                 may be modified by the called procedure without being saved and restored. This register is@ 	 *                 not to be preserved by any called procedure. 	 * r 	 *         R1      Conventional scratch register. In a standard call, this register may be modified by the calledr 	 *                 procedure without being saved and restored. This register is not to be preserved by any called 	 *                 procedure. 	 * j 	 *         R2-15   Conventional saved registers. If a standard-conforming procedure modifies one of these; 	 *                 registers, it must save and restore it.  	 *Xm 	 *         R16-21  Argument registers. In a standard call, up to six nonfloating-point items of the argumentsr 	 *                 list are passed in these registers. In a standard call, these registers may be modified by theF 	 *                 called procedure without being saved and restored. 	 *in 	 *         R22-24  Conventional scratch registers. In a standard call, these registers may be modified by theF 	 *                 called procedure without being saved and restored. 	 *rx 	 *  ===>   R25     Argument information (AI) register. In a standard call, this register describes the argument    <===x 	 *  ===>           list (see Section 3.7.1, for a detailed description). In a standard call, this register may be  <===x 	 *  ===>           modified by the called procedure without being saved and restored.                              <=== 	 *co 	 *         R26     Return address (RA) register. In a standard call, the return address must be passed in this_o 	 *                 register. In a standard call, this register may be modified by the called procedure withoutF- 	 *                 being saved and restored.  	 * q 	 *         R27     Procedure value (PV) register. In a standard call, the procedure value of the procedure beingFo 	 *                 called is passed in this register. In a standard call, this register may be modified by theoF 	 *                 called procedure without being saved and restored. 	 *so 	 *         R28     Volatile scratch register. The contents of this register are always unpredictable after anyar 	 *                 external transfer of control either to or from a procedure.  This applies to both standard andr 	 *                 nonstandard calls.  This register may be used by the operating system for external call fixup,4 	 *                 autoloading, and exit sequences. 	 *Vq 	 *         R29     Frame pointer (FP). The contents of this register define, among other things, which procedure e 	 *                 is considered current. Details of usage and alignment are defined in Section 3.6.	 	 *Es 	 *         R30     Stack pointer (SP). This register contains a pointer to the top of the current operating stack.dh 	 *                 Aspects of its usage and alignment are defined by the hardware architecture. Various] 	 *                 software aspects of its usage and alignment are defined in Section 3.7.1.f 	 *Pp 	 *         R31     ReadAsZero/Sink (RZ). Hardware defined: binary zero as a source operand, sink (no effect) as% 	 *                 a result operand.t 	 */ #endif  3 	/* calculate the number of arguments at this pointf7 	 * and adjust the Stack Pointer, since it is not saved  	 */ 	numberOfArgs = 0; #ifdef __VAX# 	if ((ap = fdp->savedAP) != NULL) {F, 		if (DSC_CanReadMemory(sizeof(long), ap)) {0 			if (ap->argCount > 0 && ap->argCount <= 32) {  				numberOfArgs = ap->argCount; 			} 		}0 	}' 	stackptr  = (long) fdp + sizeof(long);  	stackptr += fdp->spa; 	stackptr += sizeof(CallFrame);f 	stackptr += k * sizeof(long);; 	if (fdp->isCALLS) stackptr += numberOfArgs * sizeof(long);k+ 	TrueRegs[REG_SP].pval = (void *) stackptr;t #endif  4 	/* output the values in the registers at this point 	 */ 	HER_I_ShowRegisters(fdp);  ; 	/* output the values from the argument stack at this pointt 	 */' 	HER_I_ShowArguments(ap, numberOfArgs);e   	return; }    f( MEP__ PRIVATE CONDVAL HER_I_LoadHandler( 	long sigargs[], 	long mechargs[] )r {	 #ifdef IGNORE_MISSING_SHERLOCK #ifdef __ALPHAK 	if ($VMS_STATUS_MSG_NO(sigargs[1]) == $VMS_STATUS_MSG_NO(LIB$_ACTIMAGE)) {oL 		if ($VMS_STATUS_FAC_NO(sigargs[1]) == $VMS_STATUS_FAC_NO(LIB$_ACTIMAGE)) {H 			if ($VMS_STATUS_MSG_NO(sigargs[1]) == $VMS_STATUS_MSG_NO(RMS$_FNF)) {I 				if ($VMS_STATUS_FAC_NO(sigargs[1]) == $VMS_STATUS_FAC_NO(RMS$_FNF)) {i 					return(SS$_CONTINUE); 				}  			} 		}t 	} #endifL 	if ($VMS_STATUS_MSG_NO(sigargs[1]) == $VMS_STATUS_MSG_NO(LIB$_KEYNOTFOU)) {M 		if ($VMS_STATUS_FAC_NO(sigargs[1]) == $VMS_STATUS_FAC_NO(LIB$_KEYNOTFOU)) {f 			return(SS$_CONTINUE); 		}k 	} #endif   	return(SS$_RESIGNAL); }d   A) MEP__ PRIVATE CONDVAL HER_I_LoadSherlock(\ 	void  )P {d< 	/* we must install our own error handler for temporary use,C 	 * because (get this) the LIB routine actually signals from within-) 	 * if it can't find the function, ha ha.n 	 */" 	lib$establish(HER_I_LoadHandler);R 	return(lib$find_image_symbol(&SherlockImage, &SherlockName, &SherlockPtr, NULL)); }c   - #ifdef __ALPHA  & MEP__ PRIVATE void DSC_GetMyRegisters(" 	VMSRegister *regptr	/* ignored */ )  {> 	int j;  	int k;i 	FrameData icbblock;  G 	/* IR31 and FR31 are not saved (since they are RAZ) so skip over them.aI 	 * and, yes, dec's floating-point registers are of the int64 type (sigh)o 	 */& 	lib$get_curr_invo_context(&icbblock); 	k = 0;V4 	for (j = 0; j < NUMBER_OF_INT_REGISTERS - 1; j++) {1 		TrueRegs[k++].qval = icbblock.libicb$q_ireg[j];n 	} 	TrueRegs[k++].qval = 0;6 	for (j = 0; j < NUMBER_OF_FLOAT_REGISTERS - 1; j++) {1 		TrueRegs[k++].qval = icbblock.libicb$q_freg[j];r 	} 	TrueRegs[k++].qval = 0;   	return; }{   #endif   ;, MEP__ UNIVERSAL CONDVAL HER_ReportException( 	SignalArray *sigargs, 	MechArray *mechargs )i {f 	char *reason; 	char *tmpptr;
 	CONDVAL cv0;. 	SignalArray *newsigs; 	char rptfs[132];> #ifdef __VAX 	CallFrame *fp, *saveFP; 	char **specialPCaddr; #endif #ifdef __ALPHA 	FrameData icbblock; #endif   	if (Reporting) {  		return(SS$_RESIGNAL);i 	} 	Reporting = TRUE;  E 	/* quick!  save the register values before our code overwrites them!  	 */ 	DSC_GetMyRegisters(TrueRegs);   #ifdef __VAX 	specialPCaddr = NULL; 	saveFP = mechargs->frame;$ 	mechargs->frame = DSC_GetMyFrame();  I 	/* usually the call frame's PC will point at or close to the instruction F 	 * dealing with whatever is going on.  however, exceptions seem to beE 	 * (pardon me) an exception.  if my code look like this at PC 20000:  	 *_ 	 *        char *foo, bar; 	 *s 	 *        foo = NULL; 	 *        bar = *foo; 	 *LB 	 * then the image seems to jump to some other region where it canB 	 * prepare the SignalArray and MechanismArray so that it can callE 	 * whatever handler is first in line, with the result that while the0E 	 * rest of the call frame contains valid information, the PC is left F 	 * pointing to this intermediate area (typically 0x80000014) which isG 	 * not useful at all.  in this case we will take advantage of the fact D 	 * that the true PC (i.e., the one in which we are most interested)D 	 * and PSL are passed along in the SignalArray, which does not look4 	 * like a SignalArray, for all hardware exceptions: 	 *0  	 *        +-------------------+* 	 *        |    arg count      | : sigargs  	 *        +-------------------+  	 *        |    cond value     |  	 *        +-------------------+  	 *        |      arg 1        |  	 *        +-------------------+  	 *        |      arg 2        |  	 *        +-------------------+  	 *        |        .          |  	 *        +-------------------+  	 *        |        .          |  	 *        +-------------------+8 	 *        |      arg n        |     (n = arg count - 3)  	 *        +-------------------+  	 *        |       PC          |  	 *        +-------------------+  	 *        |       PSL         |  	 *        +-------------------+ 	 *R% 	 * instead of something more normal:  	 *   	 *        +-------------------+* 	 *        | total arg count   | : sigargs  	 *        +-------------------+  	 *        | first cond value  |  	 *        +-------------------+  	 *        |    first arg 1    |  	 *        +-------------------+  	 *        |    first arg 2    |  	 *        +-------------------+  	 *        |        .          |  	 *        +-------------------+  	 *        |        .          |  	 *        +-------------------+  	 *        |    first arg n    |  	 *        +-------------------+  	 *        | second cond value |  	 *        +-------------------+  	 *        |    second arg 1   |  	 *        +-------------------+  	 *        |    second arg 2   |  	 *        +-------------------+  	 *        |        .          |  	 *        +-------------------+  	 *        |        .          |  	 *        +-------------------+  	 *        |    second arg n   |  	 *        +-------------------+  	 *        |        .          |  	 *        +-------------------+  	 *        |        .          |  	 *        +-------------------+  	 *        |    final arg n    |  	 *        +-------------------+ 	 *jF 	 * unfortunately this is not explicitly documented anywhere, althoughF 	 * details about the specific condition values and specific argumentsC 	 * thereof can be found on page 10-2 of the Introduction to System-& 	 * Services (Volume 4A of the P set). 	 * C 	 * the question becomes, how can you tell a true SignalArray whichRB 	 * develops from a user's call to lib$signal() from an exception?I 	 * the first method i tried was to examine the PC from which the handler(C 	 * was called, and guess if it occurred in system space (typicallykI 	 * 0x80000014).  this was too kludgy so now i just compare the conditionRC 	 * value against the list of statuses Digital defines as Exception(9 	 * Conditions on the pages mentioned above.  this is whynG 	 * CheckForException() returns FALSE, TRUE, or MAYBE:  FALSE means the'F 	 * status is not one that we are interested in reporting at all, TRUEA 	 * means it is an Official Digital Hardware Exception and shouldeI 	 * definitely be reported, and MAYBE means it is not an actual exceptionp' 	 * but we want to log it as if it was.; 	 * 4 	 * an example of the most common exception follows: 	 *g  	 *        +-------------------+* 	 *        |        5          | : sigargs  	 *        +-------------------+  	 *        |    SS$_ACCVIO     |  	 *        +-------------------+  	 *        |    reason mask    |  	 *        +-------------------+  	 *        |  virtual address  |  	 *        +-------------------+@ 	 *        |       PC          |    (this is where the violation; 	 *        +-------------------+         actually occurred)   	 *        |       PSL         |  	 *        +-------------------+ 	 */  E 	/* check for an "uninteresting" PC.  if true, we need to replace it;rD 	 * however, since a call from a hardware exception does not conformA 	 * to the normal signal array, we cast the "sigargs" value to beiG 	 * a <pointer to long> and then offset to where the true PC should be.  	 */1 	if (HER_CheckForException(0, sigargs) == TRUE) {08 		if (mechargs->frame->savedFP->savedPC == SPECIAL_PC) { 			long *longptr; 6 			specialPCaddr = &mechargs->frame->savedFP->savedPC; 			longptr  = (long *) sigargs;e) 			longptr += sigargs->totalArgCount - 1;;; 			mechargs->frame->savedFP->savedPC = (void *) (*longptr);A 		}  	} #endif  7 	/* drop the channel that we have reserved for our use,y' 	 * so that there will be one availablen 	 */ 	if (TrackChannel != 0) {R 		sys$dassgn(TrackChannel);X 		TrackChannel = 0;g 	}  D 	/* try to <open for appending>/<create> the exceptions report file.E 	 * if we cannot do so for any reason, we want to create a new signaltA 	 * array which copies everything from the original and then addstE 	 * some more condition values:  one to explain why we cannot open oreC 	 * create the file, and another one for each call frame to displayr@ 	 * the PC so that at least SOMEONE will see the function stack. 	 * F 	 * note that detached processes do not necessarily have the SYS$LOGIN) 	 * or SYS$SCRATCH logicals defined . . .i 	 */ 	rptfs[0] = '\0';_- 	if ((tmpptr = getenv("HER_PATH")) == NULL) {e 		tmpptr = getenv("SYS$LOGIN");p 	} 	if (tmpptr != NULL) { 		strcpy(rptfs, tmpptr); 	}) 	strcat(rptfs, "HARDWARE_EXCEPTION.RPT");aW 	if ((ReportFP = fopen(rptfs, "a", "ctx=rec", "mrs=0", "rat=cr", "rfm=var")) == NULL) {c 		cv0 = vaxc$errno;u 	} 	else {p 		newsigs = NULL;g% 		HER_I_ShowExceptionHeader(sigargs);   		HER_I_ShowCallStack(mechargs);, 		DSC_ShowProcessData(NULL, ReportFP, NULL);+ 		DSC_ShowSystemData(NULL, ReportFP, NULL);f 		if (SherlockPtr == NULL) { 			HER_I_LoadSherlock(); 		}r 		if (SherlockPtr != NULL) { 			nImageCount = 0;C@ 			(*SherlockPtr)(0, ReportFP, NULL, NULL, HER_K_SaveImageInfo); 		}  #ifdef this_is_not_trustworthy 		FrameCount = mechargs->depth;s #else"+ 		FrameCount = HER_I_CountFrames(mechargs);a #endif #ifdef __VAX< 		for (fp = mechargs->frame; fp != NULL; fp = fp->savedFP) {, 			if (HER_I_CanProcess(fp) == FALSE) break; 			HER_I_ShowFrame(fp);n 		}O #endif #ifdef __ALPHA' 		lib$get_curr_invo_context(&icbblock);a 		for (;;) { 			HER_I_ShowFrame(&icbblock);8 			if (lib$get_prev_invo_context(&icbblock) == 0) break; 		}l #endif4 		fprintf(ReportFP, "\n\tFrame #0:\n\n\t\tshell\n");3 		fprintf(ReportFP, "\nend of EXCEPTION report\n");d 		fclose(ReportFP);i 		cv0 = SS$_NORMAL;E 	}  5 	/* try to keep a channel reserved for future reportso 	 */ 	HER_I_SaveChan();  1 	/* restore the frame pointer and program counter  	 */ #ifdef __VAX8 	if (specialPCaddr != NULL) *specialPCaddr = SPECIAL_PC; 	mechargs->frame = saveFP; #endif  / 	/* reset this module's static flags & pointers  	 */ 	ReportFP = NULL;d 	Reporting = FALSE;e  
 	return(cv0);i }p