# This file is read by Makefile.SH to produce rules for $(perllib)
# We insert perl5.def since I do not know how to generate it yet.

$spitshell >>Makefile <<'!NO!SUBS!'
$(perllib): perl.imp perl.dll perl5.def
	emximp -o $(perllib) perl.imp

perl.imp: perl5.def
	emximp -o perl.imp perl5.def

perl.dll: $(obj) perl5.def perl$(O)
	$(LD) $(LDDLFLAGS) -o $@ perl$(O) $(obj) -lsocket perl5.def

perl5.def: perl.linkexp
	echo "LIBRARY 'Perl' INITINSTANCE TERMINSTANCE"	> $@
	echo DESCRIPTION "'Perl interpreter, export autogenerated'"	>>$@
	echo STACKSIZE 32768				>>$@
	echo CODE LOADONCALL				>>$@
	echo DATA LOADONCALL NONSHARED MULTIPLE		>>$@
	echo EXPORTS					>>$@
	echo '  "ctermid"'				>>$@
	echo '  "ttyname"'				>>$@
	cat perl.linkexp	>>$@

#	grep -v '"\(malloc\|realloc\|free\)"' perl.linkexp	>>$@


# We assume here that perl is available somewhere ...

perl.exports: perl.exp EXTERN.h perl.h
	(echo '#include "EXTERN.h"'; echo '#include "perl.h"' ; \
			echo '#include "perl.exp"') | \
		$(CC) -DEMBED  -E - | \
		awk '{if ($$2 == "") print $$1}' | sort | uniq > $@

#		perl -ne 'print if (/^#!/ .. /^#\s/) && s/^(\w+) *$$/$$1/' > $@

perl.linkexp: perl.exports perl.map
	cat perl.exports perl.map | sort | uniq -d | sed -e 's/\w\+/  "\0"/' > perl.linkexp

perl.map: $(obj) perl$(O) miniperlmain$(O)
	$(CC) $(LARGE) $(CLDFLAGS) $(CCDLFLAGS) -o dummy.exe miniperlmain$(O) perl$(O) $(obj) -lsocket -lm -Zmap -Zlinker /map
	awk '{if ($$3 == "") print $$2}' <dummy.map | sort | uniq > perl.map
	rm dummy.exe dummy.map

depend: os2ish.h

os2.c: os2/os2.c os2ish.h
	cp $< $@

os2ish.h: os2/os2ish.h
	cp $< $@

!NO!SUBS!
