	PROGRAM ADVEXAMPLE
C
C PROGRAM TO GENERATE RANDOM N-TUPLE AND HISTOGRAM DATA AND DEMONSTRATE
C	 ADVANCED FEATURES OF HISTO-SCOPE, E.G. INDICATORS AND CONTROLS
C
	IMPLICIT NONE
C#include "histoscope.inc"
C
C   IF COMPILING PROGRAM ON VMS OR IBM/AIX SYSTEM, COMMENT OUT
C   ABOVE INCLUDE AND REMOVE THE C IN COLUMN 1 OF NEXT ONE
C
	INCLUDE 'HISTO_INC:histoscope.inc'
	INTEGER I, J, K, N_VARIABLES, HS1_ID, HS2_ID, NTUPLE_ID
	INTEGER CTRL_ID, IND_ID, CTRL_NPTS_ID, CTRL_MERRS_ID
	INTEGER TRIGGER_ID, NUM_PTS, ISTAT
	REAL VALUES(8), CVAL, FVALPTS, ERRVAL_M
	REAL ERRS1D(100), ERRS2D(10000), ERRS1D_M(100), ERRS2D_M(10000)
	REAL RNDOM
	CHARACTER*8 TAGS(8)
	COMMON/PAWC/H
	REAL*4 H(1 000 000)
	
	N_VARIABLES = 8
	NUM_PTS = 10000
        TAGS(1) = 'X'
        TAGS(2) = 'Y'
        TAGS(3) = 'IDX'
        TAGS(4) = 'SQRT(X)'
        TAGS(5) = 'SQRT(Y)'
        TAGS(6) = 'LOG(X)'
        TAGS(7) = 'LOG(Y)'
        TAGS(8) = 'SIN(IDX)'
	DO I = 1, 10000
	    ERRS2D(I) = .1
	    ERRS2D_M(I) = 0.
	ENDDO
	DO I = 1, 100
	    ERRS1D(I) = .1
	    ERRS1D_M(I) = 0.
	ENDDO
	CALL HS_INITIALIZE('ADVEXAMPLE')
	CALL HS_HISTOSCOPE(1)
 	NTUPLE_ID = HS_CREATE_NTUPLE(101, 'EXAMPLE NTUPLE', 'HS',
     &      N_VARIABLES, TAGS)
 	HS1_ID = HS_CREATE_1D_HIST(102, 'EXAMPLE 1D HIST', 'HS', 'Y',
     &      'TOTAL' ,100, 4600., 5400.)
 	HS2_ID = HS_CREATE_2D_HIST(103, '2D HIST EXAMPLE', 'HS','X',
     &      'Y', 'TOTAL', 100, 100, 4600., 5400., 4600., 5400.)
	IND_ID = HS_CREATE_INDICATOR(104, 'INDICATOR EXAMPLE', 'HS',
     &      0., 10000.)
	CTRL_ID = HS_CREATE_CONTROL(201, 'CONTROL: PAUSE IF .LT. 0',
     &      'HS', -500., +500., 0.)
	CTRL_NPTS_ID = HS_CREATE_CONTROL(202, 'CONTROL: NUM OF PTS',
     &      'HS', 0., 10000., 10000.)
	CTRL_MERRS_ID = HS_CREATE_CONTROL(203,
     &      'CONTROL: ACCUM NONSYM NEG ERRS', 'HS', 0., 1., 0.)
	TRIGGER_ID = HS_CREATE_TRIGGER(301, 'TRIGGER EXAMPLE', 'HS')
	CALL HLIMIT(250 000)
        CALL HBOOKN(900, 'EXAMPLE NTUPLE', N_VARIABLES, ' ', 1000, TAGS)
        CALL HBOOK2(5000,'2D HIST EXAMPLE',100,4600.,5400., 100,4600.,
     &      5400.0, 0.)
        CALL HBOOK1(6000,'EXAMPLE 1D HIST',100,4600.,5400.,0.0)
	PRINT *, ' HLDIR CALLED: '
	CALL HLDIR('//PAWC', 'T')
	CALL HS_HBOOK_SETUP('//PAWC')
C
C	    RANDOM DATA COMPUTATION - THIS COULD BE ANY CODE YOU WISH
C	
	I = 1
	DO WHILE (I .LE. NUM_PTS)
    	    DO J = 1, 2
    		VALUES(J) = 0
    		DO K = 1, 1000
    	    	    VALUES(J) = VALUES(J) + RNDOM() * 10.
    		ENDDO
    	    ENDDO
    	    
    	    VALUES(3) = I
    	    VALUES(4) = SQRT(VALUES(1))
    	    VALUES(5) = SQRT(VALUES(2))
    	    VALUES(6) = LOG(VALUES(1))
    	    VALUES(7) = LOG(VALUES(2))
    	    VALUES(8) = SIN(VALUES(3))

    	    ISTAT = HS_FILL_NTUPLE(NTUPLE_ID, VALUES)
    	    CALL HS_FILL_1D_HIST(HS1_ID, VALUES(2), 1.)
    	    CALL HS_FILL_2D_HIST(HS2_ID, VALUES(1), VALUES(2), 1.)
    	    CALL HS_SET_INDICATOR(IND_ID, FLOAT(I))
	    CALL HFILL(5000, VALUES(1), VALUES(2), 1.)
	    CALL HFILL(6000, VALUES(2), 0., 1.)
	    CALL HFN(900, VALUES)
    	    IF (HS_CHECK_TRIGGER(TRIGGER_ID) .NE. 0)
     &           PRINT *, ' Trigger set by HistoScope'
    	    CALL HS_UPDATE

	    IF ( MOD(I, 200) .EQ. 0)  THEN 
                 PRINT *, ' Reaching computation ...', I
    	         CALL HS_SET_1D_ERRORS(HS1_ID, ERRS1D, %VAL(0))
    	         CALL HS_SET_2D_ERRORS(HS2_ID, ERRS2D, %VAL(0))
    	         CALL HS_READ_CONTROL(CTRL_MERRS_ID, ERRVAL_M)
		 DO K = 1, 10000
		     ERRS2D(K) = ERRS2D(K) + .1
    	             IF (ERRVAL_M .GT. 0)  
     &                         ERRS2D_M(K) = ERRS2D_M(K) + ERRVAL_M
		 ENDDO
		 DO K = 1, 100
		     ERRS1D(K) = ERRS1D(K) + .1
    	             IF (ERRVAL_M .GT. 0)  
     &                         ERRS1D_M(K) = ERRS1D_M(K) + ERRVAL_M
		 ENDDO
    	         IF (ERRVAL_M .GT. 0) THEN 
    	             CALL HS_SET_1D_ERRORS(HS1_ID, %VAL(0), ERRS1D_M)
    	             CALL HS_SET_2D_ERRORS(HS2_ID, %VAL(0), ERRS2D_M)
    	         ENDIF
            ENDIF
    	    CALL HS_READ_CONTROL(CTRL_ID, CVAL)
    	    CALL HS_READ_CONTROL(CTRL_NPTS_ID, FVALPTS)
    	    NUM_PTS = INT(FVALPTS)
    	    DO WHILE (CVAL .LT. 0.) 
    	    	 IF (HS_CHECK_TRIGGER(TRIGGER_ID) .NE. 0)
     &               PRINT *, ' Trigger set by HistoScope'
    	    	 CALL HS_UPDATE
    	    	 CALL HS_READ_CONTROL(CTRL_ID, CVAL)
            ENDDO
	I = I + 1
	END DO
	ISTAT = HS_SAVE_FILE('advExample.hs')
	CALL HS_COMPLETE_AND_WAIT
	CALL HRPUT(0, 'advexample.hst', 'TN')
	STOP
	END


      REAL FUNCTION RNDOM()
      INTEGER A,M,Q,R,HI,LO,TEST
      DATA A, M, Q, R, ISEED /16807, 2147483647, 127773, 2836, 19283755/

      HI = ISEED/Q
      LO = MOD(ISEED,Q)
      TEST = A*LO - R*HI
      IF(TEST.GT.0)  THEN
        ISEED = TEST
      ELSE
        ISEED = TEST + M
      END IF
      RNDOM = FLOAT(ISEED)/M
      RETURN
      END
	
