	PROGRAM HBOOKEXAMPLE
C
C PROGRAM TO GENERATE RANDOM N-TUPLE AND HISTOGRAM DATA
C
	IMPLICIT NONE
C#include "histoscope.inc"
C
C   IF COMPILING PROGRAM ON VMS OR IBM/AIX SYSTEM, COMMENT OUT
C   ABOVE INCLUDE AND REMOVE THE C IN COLUMN 1 OF NEXT ONE
C
	INCLUDE 'HISTO_INC:histoscope.inc'
	INTEGER I, J, K, N_VARIABLES  
	REAL VALUES(8)
	REAL RNDOM
	CHARACTER*8 TAGS(8)
	COMMON/PAWC/H
	REAL*4 H(1 000 000)
	
	N_VARIABLES = 8
        TAGS(1) = 'X'
        TAGS(2) = 'Y'
        TAGS(3) = 'IDX'
        TAGS(4) = 'SQRT(X)'
        TAGS(5) = 'SQRT(Y)'
        TAGS(6) = 'LOG(X)'
        TAGS(7) = 'LOG(Y)'
        TAGS(8) = 'SIN(IDX)'
	CALL HS_INITIALIZE('hbookExample.f')
	CALL HS_HISTOSCOPE(1)
	CALL HLIMIT(250 000)
        CALL HBOOKN(900, 'EXAMPLE NTUPLE', N_VARIABLES, ' ', 1000, TAGS)
        CALL HBOOK2(5000,'2D HIST EXAMPLE',100,4600.,5400., 100,4600.,
     &     5400.0, 0.)
        CALL HBOOK1(6000,'EXAMPLE 1D HIST',100,4600.,5400.,0.0)
	PRINT *, ' HLDIR CALLED: '
	CALL HLDIR('//PAWC', 'T')
	CALL HS_HBOOK_SETUP('//PAWC')
C
C	    RANDOM DATA COMPUTATION - THIS COULD BE ANY CODE YOU WISH
C	
	DO I = 1, 10000
    	    DO J = 1, 2
    		VALUES(J) = 0
    		DO K = 1, 1000
    	    	    VALUES(J) = VALUES(J) + RNDOM(0) * 10.
    		ENDDO
    	    ENDDO
    	    
    	    VALUES(3) = I
    	    VALUES(4) = SQRT(VALUES(1))
    	    VALUES(5) = SQRT(VALUES(2))
    	    VALUES(6) = LOG(VALUES(1))
    	    VALUES(7) = LOG(VALUES(2))
    	    VALUES(8) = SIN(VALUES(3))

	    CALL HFILL(5000, VALUES(1), VALUES(2), 1.)
	    CALL HFILL(6000, VALUES(2), 0., 1.)
	    CALL HFN(900, VALUES)
    	    CALL HS_UPDATE

	    IF ( MOD(I, 200) .EQ. 0)  THEN 
                 PRINT *, ' Reaching computation ...', I
            ENDIF
	END DO
	CALL HS_COMPLETE
	CALL HRPUT(0, 'hbookexample.hst', 'TN')
	STOP
	END
	
      REAL FUNCTION RNDOM()
      INTEGER A,M,Q,R,HI,LO,TEST
      DATA A, M, Q, R, ISEED /16807, 2147483647, 127773, 2836, 19283755/

      HI = ISEED/Q
      LO = MOD(ISEED,Q)
      TEST = A*LO - R*HI
      IF(TEST.GT.0)  THEN
        ISEED = TEST
      ELSE
        ISEED = TEST + M
      END IF
      RNDOM = FLOAT(ISEED)/M
      RETURN
      END

	
