	PROGRAM HSEXAMPLE
C
C PROGRAM TO GENERATE RANDOM N-TUPLE AND HISTOGRAM DATA
C
	IMPLICIT NONE
C#include "histoscope.inc"
C
C   IF COMPILING PROGRAM ON VMS OR IBM/AIX SYSTEM, COMMENT OUT
C   ABOVE INCLUDE AND REMOVE THE C IN COLUMN 1 OF NEXT ONE
C
	INCLUDE 'HISTO_INC:histoscope.inc'
	INTEGER I, J, K, N_VARIABLES, HS1_ID, HS2_ID, NTUPLE_ID
	INTEGER IND_ID, ISTAT
	REAL VALUES(8)
	REAL RNDOM
	CHARACTER*8 TAGS(8)
	
	N_VARIABLES = 8
        TAGS(1) = 'X'
        TAGS(2) = 'Y'
        TAGS(3) = 'IDX'
        TAGS(4) = 'SQRT(X)'
        TAGS(5) = 'SQRT(Y)'
        TAGS(6) = 'LOG(X)'
        TAGS(7) = 'LOG(Y)'
        TAGS(8) = 'SIN(IDX)'
	CALL HS_INITIALIZE('hsExample.f')
	CALL HS_HISTOSCOPE(1)
 	NTUPLE_ID = HS_CREATE_NTUPLE(101, 'EXAMPLE NTUPLE', 'HS',
     &     N_VARIABLES, TAGS)
 	HS1_ID = HS_CREATE_1D_HIST(102, 'EXAMPLE 1D HIST', 'HS', 'Y',
     &     'TOTAL', 100, 4600., 5400.)
 	HS2_ID = HS_CREATE_2D_HIST(103, '2D HIST EXAMPLE', 'HS','X', 'Y',
     &     'TOTAL', 100, 100, 4600., 5400., 4600., 5400.)
	IND_ID = HS_CREATE_INDICATOR(104, 'INDICATOR EXAMPLE', 'HS', 0.,
     &      10000.)
C
C	    RANDOM DATA COMPUTATION - THIS COULD BE ANY CODE YOU WISH
C	
	DO I = 1, 10000
    	    DO J = 1, 2
    		VALUES(J) = 0
    		DO K = 1, 1000
    	    	    VALUES(J) = VALUES(J) + RNDOM() * 10.
    		ENDDO
    	    ENDDO
    	    
    	    VALUES(3) = I
    	    VALUES(4) = SQRT(VALUES(1))
    	    VALUES(5) = SQRT(VALUES(2))
    	    VALUES(6) = LOG(VALUES(1))
    	    VALUES(7) = LOG(VALUES(2))
    	    VALUES(8) = SIN(VALUES(3))

    	    ISTAT = HS_FILL_NTUPLE(NTUPLE_ID, VALUES)
    	    CALL HS_FILL_1D_HIST(HS1_ID, VALUES(2), 1.)
    	    CALL HS_FILL_2D_HIST(HS2_ID, VALUES(1), VALUES(2), 1.)
    	    CALL HS_SET_INDICATOR(IND_ID, FLOAT(I))
    	    CALL HS_UPDATE

	    IF ( MOD(I, 200) .EQ. 0)  THEN 
                 PRINT *, ' Reaching computation ...', I
            ENDIF
	END DO
	ISTAT = HS_SAVE_FILE('hsExample.hs')
	CALL HS_COMPLETE
	STOP
	END
	
      REAL FUNCTION RNDOM()
      INTEGER A,M,Q,R,HI,LO,TEST
      DATA A, M, Q, R, ISEED /16807, 2147483647, 127773, 2836, 19283755/

      HI = ISEED/Q
      LO = MOD(ISEED,Q)
      TEST = A*LO - R*HI
      IF(TEST.GT.0)  THEN
        ISEED = TEST
      ELSE
        ISEED = TEST + M
      END IF
      RNDOM = FLOAT(ISEED)/M
      RETURN
      END

	
