$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$! SETUP procedure for Histo-Scope V2.0.1
$!
$! Author : Joy Kyriakopulos, PAT Computing, Fermilab
$!
$! Purpose :
$! 	Define HISTO_DIR and HISTO_ROOT to proper directory.
$! 	Define HISTO_SHR to point to shareable image for client programs.
$!	Ensure HISTO_PROCESS_DIR for client programs' ID files is defined.
$!	Define HISTOSCOPE foreign command for Histo process.
$!
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$!
$  here		= f$environment("PROCEDURE")
$  location	= f$parse(here,,,"DEVICE") + f$parse(here,,,"DIRECTORY")
$  locroot	= f$parse(location,,,,"NO_CONCEAL") - "][" - "].;" + ".]"
$!
$  define/nolog 	HISTO_DIR       'location'
$  define/nolog/translation=(terminal,conceal)    HISTO_ROOT      'locroot'
$  define/nolog 	HISTO_SHR       'location'HISTO_SHR.EXE
$  define/nolog 	HISTOLIB_DIR    'location'
$  define/nolog 	HISTO_INC       'location'
$!
$!	Check that HISTO_PROCESS_DIR is defined, and print warning if it isn't:
$!
$   if f$trnlnm("HISTO_PROCESS_DIR") .eqs. "" THEN WRITE SYS$OUTPUT -
"WARNING: HISTO_PROCESS_DIR not properly defined. See Installation Guide."
$!
$!	Define foreign command for Histo process:
$!
$   HISTOS*COPE :== $HISTO_DIR:HISTO
$   HSDIR :== $HISTO_DIR:HSDIR
$!
$ exit  !!!! END HISTO SETUP !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
