      SUBROUTINE ACDCMP
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE PERFORMS AN LU FACTORIZATION OF THE CIRCUIT EQUATION
C COEFFICIENT MATRIX.
C
C SPICE VERSION 2G.6  SCCSID=TABINF 3/15/83
      COMMON /TABINF/ IELMNT,ISBCKT,NSBCKT,IUNSAT,NUNSAT,ITEMPS,NUMTEM,
     1   ISENS,NSENS,IFOUR,NFOUR,IFIELD,ICODE,IDELIM,ICOLUM,INSIZE,
     2   JUNODE,LSBKPT,NUMBKP,IORDER,JMNODE,IUR,IUC,ILC,ILR,NUMOFF,ISR,
     3   NMOFFC,ISEQ,ISEQ1,NEQN,NODEVS,NDIAG,ISWAP,IEQUA,MACINS,LVNIM1,
     4   LX0,LVN,LYNL,LYU,LYL,LX1,LX2,LX3,LX4,LX5,LX6,LX7,LD0,LD1,LTD,
     5   IMYNL,IMVN,LCVN,NSNOD,NSMAT,NSVAL,ICNOD,ICMAT,ICVAL,
     6   LOUTPT,LPOL,LZER,IRSWPF,IRSWPR,ICSWPF,ICSWPR,IRPT,JCPT,
     7   IROWNO,JCOLNO,NTTBR,NTTAR,LVNTMP
C SPICE VERSION 2G.6  SCCSID=CIRDAT 3/15/83
      COMMON /CIRDAT/ LOCATE(50),JELCNT(50),NUNODS,NCNODS,NUMNOD,NSTOP,
     1   NUT,NLT,NXTRM,NDIST,NTLIN,IBR,NUMVS,NUMALT,NUMCYC
C SPICE VERSION 2G.6  SCCSID=FLAGS 3/15/83
      COMMON /FLAGS/ IPRNTA,IPRNTL,IPRNTM,IPRNTN,IPRNTO,LIMTIM,LIMPTS,
     1   LVLCOD,LVLTIM,ITL1,ITL2,ITL3,ITL4,ITL5,ITL6,IGOOF,NOGO,KEOF
C SPICE VERSION 2G.6  SCCSID=KNSTNT 3/15/83
      COMMON /KNSTNT/ TWOPI,XLOG2,XLOG10,ROOT2,RAD,BOLTZ,CHARGE,CTOK,
     1   GMIN,RELTOL,ABSTOL,VNTOL,TRTOL,CHGTOL,EPS0,EPSSIL,EPSOX,
     2   PIVTOL,PIVREL
C SPICE VERSION 2G.6  SCCSID=BLANK 3/15/83
      COMMON /BLANK/ VALUE(200000)
C SPICE VERSION 2G.6  SCCSID=STATUS 3/15/83
      COMMON /STATUS/ OMEGA,TIME,DELTA,DELOLD(7),AG(7),VT,XNI,EGFET,
     1   XMU,SFACTR,MODE,MODEDC,ICALC,INITF,METHOD,IORD,MAXORD,NONCON,
     2   ITERNO,ITEMNO,NOSOLV,MODAC,IPIV,IVMFLG,IPOSTP,ISCRCH,IOFILE
      INTEGER NODPLC(64)
      COMPLEX CVALUE(32)
      EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1))
C
      N=1
   10 N=N+1
      NXTI=N
      NXTJ=N
C
C     CALCULATE CONTRIBUTION FROM (NXTI,NXTJ)
C
      IF (N.GE.NSTOP) RETURN
      N1=NODPLC(IRSWPF+NXTI)
      N2=NODPLC(ICSWPF+NXTJ)
      LOCNN=INDXX(N1,N2)
      GDIAG=DABS(VALUE(LYNL+LOCNN))+DABS(VALUE(IMYNL+LOCNN))
      IF (GDIAG.GE.PIVTOL) GO TO 20
      VALUE(LYNL+LOCNN)=PIVTOL
      VALUE(IMYNL+LOCNN)=0.0D0
      WRITE(IOFILE,11) N
   11 FORMAT(1H0,' UNDERFLOW OCCURED AT STEP N= ',I5)
C
C     DOWN COL J
C
   20 LOCR=NODPLC(IRPT+LOCNN)
   25 IF (LOCR.EQ.0) GO TO 10
      I=NODPLC(IROWNO+LOCR)
      CALL CDIV(VALUE(LYNL+LOCR),VALUE(IMYNL+LOCR),VALUE(LYNL+LOCNN),
     1     VALUE(IMYNL+LOCNN),VALUE(LYNL+LOCR),VALUE(IMYNL+LOCR))
      LOCC=NODPLC(JCPT+LOCNN)
C
C     FOR EACH ELEMENT LOOK UP ROW NXTI
C
   30 IF (LOCC.EQ.0) GO TO 70
      J=NODPLC(JCOLNO+LOCC)
C
C     LOCATE ELEMENT (I,J)
C
   35 IF (J.LT.I) GO TO 45
      LOCIJ=LOCC
   40 LOCIJ=NODPLC(IRPT+LOCIJ)
      IF (NODPLC(IROWNO+LOCIJ).EQ.I) GO TO 55
      GO TO 40
   45 LOCIJ=LOCR
   50 LOCIJ=NODPLC(JCPT+LOCIJ)
      IF (NODPLC(JCOLNO+LOCIJ).EQ.J) GO TO 55
      GO TO 50
   55 CALL CMULT(VALUE(LYNL+LOCC),VALUE(IMYNL+LOCC),
     1     VALUE(LYNL+LOCR),VALUE(IMYNL+LOCR),XREAL,XIMAG)
      VALUE(LYNL+LOCIJ)=VALUE(LYNL+LOCIJ)-XREAL
      VALUE(IMYNL+LOCIJ)=VALUE(IMYNL+LOCIJ)-XIMAG
      LOCC=NODPLC(JCPT+LOCC)
      GO TO 30
   70 LOCR=NODPLC(IRPT+LOCR)
      GO TO 25
      END
