      SUBROUTINE ALFNUM(NUMBER,STRING,IPOS)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE CONVERTS NUMBER INTO CHARACTER FORM, STORING THE
C CHARACTERS IN THE CHARACTER ARRAY STRING, BEGINNING WITH THE POSITION
C INDICATED BY IPOS.
C
C **** NOTE THAT THE 'IPOS' VARIABLE IS CHANGED TO INDICATE THE POSITION
C      OF THE NEXT UNWRITTEN CHARACTER.  THIS COULD CLOBBER CONSTANTS IF
C      IPOS IS NOT A VARIABLE IN THE CALLING PROGRAM
C
      DIMENSION STRING(1)
      DIMENSION ADIGIT(10)
      DATA ADIGIT / 1H0,1H1,1H2,1H3,1H4,1H5,1H6,1H7,1H8,1H9 /
      DATA AMINUS / 1H- /
C
C
      NUM=NUMBER
C
C  CHECK FOR NUMBER < 0
C
      IF (NUM.GE.0) GO TO 10
      NUM=-NUM
C...  NEGATIVE NUMBER:  INSERT MINUS SIGN
      CALL MOVE(STRING,IPOS,AMINUS,1,1)
      IPOS=IPOS+1
C
C  CONVERT NUMBER ONE DIGIT AT A TIME, IN REVERSE ORDER
C
   10 ISTART=IPOS
   20 NUMTMP=NUM/10
      IDIGIT=NUM-NUMTMP*10
      CALL MOVE(STRING,IPOS,ADIGIT(IDIGIT+1),1,1)
      IPOS=IPOS+1
      NUM=NUMTMP
      IF (NUM.NE.0) GO TO 20
      ISTOP=IPOS-1
C
C  NOW REVERSE THE ORDER OF THE DIGITS
C
   30 IF (ISTOP.LE.ISTART) GO TO 40
      CALL MOVE(TMPDGT,1,STRING,ISTART,1)
      CALL MOVE(STRING,ISTART,STRING,ISTOP,1)
      CALL MOVE(STRING,ISTOP,TMPDGT,1,1)
      ISTART=ISTART+1
      ISTOP=ISTOP-1
      GO TO 30
C
C  CONVERSION COMPLETE
C
   40 RETURN
      END
