F c********************************************************************* c  c234567 B       logical function main(process_number,number_of_subprocesses,0      1           number_of_subprocess_default_1,0      1           number_of_subprocess_default_2,E      1           subprocess_input,subprocess_output,subprocess_error, 3      1           debug_default,debug_command_files) )       implicit double precision (a-h,o-z)  c G c This routine initializes a program written to be executed in parallel C c by multiple processes. The parallel methodology is a master slave F c approach. A main process signals a specified number of subprocesses.; c Main and subprocesses run the exact same executable file. F c Communication between processes is performed through shared memory. 3 c Signaling is achieved through system event flags.  c  c F c For more information about the parallel methodology used to parallelC c SPICE, please refer to the PLIBV2 KIT, which is available through  c the DECUS Library. c 
 c WARNING:A c    A test of this logical function MUST be the FIRST executable D c    statement of the program. The program MUST also be linked using. c    an option file containing the statements: c       psect_attr=A,page : c       collect=shared_memory,A,shared_user_block_i,zzzzz ; c    All the shared common block names defined by the user, F c    shared_user_block_i, must appear in the collect statement betweenG c    A and zzzzz. These names must be in alphabetical order after A and  c    before zzzzz. c  c  c INPUT:, c    number_of_subprocess_default_1: integerD c       This number is the default number of subprocesses which will@ c       be created if no command line option is used. The number@ c       of subprocesses is entered through a command line option@ c       /SUBPROCESSES=N (/SUB=N). The subroutine will look for aA c       command line buffer and scan this buffer for the previous ? c       option. If the previous option is not present or if the @ c       command line buffer is empty then this default number ofE c       subprocesses will be used. When using the command line buffer E c       for other purposes, one should be aware of this valid option. , c    number_of_subprocess_default_2: integer? c       When the command line option /SUB is used alone without A c       specifying any number N then this default is used for the  c       number of subprocesses. $ c    subprocess_input: character*(*)D c       This character string is used to specify input files for theC c       subprocesses. If an empty string is given then sys$input of H c       the main process is assumed for all subprocesses. The subroutineH c       will perform logical translations on the subprocess_input stringD c       until no translations are no longer possible. The translated' c       name should then be of the form + c       DISK:[DIRECTORY]FILE.TYPE;VERSION . H c       If the last three characters of FILE are three zeros, that is ifE c       FILE is of the form NAME000 then the subprocess whose name is F c       EEENNN$IIIIIIII will be looking for an input file whose actual6 c       name is DISK:[DIRECTORY]NAMENNN.TYPE;VERSION .E c       Otherwise all subprocesses will be looking for the same input > c       file whose name is DISK:[DIRECTORY]FILE.TYPE;VERSION .% c    subprocess_output: character*(*) E c       This character string is used to specify output files for the E c       subprocesses. The actual output file names are extracted from ? c       this string as explained above for the input file name. $ c    subprocess_error: character*(*)D c       This character string is used to specify error files for theD c       subprocesses. The actual error file names are extracted from? c       this string as explained above for the input file name.  c    debug_default: integer F c       This is the default used for the debug flag. The debug flag isD c       for debugging purposes. If set to 0, then the program is run< c       in no debug mode. If set to 1 the program will spawnC c       subprocesses which will look for command files. The command F c       file names are obtained from the debug_command_files argument.G c       If set to 2 the program assumes a work station debuging session F c       and will automatically set up debuging windows for up to threeF c       subprocesses. The debug flag is entered through a command line c       option. It is set to  # c       * 0 using /NODEBUG (/NODEB) G c       * 1 using /DEBUG=MT (/DEB=MT), MT stands for multiple terminals F c       * 2 using /DEBUG=MW (/DEB=MW), MW stands for multiple windows.E c       When no debug option is given the default value is used. When A c       the debug option is specified without value, the value MT ) c       (debug flag set to 1) is assumed. ' c    debug_command_files: character*(*) H c       This character string is used to specify command files to be runA c       by subprocesses when doing a debuging session. The actual F c       command file names are extracted from this string as explained& c       above for the input file name. c 	 c OUTPUT:  c    process_number: integerD c       This integer will contain the number of the calling process.E c       If this process is the main process then process_number=0. If D c       this process is the subprocess whose name is EEENNN$IIIIIIII! c       then process_number=NNN . $ c    number_of_subprocesses: integerE c       This integer will contain the number of subprocesses actually  c       created.F ********************************************************************** c  c  c declarations c  c  c234567  c  c external routines    c !       integer plib$init_pagefile,       1       plib$init_signals,       1       plib$share_memory,       1       plib$current_pc, &      1       plib$create_subprocesses,&      1       plib$signal_subprocesses,      1       plib$signal_main,      1       plib$synch,&      1       plib$set_bit_interlocked,(      1       plib$clear_bit_interlocked,      1       plib$main_pid,        1       plib$current_image,%      1       plib$delete_subprocesses  c  c local variables  c )       integer ignore, subprocess_pids(8), $      1       isection_number, my_num         character*8 main_pid       character*132 image_name     c  c declarations   c 5       logical main_or_subprocess,ef_toggle,ef_toggle2 C       integer number_of_subprocesses,number_of_subprocess_default_1 %       integer number_of_subprocessesl ,       integer number_of_subprocess_default_2B       integer existing_subprocess_number,running_subprocess_number       integer process_number       integer first_word_shared !       integer ef0,ef1,ef2,ef3,ef4 !       integer debug_default,debug        character*3 header       character*8 hex_job_id       character*15 cef_name G       character*(*) subprocess_input,subprocess_output,subprocess_error '       character*(*) debug_command_files    c  c shared common block  c 8       common /A/ first_word_shared,ef0,ef1,ef2,ef3,ef4, F      1           existing_subprocess_number,running_subprocess_number,      1           cef_name   #       common /pids/ subprocess_pids    c  c Perform initialization code  c &       isave = plib$main_pid (main_pid) c B c  get the number of subprocesess to use if we're the main process c        if (isave .eq. 0) then@          call get_number_of_subprocesses(number_of_subprocesses,1      1            number_of_subprocess_default_1, 1      1            number_of_subprocess_default_2, &      1            debug,debug_default)       endif   >       ignore = plib$init_pagefile (main_pid//'page.file',4000) c ( c init call for the signalling mechanism c E       ignore = plib$init_signals (64, number_of_subprocesses, my_num)        process_number = my_num  c + c distinguish between main and subprocesses  c          if (my_num .eq. 0) then    c  c    main process  c           main = .true.  .          if (number_of_subprocesses.gt.0) then c " c       main requires subprocesses c 9            number_of_subprocessesl=number_of_subprocesses 7             call setup_shared_memory(hex_job_id,header) 9            number_of_subprocesses=number_of_subprocessesl 4             ignore = plib$current_image (image_name)F             ignore = plib$create_subprocesses (number_of_subprocesses,6      1        image_name,'nl:', 'nl:',subprocess_pids) c      c "             ignore = plib$synch ()          endif c  c   
       else   c  c    subprocess  c           main = .false.   7             call setup_shared_memory(hex_job_id,header)   0          call plib$signal_main (isection_number) c         call join          endif      c        return	       end  c F c*********************************************************************F c*********************************************************************F c*********************************************************************F c*********************************************************************F c*********************************************************************D c******************************************************************* c  c234567 C       subroutine get_number_of_subprocesses(number_of_subprocesses,*4      1               number_of_subprocess_default_1,4      1               number_of_subprocess_default_2,3      1               debug_flag,debug_flag_default)b)       implicit double precision (a-h,o-z)_ csC c This routine returns the number N of subprocesses used to run thetE c program. The number of subprocesses is specified through the optionl0 c /SUB=N in a command line invoking the program.' c This routine also set the debug flag.w ct c INPUT:, c    number_of_subprocess_default_1: integer> c       This is the number which will be returned in number_ofF c       subprocesses if no subprocess option appears in a command line c       invoking the program.a, c    number_of_subprocess_default_2: integer> c       This is the number which will be returned in number_ofD c       subprocesses if a subprocess option with no number specified7 c       appears in a command line invoking the program.e  c    debug_flag_default: integerB c       This is the default value used for the debuging flag if no3 c       command line option for debugging is given.  c 	 c OUTPUT: $ c    number_of_subprocesses: integer6 c       number of subprocesses required to be created. c    debug_flag: integer c       value of the debug flag  c $       integer number_of_subprocesses,       integer number_of_subprocess_default_1,       integer number_of_subprocess_default_23       integer number,maximum_number_of_subprocesses "       integer length,delta_min_maj+       integer debug_flag,debug_flag_default        integer lib$get_foreign #       integer get_option,get_number A       integer value_length,no_option,no_value,value_present,error        character*1 letter       character*4 sub,deb        character*6 nodeb #       character*6 value,mt,mw,blank -       character*15 subprocesses,debug,nodebug         character*255 command_line c /       data maximum_number_of_subprocesses /100/        data delta_min_maj /32/ <       data no_option,no_value,value_present,error /0,1,2,-1/6       data subprocesses,sub /'SUBPROCESSES   ','/SUB'/6       data debug,deb        /'DEBUG          ','/DEB'/8       data nodebug,nodeb    /'NODEBUG        ','/NODEB'/8       data mt,mw,blank      /'MT    ','MW    ','      '/   c  c get command line c 2       istat=lib$get_foreign(command_line,,length,)       if (length.eq.0) then >          number_of_subprocesses=number_of_subprocess_default_1&          debug_flag=debug_flag_default          return        endif  c G c parse the command string for /mult if the command string is not empty  c ( c convert command string into upper case c        do loc=1,length %          letter=command_line(loc:loc) 6          if ((letter.ge.'a').and.(letter.le.'z')) thenC             command_line(loc:loc)=char(ichar(letter)-delta_min_maj)           endif       enddo  c + c process the number of subprocesses option  c        value=blank B       istat=get_option(command_line,length,subprocesses,sub,value,$      1                 value_length)"       if (istat.eq.no_option) then>          number_of_subprocesses=number_of_subprocess_default_1&       else if (istat.eq.no_value) then>          number_of_subprocesses=number_of_subprocess_default_2+       else if (istat.eq.value_present) then -          istat=get_number(value,value_length, B      1      maximum_number_of_subprocesses,number_of_subprocesses)!          if (istat.eq.error) then )             call error_exit(subprocesses)           endif
       else&          call error_exit(subprocesses)       endif  c  c process the debug option c A       istat_nodebug=get_option(command_line,length,nodebug,nodeb, 2      1                         value,value_length)       value=blank A       istat_debug=get_option(command_line,length,debug,deb,value, *      1                       value_length)+       if ((istat_nodebug.eq.no_option).and. *      1    (istat_debug.eq.no_option)) then&          debug_flag=debug_flag_default0       else if ((istat_nodebug.ne.no_option).and./      1         (istat_debug.eq.no_option)) then ,          if (istat_nodebug.eq.no_value) then             debug_flag=0
          else "             call error_exit(debug)          endif0       else if ((istat_nodebug.eq.no_option).and./      1         (istat_debug.ne.no_option)) then *          if (istat_debug.eq.no_value) then             debug_flag=14          else if (istat_debug.eq.value_present) then!             if (value.eq.mt) then                 debug_flag=1 &             else if (value.eq.mw) then                debug_flag=2              else%                call error_exit(debug)              endif 
          else "             call error_exit(debug)          endif
       else          call error_exit(debug)        endif  c        return	       end  c D c******************************************************************* c B       integer function get_option(command_line,length,option_name,B      1                            option_stamp,value,value_length) c D c This function scans a command line for an option. If the option isF c present and has a value it returns the string containing this value. c  c INPUT:  c    command_line: character*255/ c       buffer which is scanned for the option.  c    length: integer9 c       number of significant characters in command line.  c    option_name: character*15E c       upper case character string containing the name of the option   c       to scan for (ex: DEBUG). c    option_stamp: character*8H c       upper case character string containing the minimum string needed* c       to identify the option (ex: /DEB). c 	 c OUTPUT:  c    get_option: integerB c       the value returned by the function is one of the following< c       * error         (-1): the option was badly specified8 c       * no_option     ( 0): the option was not presentB c       * no_value      ( 1): the option was present without valueB c       * value_present ( 2): the option was present with a value. c    value: character*6 G c       character string containing the value of the option if present.  c    value_length: integerG c       integer containing the number of significant characters written  c       in the string value. c  c declarations c !       integer length,value_length .       integer option_name_length,option_length!       integer loc,loc_start,index 4       integer no_option,no_value,value_present,error?       character*(*) command_line,option_name,option_stamp,value        character*255 option c "       data option_name_length /15/<       data no_option,no_value,value_present,error /0,1,2,-1/       value_length=6 c ' c check whether option stamp is present  c 0       loc_start=index(command_line,option_stamp)       if (loc_start.eq.0) then          get_option=no_option           return        endif  c 
 c find next /  c        loc_start=loc_start+1        loc=loc_start C       do while ((loc.lt.length).and.(command_line(loc:loc).ne.'/'))           loc=loc+1       enddo B       if ((loc.eq.length).and.(command_line(loc:loc).ne.'/')) then          loc=loc+1       endif  c  c eliminate trailing blanks  c        loc=loc-1 -       do while (command_line(loc:loc).eq.' ')           loc=loc-1       enddo #       option_length=loc-loc_start+1 9       option(1:option_length)=command_line(loc_start:loc)  c   c search for next blank or equal c        loc=1 +       do while ((loc.lt.option_length).and. F      1          (option(loc:loc).ne.' ').and.(option(loc:loc).ne.'='))          loc=loc+1       enddo %       if ((loc.eq.option_length).and. E      1    (option(loc:loc).ne.' ').and.(option(loc:loc).ne.'=')) then           loc=loc+1       endif  c $ c verify that option name is correct c        loc=loc-1 )       if (loc.gt.option_name_length) then           get_option=error           return        endif 3       if (option(1:loc).ne.option_name(1:loc)) then           get_option=error           return        endif $       if (loc.eq.option_length) then          get_option=no_value          return        endif  c * c find next character which is not a blank c        loc=loc+1 '       do while (option(loc:loc).eq.' ')t          loc=loc+1       enddoF&       if (option(loc:loc).ne.'=') then          get_option=no_value          return        endifn cl c get option value ce       loc=loc+1cD       do while ((option(loc:loc).eq.' ').and.(loc.lt.option_length))          loc=loc+1       enddob&       if (option(loc:loc).eq.' ') then          get_option=errorp          returnt       endift       loc_start=loczD       do while ((option(loc:loc).ne.' ').and.(loc.lt.option_length))          loc=loc+1       enddom&       if (option(loc:loc).ne.' ') then          loc=loc+1       endifn/       if ((loc-loc_start).gt.value_length) thent          get_option=errorn          returnb       endiff       get_option=value_present        value_length=loc-loc_start3       value(1:value_length)=option(loc_start:loc-1)a c        return	       end  c D c******************************************************************* cn c234567r cn>       integer function get_number(value,length,maximum,number) ctA c This function converts a character string containing an integern@ c decimal representation into an integer. If the integer exceeds; c the specified maximum the function returns an error flag.t cr c INPUT: c    value: character*15I c       This character strings contains an integer decimal repesentation.e c    length: integerI c       Integer containing the number of significant characters in value.  c    maximum: integerrH c       Integer containing the maximum integer the function will return.	 c OUTPUT:i c    get_number: integerJ c       The integer function returns a status which can have the following c       values:oF c       * normal ( 0): the character string was succesfully converted.G c       * error  (-1): the string is not a number or the number exceeds - c                      the specified maximum.I c    number: integer3 c       Integer containing the convertion of value.z cs
 c declaration  c         integer length,number,zero       integer loc,loc_start        integer normal,error       character*1 letter             character*(*) valuei cI       data zero /48/       data normal,error /0,-1/ clA c check validity of characters and compute number of subprocesseso cn       number=0       loc_start=1R       do loc=loc_start,length           letter=value(loc:loc)5          if ((letter.lt.'0').or.(letter.gt.'9')) then              get_number=error             return          endif,          number=number*10+ichar(letter)-zero$          if (number.gt.maximum) then             get_number=error             return          endif       enddor       get_number=normalu co       return	       endf c D c******************************************************************* ci c234567 (       subroutine error_exit(option_name) c B c This routine prints an error message if the option whose name isB c option_name was incorrectly specified in the command line and it c subsequently exits.  cs c INPUT: c    option_name: character*15 c       name of the option.r cm       integer outm       character*(*) option_namei c        data out /6/ cfA       write(out,'(''   ERROR IN COMMAND LINE:               '')')iH       write(out,'(''   SPECIFICATION OF THE OPTION '',a15)') option_nameA       write(out,'(''   IS INCORRECT OR NOT ALLOWED,         '')') A       write(out,'(''   CHECK OPTION NAME OR VALUE.          '')')        call exitN cB       return	       endB cME c********************************************************************G c  c234567,7       subroutine setup_shared_memory(hex_job_id,header)p)       implicit double precision (a-h,o-z)e c / c This routine creates the shared common block.uG c The shared common block is named 'EEESHA$IIIIIIII' where EEE = headercB c and IIIIIIII = hex_job_id. The user defined shared common blocks$ c must meet the following condition:F c    * the blocks must be named and their name must be in alphabetical' c      order after A and before zzzzz .hF c The user program must also be linked using an option file containing c the statements:s c    psect_attr=A,page  7 c    collect=shared_memory,A,shared_user_block_i,zzzzz sE c The first statement page aligns the begining of the shared section.I8 c All the shared common block names defined by the user,C c shared_user_block_i, must appear in the collect statement betweenbD c A and zzzzz. The collect statement provides a contiguous sector of* c virtual memory for the collected blocks. c* c INPUT: c    hex_job_id: character*8F c       This character string will contain the string 'IIIIIIII' whereA c       IIIIIIII is the hexadecimal representation of the process12 c       identification number of the main process. c    header: character*3E c       This character string will contain the string 'EEE' where EEEiC c       is the first three characters of the name of the executablep- c       file which the processes are running.e c 
 c WARNING:@ c    This routine should only be called by parallel code using aB c    single .exe file to insure that the addresses for the various5 c    processes are at the same virtual address space.oF c    Non-shared data must not be on any of these virtual address pages4 c    or else these "local" variables will be shared. cl# c include symbolic definition files_ cp       include '($ssdef)'       include '($syidef)'_       include '($secdef)'r       include '($fordef)'e c  c declarations cs       byte garbage(512)r       byte irecord(512) #       integer*4 sys$getsyiw, ignoreb6       integer*4 iret_pagefile_page, iret_pagefile_free"       integer*4 sys$crmpsc,options1       integer*4 open_page_file,get_channel_number "       integer*4 address(2),channel!       integer*4 plib$share_memoryo!       integer page_needed, sector 0       integer first_word_shared,last_word_shared%       character*(*) hex_job_id,header*%       character*15 shared_memory_named             character*8 main_pid cf!       structure /item_descriptor/4           integer*2 buffer_length          integer*2 item_code!          integer*4 buffer_addressm(          integer*4 return_length_address       end structuret       structure /item_list/s/          record /item_descriptor/ descriptor(1)m          integer*4 terminatore       end structure  c        record /item_list/ list  c        data irecord /512*0/ cs c include common blocks, c "       common /A/ first_word_shared-       common /zzzzz/ last_word_shared,garbageo cs c set up shared memory region  cu'       ignore = plib$main_pid (main_pid)g:       ignore = plib$share_memory (%loc(first_word_shared),3      1        %loc(garbage)-1, main_pid//'MEMTEST')g   c=	       ends caD c******************************************************************* c  c234567t; c      subroutine initialize_event_flags(hex_job_id,header)m* c      implicit double precision (a-h,o-z) c G c this routine initialize the the event flags used for synchronization. D c the event flag cluster 2 is used; this cluster contains event flag@ c 64 trough 95. Only three event flags of this cluster are used:@ c ef0=64, ef1=65, ef2=66. The common event flag cluster is namedA c 'EEECEF$IIIIIIII' where EEE = header and IIIIIIII = hex_job_id.m c  c INPUT: c    hex_job_id: character*8B c       This character string contains the string 'IIIIIIII' whereA c       IIIIIIII is the hexadecimal representation of the process 2 c       identification number of the main process. c    header: character*3A c       This character string contains the string 'EEE' where EEEdC c       is the first three characters of the name of the executablea- c       file which the processes are running.  c  c OUTPUT: through common blocks* c    cef_name: character*15*& c       common event flag cluster name c    ef1,ef2,ef3: integer*B c       numbers of the three event flags used for synchronization. c    ef_toggle: logical*= c       boolean used for synchronization through event flags.* c*# c      logical ef_toggle,ef_toggle2*  c      integer first_word_shared" c      integer ef0,ef1,ef2,ef3,ef4C c      integer existing_subprocess_number,running_subprocess_numbere c      character*15 cef_name& c      character*(*) hex_job_id,header c ; c      common /parallel_library_local/ ef_toggle,ef_toggle2_8 c      common /A/ first_word_shared,ef0,ef1,ef2,ef3,ef4,G c     1           existing_subprocess_number,running_subprocess_number,h c     1           cef_name c 
 c      ef0=64 
 c      ef1=65t
 c      ef2=66e
 c      ef3=67r
 c      ef4=68i c      ef_toggle=.TRUE.  c      ef_toggle2=.TRUE. c      cef_name(1:3)=headers c      cef_name(4:7)='CEF$'l  c      cef_name(8:15)=hex_job_id- c      call sys$ascefc(%val(ef0),cef_name,1,)   c      call sys$clref(%val(ef0))  c      call sys$clref(%val(ef1))  c      call sys$clref(%val(ef2))  c      call sys$clref(%val(ef3))  c      call sys$clref(%val(ef4)) cc
 c      returni
 c      end c G c**********************************************************************sG c**********************************************************************cE c********************************************************************  c  c234567 8       subroutine map_to_shared_memory(hex_job_id,header))       implicit double precision (a-h,o-z)n c ; c This routine maps to the shared common section of memory.  cb c INPUT: c    hex_job_id: character*8B c       This character string contains the string 'IIIIIIII' whereA c       IIIIIIII is the hexadecimal representation of the processo2 c       identification number of the main process. c    header: character*3A c       This character string contains the string 'EEE' where EEEnC c       is the first three characters of the name of the executable$- c       file which the processes are running.e c 
 c WARNING:@ c    This routine should only be called by parallel code using aB c    single .exe file to insure that the addresses for the various5 c    processes are at the same virtual address space.*F c    Non-shared data must not be on any of these virtual address pages4 c    or else these "local" variables will be shared. ca# c include symbolic definition filesp cn       include '($ssdef)'       include '($secdef)'s cr c declarations cO       byte garbage(512) "       integer*4 sys$mgblsc,options       integer*4 address(2)       integer sector0       integer first_word_shared,last_word_shared%       character*15 shared_memory_namee%       character*(*) hex_job_id,header_ ce c include common blocks) c "       common /A/ first_word_shared-       common /zzzzz/ last_word_shared,garbagef ctA c define the name and the address of the section of shared memory  ci(       address(1)=%loc(first_word_shared)'       address(2)=%loc(last_word_shared) $       shared_memory_name(1:3)=header$       shared_memory_name(4:7)='SHA$')       shared_memory_name(8:15)=hex_job_id  c  c build the options flag cl&       options=sec$m_wrt     ! writable cl; c call the system service to do the global section mapping.  cd>       istat=sys$mgblsc (address,,,             ! address range=      1                  %val(options),         ! options flagc=      1                  shared_memory_name,,)  ! section namef#       if (istat.eq.ss$_normal) thenn          returns
       else          call exit(istat)        endift ce	       end  cnF c********************************************************************* ce c234567tC       character*15 function process_name(process_number,hex_job_id,h0      1                                   header) c_E c This routine returns in process_name the character string of lengthe@ c 15: 'EEENNN$XXXXXXXX' where EEE = header, NNN = process_numberB c is a positive integer from 000 to 999 and IIIIIIII = hex_job_id. cn c INPUT: c    hex_job_id: character*8B c       This character string contains the string 'IIIIIIII' whereA c       IIIIIIII is the hexadecimal representation of the processc2 c       identification number of the main process. c    header: character*3A c       This character string contains the string 'EEE' where EEEdC c       is the first three characters of the name of the executable - c       file which the processes are running.  c    process_number: integer; c       This integer contains the number of the subprocess.n0 c       Integers greater than 999 are truncated. c  c declarations ce2       integer process_number,maximum_number,number#       integer loc,decade,digit,zeros%       character*(*) hex_job_id,header  c &       data maximum_number,zero/999,48/ c 8 c insert process number in character string process_name c        number=process_numberq       decade=maximum_number+1g*       number=number-(number/decade)*decade
       digit=0        process_name(1:3)=header       process_name(7:7)='$'o#       process_name(8:15)=hex_job_id        loc_start=4        loc_stop=6       do loc=loc_start,loc_stop #          number=number-digit*decade           decade=decade/10e          digit=number/decade/          process_name(loc:loc)=char(zero+digit)*       enddo  c        return	       endo coG c**********************************************************************i cs c234567eA       subroutine translate_name(user_name,translated_name,length,i7      1                          multiple_files,pointer)s)       implicit double precision (a-h,o-z)N c:@ c This routine is making logical table translations for the fileH c whose name is name. After translation, the translated name of the file; c is returned into translated_name. The routine also checks E c translated_name. If this name ends with three zeros, that is if the G c file specification has the form DISK:[DIRECTORY]FILE000.TYPE;VERSION,pA c then the logical multiple_files is set to true and pointer will E c contain the starting position of the string '000' in the translated: c file name string.  cu c INPUT: c    user_name: character*255fG c       This string is a file name specification which may be a logical  c 	 c OUTPUT:o# c    translated_name: character*255tF c       This string will contain the result of the translation the the/ c       string name through the logical tables.t c    length: integerF c       This integer will contain the number of significant characters. c       written in the string translated_name. c    multiple_files: logicalD c       This logical is set to true if the translated file name ends c       with three zeros.  c    pointer: integervF c       This integer will point to the starting position of the stringD c       000 in the translated file name string, it will contain 0 if& c       the string 000 is not present. co c declarations ct       logical multiple_files       integer pointer,loct#       integer lib$sys_trnlog,lengthp'       integer name_length,delta_min_maj-       integer buffer_length        character*1 letter#       character*255 buffer1,buffer2n(       character*255 name,translated_name       character*(*) user_nameg co/       data delta_min_maj,buffer_length /32,255/  c  c include symbol table co       include '($ssdef)' co, c eliminate blanks and convert to upper case c.        name_length=len(user_name)       name=user_name       loc=1 :       do while ((name(1:1).eq.' ').and.(name_length.gt.1))          name(1:)=name(2:)*          name(name_length:name_length)=' '"          name_length=name_length-1       enddoi;       do while ((name(name_length:name_length).eq.' ').and. #      1          (name_length.gt.1)) "          name_length=name_length-1       enddoc       do loc=1,name_length          letter=name(loc:loc) 6          if ((letter.ge.'a').and.(letter.le.'z')) then;             name(loc:loc)=char(ichar(letter)-delta_min_maj)           endif       enddod c  c perform logical translations cd       istat=ss$_normal$       do while (istat.eq.ss$_normal)          loc=index(name,':')-1          if (loc.gt.0) thent             loc1=loc              buffer1=name(1:loc1)-             if ((loc1+2).le.name_length) theng/                buffer2=name(loc1+2:name_length) )                length2=name_length-loc1-1c             endifg
          else "             loc1=index(name,' ')-1-             if (loc1.lt.0) loc1=buffer_lengtht             buffer1=name          endif5          istat=lib$sys_trnlog(buffer1(1:loc1),length, 1      1                        translated_name,,,)c&          if (istat.eq.ss$_normal) then             if (loc.gt.0) then8                translated_name(length+1:length+length2)=1      1                         buffer2(1:length2) $                length=length+length2.                loc=index(translated_name,'][')"                do while (loc.ne.0).                   translated_name(loc:length)=:      1                       translated_name(loc+2:length)7                   translated_name(length-1:length)='  '.!                   length=length-2c1                   loc=index(translated_name,'][')                 enddo             endif              name=' '4             name(1:length)=translated_name(1:length)             name_length=length          endif       enddot#       if (istat.ne.ss$_notran) then           call exit(istat)p       endift       translated_name=name       length=name_length c*/ c check whether file name ends with three zeros* c*$       loc=index(translated_name,']')       loc=loc+1a       loc_stop=lengtheG       do while ((loc.lt.loc_stop).and.(translated_name(loc:loc).ne.'.')n7      1          .and.(translated_name(loc:loc).ne.' '))r          loc=loc+1       enddo F       if ((loc.eq.loc_stop).and.(translated_name(loc:loc).ne.'.').and.1      1    (translated_name(loc:loc).ne.' ')) thent          loc=loc+1       endif 5       if (translated_name(loc-3:loc-1).eq.'000') then           multiple_files=.TRUE.          pointer=loc-3
       else          multiple_files=.FALSE.i          pointer=0       endif  cU       return	       endi cgG c**********************************************************************o cg c234567 7       subroutine file_name(name,process_number,pointer)  ccG c This function inserts into the character string name at the positionstA c pointer to pointer + 2 the decimal representation of the number  c process_number c  c INPUT: c    name: character*255 c    process_number: integerE c       This integer should be between 0 and 999, bigger integers arer c       truncatedo c    pointer: integerc c* c declarations c 2       integer process_number,maximum_number,number+       integer pointer,loc,decade,digit,zeroi       character*255 name ce&       data maximum_number,zero/999,48/ c0       number=process_numbero       decade=maximum_number+1 *       number=number-(number/decade)*decade
       digit=0t       loc_start=pointer        loc_stop=pointer+2       do loc=loc_start,loc_stop #          number=number-digit*decader          decade=decade/10.          digit=number/decade'          name(loc:loc)=char(zero+digit)        enddo  c        return	       endn caG c*********************************************************************** c* c234567*%       character*8 function hex_id(id) )       implicit double precision (a-h,o-z)h crB c this routine returns a character string of length 8 which is the9 c the hexadecimal expression of the four byte integer id.  cu c INPUT: c    id: integer*4 c        integer*4 id,digit$       integer loc_start,loc_stop,loc/       integer length,source_bit,destination_bitn       integer zero,ten       parameter (zero = 48)'       parameter (ten  = 65)  c        loc_start=1        loc_stop=8       source_bit=0       destination_bit=0a       length=4 c,"       do loc=loc_stop,loc_start,-1          digit=0@          call mvbits(id,source_bit,length,digit,destination_bit)          if (digit.lt.10) then,             hex_id(loc:loc)=char(zero+digit)
          else*             digit=digit-10+             hex_id(loc:loc)=char(ten+digit)_          endif           source_bit=source_bit+4       enddoh cz       return	       ende csF c********************************************************************* cIB       subroutine deb_create_sub(number_of_subprocesses,image_name,@      1           hex_job_id,header,debug_flag,command_file_name))       implicit double precision (a-h,o-z)e cs/       integer number_of_subprocesses,debug_flagf/       character*15 subprocess_name,process_namek       character*(*) image_name7       character*(*) command_file_name,hex_job_id,headerl ct       if (debug_flag.eq.1) thenkB          call deb_create_sub_mt(number_of_subprocesses,hex_job_id,9      1                          header,command_file_name) 
       elseB          call deb_create_sub_mw(number_of_subprocesses,image_name,#      1           hex_job_id,header)e       endif  ct       return	       enda ceF c********************************************************************* c E       subroutine deb_create_sub_mt(number_of_subprocesses,hex_job_id, 9      1                          header,command_file_name)r)       implicit double precision (a-h,o-z)e ci       logical multiple_files8       integer number_of_subprocesses,out,pointer,process/       character*15 subprocess_name,process_namec#       character*255 translated_namel7       character*(*) hex_job_id,header,command_file_name  cN       data out /6/ c (       if (command_file_name.eq.' ') then@          write(out,'(''   ERROR  IN DEBUG COMMAND FILE NAME'')')          call exit       endif <       call translate_name(command_file_name,translated_name,8      1                    length,multiple_files,pointer))       do process=1,number_of_subprocessesn!          if (multiple_files) thenp;             call file_name(translated_name,process,pointer)           endif@          subprocess_name=process_name(process,hex_job_id,header)          i_spawn_flag=1yB          istat=lib$spawn(,translated_name(1:length),,i_spawn_flag,)      1                   subprocess_name)        enddo* cy       return	       endn ceF c********************************************************************* c  c234567eE       subroutine deb_create_sub_mw(number_of_subprocesses,image_name,e#      1           hex_job_id,header)d)       implicit double precision (a-h,o-z)  c F c This routine creates subprocesses and assigns the subprocesses input6 c output to worstation windows for parallel debugging.9 c The subprocess names are of the form 'EEENNN$IIIIIIII' r= c where EEE are the first three letters of the image name the A c subprocesses are running, NNN is the subprocess number (integeriB c between 1 and 999) and IIIIIIII is the job identification number/ c which is the hexadecimal main process number.s c  c INPUT:$ c    number_of_subprocesses: integerC c       This integer contains the number of subprocesses to create.z c    image_name: character*127A c       This character string contains the name of the executabled4 c       file which the subprocesses will be running. c    hex_job_id: character*8B c       This character string contains the string 'IIIIIIII' whereA c       IIIIIIII is the hexadecimal representation of the process 2 c       identification number of the main process. c    header: character*3A c       This character string contains the string 'EEE' where EEElC c       is the first three characters of the name of the executablec- c       file which the processes are running.l c  c4 c declarations cr       integer subprocess_numbere       integer process5       integer*4 sys$creprc+       integer*4 sys$getjpiw,priority,ignorer/       character*15 process_name,subprocess_name        character*(*) image_name%       character*(*) hex_job_id,headert cs!       structure /item_descriptor/            integer*2 buffer_length          integer*2 item_code!          integer*4 buffer_addressm(          integer*4 return_length_address       end structures       structure /item_list/E/          record /item_descriptor/ descriptor(3)r          integer*4 terminatora       end structuret       structure /quotalist/           logical*1 quota_namek 	 integer*4 quota_valuet       end structuren ce       record /item_list/ liste&       record /quotalist/ quota_list(3) crF c include symbolic definition files for process and quota informations c        include '($jpidef)'a       include '($pqldef)'        include '($ssdef)' ce c get main process informationsw c_(       list.descriptor(1).buffer_length=4,       list.descriptor(1).item_code=jpi$_prib6       list.descriptor(1).buffer_address=%loc(priority);       list.descriptor(1).return_length_address=%loc(ignore)r(       list.descriptor(2).buffer_length=40       list.descriptor(2).item_code=jpi$_wsextent;       list.descriptor(2).buffer_address=%loc(iret_wsextent)g;       list.descriptor(2).return_length_address=%loc(ignore)e(       list.descriptor(3).buffer_length=4/       list.descriptor(3).item_code=jpi$_wsquotaR:       list.descriptor(3).buffer_address=%loc(iret_wsquota);       list.descriptor(3).return_length_address=%loc(ignore)_       list.terminator=0c#       istat=sys$getjpiw(,,,list,,,)  c$2 c pass main working set quotas to the subprocesses c .       quota_list(1).quota_name = pql$_wsextent/       quota_list(1).quota_value = iret_wsextent -       quota_list(2).quota_name = pql$_wsquota*.       quota_list(2).quota_value = iret_wsquota-       quota_list(3).quota_name = pql$_listend*#       quota_list(3).quota_value = 0c c* c  create the subprocesses c*)       do process=1,number_of_subprocesses2@          subprocess_name=process_name(process,hex_job_id,header)(          istat = sys$creprc(,image_name,#      1                      'WTA0',e#      1                      'WTA0',N$      1                      'WTA0',,'      1                      quota_list,s,      1                      subprocess_name,.      1                      %val(priority),,,) c  c  status checkn ce&          if (istat.ne.ss$_normal) then             call exit (istat)r          endif       enddoE c 
 c  and return  c        return	       endt  