      SUBROUTINE CARD
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE SCANS THE INPUT LINES, STORING EACH FIELD INTO THE
C TABLES IFIELD, IDELIM, ICOLUM, AND ICODE.  WITH THE EXCEPTION OF THE
C '.END' LINE, CARD ALWAYS READS THE NEXT LINE TO CHECK FOR A POSSIBLE
C CONTINUATION BEFORE IT EXITS.
C
C SPICE VERSION 2G.6  SCCSID=TABINF 3/15/83
      COMMON /TABINF/ IELMNT,ISBCKT,NSBCKT,IUNSAT,NUNSAT,ITEMPS,NUMTEM,
     1   ISENS,NSENS,IFOUR,NFOUR,IFIELD,ICODE,IDELIM,ICOLUM,INSIZE,
     2   JUNODE,LSBKPT,NUMBKP,IORDER,JMNODE,IUR,IUC,ILC,ILR,NUMOFF,ISR,
     3   NMOFFC,ISEQ,ISEQ1,NEQN,NODEVS,NDIAG,ISWAP,IEQUA,MACINS,LVNIM1,
     4   LX0,LVN,LYNL,LYU,LYL,LX1,LX2,LX3,LX4,LX5,LX6,LX7,LD0,LD1,LTD,
     5   IMYNL,IMVN,LCVN,NSNOD,NSMAT,NSVAL,ICNOD,ICMAT,ICVAL,
     6   LOUTPT,LPOL,LZER,IRSWPF,IRSWPR,ICSWPF,ICSWPR,IRPT,JCPT,
     7   IROWNO,JCOLNO,NTTBR,NTTAR,LVNTMP
C SPICE VERSION 2G.6  SCCSID=STATUS 3/15/83
      COMMON /STATUS/ OMEGA,TIME,DELTA,DELOLD(7),AG(7),VT,XNI,EGFET,
     1   XMU,SFACTR,MODE,MODEDC,ICALC,INITF,METHOD,IORD,MAXORD,NONCON,
     2   ITERNO,ITEMNO,NOSOLV,MODAC,IPIV,IVMFLG,IPOSTP,ISCRCH,IOFILE
C SPICE VERSION 2G.6  SCCSID=MISCEL 3/15/83
      COMMON /MISCEL/ ATIME,APROG(3),ADATE,ATITLE(10),DEFL,DEFW,DEFAD,
     1  DEFAS,RSTATS(50),IWIDTH,LWIDTH,NOPAGE
C SPICE VERSION 2G.6  SCCSID=LINE 3/15/83
      COMMON /LINE/ ACHAR,AFIELD(15),OLDLIN(15),KNTRC,KNTLIM
C SPICE VERSION 2G.6  SCCSID=FLAGS 3/15/83
      COMMON /FLAGS/ IPRNTA,IPRNTL,IPRNTM,IPRNTN,IPRNTO,LIMTIM,LIMPTS,
     1   LVLCOD,LVLTIM,ITL1,ITL2,ITL3,ITL4,ITL5,ITL6,IGOOF,NOGO,KEOF
C SPICE VERSION 2G.6  SCCSID=KNSTNT 3/15/83
      COMMON /KNSTNT/ TWOPI,XLOG2,XLOG10,ROOT2,RAD,BOLTZ,CHARGE,CTOK,
     1   GMIN,RELTOL,ABSTOL,VNTOL,TRTOL,CHGTOL,EPS0,EPSSIL,EPSOX,
     2   PIVTOL,PIVREL
C SPICE VERSION 2G.6  SCCSID=BLANK 3/15/83
      COMMON /BLANK/ VALUE(200000)
      INTEGER NODPLC(64)
      COMPLEX CVALUE(32)
      EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1))
C
      DIMENSION ADIGIT(10)
      DATA ADIGIT / 1H0,1H1,1H2,1H3,1H4,1H5,1H6,1H7,1H8,1H9 /
      DATA ABLNK,APER,APLUS,AMINUS,ASTK / 1H , 1H., 1H+, 1H-, 1H* /
      DATA BG,AK,AU,AN,AP,AE,AM,AF,AT /1HG,1HK,1HU,1HN,1HP,1HE,1HM,
     1  1HF,1HT/
      DATA AI / 1HI /
      DATA ALPRN, ARPRN, AEQUAL / 1H(, 1H), 1H= /
      DATA AEND / 4H.END /
C
C      NOTE:  THE VALUE OF THE FUNCTION *NXTCHR* (USED EXTENSIVELY IN
C THIS ROUTINE) IS AS FOLLOWS:
C
C                    <0:  END-OF-LINE
C                    =0:  DELIMITER FOUND
C                    >0:  NON-DELIMITER FOUND
C
      NUMFLD=0
      NOFLD=10
      GO TO 20
C
C  READ NEXT CARD
C
   10 NOFLD=10
      CALL GETLIN
      IF (KEOF.EQ.0) GO TO 20
C...  ERROR:  UNEXPECTED END-OF-FILE CONDITION ON INPUT
   15 KEOF=1
      NOFLD=1
      NUMFLD=0
      IGOOF=1
      WRITE (IOFILE,16)
   16 FORMAT('0*ERROR*:  .END CARD MISSING'/)
      GO TO 1000
C
C  ELIMINATE TRAILING BLANKS RAPIDLY
C
   20 IF (AFIELD(NOFLD).NE.ABLNK) GO TO 40
      IF (NOFLD.EQ.1) GO TO 30
      NOFLD=NOFLD-1
      GO TO 20
C...  WRITE BLANK CARD
   30 WRITE (IOFILE,31)
   31 FORMAT(1X)
      GO TO 10
C...  COPY THE CARD TO OUTPUT LISTING
   40 WRITE (IOFILE,41) (AFIELD(I),I=1,NOFLD)
   41 FORMAT(1X,10A8)
C
C  INITIALIZATION FOR NEW CARD
C
   45 KNTRC=0
      KNTLIM=MIN0(8*NOFLD,IWIDTH)
C
C  FETCH FIRST NON-DELIMITER (SEE ROUTINE *NXTCHR* FOR LIST)
C
   50 IF (NXTCHR(0)) 600,50,60
C...  CHECK FOR COMMENT (LEADING ASTERISK)
   60 IF (ACHAR.EQ.ASTK) GO TO 10
      GO TO 100
C
C  FETCH NEXT CHARACTER
C
   70 IF (NXTCHR(0)) 600,80,100
C
C  TWO CONSECUTIVE DELIMITERS IMPLY NUMERIC ZERO UNLESS THE DELIMITER
C  IS A BLANK OR PARENTHESIS.
C
   80 IF (ACHAR.EQ.ABLNK) GO TO 70
      IF (ACHAR.EQ.ALPRN) GO TO 70
      IF (ACHAR.EQ.ARPRN) GO TO 70
      IF (ACHAR.EQ.AEQUAL) GO TO 70
C...  CHECK FOR SUFFICIENT SPACE IN STORAGE ARRAYS
      IF (NUMFLD.LT.INSIZE-1) GO TO 90
      CALL EXTMEM(IFIELD,50)
      CALL EXTMEM(ICODE,50)
      CALL EXTMEM(IDELIM,50)
      CALL EXTMEM(ICOLUM,50)
      INSIZE=INSIZE+50
   90 NUMFLD=NUMFLD+1
      VALUE(IFIELD+NUMFLD)=0.0D0
      NODPLC(ICODE+NUMFLD)=0
      VALUE(IDELIM+NUMFLD)=ACHAR
      NODPLC(ICOLUM+NUMFLD)=KNTRC
      GO TO 70
C
C  CHECK FOR SUFFICIENT SPACE IN STORAGE ARRAYS
C
  100 IF (NUMFLD.LT.INSIZE-1) GO TO 110
      CALL EXTMEM(IFIELD,50)
      CALL EXTMEM(ICODE,50)
      CALL EXTMEM(IDELIM,50)
      CALL EXTMEM(ICOLUM,50)
      INSIZE=INSIZE+50
C
C  BEGIN SCAN OF NEXT FIELD
C
C...  INITIALIZATION
  110 JDELIM=0
      XSIGN=1.0D0
      XMANT=0.0D0
      IDEC=0
      IEXP=0
C...  CHECK FOR LEADING PLUS OR MINUS SIGN
      IF (ACHAR.EQ.APLUS) GO TO 210
      IF (ACHAR.EQ.AMINUS) GO TO 200
C...  FINISH INITIALIZATION
      ANAM=ABLNK
      KCHR=1
C...  AN ISOLATED PERIOD INDICATES THAT A CONTINUATION CARD FOLLOWS
      IF (ACHAR.NE.APER) GO TO 120
C...  ALTER INITIALIZATION SLIGHTLY IF LEADING PERIOD FOUND
      IDEC=1
      IEXP=-1
      ANAM=APER
      KCHR=2
C...  NOW TAKE A LOOK AT THE NEXT CHARACTER
      IF (NXTCHR(0)) 10,10,120
C
C  TEST FOR NUMBER (ANY DIGIT)
C
  120 DO 130 I=1,10
      IF (ACHAR.NE.ADIGIT(I)) GO TO 130
      XMANT=DFLOAT(I-1)
      GO TO 210
  130 CONTINUE
C
C  ASSEMBLE NAME
C
      NUMFLD=NUMFLD+1
      CALL MOVE(ANAM,KCHR,ACHAR,1,1)
      KCHR=KCHR+1
      DO 150 I=KCHR,8
      IF (NXTCHR(0)) 160,160,140
  140 CALL MOVE(ANAM,I,ACHAR,1,1)
  150 CONTINUE
      GO TO 170
  160 JDELIM=1
  170 VALUE(IFIELD+NUMFLD)=ANAM
      NODPLC(ICODE+NUMFLD)=1
      NODPLC(ICOLUM+NUMFLD)=KNTRC
C...  NO '+' FORMAT CONTINUATION POSSIBLE FOR .END CARD
      IF (NUMFLD.GE.2) GO TO 400
      IF (ANAM.NE.AEND) GO TO 400
      NODPLC(ICODE+NUMFLD+1)=-1
      GO TO 1000
C
C  PROCESS NUMBER
C
C...  TAKE NOTE OF LEADING MINUS SIGN
  200 XSIGN=-1.0D0
C...  TAKE A LOOK AT THE NEXT CHARACTER
  210 IF (NXTCHR(0)) 335,335,220
C...  TEST FOR DIGIT
  220 DO 230 I=1,10
      IF (ACHAR.NE.ADIGIT(I)) GO TO 230
      XMANT=XMANT*10.0D0+DFLOAT(I-1)
      IF (IDEC.EQ.0) GO TO 210
      IEXP=IEXP-1
      GO TO 210
  230 CONTINUE
C
C  CHECK FOR DECIMAL POINT
C
      IF (ACHAR.NE.APER) GO TO 240
C...  MAKE CERTAIN THAT THIS IS THE FIRST ONE FOUND
      IF (IDEC.NE.0) GO TO 500
      IDEC=1
      GO TO 210
C
C  TEST FOR EXPONENT
C
  240 IF (ACHAR.NE.AE) GO TO 300
      IF (NXTCHR(0)) 335,335,250
  250 ITEMP=0
      ISIGN=1
C...  CHECK FOR POSSIBLE LEADING SIGN ON EXPONENT
      IF (ACHAR.EQ.APLUS) GO TO 260
      IF (ACHAR.NE.AMINUS) GO TO 270
      ISIGN=-1
  260 IF (NXTCHR(0)) 285,285,270
C...  TEST FOR DIGIT
  270 DO 280 I=1,10
      IF (ACHAR.NE.ADIGIT(I)) GO TO 280
      ITEMP=ITEMP*10+I-1
      GO TO 260
  280 CONTINUE
      GO TO 290
  285 JDELIM=1
C...  CORRECT INTERNAL EXPONENT
  290 IEXP=IEXP+ISIGN*ITEMP
      GO TO 340
C
C  TEST FOR SCALE FACTOR
C
  300 IF (ACHAR.NE.AM) GO TO 330
C...  SPECIAL CHECK FOR *ME* (AS DISTINGUISHED FROM *M*)
      IF (NXTCHR(0)) 320,320,310
  310 IF (ACHAR.NE.AE) GO TO 315
      IEXP=IEXP+6
      GO TO 340
  315 IF (ACHAR.NE.AI) GO TO 325
      XMANT=XMANT*25.4D-6
      GO TO 340
  320 JDELIM=1
  325 IEXP=IEXP-3
      GO TO 340
  330 IF (ACHAR.EQ.AT) IEXP=IEXP+12
      IF (ACHAR.EQ.BG) IEXP=IEXP+9
      IF (ACHAR.EQ.AK) IEXP=IEXP+3
      IF (ACHAR.EQ.AU) IEXP=IEXP-6
      IF (ACHAR.EQ.AN) IEXP=IEXP-9
      IF (ACHAR.EQ.AP) IEXP=IEXP-12
      IF (ACHAR.EQ.AF) IEXP=IEXP-15
      GO TO 340
  335 JDELIM=1
C
C  ASSEMBLE THE FINAL NUMBER
C
  340 IF (XMANT.EQ.0.0D0) GO TO 350
      IF (IEXP.EQ.0) GO TO 350
      IF (IABS(IEXP).GE.201) GO TO 500
      XMANT=XMANT*DEXP(DFLOAT(IEXP)*XLOG10)
      IF (XMANT.GT.1.0D+35) GO TO 500
      IF (XMANT.LT.1.0D-35) GO TO 500
  350 NUMFLD=NUMFLD+1
      VALUE(IFIELD+NUMFLD)=DSIGN(XMANT,XSIGN)
      NODPLC(ICODE+NUMFLD)=0
      NODPLC(ICOLUM+NUMFLD)=KNTRC
C
C  SKIP TO NON-BLANK DELIMITER (IF NECESSARY)
C
  400 IF (JDELIM.EQ.0) GO TO 440
  410 VALUE(IDELIM+NUMFLD)=ACHAR
      IF (ACHAR.NE.ABLNK) GO TO 70
      IF (NXTCHR(0)) 450,410,420
  420 KNTRC=KNTRC-1
      GO TO 70
  440 IF (NXTCHR(0)) 450,410,440
  450 VALUE(IDELIM+NUMFLD)=ACHAR
      GO TO 600
C
C  ERRORS
C
  500 WRITE (IOFILE,501) KNTRC
  501 FORMAT('0*ERROR*:  ILLEGAL NUMBER -- SCAN STOPPED AT COLUMN ',I3/)
      IGOOF=1
      NUMFLD=NUMFLD+1
      VALUE(IFIELD+NUMFLD)=0.0D0
      NODPLC(ICODE+NUMFLD)=0
      VALUE(IDELIM+NUMFLD)=ACHAR
      NODPLC(ICOLUM+NUMFLD)=KNTRC
C
C  FINISHED
C
  600 NODPLC(ICODE+NUMFLD+1)=-1
C
C  CHECK NEXT LINE FOR POSSIBLE CONTINUATION
C
  610 CALL GETLIN
      IF (KEOF.EQ.1) GO TO 15
      NOFLD=10
  620 IF (AFIELD(NOFLD).NE.ABLNK) GO TO 630
      IF (NOFLD.EQ.1) GO TO 650
      NOFLD=NOFLD-1
      GO TO 620
  630 KNTRC=0
      KNTLIM=MIN0(8*NOFLD,IWIDTH)
C...  CONTINUATION LINE HAS A '+' AS FIRST NON-DELIMITER ON CARD
  632 IF(NXTCHR(0)) 650,632,634
  634 IF(ACHAR.NE.APLUS) GO TO 640
      WRITE(IOFILE,41) (AFIELD(I),I=1,NOFLD)
      GO TO 70
  640 IF (ACHAR.NE.ASTK) GO TO 1000
  650 WRITE (IOFILE,41) (AFIELD(I),I=1,NOFLD)
      GO TO 610
 1000 RETURN
      END
