      SUBROUTINE COMCOF
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE CALCULATES THE TIMESTEP-DEPENDENT TERMS USED IN THE
C NUMERICAL INTEGRATION.
C
C SPICE VERSION 2G.6  SCCSID=TABINF 3/15/83
      COMMON /TABINF/ IELMNT,ISBCKT,NSBCKT,IUNSAT,NUNSAT,ITEMPS,NUMTEM,
     1   ISENS,NSENS,IFOUR,NFOUR,IFIELD,ICODE,IDELIM,ICOLUM,INSIZE,
     2   JUNODE,LSBKPT,NUMBKP,IORDER,JMNODE,IUR,IUC,ILC,ILR,NUMOFF,ISR,
     3   NMOFFC,ISEQ,ISEQ1,NEQN,NODEVS,NDIAG,ISWAP,IEQUA,MACINS,LVNIM1,
     4   LX0,LVN,LYNL,LYU,LYL,LX1,LX2,LX3,LX4,LX5,LX6,LX7,LD0,LD1,LTD,
     5   IMYNL,IMVN,LCVN,NSNOD,NSMAT,NSVAL,ICNOD,ICMAT,ICVAL,
     6   LOUTPT,LPOL,LZER,IRSWPF,IRSWPR,ICSWPF,ICSWPR,IRPT,JCPT,
     7   IROWNO,JCOLNO,NTTBR,NTTAR,LVNTMP
C SPICE VERSION 2G.6  SCCSID=STATUS 3/15/83
      COMMON /STATUS/ OMEGA,TIME,DELTA,DELOLD(7),AG(7),VT,XNI,EGFET,
     1   XMU,SFACTR,MODE,MODEDC,ICALC,INITF,METHOD,IORD,MAXORD,NONCON,
     2   ITERNO,ITEMNO,NOSOLV,MODAC,IPIV,IVMFLG,IPOSTP,ISCRCH,IOFILE
C SPICE VERSION 2G.6  SCCSID=FLAGS 3/15/83
      COMMON /FLAGS/ IPRNTA,IPRNTL,IPRNTM,IPRNTN,IPRNTO,LIMTIM,LIMPTS,
     1   LVLCOD,LVLTIM,ITL1,ITL2,ITL3,ITL4,ITL5,ITL6,IGOOF,NOGO,KEOF
C SPICE VERSION 2G.6  SCCSID=BLANK 3/15/83
      COMMON /BLANK/ VALUE(200000)
      INTEGER NODPLC(64)
      COMPLEX CVALUE(32)
      EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1))
      DIMENSION GMAT(7,7)
C
C  COMPUTE COEFFICIENTS FOR PARTICULAR INTEGRATION METHOD
C
      IF (METHOD.NE.1) GO TO 5
      IF (IORD.EQ.1) GO TO 5
C...  TRAPEZOIDAL METHOD
      AG(1)=1.0D0/DELTA/(1.0D0-XMU)
      AG(2)=XMU/(1.0D0-XMU)
      GO TO 200
C
C  CONSTRUCT GEAR COEFFICIENT MATRIX
C
    5 ISTOP=IORD+1
      CALL ZERO8(AG,ISTOP)
      AG(2)=-1.0D0
      DO 10 I=1,ISTOP
      GMAT(1,I)=1.0D0
   10 CONTINUE
      DO 20 I=2,ISTOP
      GMAT(I,1)=0.0D0
   20 CONTINUE
      ARG=0.0D0
      DO 40 I=2,ISTOP
      ARG=ARG+DELOLD(I-1)
      ARG1=1.0D0
      DO 30 J=2,ISTOP
      ARG1=ARG1*ARG
      GMAT(J,I)=ARG1
   30 CONTINUE
   40 CONTINUE
C
C  SOLVE FOR GEAR COEFFICIENTS AG(*)
C
C
C  LU DECOMPOSITION
C
      DO 70 I=2,ISTOP
      JSTART=I+1
      IF (JSTART.GT.ISTOP) GO TO 70
      DO 60 J=JSTART,ISTOP
      GMAT(J,I)=GMAT(J,I)/GMAT(I,I)
      DO 50 K=JSTART,ISTOP
      GMAT(J,K)=GMAT(J,K)-GMAT(J,I)*GMAT(I,K)
   50 CONTINUE
   60 CONTINUE
   70 CONTINUE
C
C  FORWARD SUBSTITUTION
C
      DO 90 I=2,ISTOP
      JSTART=I+1
      IF (JSTART.GT.ISTOP) GO TO 90
      DO 80 J=JSTART,ISTOP
      AG(J)=AG(J)-GMAT(J,I)*AG(I)
   80 CONTINUE
   90 CONTINUE
C
C  BACKWARD SUBSTITUTION
C
      AG(ISTOP)=AG(ISTOP)/GMAT(ISTOP,ISTOP)
      IR=ISTOP
      DO 110 I=2,ISTOP
      JSTART=IR
      IR=IR-1
      DO 100 J=JSTART,ISTOP
      AG(IR)=AG(IR)-GMAT(IR,J)*AG(J)
  100 CONTINUE
      AG(IR)=AG(IR)/GMAT(IR,IR)
  110 CONTINUE
C
C  FINISHED
C
  200 RETURN
      END
