      SUBROUTINE DCOP
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE PRINTS OUT THE OPERATING POINTS OF THE NONLINEAR
C CIRCUIT ELEMENTS.
C
C SPICE VERSION 2G.6  SCCSID=TABINF 3/15/83
      COMMON /TABINF/ IELMNT,ISBCKT,NSBCKT,IUNSAT,NUNSAT,ITEMPS,NUMTEM,
     1   ISENS,NSENS,IFOUR,NFOUR,IFIELD,ICODE,IDELIM,ICOLUM,INSIZE,
     2   JUNODE,LSBKPT,NUMBKP,IORDER,JMNODE,IUR,IUC,ILC,ILR,NUMOFF,ISR,
     3   NMOFFC,ISEQ,ISEQ1,NEQN,NODEVS,NDIAG,ISWAP,IEQUA,MACINS,LVNIM1,
     4   LX0,LVN,LYNL,LYU,LYL,LX1,LX2,LX3,LX4,LX5,LX6,LX7,LD0,LD1,LTD,
     5   IMYNL,IMVN,LCVN,NSNOD,NSMAT,NSVAL,ICNOD,ICMAT,ICVAL,
     6   LOUTPT,LPOL,LZER,IRSWPF,IRSWPR,ICSWPF,ICSWPR,IRPT,JCPT,
     7   IROWNO,JCOLNO,NTTBR,NTTAR,LVNTMP
C SPICE VERSION 2G.6  SCCSID=CIRDAT 3/15/83
      COMMON /CIRDAT/ LOCATE(50),JELCNT(50),NUNODS,NCNODS,NUMNOD,NSTOP,
     1   NUT,NLT,NXTRM,NDIST,NTLIN,IBR,NUMVS,NUMALT,NUMCYC
C SPICE VERSION 2G.6  SCCSID=STATUS 3/15/83
      COMMON /STATUS/ OMEGA,TIME,DELTA,DELOLD(7),AG(7),VT,XNI,EGFET,
     1   XMU,SFACTR,MODE,MODEDC,ICALC,INITF,METHOD,IORD,MAXORD,NONCON,
     2   ITERNO,ITEMNO,NOSOLV,MODAC,IPIV,IVMFLG,IPOSTP,ISCRCH,IOFILE
C SPICE VERSION 2G.6  SCCSID=KNSTNT 3/15/83
      COMMON /KNSTNT/ TWOPI,XLOG2,XLOG10,ROOT2,RAD,BOLTZ,CHARGE,CTOK,
     1   GMIN,RELTOL,ABSTOL,VNTOL,TRTOL,CHGTOL,EPS0,EPSSIL,EPSOX,
     2   PIVTOL,PIVREL
C SPICE VERSION 2G.6  SCCSID=MISCEL 3/15/83
      COMMON /MISCEL/ ATIME,APROG(3),ADATE,ATITLE(10),DEFL,DEFW,DEFAD,
     1  DEFAS,RSTATS(50),IWIDTH,LWIDTH,NOPAGE
C SPICE VERSION 2G.6  SCCSID=DC 3/15/83
      COMMON /DC/ TCSTAR(2),TCSTOP(2),TCINCR(2),ICVFLG,ITCELM(2),KSSOP,
     1   KINEL,KIDIN,KOVAR,KIDOUT
C SPICE VERSION 2G.6  SCCSID=AC 3/15/83
      COMMON /AC/ FSTART,FSTOP,FINCR,SKW2,REFPRL,SPW2,JACFLG,IDFREQ,
     1   INOISE,NOSPRT,NOSOUT,NOSIN,IDIST,IDPRT
C SPICE VERSION 2G.6  SCCSID=BLANK 3/15/83
      COMMON /BLANK/ VALUE(200000)
      INTEGER NODPLC(64)
      COMPLEX CVALUE(32)
      EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1))
      LOGICAL MEMPTR
C
C
      DIMENSION OPTITL(4)
      DIMENSION ANAM(12),AV1(12),AI1(12),REQ(12)
      DIMENSION AMOD(12),VD(12),CAP(12)
      DIMENSION CB(12),CC(12),VBE(12),VBC(12),VCE(12),RPI(12),
     1   RO(12),CPI(12),CMU(12),BETADC(12),BETAAC(12),FT(12),
     2   CCS(12),CBX(12),RX(12)
      DIMENSION CG(12),VGS(12),VDS(12),GDS(12),VBS(12),CBD(12),CBS(12),
     2  CGSOV(12),CGDOV(12),CGBOV(12),VTH(12),VDSAT(12),CD(12),GM(12),
     3  CGGB(12),CGDB(12),CGSB(12),CBGB(12),CBDB(12),CBSB(12),
     4  GMB(12)
      DIMENSION CGS(12),CGD(12),CGB(12),CDS(12)
      EQUIVALENCE(CB(1),CG(1)),(CC(1),VGS(1)),(VBE(1),VDS(1)),
     1(VBC(1),GDS(1)),(VCE(1),VBS(1)),(RPI(1),CBD(1)),
     2(RO(1),CBS(1)),(CPI(1),CGSOV(1)),(CMU(1),CGDOV(1)),
     3(BETADC(1),CGBOV(1)),(BETAAC(1),VTH(1)),(FT(1),VDSAT(1)),
     4(CCS(1),CD(1)),(CBX(1),CGGB(1)),(RX(1),CGDB(1))
      EQUIVALENCE(VD(1),CG(1)),(CAP(1),VGS(1)),(AV1(1),VDS(1)),
     1  (AI1(1),GDS(1)),(REQ(1),VBS(1))
      EQUIVALENCE (CGS(1),CGGB(1)),(CGD(1),CGDB(1)),(CGB(1),CGSB(1)),
     1  (CDS(1),CBGB(1))
      DIMENSION AFMT1(3),AFMT2(2),AFMT3(3),AFMT4(3)
      DATA OPTITL / 8HOPERATIN, 8HG POINT , 8HINFORMAT, 8HION      /
      DATA AV,AVD,AVBE,AVBC,AVCE,AVGS,AVDS,AVBS / 1HV,2HVD,3HVBE,3HVBC,
     1   3HVCE,3HVGS,3HVDS,3HVBS /
      DATA ACNTRV,ACNTRI,ASRCV,ASRCI,ATRANG,ATRANR,AVGAIN,AIGAIN /
     1   8HV-CONTRL, 8HI-CONTRL, 8HV-SOURCE, 8HI-SOURCE,
     2   8HTRANS-G , 8HTRANS-R , 8HV GAIN  , 8HI GAIN   /
      DATA AI,AID,AIB,AIC,AIG / 1HI,2HID,2HIB,2HIC,2HIG /
      DATA AREQ,ARPI,ARO / 3HREQ,3HRPI,2HRO /
      DATA ACAP,ACPI,ACMU,ACGS,ACGD,ACBD,ACBS / 3HCAP,3HCPI,3HCMU,3HCGS,
     1   3HCGD,3HCBD,3HCBS /
      DATA ACGSOV,ACGDOV,ACGBOV /6HCGSOVL,6HCGDOVL,6HCGBOVL/
      DATA ACGGB,ACGDB,ACGSB,ACBGB,ACBDB,ACBSB /7HDQGDVGB,7HDQGDVDB,
     1  7HDQGDVSB,7HDQBDVGB,7HDQBDVDB,7HDQBDVSB/
      DATA ACGB,ACDS / 3HCGB,3HCDS /
      DATA AVTH, AVDSAT / 3HVTH, 5HVDSAT /
      DATA AGM,AGDS / 2HGM,3HGDS /
      DATA AGMB / 4HGMB /
      DATA ACCS,ACBX,ARX /3HCCS,3HCBX,2HRX/
      DATA ABETAD,ABETAA / 6HBETADC,6HBETAAC /
      DATA AFT / 2HFT /
C
      DATA ABLNK /1H /
      DATA AFMT1 /8H(//1H0,1,8H0X,  (2X,8H,A8))   /
      DATA AFMT2 /8H(1H ,A8,,8H  F10.3)/
      DATA AFMT3 /8H(1H ,A8,,8H1P  E10.,8H2)      /
      DATA AFMT4 /8H('0MODEL,8H   ',  (,8H2X,A8)) /
C
C.. FIX-UP THE FORMAT STATEMENTS
C
      KNTR=12
      IF(LWIDTH.LE.80) KNTR=7
      IPOS=12
      CALL MOVE(AFMT1,IPOS,ABLNK,1,2)
      CALL ALFNUM(KNTR,AFMT1,IPOS)
      IPOS=9
      CALL MOVE(AFMT2,IPOS,ABLNK,1,2)
      CALL ALFNUM(KNTR,AFMT2,IPOS)
      IPOS=11
      CALL MOVE(AFMT3,IPOS,ABLNK,1,2)
      CALL ALFNUM(KNTR,AFMT3,IPOS)
      IPOS=14
      CALL MOVE(AFMT4,IPOS,ABLNK,1,2)
      CALL ALFNUM(KNTR,AFMT4,IPOS)
C
C  COMPUTE VOLTAGE SOURCE CURRENTS AND POWER DISSIPATION
C
      CALL SECOND(T1)
      IF ((MODE.EQ.1).AND.(MODEDC.EQ.2).AND.(NOSOLV.NE.0)) GO TO 700
      POWER=0.0D0
      IF (JELCNT(9).EQ.0) GO TO 50
      ITITLE=0
   11 FORMAT (////5X,'VOLTAGE SOURCE CURRENTS'//5X,'NAME',
     1   7X,'CURRENT'/)
      LOC=LOCATE(9)
   20 IF ((LOC.EQ.0).OR.(NODPLC(LOC+11).NE.0)) GO TO 50
      LOCV=NODPLC(LOC+1)
      IPTR=NODPLC(LOC+6)
      CREAL=VALUE(LVNIM1+IPTR)
      POWER=POWER-CREAL*VALUE(LOCV+1)
      IF (ITITLE.EQ.0) WRITE (IOFILE,11)
      ITITLE=1
      WRITE (IOFILE,21) VALUE(LOCV),CREAL
   21 FORMAT (/5X,A8,1X,1PD10.3)
   30 LOC=NODPLC(LOC)
      GO TO 20
   50 LOC=LOCATE(10)
   60 IF ((LOC.EQ.0).OR.(NODPLC(LOC+6).NE.0)) GO TO 90
      LOCV=NODPLC(LOC+1)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      POWER=POWER-VALUE(LOCV+1)
     1   *(VALUE(LVNIM1+NODE1)-VALUE(LVNIM1+NODE2))
      LOC=NODPLC(LOC)
      GO TO 60
   90 WRITE (IOFILE,91) POWER
   91 FORMAT (//5X,'TOTAL POWER DISSIPATION  ',1PD9.2,'  WATTS')
C
C  SMALL SIGNAL DEVICE PARAMETERS
C
      NUMDEV=JELCNT(5)+JELCNT(6)+JELCNT(7)+JELCNT(8)+JELCNT(11)
     1   +JELCNT(12)+JELCNT(13)+JELCNT(14)
      IF (NUMDEV.EQ.0) GO TO 600
      CALL TITLE(0,LWIDTH,1,OPTITL)
      KNTLIM=LWIDTH/11
C
C  NONLINEAR VOLTAGE CONTROLLED CURRENT SOURCES
C
      IF (JELCNT(5).EQ.0) GO TO 175
      ITITLE=0
  111 FORMAT(1H0,/,'0**** VOLTAGE-CONTROLLED CURRENT SOURCES')
      LOC=LOCATE(5)
      KNTR=0
  120 IF ((LOC.EQ.0).OR.(NODPLC(LOC+13).NE.0)) GO TO 140
      KNTR=KNTR+1
      LOCV=NODPLC(LOC+1)
      LOCT=LX0+NODPLC(LOC+12)
      ANAM(KNTR)=VALUE(LOCV)
      AI1(KNTR)=VALUE(LOCT)
      IF (KNTR.GE.KNTLIM) GO TO 150
  130 LOC=NODPLC(LOC)
      GO TO 120
  140 IF (KNTR.EQ.0) GO TO 175
  150 IF (ITITLE.EQ.0) WRITE (IOFILE,111)
      ITITLE=1
      WRITE (IOFILE,AFMT1) (ANAM(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ASRCI,(AI1(I),I=1,KNTR)
      KNTR=0
      IF ((LOC.NE.0).AND.(NODPLC(LOC+13).EQ.0)) GO TO 130
C
C  NONLINEAR VOLTAGE CONTROLLED VOLTAGE SOURCES
C
  175 IF (JELCNT(6).EQ.0) GO TO 186
      ITITLE=0
  176 FORMAT(1H0,/,'0**** VOLTAGE-CONTROLLED VOLTAGE SOURCES')
      LOC=LOCATE(6)
      KNTR=0
  178 IF ((LOC.EQ.0).OR.(NODPLC(LOC+14).NE.0)) GO TO 182
      KNTR=KNTR+1
      LOCV=NODPLC(LOC+1)
      LOCT=LX0+NODPLC(LOC+13)
      ANAM(KNTR)=VALUE(LOCV)
      AV1(KNTR)=VALUE(LOCT)
      AI1(KNTR)=VALUE(LOCT+1)
      IF (KNTR.GE.KNTLIM) GO TO 184
  180 LOC=NODPLC(LOC)
      GO TO 178
  182 IF (KNTR.EQ.0) GO TO 186
  184 IF (ITITLE.EQ.0) WRITE (IOFILE,176)
      ITITLE=1
      WRITE (IOFILE,AFMT1) (ANAM(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ASRCV,(AV1(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ASRCI,(AI1(I),I=1,KNTR)
      KNTR=0
      IF ((LOC.NE.0).AND.(NODPLC(LOC+14).EQ.0)) GO TO 180
C
C  NONLINEAR CURRENT CONTROLLED CURRENT SOURCES
C
  186 IF (JELCNT(7).EQ.0) GO TO 196
      ITITLE=0
  187 FORMAT(1H0,/,'0**** CURRENT-CONTROLLED CURRENT SOURCES')
      LOC=LOCATE(7)
      KNTR=0
  188 IF ((LOC.EQ.0).OR.(NODPLC(LOC+13).NE.0)) GO TO 192
      KNTR=KNTR+1
      LOCV=NODPLC(LOC+1)
      LOCT=LX0+NODPLC(LOC+12)
      ANAM(KNTR)=VALUE(LOCV)
      AI1(KNTR)=VALUE(LOCT)
      IF (KNTR.GE.KNTLIM) GO TO 194
  190 LOC=NODPLC(LOC)
      GO TO 188
  192 IF (KNTR.EQ.0) GO TO 196
  194 IF (ITITLE.EQ.0) WRITE (IOFILE,187)
      ITITLE=1
      WRITE (IOFILE,AFMT1) (ANAM(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ASRCI,(AI1(I),I=1,KNTR)
      KNTR=0
      IF ((LOC.NE.0).AND.(NODPLC(LOC+13).EQ.0)) GO TO 190
C
C  NONLINEAR CURRENT CONTROLLED VOLTAGE SOURCES
C
  196 IF (JELCNT(8).EQ.0) GO TO 210
      ITITLE=0
  197 FORMAT(1H0,/,'0**** CURRENT-CONTROLLED VOLTAGE SOURCES')
      LOC=LOCATE(8)
      KNTR=0
  198 IF ((LOC.EQ.0).OR.(NODPLC(LOC+14).NE.0)) GO TO 202
      KNTR=KNTR+1
      LOCV=NODPLC(LOC+1)
      LOCT=LX0+NODPLC(LOC+13)
      ANAM(KNTR)=VALUE(LOCV)
      AV1(KNTR)=VALUE(LOCT)
      AI1(KNTR)=VALUE(LOCT+1)
      IF (KNTR.GE.KNTLIM) GO TO 204
  200 LOC=NODPLC(LOC)
      GO TO 198
  202 IF (KNTR.EQ.0) GO TO 210
  204 IF (ITITLE.EQ.0) WRITE (IOFILE,197)
      ITITLE=1
      WRITE (IOFILE,AFMT1) (ANAM(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ASRCV,(AV1(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ASRCI,(AI1(I),I=1,KNTR)
      KNTR=0
      IF ((LOC.NE.0).AND.(NODPLC(LOC+14).EQ.0)) GO TO 200
C
C  DIODES
C
  210 IF (JELCNT(11).EQ.0) GO TO 300
      ITITLE=0
  211 FORMAT(1H0,/,'0**** DIODES')
      LOC=LOCATE(11)
      KNTR=0
  220 IF ((LOC.EQ.0).OR.(NODPLC(LOC+16).NE.0)) GO TO 240
      KNTR=KNTR+1
      LOCV=NODPLC(LOC+1)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      LOCM=NODPLC(LOC+5)
      LOCM=NODPLC(LOCM+1)
      LOCT=LX0+NODPLC(LOC+11)
      ANAM(KNTR)=VALUE(LOCV)
      AMOD(KNTR)=VALUE(LOCM)
      CD(KNTR)=VALUE(LOCT+1)
      VD(KNTR)=VALUE(LVNIM1+NODE1)-VALUE(LVNIM1+NODE2)
      IF (MODEDC.NE.1) GO TO 225
      REQ(KNTR)=1.0D0/VALUE(LOCT+2)
      CAP(KNTR)=VALUE(LOCT+4)
  225 IF (KNTR.GE.KNTLIM) GO TO 250
  230 LOC=NODPLC(LOC)
      GO TO 220
  240 IF (KNTR.EQ.0) GO TO 300
  250 IF (ITITLE.EQ.0) WRITE (IOFILE,211)
      ITITLE=1
      WRITE (IOFILE,AFMT1) (ANAM(I),I=1,KNTR)
      WRITE (IOFILE,AFMT4) (AMOD(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) AID,(CD(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) AVD,(VD(I),I=1,KNTR)
      IF (MODEDC.NE.1) GO TO 260
      WRITE (IOFILE,AFMT3) AREQ,(REQ(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ACAP,(CAP(I),I=1,KNTR)
  260 KNTR=0
      IF ((LOC.NE.0).AND.(NODPLC(LOC+16).EQ.0)) GO TO 230
C
C  BIPOLAR JUNCTION TRANSISTORS
C
  300 IF (JELCNT(12).EQ.0) GO TO 400
      ITITLE=0
  301 FORMAT(1H0,/,'0**** BIPOLAR JUNCTION TRANSISTORS')
      LOC=LOCATE(12)
      KNTR=0
  320 IF ((LOC.EQ.0).OR.(NODPLC(LOC+36).NE.0)) GO TO 340
      KNTR=KNTR+1
      LOCV=NODPLC(LOC+1)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      NODE3=NODPLC(LOC+4)
      LOCM=NODPLC(LOC+8)
      TYPE=NODPLC(LOCM+2)
      LOCM=NODPLC(LOCM+1)
      LOCT=LX0+NODPLC(LOC+22)
      ANAM(KNTR)=VALUE(LOCV)
      AMOD(KNTR)=VALUE(LOCM)
      CB(KNTR)=TYPE*VALUE(LOCT+3)
      CC(KNTR)=TYPE*VALUE(LOCT+2)
      VBE(KNTR)=VALUE(LVNIM1+NODE2)-VALUE(LVNIM1+NODE3)
      VBC(KNTR)=VALUE(LVNIM1+NODE2)-VALUE(LVNIM1+NODE1)
      VCE(KNTR)=VBE(KNTR)-VBC(KNTR)
      BETADC(KNTR)=CC(KNTR)/DSIGN(DMAX1(DABS(CB(KNTR)),1.0D-20),
     1  CB(KNTR))
      IF (MODEDC.NE.1) GO TO 325
      RX(KNTR)=0.0D0
      IF(VALUE(LOCT+16).NE.0.0D0) RX(KNTR)=1.0D0/VALUE(LOCT+16)
      CCS(KNTR)=VALUE(LOCT+13)
      CBX(KNTR)=VALUE(LOCT+15)
      RPI(KNTR)=1.0D0/VALUE(LOCT+4)
      GM(KNTR)=VALUE(LOCT+6)
      RO(KNTR)=1.0D0/VALUE(LOCT+7)
      CPI(KNTR)=VALUE(LOCT+9)
      CMU(KNTR)=VALUE(LOCT+11)
      BETAAC(KNTR)=GM(KNTR)*RPI(KNTR)
      FT(KNTR)=GM(KNTR)/(TWOPI*DMAX1(CPI(KNTR)+CMU(KNTR)+CBX(KNTR),
     1  1.0D-20))
  325 IF (KNTR.GE.KNTLIM) GO TO 350
  330 LOC=NODPLC(LOC)
      GO TO 320
  340 IF (KNTR.EQ.0) GO TO 400
  350 IF (ITITLE.EQ.0) WRITE (IOFILE,301)
      ITITLE=1
      WRITE (IOFILE,AFMT1) (ANAM(I),I=1,KNTR)
      WRITE (IOFILE,AFMT4) (AMOD(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) AIB,(CB(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) AIC,(CC(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) AVBE,(VBE(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) AVBC,(VBC(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) AVCE,(VCE(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ABETAD,(BETADC(I),I=1,KNTR)
      IF (MODEDC.NE.1) GO TO 360
      WRITE (IOFILE,AFMT3) AGM,(GM(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ARPI,(RPI(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ARX,(RX(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ARO,(RO(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ACPI,(CPI(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ACMU,(CMU(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ACBX,(CBX(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ACCS,(CCS(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ABETAA,(BETAAC(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) AFT,(FT(I),I=1,KNTR)
  360 KNTR=0
      IF ((LOC.NE.0).AND.(NODPLC(LOC+36).EQ.0)) GO TO 330
C
C  JFETS
C
  400 IF (JELCNT(13).EQ.0) GO TO 500
      ITITLE=0
  401 FORMAT(1H0,/,'0**** JFETS')
      LOC=LOCATE(13)
      KNTR=0
  420 IF ((LOC.EQ.0).OR.(NODPLC(LOC+25).NE.0)) GO TO 440
      KNTR=KNTR+1
      LOCV=NODPLC(LOC+1)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      NODE3=NODPLC(LOC+4)
      LOCM=NODPLC(LOC+7)
      TYPE=NODPLC(LOCM+2)
      LOCM=NODPLC(LOCM+1)
      LOCT=LX0+NODPLC(LOC+19)
      ANAM(KNTR)=VALUE(LOCV)
      AMOD(KNTR)=VALUE(LOCM)
      CD(KNTR)=TYPE*(VALUE(LOCT+3)-VALUE(LOCT+4))
      VGS(KNTR)=VALUE(LVNIM1+NODE2)-VALUE(LVNIM1+NODE3)
      VDS(KNTR)=VALUE(LVNIM1+NODE1)-VALUE(LVNIM1+NODE3)
      IF (MODEDC.NE.1) GO TO 425
      GM(KNTR)=VALUE(LOCT+5)
      GDS(KNTR)=VALUE(LOCT+6)
      CGS(KNTR)=VALUE(LOCT+9)
      CGD(KNTR)=VALUE(LOCT+11)
  425 IF (KNTR.GE.KNTLIM) GO TO 450
  430 LOC=NODPLC(LOC)
      GO TO 420
  440 IF (KNTR.EQ.0) GO TO 500
  450 IF (ITITLE.EQ.0) WRITE (IOFILE,401)
      ITITLE=1
      WRITE (IOFILE,AFMT1) (ANAM(I),I=1,KNTR)
      WRITE (IOFILE,AFMT4) (AMOD(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) AID,(CD(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) AVGS,(VGS(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) AVDS,(VDS(I),I=1,KNTR)
      IF (MODEDC.NE.1) GO TO 460
      WRITE (IOFILE,AFMT3) AGM,(GM(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) AGDS,(GDS(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ACGS,(CGS(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ACGD,(CGD(I),I=1,KNTR)
  460 KNTR=0
      IF ((LOC.NE.0).AND.(NODPLC(LOC+25).EQ.0)) GO TO 430
C
C  MOSFETS
C
  500 IF (JELCNT(14).EQ.0) GO TO 600
      ITITLE=0
  501 FORMAT(1H0,/,'0**** MOSFETS')
      LOC=LOCATE(14)
      KNTR=0
  520 IF ((LOC.EQ.0).OR.(NODPLC(LOC+33).NE.0)) GO TO 540
      KNTR=KNTR+1
      LOCV=NODPLC(LOC+1)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      NODE3=NODPLC(LOC+4)
      NODE4=NODPLC(LOC+5)
      NODE5=NODPLC(LOC+6)
      NODE6=NODPLC(LOC+7)
      LOCM=NODPLC(LOC+8)
      TYPE=NODPLC(LOCM+2)
      LOCM=NODPLC(LOCM+1)
      LOCT=LX0+NODPLC(LOC+26)
      ANAM(KNTR)=VALUE(LOCV)
      AMOD(KNTR)=VALUE(LOCM)
      CD(KNTR)=TYPE*VALUE(LOCT+4)
      VGS(KNTR)=VALUE(LVNIM1+NODE2)-VALUE(LVNIM1+NODE3)
      VDS(KNTR)=VALUE(LVNIM1+NODE1)-VALUE(LVNIM1+NODE3)
      VBS(KNTR)=VALUE(LVNIM1+NODE4)-VALUE(LVNIM1+NODE3)
      IF (MODEDC.NE.1) GO TO 525
      XL=VALUE(LOCV+1)-2.0D0*VALUE(LOCM+28)
      XW=VALUE(LOCV+2)
      COVLGS=VALUE(LOCM+13)*XW
      COVLGD=VALUE(LOCM+14)*XW
      COVLGB=VALUE(LOCM+15)*XL
      XQCO=VALUE(LOCM+35)
      DEVMOD=VALUE(LOCV+8)
      VDSAT(KNTR)=VALUE(LOCV+10)
      VTH(KNTR)=VALUE(LOCV+9)
      GM(KNTR)=VALUE(LOCT+7)
      GDS(KNTR)=VALUE(LOCT+8)
      GMB(KNTR)=VALUE(LOCT+9)
      IF(DEVMOD.GT.0.0D0) GO TO 521
      VTH(KNTR)=VALUE(LOCV+9)
  521 CBD(KNTR)=VALUE(LOCT+24)
      CBS(KNTR)=VALUE(LOCT+26)
      CGSOV(KNTR)=COVLGS
      CGDOV(KNTR)=COVLGD
      CGBOV(KNTR)=COVLGB
      IF (XQCO.GT.0.5D0) GO TO 522
      CGGB(KNTR)=VALUE(LOCT+18)
      CGDB(KNTR)=VALUE(LOCT+19)
      CGSB(KNTR)=VALUE(LOCT+20)
      CBGB(KNTR)=VALUE(LOCT+21)
      CBDB(KNTR)=VALUE(LOCT+22)
      CBSB(KNTR)=VALUE(LOCT+23)
      GO TO 525
  522 CGS(KNTR)=VALUE(LOCT+12)
      CGD(KNTR)=VALUE(LOCT+14)
      CGB(KNTR)=VALUE(LOCT+16)
  525 IF (KNTR.GE.KNTLIM) GO TO 550
  530 LOC=NODPLC(LOC)
      GO TO 520
  540 IF (KNTR.EQ.0) GO TO 600
  550 IF (ITITLE.EQ.0) WRITE (IOFILE,501)
      ITITLE=1
      WRITE (IOFILE,AFMT1) (ANAM(I),I=1,KNTR)
      WRITE (IOFILE,AFMT4) (AMOD(I),I=1,KNTR)
      IF(TYPE.EQ.0.0D0) GO TO 555
      WRITE (IOFILE,AFMT3) AID,(CD(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) AVGS,(VGS(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) AVDS,(VDS(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) AVBS,(VBS(I),I=1,KNTR)
      IF (MODEDC.NE.1) GO TO 560
      WRITE (IOFILE,AFMT2) AVTH,(VTH(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) AVDSAT,(VDSAT(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) AGM,(GM(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) AGDS,(GDS(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) AGMB,(GMB(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ACBD,(CBD(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ACBS,(CBS(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ACGSOV,(CGSOV(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ACGDOV,(CGDOV(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ACGBOV,(CGBOV(I),I=1,KNTR)
      IF (XQCO.GT.0.5D0) GO TO 552
      WRITE (IOFILE,551)
  551 FORMAT(' DERIVATIVES OF GATE (DQGDVX) AND BULK (DQBDVX) CHARGES')
      WRITE (IOFILE,AFMT3) ACGGB,(CGGB(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ACGDB,(CGDB(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ACGSB,(CGSB(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ACBGB,(CBGB(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ACBDB,(CBDB(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ACBSB,(CBSB(I),I=1,KNTR)
      GO TO 560
  552 WRITE (IOFILE,AFMT3) ACGS,(CGS(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ACGD,(CGD(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ACGB,(CGB(I),I=1,KNTR)
      GO TO 560
  555 WRITE (IOFILE,AFMT3) AID,(CD(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) AIG,(CG(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) AVGS,(VGS(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) AVDS,(VDS(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) AVBS,(VBS(I),I=1,KNTR)
      IF (MODEDC.NE.1) GO TO 560
      WRITE (IOFILE,AFMT3) AGM,(GM(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) AGDS,(GDS(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ACGS,(CGS(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ACGD,(CGD(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ACGB,(CGB(I),I=1,KNTR)
      WRITE (IOFILE,AFMT3) ACDS,(CDS(I),I=1,KNTR)
  560 KNTR=0
      IF ((LOC.NE.0).AND.(NODPLC(LOC+33).EQ.0)) GO TO 530
C
C  OPERATING POINT ANALYSES
C
  600 IF (MODEDC.NE.1) GO TO 700
      IF (KINEL.EQ.0) GO TO 610
      CALL SSTF
  610 IF (NSENS.EQ.0) GO TO 700
      CALL SENCAL
C
C  FINISHED
C
  700 IF (MODEDC.EQ.2) GO TO 710
      IF (JACFLG.NE.0) GO TO 705
      CALL CLRMEM(LVNIM1)
      CALL CLRMEM(LX0)
  705 CALL CLRMEM(LVN)
      CALL CLRMEM(LVNTMP)
      IF (MEMPTR(MACINS)) CALL CLRMEM(MACINS)
  710 CALL SECOND(T2)
      RSTATS(5)=RSTATS(5)+T2-T1
      RETURN
      END
