      SUBROUTINE DCSOL
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE SOLVES THE SYSTEM OF CIRCUIT EQUATIONS BY PERFORMING
C A FORWARD AND BACKWARD SUBSTITUTION STEP USING THE PREVIOUSLY-COMPUTED
C LU FACTORS.
C
C SPICE VERSION 2G.6  SCCSID=TABINF 3/15/83
      COMMON /TABINF/ IELMNT,ISBCKT,NSBCKT,IUNSAT,NUNSAT,ITEMPS,NUMTEM,
     1   ISENS,NSENS,IFOUR,NFOUR,IFIELD,ICODE,IDELIM,ICOLUM,INSIZE,
     2   JUNODE,LSBKPT,NUMBKP,IORDER,JMNODE,IUR,IUC,ILC,ILR,NUMOFF,ISR,
     3   NMOFFC,ISEQ,ISEQ1,NEQN,NODEVS,NDIAG,ISWAP,IEQUA,MACINS,LVNIM1,
     4   LX0,LVN,LYNL,LYU,LYL,LX1,LX2,LX3,LX4,LX5,LX6,LX7,LD0,LD1,LTD,
     5   IMYNL,IMVN,LCVN,NSNOD,NSMAT,NSVAL,ICNOD,ICMAT,ICVAL,
     6   LOUTPT,LPOL,LZER,IRSWPF,IRSWPR,ICSWPF,ICSWPR,IRPT,JCPT,
     7   IROWNO,JCOLNO,NTTBR,NTTAR,LVNTMP
C SPICE VERSION 2G.6  SCCSID=MISCEL 3/15/83
      COMMON /MISCEL/ ATIME,APROG(3),ADATE,ATITLE(10),DEFL,DEFW,DEFAD,
     1  DEFAS,RSTATS(50),IWIDTH,LWIDTH,NOPAGE
C SPICE VERSION 2G.6  SCCSID=CIRDAT 3/15/83
      COMMON /CIRDAT/ LOCATE(50),JELCNT(50),NUNODS,NCNODS,NUMNOD,NSTOP,
     1   NUT,NLT,NXTRM,NDIST,NTLIN,IBR,NUMVS,NUMALT,NUMCYC
C SPICE VERSION 2G.6  SCCSID=BLANK 3/15/83
      COMMON /BLANK/ VALUE(200000)
      INTEGER NODPLC(64)
      COMPLEX CVALUE(32)
      EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1))
C
C  FORWARD SUBSTITUTION
C
      CALL SECOND(T1)
      DO 20 I=2,NSTOP
      LOC=I
      IORD=NODPLC(IRSWPF+I)
   10 LOC=NODPLC(JCPT+LOC)
      IF (NODPLC(JCOLNO+LOC).GE.I) GO TO 20
      J=NODPLC(JCOLNO+LOC)
      JORD=NODPLC(IRSWPF+J)
      VALUE(LVN+IORD)=VALUE(LVN+IORD)-
     1           VALUE(LVN+LOC)*VALUE(LVN+JORD)
      GO TO 10
   20 CONTINUE
C
C     BACK SUBSTITUTION
C
      I=NSTOP
      IORD=NODPLC(IRSWPF+I)
      JORD=NODPLC(ICSWPF+I)
      LOCNN=INDXX(IORD,JORD)
   30 VALUE(LVN+IORD)=VALUE(LVN+IORD)/VALUE(LVN+LOCNN)
      I=I-1
      IF (I.LE.1) GO TO 100
      IORD=NODPLC(IRSWPF+I)
      LOC=I
   35 LOC=NODPLC(JCPT+LOC)
   40 IF (NODPLC(JCOLNO+LOC).NE.I) GO TO 35
      LOCNN=LOC
   50 LOC=NODPLC(JCPT+LOC)
      IF (LOC.EQ.0) GO TO 30
      J=NODPLC(JCOLNO+LOC)
      JORD=NODPLC(IRSWPF+J)
      VALUE(LVN+IORD)=VALUE(LVN+IORD)-
     1           VALUE(LVN+LOC)*VALUE(LVN+JORD)
      GO TO 50
  100 CALL SECOND(T2)
      RSTATS(46)=RSTATS(46)+T2-T1
      RETURN
      END
