      SUBROUTINE DINIT
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE PERFORMS STORAGE-ALLOCATION AND ONE-TIME COMPUTATION
C NEEDED TO DO THE SMALL-SIGNAL DISTORTION ANALYSIS.
C
C SPICE VERSION 2G.6  SCCSID=TABINF 3/15/83
      COMMON /TABINF/ IELMNT,ISBCKT,NSBCKT,IUNSAT,NUNSAT,ITEMPS,NUMTEM,
     1   ISENS,NSENS,IFOUR,NFOUR,IFIELD,ICODE,IDELIM,ICOLUM,INSIZE,
     2   JUNODE,LSBKPT,NUMBKP,IORDER,JMNODE,IUR,IUC,ILC,ILR,NUMOFF,ISR,
     3   NMOFFC,ISEQ,ISEQ1,NEQN,NODEVS,NDIAG,ISWAP,IEQUA,MACINS,LVNIM1,
     4   LX0,LVN,LYNL,LYU,LYL,LX1,LX2,LX3,LX4,LX5,LX6,LX7,LD0,LD1,LTD,
     5   IMYNL,IMVN,LCVN,NSNOD,NSMAT,NSVAL,ICNOD,ICMAT,ICVAL,
     6   LOUTPT,LPOL,LZER,IRSWPF,IRSWPR,ICSWPF,ICSWPR,IRPT,JCPT,
     7   IROWNO,JCOLNO,NTTBR,NTTAR,LVNTMP
C SPICE VERSION 2G.6  SCCSID=CIRDAT 3/15/83
      COMMON /CIRDAT/ LOCATE(50),JELCNT(50),NUNODS,NCNODS,NUMNOD,NSTOP,
     1   NUT,NLT,NXTRM,NDIST,NTLIN,IBR,NUMVS,NUMALT,NUMCYC
C SPICE VERSION 2G.6  SCCSID=STATUS 3/15/83
      COMMON /STATUS/ OMEGA,TIME,DELTA,DELOLD(7),AG(7),VT,XNI,EGFET,
     1   XMU,SFACTR,MODE,MODEDC,ICALC,INITF,METHOD,IORD,MAXORD,NONCON,
     2   ITERNO,ITEMNO,NOSOLV,MODAC,IPIV,IVMFLG,IPOSTP,ISCRCH,IOFILE
C SPICE VERSION 2G.6  SCCSID=FLAGS 3/15/83
      COMMON /FLAGS/ IPRNTA,IPRNTL,IPRNTM,IPRNTN,IPRNTO,LIMTIM,LIMPTS,
     1   LVLCOD,LVLTIM,ITL1,ITL2,ITL3,ITL4,ITL5,ITL6,IGOOF,NOGO,KEOF
C SPICE VERSION 2G.6  SCCSID=BLANK 3/15/83
      COMMON /BLANK/ VALUE(200000)
      INTEGER NODPLC(64)
      COMPLEX CVALUE(32)
      EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1))
C
C
      CALL GETM8(LD0,NDIST)
      CALL GETM16(LD1,5*NSTOP)
C
C  BIPOLAR JUNCTION TRANSISTORS
C
      LOC=LOCATE(12)
  100 IF ((LOC.EQ.0).OR.(NODPLC(LOC+36).NE.0)) GO TO 200
      LOCV=NODPLC(LOC+1)
      AREA=VALUE(LOCV+1)
      LOCM=NODPLC(LOC+8)
      LOCM=NODPLC(LOCM+1)
      LOCT=LX0+NODPLC(LOC+22)
      LOCD=LD0+NODPLC(LOC+23)
      CSAT=VALUE(LOCM+1)*AREA
      OVA=VALUE(LOCM+4)
      TF=VALUE(LOCM+24)
      TR=VALUE(LOCM+33)
      CZBE=VALUE(LOCM+21)*AREA
      CZBC=VALUE(LOCM+29)*AREA
      PE=VALUE(LOCM+22)
      XME=VALUE(LOCM+23)
      PC=VALUE(LOCM+30)
      XMC=VALUE(LOCM+31)
      FCPE=VALUE(LOCM+46)
      FCPC=VALUE(LOCM+50)
      VBE=VALUE(LOCT)
      VBC=VALUE(LOCT+1)
      GPI=VALUE(LOCT+4)
      GO=VALUE(LOCT+7)
      GM=VALUE(LOCT+6)
      GMU=VALUE(LOCT+5)
      IF (VBE.GT.0.0D0) GO TO 110
      EVBE=1.0D0
      CBE=CSAT*VBE/VT
      GO TO 120
  110 EVBE=DEXP(VBE/VT)
      CBE=CSAT*(EVBE-1.0D0)
  120 IF (VBC.GT.0.0D0) GO TO 130
      EVBC=1.0D0
      CBC=CSAT*VBC/VT
      ARG=1.0D0-VBC/PC
      GO TO 140
  130 EVBC=DEXP(VBC/VT)
      CBC=CSAT*(EVBC-1.0D0)
  140 IF (VBE.GE.FCPE) GO TO 150
      ARG=1.0D0-VBE/PE
      SARG=DEXP(XME*DLOG(ARG))
      CJEO=CZBE/SARG
      ARGBE=PE-VBE
      CJE1=XME*CJEO/ARGBE
      CJE2=(1.0D0+XME)*CJE1/ARGBE
      GO TO 160
  150 DENOM=DEXP((1.0D0+XME)*DLOG(1.0D0-FCPE))
      CJEO=CZBE*(1.0D0-FCPE*(1.0D0+XME)+XME*VBE/PE)/DENOM
      CJE1=CZBE*XME/(DENOM*PE)
      CJE2=0.0D0
  160 IF (VBC.GE.FCPC) GO TO 170
      ARG=1.0D0-VBC/PC
      SARG=DEXP(XMC*DLOG(ARG))
      CJCO=CZBC/SARG
      ARGBC=PC-VBC
      CJC1=XMC*CJCO/ARGBC
      CJC2=(1.0D0+XMC)*CJC1/ARGBC
      GO TO 180
  170 DENOM=DEXP((1.0D0+XMC)*DLOG(1.0D0-FCPC))
      CJCO=CZBC*(1.0D0-FCPC*(1.0D0+XMC)+XMC*VBC/PC)/DENOM
      CJC1=CZBC*XMC/(DENOM*PC)
      CJC2=0.0D0
  180 TWOVT=VT+VT
      GO2=(-GO+CSAT*(EVBE+EVBC)*OVA)/TWOVT
      GMO2=(CBE+CSAT)*OVA/VT-2.0D0*GO2
      GM2=(GM+GO)/TWOVT-GMO2-GO2
      GMU2=GMU/TWOVT
      IF (VBC.LE.0.0D0) GMU2=0.0D0
      GPI2=GPI/TWOVT
      IF (VBE.LE.0.0D0) GPI2=0.0D0
      CBO=TF*CSAT*EVBE/VT
      CBOR=TR*CSAT*EVBC/VT
      CB1=CBO/VT
      CB1R=CBOR/VT
      TRIVT=3.0D0*VT
      GO3=-(GO2+(CBC+CSAT)*OVA/TWOVT)/TRIVT
      GMO23=-3.0D0*GO3
      GM2O3=-GMO23+(CBE+CSAT)*OVA/(VT*TWOVT)
      GM3=(GM2-(CBE-CBC)*OVA/TWOVT)/TRIVT
      GMU3=GMU2/TRIVT
      GPI3=GPI2/TRIVT
      CB2=CB1/TWOVT
      CB2R=CB1R/TWOVT
      VALUE(LOCD)=CJE1
      VALUE(LOCD+1)=CJE2
      VALUE(LOCD+2)=CJC1
      VALUE(LOCD+3)=CJC2
      VALUE(LOCD+4)=GO2
      VALUE(LOCD+5)=GMO2
      VALUE(LOCD+6)=GM2
      VALUE(LOCD+7)=GMU2
      VALUE(LOCD+8)=GPI2
      VALUE(LOCD+9)=CBO
      VALUE(LOCD+10)=CBOR
      VALUE(LOCD+11)=CB1
      VALUE(LOCD+12)=CB1R
      VALUE(LOCD+13)=GO3
      VALUE(LOCD+14)=GMO23
      VALUE(LOCD+15)=GM2O3
      VALUE(LOCD+16)=GM3
      VALUE(LOCD+17)=GMU3
      VALUE(LOCD+18)=GPI3
      VALUE(LOCD+19)=CB2
      VALUE(LOCD+20)=CB2R
      LOC=NODPLC(LOC)
      GO TO 100
C
C  DIODES
C
  200 LOC=LOCATE(11)
  210 IF ((LOC.EQ.0).OR.(NODPLC(LOC+16).NE.0)) GO TO 300
      LOCV=NODPLC(LOC+1)
      AREA=VALUE(LOCV+1)
      LOCM=NODPLC(LOC+5)
      LOCM=NODPLC(LOCM+1)
      LOCT=LX0+NODPLC(LOC+11)
      LOCD=LD0+NODPLC(LOC+12)
      CSAT=VALUE(LOCM+1)*AREA
      VTE=VALUE(LOCM+3)*VT
      TAU=VALUE(LOCM+4)
      CZERO=VALUE(LOCM+5)*AREA
      PHIB=VALUE(LOCM+6)
      XM=VALUE(LOCM+7)
      FCPB=VALUE(LOCM+12)
      VD=VALUE(LOCT)
      GEQ=VALUE(LOCT+2)
      EVD=1.0D0
      IF (VD.GE.0.0D0) EVD=DEXP(VD/VTE)
      IF (VD.GE.FCPB) GO TO 220
      ARG=1.0D0-VD/PHIB
      SARG=DEXP(XM*DLOG(ARG))
      CDJO=CZERO/SARG
      ARGD=PHIB-VD
      CDJ1=XM*CDJO/ARGD
      CDJ2=(1.0D0+XM)*CDJ1/ARGD
      GO TO 230
  220 DENOM=DEXP((1.0D0+XM)*DLOG(1.0D0-FCPB))
      CDJO=CZERO*(1.0D0-FCPB*(1.0D0+XM)+XM*VD/PHIB)/DENOM
      CDJ1=CZERO*XM/(DENOM*PHIB)
      CDJ2=0.0D0
      CDJ2=0.0D0
  230 CDBO=TAU*CSAT*EVD/VTE
      CDB1=CDBO/VTE
      TWOVTE=2.0D0*VTE
      GEQ2=GEQ/TWOVTE
      IF (VD.LE.0.0D0) GEQ2=0.0D0
      TRIVTE=3.0D0*VTE
      GEQ3=GEQ2/TRIVTE
      CDB2=CDB1/TWOVTE
      VALUE(LOCD)=CDJ1
      VALUE(LOCD+1)=CDJ2
      VALUE(LOCD+2)=CDBO
      VALUE(LOCD+3)=CDB1
      VALUE(LOCD+4)=GEQ2
      VALUE(LOCD+5)=GEQ3
      VALUE(LOCD+6)=CDB2
      LOC=NODPLC(LOC)
      GO TO 210
C
C  FINISHED
C
  300 RETURN
      END
