      SUBROUTINE DISTO(LOCO)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE PERFORMS THE SMALL-SIGNAL DISTORTION ANALYSIS.
C
C SPICE VERSION 2G.6  SCCSID=TABINF 3/15/83
      COMMON /TABINF/ IELMNT,ISBCKT,NSBCKT,IUNSAT,NUNSAT,ITEMPS,NUMTEM,
     1   ISENS,NSENS,IFOUR,NFOUR,IFIELD,ICODE,IDELIM,ICOLUM,INSIZE,
     2   JUNODE,LSBKPT,NUMBKP,IORDER,JMNODE,IUR,IUC,ILC,ILR,NUMOFF,ISR,
     3   NMOFFC,ISEQ,ISEQ1,NEQN,NODEVS,NDIAG,ISWAP,IEQUA,MACINS,LVNIM1,
     4   LX0,LVN,LYNL,LYU,LYL,LX1,LX2,LX3,LX4,LX5,LX6,LX7,LD0,LD1,LTD,
     5   IMYNL,IMVN,LCVN,NSNOD,NSMAT,NSVAL,ICNOD,ICMAT,ICVAL,
     6   LOUTPT,LPOL,LZER,IRSWPF,IRSWPR,ICSWPF,ICSWPR,IRPT,JCPT,
     7   IROWNO,JCOLNO,NTTBR,NTTAR,LVNTMP
C SPICE VERSION 2G.6  SCCSID=MISCEL 3/15/83
      COMMON /MISCEL/ ATIME,APROG(3),ADATE,ATITLE(10),DEFL,DEFW,DEFAD,
     1  DEFAS,RSTATS(50),IWIDTH,LWIDTH,NOPAGE
C SPICE VERSION 2G.6  SCCSID=CIRDAT 3/15/83
      COMMON /CIRDAT/ LOCATE(50),JELCNT(50),NUNODS,NCNODS,NUMNOD,NSTOP,
     1   NUT,NLT,NXTRM,NDIST,NTLIN,IBR,NUMVS,NUMALT,NUMCYC
C SPICE VERSION 2G.6  SCCSID=STATUS 3/15/83
      COMMON /STATUS/ OMEGA,TIME,DELTA,DELOLD(7),AG(7),VT,XNI,EGFET,
     1   XMU,SFACTR,MODE,MODEDC,ICALC,INITF,METHOD,IORD,MAXORD,NONCON,
     2   ITERNO,ITEMNO,NOSOLV,MODAC,IPIV,IVMFLG,IPOSTP,ISCRCH,IOFILE
C SPICE VERSION 2G.6  SCCSID=KNSTNT 3/15/83
      COMMON /KNSTNT/ TWOPI,XLOG2,XLOG10,ROOT2,RAD,BOLTZ,CHARGE,CTOK,
     1   GMIN,RELTOL,ABSTOL,VNTOL,TRTOL,CHGTOL,EPS0,EPSSIL,EPSOX,
     2   PIVTOL,PIVREL
C SPICE VERSION 2G.6  SCCSID=FLAGS 3/15/83
      COMMON /FLAGS/ IPRNTA,IPRNTL,IPRNTM,IPRNTN,IPRNTO,LIMTIM,LIMPTS,
     1   LVLCOD,LVLTIM,ITL1,ITL2,ITL3,ITL4,ITL5,ITL6,IGOOF,NOGO,KEOF
C SPICE VERSION 2G.6  SCCSID=AC 3/15/83
      COMMON /AC/ FSTART,FSTOP,FINCR,SKW2,REFPRL,SPW2,JACFLG,IDFREQ,
     1   INOISE,NOSPRT,NOSOUT,NOSIN,IDIST,IDPRT
C SPICE VERSION 2G.6  SCCSID=BLANK 3/15/83
      COMMON /BLANK/ VALUE(200000)
      INTEGER NODPLC(64)
      COMPLEX CVALUE(32)
      EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1))
C
C
      COMPLEX DIFVN1,DIFVN2,DIFVN3,DIFVI1,DIFVI2,DIFVI3,DSGO2,DSGM2,
     1   DSGMU2,DSGPI2,DSCB1,DSCB1R,DSCJE1,DSCJC1,DISTO1,DISTO2,DISTO3,
     2   DSGMO2,DGM2O3,DGMO23,BEW,CEW,BCW,BE2W,CE2W,BC2W,BEW2,CEW2,
     3   BCW2,BEW12,CEW12,BCW12,DSCDB1,DSCDJ1,DSG2,CVABE,CVABC,CVACE,
     4   CVOUT,CVDIST
      DIMENSION DISTIT(4)
      DIMENSION VDO(2,12)
      COMPLEX CVDO(12)
      REAL VDO
      EQUIVALENCE (CVDO(1),VDO(1,1))
      DATA DISTIT / 8HDISTORTI, 8HON ANALY, 8HSIS     , 8H        /
C
C
      ICVW1=LD1
      ICV2W1=ICVW1+NSTOP
      ICVW2=ICV2W1+NSTOP
      ICVW12=ICVW2+NSTOP
      ICVADJ=ICVW12+NSTOP
      IPRNT=0
      IF (ICALC.GE.2) GO TO 10
      IDNP=NODPLC(IDIST+2)
      IDNN=NODPLC(IDIST+3)
      LOCV=NODPLC(IDIST+1)
      RLOAD=1.0D0/VALUE(LOCV+1)
      KNTR=1
   10 IF (IDPRT.EQ.0) GO TO 30
      IF (KNTR.GT.ICALC) GO TO 30
      IPRNT=1
      KNTR=KNTR+IDPRT
      CALL TITLE(0,LWIDTH,1,DISTIT)
   30 FREQ1=DBLE(REAL(CVALUE(LOCO+1)))
      FREQ2=SKW2*FREQ1
      CALL COPY16(CVALUE(LCVN+1),CVALUE(ICVW1+1),NSTOP)
      CVOUT=CVALUE(ICVW1+IDNP)-CVALUE(ICVW1+IDNN)
      CALL MAGPHS(CVOUT,OMAG,OPHASE)
C
C  BEGIN THE DISTORTION ANALYSIS
C
      DO 1000 KDISTO=1,7
      CVDIST=CMPLX(0.0E0,0.0E0)
      GO TO (1000,110,120,130,140,160,170),KDISTO
  110 FREQD=2.0D0*FREQ1
      ARG=DSQRT(2.0D0*RLOAD*REFPRL)/(OMAG*OMAG)
      IF (IPRNT.EQ.0) GO TO 200
      WRITE (IOFILE,111) FREQ1,FREQD,OMAG,OPHASE
  111 FORMAT (///5X,'2ND HARMONIC DISTORTION',30X,'FREQ1 = ',1PD9.2,
     1   '  HZ'//5X,'DISTORTION FREQUENCY  ',D9.2,'  HZ',16X,
     2   'MAG ',D9.3,3X,'PHS ',0PF7.2)
      GO TO 200
  120 FREQD=3.0D0*FREQ1
      ARG=2.0D0*RLOAD*REFPRL/(OMAG*OMAG*OMAG)
      IF (IPRNT.EQ.0) GO TO 200
      WRITE (IOFILE,121) FREQ1,FREQD,OMAG,OPHASE
  121 FORMAT (1H1,4X,'3RD HARMONIC DISTORTION',30X,'FREQ1 = ',1PD9.2,
     1   '  HZ'//5X,'DISTORTION FREQUENCY  ',D9.2,'  HZ',16X,
     2   'MAG ',D9.3,3X,'PHS ',0PF7.2)
      GO TO 200
  130 FREQD=FREQ2
      GO TO 200
  140 FREQD=FREQ1-FREQ2
      ARG=DSQRT(2.0D0*RLOAD*REFPRL)*SPW2/(OMAG*OMAG)
      IF (IPRNT.EQ.0) GO TO 200
      WRITE (IOFILE,151) FREQ1,FREQ2,FREQD,OMAG,OPHASE,OW2MAG,OW2PHS
  151 FORMAT (1H1,4X,'2ND ORDER INTERMODULATION DIFFERENCE COMPONENT',
     1   7X,'FREQ1 = ',1PD9.2,'  HZ',15X,'FREQ2 = ',D9.2,'  HZ'//
     2   5X,'DISTORTION FREQUENCY  ',D9.2,'  HZ',16X,'MAG ',
     3   D9.3,3X,'PHS ',0PF7.2,9X,'MAG ',1PD9.3,3X,'PHS ',0PF7.2)
      GO TO 200
  160 FREQD=FREQ1+FREQ2
      ARG=DSQRT(2.0D0*RLOAD*REFPRL)*SPW2/(OMAG*OMAG)
      IF (IPRNT.EQ.0) GO TO 200
      WRITE (IOFILE,161) FREQ1,FREQ2,FREQD,OMAG,OPHASE,OW2MAG,OW2PHS
  161 FORMAT (1H1,4X,'2ND ORDER INTERMODULATION SUM COMPONENT',
     1   14X,'FREQ1 = ',1PD9.2,'  HZ',15X,'FREQ2 = ',D9.2,'  HZ'//
     2   5X,'DISTORTION FREQUENCY  ',D9.2,'  HZ',16X,'MAG ',
     3   D9.3,3X,'PHS ',0PF7.2,9X,'MAG ',1PD9.3,3X,'PHS ',0PF7.2)
      GO TO 200
  170 FREQD=2.0D0*FREQ1-FREQ2
      ARG=2.0D0*RLOAD*REFPRL*SPW2/(OMAG*OMAG*OMAG)
      IF (IPRNT.EQ.0) GO TO 200
      WRITE (IOFILE,171) FREQ1,FREQ2,FREQD,OMAG,OPHASE,OW2MAG,OW2PHS
  171 FORMAT (1H1,4X,'3RD ORDER INTERMODULATION DIFFERENCE COMPONENT',
     1   7X,'FREQ1 = ',1PD9.2,'  HZ',15X,'FREQ2 = ',D9.2,'  HZ'//
     2   5X,'DISTORTION FREQUENCY  ',D9.2,'  HZ',16X,'MAG ',
     3   D9.3,3X,'PHS ',0PF7.2,9X,'MAG ',1PD9.3,3X,'PHS ',0PF7.2)
C
C  LOAD AND DECOMPOSE Y MATRIX
C
  200 OMEGA=TWOPI*FREQD
      IGOOF=0
      CALL ACLOAD
      CALL ACDCMP
      IF (IGOOF.EQ.0) GO TO 220
      WRITE (IOFILE,211) IGOOF,FREQD
  211 FORMAT('0WARNING:  UNDERFLOW ',I4,' TIME(S) IN DISTORTION ANALYSIS
     1 AT FREQ = ',1PD9.3,' HZ')
      IGOOF=0
  220 IF (KDISTO.EQ.4) GO TO 710
C
C  OBTAIN ADJOINT SOLUTION
C
      CALL ZERO8(VALUE(LVN+1),NSTOP)
      CALL ZERO8(VALUE(IMVN+1),NSTOP)
      VALUE(LVN+IDNP)=-1.0D0
      VALUE(LVN+IDNN)=+1.0D0
      CALL ACASOL
      CALL COPY16(CVALUE(LCVN+1),CVALUE(ICVADJ+1),NSTOP)
      CALL ZERO8(VALUE(LVN+1),NSTOP)
      CALL ZERO8(VALUE(IMVN+1),NSTOP)
C
C  BJTS
C
      IF (JELCNT(12).EQ.0) GO TO 500
      ITITLE=0
  301 FORMAT (////1X,'BJT DISTORTION COMPONENTS'//1X,'NAME',11X,'GM',
     1   8X,'GPI',7X,'GO',8X,'GMU',6X,'GMO2',7X,'CB',8X,'CBR',7X,'CJE',
     2   7X,'CJC',6X,'TOTAL')
  311 FORMAT (////1X,'BJT DISTORTION COMPONENTS'//1X,'NAME',11X,'GM',
     1   8X,'GPI',7X,'GO',8X,'GMU',6X,'GMO2',7X,'CB',8X,'CBR',7X,'CJE',
     2   7X,'CJC',6X,'GM203',5X,'GMO23',5X,'TOTAL')
  320 LOC=LOCATE(12)
  330 IF ((LOC.EQ.0).OR.(NODPLC(LOC+36).NE.0)) GO TO 500
      LOCV=NODPLC(LOC+1)
      LOCT=LX0+NODPLC(LOC+22)
      LOCD=LD0+NODPLC(LOC+23)
      NODE1=NODPLC(LOC+5)
      NODE2=NODPLC(LOC+6)
      NODE3=NODPLC(LOC+7)
      CJE1=VALUE(LOCD)
      CJE2=VALUE(LOCD+1)
      CJC1=VALUE(LOCD+2)
      CJC2=VALUE(LOCD+3)
      GO2=VALUE(LOCD+4)
      GMO2=VALUE(LOCD+5)
      GM2=VALUE(LOCD+6)
      GMU2=VALUE(LOCD+7)
      GPI2=VALUE(LOCD+8)
      CB1=VALUE(LOCD+11)
      CB1R=VALUE(LOCD+12)
      GO3=VALUE(LOCD+13)
      GMO23=VALUE(LOCD+14)
      GM2O3=VALUE(LOCD+15)
      GM3=VALUE(LOCD+16)
      GMU3=VALUE(LOCD+17)
      GPI3=VALUE(LOCD+18)
      CB2=VALUE(LOCD+19)
      CB2R=VALUE(LOCD+20)
      BEW=CVALUE(ICVW1+NODE2)-CVALUE(ICVW1+NODE3)
      CEW=CVALUE(ICVW1+NODE1)-CVALUE(ICVW1+NODE3)
      BCW=CVALUE(ICVW1+NODE2)-CVALUE(ICVW1+NODE1)
      IF (KDISTO.EQ.2) GO TO 370
      BE2W=CVALUE(ICV2W1+NODE2)-CVALUE(ICV2W1+NODE3)
      CE2W=CVALUE(ICV2W1+NODE1)-CVALUE(ICV2W1+NODE3)
      BC2W=CVALUE(ICV2W1+NODE2)-CVALUE(ICV2W1+NODE1)
      IF (KDISTO.EQ.3) GO TO 380
      BEW2=CVALUE(ICVW2+NODE2)-CVALUE(ICVW2+NODE3)
      CEW2=CVALUE(ICVW2+NODE1)-CVALUE(ICVW2+NODE3)
      BCW2=CVALUE(ICVW2+NODE2)-CVALUE(ICVW2+NODE1)
      IF (KDISTO.EQ.5) GO TO 390
      IF (KDISTO.EQ.6) GO TO 400
      BEW12=CVALUE(ICVW12+NODE2)-CVALUE(ICVW12+NODE3)
      CEW12=CVALUE(ICVW12+NODE1)-CVALUE(ICVW12+NODE3)
      BCW12=CVALUE(ICVW12+NODE2)-CVALUE(ICVW12+NODE1)
      GO TO 410
C
C  CALCULATE HD2 CURRENT GENERATORS
C
  370 DIFVN1=0.5D0*CEW*CEW
      DIFVN2=0.5D0*BEW*BEW
      DIFVN3=0.5D0*BCW*BCW
      DSGMO2=GMO2*0.5D0*BEW*CEW
      GO TO 420
C
C  CALCULATE HD3 CURRENT GENERATORS
C
  380 DIFVI1=0.50D0*CEW*CE2W
      DIFVN1=0.25D0*CEW*CEW*CEW
      DIFVI2=0.50D0*BEW*BE2W
      DIFVN2=0.25D0*BEW*BEW*BEW
      DIFVI3=0.50D0*BCW*BC2W
      DIFVN3=0.25D0*BCW*BCW*BCW
      DSGMO2=GMO2*(BEW*CE2W+BE2W*CEW)*0.5D0
      GO TO 430
C
C  CALCULATE IM2D CURRENT GENERATORS
C
  390 DIFVN1=CEW*CONJG(CEW2)
      DIFVN2=BEW*CONJG(BEW2)
      DIFVN3=BCW*CONJG(BCW2)
      DSGMO2=GMO2*0.5D0*(BEW*CONJG(CEW2)+CEW*CONJG(BEW2))
      GO TO 420
C
C  CALCULATE IM2S CURRENT GENERATORS
C
  400 DIFVN1=CEW*CEW2
      DIFVN2=BEW*BEW2
      DIFVN3=BCW*BCW2
      DSGMO2=GMO2*0.5D0*(BEW*CEW2+BEW2*CEW)
      GO TO 420
C
C  CALCULATE IM3 CURRENT GENERATORS
C
  410 DIFVI1=0.5D0*(CE2W*CONJG(CEW2)+CEW*CEW12)
      DIFVI2=0.5D0*(BE2W*CONJG(BEW2)+BEW*BEW12)
      DIFVI3=0.5D0*(BC2W*CONJG(BCW2)+BCW*BCW12)
      DIFVN1=CEW*CEW*CONJG(CEW2)*0.75D0
      DIFVN2=BEW*BEW*CONJG(BEW2)*0.75D0
      DIFVN3=BCW*BCW*CONJG(BCW2)*0.75D0
      DSGMO2=GMO2*0.5D0*(CONJG(BEW2)*CE2W+BEW*CEW12+CONJG(CEW2)*BE2W+
     1   CEW*BEW12)
      GO TO 430
C
  420 DSGO2=GO2*DIFVN1
      DSGM2=GM2*DIFVN2
      DSGMU2=GMU2*DIFVN3
      DSGPI2=GPI2*DIFVN2
      DSCB1=0.5D0*CB1*OMEGA*CMPLX(-AIMAG(DIFVN2),REAL(DIFVN2))
      DSCB1R=0.5D0*CB1R*OMEGA*CMPLX(-AIMAG(DIFVN3),REAL(DIFVN3))
      DSCJE1=0.5D0*CJE1*OMEGA*CMPLX(-AIMAG(DIFVN2),REAL(DIFVN2))
      DSCJC1=0.5D0*CJC1*OMEGA*CMPLX(-AIMAG(DIFVN3),REAL(DIFVN3))
      GO TO 440
C
  430 DSGO2=2.0D0*GO2*DIFVI1+GO3*DIFVN1
      DSGM2=2.0D0*GM2*DIFVI2+GM3*DIFVN2
      DSGMU2=2.0D0*GMU2*DIFVI3+GMU3*DIFVN3
      DSGPI2=2.0D0*GPI2*DIFVI2+GPI3*DIFVN2
      DSCB1=OMEGA*(CB1*DIFVI2+CB2*DIFVN2/3.0D0)
      DSCB1=CMPLX(-AIMAG(DSCB1),REAL(DSCB1))
      DSCB1R=OMEGA*(CB1R*DIFVI3+CB2R*DIFVN3/3.0D0)
      DSCB1R=CMPLX(-AIMAG(DSCB1R),REAL(DSCB1R))
      DSCJE1=OMEGA*(CJE1*DIFVI2+CJE2*DIFVN2/3.0D0)
      DSCJE1=CMPLX(-AIMAG(DSCJE1),REAL(DSCJE1))
      DSCJC1=OMEGA*(CJC1*DIFVI3+CJC2*DIFVN3/3.0D0)
      DSCJC1=CMPLX(-AIMAG(DSCJC1),REAL(DSCJC1))
C
C  DETERMINE CONTRIBUTION OF EACH DISTORTION SOURCE
C
  440 CVABE=CVALUE(ICVADJ+NODE2)-CVALUE(ICVADJ+NODE3)
      CVABC=CVALUE(ICVADJ+NODE2)-CVALUE(ICVADJ+NODE1)
      CVACE=CVALUE(ICVADJ+NODE1)-CVALUE(ICVADJ+NODE3)
      DISTO1=DSGM2+DSGO2+DSGMO2
      DISTO2=DSGPI2+DSCB1+DSCJE1
      DISTO3=DSGMU2+DSCB1R+DSCJC1
      CVDO(1)=DSGM2*CVACE*ARG
      CVDO(2)=DSGPI2*CVABE*ARG
      CVDO(3)=DSGO2*CVACE*ARG
      CVDO(4)=DSGMU2*CVABC*ARG
      CVDO(5)=DSGMO2*CVACE*ARG
      CVDO(6)=DSCB1*CVABE*ARG
      CVDO(7)=DSCB1R*CVABC*ARG
      CVDO(8)=DSCJE1*CVABE*ARG
      CVDO(9)=DSCJC1*CVABC*ARG
      IF (KDISTO.EQ.3) GO TO 450
      IF (KDISTO.EQ.7) GO TO 460
      CVDO(10)=CVDO(1)+CVDO(2)+CVDO(3)+CVDO(4)+CVDO(5)+CVDO(6)+CVDO(7)+
     1   CVDO(8)+CVDO(9)
      CVDIST=CVDIST+CVDO(10)
      IF (IPRNT.EQ.0) GO TO 480
      DO 445 J=1,10
      CALL MAGPHS(CVDO(J),XMAG,XPHS)
      CVDO(J)=CMPLX(SNGL(XMAG),SNGL(XPHS))
  445 CONTINUE
      IF (ITITLE.EQ.0) WRITE (IOFILE,301)
      ITITLE=1
      WRITE (IOFILE,446) VALUE(LOCV),(VDO(1,J),J=1,10)
  446 FORMAT(1H0,A8,'MAG',1P12D10.3)
      WRITE (IOFILE,447) (VDO(2,J),J=1,10)
  447 FORMAT(9X,'PHS',12(1X,F7.2,2X))
      GO TO 480
  450 DGM2O3=GM2O3*CEW*BEW*BEW*0.25D0
      DGMO23=GMO23*BEW*CEW*CEW*0.25D0
      GO TO 470
  460 DGM2O3=GM2O3*(0.5D0*BEW*CONJG(BEW2)*CEW+0.25D0*BEW*BEW*
     1  CONJG(CEW2))
      DGMO23=GMO23*(0.5D0*CEW*CONJG(CEW2)*BEW+0.25D0*CEW*CEW*
     1  CONJG(BEW2))
  470 DISTO1=DISTO1+DGM2O3+DGMO23
      CVDO(10)=DGM2O3*CVACE*ARG
      CVDO(11)=DGMO23*CVACE*ARG
      CVDO(12)=CVDO(1)+CVDO(2)+CVDO(3)+CVDO(4)+CVDO(5)+CVDO(6)+CVDO(7)+
     1   CVDO(8)+CVDO(9)+CVDO(10)+CVDO(11)
      CVDIST=CVDIST+CVDO(12)
      IF (IPRNT.EQ.0) GO TO 480
      DO 475 J=1,12
      CALL MAGPHS(CVDO(J),XMAG,XPHS)
      CVDO(J)=CMPLX(SNGL(XMAG),SNGL(XPHS))
  475 CONTINUE
      IF (ITITLE.EQ.0) WRITE (IOFILE,311)
      ITITLE=1
      WRITE (IOFILE,446) VALUE(LOCV),(VDO(1,J),J=1,12)
      WRITE (IOFILE,447) (VDO(2,J),J=1,12)
  480 VALUE(LVN+NODE1)=VALUE(LVN+NODE1)
     1  -REAL(DISTO1-DISTO3)
      VALUE(LVN+NODE2)=VALUE(LVN+NODE2)
     1  -REAL(DISTO2+DISTO3)
      VALUE(LVN+NODE3)=VALUE(LVN+NODE3)
     1  +REAL(DISTO1+DISTO2)
      VALUE(IMVN+NODE1)=VALUE(IMVN+NODE1)
     1  -AIMAG(DISTO1-DISTO3)
      VALUE(IMVN+NODE2)=VALUE(IMVN+NODE2)
     1  -AIMAG(DISTO2+DISTO3)
      VALUE(IMVN+NODE3)=VALUE(IMVN+NODE3)
     1  +AIMAG(DISTO1+DISTO2)
      LOC=NODPLC(LOC)
      GO TO 330
C
C   JUNCTION DIODES
C
  500 IF (JELCNT(11).EQ.0) GO TO 700
      ITITLE=0
  501 FORMAT (////1X,'DIODE DISTORTION COMPONENTS'//1X,'NAME',
     1   11X,'GEQ',7X,'CB',8X,'CJ',7X,'TOTAL')
  510 LOC=LOCATE(11)
  520 IF ((LOC.EQ.0).OR.(NODPLC(LOC+16).NE.0)) GO TO 700
      LOCV=NODPLC(LOC+1)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      NODE3=NODPLC(LOC+4)
      LOCM=NODPLC(LOC+5)
      LOCM=NODPLC(LOCM+1)
      LOCT=LX0+NODPLC(LOC+11)
      LOCD=LD0+NODPLC(LOC+12)
      CDJ1=VALUE(LOCD)
      CDJ2=VALUE(LOCD+1)
      CDB1=VALUE(LOCD+3)
      GEQ2=VALUE(LOCD+4)
      GEQ3=VALUE(LOCD+5)
      CDB2=VALUE(LOCD+6)
      BEW=CVALUE(ICVW1+NODE3)-CVALUE(ICVW1+NODE2)
      IF (KDISTO.EQ.2) GO TO 540
      BE2W=CVALUE(ICV2W1+NODE3)-CVALUE(ICV2W1+NODE2)
      IF (KDISTO.EQ.3) GO TO 550
      BEW2=CVALUE(ICVW2+NODE3)-CVALUE(ICVW2+NODE2)
      IF (KDISTO.EQ.5) GO TO 560
      IF (KDISTO.EQ.6) GO TO 570
      BEW12=CVALUE(ICVW12+NODE3)-CVALUE(ICVW12+NODE2)
      GO TO 580
C
C    CALCULATE HD2 CURRENT GENERATORS
C
  540 DIFVN1=0.5D0*BEW*BEW
      GO TO 590
C
C    CALCULATE HD3 CURRENT GENERATORS
C
  550 DIFVI1=0.5D0*BEW*BE2W
      DIFVN1=0.25D0*BEW*BEW*BEW
      GO TO 600
C
C    CALCULATE IM2D CURRENT GENERATORS
C
  560 DIFVN1=BEW*CONJG(BEW2)
      GO TO 590
C
C    CALCULATE IM2S CURRENT GENERATORS
C
  570 DIFVN1=BEW*BEW2
      GO TO 590
C
C    CALCULATE IM3 CURRENT GENERATORS
C
  580 DIFVI1=0.5D0*(BE2W*CONJG(BEW2)+BEW*BEW12)
      DIFVN1=BEW*BEW*CONJG(BEW2)*0.75D0
      GO TO 600
  590 DSG2=GEQ2*DIFVN1
      DSCDB1=0.5D0*CDB1*OMEGA*CMPLX(-AIMAG(DIFVN1),REAL(DIFVN1))
      DSCDJ1=0.5D0*CDJ1*OMEGA*CMPLX(-AIMAG(DIFVN1),REAL(DIFVN1))
      GO TO 610
C
  600 DSG2=2.0D0*GEQ2*DIFVI1+GEQ3*DIFVN1
      DSCDB1=OMEGA*(CDB1*DIFVI1+CDB2*DIFVN1/3.0D0)
      DSCDB1=CMPLX(-AIMAG(DSCDB1),REAL(DSCDB1))
      DSCDJ1=OMEGA*(CDJ1*DIFVI1+CDJ2*DIFVN1/3.0D0)
      DSCDJ1=CMPLX(-AIMAG(DSCDJ1),REAL(DSCDJ1))
C
C  DETERMINE CONTRIBUTION OF EACH DISTORTION SOURCE
C
  610 CVABE=CVALUE(ICVADJ+NODE3)-CVALUE(ICVADJ+NODE2)
      DISTO1=DSG2+DSCDB1+DSCDJ1
      CVDO(1)=DSG2*CVABE*ARG
      CVDO(2)=DSCDB1*CVABE*ARG
      CVDO(3)=DSCDJ1*CVABE*ARG
      CVDO(4)=CVDO(1)+CVDO(2)+CVDO(3)
      CVDIST=CVDIST+CVDO(4)
      IF (IPRNT.EQ.0) GO TO 680
      DO 670 J=1,4
      CALL MAGPHS(CVDO(J),XMAG,XPHS)
      CVDO(J)=CMPLX(SNGL(XMAG),SNGL(XPHS))
  670 CONTINUE
      IF (ITITLE.EQ.0) WRITE (IOFILE,501)
      ITITLE=1
      WRITE (IOFILE,446) VALUE(LOCV),(VDO(1,J),J=1,4)
      WRITE (IOFILE,447) (VDO(2,J),J=1,4)
  680 VALUE(LVN+NODE2)=VALUE(LVN+NODE2)+REAL(DISTO1)
      VALUE(LVN+NODE3)=VALUE(LVN+NODE3)-REAL(DISTO1)
      VALUE(IMVN+NODE2)=VALUE(IMVN+NODE2)+AIMAG(DISTO1)
      VALUE(IMVN+NODE3)=VALUE(IMVN+NODE3)-AIMAG(DISTO1)
      LOC=NODPLC(LOC)
      GO TO 520
C
C  OBTAIN TOTAL DISTORTION SOLUTION IF NECESSARY
C
  700 GO TO (1000,710,790,710,710,840,860),KDISTO
  710 CALL ACSOL
C
C  STORE SOLUTION, PRINT AND STORE ANSWERS
C
  760 GO TO (1000,770,790,800,820,840,860),KDISTO
  770 CALL COPY16(CVALUE(LCVN+1),CVALUE(ICV2W1+1),NSTOP)
      CALL MAGPHS(CVDIST,O2MAG,O2PHS)
      IF (IPRNT.EQ.0) GO TO 900
      O2LOG=20.0D0*DLOG10(O2MAG)
      WRITE (IOFILE,781) O2MAG,O2PHS,O2LOG
  781 FORMAT (///5X,'HD2     MAGNITUDE  ',1PD10.3,5X,'PHASE  ',0PF7.2,
     1   5X,'=  ',F7.2,'  DB')
      GO TO 900
  790 CALL MAGPHS(CVDIST,O3MAG,O3PHS)
      IF (IPRNT.EQ.0) GO TO 900
      O3LOG=20.0D0*DLOG10(O3MAG)
      WRITE (IOFILE,791) O3MAG,O3PHS,O3LOG
  791 FORMAT (///5X,'HD3     MAGNITUDE  ',1PD10.3,5X,'PHASE  ',0PF7.2,
     1   5X,'=  ',F7.2,'  DB')
      GO TO 900
  800 CALL COPY16(CVALUE(LCVN+1),CVALUE(ICVW2+1),NSTOP)
      CVOUT=CVALUE(ICVW2+IDNP)-CVALUE(ICVW2+IDNN)
      CALL MAGPHS(CVOUT,OW2MAG,OW2PHS)
      GO TO 1000
  820 CALL COPY16(CVALUE(LCVN+1),CVALUE(ICVW12+1),NSTOP)
  840 CALL MAGPHS(CVDIST,O12MAG,O12PHS)
      IF (IPRNT.EQ.0) GO TO 900
      O12LOG=20.0D0*DLOG10(O12MAG)
      IF (KDISTO.EQ.6) GO TO 850
      WRITE (IOFILE,841) O12MAG,O12PHS,O12LOG
  841 FORMAT (///5X,'IM2D    MAGNITUDE  ',1PD10.3,5X,'PHASE  ',0PF7.2,
     1   5X,'=  ',F7.2,'  DB')
      GO TO 900
  850 WRITE (IOFILE,851) O12MAG,O12PHS,O12LOG
  851 FORMAT (///5X,'IM2S    MAGNITUDE  ',1PD10.3,5X,'PHASE  ',0PF7.2,
     1   5X,'=  ',F7.2,'  DB')
      GO TO 900
  860 CALL MAGPHS(CVDIST,O21MAG,O21PHS)
      IF (IPRNT.EQ.0) GO TO 900
      O21LOG=20.0D0*DLOG10(O21MAG)
      WRITE (IOFILE,861) O21MAG,O21PHS,O21LOG
  861 FORMAT (///5X,'IM3     MAGNITUDE  ',1PD10.3,5X,'PHASE  ',0PF7.2,
     1   5X,'=  ',F7.2,'  DB')
      CMA=DABS(4.0D0*O21MAG*DCOS((O21PHS-OPHASE)/RAD))
      CMA=DMAX1(CMA,1.0D-20)
      CMP=DABS(4.0D0*O21MAG*DSIN((O21PHS-OPHASE)/RAD))
      CMP=DMAX1(CMP,1.0D-20)
      CMALOG=20.0D0*DLOG10(CMA)
      CMPLOG=20.0D0*DLOG10(CMP)
      WRITE (IOFILE,866)
  866 FORMAT (////5X,'APPROXIMATE CROSS MODULATION COMPONENTS')
      WRITE (IOFILE,871) CMA,CMALOG
  871 FORMAT (/5X,'CMA     MAGNITUDE  ',1PD10.3,24X,'=  ',0PF7.2,'  DB')
      WRITE (IOFILE,881) CMP,CMPLOG
  881 FORMAT (/5X,'CMP     MAGNITUDE  ',1PD10.3,24X,'=  ',0PF7.2,'  DB')
C
C  SAVE DISTORTION OUTPUTS
C
  900 IFLAG=KDISTO+2
      IF (IFLAG.GE.7) IFLAG=IFLAG-1
      LOC=LOCATE(45)
  910 IF (LOC.EQ.0) GO TO 1000
      IF (NODPLC(LOC+5).NE.IFLAG) GO TO 920
      ISEQ=NODPLC(LOC+4)
      CVALUE(LOCO+ISEQ)=CVDIST
  920 LOC=NODPLC(LOC)
      GO TO 910
 1000 CONTINUE
C
C  FINISHED
C
 2000 RETURN
      END
