      SUBROUTINE ELPRNT
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE PRINTS A CIRCUIT ELEMENT SUMMARY.
C
C SPICE VERSION 2G.6  SCCSID=TABINF 3/15/83
      COMMON /TABINF/ IELMNT,ISBCKT,NSBCKT,IUNSAT,NUNSAT,ITEMPS,NUMTEM,
     1   ISENS,NSENS,IFOUR,NFOUR,IFIELD,ICODE,IDELIM,ICOLUM,INSIZE,
     2   JUNODE,LSBKPT,NUMBKP,IORDER,JMNODE,IUR,IUC,ILC,ILR,NUMOFF,ISR,
     3   NMOFFC,ISEQ,ISEQ1,NEQN,NODEVS,NDIAG,ISWAP,IEQUA,MACINS,LVNIM1,
     4   LX0,LVN,LYNL,LYU,LYL,LX1,LX2,LX3,LX4,LX5,LX6,LX7,LD0,LD1,LTD,
     5   IMYNL,IMVN,LCVN,NSNOD,NSMAT,NSVAL,ICNOD,ICMAT,ICVAL,
     6   LOUTPT,LPOL,LZER,IRSWPF,IRSWPR,ICSWPF,ICSWPR,IRPT,JCPT,
     7   IROWNO,JCOLNO,NTTBR,NTTAR,LVNTMP
C SPICE VERSION 2G.6  SCCSID=MISCEL 3/15/83
      COMMON /MISCEL/ ATIME,APROG(3),ADATE,ATITLE(10),DEFL,DEFW,DEFAD,
     1  DEFAS,RSTATS(50),IWIDTH,LWIDTH,NOPAGE
C SPICE VERSION 2G.6  SCCSID=CIRDAT 3/15/83
      COMMON /CIRDAT/ LOCATE(50),JELCNT(50),NUNODS,NCNODS,NUMNOD,NSTOP,
     1   NUT,NLT,NXTRM,NDIST,NTLIN,IBR,NUMVS,NUMALT,NUMCYC
C SPICE VERSION 2G.6  SCCSID=FLAGS 3/15/83
      COMMON /FLAGS/ IPRNTA,IPRNTL,IPRNTM,IPRNTN,IPRNTO,LIMTIM,LIMPTS,
     1   LVLCOD,LVLTIM,ITL1,ITL2,ITL3,ITL4,ITL5,ITL6,IGOOF,NOGO,KEOF
C SPICE VERSION 2G.6  SCCSID=TRAN 3/15/83
      COMMON /TRAN/ TSTEP,TSTOP,TSTART,DELMAX,TDMAX,FORFRE,JTRFLG
C SPICE VERSION 2G.6  SCCSID=BLANK 3/15/83
      COMMON /BLANK/ VALUE(200000)
C SPICE VERSION 2G.6  SCCSID=STATUS 3/15/83
      COMMON /STATUS/ OMEGA,TIME,DELTA,DELOLD(7),AG(7),VT,XNI,EGFET,
     1   XMU,SFACTR,MODE,MODEDC,ICALC,INITF,METHOD,IORD,MAXORD,NONCON,
     2   ITERNO,ITEMNO,NOSOLV,MODAC,IPIV,IVMFLG,IPOSTP,ISCRCH,IOFILE
      INTEGER NODPLC(64)
      COMPLEX CVALUE(32)
      EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1))
C
C
      DIMENSION ITAB(25),ASTYP(6)
      DIMENSION ELTITL(4)
      DATA ELTITL / 8HCIRCUIT , 8HELEMENT , 8HSUMMARY , 8H         /
      DATA ASTYP / 1H , 5HPULSE, 3HSIN, 3HEXP, 3HPWL, 4HSFFM /
      DATA ABLNK,AOFF /1H ,3HOFF/
C
C  PRINT LISTING OF ELEMENTS
C
      CALL TITLE(0,LWIDTH,1,ELTITL)
C
C  PRINT RESISTORS
C
      IF (JELCNT(1).EQ.0) GO TO 50
      ITITLE=0
   21 FORMAT(//'0**** RESISTORS'/'0     NAME        NODES     VALUE
     1  TC1        TC2'//)
      LOC=LOCATE(1)
   30 IF ((LOC.EQ.0).OR.(NODPLC(LOC+8).NE.0)) GO TO 50
      IF (ITITLE.EQ.0) WRITE (IOFILE,21)
      ITITLE=1
      LOCV=NODPLC(LOC+1)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      WRITE (IOFILE,31) VALUE(LOCV),NODPLC(JUNODE+NODE1),
     1   NODPLC(JUNODE+NODE2),VALUE(LOCV+2),VALUE(LOCV+3),VALUE(LOCV+4)
   31 FORMAT(6X,A8,2I5,1P3D11.2)
   40 LOC=NODPLC(LOC)
      GO TO 30
C
C  PRINT CAPACITORS AND INDUCTORS
C
   50 IF ((JELCNT(2)+JELCNT(3)).EQ.0) GO TO 80
      ITITLE=0
   51 FORMAT(//'0**** CAPACITORS AND INDUCTORS'/'0     NAME        NODES
     1    IN COND     VALUE'//)
      DO 70 ID=2,3
      LOC=LOCATE(ID)
   60 IF (LOC.EQ.0) GO TO 70
      IF ((ID.EQ.2).AND.(NODPLC(LOC+12).NE.0)) GO TO 70
      IF ((ID.EQ.3).AND.(NODPLC(LOC+14).NE.0)) GO TO 70
      IF (ITITLE.EQ.0) WRITE (IOFILE,51)
      ITITLE=1
      LOCV=NODPLC(LOC+1)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      IF (NODPLC(LOC+4).NE.1) GO TO 62
      WRITE (IOFILE,31) VALUE(LOCV),NODPLC(JUNODE+NODE1),
     1   NODPLC(JUNODE+NODE2),VALUE(LOCV+2),VALUE(LOCV+1)
      GO TO 65
   62 LTAB=7
      IF (ID.EQ.3) LTAB=10
      CALL SIZMEM(NODPLC(LOC+LTAB),NPARAM)
      ISPOT=NODPLC(LOC+LTAB)+1
      WRITE (IOFILE,63) VALUE(LOCV),NODPLC(JUNODE+NODE1),
     1   NODPLC(JUNODE+NODE2),VALUE(LOCV+2)
   63 FORMAT(6X,A8,2I5,1PD11.2,'   VARIABLE')
   65 LOC=NODPLC(LOC)
      GO TO 60
   70 CONTINUE
C
C  PRINT MUTUAL INDUCTORS
C
   80 IF (JELCNT(4).EQ.0) GO TO 100
      ITITLE=0
   81 FORMAT(//'0**** MUTUAL INDUCTORS'/'0     NAME        COUPLED INDUC
     1TORS   VALUE'//)
      LOC=LOCATE(4)
   90 IF ((LOC.EQ.0).OR.(NODPLC(LOC+6).NE.0)) GO TO 110
      IF (ITITLE.EQ.0) WRITE (IOFILE,81)
      ITITLE=1
      LOCV=NODPLC(LOC+1)
      NL1=NODPLC(LOC+2)
      NL1=NODPLC(NL1+1)
      NL2=NODPLC(LOC+3)
      NL2=NODPLC(NL2+1)
      WRITE (IOFILE,91) VALUE(LOCV),VALUE(NL1),VALUE(NL2),VALUE(LOCV+1)
   91 FORMAT(6X,A8,4X,A8,2X,A8,1PD10.2)
   95 LOC=NODPLC(LOC)
      GO TO 90
C
C  PRINT NONLINEAR VOLTAGE CONTROLLED SOURCES
C
  100 IF (JELCNT(5).EQ.0) GO TO 120
      ITITLE=0
  101 FORMAT(//'0**** VOLTAGE-CONTROLLED CURRENT SOURCES'/'0     NAME
     1     +    -   DIMENSION   FUNCTION')
      LOC=LOCATE(5)
  110 IF ((LOC.EQ.0).OR.(NODPLC(LOC+13).NE.0)) GO TO 120
      IF (ITITLE.EQ.0) WRITE (IOFILE,101)
      ITITLE=1
      LOCV=NODPLC(LOC+1)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      WRITE (IOFILE,111) VALUE(LOCV),NODPLC(JUNODE+NODE1),
     1   NODPLC(JUNODE+NODE2),NODPLC(LOC+4)
  111 FORMAT(6X,A8,2I5,I8,9X,'POLY')
  115 LOC=NODPLC(LOC)
      GO TO 110
C
C  NONLINEAR VOLTAGE CONTROLLED VOLTAGE SOURCES
C
  120 IF (JELCNT(6).EQ.0) GO TO 140
      ITITLE=0
  121 FORMAT(//'0**** VOLTAGE-CONTROLLED VOLTAGE SOURCES'/'0     NAME
     1     +    -   DIMENSION   FUNCTION')
      LOC=LOCATE(6)
  130 IF ((LOC.EQ.0).OR.(NODPLC(LOC+14).NE.0)) GO TO 140
      IF (ITITLE.EQ.0) WRITE (IOFILE,121)
      ITITLE=1
      LOCV=NODPLC(LOC+1)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      WRITE (IOFILE,111) VALUE(LOCV),NODPLC(JUNODE+NODE1),
     1   NODPLC(JUNODE+NODE2),NODPLC(LOC+4)
  135 LOC=NODPLC(LOC)
      GO TO 130
C
C  NONLINEAR CURRENT CONTROLLED CURRENT SOURCES
C
  140 IF (JELCNT(7).EQ.0) GO TO 160
      ITITLE=0
  141 FORMAT(//'0**** CURRENT-CONTROLLED CURRENT SOURCES'/'0     NAME
     1     +    -   DIMENSION   FUNCTION')
      LOC=LOCATE(7)
  150 IF ((LOC.EQ.0).OR.(NODPLC(LOC+13).NE.0)) GO TO 160
      IF (ITITLE.EQ.0) WRITE (IOFILE,141)
      ITITLE=1
      LOCV=NODPLC(LOC+1)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      WRITE (IOFILE,111) VALUE(LOCV),NODPLC(JUNODE+NODE1),
     1   NODPLC(JUNODE+NODE2),NODPLC(LOC+4)
  155 LOC=NODPLC(LOC)
      GO TO 150
C
C  NONLINEAR CURRENT CONTROLLED VOLTAGE SOURCES
C
  160 IF (JELCNT(8).EQ.0) GO TO 170
      ITITLE=0
  161 FORMAT(//'0**** CURRENT-CONTROLLED VOLTAGE SOURCES'/'0     NAME
     1     +    -   DIMENSION   FUNCTION')
      LOC=LOCATE(8)
  165 IF ((LOC.EQ.0).OR.(NODPLC(LOC+14).NE.0)) GO TO 170
      IF (ITITLE.EQ.0) WRITE (IOFILE,161)
      ITITLE=1
      LOCV=NODPLC(LOC+1)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      WRITE (IOFILE,111) VALUE(LOCV),NODPLC(JUNODE+NODE1),
     1   NODPLC(JUNODE+NODE2),NODPLC(LOC+4)
  167 LOC=NODPLC(LOC)
      GO TO 165
C
C  PRINT INDEPENDENT SOURCES
C
  170 IF ((JELCNT(9)+JELCNT(10)).EQ.0) GO TO 250
      ITITLE=0
  171 FORMAT(//'0**** INDEPENDENT SOURCES'/'0     NAME        NODES   DC
     1 VALUE   AC VALUE   AC PHASE   TRANSIENT'//)
      DO 245 ID=9,10
      LOC=LOCATE(ID)
  180 IF (LOC.EQ.0) GO TO 245
      IF ((ID.EQ.9).AND.(NODPLC(LOC+11).NE.0)) GO TO 245
      IF ((ID.EQ.10).AND.(NODPLC(LOC+6).NE.0)) GO TO 245
      IF (ITITLE.EQ.0) WRITE (IOFILE,171)
      ITITLE=1
      LOCV=NODPLC(LOC+1)
      LOCP=NODPLC(LOC+5)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      ITYPE=NODPLC(LOC+4)+1
      ANAM=ASTYP(ITYPE)
      WRITE (IOFILE,181) VALUE(LOCV),NODPLC(JUNODE+NODE1),
     1   NODPLC(JUNODE+NODE2),VALUE(LOCV+1),VALUE(LOCV+2),
     2   VALUE(LOCV+3),ANAM
  181 FORMAT(6X,A8,2I5,1P3D11.2,2X,A8)
      IF (JTRFLG.EQ.0) GO TO 240
      JSTART=LOCP+1
      GO TO (240,190,200,210,220,230), ITYPE
  190 JSTOP=LOCP+7
      WRITE (IOFILE,191) (VALUE(J),J=JSTART,JSTOP)
  191 FORMAT(1H0,42X,'INITIAL VALUE',1PD11.2,/,
     1           43X,'PULSED VALUE.',  D11.2,/,
     2           43X,'DELAY TIME...',  D11.2,/,
     3           43X,'RISETIME.....',  D11.2,/,
     4           43X,'FALLTIME.....',  D11.2,/,
     5           43X,'WIDTH........',  D11.2,/,
     6           43X,'PERIOD.......',  D11.2,/)
      GO TO 240
  200 JSTOP=LOCP+5
      WRITE (IOFILE,201) (VALUE(J),J=JSTART,JSTOP)
  201 FORMAT(1H0,42X,'OFFSET.......',1PD11.2,/,
     1           43X,'AMPLITUDE....',  D11.2,/,
     2           43X,'FREQUENCY....',  D11.2,/,
     3           43X,'DELAY........',  D11.2,/,
     4           43X,'THETA........',  D11.2,/)
      GO TO 240
  210 JSTOP=LOCP+6
      WRITE (IOFILE,211) (VALUE(J),J=JSTART,JSTOP)
  211 FORMAT(1H0,42X,'INITIAL VALUE',1PD11.2,/,
     1           43X,'PULSED VALUE.',  D11.2,/,
     2           43X,'RISE DELAY...',  D11.2,/,
     3           43X,'RISE TAU.....',  D11.2,/,
     4           43X,'FALL DELAY...',  D11.2,/,
     5           43X,'FALL TAU.....',  D11.2,/)
      GO TO 240
  220 CALL SIZMEM(NODPLC(LOC+5),JSTOP)
      JSTOP=LOCP+JSTOP
      WRITE (IOFILE,221) (VALUE(J),J=JSTART,JSTOP)
  221 FORMAT(1H0,49X,'TIME       VALUE'//,(46X,1P2D11.2))
      WRITE (IOFILE,226)
  226 FORMAT(1X)
      GO TO 240
  230 JSTOP=LOCP+5
      WRITE (IOFILE,231) (VALUE(J),J=JSTART,JSTOP)
  231 FORMAT(1H0,42X,'OFFSET.......',1PD11.2,/,
     1           43X,'AMPLITUDE....',  D11.2,/,
     2           43X,'CARRIER FREQ.',  D11.2,/,
     3           43X,'MODN INDEX...',  D11.2,/,
     4           43X,'SIGNAL FREQ..',  D11.2,/)
  240 LOC=NODPLC(LOC)
      GO TO 180
  245 CONTINUE
C
C  PRINT TRANSMISSION LINES
C
  250 IF (JELCNT(17).EQ.0) GO TO 260
      ITITLE=0
  251 FORMAT(//'0**** TRANSMISSION LINES'/'0     NAME             NODES
     1           Z0         TD'//)
      LOC=LOCATE(17)
  253 IF ((LOC.EQ.0).OR.(NODPLC(LOC+33).NE.0)) GO TO 260
      IF (ITITLE.EQ.0) WRITE (IOFILE,251)
      ITITLE=1
      LOCV=NODPLC(LOC+1)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      NODE3=NODPLC(LOC+4)
      NODE4=NODPLC(LOC+5)
      WRITE (IOFILE,256) VALUE(LOCV),NODPLC(JUNODE+NODE1),
     1   NODPLC(JUNODE+NODE2),NODPLC(JUNODE+NODE3),
     2   NODPLC(JUNODE+NODE4),VALUE(LOCV+1),VALUE(LOCV+2)
  256 FORMAT(6X,A8,4I5,1P2D11.2)
  258 LOC=NODPLC(LOC)
      GO TO 253
C
C  PRINT DIODES
C
  260 IF (JELCNT(11).EQ.0) GO TO 290
      ITITLE=0
  261 FORMAT(//'0**** DIODES'/'0     NAME        +    -  MODEL       ARE
     1A'//)
      LOC=LOCATE(11)
  270 IF ((LOC.EQ.0).OR.(NODPLC(LOC+16).NE.0)) GO TO 290
      IF (ITITLE.EQ.0) WRITE (IOFILE,261)
      ITITLE=1
      LOCV=NODPLC(LOC+1)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      LOCM=NODPLC(LOC+5)
      LOCM=NODPLC(LOCM+1)
      AIC=ABLNK
      IF (NODPLC(LOC+6).EQ.1) AIC=AOFF
      WRITE (IOFILE,271) VALUE(LOCV),NODPLC(JUNODE+NODE1),
     1   NODPLC(JUNODE+NODE2),VALUE(LOCM),VALUE(LOCV+1),AIC
  271 FORMAT(6X,A8,2I5,2X,A8,F8.3,2X,A8)
  280 LOC=NODPLC(LOC)
      GO TO 270
C
C  PRINT TRANSISTORS
C
  290 IF (JELCNT(12).EQ.0) GO TO 320
      ITITLE=0
  291 FORMAT(//'0**** BIPOLAR JUNCTION TRANSISTORS'/'0     NAME        C
     1    B    E    S  MODEL       AREA'//)
      LOC=LOCATE(12)
  300 IF ((LOC.EQ.0).OR.(NODPLC(LOC+36).NE.0)) GO TO 320
      IF (ITITLE.EQ.0) WRITE (IOFILE,291)
      ITITLE=1
      LOCV=NODPLC(LOC+1)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      NODE3=NODPLC(LOC+4)
      NODE4=NODPLC(LOC+5)
      LOCM=NODPLC(LOC+8)
      LOCM=NODPLC(LOCM+1)
      AIC=ABLNK
      IF (NODPLC(LOC+9).EQ.1) AIC=AOFF
      WRITE (IOFILE,301) VALUE(LOCV),NODPLC(JUNODE+NODE1),
     1   NODPLC(JUNODE+NODE2),NODPLC(JUNODE+NODE3),NODPLC(JUNODE+NODE4),
     2   VALUE(LOCM),VALUE(LOCV+1),AIC
  301 FORMAT(6X,A8,4I5,2X,A8,F8.3,2X,A8)
  310 LOC=NODPLC(LOC)
      GO TO 300
C
C  PRINT JFETS
C
  320 IF (JELCNT(13).EQ.0) GO TO 350
      ITITLE=0
  321 FORMAT(//'0**** JFETS'/'0     NAME        D    G    S  MODEL
     1 AREA'//)
      LOC=LOCATE(13)
  330 IF ((LOC.EQ.0).OR.(NODPLC(LOC+25).NE.0)) GO TO 350
      IF (ITITLE.EQ.0) WRITE (IOFILE,321)
      ITITLE=1
      LOCV=NODPLC(LOC+1)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      NODE3=NODPLC(LOC+4)
      LOCM=NODPLC(LOC+7)
      LOCM=NODPLC(LOCM+1)
      AIC=ABLNK
      IF (NODPLC(LOC+8).EQ.1) AIC=AOFF
      WRITE (IOFILE,331) VALUE(LOCV),NODPLC(JUNODE+NODE1),
     1   NODPLC(JUNODE+NODE2),NODPLC(JUNODE+NODE3),
     2   VALUE(LOCM),VALUE(LOCV+1),AIC
  331 FORMAT(6X,A8,3I5,2X,A8,F8.3,2X,A8)
  340 LOC=NODPLC(LOC)
      GO TO 330
C
C  PRINT MOSFETS
C
  350 IF (JELCNT(14).EQ.0) GO TO 400
      ITITLE=0
  351 FORMAT(//'0**** MOSFETS',/,'0NAME',6X,'D   G   S   B  MODEL',6X,
     1      'W       AD       PD      RDS'/
     2  37X,'L       AS       PS      RSS',//)
      LOC=LOCATE(14)
  360 IF ((LOC.EQ.0).OR.(NODPLC(LOC+33).NE.0)) GO TO 400
      IF (ITITLE.EQ.0) WRITE (IOFILE,351)
      ITITLE=1
      LOCV=NODPLC(LOC+1)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      NODE3=NODPLC(LOC+4)
      NODE4=NODPLC(LOC+5)
      LOCM=NODPLC(LOC+8)
      LOCM=NODPLC(LOCM+1)
      AIC=ABLNK
      IF (NODPLC(LOC+9).EQ.1) AIC=AOFF
      WRITE (IOFILE,361) VALUE(LOCV),NODPLC(JUNODE+NODE1),
     1   NODPLC(JUNODE+NODE2),NODPLC(JUNODE+NODE3),
     2   NODPLC(JUNODE+NODE4),VALUE(LOCM),VALUE(LOCV+2),
     3   VALUE(LOCV+3),VALUE(LOCV+11),VALUE(LOCV+13),
     4   VALUE(LOCV+1),VALUE(LOCV+4),VALUE(LOCV+12),VALUE(LOCV+14),AIC
  361 FORMAT(1X,A8,4I4,1X,A8,1P4D8.1,/34X,1P4D8.1,1X,A8)
  370 LOC=NODPLC(LOC)
      GO TO 360
C
C  SUBCIRCUIT CALLS
C
  400 IF (JELCNT(19).EQ.0) GO TO 500
      ITITLE=0
  401 FORMAT(//'0**** SUBCIRCUIT CALLS'/'0     NAME     SUBCIRCUIT   EXT
     1ERNAL NODES'//)
      LOC=LOCATE(19)
  410 IF (LOC.EQ.0) GO TO 500
      IF (ITITLE.EQ.0) WRITE (IOFILE,401)
      ITITLE=1
      LOCV=NODPLC(LOC+1)
      LOCN=NODPLC(LOC+2)
      CALL SIZMEM(NODPLC(LOC+2),NNODX)
      LOCS=NODPLC(LOC+3)
      LOCSV=NODPLC(LOCS+1)
      JSTART=1
      NDPRLN=(LWIDTH-28)/5
  412 JSTOP=MIN0(NNODX,JSTART+NDPRLN-1)
      DO 414 J=JSTART,JSTOP
      NODE=NODPLC(LOCN+J)
      ITAB(J-JSTART+1)=NODPLC(JUNODE+NODE)
  414 CONTINUE
      IF (JSTART.EQ.1)
     1   WRITE (IOFILE,416) VALUE(LOCV),VALUE(LOCSV),(ITAB(J),J=1,JSTOP)
  416 FORMAT(6X,A8,2X,A8,4X,20I5)
      IF (JSTART.NE.1)
     1   WRITE (IOFILE,418) (ITAB(J-JSTART+1),J=JSTART,JSTOP)
  418 FORMAT(28X,20I5)
      JSTART=JSTOP+1
      IF (JSTART.LE.NNODX) GO TO 412
      IF (NNODX.LE.NDPRLN) GO TO 420
      WRITE (IOFILE,226)
  420 LOC=NODPLC(LOC)
      GO TO 410
C
C  FINISHED
C
  500 RETURN
      END
