      SUBROUTINE FETLIM(VNEW,VOLD,VTO)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE LIMITS THE PER-ITERATION CHANGE OF FET VOLTAGES.
C
C
C      THREE REGIONS OF OPERATION ARE IDENTIFIED:
C
C                  V < VTO        DEFINITELY OFF
C            VTO <= V <= VTO+3.5D0    OFF OR ON DEPENDING ON VBS
C        VTO+3.5D0 < V              DEFINITELY ON
C
      VTSTHI=DABS(2.0D0*(VOLD-VTO))+2.0D0
      VTSTLO=VTSTHI/2.0D0+2.0D0
      VTOX=VTO+3.5D0
      DELV=VNEW-VOLD
C
      IF (VOLD.LT.VTO) GO TO 300
      IF (VOLD.LT.VTOX) GO TO 200
C
C  ON ...
C
      IF (DELV.GT.0.0D0) GO TO 120
C...  GOING OFF
      IF (VNEW.LT.VTOX) GO TO 110
      IF (-DELV.LE.VTSTLO) GO TO 500
      VNEW=VOLD-VTSTLO
      GO TO 500
  110 VNEW=DMAX1(VNEW,VTO+2.0D0)
      GO TO 500
C...  STAYING ON
  120 IF (DELV.LT.VTSTHI) GO TO 500
      VNEW=VOLD+VTSTHI
      GO TO 500
C
C  MIDDLE REGION ...
C
  200 IF (DELV.GT.0.0D0) GO TO 210
C...  DECREASING
      VNEW=DMAX1(VNEW,VTO-0.5D0)
      GO TO 500
C...  INCREASING
  210 VNEW=DMIN1(VNEW,VTO+4.0D0)
      GO TO 500
C
C  OFF ...
C
  300 IF (DELV.GT.0.0D0) GO TO 310
      IF (-DELV.LE.VTSTHI) GO TO 500
      VNEW=VOLD-VTSTHI
      GO TO 500
  310 VTEMP=VTO+0.5D0
      IF (VNEW.GT.VTEMP) GO TO 320
      IF (DELV.LE.VTSTLO) GO TO 500
      VNEW=VOLD+VTSTLO
      GO TO 500
  320 VNEW=VTEMP
C
C  FINISHED
C
  500 RETURN
      END
