      SUBROUTINE FOURAN
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE DETERMINES THE FOURIER COEFFICIENTS OF A TRANSIENT
C ANALYSIS WAVEFORM.
C
C SPICE VERSION 2G.6  SCCSID=TABINF 3/15/83
      COMMON /TABINF/ IELMNT,ISBCKT,NSBCKT,IUNSAT,NUNSAT,ITEMPS,NUMTEM,
     1   ISENS,NSENS,IFOUR,NFOUR,IFIELD,ICODE,IDELIM,ICOLUM,INSIZE,
     2   JUNODE,LSBKPT,NUMBKP,IORDER,JMNODE,IUR,IUC,ILC,ILR,NUMOFF,ISR,
     3   NMOFFC,ISEQ,ISEQ1,NEQN,NODEVS,NDIAG,ISWAP,IEQUA,MACINS,LVNIM1,
     4   LX0,LVN,LYNL,LYU,LYL,LX1,LX2,LX3,LX4,LX5,LX6,LX7,LD0,LD1,LTD,
     5   IMYNL,IMVN,LCVN,NSNOD,NSMAT,NSVAL,ICNOD,ICMAT,ICVAL,
     6   LOUTPT,LPOL,LZER,IRSWPF,IRSWPR,ICSWPF,ICSWPR,IRPT,JCPT,
     7   IROWNO,JCOLNO,NTTBR,NTTAR,LVNTMP
C SPICE VERSION 2G.6  SCCSID=CIRDAT 3/15/83
      COMMON /CIRDAT/ LOCATE(50),JELCNT(50),NUNODS,NCNODS,NUMNOD,NSTOP,
     1   NUT,NLT,NXTRM,NDIST,NTLIN,IBR,NUMVS,NUMALT,NUMCYC
C SPICE VERSION 2G.6  SCCSID=FLAGS 3/15/83
      COMMON /FLAGS/ IPRNTA,IPRNTL,IPRNTM,IPRNTN,IPRNTO,LIMTIM,LIMPTS,
     1   LVLCOD,LVLTIM,ITL1,ITL2,ITL3,ITL4,ITL5,ITL6,IGOOF,NOGO,KEOF
C SPICE VERSION 2G.6  SCCSID=MISCEL 3/15/83
      COMMON /MISCEL/ ATIME,APROG(3),ADATE,ATITLE(10),DEFL,DEFW,DEFAD,
     1  DEFAS,RSTATS(50),IWIDTH,LWIDTH,NOPAGE
C SPICE VERSION 2G.6  SCCSID=STATUS 3/15/83
      COMMON /STATUS/ OMEGA,TIME,DELTA,DELOLD(7),AG(7),VT,XNI,EGFET,
     1   XMU,SFACTR,MODE,MODEDC,ICALC,INITF,METHOD,IORD,MAXORD,NONCON,
     2   ITERNO,ITEMNO,NOSOLV,MODAC,IPIV,IVMFLG,IPOSTP,ISCRCH,IOFILE
C SPICE VERSION 2G.6  SCCSID=KNSTNT 3/15/83
      COMMON /KNSTNT/ TWOPI,XLOG2,XLOG10,ROOT2,RAD,BOLTZ,CHARGE,CTOK,
     1   GMIN,RELTOL,ABSTOL,VNTOL,TRTOL,CHGTOL,EPS0,EPSSIL,EPSOX,
     2   PIVTOL,PIVREL
C SPICE VERSION 2G.6  SCCSID=TRAN 3/15/83
      COMMON /TRAN/ TSTEP,TSTOP,TSTART,DELMAX,TDMAX,FORFRE,JTRFLG
C SPICE VERSION 2G.6  SCCSID=OUTINF 3/15/83
      COMMON /OUTINF/ XINCR,STRING(15),XSTART,YVAR(8),ITAB(8),ITYPE(8),
     1   ILOGY(8),NPOINT,NUMOUT,KNTR,NUMDGT
C SPICE VERSION 2G.6  SCCSID=BLANK 3/15/83
      COMMON /BLANK/ VALUE(200000)
      INTEGER NODPLC(64)
      COMPLEX CVALUE(32)
      EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1))
C
C
      DIMENSION SINCO(9),COSCO(9)
      DIMENSION FORTIT(4)
      DATA FORTIT / 8HFOURIER , 8HANALYSIS, 8H        , 8H         /
      DATA ABLNK / 1H  /
C
C
      FORPRD=1.0D0/FORFRE
      XSTART=TSTOP-FORPRD
      KNTR=1
CC    XN=101.0D0
      XINCR=FORPRD/NPOINT
CC    NPOINT=XN
      CALL GETM8(LOCX,NPOINT)
      CALL GETM8(LOCY,NPOINT)
      DO 105 NKNT=1,NFOUR
      ITAB(1)=NODPLC(IFOUR+NKNT)
      KFROUT=ITAB(1)
      CALL NTRPL8(LOCX,LOCY,NUMPNT)
      DCCO=0.0D0
      CALL ZERO8(SINCO,9)
      CALL ZERO8(COSCO,9)
      LOCT=LOCY+1
      IPNT=0
   10 YVR=VALUE(LOCT+IPNT)
      DCCO=DCCO+YVR
      FORFAC=DFLOAT(IPNT)*TWOPI/NPOINT
      ARG=0.0D0
      DO 20 K=1,9
      ARG=ARG+FORFAC
      SINCO(K)=SINCO(K)+YVR*DSIN(ARG)
      COSCO(K)=COSCO(K)+YVR*DCOS(ARG)
   20 CONTINUE
      IPNT=IPNT+1
      IF (IPNT.NE.NPOINT) GO TO 10
      DCCO=DCCO/NPOINT
      FORFAC=2.0D0/NPOINT
      DO 30 K=1,9
      SINCO(K)=SINCO(K)*FORFAC
      COSCO(K)=COSCO(K)*FORFAC
   30 CONTINUE
      CALL TITLE(0,72,1,FORTIT)
      IPOS=1
      CALL OUTNAM(KFROUT,1,STRING,IPOS)
      CALL MOVE(STRING,IPOS,ABLNK,1,7)
      JSTOP=(IPOS+6)/8
      WRITE (IOFILE,61) (STRING(J),J=1,JSTOP)
   61 FORMAT(' FOURIER COMPONENTS OF TRANSIENT RESPONSE ',5A8///)
      WRITE (IOFILE,71) DCCO
   71 FORMAT('0DC COMPONENT =',1PD12.3/,
     1   '0HARMONIC   FREQUENCY    FOURIER    NORMALIZED    PHASE     NO
     2RMALIZED'/,
     3   '    NO         (HZ)     COMPONENT    COMPONENT    (DEG)    PHA
     4SE (DEG)'//)
      IKNT=1
      FREQ1=FORFRE
      XNHARM=1.0D0
      CALL MAGPHS(CMPLX(SNGL(SINCO(1)),SNGL(COSCO(1))),XNORM,PNORM)
      PHASEN=0.0D0
      WRITE (IOFILE,81) IKNT,FREQ1,XNORM,XNHARM,PNORM,PHASEN
   81 FORMAT(I6,1PD15.3,D12.3,0PF13.6,F10.3,F12.3/)
      THD=0.0D0
      DO 90 IKNT=2,9
      FREQ1=DFLOAT(IKNT)*FORFRE
      CALL MAGPHS(CMPLX(SNGL(SINCO(IKNT)),SNGL(COSCO(IKNT))),
     1   HARM,PHASE)
      XNHARM=HARM/XNORM
      PHASEN=PHASE-PNORM
      THD=THD+XNHARM*XNHARM
      WRITE (IOFILE,81) IKNT,FREQ1,HARM,XNHARM,PHASE,PHASEN
   90 CONTINUE
      THD=100.0D0*DSQRT(THD)
      WRITE (IOFILE,101) THD
  101 FORMAT (//5X,'TOTAL HARMONIC DISTORTION =  ',F12.6,'  PERCENT')
  105 CONTINUE
      CALL CLRMEM(LOCX)
      CALL CLRMEM(LOCY)
  110 RETURN
      END
