      SUBROUTINE ITER8(ITLIM)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE DRIVES THE NEWTON-RAPHSON ITERATION TECHNIQUE USED TO
C SOLVE THE SET OF NONLINEAR CIRCUIT EQUATIONS.
C
C SPICE VERSION 2G.6  SCCSID=TABINF 3/15/83
      COMMON /TABINF/ IELMNT,ISBCKT,NSBCKT,IUNSAT,NUNSAT,ITEMPS,NUMTEM,
     1   ISENS,NSENS,IFOUR,NFOUR,IFIELD,ICODE,IDELIM,ICOLUM,INSIZE,
     2   JUNODE,LSBKPT,NUMBKP,IORDER,JMNODE,IUR,IUC,ILC,ILR,NUMOFF,ISR,
     3   NMOFFC,ISEQ,ISEQ1,NEQN,NODEVS,NDIAG,ISWAP,IEQUA,MACINS,LVNIM1,
     4   LX0,LVN,LYNL,LYU,LYL,LX1,LX2,LX3,LX4,LX5,LX6,LX7,LD0,LD1,LTD,
     5   IMYNL,IMVN,LCVN,NSNOD,NSMAT,NSVAL,ICNOD,ICMAT,ICVAL,
     6   LOUTPT,LPOL,LZER,IRSWPF,IRSWPR,ICSWPF,ICSWPR,IRPT,JCPT,
     7   IROWNO,JCOLNO,NTTBR,NTTAR,LVNTMP
C SPICE VERSION 2G.6  SCCSID=KNSTNT 3/15/83
      COMMON /KNSTNT/ TWOPI,XLOG2,XLOG10,ROOT2,RAD,BOLTZ,CHARGE,CTOK,
     1   GMIN,RELTOL,ABSTOL,VNTOL,TRTOL,CHGTOL,EPS0,EPSSIL,EPSOX,
     2   PIVTOL,PIVREL
C SPICE VERSION 2G.6  SCCSID=CIRDAT 3/15/83
      COMMON /CIRDAT/ LOCATE(50),JELCNT(50),NUNODS,NCNODS,NUMNOD,NSTOP,
     1   NUT,NLT,NXTRM,NDIST,NTLIN,IBR,NUMVS,NUMALT,NUMCYC
C SPICE VERSION 2G.6  SCCSID=STATUS 3/15/83
      COMMON /STATUS/ OMEGA,TIME,DELTA,DELOLD(7),AG(7),VT,XNI,EGFET,
     1   XMU,SFACTR,MODE,MODEDC,ICALC,INITF,METHOD,IORD,MAXORD,NONCON,
     2   ITERNO,ITEMNO,NOSOLV,MODAC,IPIV,IVMFLG,IPOSTP,ISCRCH,IOFILE
C SPICE VERSION 2G.6  SCCSID=MISCEL 3/15/83
      COMMON /MISCEL/ ATIME,APROG(3),ADATE,ATITLE(10),DEFL,DEFW,DEFAD,
     1  DEFAS,RSTATS(50),IWIDTH,LWIDTH,NOPAGE
C SPICE VERSION 2G.6  SCCSID=FLAGS 3/15/83
      COMMON /FLAGS/ IPRNTA,IPRNTL,IPRNTM,IPRNTN,IPRNTO,LIMTIM,LIMPTS,
     1   LVLCOD,LVLTIM,ITL1,ITL2,ITL3,ITL4,ITL5,ITL6,IGOOF,NOGO,KEOF
C SPICE VERSION 2G.6  SCCSID=BLANK 3/15/83
      COMMON /BLANK/ VALUE(200000)
      INTEGER NODPLC(64)
      COMPLEX CVALUE(32)
      EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1))
C
C
      IGOOF=0
      ITERNO=0
      NDRFLO=0
      NONCON=0
      IPASS=0
C
C  CONSTRUCT LINEAR EQUATIONS AND CHECK CONVERGENCE
C
   10 IVMFLG=0
      CALL LOAD
   15 IF ((MODE.EQ.1).AND.(MODEDC.EQ.2).AND.(NOSOLV.NE.0)) GO TO 300
      ITERNO=ITERNO+1
      GO TO (20,30,40,60,50,60),INITF
   20 IF(MODE.NE.1) GO TO 22
      CALL SIZMEM(NSNOD,NIC)
      IF (NIC.EQ.0) GO TO 22
      IF (IPASS.NE.0) NONCON=IPASS
      IPASS=0
   22 IF (NONCON.EQ.0) GO TO 300
      GO TO 100
   30 INITF=3
      IF(LVLCOD.EQ.3) LVLCOD=2
      IPIV=1
   40 IF (NONCON.EQ.0) INITF=1
      IPASS=1
      GO TO 100
   50 IF (ITERNO.GT.1) GO TO 60
      IPIV=1
      IF (LVLCOD.EQ.3) LVLCOD=2
   60 INITF=1
C
C  SOLVE EQUATIONS FOR NEXT ITERATION
C
  100 IF (ITERNO.GE.ITLIM) GO TO 200
  102 CALL DCDCMP
      IF (IGOOF.NE.0) GO TO 400
      IF (LVLCOD.EQ.1) GO TO 105
  105 CALL DCSOL
      GO TO 120
  120 IF (IGOOF.EQ.0) GO TO 130
      IGOOF=0
      IF (LVLCOD.NE.1) LVLCOD=2
      IPIV=1
      CALL LOAD
      GO TO 102
  130 VALUE(LVN+1)=0.0D0
      DO 135 I=1,NSTOP
      J=NODPLC(ICSWPR+I)
      K=NODPLC(IRSWPF+J)
      VALUE(LVNTMP+K)=VALUE(LVNIM1+I)
  135 CONTINUE
      CALL COPY8(VALUE(LVNTMP+1),VALUE(LVNIM1+1),NSTOP)
      NTEMP=NONCON
      NONCON=0
      IF (NTEMP.GT.0) GO TO 150
      IF (ITERNO.EQ.1) GO TO 150
      DO 140 I=2,NUMNOD
      VOLD=VALUE(LVNIM1+I)
      VNEW=VALUE(LVN+I)
      TOL=RELTOL*DMAX1(DABS(VOLD),DABS(VNEW))+VNTOL
      IF (DABS(VOLD-VNEW).LE.TOL) GO TO 140
      NONCON=NONCON+1
  140 CONTINUE
  150 DO 160 I=1,NSTOP
      J=NODPLC(ICSWPR+I)
      K=NODPLC(IRSWPF+J)
      VALUE(LVNIM1+I)=VALUE(LVN+K)
  160 CONTINUE
C     WRITE(IOFILE,151) (VALUE(LVN+K),K=1,NSTOP)
C 151 FORMAT(' SOLUTION: '/1P12D10.3)
      GO TO 10
C
C  NO CONVERGENCE
C
  200 IGOOF=1
  300 IF (NDRFLO.EQ.0) GO TO 400
      WRITE (IOFILE,301) NDRFLO
  301 FORMAT('0WARNING:  UNDERFLOW OCCURRED ',I4,' TIME(S)')
C
C  FINISHED
C
  400 RETURN
      END
