      SUBROUTINE MODCHK
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE PERFORMS ONE-TIME PROCESSING OF DEVICE MODEL PARA-
C METERS AND PRINTS OUT A DEVICE MODEL SUMMARY.  IT ALSO RESERVES THE
C ADDITIONAL NODES REQUIRED BY NONZERO DEVICE EXTRINSIC RESISTANCES.
C
C SPICE VERSION 2G.6  SCCSID=TABINF 3/15/83
      COMMON /TABINF/ IELMNT,ISBCKT,NSBCKT,IUNSAT,NUNSAT,ITEMPS,NUMTEM,
     1   ISENS,NSENS,IFOUR,NFOUR,IFIELD,ICODE,IDELIM,ICOLUM,INSIZE,
     2   JUNODE,LSBKPT,NUMBKP,IORDER,JMNODE,IUR,IUC,ILC,ILR,NUMOFF,ISR,
     3   NMOFFC,ISEQ,ISEQ1,NEQN,NODEVS,NDIAG,ISWAP,IEQUA,MACINS,LVNIM1,
     4   LX0,LVN,LYNL,LYU,LYL,LX1,LX2,LX3,LX4,LX5,LX6,LX7,LD0,LD1,LTD,
     5   IMYNL,IMVN,LCVN,NSNOD,NSMAT,NSVAL,ICNOD,ICMAT,ICVAL,
     6   LOUTPT,LPOL,LZER,IRSWPF,IRSWPR,ICSWPF,ICSWPR,IRPT,JCPT,
     7   IROWNO,JCOLNO,NTTBR,NTTAR,LVNTMP
C SPICE VERSION 2G.6  SCCSID=MISCEL 3/15/83
      COMMON /MISCEL/ ATIME,APROG(3),ADATE,ATITLE(10),DEFL,DEFW,DEFAD,
     1  DEFAS,RSTATS(50),IWIDTH,LWIDTH,NOPAGE
C SPICE VERSION 2G.6  SCCSID=CIRDAT 3/15/83
      COMMON /CIRDAT/ LOCATE(50),JELCNT(50),NUNODS,NCNODS,NUMNOD,NSTOP,
     1   NUT,NLT,NXTRM,NDIST,NTLIN,IBR,NUMVS,NUMALT,NUMCYC
C SPICE VERSION 2G.6  SCCSID=STATUS 3/15/83
      COMMON /STATUS/ OMEGA,TIME,DELTA,DELOLD(7),AG(7),VT,XNI,EGFET,
     1   XMU,SFACTR,MODE,MODEDC,ICALC,INITF,METHOD,IORD,MAXORD,NONCON,
     2   ITERNO,ITEMNO,NOSOLV,MODAC,IPIV,IVMFLG,IPOSTP,ISCRCH,IOFILE
C SPICE VERSION 2G.6  SCCSID=FLAGS 3/15/83
      COMMON /FLAGS/ IPRNTA,IPRNTL,IPRNTM,IPRNTN,IPRNTO,LIMTIM,LIMPTS,
     1   LVLCOD,LVLTIM,ITL1,ITL2,ITL3,ITL4,ITL5,ITL6,IGOOF,NOGO,KEOF
C SPICE VERSION 2G.6  SCCSID=KNSTNT 3/15/83
      COMMON /KNSTNT/ TWOPI,XLOG2,XLOG10,ROOT2,RAD,BOLTZ,CHARGE,CTOK,
     1   GMIN,RELTOL,ABSTOL,VNTOL,TRTOL,CHGTOL,EPS0,EPSSIL,EPSOX,
     2   PIVTOL,PIVREL
C SPICE VERSION 2G.6  SCCSID=BLANK 3/15/83
      COMMON /BLANK/ VALUE(200000)
      INTEGER NODPLC(64)
      COMPLEX CVALUE(32)
      EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1))
C
C
      DIMENSION ITAB(50),ATABLE(12)
      DIMENSION CPAR(2),BTABLE(12)
      DIMENSION ANTYPE(4),APTYPE(4)
      DIMENSION IPAR(5),AMPAR(115),DEFVAL(115),IFMT(115),IVCHK(115)
      DIMENSION TITLED(4),TITLEB(4),TITLEJ(4),TITLEM(4)
      DATA TITLED / 8HDIODE MO, 8HDEL PARA, 8HMETERS  , 8H         /
      DATA TITLEB / 8HBJT MODE, 8HL PARAME, 8HTERS    , 8H         /
      DATA TITLEJ / 8HJFET MOD, 8HEL PARAM, 8HETERS   , 8H         /
      DATA TITLEM / 8HMOSFET M, 8HODEL PAR, 8HAMETERS , 8H         /
      DATA ANTYPE /1H ,3HNPN,3HNJF,4HNMOS/
      DATA APTYPE /1H ,3HPNP,3HPJF,4HPMOS/
      DATA IPAR /0,14,60,72,114/
      DATA CPAR / 3HC2 ,3HC4 /
      DATA AUNDEF /2H.U/
      DATA AMPAR /
     1   6HIS    ,6HRS    ,6HN     ,6HTT    ,6HCJO   ,6HVJ    ,6HM     ,
     2   6HEG    ,6HXTI   ,6HKF    ,6HAF    ,6HFC    ,6HBV    ,6HIBV   ,
     1   6HIS    ,6HBF    ,6HNF    ,6HVAF   ,6HIKF   ,6HISE   ,6HNE    ,
     2   6HBR    ,6HNR    ,6HVAR   ,6HIKR   ,6HISC   ,6HNC    ,6H0     ,
     3   6H0     ,6HRB    ,6HIRB   ,6HRBM   ,6HRE    ,6HRC    ,6HCJE   ,
     4   6HVJE   ,6HMJE   ,6HTF    ,6HXTF   ,6HVTF   ,6HITF   ,6HPTF   ,
     5   6HCJC   ,6HVJC   ,6HMJC   ,6HXCJC  ,6HTR    ,6H0     ,6H0     ,
     6   6H0     ,6H0     ,6HCJS   ,6HVJS   ,6HMJS   ,6HXTB   ,6HEG    ,
     7   6HXTI   ,6HKF    ,6HAF    ,6HFC    ,
     1   6HVTO   ,6HBETA  ,6HLAMBDA,6HRD    ,6HRS    ,6HCGS   ,6HCGD   ,
     2   6HPB    ,6HIS    ,6HKF    ,6HAF    ,6HFC    ,
     1   6HLEVEL ,6HVTO   ,6HKP    ,6HGAMMA ,6HPHI   ,6HLAMBDA,6HRD    ,
     2   6HRS    ,6HCBD   ,6HCBS   ,6HIS    ,6HPB    ,6HCGSO  ,6HCGDO  ,
     3   6HCGBO  ,6HRSH   ,6HCJ    ,6HMJ    ,6HCJSW  ,6HMJSW  ,6HJS    ,
     4   6HTOX   ,6HNSUB  ,6HNSS   ,6HNFS   ,6HTPG   ,6HXJ    ,6HLD    ,
     5   6HUO    ,6HUCRIT ,6HUEXP  ,6HUTRA  ,6HVMAX  ,6HNEFF  ,6HXQC   ,
     6   6HKF    ,6HAF    ,6HFC    ,6HDELTA ,6HTHETA ,6HETA   ,6HKAPPA ,
     7   0.0D0   /
      DATA DEFVAL /
     1   1.0D-14,  0.0D0,  1.0D0,2*0.0D0,  1.0D0,  0.5D0, 1.11D0,
     2     3.0D0,  0.0D0,  1.0D0,  0.5D0,  0.0D0, 1.0D-3,
     1   1.0D-16,100.0D0,  1.0D0,3*0.0D0,  1.5D0,2*1.0D0,3*0.0D0,
     2     2.0D0,  0.0D0,  1.0D0,6*0.0D0, 0.75D0, 0.33D0,2*0.0D0,
     3   4*0.0D0, 0.75D0, 0.33D0,  1.0D0,6*0.0D0, 0.75D0,2*0.0D0,
     4    1.11D0,  3.0D0,  0.0D0,  1.0D0,  0.5D0,
     1    -2.0D0, 1.0D-4,5*0.0D0,  1.0D0,1.0D-14,  0.0D0,  1.0D0,
     2     0.5D0,
     1     1.0D0,  0.0D0, 2.0D-5,  0.0D0,  0.6D0,5*0.0D0,1.0D-14,
     2     0.8D0,5*0.0D0,  0.5D0,  0.0D0, 0.33D0,5*0.0D0,  1.0D0,
     3   2*0.0D0,600.0D0, 1.0D+4,3*0.0D0,  1.0D0,  1.0D0,  0.0D0,
     4     1.0D0,  0.5D0,3*0.0D0,  0.2D0,
     5     0.0D0/
      DATA IFMT /
     1   4,1,1,2,2,1,1,1,1,2,1,1,2,2,
     2   4,3,3,2,2,2,1,3,3,2,2,2,1,0,0,1,2,1,1,1,2,1,1,2,2,2,2,1,2,1,
     2   1,1,2,0,0,0,0,2,1,1,2,1,1,2,2,2,
     3   3,4,1,1,1,2,2,1,2,2,1,1,
     4   3,3,4,1,1,2,1,1,2,2,2,1,2,2,2,1,2,1,2,1,2,2,2,2,2,1,2,2,
     4   1,2,1,1,2,1,1,2,1,1,1,1,1,1,
     5   0/
      DATA IVCHK /
     1   0,0,0,0,0,0,0,0,0,0,0,0,0,0,
     2   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
     2   0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,0,0,
     3   -1,0,0,0,0,0,0,0,0,0,0,0,
     4   0,-1,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,-1,
     4   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
     5   0/
C
C
      TNOM=VALUE(ITEMPS+1)+CTOK
      XKT=BOLTZ*TNOM
      VT=XKT/CHARGE
      XNI=1.45D16
      EGFET=1.16D0-(7.02D-4*TNOM*TNOM)/(TNOM+1108.0D0)
      NUMMOD=JELCNT(21)+JELCNT(22)+JELCNT(23)+JELCNT(24)
      IF (NUMMOD.EQ.0) GO TO 1000
C
C  SPECIAL PREPROCESSING FOR MOSFET MODELS
C
      LOC=LOCATE(24)
    5 IF (LOC.EQ.0) GO TO 35
      LOCV=NODPLC(LOC+1)
      TYPE=NODPLC(LOC+2)
C
C     DEFAULT PARAMETERS FOR HIGHER LEVEL MOS MODELS
C
      LEV=VALUE(LOCV+1)
      IF (VALUE(LOCV+1).EQ.AUNDEF) LEV=1
      IF (VALUE(LOCV+23).NE.AUNDEF) XNSUB=VALUE(LOCV+23)*1.0D6
      IF (VALUE(LOCV+22).EQ.AUNDEF.AND.LEV.GT.1) VALUE(LOCV+22)=1.0D-7
      IF (VALUE(LOCV+22).EQ.AUNDEF) GO TO 33
      COX=EPSOX/VALUE(LOCV+22)
C
C     COMPUTE KP, IF NOT INPUT, USING DEFAULT MOBILITY 600 CM**2/V*SEC
C
      IF (VALUE(LOCV+3).NE.AUNDEF) GO TO 10
      IF (VALUE(LOCV+29).EQ.AUNDEF) VALUE(LOCV+29)=600.0D0
      VALUE(LOCV+3)=VALUE(LOCV+29)*COX*1.0D-4
   10 IF (VALUE(LOCV+23).EQ.AUNDEF) GO TO 33
      IF (XNSUB.LE.XNI) GO TO 30
C
C     NSUB NONZERO => PROCESS ORIENTED MODEL
C
      IF (VALUE(LOCV+5).EQ.AUNDEF) VALUE(LOCV+5)=
     1   DMAX1((2.0D0*VT*DLOG(XNSUB/XNI)),0.1D0)
      FERMIS=TYPE*0.5D0*VALUE(LOCV+5)
      WKFNG=3.2D0
      IF (VALUE(LOCV+26).EQ.AUNDEF) VALUE(LOCV+26)=1.0D0
      IF (VALUE(LOCV+26).EQ.0.0D0) GO TO 15
C
C  POLYSILICON GATE
C
      FERMIG=TYPE*VALUE(LOCV+26)*0.5D0*EGFET
      WKFNG=3.25D0+0.5D0*EGFET-FERMIG
   15 WKFNGS=WKFNG-(3.25D0+0.5D0*EGFET+FERMIS)
      IF (VALUE(LOCV+4).EQ.AUNDEF)
     1   VALUE(LOCV+4)=DSQRT(2.0D0*EPSSIL*CHARGE*XNSUB)/COX
C
C     COMPUTED VTO
C
      IF (VALUE(LOCV+2).NE.AUNDEF) GO TO 20
      IF (VALUE(LOCV+24).EQ.AUNDEF) VALUE(LOCV+24)=0.0D0
      VALUE(LOCV+44)=WKFNGS-VALUE(LOCV+24)*1.0D4*CHARGE/COX
      VALUE(LOCV+2)=VALUE(LOCV+44)
     1   +TYPE*(VALUE(LOCV+4)*DSQRT(VALUE(LOCV+5))+VALUE(LOCV+5))
      GO TO 25
C
C     MEASURED VTO HAS BEEN INPUT
C
   20 VALUE(LOCV+44)=VALUE(LOCV+2)
     1   -TYPE*(VALUE(LOCV+4)*DSQRT(VALUE(LOCV+5))+VALUE(LOCV+5))
   25 VALUE(LOCV+45)=DSQRT((EPSSIL+EPSSIL)/(CHARGE*XNSUB))
      GO TO 33
   30 VALUE(LOCV+23)=0.0D0
      WRITE (IOFILE,31) VALUE(LOCV)
   31 FORMAT('0*ERROR*:  NSUB <= NI IN MOSFET MODEL ',A8,/)
      NOGO=1
C
C   SPECIAL PROCESSING FOR MOS3: LIMIT KAPPA>0,
C   SET TO ZERO LAMBDA,UCRIT,UEXP AND UTAR
C
   33 IF (LEV.NE.3) GO TO 34
      IF (VALUE(LOCV+42).EQ.AUNDEF) VALUE(LOCV+42)=0.2D0
      VALUE(LOCV+6)=0.0D0
      VALUE(LOCV+30)=0.0D0
      VALUE(LOCV+31)=0.0D0
      VALUE(LOCV+32)=0.0D0
   34 LOC=NODPLC(LOC)
      GO TO 5
C
C     CYCLE THRU DEVICES
C
   35 KNTLIM=LWIDTH/11
      DO 390 ID=1,4
      IF (JELCNT(ID+20).EQ.0) GO TO 390
      LOCM=IPAR(ID)
      NOPAR=IPAR(ID+1)-LOCM
      DO 45 I=1,NOPAR
      IF (IFMT(LOCM+I).GE.3) GO TO 40
      ITAB(I)=0
      GO TO 45
   40 ITAB(I)=IFMT(LOCM+I)-2
   45 CONTINUE
C
C  ASSIGN DEFAULT VALUES
C
      LOC=LOCATE(ID+20)
   50 IF (LOC.EQ.0) GO TO 70
      LOCV=NODPLC(LOC+1)
      DO 65 I=1,NOPAR
      IF (VALUE(LOCV+I).EQ.AUNDEF) GO TO 62
      IF (IVCHK(LOCM+I).LT.0) GO TO 55
      IF (VALUE(LOCV+I).LT.0.0D0) GO TO 62
   55 IF (ITAB(I).NE.0) GO TO 65
      ITAB(I)=IFMT(LOCM+I)
      GO TO 65
   62 VALUE(LOCV+I)=DEFVAL(LOCM+I)
   65 CONTINUE
      LOC=NODPLC(LOC)
      GO TO 50
C
C     LIMIT MODEL VALUES
C
   70 GO TO (80,85,90,95), ID
C...  DIODES
   80 LOC=LOCATE(21)
   82 IF (LOC.EQ.0) GO TO 130
      LOCV=NODPLC(LOC+1)
      VALUE(LOCV+7)=DMIN1(VALUE(LOCV+7),0.9D0)
      VALUE(LOCV+8)=DMAX1(VALUE(LOCV+8),0.1D0)
      VALUE(LOCV+11)=DMAX1(VALUE(LOCV+11),0.1D0)
      VALUE(LOCV+12)=DMIN1(VALUE(LOCV+12),0.95D0)
      LOC=NODPLC(LOC)
      GO TO 82
C...  BIPOLAR TRANSISTORS
   85 LOC=LOCATE(22)
   87 IF (LOC.EQ.0) GO TO 130
      LOCV=NODPLC(LOC+1)
      VALUE(LOCV+23)=DMIN1(VALUE(LOCV+23),0.9D0)
      IF (VALUE(LOCV+24).EQ.0.0D0) VALUE(LOCV+28)=0.0D0
      VALUE(LOCV+31)=DMIN1(VALUE(LOCV+31),0.9D0)
      VALUE(LOCV+32)=DMIN1(VALUE(LOCV+32),1.0D0)
      VALUE(LOCV+40)=DMIN1(VALUE(LOCV+40),0.9D0)
      VALUE(LOCV+42)=DMAX1(VALUE(LOCV+42),0.1D0)
      VALUE(LOCV+45)=DMAX1(VALUE(LOCV+45),0.1D0)
      VALUE(LOCV+46)=DMIN1(VALUE(LOCV+46),0.9999D0)
      LOC=NODPLC(LOC)
      IF (VALUE(LOCV+18).EQ.0.0D0) VALUE(LOCV+18)=VALUE(LOCV+16)
      IF (VALUE(LOCV+16).GE.VALUE(LOCV+18)) GO TO 87
      WRITE(IOFILE,89) VALUE(LOCV)
   89 FORMAT('0WARNING:  MINIMUM BASE RESISTANCE (RBM) IS LESS THAN '
     1       ,'TOTAL (RB) FOR MODEL ',A8,/10X,' RBM SET EQUAL TO RB',/)
      VALUE(LOCV+18)=VALUE(LOCV+16)
      GO TO 87
C...  JFETS
   90 LOC=LOCATE(23)
   92 IF (LOC.EQ.0) GO TO 130
      LOCV=NODPLC(LOC+1)
      VALUE(LOCV+11)=DMAX1(VALUE(LOCV+11),0.1D0)
      VALUE(LOCV+12)=DMIN1(VALUE(LOCV+12),0.95D0)
      LOC=NODPLC(LOC)
      GO TO 92
C...  MOSFETS
   95 LOC=LOCATE(24)
   97 IF (LOC.EQ.0) GO TO 130
      LOCV=NODPLC(LOC+1)
C
  100 VALUE(LOCV+37)=DMAX1(VALUE(LOCV+37),0.1D0)
      VALUE(LOCV+38)=DMIN1(VALUE(LOCV+38),0.95D0)
      IF (VALUE(LOCV+23).LE.0.0D0) GO TO 120
      CJ=DSQRT(EPSSIL*CHARGE*VALUE(LOCV+23)*1.0D6/
     1   (2.0D0*VALUE(LOCV+12)))
      IF (VALUE(LOCV+9).LE.0.0D0) GO TO 105
      ITAB(9)=2
  105 IF (VALUE(LOCV+10).LE.0.0D0) GO TO 110
      ITAB(10)=2
      GO TO 115
  110 IF (VALUE(LOCV+17).LE.0.0D0) VALUE(LOCV+17)=CJ
      ITAB(17)=2
  115 IF ((VALUE(LOCV+7).LE.0.0D0).AND.
     1    (VALUE(LOCV+8).LE.0.0D0)) GO TO 120
      ITAB(7)=2
      ITAB(8)=2
  120 IF (VALUE(LOCV+6).GE.0.2D0) WRITE (IOFILE,121) VALUE(LOCV)
  121 FORMAT ('0WARNING:  THE VALUE OF LAMBDA FOR MOSFET MODEL ',A8,/,
     1   ' IS UNUSUALLY LARGE AND MIGHT CAUSE NONCONVERGENCE',/)
      IF (LEV.NE.2) VALUE(LOCV+35)=1.0D0
      IF (LEV.NE.3) GO TO 125
      ITAB(40)=1
      ITAB(41)=1
      ITAB(42)=1
      ITAB(43)=1
  125 LOC=NODPLC(LOC)
      GO TO 97
C
C     PRINT MODEL PARAMETERS
C
  130 IF (IPRNTM.EQ.0) GO TO 360
      LOCS=LOCATE(ID+20)
  140 KNTR=0
      LOC=LOCS
      GO TO (150,160,170,180), ID
  150 CALL TITLE(0,LWIDTH,1,TITLED)
      GO TO 200
  160 CALL TITLE(0,LWIDTH,1,TITLEB)
      GO TO 200
  170 CALL TITLE(0,LWIDTH,1,TITLEJ)
      GO TO 200
  180 CALL TITLE(0,LWIDTH,1,TITLEM)
  200 IF (LOC.EQ.0) GO TO 210
      IF (KNTR.LT.KNTLIM) GO TO 220
  210 LOCN=LOC
      GO TO 240
  220 KNTR=KNTR+1
      LOCV=NODPLC(LOC+1)
      ATABLE(KNTR)=VALUE(LOCV)
  230 LOC=NODPLC(LOC)
      GO TO 200
  240 WRITE (IOFILE,241) (ATABLE(K),K=1,KNTR)
  241 FORMAT(//11X,12(2X,A8))
      IF (ID.EQ.1) GO TO 300
      KNTR=0
      LOC=LOCS
  250 IF (LOC.EQ.0) GO TO 260
      IF (KNTR.GE.KNTLIM) GO TO 260
      KNTR=KNTR+1
      ATABLE(KNTR)=ANTYPE(ID)
      IF (NODPLC(LOC+2).EQ.-1) ATABLE(KNTR)=APTYPE(ID)
      LOC=NODPLC(LOC)
      GO TO 250
  260 WRITE (IOFILE,261) (ATABLE(K),K=1,KNTR)
  261 FORMAT('0TYPE',4X,12(4X,A6))
  300 DO 340 I=1,NOPAR
      IF (ITAB(I).EQ.0) GO TO 340
      KNTR=0
      ICCFLG=0
      LOC=LOCS
  310 IF (LOC.EQ.0) GO TO 320
      IF (KNTR.GE.KNTLIM) GO TO 320
      LOCV=NODPLC(LOC+1)
      KNTR=KNTR+1
      IF (ICCFLG.NE.0) GO TO 313
      IF (ID.NE.2) GO TO 315
      IF ((I.NE.6).AND.(I.NE.12)) GO TO 315
      IF (VALUE(LOCV+I).LE.1.0D0) GO TO 315
      ICCFLG=I/6
  313 BTABLE(KNTR)=VALUE(LOCV+I)
      VALUE(LOCV+I)=VALUE(LOCV+I)*VALUE(LOCV+1)
  315 ATABLE(KNTR)=VALUE(LOCV+I)
      LOC=NODPLC(LOC)
      GO TO 310
  320 IF (ITAB(I).EQ.2) GO TO 330
      WRITE (IOFILE,321) AMPAR(LOCM+I),(ATABLE(K),K=1,KNTR)
  321 FORMAT(1H0,A8,12F10.3)
      GO TO 340
  330 WRITE (IOFILE,331) AMPAR(LOCM+I),(ATABLE(K),K=1,KNTR)
  331 FORMAT(1H0,A8,1P12D10.2)
      IF (ICCFLG.EQ.0) GO TO 340
      WRITE (IOFILE,321) CPAR(ICCFLG),(BTABLE(K),K=1,KNTR)
  340 CONTINUE
      IF (LOCN.EQ.0) GO TO 390
      LOCS=LOCN
      GO TO 140
C
C  SPECIAL  TREATMENT FOR C2 & C4 IN THE BJT MODEL
C  WHEN NO MODEL PARAMETER PRINT
C
  360 IF (ID.NE.2) GO TO 390
      LOC=LOCATE(ID+20)
  370 IF (LOC.EQ.0) GO TO 390
      LOCV=NODPLC(LOC+1)
      IF (VALUE(LOCV+6).GE.1.0D0)
     1   VALUE(LOCV+6)=VALUE(LOCV+6)*VALUE(LOCV+1)
      IF (VALUE(LOCV+12).GE.1.0D0)
     1   VALUE(LOCV+12)=VALUE(LOCV+12)*VALUE(LOCV+1)
      LOC=NODPLC(LOC)
      GO TO 370
  390 CONTINUE
C
C  PROCESS MODEL PARAMETERS
C
C  DIODES
C
  400 LOC=LOCATE(21)
  410 IF (LOC.EQ.0) GO TO 420
      LOCV=NODPLC(LOC+1)
      IF (VALUE(LOCV+2).NE.0.0D0) VALUE(LOCV+2)=1.0D0/VALUE(LOCV+2)
      PB=VALUE(LOCV+6)
      XM=VALUE(LOCV+7)
      FC=VALUE(LOCV+12)
      VALUE(LOCV+12)=FC*PB
      XFC=DLOG(1.0D0-FC)
      VALUE(LOCV+15)=PB*(1.0D0-DEXP((1.0D0-XM)*XFC))/(1.0D0-XM)
      VALUE(LOCV+16)=DEXP((1.0D0+XM)*XFC)
      VALUE(LOCV+17)=1.0D0-FC*(1.0D0+XM)
      CSAT=VALUE(LOCV+1)
      VTE=VALUE(LOCV+3)*VT
      VALUE(LOCV+18)=VTE*DLOG(VTE/(ROOT2*CSAT))
      BV=VALUE(LOCV+13)
      IF (BV.EQ.0) GO TO 418
      CBV=VALUE(LOCV+14)
      IF (CBV.GE.CSAT*BV/VT) GO TO 412
      CBV=CSAT*BV/VT
      WRITE (IOFILE,411) VALUE(LOCV),CBV
  411 FORMAT('0WARNING:  IN DIODE MODEL ',A8,' IBV INCREASED TO ',1PE10.
     1   3,11X,'TO RESOLVE INCOMPATIBILITY WITH SPECIFIED IS'/)
      XBV=BV
      GO TO 416
  412 TOL=RELTOL*CBV
      XBV=BV-VT*DLOG(1.0D0+CBV/CSAT)
      ITER=0
  413 XBV=BV-VT*DLOG(CBV/CSAT+1.0D0-XBV/VT)
      XCBV=CSAT*(DEXP((BV-XBV)/VT)-1.0D0+XBV/VT)
      IF (DABS(XCBV-CBV).LE.TOL) GO TO 416
      ITER=ITER+1
      IF (ITER.LT.25) GO TO 413
      WRITE (IOFILE,415) XBV,XCBV
  415 FORMAT('0WARNING:  UNABLE TO MATCH FORWARD AND REVERSE DIODE REGIO
     1NS',/,11X,'BV = ',1PD10.3,' AND IBV = ',D10.3,/)
  416 VALUE(LOCV+13)=XBV
  418 LOC=NODPLC(LOC)
      GO TO 410
C
C  BIPOLAR TRANSISTOR MODELS
C
  420 LOC=LOCATE(22)
  430 IF (LOC.EQ.0) GO TO 440
      LOCV=NODPLC(LOC+1)
      IF (VALUE(LOCV+4).NE.0.0D0) VALUE(LOCV+4)=1.0D0/VALUE(LOCV+4)
      IF (VALUE(LOCV+5).NE.0.0D0) VALUE(LOCV+5)=1.0D0/VALUE(LOCV+5)
      IF (VALUE(LOCV+10).NE.0.0D0) VALUE(LOCV+10)=1.0D0/VALUE(LOCV+10)
      IF (VALUE(LOCV+11).NE.0.0D0) VALUE(LOCV+11)=1.0D0/VALUE(LOCV+11)
      IF (VALUE(LOCV+19).NE.0.0D0) VALUE(LOCV+19)=1.0D0/VALUE(LOCV+19)
      IF (VALUE(LOCV+20).NE.0.0D0) VALUE(LOCV+20)=1.0D0/VALUE(LOCV+20)
      IF (VALUE(LOCV+26).NE.0.0D0) VALUE(LOCV+26)=1.0D0/VALUE(LOCV+26)
     1   /1.44D0
      VALUE(LOCV+28)=VALUE(LOCV+28)/RAD*VALUE(LOCV+24)
      IF (VALUE(LOCV+35).NE.0.0D0) VALUE(LOCV+35)=1.0D0/VALUE(LOCV+35)
     1   /1.44D0
      PE=VALUE(LOCV+22)
      XME=VALUE(LOCV+23)
      PC=VALUE(LOCV+30)
      XMC=VALUE(LOCV+31)
      FC=VALUE(LOCV+46)
      VALUE(LOCV+46)=FC*PE
      XFC=DLOG(1.0D0-FC)
      VALUE(LOCV+47)=PE*(1.0D0-DEXP((1.0D0-XME)*XFC))/(1.0D0-XME)
      VALUE(LOCV+48)=DEXP((1.0D0+XME)*XFC)
      VALUE(LOCV+49)=1.0D0-FC*(1.0D0+XME)
      VALUE(LOCV+50)=FC*PC
      VALUE(LOCV+51)=PC*(1.0D0-DEXP((1.0D0-XMC)*XFC))/(1.0D0-XMC)
      VALUE(LOCV+52)=DEXP((1.0D0+XMC)*XFC)
      VALUE(LOCV+53)=1.0D0-FC*(1.0D0+XMC)
      CSAT=VALUE(LOCV+1)
      VALUE(LOCV+54)=VT*DLOG(VT/(ROOT2*CSAT))
      LOC=NODPLC(LOC)
      GO TO 430
C
C  JFET MODELS
C
  440 LOC=LOCATE(23)
  450 IF (LOC.EQ.0) GO TO 460
      LOCV=NODPLC(LOC+1)
      IF (VALUE(LOCV+4).NE.0.0D0) VALUE(LOCV+4)=1.0D0/VALUE(LOCV+4)
      IF (VALUE(LOCV+5).NE.0.0D0) VALUE(LOCV+5)=1.0D0/VALUE(LOCV+5)
      PB=VALUE(LOCV+8)
      XM=0.5D0
      FC=VALUE(LOCV+12)
      VALUE(LOCV+12)=FC*PB
      XFC=DLOG(1.0D0-FC)
      VALUE(LOCV+13)=PB*(1.0D0-DEXP((1.0D0-XM)*XFC))/(1.0D0-XM)
      VALUE(LOCV+14)=DEXP((1.0D0+XM)*XFC)
      VALUE(LOCV+15)=1.0D0-FC*(1.0D0+XM)
      CSAT=VALUE(LOCV+9)
      VALUE(LOCV+16)=VT*DLOG(VT/(ROOT2*CSAT))
      LOC=NODPLC(LOC)
      GO TO 450
C
C  MOSFET MODELS
C
  460 LOC=LOCATE(24)
  470 IF (LOC.EQ.0) GO TO 600
      LOCV=NODPLC(LOC+1)
      TYPE=NODPLC(LOC+2)
      IF (VALUE(LOCV+7).NE.0.0D0) VALUE(LOCV+7)=1.0D0/VALUE(LOCV+7)
      IF (VALUE(LOCV+8).NE.0.0D0) VALUE(LOCV+8)=1.0D0/VALUE(LOCV+8)
      IF (VALUE(LOCV+16).NE.0.0D0) VALUE(LOCV+16)=1.0D0/VALUE(LOCV+16)
      VALUE(LOCV+23)=VALUE(LOCV+23)*1.0D6
      VALUE(LOCV+24)=VALUE(LOCV+24)*1.0D4
      VALUE(LOCV+25)=VALUE(LOCV+25)*1.0D4
      IF (VALUE(LOCV+22).NE.0.0D0) VALUE(LOCV+22)=EPSOX/VALUE(LOCV+22)
      VALUE(LOCV+29)=VALUE(LOCV+29)*1.0D-4
      IF (LEV.EQ.3) GO TO 472
      VALUE(LOCV+30)=VALUE(LOCV+30)*1.0D2
      GO TO 473
C
C   MOVE MOS3 PARAMETERS : THETA FROM LOCATIONS LOCV+40 TO LOCV+30
C                          ETA                       41         31
C                          KAPPA                     42         32
C   AND REPLACE LOCV+6 BY (XD)**2
C
  472 VALUE(LOCV+39)=VALUE(LOCV+39)
     1   *0.25D0*TWOPI*EPSSIL/VALUE(LOCV+22)
      VALUE(LOCV+30)=VALUE(LOCV+40)
      VALUE(LOCV+31)=VALUE(LOCV+41)*8.15D-22/VALUE(LOCV+22)
      VALUE(LOCV+32)=VALUE(LOCV+42)
      IF (VALUE(LOCV+23).GT.0.0D0)
     1    VALUE(LOCV+6)=(EPSSIL+EPSSIL)/(CHARGE*VALUE(LOCV+23))
C
C   NOISE PARAMETERS
C
  473 PB=VALUE(LOCV+12)
      XM=0.5D0
      FC=VALUE(LOCV+38)
      VALUE(LOCV+38)=FC*PB
      XFC=DLOG(1.0D0-FC)
      VALUE(LOCV+40)=PB*(1.0D0-DEXP((1.0D0-XM)*XFC))/(1.0D0-XM)
      VALUE(LOCV+41)=DEXP((1.0D0+XM)*XFC)
      VALUE(LOCV+42)=1.0D0-FC*(1.0D0+XM)
      VALUE(LOCV+43)=-1.0D0
      VALUE(LOCV+44)=VALUE(LOCV+2)-
     1   TYPE*VALUE(LOCV+4)*DSQRT(VALUE(LOCV+5))
  475 IF (VALUE(LOCV+22).NE.0.0D0.AND.LEV.NE.3)
     1   VALUE(LOCV+30)=VALUE(LOCV+30)*EPSSIL/VALUE(LOCV+22)
      LOC=NODPLC(LOC)
      GO TO 470
C
C  RESERVE ADDITIONAL NODES
C
C  DIODES
C
  600 LOC=LOCATE(11)
  610 IF ((LOC.EQ.0).OR.(NODPLC(LOC+16).NE.0)) GO TO 700
      LOCM=NODPLC(LOC+5)
      LOCM=NODPLC(LOCM+1)
      IF (VALUE(LOCM+2).EQ.0.0D0) GO TO 620
      NUMNOD=NUMNOD+1
      NODPLC(LOC+4)=NUMNOD
      GO TO 630
  620 NODPLC(LOC+4)=NODPLC(LOC+2)
  630 LOC=NODPLC(LOC)
      GO TO 610
C
C  TRANSISTORS
C
  700 LOC=LOCATE(12)
  710 IF ((LOC.EQ.0).OR.(NODPLC(LOC+36).NE.0)) GO TO 800
      NODPLC(LOC+30)=NODPLC(LOC+5)
      LOCM=NODPLC(LOC+8)
      LOCM=NODPLC(LOCM+1)
      IF (VALUE(LOCM+16).EQ.0.0D0) GO TO 720
      NUMNOD=NUMNOD+1
      NODPLC(LOC+6)=NUMNOD
      GO TO 730
  720 NODPLC(LOC+6)=NODPLC(LOC+3)
  730 IF (VALUE(LOCM+20).EQ.0.0D0) GO TO 740
      NUMNOD=NUMNOD+1
      NODPLC(LOC+5)=NUMNOD
      GO TO 750
  740 NODPLC(LOC+5)=NODPLC(LOC+2)
  750 IF (VALUE(LOCM+19).EQ.0.0D0) GO TO 760
      NUMNOD=NUMNOD+1
      NODPLC(LOC+7)=NUMNOD
      GO TO 770
  760 NODPLC(LOC+7)=NODPLC(LOC+4)
  770 LOC=NODPLC(LOC)
      GO TO 710
C
C  JFETS
C
  800 LOC=LOCATE(13)
  810 IF ((LOC.EQ.0).OR.(NODPLC(LOC+25).NE.0)) GO TO 900
      LOCM=NODPLC(LOC+7)
      LOCM=NODPLC(LOCM+1)
      IF (VALUE(LOCM+4).EQ.0.0D0) GO TO 820
      NUMNOD=NUMNOD+1
      NODPLC(LOC+5)=NUMNOD
      GO TO 830
  820 NODPLC(LOC+5)=NODPLC(LOC+2)
  830 IF (VALUE(LOCM+5).EQ.0.0D0) GO TO 840
      NUMNOD=NUMNOD+1
      NODPLC(LOC+6)=NUMNOD
      GO TO 850
  840 NODPLC(LOC+6)=NODPLC(LOC+4)
  850 LOC=NODPLC(LOC)
      GO TO 810
C
C  MOSFETS
C
  900 LOC=LOCATE(14)
  910 IF (LOC.EQ.0) GO TO 1000
      LOCM=NODPLC(LOC+8)
      LOCM=NODPLC(LOCM+1)
      LOCV=NODPLC(LOC+1)
      XLEFF=VALUE(LOCV+1)-2.0D0*VALUE(LOCM+28)
      IF (XLEFF.GT.0.0D0) GO TO 915
      WRITE(IOFILE,911) VALUE(LOCV),VALUE(LOCM)
  911 FORMAT('0*ERROR*:  EFFECTIVE CHANNEL LENGTH OF ',A8,' LESS THAN ',
     1   'ZERO.',/' CHECK VALUE OF LD FOR MODEL ',A8)
      IF (NODPLC(LOC+33).NE.0) GO TO 960
  915 IF ((VALUE(LOCM+7).EQ.0.0D0).AND.
     1    (VALUE(LOCM+16).EQ.0.0D0)) GO TO 920
      NUMNOD=NUMNOD+1
      NODPLC(LOC+6)=NUMNOD
      GO TO 930
  920 NODPLC(LOC+6)=NODPLC(LOC+2)
  930 IF ((VALUE(LOCM+8).EQ.0.0D0).AND.
     1    (VALUE(LOCM+16).EQ.0.0D0)) GO TO 940
      NUMNOD=NUMNOD+1
      NODPLC(LOC+7)=NUMNOD
      GO TO 950
  940 NODPLC(LOC+7)=NODPLC(LOC+4)
  950 AD=VALUE(LOCV+3)
      AS=VALUE(LOCV+4)
      IF ((AD.LE.0.0D0).OR.(AS.LE.0.0D0)
     1   .AND.VALUE(LOCM+11).LE.0.0D0)
     2   VALUE(LOCM+11)=1.0D-14
  960 LOC=NODPLC(LOC)
      GO TO 910
C
C  TRANSMISSION LINES
C
 1000 LOC=LOCATE(17)
 1010 IF ((LOC.EQ.0).OR.(NODPLC(LOC+33).NE.0)) GO TO 2000
      NUMNOD=NUMNOD+1
      NODPLC(LOC+6)=NUMNOD
      NUMNOD=NUMNOD+1
      NODPLC(LOC+7)=NUMNOD
      LOC=NODPLC(LOC)
      GO TO 1010
C
C  FINISHED
C
 2000 RETURN
      END
