      SUBROUTINE MOSEQ1(VDS,VBS,VGS,GM,GDS,GMBS)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE EVALUATES THE DRAIN CURRENT AND ITS DERIVATIVES
C     USING THE SHICHMAN-HODGES MODEL AND THE CHARGES ASSOCIATED
C     WITH THE GATE, CHANNEL AND BULK FOR MOSFETS
C
C SPICE VERSION 2G.6  SCCSID=MOSARG 3/15/83
      COMMON /MOSARG/ VTO,BETA,GAMMA,PHI,PHIB,COX,XNSUB,XNFS,XD,XJ,XLD,
     1   XLAMDA,UO,UEXP,VBP,UTRA,VMAX,XNEFF,XL,XW,VBI,VON,VDSAT,QSPOF,
     2   BETA0,BETA1,CDRAIN,XQCO,XQC,FNARRW,FSHORT,LEV
C SPICE VERSION 2G.6  SCCSID=STATUS 3/15/83
      COMMON /STATUS/ OMEGA,TIME,DELTA,DELOLD(7),AG(7),VT,XNI,EGFET,
     1   XMU,SFACTR,MODE,MODEDC,ICALC,INITF,METHOD,IORD,MAXORD,NONCON,
     2   ITERNO,ITEMNO,NOSOLV,MODAC,IPIV,IVMFLG,IPOSTP,ISCRCH,IOFILE
C SPICE VERSION 2G.6  SCCSID=KNSTNT 3/15/83
      COMMON /KNSTNT/ TWOPI,XLOG2,XLOG10,ROOT2,RAD,BOLTZ,CHARGE,CTOK,
     1   GMIN,RELTOL,ABSTOL,VNTOL,TRTOL,CHGTOL,EPS0,EPSSIL,EPSOX,
     2   PIVTOL,PIVREL
      VBD=VBS-VDS
      VGB=VGS-VBS
C
C
      IF (VBS.GT.0.0D0) GO TO 102
      SARG=DSQRT(PHI-VBS)
      GO TO 104
  102 SARG=DSQRT(PHI)
      SARG=SARG-VBS/(SARG+SARG)
      SARG=DMAX1(0.0D0,SARG)
  104 VON=VBI+GAMMA*SARG
      VGST=VGS-VON
      VDSAT=DMAX1(VGST,0.0D0)
      IF (SARG.GT.0.0D0) GO TO 105
      ARG=0.0D0
      GO TO 108
  105 ARG=GAMMA/(SARG+SARG)
  108 IF (VGST.GT.0.0D0) GO TO 110
C
C     CUTOFF REGION
C
      CDRAIN=0.0D0
      GM=0.0D0
      GDS=0.0D0
      GMBS=0.0D0
      GO TO 1000
C
C     SATURATION REGION
C
  110 BETAP=BETA*(1.0D0+XLAMDA*VDS)
      IF (VGST.GT.VDS) GO TO 120
      CDRAIN=BETAP*VGST*VGST*0.5D0
      GM=BETAP*VGST
      GDS=XLAMDA*BETA*VGST*VGST*0.5D0
      GMBS=GM*ARG
      GO TO 1000
C
C     LINEAR REGION
C
  120 CDRAIN=BETAP*VDS*(VGST-0.5D0*VDS)
      GM=BETAP*VDS
      GDS=BETAP*(VGST-VDS)+XLAMDA*BETA*VDS*(VGST-0.5D0*VDS)
      GMBS=GM*ARG
C
C     FINISHED
C
 1000 RETURN
      END
