      SUBROUTINE MOSEQ2(VDS,VBS,VGS,GM,GDS,GMBS,
     1   QG,QC,QB,CGGB,CGDB,CGSB,CBGB,CBDB,CBSB)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE EVALUATES THE DRAIN CURRENT, ITS DERIVATIVES AND
C     THE CHARGES ASSOCIATED WITH THE GATE, CHANNEL AND BULK
C     FOR MOSFETS
C
C SPICE VERSION 2G.6  SCCSID=MOSARG 3/15/83
      COMMON /MOSARG/ VTO,BETA,GAMMA,PHI,PHIB,COX,XNSUB,XNFS,XD,XJ,XLD,
     1   XLAMDA,UO,UEXP,VBP,UTRA,VMAX,XNEFF,XL,XW,VBI,VON,VDSAT,QSPOF,
     2   BETA0,BETA1,CDRAIN,XQCO,XQC,FNARRW,FSHORT,LEV
C SPICE VERSION 2G.6  SCCSID=STATUS 3/15/83
      COMMON /STATUS/ OMEGA,TIME,DELTA,DELOLD(7),AG(7),VT,XNI,EGFET,
     1   XMU,SFACTR,MODE,MODEDC,ICALC,INITF,METHOD,IORD,MAXORD,NONCON,
     2   ITERNO,ITEMNO,NOSOLV,MODAC,IPIV,IVMFLG,IPOSTP,ISCRCH,IOFILE
C SPICE VERSION 2G.6  SCCSID=KNSTNT 3/15/83
      COMMON /KNSTNT/ TWOPI,XLOG2,XLOG10,ROOT2,RAD,BOLTZ,CHARGE,CTOK,
     1   GMIN,RELTOL,ABSTOL,VNTOL,TRTOL,CHGTOL,EPS0,EPSSIL,EPSOX,
     2   PIVTOL,PIVREL
C
      DIMENSION A4(4),B4(4),X4(8),POLY4(8),SIG1(4),SIG2(4)
      DATA SIG1 / 1.0D0, -1.0D0, 1.0D0, -1.0D0/,
     1     SIG2 / 1.0D0,  1.0D0,-1.0D0, -1.0D0/
C
C     ICHARG=1 CAUSES CHARGES TO BE COMPUTED
C     ICHARG=0 BYPASSES THE COMPUTATION OF CHARGES
C
      ICHARG=1
      IF (MODE.NE.1.AND.XQCO.LE.0.5D0) GO TO 100
      ICHARG=0
      IF (XQCO.GT.0.5D0) GO TO 100
      IF (MODEDC.EQ.2.AND.NOSOLV.NE.0) ICHARG=1
      IF (INITF.EQ.4) ICHARG=1
C
C  COMPUTE SOME USEFUL QUANTITIES
C
  100 IF (VBS.GT.0.0D0) GO TO 110
      SARG=DSQRT(PHI-VBS)
      TSARG=SARG+SARG
      DSRGDB=-0.5D0/SARG
      D2SDB2=+0.5D0*DSRGDB/(PHI-VBS)
      GO TO 120
  110 SPHI=DSQRT(PHI)
      SPHI3=PHI*SPHI
      SARG=SPHI/(1.0D0+0.5D0*VBS/PHI)
      TSARG=SARG+SARG
      DSRGDB=-0.5D0*SARG*SARG/SPHI3
      D2SDB2=-DSRGDB*SARG/SPHI3
  120 IF ((VDS-VBS).LT.0.0D0) GO TO 130
      BARG=DSQRT(PHI+VDS-VBS)
      DBRGDB=-0.5D0/BARG
      D2BDB2=+0.5D0*DBRGDB/(PHI+VDS-VBS)
      GO TO 200
  130 BARG=SPHI/(1.0D0+0.5D0*(VBS-VDS)/PHI)
      DBRGDB=-0.5D0*BARG*BARG/SPHI3
      D2BDB2=-DBRGDB*BARG/SPHI3
C
C  CALCULATE THRESHOLD VOLTAGE (VON)
C     NARROW-CHANNEL EFFECT
C
  200 FACTOR=0.125D0*FNARRW*TWOPI*EPSSIL/COX*XL
      ETA=1.0D0+FACTOR
      VBIN=VBI+FACTOR*(PHI-VBS)
      IF (GAMMA.LE.0.0D0) GO TO 215
      IF (XNSUB.LE.0.0D0) GO TO 215
      XWD=XD*BARG
      XWS=XD*SARG
C
C     SHORT-CHANNEL EFFECT WITH VDS .NE. 0.0D0
C
      ARGSS=0.0D0
      ARGSD=0.0D0
      DBARGS=0.0D0
      DBARGD=0.0D0
      DGDVDS=0.0D0
      DGDDB2=0.0D0
      IF (XJ.LE.0.0D0) GO TO 205
      ARGXS=1.0D0+2.0D0*XWS/XJ
      ARGS=DSQRT(ARGXS)
      ARGSS=0.5D0*XJ/XL*(ARGS-1.0D0)
      ARGXD=1.0D0+2.0D0*XWD/XJ
      ARGD=DSQRT(ARGXD)
      ARGSD=0.5D0*XJ/XL*(ARGD-1.0D0)
  205 GAMASD=GAMMA*(1.0D0-ARGSS-ARGSD)
      GAMASS=GAMMA*(1.0D0-2.0D0*ARGSS)
      DBXWD=XD*DBRGDB
      DBXWS=XD*DSRGDB
      IF (XJ.LE.0.0D0) GO TO 210
      DBARGS=0.5D0/XL*DBXWS/ARGS
      DBARGD=0.5D0/XL*DBXWD/ARGD
      DASDB2=-XD*( D2SDB2+DSRGDB*DSRGDB*XD/(XJ*ARGXS) )/(XL*ARGS)
      DADDB2=-XD*( D2BDB2+DBRGDB*DBRGDB*XD/(XJ*ARGXD) )/(XL*ARGD)
      DGDDB2=-0.5D0*GAMMA*(DASDB2+DADDB2)
  210 DGDDVB=-GAMMA*(DBARGS+DBARGD)
      DGSDVB=-2.0D0*GAMMA*DBARGS
      IF (XJ.LE.0.0D0) GO TO 220
      DDXWD=-DBXWD
      DGDVDS=-GAMMA*0.5D0/XL*DDXWD/ARGD
      GO TO 220
  215 GAMASD=GAMMA
      GAMASS=GAMMA
      GAMMAD=GAMMA
      DGDDVB=0.0D0
      DGSDVB=0.0D0
      DGDVDS=0.0D0
      DGDDB2=0.0D0
  220 VON=VBIN+GAMASD*SARG
C     WRITE(IOFILE,221) VON,VBIN,VBI,GAMASD,ARGSS,ARGSD,XJ
  221 FORMAT ('0MSG1:'/1P7D10.2)
      VTH=VON
      VDSAT=0.0D0
  225 IF (XNFS.EQ.0.0D0.OR.COX.EQ.0.0D0) GO TO 230
      CFS=CHARGE*XNFS
      CDONCO=-(GAMASD*DSRGDB+DGDDVB*SARG)+FACTOR
      XN=1.0D0+CFS/COX*XW*XL+CDONCO
      VON=VON+VT*XN
C     WRITE (IOFILE,226) VON,CDONCO,XN,CFS,XD
  226 FORMAT(' MSG2:'/1P6D10.2)
      ARGG=1.0D0/(VT*XN)
      VGST=VGS-VON
      GO TO 300
  230 VGST=VGS-VON
      IF (VGS.GT.VON) GO TO 300
C
C  CUTOFF REGION
C
      GDS=0.0D0
      GO TO 1050
C
C  COMPUTE SOME MORE USEFUL QUANTITIES
C
  300 SARG3=SARG*SARG*SARG
      SBIARG=DSQRT(PHIB)
      GAMMAD=GAMASD
      DGDVBS=DGDDVB
      BODY=BARG*BARG*BARG-SARG3
      GDBDV=2.0D0*GAMMAD*(BARG*BARG*DBRGDB-SARG*SARG*DSRGDB)
      DODVBS=-FACTOR+DGDVBS*SARG+GAMMAD*DSRGDB
      IF (XNFS.EQ.0.0D0) GO TO 400
      IF (COX.EQ.0.0D0) GO TO 410
      DXNDVB=2.0D0*DGDVBS*DSRGDB+GAMMAD*D2SDB2+DGDDB2*SARG
      DODVBS=DODVBS+VT*DXNDVB
      DXNDVD=DGDVDS*DSRGDB
      DODVDS=DGDVDS*SARG+VT*DXNDVD
C
C  EVALUATE EFFECTIVE MOBILITY AND ITS DERIVATIVES
C
  400 IF (COX.LE.0.0D0) GO TO 410
      UDENOM=VGST
      IF (UDENOM.LE.VBP) GO TO 410
      UFACT=DEXP(UEXP*DLOG(VBP/UDENOM))
      UEFF=UO*UFACT
      DUDVGS=-UFACT*UEXP/UDENOM
      DUDVDS=0.0D0
      DUDVBS=UEXP*UFACT*DODVBS/VGST
      GO TO 500
  410 UFACT=1.0D0
      UEFF=UO
      DUDVGS=0.0D0
      DUDVDS=0.0D0
      DUDVBS=0.0D0
C
C     EVALUATE SATURATION VOLTAGE AND ITS DERIVATIVES ACCORDING TO
C     GROVE-FROHMAN EQUATION
C
  500 VGSX=VGS
      GAMMAD=GAMASD/ETA
      DGDVBS=DGDDVB
      IF (XNFS.NE.0.0D0.AND.COX.NE.0.0D0)
     1   VGSX=DMAX1(VGS,VON)
  505 IF (GAMMAD.LE.0.0D0) GO TO 535
      GAMMD2=GAMMAD*GAMMAD
      ARGV=(VGSX-VBIN)/ETA+PHI-VBS
      IF (ARGV.LE.0.0D0) GO TO 540
      ARG=DSQRT(1.0D0+4.0D0*ARGV/GAMMD2)
      VDSAT=(VGSX-VBIN)/ETA+GAMMD2*(1.0D0-ARG)/2.0D0
      VDSAT=DMAX1(VDSAT,0.0D0)
  510 IF (ICHARG.EQ.0) GO TO 530
      ARG1=GAMMD2/(ETA*ETA)
      ARG2=VDS-0.5D0*ARG1
      ARGSQ=(ARG2+0.5D0*ARG1+PHI-VBS)*ARG1
      IF (ARGSQ.GE.0.0D0) GO TO 515
      VPOF=VTH
      GO TO 520
  515 VPOF=VBIN+ETA*(ARG2+0.5D0*ARG1+DSQRT(ARGSQ))
  520 ARGV1=(VPOF-VBIN)/ETA+PHI-VBS
      IF (ARGV1.GT.0.0D0) GO TO 525
      VDSAT1=0.0D0
      GO TO 530
  525 ARG1=DSQRT(1.0D0+4.0D0*ARGV1/GAMMD2)
      VDSAT1=(VPOF-VBIN)/ETA+GAMMD2*(1.0D0-ARG1)/2.0D0
      VDSAT1=DMAX1(VDSAT1,0.0D0)
  530 DSDVGS=(1.0D0-1.0D0/ARG)/ETA
      DSDVBS=(GAMMAD*(1.0D0-ARG)+2.0D0*ARGV/(GAMMAD*ARG))/ETA*DGDVBS+
     1       1.0D0/ARG+FACTOR*DSDVGS
      GO TO 545
  535 VDSAT=DMAX1((VGSX-VBIN)/ETA,0.0D0)
      VPOF=DMAX1((ETA*VDS+VBIN),0.0D0)
      VDSAT1=DMAX1((VPOF-VBIN)/ETA,0.0D0)
      DSDVGS=1.0D0
      DSDVBS=0.0D0
      GO TO 545
  540 VDSAT=0.0D0
      VPOF=VTH
      VDSAT1=0.0D0
      DSDVGS=0.0D0
      DSDVBS=0.0D0
C
C     STORE VDSAT AS ABOVE IN VPOF (PINCH-OFF)
C
  545 IF (VMAX.LE.0.0D0) GO TO 600
C
C     EVALUATE SATURATION VOLTAGE AND ITS DERIVATIVES ACCORDING TO
C     BAUM'S THEORY OF SCATTERING VELOCITY SATURATION
C
      GAMMD2=GAMMAD*GAMMAD
      V1=(VGSX-VBIN)/ETA+PHI-VBS
      V2=PHI-VBS
      XV=VMAX*XL/UEFF
      A1=GAMMAD/0.75D0
      B1=-2.0D0*(V1+XV)
      C1=-2.0D0*GAMMAD*XV
      D1=2.0D0*V1*(V2+XV)-V2*V2-4.0D0/3.0D0*GAMMAD*SARG3
      A=-B1
      B=A1*C1-4.0D0*D1
      C=-D1*(A1*A1-4.0D0*B1)-C1*C1
      R=-A*A/3.0D0+B
      S=2.0D0*A*A*A/27.0D0-A*B/3.0D0+C
      R3=R*R*R
      S2=S*S
      P=S2/4.0D0+R3/27.0D0
      P0=DABS(P)
      P2=DSQRT(P0)
      IF (P.GE.0.0D0) GO TO 550
      RO=DSQRT(S2/4.0D0+P0)
      RO=DLOG(RO)/3.0D0
      RO=DEXP(RO)
      FI=DATAN(-2.0D0*P2/S)
      Y3=2.0D0*RO*DCOS(FI/3.0D0)-A/3.0D0
      GO TO 560
  550 P3=DEXP(DLOG(DABS(-S/2.0D0+P2))/3.0D0)
      P4=DEXP(DLOG(DABS(-S/2.0D0-P2))/3.0D0)
      Y3=P3+P4-A/3.0D0
  560 IKNT=0
      A3=DSQRT(A1*A1/4.0D0-B1+Y3)
      B3=DSQRT(Y3*Y3/4.0D0-D1)
      DO 570 I=1,4
      A4(I)=A1/2.0D0+SIG1(I)*A3
      B4(I)=Y3/2.0D0+SIG2(I)*B3
      DELTA4=A4(I)*A4(I)/4.0D0-B4(I)
      IF (DELTA4.LT.0.0D0) GO TO 570
      IKNT=IKNT+1
      X4(IKNT)=-A4(I)/2.0D0+DSQRT(DELTA4)
      IKNT=IKNT+1
      X4(IKNT)=-A4(I)/2.0D0-DSQRT(DELTA4)
  570 CONTINUE
      JKNT=0
      DO 580 J=1,IKNT
      IF (X4(J).LE.0.0D0) GO TO 580
      POLY4(J)=X4(J)*X4(J)*X4(J)*X4(J)+A1*X4(J)*X4(J)*X4(J)
      POLY4(J)=POLY4(J)+B1*X4(J)*X4(J)+C1*X4(J)+D1
      IF (DABS(POLY4(J)).GT.1.0D-6) GO TO 580
      JKNT=JKNT+1
      IF (JKNT.GT.1) GO TO 575
      XVALID=X4(J)
  575 IF (X4(J).GT.XVALID) GO TO 580
      XVALID=X4(J)
  580 CONTINUE
      IF (JKNT.GT.0) GO TO 590
      IVMFLG=IVMFLG+1
      GO TO 600
  590 VDSAT=XVALID*XVALID+VBS-PHI
C
C  EVALUATE EFFECTIVE CHANNEL LENGTH AND ITS DERIVATIVES
C
  600 IF (VDS.EQ.0.0D0) GO TO 610
      GAMMAD=GAMASD
      IF ((VBS-VDSAT).GT.0.0D0) GO TO 601
      BSARG=DSQRT(VDSAT-VBS+PHI)
      DBSRDB=-0.5D0/BSARG
      GO TO 602
  601 BSARG=SPHI/(1.0D0+0.5D0*(VBS-VDSAT)/PHI)
      DBSRDB=-0.5D0*BSARG*BSARG/SPHI3
  602 BODYS=BSARG*BSARG*BSARG-SARG3
      GDBDVS=2.0D0*GAMMAD*(BSARG*BSARG*DBSRDB-SARG*SARG*DSRGDB)
      IF (VMAX.GT.0.0D0) GO TO 603
      IF (XNSUB.EQ.0.0D0) GO TO 610
      IF (XLAMDA.GT.0.0D0) GO TO 610
      ARGV=(VDS-VDSAT)/4.0D0
      SARGV=DSQRT(1.0D0+ARGV*ARGV)
      ARG=DSQRT(ARGV+SARGV)
      XLFACT=XD/(XL*VDS)
      XLAMDA=XLFACT*ARG
      DLDSAT=VDS*XLFACT*ARG/(8.0D0*SARGV)
      GO TO 605
  603 ARGV=(VGSX-VBIN)/ETA-VDSAT
      XDV=XD/DSQRT(XNEFF)
      XLV=VMAX*XDV/(2.0D0*UEFF)
      VQCHAN=ARGV-GAMMAD*BSARG
      DQDSAT=-1.0D0+GAMMAD*DBSRDB
      VL=VMAX*XL
      DFUNDS=VL*DQDSAT-UEFF*VQCHAN
      DFUNDG=(VL-UEFF*VDSAT)/ETA
      DFUNDB=-VL*(1.0D0+DQDSAT-FACTOR/ETA)+
     1        UEFF*(GDBDVS-DGDVBS*BODYS/1.5D0)/ETA
      DSDVGS=-DFUNDG/DFUNDS
      DSDVBS=-DFUNDB/DFUNDS
      IF (XNSUB.EQ.0.0D0) GO TO 610
      IF (XLAMDA.GT.0.0D0) GO TO 610
      ARGV=DMAX1(VDS-VDSAT,0.0D0)
      XLS=DSQRT(XLV*XLV+ARGV)
      DLDSAT=XDV/(2.0D0*XLS)
      XLFACT=XDV/(XL*VDS)
      XLAMDA=XLFACT*(XLS-XLV)
      DLDSAT=DLDSAT/XL
  605 DLDVGS=DLDSAT*DSDVGS
      DLDVDS=-XLAMDA+DLDSAT
      DLDVBS=DLDSAT*DSDVBS
      GO TO 620
  610 DLDVGS=0.0D0
      DLDVDS=0.0D0
      DLDVBS=0.0D0
C
C     LIMIT CHANNEL SHORTENING AT PUNCH-THROUGH
C
  620 XWB=XD*SBIARG
      XLD=XL-XWB
      CLFACT=1.0D0-XLAMDA*VDS
      DLDVDS=-XLAMDA-DLDVDS
      XLEFF=XL*CLFACT
      DELTAL=XLAMDA*VDS*XL
      IF (XNSUB.EQ.0.0D0) XWB=0.25D-6
      IF (XLEFF.GE.XWB) GO TO 700
      XLEFF=XWB/(1.0D0+(DELTAL-XLD)/XWB)
      CLFACT=XLEFF/XL
      DFACT=XLEFF*XLEFF/(XWB*XWB)
      DLDVGS=DFACT*DLDVGS
      DLDVDS=DFACT*DLDVDS
      DLDVBS=DFACT*DLDVBS
C
C  EVALUATE EFFECTIVE BETA (EFFECTIVE KP)
C
  700 BETA1=BETA*UFACT/CLFACT
C
C  TEST FOR MODE OF OPERATION AND BRANCH APPROPRIATELY
C
      GAMMAD=GAMASD
      DGDVBS=DGDDVB
      IF (VDS.GT.1.0D-8) GO TO 730
      IF (VGS.GT.VON) GO TO 720
      IF ((XNFS.NE.0.0D0).AND.(COX.NE.0.0D0)) GO TO 710
      GDS=0.0D0
      GO TO 1050
C
  710 GDS=BETA1*(VON-VBIN-GAMMAD*SARG)*DEXP(ARGG*(VGS-VON))
      GO TO 1050
C
C
  720 GDS=BETA1*(VGS-VBIN-GAMMAD*SARG)
      GO TO 1050
C
  730 IF (VGS.GT.VON) GO TO 900
C
C  SUBTHRESHOLD REGION
C
      IF (VDSAT.GT.0.0D0) GO TO 830
      GDS=0.0D0
      IF (VGS.GT.VTH) GO TO 1020
      GO TO 1050
  830 VDSON=DMIN1(VDSAT,VDS)
      IF (VDS.LE.VDSAT) GO TO 850
      BARG=BSARG
      DBRGDB=DBSRDB
      BODY=BODYS
      GDBDV=GDBDVS
  850 CDSON=BETA1*((VON-VBIN-ETA*VDSON*0.5D0)*VDSON-GAMMAD*BODY/1.5D0)
      DIDVDS=BETA1*(VON-VBIN-ETA*VDSON-GAMMAD*BARG)
      GDSON=-CDSON*DLDVDS/CLFACT-BETA1*DGDVDS*BODY/1.5D0
      IF (VDS.LT.VDSAT) GDSON=GDSON+DIDVDS
      GBSON=-CDSON*DLDVBS/CLFACT
     1      +BETA1*(DODVBS*VDSON+FACTOR*VDSON-DGDVBS*BODY/1.5D0-GDBDV)
      IF (VDS.GT.VDSAT) GBSON=GBSON+DIDVDS*DSDVBS
      EXPG=DEXP(ARGG*(VGS-VON))
      CDRAIN=CDSON*EXPG
      GMW=CDRAIN*ARGG
      GM=GMW
      IF (VDS.GT.VDSAT) GM=GMW+DIDVDS*DSDVGS*EXPG
      GDS=GDSON*EXPG-GM*DODVDS-GMW*(VGS-VON)*DXNDVD/XN
      GMBS=GBSON*EXPG-GM*DODVBS-GMW*(VGS-VON)*DXNDVB/XN
      GO TO 1020
C
C
  900 IF (VDS.GT.VDSAT) GO TO 1000
C
C  LINEAR REGION
C
      CDRAIN=BETA1*((VGS-VBIN-ETA*VDS/2.0D0)*VDS-GAMMAD*BODY/1.5D0)
      ARG=CDRAIN*(DUDVGS/UFACT-DLDVGS/CLFACT)
      GM=ARG+BETA1*VDS
      ARG=CDRAIN*(DUDVDS/UFACT-DLDVDS/CLFACT)
      GDS=ARG+BETA1*(VGS-VBIN-ETA*VDS-
     1   GAMMAD*BARG-DGDVDS*BODY/1.5D0)
      ARG=CDRAIN*(DUDVBS/UFACT-DLDVBS/CLFACT)
      GMBS=ARG-BETA1*(GDBDV+DGDVBS*BODY/1.5D0-FACTOR*VDS)
      GO TO 1020
C
C  SATURATION REGION
C
 1000 CDRAIN=BETA1*((VGS-VBIN-ETA*VDSAT/2.0D0)*VDSAT-GAMMAD*BODYS/1.5D0)
      ARG=CDRAIN*(DUDVGS/UFACT-DLDVGS/CLFACT)
      GM=ARG+BETA1*VDSAT+
     1   BETA1*(VGS-VBIN-ETA*VDSAT-GAMMAD*BSARG)*DSDVGS
      GDS=-CDRAIN*DLDVDS/CLFACT-BETA1*DGDVDS*BODYS/1.5D0
      ARG=CDRAIN*(DUDVBS/UFACT-DLDVBS/CLFACT)
      GMBS=ARG-BETA1*(GDBDVS+DGDVBS*BODYS/1.5D0-FACTOR*VDSAT)+
     1     BETA1*(VGS-VBIN-ETA*VDSAT-GAMMAD*BSARG)*DSDVBS
C
C     COMPUTE CHARGES FOR "ON" REGION
C
 1020 IF (ICHARG.EQ.0) GO TO 1500
      IF (VGS.LE.VTH) GO TO 1070
      CALL MQSPOF(VDS,VBS,VGS,VPOF,VDSAT1,VTH,VBIN,GAMASD,
     1   QG,QC,QB,CGGB,CGDB,CGSB,CBGB,CBDB,CBSB)
      GO TO 2000
C
C  FINISH SPECIAL CASES
C
 1050 CDRAIN=0.0D0
      GM=0.0D0
      GMBS=0.0D0
 1070 XQC=XQCO
      IF (ICHARG.EQ.0) GO TO 1500
      CALL MOSQ2(VDS,VBS,VGS,VDSAT,VTH,VBIN,GAMASD,COX,PHI,
     1   QG,QC,QB,CGGB,CGDB,CGSB,CBGB,CBDB,CBSB)
      QSPOF=0.0D0
      GO TO 2000
C
C  FINISHED
C
 1500 QG=0.0D0
      QB=0.0D0
      QC=0.0D0
      QSPOF=0.0D0
 2000 RETURN
      END
