      SUBROUTINE MOSEQ3(VDS,VBS,VGS,GM,GDS,GMBS,
     1   QG,QC,QB,CGGB,CGDB,CGSB,CBGB,CBDB,CBSB)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE EVALUATES THE DRAIN CURRENT, ITS DERIVATIVES AND
C     THE CHARGES ASSOCIATED WITH THE GATE, CHANNEL AND BULK
C     FOR MOSFETS BASED ON SEMI-EMPIRICAL EQUATIONS
C
C SPICE VERSION 2G.6  SCCSID=MOSARG 3/15/83
      COMMON /MOSARG/ VTO,BETA,GAMMA,PHI,PHIB,COX,XNSUB,XNFS,XD,XJ,XLD,
     1   XLAMDA,UO,UEXP,VBP,UTRA,VMAX,XNEFF,XL,XW,VBI,VON,VDSAT,QSPOF,
     2   BETA0,BETA1,CDRAIN,XQCO,XQC,FNARRW,FSHORT,LEV
C SPICE VERSION 2G.6  SCCSID=STATUS 3/15/83
      COMMON /STATUS/ OMEGA,TIME,DELTA,DELOLD(7),AG(7),VT,XNI,EGFET,
     1   XMU,SFACTR,MODE,MODEDC,ICALC,INITF,METHOD,IORD,MAXORD,NONCON,
     2   ITERNO,ITEMNO,NOSOLV,MODAC,IPIV,IVMFLG,IPOSTP,ISCRCH,IOFILE
C SPICE VERSION 2G.6  SCCSID=KNSTNT 3/15/83
      COMMON /KNSTNT/ TWOPI,XLOG2,XLOG10,ROOT2,RAD,BOLTZ,CHARGE,CTOK,
     1   GMIN,RELTOL,ABSTOL,VNTOL,TRTOL,CHGTOL,EPS0,EPSSIL,EPSOX,
     2   PIVTOL,PIVREL
C
      EQUIVALENCE (XLAMDA,ALPHA),(VBP,THETA),(UEXP,ETA),(UTRA,XKAPPA)
      DATA COEFF0/0.0631353D0/,COEFF1/0.8013292D0/,COEFF2/-0.01110777D0/
C
C     ICHARG=1 CAUSES CHARGES TO BE COMPUTED
C     ICHARG=0 BYPASSES THE COMPUTATION OF CHARGES
C
C     ICHARG=1
C     IF (MODE.NE.1) GO TO 10
C     ICHARG=0
C     IF (MODEDC.EQ.2.AND.NOSOLV.NE.0) ICHARG=1
C     IF (INITF.EQ.4) ICHARG=1
C
C     REFERENCE CDRAIN EQUATIONS TO SOURCE AND
C     CHARGE EQUATIONS TO BULK
C
10    CONTINUE
      ICHARG=0
      VGB=VGS-VBS
      VFB=VBI-PHI
      VDSAT=0.0D0
      QG=0.0D0
      QB=0.0D0
      QC=0.0D0
      CGDB=0.0D0
      CBDB=0.0D0
      ONXL=1.0D0/XL
      ETA=ETA/(XL*XL*XL)
C
C.....SQUARE ROOT TERM
C
      IF ( VBS.GT.0.0D0 ) GO TO 120
      PHIBS=PHI-VBS
      SQPHBS=DSQRT(PHIBS)
      DSQDVB=-0.5D0/SQPHBS
      GO TO 200
120   CONTINUE
      SQPHIS=DSQRT(PHI)
      SQPHS3=PHI*SQPHIS
      SQPHBS=SQPHIS/(1.0D0+VBS/(PHI+PHI))
      PHIBS=SQPHBS*SQPHBS
      DSQDVB=-PHIBS/(SQPHS3+SQPHS3)
C
C.....SHORT CHANNEL EFFECT FACTOR
C
200   CONTINUE
      IF ( (XJ.EQ.0.0D0).OR.(XD.EQ.0.0D0) ) GO TO 210
      WPS=XD*SQPHBS
      ONXJ=1.0D0/XJ
      XJONXL=XJ*ONXL
      DJONXJ=XLD*ONXJ
      WPONXJ=WPS*ONXJ
      WCONXJ=COEFF0+COEFF1*WPONXJ+COEFF2*WPONXJ*WPONXJ
      WCS=WCONXJ*XJ
      ARGA=WCONXJ+DJONXJ
      ARGC=WPONXJ/(1.0D0+WPONXJ)
      ARGB=DSQRT(1.0D0-ARGC*ARGC)
      FSHORT=1.0D0-XJONXL*(ARGA*ARGB-DJONXJ)
      DWPDVB=XD*DSQDVB
      DADVB=(COEFF1+COEFF2*(WPONXJ+WPONXJ))*DWPDVB*ONXJ
      DBDVB=-ARGC*ARGC*(1.0D0-ARGC)*DWPDVB/(ARGB*WPS)
      DFSDVB=-XJONXL*(DADVB*ARGB+ARGA*DBDVB)
      GO TO 220
210   CONTINUE
      FSHORT=1.0D0
      DFSDVB=0.0D0
      WCS=0.05D-6
C
C.....BODY EFFECT
C
220   CONTINUE
      GAMMAS=GAMMA*FSHORT
      FBODYS=0.5D0*GAMMAS/(SQPHBS+SQPHBS)
      FBODY=FBODYS+FNARRW
      ONFBDY=1.0D0/(1.0D0+FBODY)
      DFBDVB=-FBODYS*DSQDVB/SQPHBS+FBODYS*DFSDVB/FSHORT
      QBONCO=GAMMAS*SQPHBS+FNARRW*PHIBS
      DQBDVB=GAMMAS*DSQDVB+GAMMA*DFSDVB*SQPHBS-FNARRW
C
C.....STATIC FEEDBACK EFFECT
C
      VBIX=VBI-ETA*VDS
C
C.....THRESHOLD VOLTAGE
C
      VTH=VBIX+QBONCO
      DVTDVD=-ETA
      DVTDVB=DQBDVB
C
C.....JOINT WEAK INVERSION AND STRONG INVERSION
C
      VON=VTH
      IF ( XNFS.EQ.0.0D0 ) GO TO 250
           CSONCO=CHARGE*XNFS*XL*XW/COX
           CDONCO=QBONCO/(PHIBS+PHIBS)
           XN=1.0D0+CSONCO+CDONCO
           VON=VTH+VT*XN
           DXNDVB=DQBDVB/(PHIBS+PHIBS)-QBONCO*DSQDVB/(PHIBS*SQPHBS)
           DVODVD=DVTDVD
           DVODVB=DVTDVB+VT*DXNDVB
           GO TO 300
C
C.....CUTOFF REGION
C
250   CONTINUE
      IF ( VGS.GT.VON ) GO TO 300
      CDRAIN=0.0D0
      GM=0.0D0
      GDS=0.0D0
      GMBS=0.0D0
      IF ( ICHARG.NE.0 ) GO TO 800
      GO TO 1000
C
C.....DEVICE IS ON
C
300   CONTINUE
      VGSX=DMAX1(VGS,VON)
C
C.....MOBILITY MODULATION BY GATE VOLTAGE
C
      ONFG=1.0D0+THETA*(VGSX-VTH)
      FGATE=1.0D0/ONFG
      US=UO*FGATE
      DFGDVG=-THETA*FGATE*FGATE
      DFGDVD=-DFGDVG*DVTDVD
      DFGDVB=-DFGDVG*DVTDVB
C
C.....SATURATION VOLTAGE
C
      VDSAT=(VGSX-VTH)*ONFBDY
      VPOF=VDSAT
      IF ( VMAX.GT.0.0D0 ) GO TO 310
      DVSDVG=ONFBDY
      DVSDVD=-DVSDVG*DVTDVD
      DVSDVB=-DVSDVG*DVTDVB-VDSAT*DFBDVB*ONFBDY
      GO TO 400
  310 VDSC=XL*VMAX/US
      ONVDSC=1.0D0/VDSC
      ARGA=(VGSX-VTH)*ONFBDY
      ARGB=DSQRT(ARGA*ARGA+VDSC*VDSC)
      VDSAT=ARGA+VDSC-ARGB
      DVSDGA=(1.0D0-ARGA/ARGB)*ONFBDY
      DVSDVG=DVSDGA-(1.0D0-VDSC/ARGB)*VDSC*DFGDVG*ONFG
      DVSDVD=-DVSDVG*DVTDVD
      DVSDVB=-DVSDVG*DVTDVB-ARGA*DVSDGA*DFBDVB
C
C.....CURRENT FACTORS IN LINEAR REGION
C
400   CONTINUE
      VDSX=DMIN1(VDS,VDSAT)
      IF ( VDSX.EQ.0.0D0 ) GO TO 900
      CDO=VGSX-VTH-0.5D0*(1.0D0+FBODY)*VDSX
      DCODVG=1.0D0
      IF (VDS.LT.VDSAT) DCODVD=-DVTDVD-0.5D0*(1.0D0+FBODY)
      DCODVB=-DVTDVB-0.5D0*DFBDVB*VDSX
C
C.....NORMALIZED DRAIN CURRENT
C
410   CONTINUE
      CDNORM=CDO*VDSX
      GM=VDSX
      GDS=VGSX-VTH-(1.0D0+FBODY+DVTDVD)*VDSX
      GMBS=DCODVB*VDSX
C
C.....DRAIN CURRENT WITHOUT VELOCITY SATURATION EFFECT
C
      CD1=BETA*CDNORM
      BETA=BETA*FGATE
      CDRAIN=BETA*CDNORM
      GM=BETA*GM+DFGDVG*CD1
      GDS=BETA*GDS+DFGDVD*CD1
      GMBS=BETA*GMBS
C
C.....VELOCITY SATURATION FACTOR
C
      IF ( VMAX.EQ.0.0D0 ) GO TO 500
      FDRAIN=1.0D0/(1.0D0+VDSX*ONVDSC)
      FD2=FDRAIN*FDRAIN
      ARGA=FD2*VDSX*ONVDSC*ONFG
      DFDDVG=-DFGDVG*ARGA
      DFDDVD=-DFGDVD*ARGA-FD2*ONVDSC
      DFDDVB=-DFGDVB*ARGA
C
C.....DRAIN CURRENT
C
      GM=FDRAIN*GM+DFDDVG*CDRAIN
      GDS=FDRAIN*GDS+DFDDVD*CDRAIN
      GMBS=FDRAIN*GMBS+DFDDVB*CDRAIN
      CDRAIN=FDRAIN*CDRAIN
      BETA=BETA*FDRAIN
C
C.....CHANNEL LENGTH MODULATION
C
500   CONTINUE
      IF ( VDS.LE.VDSAT ) GO TO 700
      IF ( VMAX.EQ.0.0D0 ) GO TO 510
      IF (ALPHA.EQ.0.0D0) GO TO 700
      CDSAT=CDRAIN
      GDSAT=CDSAT*(1.0D0-FDRAIN)*ONVDSC
      GDSAT=DMAX1(1.0D-12,GDSAT)
      GDONCD=GDSAT/CDSAT
      GDONFD=GDSAT/(1.0D0-FDRAIN)
      GDONFG=GDSAT*ONFG
      DGDVG=GDONCD*GM-GDONFD*DFDDVG+GDONFG*DFGDVG
      DGDVD=GDONCD*GDS-GDONFD*DFDDVD+GDONFG*DFGDVD
      DGDVB=GDONCD*GMBS-GDONFD*DFDDVB+GDONFG*DFGDVB
C
      EMAX=CDSAT*ONXL/GDSAT
      EMONCD=EMAX/CDSAT
      EMONGD=EMAX/GDSAT
      DEMDVG=EMONCD*GM-EMONGD*DGDVG
      DEMDVD=EMONCD*GDS-EMONGD*DGDVD
      DEMDVB=EMONCD*GMBS-EMONGD*DGDVB
C
      ARGA=0.5D0*EMAX*ALPHA
      ARGC=XKAPPA*ALPHA
      ARGB=DSQRT(ARGA*ARGA+ARGC*(VDS-VDSAT))
      DELXL=ARGB-ARGA
      DLDVD=ARGC/(ARGB+ARGB)
      DLDEM=0.5D0*(ARGA/ARGB-1.0D0)*ALPHA
      DDLDVG=DLDEM*DEMDVG
      DDLDVD=DLDEM*DEMDVD-DLDVD
      DDLDVB=DLDEM*DEMDVB
      GO TO 520
510   CONTINUE
      DELXL=DSQRT(XKAPPA*(VDS-VDSAT)*ALPHA)
      DLDVD=0.5D0*DELXL/(VDS-VDSAT)
      DDLDVG=0.0D0
      DDLDVD=-DLDVD
      DDLDVB=0.0D0
C
C.....PUNCH THROUGH APPROXIMATION
C
520   CONTINUE
      IF ( DELXL.LE.(0.5D0*XL) ) GO TO 600
      WCS2=WCS*WCS
      DELXL=XL-(XL**2/(4.0D0*DELXL))
      ARGA=4.0D0*(XL-DELXL)**2/XL**2
      DDLDVG=DDLDVG*ARGA
      DDLDVD=DDLDVD*ARGA
      DDLDVB=DDLDVB*ARGA
       DLDVD= DLDVD*ARGA
C
C.....SATURATION REGION
C
600   CONTINUE
      DLONXL=DELXL*ONXL
      XLFACT=1.0D0/(1.0D0-DLONXL)
      CDRAIN=CDRAIN*XLFACT
      DIDDL=CDRAIN/(XL-DELXL)
      GM=GM*XLFACT+DIDDL*DDLDVG
      GDS0=GDS*XLFACT+DIDDL*DDLDVD
      GMBS=GMBS*XLFACT+DIDDL*DDLDVB
      GM=GM+GDS0*DVSDVG
      GMBS=GMBS+GDS0*DVSDVB
      GDS=GDS0*DVSDVD+DIDDL*DLDVD
C
C.....FINISH STRONG INVERSION CASE
C
700   CONTINUE
      IF ( VGS.GE.VON ) GO TO 750
C
C.....WEAK INVERSION
C
                ONXN=1.0D0/XN
                ONDVT=ONXN/VT
                WFACT=DEXP( (VGS-VON)*ONDVT )
                CDRAIN=CDRAIN*WFACT
                GMS=GM*WFACT
                GMW=CDRAIN*ONDVT
                GM=GMW
                IF (VDS.GT.VDSAT) GM=GM+GDS0*DVSDVG*WFACT
                GDS=GDS*WFACT+(GMS-GMW)*DVODVD
                GMBS=GMBS*WFACT+(GMS-GMW)*DVODVB
     1                         -GMW*(VGS-VON)*ONXN*DXNDVB
C
C.....CHARGE COMPUTATION
C
  750 CONTINUE
      IF (ICHARG.EQ.0) GO TO 1000
      IF (VGS.LE.VTH) GO TO 800
      CALL MQSPOF(VDS,VBS,VGS,VPOF,VDSAT1,VTH,VBIN,GAMASD,
     1   QG,QC,QB,CGGB,CGDB,CGSB,CBGB,CBDB,CBSB)
      GO TO 2000
C
C.....CHARGE COMPUTATION FOR VGS<VTH
C
800   CONTINUE
      XQC=XQCO
      CALL MOSQ3(VDS,VBS,VPOF,VDSAT1,VTH,VBIN,GAMASD,COX,PHI,
     1   QG,QC,QB,CGGB,CGDB,CGSB,CBGB,CBDB,CBSB)
      QSPOF=0.0D0
      GO TO 2000
C
C.....SPECIAL CASE OF VDS=0.0D0
C
900   CONTINUE
      BETA=BETA*FGATE
      CDRAIN=0.0D0
      GM=0.0D0
      GDS=BETA*(VGSX-VTH)
      GMBS=0.0D0
           IF ( (XNFS.NE.0.0D0).AND.(VGS.LT.VON) )
     1          GDS=GDS*DEXP((VGS-VON)/(VT*XN))
      IF (ICHARG.EQ.0) GO TO 1000
      CALL MOSQ3(VDS,VBS,VPOF,VDSAT1,VTH,VBIN,GAMASD,COX,PHI,
     1   QG,QC,QB,CGGB,CGDB,CGSB,CBGB,CBDB,CBSB)
1000  QSPOF=0.0D0
C
C.....DONE
C
 2000 RETURN
      END
