      SUBROUTINE MOSQ3(VDS,VBS,VGS,VDSAT,VTH,VBIN,GAMASD,COX,PHI,
     1   QG,QC,QB,CGGB,CGDB,CGSB,CBGB,CBDB,CBSB)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      EQUIVALENCE (XLAMDA,ALPHA),(VBP,THETA),(UEXP,ETA),(UTRA,XKAPPA)
C
C     CHARGE EQUATIONS ARE REFERENCED TO BULK
C
      VGB=VGS-VBS
      VFB=VBI-PHI
      ONXL=1.0D0/XL
      PHIBS=SQPHBS*SQPHBS
C
C     BODY EFFECT
C
      GAMMAS=GAMMA*FSHORT
      FBODYS=GAMMAS/(SQPHBS+SQPHBS)*0.5D0
      FBODY=FBODYS+FNARRW
      ONFBDY=1.0D0/(1.0D0+FBODY)
      DFBDVB=-FBODYS*DSQDVB/SQPHBS+FBODYS*DFSDVB/FSHORT
      QBONCO=GAMMAS*SQPHBS+FNARRW*PHIBS
      DQBDVB=GAMMAS*DSQDVB+GAMMA*DFSDVB*SQPHBS-FNARRW
C
C.....STATIC FEEDBACK EFFECT
C
      VBIX=VBI-ETA*VDS
C
C.....THRESHOLD VOLTAGE
C
      VTH=VBIX+QBONCO
      DVTDVD=-ETA
      DVTDVB=DQBDVB
C
C     BRANCH ACCORDING TO REGION OF OPERATION
C
      IF (VGS.LE.VTH) GO TO 800
      VGSX=DMAX1(VGS,VON)
C
C     BRANCH ON VDS=0.0D0
C
      VDSX=DMIN1(VDS,VDSAT)
      IF ( VDSX.EQ.0.0D0 ) GO TO 900
      CDO=VGSX-VTH-0.5D0*(1.0D0+FBODY)*VDSX
      DCODVG=1.0D0
      IF (VDS.LT.VDSAT) DCODVD=-DVTDVD-0.5D0*(1.0D0+FBODY)
      DCODVB=-DVTDVB-0.5D0*DFBDVB*VDSX
C
C.....CHARGE TERMS
C
420   CONTINUE
      ARGA=(1.0D0+FBODY)*VDSX*VDSX/(12.0D0*CDO)
      DADCO=-ARGA/CDO
      IF (VDS.LT.VDSAT) DADVD=ARGA/VDSX
      DADFB=ARGA*ONFBDY
C
C.....GATE CHARGE
C
      QG=COX*(VGS-VBIX-0.5D0*VDSX+ARGA)
      CGGB=COX*(1.0D0+DADCO*DCODVG)
      IF (VDS.LT.VDSAT) CGDB=COX*(-DVTDVD-0.5D0+DADVD+DADCO*DCODVD)
      CGSB=-CGGB-CGDB-COX*(DADCO*DCODVB+DADFB*DFBDVB)
C
C.....BULK CHARGE
C
      ARGA=ARGA*FBODY
      DADCO=DADCO*FBODY
      IF (VDS.LT.VDSAT) DADVD=DADVD*FBODY
      DADFB=DADFB*(1.0D0+FBODY+FBODY)
C
      QB=-COX*(QBONCO+0.5D0*FBODY*VDSX-ARGA)
      CBGB=COX*DADCO*DCODVG
      IF (VDS.LT.VDSAT) CBDB=-COX*(0.5D0*FBODY-DADVD-DADCO*DCODVD)
      CBSB=-CBGB-CBDB
     1          +COX*(DQBDVB+(0.5D0*VDSX-DADFB)*DFBDVB-DADCO*DCODVB)
      GO TO 1000
C
C.....CHARGE TERMS OF VGS<VTH
C
800   CONTINUE
      IF ( VGB.GT.VFB ) GO TO 810
      QG=COX*(VGB-VFB)
      CGGB=COX
      GO TO  820
810   CONTINUE
      GAMMA2=GAMMAS*0.5D0
      ARGA=DSQRT(GAMMA2*GAMMA2+(VGB-VFB))
      QG=GAMMAS*COX*(ARGA-GAMMA2)
      CGGB=0.5D0*COX*GAMMAS/ARGA
820   CONTINUE
      QB=-QG
      CBGB=-CGGB
      CGDB=0.0D0
      CGSB=0.0D0
      CBDB=0.0D0
      CBSB=0.0D0
      GO TO 1000
C
C     SPECIAL CASE VDS=0.0D0
C
  900 QG=COX*(VGS-VBI)
      QB=-COX*QBONCO
      CGGB=COX
      CGDB=-COX*(0.5D0+DVTDVD)
      CGSB=-COX*(0.5D0-DVTDVB)
      CBGB=0.0D0
      CBDB=-0.5D0*COX*FBODY
      CBSB=COX*(DQBDVB+0.5D0*FBODY)
C
C     DONE
C
 1000 QC=-(QG+QB)
      RETURN
      END
