      SUBROUTINE NOISE(LOCO)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     THIS ROUTINE COMPUTES THE NOISE DUE TO VARIOUS CIRCUIT ELEMENTS.
C
C SPICE VERSION 2G.6  SCCSID=TABINF 3/15/83
      COMMON /TABINF/ IELMNT,ISBCKT,NSBCKT,IUNSAT,NUNSAT,ITEMPS,NUMTEM,
     1   ISENS,NSENS,IFOUR,NFOUR,IFIELD,ICODE,IDELIM,ICOLUM,INSIZE,
     2   JUNODE,LSBKPT,NUMBKP,IORDER,JMNODE,IUR,IUC,ILC,ILR,NUMOFF,ISR,
     3   NMOFFC,ISEQ,ISEQ1,NEQN,NODEVS,NDIAG,ISWAP,IEQUA,MACINS,LVNIM1,
     4   LX0,LVN,LYNL,LYU,LYL,LX1,LX2,LX3,LX4,LX5,LX6,LX7,LD0,LD1,LTD,
     5   IMYNL,IMVN,LCVN,NSNOD,NSMAT,NSVAL,ICNOD,ICMAT,ICVAL,
     6   LOUTPT,LPOL,LZER,IRSWPF,IRSWPR,ICSWPF,ICSWPR,IRPT,JCPT,
     7   IROWNO,JCOLNO,NTTBR,NTTAR,LVNTMP
C SPICE VERSION 2G.6  SCCSID=CIRDAT 3/15/83
      COMMON /CIRDAT/ LOCATE(50),JELCNT(50),NUNODS,NCNODS,NUMNOD,NSTOP,
     1   NUT,NLT,NXTRM,NDIST,NTLIN,IBR,NUMVS,NUMALT,NUMCYC
C SPICE VERSION 2G.6  SCCSID=STATUS 3/15/83
      COMMON /STATUS/ OMEGA,TIME,DELTA,DELOLD(7),AG(7),VT,XNI,EGFET,
     1   XMU,SFACTR,MODE,MODEDC,ICALC,INITF,METHOD,IORD,MAXORD,NONCON,
     2   ITERNO,ITEMNO,NOSOLV,MODAC,IPIV,IVMFLG,IPOSTP,ISCRCH,IOFILE
C SPICE VERSION 2G.6  SCCSID=MISCEL 3/15/83
      COMMON /MISCEL/ ATIME,APROG(3),ADATE,ATITLE(10),DEFL,DEFW,DEFAD,
     1  DEFAS,RSTATS(50),IWIDTH,LWIDTH,NOPAGE
C SPICE VERSION 2G.6  SCCSID=KNSTNT 3/15/83
      COMMON /KNSTNT/ TWOPI,XLOG2,XLOG10,ROOT2,RAD,BOLTZ,CHARGE,CTOK,
     1   GMIN,RELTOL,ABSTOL,VNTOL,TRTOL,CHGTOL,EPS0,EPSSIL,EPSOX,
     2   PIVTOL,PIVREL
C SPICE VERSION 2G.6  SCCSID=AC 3/15/83
      COMMON /AC/ FSTART,FSTOP,FINCR,SKW2,REFPRL,SPW2,JACFLG,IDFREQ,
     1   INOISE,NOSPRT,NOSOUT,NOSIN,IDIST,IDPRT
C SPICE VERSION 2G.6  SCCSID=BLANK 3/15/83
      COMMON /BLANK/ VALUE(200000)
      INTEGER NODPLC(64)
      COMPLEX CVALUE(32)
      EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1))
C
C
      DIMENSION VNO1(12),VNO2(12),VNO3(12),VNO4(12),VNO5(12),VNO6(12)
      DIMENSION VNTOT(12),ANAM(12),STRING(5)
      REAL V,VREAL,VIMAG
      DIMENSION TITLN(4),V(2)
      DIMENSION AFMT1(3),AFMT2(3)
      COMPLEX CVAL,C(1)
      EQUIVALENCE (C(1),V(1),CVAL)
      EQUIVALENCE (V(1),VREAL),(V(2),VIMAG)
      DATA TITLN / 8HNOISE AN, 8HALYSIS  , 8H        , 8H         /
      DATA ALSRB,ALSRC,ALSRE,ALSRS,ALSRD / 2HRB,2HRC,2HRE,2HRS,2HRD /
      DATA ALSIB,ALSIC,ALSID,ALSFN / 2HIB,2HIC,2HID,2HFN /
      DATA ALSTOT / 5HTOTAL /
      DATA ASLASH,ABLNK / 1H/, 1H  /
      DATA AFMT1 /8H(////,11,8HX,  (2X,,8HA8))    /
      DATA AFMT2 /8H(1H0,A8,,8H1P  D10.,8H3)      /
C
C
C.. FIX-UP FORMATS
      KNTR=12
      IF(LWIDTH.LE.80) KNTR=7
      IPOS=11
      CALL MOVE(AFMT1,IPOS,ABLNK,1,2)
      CALL ALFNUM(KNTR,AFMT1,IPOS)
      IPOS=11
      CALL MOVE(AFMT2,IPOS,ABLNK,1,2)
      CALL ALFNUM(KNTR,AFMT2,IPOS)
      NPRNT=0
      FREQ=OMEGA/TWOPI
      IF (ICALC.GE.2) GO TO 10
      FOURKT=4.0D0*CHARGE*VT
      TWOQ=2.0D0*CHARGE
      NOPOSO=NODPLC(NOSOUT+2)
      NONEGO=NODPLC(NOSOUT+3)
      KNTLIM=LWIDTH/11
      NKNTR=1
   10 IF (NOSPRT.EQ.0) GO TO 30
      IF (NKNTR.GT.ICALC) GO TO 30
      NPRNT=1
      NKNTR=NKNTR+NOSPRT
      CALL TITLE(0,LWIDTH,1,TITLN)
      WRITE (IOFILE,16) FREQ
   16 FORMAT('0    FREQUENCY = ',1PD10.3,' HZ'/)
C
C  OBTAIN ADJOINT CIRCUIT SOLUTION
C
   30 VNRMS=0.0D0
      CVAL=CVALUE(LCVN+NOPOSO)-CVALUE(LCVN+NONEGO)
      VOUT=DSQRT(DBLE(VREAL*VREAL)+DBLE(VIMAG*VIMAG))
      VOUT=DMAX1(VOUT,1.0D-20)
      CALL ZERO8(VALUE(LVN+1),NSTOP)
      CALL ZERO8(VALUE(IMVN+1),NSTOP)
      VALUE(LVN+NOPOSO)=-1.0D0
      VALUE(LVN+NONEGO)=+1.0D0
      CALL ACASOL
C
C  RESISTORS
C
      IF (JELCNT(1).EQ.0) GO TO 200
      ITITLE=0
   91 FORMAT(//'0**** RESISTOR SQUARED NOISE VOLTAGES (SQ V/HZ)')
  100 LOC=LOCATE(1)
      KNTR=0
  110 IF ((LOC.EQ.0).OR.(NODPLC(LOC+8).NE.0)) GO TO 130
      KNTR=KNTR+1
      LOCV=NODPLC(LOC+1)
      ANAM(KNTR)=VALUE(LOCV)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      CVAL=CVALUE(LCVN+NODE1)-CVALUE(LCVN+NODE2)
      VNTOT(KNTR)=(DBLE(VREAL*VREAL)+DBLE(VIMAG*VIMAG))
     1   *FOURKT*VALUE(LOCV+1)
      VNRMS=VNRMS+VNTOT(KNTR)
      IF (KNTR.GE.KNTLIM) GO TO 140
  120 LOC=NODPLC(LOC)
      GO TO 110
  130 IF (KNTR.EQ.0) GO TO 200
  140 IF (NPRNT.EQ.0) GO TO 160
      IF (ITITLE.EQ.0) WRITE (IOFILE,91)
      ITITLE=1
      WRITE (IOFILE,AFMT1) (ANAM(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ALSTOT,(VNTOT(I),I=1,KNTR)
  160 KNTR=0
      IF (LOC.NE.0) GO TO 120
C
C  DIODES
C
  200 IF (JELCNT(11).EQ.0) GO TO 300
      ITITLE=0
  201 FORMAT(//'0**** DIODE SQUARED NOISE VOLTAGES (SQ V/HZ)')
  210 LOC=LOCATE(11)
      KNTR=0
  220 IF ((LOC.EQ.0).OR.(NODPLC(LOC+16).NE.0)) GO TO 240
      KNTR=KNTR+1
      LOCV=NODPLC(LOC+1)
      ANAM(KNTR)=VALUE(LOCV)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      NODE3=NODPLC(LOC+4)
      LOCM=NODPLC(LOC+5)
      LOCM=NODPLC(LOCM+1)
      LOCT=NODPLC(LOC+11)
      AREA=VALUE(LOCV+1)
      FNK=VALUE(LOCM+10)
      FNA=VALUE(LOCM+11)
C
C  OHMIC RESISTANCE
C
      CVAL=CVALUE(LCVN+NODE1)-CVALUE(LCVN+NODE3)
      VNO1(KNTR)=(DBLE(VREAL*VREAL)+DBLE(VIMAG*VIMAG))
     1   *FOURKT*VALUE(LOCM+2)*AREA
C
C  JUNCTION SHOT NOISE AND FLICKER NOISE
C
      CVAL=CVALUE(LCVN+NODE3)-CVALUE(LCVN+NODE2)
      VTEMP=DBLE(VREAL*VREAL)+DBLE(VIMAG*VIMAG)
      ARG=DMAX1(DABS(VALUE(LX0+LOCT+1)),1.0D-20)
      VNO2(KNTR)=VTEMP*TWOQ*ARG
      VNO3(KNTR)=VTEMP*FNK*DEXP(FNA*DLOG(ARG))/FREQ
      VNTOT(KNTR)=VNO1(KNTR)+VNO2(KNTR)+VNO3(KNTR)
      VNRMS=VNRMS+VNTOT(KNTR)
      IF (KNTR.GE.KNTLIM) GO TO 250
  230 LOC=NODPLC(LOC)
      GO TO 220
  240 IF (KNTR.EQ.0) GO TO 300
  250 IF (NPRNT.EQ.0) GO TO 260
      IF (ITITLE.EQ.0) WRITE (IOFILE,201)
      ITITLE=1
      WRITE (IOFILE,AFMT1) (ANAM(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ALSRS,(VNO1(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ALSID,(VNO2(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ALSFN,(VNO3(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ALSTOT,(VNTOT(I),I=1,KNTR)
  260 KNTR=0
      IF (LOC.NE.0) GO TO 230
C
C  BIPOLAR JUNCTION TRANSISTORS
C
  300 IF (JELCNT(12).EQ.0) GO TO 400
      ITITLE=0
  301 FORMAT(//'0**** TRANSISTOR SQUARED NOISE VOLTAGES (SQ V/HZ)')
  310 LOC=LOCATE(12)
      KNTR=0
  320 IF ((LOC.EQ.0).OR.(NODPLC(LOC+36).NE.0)) GO TO 340
      KNTR=KNTR+1
      LOCV=NODPLC(LOC+1)
      ANAM(KNTR)=VALUE(LOCV)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      NODE3=NODPLC(LOC+4)
      NODE4=NODPLC(LOC+5)
      NODE5=NODPLC(LOC+6)
      NODE6=NODPLC(LOC+7)
      LOCM=NODPLC(LOC+8)
      LOCM=NODPLC(LOCM+1)
      LOCT=NODPLC(LOC+22)
      AREA=VALUE(LOCV+1)
      FNK=VALUE(LOCM+44)
      FNA=VALUE(LOCM+45)
C
C  EXTRINSIC RESISTANCES
C
C...  BASE RESISTANCE
      CVAL=CVALUE(LCVN+NODE2)-CVALUE(LCVN+NODE5)
      VNO1(KNTR)=(DBLE(VREAL*VREAL)+DBLE(VIMAG*VIMAG))
     1  *FOURKT*VALUE(LX0+LOCT+16)
C...  COLLECTOR RESISTANCE
      CVAL=CVALUE(LCVN+NODE1)-CVALUE(LCVN+NODE4)
      VNO2(KNTR)=(DBLE(VREAL*VREAL)+DBLE(VIMAG*VIMAG))
     1   *FOURKT*VALUE(LOCM+20)*AREA
C...  EMITTER RESISTANCE
      CVAL=CVALUE(LCVN+NODE3)-CVALUE(LCVN+NODE6)
      VNO3(KNTR)=(DBLE(VREAL*VREAL)+DBLE(VIMAG*VIMAG))
     1   *FOURKT*VALUE(LOCM+19)*AREA
C
C  BASE CURRENT SHOT NOISE AND FLICKER NOISE
C
      CVAL=CVALUE(LCVN+NODE5)-CVALUE(LCVN+NODE6)
      VTEMP=DBLE(VREAL*VREAL)+DBLE(VIMAG*VIMAG)
      ARG=DMAX1(DABS(VALUE(LX0+LOCT+3)),1.0D-20)
      VNO4(KNTR)=VTEMP*TWOQ*ARG
      VNO5(KNTR)=VTEMP*FNK*DEXP(FNA*DLOG(ARG))/FREQ
C
C  COLLECTOR CURRENT SHOT NOISE
C
      CVAL=CVALUE(LCVN+NODE4)-CVALUE(LCVN+NODE6)
      VNO6(KNTR)=(DBLE(VREAL*VREAL)+DBLE(VIMAG*VIMAG))
     1   *TWOQ*DABS(VALUE(LX0+LOCT+2))
      VNTOT(KNTR)=VNO1(KNTR)+VNO2(KNTR)+VNO3(KNTR)+VNO4(KNTR)+VNO5(KNTR)
     1   +VNO6(KNTR)
      VNRMS=VNRMS+VNTOT(KNTR)
      IF (KNTR.GE.KNTLIM) GO TO 350
  330 LOC=NODPLC(LOC)
      GO TO 320
  340 IF (KNTR.EQ.0) GO TO 400
  350 IF (NPRNT.EQ.0) GO TO 360
      IF (ITITLE.EQ.0) WRITE (IOFILE,301)
      ITITLE=1
      WRITE (IOFILE,AFMT1) (ANAM(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ALSRB,(VNO1(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ALSRC,(VNO2(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ALSRE,(VNO3(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ALSIB,(VNO4(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ALSIC,(VNO6(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ALSFN,(VNO5(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ALSTOT,(VNTOT(I),I=1,KNTR)
  360 KNTR=0
      IF (LOC.NE.0) GO TO 330
C
C  JFETS
C
  400 IF (JELCNT(13).EQ.0) GO TO 500
      ITITLE=0
  401 FORMAT(//'0**** JFET SQUARED NOISE VOLTAGES (SQ V/HZ)')
  410 LOC=LOCATE(13)
      KNTR=0
  420 IF ((LOC.EQ.0).OR.(NODPLC(LOC+25).NE.0)) GO TO 440
      KNTR=KNTR+1
      LOCV=NODPLC(LOC+1)
      ANAM(KNTR)=VALUE(LOCV)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      NODE3=NODPLC(LOC+4)
      NODE4=NODPLC(LOC+5)
      NODE5=NODPLC(LOC+6)
      LOCM=NODPLC(LOC+7)
      LOCM=NODPLC(LOCM+1)
      LOCT=NODPLC(LOC+19)
      AREA=VALUE(LOCV+1)
      FNK=VALUE(LOCM+10)
      FNA=VALUE(LOCM+11)
C
C  EXTRINSIC RESISTANCES
C
C...  DRAIN RESISTANCE
      CVAL=CVALUE(LCVN+NODE1)-CVALUE(LCVN+NODE4)
      VNO1(KNTR)=(DBLE(VREAL*VREAL)+DBLE(VIMAG*VIMAG))
     1   *FOURKT*VALUE(LOCM+4)*AREA
C...  SOURCE RESISTANCE
      CVAL=CVALUE(LCVN+NODE3)-CVALUE(LCVN+NODE5)
      VNO2(KNTR)=(DBLE(VREAL*VREAL)+DBLE(VIMAG*VIMAG))
     1   *FOURKT*VALUE(LOCM+5)*AREA
C
C  DRAIN CURRENT SHOT NOISE AND FLICKER NOISE
C
      CVAL=CVALUE(LCVN+NODE4)-CVALUE(LCVN+NODE5)
      VTEMP=DBLE(VREAL*VREAL)+DBLE(VIMAG*VIMAG)
      VNO3(KNTR)=VTEMP*FOURKT*2.0D0*DABS(VALUE(LX0+LOCT+5))/3.0D0
      ARG=DMAX1(DABS(VALUE(LX0+LOCT+3)),1.0D-20)
      VNO4(KNTR)=VTEMP*FNK*DEXP(FNA*DLOG(ARG))/FREQ
      VNTOT(KNTR)=VNO1(KNTR)+VNO2(KNTR)+VNO3(KNTR)+VNO4(KNTR)
      VNRMS=VNRMS+VNTOT(KNTR)
      IF (KNTR.GE.KNTLIM) GO TO 450
  430 LOC=NODPLC(LOC)
      GO TO 420
  440 IF (KNTR.EQ.0) GO TO 500
  450 IF (NPRNT.EQ.0) GO TO 460
      IF (ITITLE.EQ.0) WRITE (IOFILE,401)
      ITITLE=1
      WRITE (IOFILE,AFMT1) (ANAM(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ALSRD,(VNO1(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ALSRS,(VNO2(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ALSID,(VNO3(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ALSFN,(VNO4(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ALSTOT,(VNTOT(I),I=1,KNTR)
  460 KNTR=0
      IF (LOC.NE.0) GO TO 430
C
C  MOSFETS
C
  500 IF (JELCNT(14).EQ.0) GO TO 600
      ITITLE=0
  501 FORMAT(//'0**** MOSFET SQUARED NOISE VOLTAGES (SQ V/HZ)')
  510 LOC=LOCATE(14)
      KNTR=0
  520 IF ((LOC.EQ.0).OR.(NODPLC(LOC+33).NE.0)) GO TO 540
      KNTR=KNTR+1
      LOCV=NODPLC(LOC+1)
      ANAM(KNTR)=VALUE(LOCV)
      NODE1=NODPLC(LOC+2)
      NODE2=NODPLC(LOC+3)
      NODE3=NODPLC(LOC+4)
      NODE4=NODPLC(LOC+5)
      NODE5=NODPLC(LOC+6)
      NODE6=NODPLC(LOC+7)
      LOCM=NODPLC(LOC+8)
      ITYPE=NODPLC(LOCM+2)
      LOCT=NODPLC(LOC+26)
      LOCM=NODPLC(LOCM+1)
      XL=VALUE(LOCV+1)-2.0D0*VALUE(LOCM+28)
      XW=VALUE(LOCV+2)
      COX=VALUE(LOCM+22)
      IF (COX.LE.0.0D0) COX=EPSOX/1.0D-7
      FNK=VALUE(LOCM+36)
      FNA=VALUE(LOCM+37)
C
C  EXTRINSIC RESISTANCES
C
      IF ((VALUE(LOCM+7).LE.0.0D0).AND.
     1   (VALUE(LOCM+8).LE.0.0D0)) GO TO 522
      GDPR=VALUE(LOCM+7)
      GSPR=VALUE(LOCM+8)
      GO TO 524
  522 GDPR=VALUE(LOCM+16)/VALUE(LOCV+13)
      GSPR=VALUE(LOCM+16)/VALUE(LOCV+14)
C...  DRAIN RESISTANCE
  524 CVAL=CVALUE(LCVN+NODE1)-CVALUE(LCVN+NODE5)
      VNO1(KNTR)=(DBLE(VREAL*VREAL)+DBLE(VIMAG*VIMAG))*FOURKT*GDPR
C...  SOURCE RESISTANCE
      CVAL=CVALUE(LCVN+NODE3)-CVALUE(LCVN+NODE6)
      VNO2(KNTR)=(DBLE(VREAL*VREAL)+DBLE(VIMAG*VIMAG))*FOURKT*GSPR
C
C  DRAIN CURRENT SHOT NOISE AND FLICKER NOISE
C
      CVAL=CVALUE(LCVN+NODE5)-CVALUE(LCVN+NODE6)
      VTEMP=DBLE(VREAL*VREAL)+DBLE(VIMAG*VIMAG)
      GM=VALUE(LX0+LOCT+7)
      ARG=DMAX1(DABS(VALUE(LX0+LOCT+4)),1.0D-20)
      VNO3(KNTR)=VTEMP*FOURKT*DABS(GM)/1.5D0
      VNO4(KNTR)=VTEMP*FNK*DEXP(FNA*DLOG(ARG))/(FREQ*COX*XL*XL)
  525 VNTOT(KNTR)=VNO1(KNTR)+VNO2(KNTR)+VNO3(KNTR)+VNO4(KNTR)
      VNRMS=VNRMS+VNTOT(KNTR)
      IF (KNTR.GE.KNTLIM) GO TO 550
  530 LOC=NODPLC(LOC)
      GO TO 520
  540 IF (KNTR.EQ.0) GO TO 600
  550 IF (NPRNT.EQ.0) GO TO 560
      IF (ITITLE.EQ.0) WRITE (IOFILE,501)
      ITITLE=1
      WRITE (IOFILE,AFMT1) (ANAM(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ALSRD,(VNO1(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ALSRS,(VNO2(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ALSID,(VNO3(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ALSFN,(VNO4(I),I=1,KNTR)
      WRITE (IOFILE,AFMT2) ALSTOT,(VNTOT(I),I=1,KNTR)
  560 KNTR=0
      IF (LOC.NE.0) GO TO 530
C
C  COMPUTE EQUIVALENT INPUT NOISE VOLTAGE
C
  600 VNOUT=DSQRT(VNRMS)
      VNIN=VNOUT/VOUT
      IF (NPRNT.EQ.0) GO TO 620
      DO 610 I=1,5
      STRING(I)=ABLNK
  610 CONTINUE
      IOUTYP=1
      IPOS=1
      CALL OUTNAM(NOSOUT,IOUTYP,STRING,IPOS)
      CALL MOVE(STRING,IPOS,ASLASH,1,1)
      IPOS=IPOS+1
      LOCV=NODPLC(NOSIN+1)
      ANAM1=VALUE(LOCV)
      CALL MOVE(STRING,IPOS,ANAM1,1,8)
      WRITE (IOFILE,611) VNRMS,VNOUT,STRING,VOUT,ANAM1,VNIN
  611 FORMAT(////,
     1   '0**** TOTAL OUTPUT NOISE VOLTAGE',9X,'= ',1PD10.3,' SQ V/HZ'/,
     2   1H0,40X,'= ',D10.3,' V/RT HZ'/,
     3   '0     TRANSFER FUNCTION VALUE:',/,
     4   1H0,7X,4A8,A1,'= ',D10.3,/,
     5   '0     EQUIVALENT INPUT NOISE AT ',A8,' = ',D10.3,' /RT HZ')
C
C  SAVE NOISE OUTPUTS
C
  620 LOC=LOCATE(44)
  630 IF (LOC.EQ.0) GO TO 1000
      ISEQ=NODPLC(LOC+4)
      IF (NODPLC(LOC+5).NE.2) GO TO 640
      CVALUE(LOCO+ISEQ)=VNOUT
      GO TO 650
  640 CVALUE(LOCO+ISEQ)=VNIN
  650 LOC=NODPLC(LOC)
      GO TO 630
C
C  FINISHED
C
 1000 RETURN
      END
