 c H c  This file contains the Fortran routines used in the Parallel Library. c  c P c*******************************************************************************P c******************************************************************************* c 4 c              Parallel Library Routines Version 2.0 c A c              COPYRIGHT 1985, 1986 DIGITAL EQUIPMENT CORPORATION  c P c*******************************************************************************P c*******************************************************************************   c & c  Update version of this file:  V2.01 c       G 	integer function plib$create_shared_memory (low_address, high_address,  	1	global_section_name)  c K c  This routine creates (and maps) the shared global section.  This section K c  is defined as being pagable to a disk file whose name is in the variable < c  PAGE_FILE.  This routine handles the opening of the file. c ( c  Parameters: (all parameters readonly) c B c	low_address (longword) - low address for the virtual range to be
 c				 mapped.  c D c	high_address (longword) - high address for the virtual range to be c				  mapped. c B c	global_section_name (char*15) - contains the address of the name' c		of the global section to be created.  c  c  Return value: c A c	The return value is whatever value is returned from the $CRMPSC  c	system service call. c  c  Restrictions: c D c	This routine should only be called by parallel code using a singleF c	.exe file to insure that the addresses for the various processes are$ c	at the same virtual address space. c A c	Be careful that non-shared data are not on any of these virtual A c	address pages or else these "local" variables will end up being  c	shared!!!  c    	implicit none   c  c  define data formats c B 	integer*4 low_address, high_address, addr_range(2), ret_range(2),7 	1	sys$crmpsc, ioptions, istart_page, inumber_of_pages, 8 	1	plib$ufo_open, ignore, part, wait, lib$get_lun, ilun, 	1	isave_chan, i  " 	character*(*) global_section_name   	external plib$ufo_open    c ( c  get the Plib common block definitions c  	include 'plibfor.inc'   c $ c  get the symbolic definition files c  	include '($secdef)' 	include '($ssdef)'    c N c  build the option flag - writable (wrt), global (gbl) and demand zero (dzro) c 4 	ioptions = sec$m_wrt .or. sec$m_gbl .or. sec$m_dzro   c E c  move the high and low addresses into the two-longword array as per  c  the $crmpsc specs.  c  	addr_range(1) = low_address 	addr_range(2) = high_address  c	write (1,10) addr_range  c10	format (2i)    c 1 c  determine the total number of pages requested.  c < 	inumber_of_pages = ((high_address - low_address) / 512) + 2   c I c  open the disk file to be used for paging and get the channel number if + c  nothing has been created and mapped yet.  c # c	write (6,93) inext_starting_block ) c93	format (' inext_starting_block = ',i)   & 	if (inext_starting_block .eq. 0) then 	   ignore = lib$get_lun (ilun) 0 	   open (unit=ilun,file=page_file,status='old', 	1	useropen=plib$ufo_open) 	   close (unit=ilun)  	endif   c K c  What we next have to do seems like a hack - and it sort of is.  When the K c  PLIB$INIT routine has called us to set up the PLIB-private shared memory I c  section, the entire shared section will be zeroed.  However... we just K c  got the channel number which is in this section - thus it will be zeroed G c  during this one situation.  (Note, this is the only variable that is G c  valid in the range in this situation.)  What we will do, then, is to F c  make a copy of the channel number and put it back after the call toG c  $CRMPSC to get around this problem.  (The PLIB$INIT routine can't do G c  this since it hasn't had a chance to copy the channel variable yet.)  c  	isave_chan = ichan    c I c  finally, call the system service to do the global section creation and  c  mapping.  c ) 	plib$create_shared_memory = sys$crmpsc ( ! 	1	addr_range,				! address range " 	1	ret_range,,				! ret addr range$ 	1	%val(ioptions),				! options flag* 	1	global_section_name,,,			! section name& 	1	%val(ichan),				! disk file channel+ 	1	%val(inumber_of_pages),			! num of pages 2 	1	%val(inext_starting_block),,)		! pagefile range   	ichan = isave_chan   6 	if (plib$create_shared_memory .eq. ss$_created  .and.( 	1	ret_range(2) .lt. addr_range(2)) then3 	   i = inext_starting_block + inumber_of_pages - 1 ( 	   write (6,999) global_section_name, iI 999	   format (/'  *** Fatal error creating shared memory ',a15,' ***',/, 8 	1	    '      Page file not large enough.  It requires',# 	1	    ' at least ',i7,' blocks.'/, % 	1	    '      Program terminated.'//) ) 	   call exit (plib$create_shared_memory)  	endif  * 	if (.not. plib$create_shared_memory) then) 	   call exit (plib$create_shared_memory)  	endif   c 1 c  reset starting block number for the next call.  c ? 	inext_starting_block = inext_starting_block + inumber_of_pages    c ' c  all done, return to calling routine.  c  	return    	end   cP c******************************************************************************* c     / 	integer function plib$ufo_open (fab, rab, lun)  c D c  routine to perform the required user file open option for settingG c  up the paging file.  This routine (with minor modifications) is from G c  page 9-27 of the "Guide to Programming on VAX/VMS (Fortran Edition)" 
 c  manual. c    c ( c  get the plib common block definitions c  	include 'plibfor.inc'   c  c  include RMS definitions c  	include '($rabdef)' 	include '($fabdef)'   c  c  Make required definitions:  c  	record /fabdef/ fab 	record /rabdef/ rab   	integer sys$open    c 3 c  set the useropen bit in the FAB options longword  c - 	fab.fab$l_fop = fab.fab$l_fop .or. fab$m_ufo  c  c  and open the file c  	plib$ufo_open = sys$open (fab)    c ( c  get the channel number for later use. c  	ichan = fab.fab$l_stv   	end     cP c******************************************************************************* c  c   8 	integer function plib$delete_subprocesses (inum, ipids) c - c  routine to delete all of the subprocesses.  c  c  Arguments c * c	INUM - Number of subprocesses to delete. c D c	IPIDS - Longword array of subprocess PIDs to delete.  (Note, these< c		pids can be obtained when the subprocesses are created by& c		the PLIB$CREATE_SUBPROCESS routine. c  c  Return value  c # c	1 = all were deleted successfully  c . c	0 = At least one subprocess was not deleted. c  c  Restrictions  c  c  Comments  c    	implicit none  - 	integer inum, ipids(1), sys$delprc, i, istat    	plib$delete_subprocesses = 1    	do i = 1,inum" 	   istat = sys$delprc (ipids(i),)1 	   if (.not. istat) plib$delete_subprocesses = 0  	enddo   	return  	end   cP c******************************************************************************* c     D 	integer function plib$map_shared_memory (low_address, high_address, 	1	global_section_name)  c 7 c  This routine maps an existing shared global section.  c ( c  Parameters: (all parameters readonly) c B c	low_address (longword) - low address for the virtual range to be
 c				 mapped.  c D c	high_address (longword) - high address for the virtual range to be c				  mapped. c B c	global_section_name (char*15) - contains the address of the name& c		of the global section to be mapped. c  c  Return value: c A c	The return value is whatever value is returned from the $MGBLSC  c	system service call. c  c  Restrictions: c D c	This routine should only be called by parallel code using a singleF c	.exe file to insure that the addresses for the various processes are$ c	at the same virtual address space. c A c	Be careful that non-shared data are not on any of these virtual A c	address pages or else these "local" variables will end up being  c	shared!!!  c    	implicit none   c  c  define data formats c @ 	integer*4 low_address, high_address, addr_range(2), sys$mgblsc, 	1	ioptions " 	character*(*) global_section_name   c # c  get the symbolic definition file  c  	include '($secdef)' 	include '($ssdef)'    c * c  build the option flag - writable (wrt), c  	ioptions = sec$m_wrt    c E c  move the high and low addresses into the two-longword array as per  c  the $mgblsc specs.  c  	addr_range(1) = low_address 	addr_range(2) = high_address    c < c  call the system service to do the global section mapping. c & 	plib$map_shared_memory = sys$mgblsc (! 	1	addr_range,				! address range % 	1	,,%val(ioptions),			! options flag * 	1	global_section_name,,)			! section name  3 	if ((plib$map_shared_memory .and. 1) .ne. 1  .and. 2 	1	plib$map_shared_memory .ne. ss$_nosuchsec) then& 	   call exit (plib$map_shared_memory) 	endif   c ' c  all done, return to calling routine.  c  	return  	end     cP c******************************************************************************* c     C 	integer function plib$create_subprocesses (number_of_subprocesses, 0 	1	exe_name, sys_input, sys_output, return_pids) c % c  This routine creates a subprocess.  c  c  Parameters: c C c	number_of_subprocesses - count of the number of subprocesss to be  c		started.  c E c	exe_name - name of the .exe file that this subprocess will execute.  c 8 c	sys_input - string to assign to the sys$input logical. c ? c	sys_output - string to assign to the sys$output and sys$error  c		logicals. c A c	return_pids - An array of NUMBER_OF_SUBPROCESSES longwords that 4 c		will return the PIDs of the created subprocesses. c  c  Return value: c A c	The return value is whatever value is returned from the $CREPRC  c	system service call. c  c  Restrictions: c  c  c  Comments: c    	implicit none   c  c  definitions...  c . 	character*(*) exe_name, sys_input, sys_output  > 	integer*4 return_pids(1), i, number_of_subprocesses, int_pid, 	1	lib$spawn   c I c  Create the subproceses and capture the subprocess's pid values if this  c  was requested.  c   	do i = 1,number_of_subprocesses= 	   plib$create_subprocesses = lib$spawn ('$ run '//exe_name, ' 	1	sys_input,sys_output,1,,int_pid,,,,) . 	   if (.not. plib$create_subprocesses) return: 	   if (%loc(return_pids) .ne. 0) return_pids(i) = int_pid 	enddo 	return    	end     c P c******************************************************************************* c   1 	integer function plib$current_image (image_name)  c / c  routine to determine the current image name.  c  c  Arguments c @ c	IMAGE_NAME - Character*128 variable in which the current image c		name will be returned.  c  c  Return value  c @ c	This routine returns the value from the $GETJPI system service
 c	routine. c  c  Restrictions  c  c  Comments  c    	implicit none  * 	integer item_list(4), sys$getjpiw, ignore   	character*128 image_name    	include '($jpidef)' c # c  Find out the current image name.  c - 	item_list(1) = (jpi$_imagname * 65536) + 128   	item_list(2) = %loc(image_name) 	item_list(3) = %loc(ignore) 	item_list(4) = 0 3 	plib$current_image = sys$getjpiw (,,,item_list,,,)  c  c  all done, return. c  	return  	end       cP c******************************************************************************* c     ? 	integer function plib$share_memory (ilow, ihigh, section_name)  c G c  This routine is the driver routine for the plib$create_shared_memory I c  and plib$map_shared_memory routines.  This first calls the MAP routine H c  in an attempt to map to an existing global section and will then callF c  the CREATE routine if the global section did not previousely exist. c    	implicit none   	character*(*) section_name G 	integer ilow, ihigh, plib$create_shared_memory, plib$map_shared_memory    	include '($ssdef)'    c 8 c  first, try mapping to it to see if it already exists. c   G 	plib$share_memory = plib$map_shared_memory (ilow, ihigh, section_name)    c I c  if we get back the status "no such section", then make it.  Also, mark F c  it for eventual deletion when no process is mapping to it any more. c / 	if (plib$share_memory .eq. ss$_nosuchsec) then ? 	   plib$share_memory = plib$create_shared_memory (ilow, ihigh,  	1	section_name) 	endif   	return  	end       cP c*******************************************************************************P c***************  Code for the sharing of executable code **********************P c******************************************************************************* c   = 	integer function plib$share_code (ilow, ihigh, section_name)  c E c  This routine is the driver routine for the plib$create_shared_code I c  and plib$map_shared_memory routines.  This first calls the MAP routine H c  in an attempt to map to an existing global section and will then callF c  the CREATE routine if the global section did not previousely exist. c  c    	implicit none   	character*(*) section_name E 	integer ilow, ihigh, plib$create_shared_code, plib$map_shared_memory    	include '($ssdef)'    c 8 c  first, try mapping to it to see if it already exists. c   E 	plib$share_code = plib$map_shared_memory (ilow, ihigh, section_name)    c I c  if we get back the status "no such section", then make it.  Also, mark F c  it for eventual deletion when no process is mapping to it any more. c - 	if (plib$share_code .eq. ss$_nosuchsec) then ; 	   plib$share_code = plib$create_shared_code (ilow, ihigh,  	1	section_name) 	endif   	return  	end     cP c******************************************************************************* c E 	integer function plib$create_shared_code (low_address, high_address,  	1	global_section_name)  c M c  This routine creates (and maps) the shared global section used for sharing L c  executable code.  This section is defined as being pagable to a disk fileM c  whose name is in the PAGE_FILE variable.  This routine handles the opening  c  of the file.  c ( c  Parameters: (all parameters readonly) c B c	low_address (longword) - low address for the virtual range to be
 c				 mapped.  c D c	high_address (longword) - high address for the virtual range to be c				  mapped. c B c	global_section_name (char*15) - contains the address of the name' c		of the global section to be created.  c  c  Return value: c A c	The return value is whatever value is returned from the $CRMPSC  c	system service call. c  c  Restrictions: c D c	This routine should only be called by parallel code using a singleF c	.exe file to insure that the addresses for the various processes are$ c	at the same virtual address space. c A c	Be careful that non-shared data are not on any of these virtual A c	address pages or else these "local" variables will end up being  c	shared!!!  c A c	If the application is going to use both the PLIB$SHARE_CODE and E c	PLIB$SHARE_MEMORY, the call to PLIB$SHARE_CODE must be first!  And, 0 c	there can only be one call to PLIB$SHARE_CODE. c    	implicit none   c  c  define data formats c B 	integer*4 low_address, high_address, addr_range(2), ret_range(2),7 	1	sys$crmpsc, ioptions, istart_page, inumber_of_pages, : 	1	plib$ufo_open, iarray_index, ireal_low_address, ignore,: 	1	lib$get_lun, ilun, istart_location, iblock_number, i, j   	external plib$ufo_open    	byte memory_block(1) " 	character*(*) global_section_name   c  c  get the plib common block c  	include 'plibfor.inc'   c $ c  get the symbolic definition files c  	include '($secdef)' 	include '($ssdef)'    c < c  build the option flag - only global (gbl).  Note that forE c  sharing the code segments the demand-zero option *must* be off and # c  we don't want it to be writable.  c  	ioptions = sec$m_gbl    c E c  move the high and low addresses into the two-longword array as per  c  the $crmpsc specs.  c  	addr_range(1) = low_address 	addr_range(2) = high_address  c	write (1,10) addr_range  c10	format (2i)    c 1 c  determine the total number of pages requested.  c < 	inumber_of_pages = ((high_address - low_address) / 512) + 2" 	iarray_index = %loc(memory_block) c M c  next, get the "real" starting address for the shared section.  (The shared M c  sections are on full page boundaries so we want to strip off the low-order ? c  nine bits to get the address of the first byte on this page.  c 2 	ireal_low_address = low_address .and. 'FFFFFE00'x   c G c  next, open the file direct access so we can dump the executable codeeF c  into it.  (Note, we don't want to open this with the user-file-openE c  option since we are going to use this from Fortran at this point.)* c* 	ignore = lib$get_lun (ilun)B 	open (unit=ilun, file=page_file, access='direct', recordsize=128, 	1	type='old')   crJ c  then loop for the blocks of code and dump each out into the paging file cN7 	istart_location = ireal_low_address - iarray_index + 1*% 	iblock_number = inext_starting_block* 	do 20 i = 1, inumber_of_pages% 	   iblock_number = iblock_number + 1* 	   write (ilun'iblock_number): 	1	(memory_block(j),j=istart_location,istart_location+511)+ 	   istart_location = istart_location + 512e 20	continuea 	close (unit=ilun)     ci coI c  reopen the disk file to be used for paging and get the channel number.eI c  Now, open it with the UFO option since we are going to now use this asGK c  a paging file.  (This looks strange that we're opening the file and thenlL c  immediately closing it, but that is what is needed for paging files.  TheI c  plib$ufo_open routine that this implicitly calls will save the channeleG c  number in the shared ICHAN variable for later passing to the $crmpsc  c  routine.) ci   	ignore = lib$get_lun (ilun)/ 	open (unit=ilun, file=page_file, status='old',r 	1	useropen=plib$ufo_open) 	close (unit=ilun)     ceI c  finally, call the system service to do the global section creation and  c  mapping.e co' 	plib$create_shared_code = sys$crmpsc ( ! 	1	addr_range,				! address ranget" 	1	ret_range,,				! ret addr range$ 	1	%val(ioptions),				! options flag* 	1	global_section_name,,,			! section name& 	1	%val(ichan),				! disk file channel+ 	1	%val(inumber_of_pages),			! num of pages 2 	1	%val(inext_starting_block),,)		! pagefile range  4 	if (plib$create_shared_code .eq. ss$_created  .and.( 	1	ret_range(2) .lt. addr_range(2)) then3 	   i = inext_starting_block + inumber_of_pages - 1_( 	   write (6,999) global_section_name, iG 999	   format (/'  *** Fatal error creating shared code ',a15,' ***',/,t8 	1	    '      Page file not large enough.  It requires',# 	1	    ' at least ',i7,' blocks.'/,u% 	1	    '      Program terminated.'//)o' 	   call exit (plib$create_shared_code)d 	endif  3 	if ((plib$create_shared_code .and. 1) .ne. 1) theni' 	   call exit (plib$create_shared_code)  	endif   ci1 c  reset starting block number for the next call.  c ? 	inext_starting_block = inext_starting_block + inumber_of_pagesa   c ' c  all done, return to calling routine.( c= 	returne 	end     cgP c*******************************************************************************P c*******************************************************************************# c              Signalling routines.oP c*******************************************************************************P c******************************************************************************* cm  @ 	integer function plib$init_signals (ief_start, inum, iproc_num)   chK c  This routine is used to initialize the event flag signalling mechanisms.u co c  Parameters: clC c	IEF_START - lowest of three consecutive event flags to be used ina; c		the signalling mechanisms.  This value is the event flag = c		to be used to awaken the main process.  The next two flagsr> c		in consecutive order are to be used for the "2 start flags"
 c		mechanism.e cs> c	INUM - The number of subprocesses that are going to be used. cl@ c	IPROC_NUM - This longword value is the relative process number; c		within the list of processes having called this routine..< c		If the value returned is zero, it means this is the first; c		call (and thus the caller is probably the main process). 9 c		Every subsequent call will get a unique number betweent c		1 and INUM. c  c  Return values:y ce9 c	1 = successfully initialized the signalling mechanisms.  cn- c	0 = Illegal range of event flags specified.s ci9 c	Any other value - return value from the system service.o c= c  Restrictions: cdC c	These signalling routines require exclusive use of a common block%( c	(and also thus PSECT) called PLIB_COM. ce c  Comments: c B c	The common block must be shared between the main process and allC c	of the subprocesses.  It will be set up as shared with the globalaH c	section name of PARENT_PID//"PLIBCOM" and will not require any special& c	handling in the linker options file. caE c	In case of an error, a value of -1 will be returned for the process 	 c	number.  c9 c    	implicit none  ? 	integer sys$ascefc, plib$main_pid, ief_start, inum, iproc_num,1( 	1	page_file_create_option, imain, istat   	character*8 pid   	character*128 temp_page_file'   ck( c  get the plib common block definitions c  	include 'plibfor.inc'     	iproc_num = -1    cfB c  First thing to do is to verify that the event flag parameter is c  acceptable. cyG c  Note, the event flag clusters go from event flags 64->95 (cluster 2) E c  and 96->127 (cluster 3) but our boundary checks will only be up to I c  93 and 125, respectivly.  This is due to the parameter being the first*I c  of three consecutive event flags and we don't want this range of three  c  to cross a cluster boundary.o ce8 	if ((ief_start .lt. 64  .or.  ief_start .gt. 93)  .and.8 	1   (ief_start .lt. 96  .or.  ief_start .gt. 125)) then 	   plib$init_signals = 0m
 	   return 	endif   c J c  valid range for the event flags.  Next thing to do is to make the eventJ c  flag range accessable from any subprocess.  (Note the use of the parentG c  pid being appended to the "flag" name to make the name of this eventi& c  flag range unique to this process.) cd 	imain = plib$main_pid (pid)4 	istat = sys$ascefc (%val(ief_start),pid//'FLAG',1,)         if (.not. istat) thenn 	   plib$init_signals = istat 
 	   return 	endif   cl% c  no errors, set up the return valueh ci 	plib$init_signals = 1   coD c  Save the paging filename so that when the plib-specific region is9 c  set up (and thus zeroed), we can replace the filename.* c* 	temp_page_file = page_file*   c*H c  Now that the page_file has been taken care of, next set up our common" c  block so that it can be shared. co/ 	call plib$share_memory (%loc(isignal_to_main),M% 	1	%loc(end_buffer)-1, pid//'PLIBSH')    cPI c  If we are the main process and we just created the global section, theaF c  previous contents of it (only PAGE_FILE) are now filled with zeros.& c  Rebuild the filename for later use. c    	page_file = temp_page_files   c J c  Next, determine if we are the main process or not.  If we are, load theH c  initial values for the event flags.  If a subprocess, just return theN c  relative process number.  (Note, the process_number variable is initialized3 c  to zero if the global section was just created.)e cs* 	call plib$set_bit_interlocked (lock_flag) 	iproc_num = process_number*$ 	process_number = process_number + 1 	if (iproc_num .gt. 0) theni/ 	   call plib$clear_bit_interlocked (lock_flag)s
 	   return 	endif coN c  main process, load the variables and make sure the event flags are cleared. c  	isignal_to_main = ief_start' 	call sys$clref (%val(isignal_to_main))) 	ithis_ef = ief_start + 1u  	call sys$clref (%val(ithis_ef)) 	inext_ef = ief_start + 2   	call sys$clref (%val(inext_ef)) 	number_of_subprocesses = inum 	subs_left = inum    c*7 c  done initing, release the hold on the flag and exit.s ci, 	call plib$clear_bit_interlocked (lock_flag) 	returnn 	end    P c*******************************************************************************    5 	integer function plib$init_pagefile (page_file_name,l 	1	page_file_create_option)e clB c  This routine is used to initialize the file that is going to be c  used as the paging file.. c  c  Parameters: c D c	PAGE_FILE_NAME - Character string variable (max of 128 characters)/ c		containing the name of the page file to use.	 crB c	PAGE_FILE_CREATE_OPTION - If zero, page file already exists.  If: c		non-zero, this parameter specifies that this routine is9 c		to create the page file.  The size of the created file > c		will be equal to the value of this parameter.  For example,; c		if PAGE_FILE_CREATE_OPTION is equal to 100, this routine 6 c		will make the page file specified at a size of 100. ca9 c		The option of creating a paging file is *only* checkede? c		when this routine is called by the main process.  Therefore,)< c		the subprocesses can execute the same initialization code> c		(which they have to for event flags, etc.) without creating c		additional page files.r c  c  Return values:o co/ c	1 = successfully initialized the paging file.	 c 7 c	0 = problem encountered initializing the paging file.. c  c  Restrictions: chC c	These signalling routines require exclusive use of a common blockm( c	(and also thus PSECT) called PLIB_COM. cc c  Comments: c E c	Even though the common block is not yet set up as shared, we'll put*A c	the paging filename into it anyway.  It will be up to the otherbC c	routines to save the filename before setting up any shared memoryt$ c	sections to preserve the filename. coC c	Also note that this routine can be called by the main process andpE c	all of the subprocesses since it has internal checks to permit only / c	the main process to initialize the page file.r cs ci   	implicit none  ? 	integer page_file_create_option, plib$main_pid, imain, ignore,_ 	1	lib$get_lun, itemp_luno   	character*(*) page_file_name	   	character*8 temp_string   cn( c  get the plib common block definitions ca 	include 'plibfor.inc'     ctI c  Are we being called by a subprocess?  If so, just return so that everyhG c  process and subprocess isn't initing this file.  (We can tell if the 4 c  PAGE_FILE variable already has a filename in it.) ce 	plib$init_pagefile = 1 $ 	imain = plib$main_pid (temp_string) 	if (imain .ne. 0) return4   crH c  First thing to do is to check if we have to create a paging file.  WeH c  are going to use the returned value from the plib$main_pid routine toM c  see if we are a main process or not.  (Note, we can't just do the standardsH c  mechanism of checking a shared variable here since no global sectionsK c  could have been created up to this point.)  (Second thing to note, don'tsJ c  try to combine these two IF statements into one since that could createF c  a timing situation of two or more subprocesses trying to reload the. c  page_file variable due to the ELSE clause.) cg 	page_file = page_file_namee) 	if (page_file_create_option .ne. 0) theng$ 	   ignore = lib$get_lun (itemp_lun)5 	   open (unit=itemp_lun, file=page_file, type='new', + 	1	access='direct', recordsize=128,err=100)r7 	   write (itemp_lun'page_file_create_option) itemp_lun  	   close (unit=itemp_lun) 	endif   	returnt   c  c  error encountered.i cg 100	plib$init_pagefile = 0 	return  	end    P c*******************************************************************************  . 	integer function plib$signal_main (next_part) c G c  This routine decrements the count of the active processes and if nowiL c  zero, awakens the main process by setting the event flag ISIGNAL_TO_MAIN.J c  Every process (including those that don't awaken the main process) will5 c  wait here until the main process wakes them again.  ci
 c  Parameters  cbG c	NEXT_PART - After the subprocesses are reawakened, the value returnedi< c		in this parameter tells the subprocesses what part number/ c		the main process has signaled in its call toA c		PLIB$SIGNAL_SUBPROCESSES. ca c  Return values ca@ c	This routine always returns a 1 since it does not return until1 c	the main process has awakened the subprocesses.  ce c  Restrictions) ccC c	The PLIB$SIGNAL_INIT routine must be called prior to calling this_
 c	routine. c  c  Comments$ ceC c	April 7, 1986 - V2.01  Modified the "last subprocess to complete" E c	test from a critical section to using the PLIB$ADD_WORD_INTERLOCKED_
 c	routine. c    	implicit none  7 	integer isave_ef, plib$add_word_interlocked, next_parti   c ( c  get the plib common block definitions ct 	include 'plibfor.inc'   c$M c  Decrement the global counter in an interlocked instruction.  If the resultr$ c  is zero, awaken the main process. c)   	isave_ef = inext_ef4 	if (plib$add_word_interlocked(-1,subs_left) .eq. 0)) 	1	call sys$setef (%val(isignal_to_main))*   c*0 c  now wait for the main process to reawaken us. c*! 	call sys$waitfr (%val(isave_ef))*   c*G c  we're back awake.  Copy the next part number from the global sectionr& c  into our parameter list and return. ct 	next_part = part_number 	plib$signal_main = 1t 	returnh 	end  P c*******************************************************************************    7 	integer function plib$signal_subprocesses (part, wait)e coI c  This routine is called by the main process to awaken the subprocesses.rM c  This performs the event flag swap to implement the "2 start flags" method,tI c  puts the PART parameter into the shared global section and awakens theuI c  subprocesses.  Optionally, this routine will wait for the subprocessest  c  to complete before returning. c_ c  Arguments coD c	PART - This longword is passed to the subprocesses and is normally; c		used to instruct the subprocesses which parallel sectiont c		to execute. c ? c	WAIT - This parameter specifies if this routine should returnu< c		immediately upon awakening the subprocesses or whether it; c		should wait for the subprocesses to report that they are  c		fully done.  The values are:* c*> c		WAIT = 0, don't wait but return immediately upon awakening. co? c		WAIT = 1, wait for all subprocesses to report they are done._ ct c  Return value  ci( c	This routine returns a 1 in all cases. cl c  Restrictions  crB c	The signalling enviroment must have been previousely initialized* c	by calling the PLIB$SIGNAL_INIT routine. cL c  CommentsT c    	implicit none   cn c  define the plib common blockr ct 	include 'plibfor.inc'   	integer itemp, part, wait   c)6 c  first step, perform the "2 start flags" value swap. c  	itemp = ithis_ef( 	ithis_ef = inext_ef 	inext_ef = itempr   ctG c  next, initialize the values for the SUBS_LEFT and PART_NUMBER globala
 c  variables.a c # 	subs_left = number_of_subprocessesd 	part_number = partu   c L c  wake up the subprocesses by setting the event flag they have been waitingI c  for.  (note, they were waiting for the variable in INEXT_EF, but sincel= c  we swapped the values, we will set the value in ITHIS_EF.)t ca% c	write (6,999) ithis_ef, part_number C c999	format (' awakening the subs by setting EF ',i,' for part ',i)d  	call sys$setef (%val(ithis_ef))   c H c  finally, determine if we are to wait for the subprocesses to complete c  before returning. ci 	if (wait .eq. 1) then" c	   write (6,998) isignal_to_main; c998	   format (' main is in wait option - waiting for ',i)d+ 	   call sys$waitfr (%val(isignal_to_main))E* 	   call sys$clref (%val(isignal_to_main)) c	   write (6,997) ithis_ef42 c997	   format (' main is clearing event flag ',i)# 	   call sys$clref (%val(ithis_ef))_ 	endif ce
 c  and return1 ci 	plib$signal_subprocesses = 1_ 	returns 	end              t  P c*******************************************************************************  8 	integer function plib$signal_and_wait (sub_ef, main_ef) c J c  this routine is used to set the event flag that starts the subprocessesK c  and wait for them to signal that they are done.  Once they signal, clear $ c  out both of the event flags used. cb c  Arguments crA c	sub_ef - event flag number to set at the start of this routine.  c D c	main_ef - event flag that the subprocesses will use to signal that6 c		they are done.  (This routine waits for this flag.) cd c  Return status ce c	1 in all cases.  ca c_   	implicit none  : 	integer sys$setef, sys$waitfr, sys$clref, sub_ef, main_ef   c1 c  signal subprocess start ci 	call sys$setef (%val(sub_ef))   cd c  wait for them to complete ch  	call sys$waitfr (%val(main_ef))   cr> c  and finally clear the flags to reset for the next sequence. cg 	call sys$clref (%val(main_ef))  	call sys$clref (%val(sub_ef))   c  c  all done, return. ct 	plib$signal_and_wait = 1    	returni 	end    P c*******************************************************************************  % 	integer function plib$synch (idummy)h ciG c  Executing this routine will cause the main process to wait until the A c  subprocesses have signaled that they are done with their work.  ca c  Arguments chD c	- none -  The IDUMMY parameter is specified here only so that this; c		routine can be called as a function in addition to being29 c		called as a subroutine.  The IDUMMY parameter is neverd c		used. cc c  Return status c C c	This routine only returns a 1 and will not return until the eventiG c	flag has been set.  (i.e. This will not return until the subprocesses " c	have reported their completion.) c  c  Restrictionsk cmA c	This routine is intended to be used ONLY when the NOWAIT option C c	on the PLIB$SIGNAL_SUBPROCESSES routine is used.  Using these twotB c	routines in this manner, the main process can continue executing@ c	after awakening the subprocesses and then call this routine to- c	resynchronize itself with the subprocesses.n ci c  Commentso cs   	implicit none   cn( c  get the plib common block definitions ci 	include 'plibfor.inc'   	integer idummy	   cT8 c  wait for the subprocesses to signal their completion. cs c	write (6,999) isignal_to_maine+ c999	format (' main is in synch for ef ',i)h( 	call sys$waitfr (%val(isignal_to_main))   ceI c  main process has been signalled.  Clean up the event flags and return.= cb) c	write (6,998) isignal_to_main, ithis_eff. c998	format (' main clearing event flags ',2i)' 	call sys$clref (%val(isignal_to_main))   	call sys$clref (%val(ithis_ef))   	returna 	end    P c*******************************************************************************    , 	integer function plib$main_pid (pid_string) caE c  This routine returns the process identification number of the main	J c  process regardless if it is called by a subprocess or the main process.H c  (Note, if it is called by a subprocess, the value returned is that ofJ c  the owner process.  If a subprocess has created another subprocess, the> c  value returned will be that of the higher-level subprocess. ce c  Arguments crC c	PID_STRING - This value is an 8 character ascii string equivalentI2 c		of the pid value returned in the return status. c  c  Return status cm? c	The return status denotes if the calling process was the main B c	process or a subprocess.  If a zero is returned, it was the mainA c	process. A non-zero signifies that this routine was called fromu c	a subprocess.  cl c  Restrictionsa cn c  Commentsx ct   	implicit none  > 	integer owner_pid, my_pid, ignore, item_list(7), iret_status, 	1	sys$getjpiw c  	character*8 pid_string* c* 	include '($jpidef)'   c*5 c  Get both our pid and the pid of our owner process.* c*( 	item_list(1) = (jpi$_owner * 65536) + 4 	item_list(2) = %loc(owner_pid)n 	item_list(3) = %loc(ignore)& 	item_list(4) = (jpi$_pid * 65536) + 4 	item_list(5) = %loc(my_pid) 	item_list(6) = %loc(ignore) 	item_list(7) = 0* c*, 	iret_status = sys$getjpiw (,,,item_list,,,)   cbG c  Now, if we were the main process, return the MY_PID value.  If we're H c  a subprocess, return the OWNER_PID variable.  In either case, convert/ c  this to a character string before returning.n cl 	plib$main_pid = owner_pid 	if (owner_pid .eq. 0) thena. 	   call ots$cvt_l_tz (my_pid, pid_string, , ) 	elsen1 	   call ots$cvt_l_tz (owner_pid, pid_string, , )r 	endif   c  c  and return to the caller. cm 	returne 	end    P c******** End of the Fortran portion of the Parallel Library V2 Routines *******P c*******************************************************************************