      SUBROUTINE READIN
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C
C     THIS ROUTINE DRIVES THE INPUT PROCESSING OF SPICE.  ELEMENT CARDS
C AND DEVICE MODELS ARE HANDLED BY THIS ROUTINE.
C
C SPICE VERSION 2G.6  SCCSID=TABINF 3/15/83
      COMMON /TABINF/ IELMNT,ISBCKT,NSBCKT,IUNSAT,NUNSAT,ITEMPS,NUMTEM,
     1   ISENS,NSENS,IFOUR,NFOUR,IFIELD,ICODE,IDELIM,ICOLUM,INSIZE,
     2   JUNODE,LSBKPT,NUMBKP,IORDER,JMNODE,IUR,IUC,ILC,ILR,NUMOFF,ISR,
     3   NMOFFC,ISEQ,ISEQ1,NEQN,NODEVS,NDIAG,ISWAP,IEQUA,MACINS,LVNIM1,
     4   LX0,LVN,LYNL,LYU,LYL,LX1,LX2,LX3,LX4,LX5,LX6,LX7,LD0,LD1,LTD,
     5   IMYNL,IMVN,LCVN,NSNOD,NSMAT,NSVAL,ICNOD,ICMAT,ICVAL,
     6   LOUTPT,LPOL,LZER,IRSWPF,IRSWPR,ICSWPF,ICSWPR,IRPT,JCPT,
     7   IROWNO,JCOLNO,NTTBR,NTTAR,LVNTMP
C SPICE VERSION 2G.6  SCCSID=MISCEL 3/15/83
      COMMON /MISCEL/ ATIME,APROG(3),ADATE,ATITLE(10),DEFL,DEFW,DEFAD,
     1  DEFAS,RSTATS(50),IWIDTH,LWIDTH,NOPAGE
C SPICE VERSION 2G.6  SCCSID=LINE 3/15/83
      COMMON /LINE/ ACHAR,AFIELD(15),OLDLIN(15),KNTRC,KNTLIM
C SPICE VERSION 2G.6  SCCSID=CIRDAT 3/15/83
      COMMON /CIRDAT/ LOCATE(50),JELCNT(50),NUNODS,NCNODS,NUMNOD,NSTOP,
     1   NUT,NLT,NXTRM,NDIST,NTLIN,IBR,NUMVS,NUMALT,NUMCYC
C SPICE VERSION 2G.6  SCCSID=STATUS 3/15/83
      COMMON /STATUS/ OMEGA,TIME,DELTA,DELOLD(7),AG(7),VT,XNI,EGFET,
     1   XMU,SFACTR,MODE,MODEDC,ICALC,INITF,METHOD,IORD,MAXORD,NONCON,
     2   ITERNO,ITEMNO,NOSOLV,MODAC,IPIV,IVMFLG,IPOSTP,ISCRCH,IOFILE
C SPICE VERSION 2G.6  SCCSID=FLAGS 3/15/83
      COMMON /FLAGS/ IPRNTA,IPRNTL,IPRNTM,IPRNTN,IPRNTO,LIMTIM,LIMPTS,
     1   LVLCOD,LVLTIM,ITL1,ITL2,ITL3,ITL4,ITL5,ITL6,IGOOF,NOGO,KEOF
C SPICE VERSION 2G.6  SCCSID=KNSTNT 3/15/83
      COMMON /KNSTNT/ TWOPI,XLOG2,XLOG10,ROOT2,RAD,BOLTZ,CHARGE,CTOK,
     1   GMIN,RELTOL,ABSTOL,VNTOL,TRTOL,CHGTOL,EPS0,EPSSIL,EPSOX,
     2   PIVTOL,PIVREL
C SPICE VERSION 2G.6  SCCSID=DC 3/15/83
      COMMON /DC/ TCSTAR(2),TCSTOP(2),TCINCR(2),ICVFLG,ITCELM(2),KSSOP,
     1   KINEL,KIDIN,KOVAR,KIDOUT
C SPICE VERSION 2G.6  SCCSID=AC 3/15/83
      COMMON /AC/ FSTART,FSTOP,FINCR,SKW2,REFPRL,SPW2,JACFLG,IDFREQ,
     1   INOISE,NOSPRT,NOSOUT,NOSIN,IDIST,IDPRT
C SPICE VERSION 2G.6  SCCSID=TRAN 3/15/83
      COMMON /TRAN/ TSTEP,TSTOP,TSTART,DELMAX,TDMAX,FORFRE,JTRFLG
C SPICE VERSION 2G.6  SCCSID=OUTINF 3/15/83
      COMMON /OUTINF/ XINCR,STRING(15),XSTART,YVAR(8),ITAB(8),ITYPE(8),
     1   ILOGY(8),NPOINT,NUMOUT,KNTR,NUMDGT
C SPICE VERSION 2G.6  SCCSID=CJE 3/15/83
      COMMON /CJE/ MAXTIM,ITIME,ICOST
C SPICE VERSION 2G.6  SCCSID=DEBUG 3/15/83
      COMMON/DEBUG/ IDEBUG(20)
C SPICE VERSION 2G.6  SCCSID=BLANK 3/15/83
      COMMON /BLANK/ VALUE(200000)
      INTEGER NODPLC(64)
      COMPLEX CVALUE(32)
      EQUIVALENCE (VALUE(1),NODPLC(1),CVALUE(1))
C
C  CONTROL CARD IDENTIFIERS
C
      DIMENSION AIDE(20),NNODS(20),NTNODS(20),L2NOD(24)
      DIMENSION NUMIC(4)
      DIMENSION AIDM(7),IPOLAR(7),MODID(7),IPAR(5),AMPAR(115)
      DIMENSION TITINP(4)
      DIMENSION AIDC(22)
      DATA TITINP / 8HINPUT LI, 8HSTING   , 8H        , 8H         /
      DATA NAIDC / 22 /
      DATA AIDC / 8HAC      , 8HDC      , 8HDISTORTI, 8HEND     ,
     1            8HENDS    , 8HFOURIER , 8HMODEL   , 8HNOISE   ,
     2            8HOP      , 8HOPTIONS , 8HPLOT    , 8HPRINT   ,
     3            8HSUBCKT  , 8HSENSITIV, 8HTRANSIEN, 8HTF      ,
     4            8HTEMPERAT, 8HWIDTH   , 8HNODESET , 8HIC      ,
     5            8H:DEBUG: , 8HALTER   /
C
C  ELEMENT CARD IDENTIFIERS, KEYWORDS, AND INFORMATION
C
      DATA AIDE / 1HR,1HC,1HL,1HK,1HG,1HE,1HF,1HH,1HV,1HI,1HD,1HQ,1HJ,
     1   1HM,1HS,1HY,1HT,0.0D0,1HX,0.0D0 /
      DATA ALSAC,ALSPU,ALSEX,ALSSI /2HAC,2HPU,2HEX,2HSI/
      DATA ALSOFF,ALSDC,ALSPW / 3HOFF,2HDC,3HPW  /
      DATA ALSZ0,ALSZO,ALSNL,ALSF,ALSTD / 2HZ0,2HZO,2HNL,1HF,2HTD /
      DATA ALSL,ALSW,ALSAS,ALSAD,ALSPD,ALSPS,ALSRDS,ALSRSS,ALSXQC
     1   /1HL,1HW,2HAS,2HAD,2HPD,2HPS,3HNRD,3HNRS,3HXQC/
      DATA ALSZX /2HZX/
      DATA ALSSF / 4HSF   /
      DATA APOLY, AIC, AREA / 4HPOLY, 2HIC, 4HAREA /
      DATA ALSTC / 2HTC /
      DATA NUMIC / 1, 2, 2, 3 /
      DATA ABLNK, APER / 1H , 1H. /
      DATA NNODS / 2,2,2,0,2,2,2,2,2,2,2,3,3,4,4,4,4,0,0,0 /
      DATA NTNODS / 2,2,2,0,2,2,2,2,2,2,3,6,5,6,4,4,4,0,0,0 /
      DATA L2NOD / 8,12,14, 6,13,14,13,14,11, 6,
     1            16,36,25,33, 6, 6,33, 0, 3, 3,
     2             3, 3, 3, 3 /
C
C  MODEL CARD KEYWORDS
C
      DATA AIDM /1HD,3HNPN,3HPNP,3HNJF,3HPJF,4HNMOS,4HPMOS/
      DATA IPOLAR /0,1,-1,1,-1,1,-1/
      DATA MODID /1,2,2,3,3,4,4/
      DATA IPAR / 0, 14, 60, 72, 114/
      DATA AMPAR /
     1   6HIS    ,6HRS    ,6HN     ,6HTT    ,6HCJO   ,6HVJ    ,6HM     ,
     2   6HEG    ,6HXTI   ,6HKF    ,6HAF    ,6HFC    ,6HBV    ,6HIBV   ,
     1   6HIS    ,6HBF    ,6HNF    ,6HVAF   ,6HIKF   ,6HISE   ,6HNE    ,
     2   6HBR    ,6HNR    ,6HVAR   ,6HIKR   ,6HISC   ,6HNC    ,6H0     ,
     3   6H0     ,6HRB    ,6HIRB   ,6HRBM   ,6HRE    ,6HRC    ,6HCJE   ,
     4   6HVJE   ,6HMJE   ,6HTF    ,6HXTF   ,6HVTF   ,6HITF   ,6HPTF   ,
     5   6HCJC   ,6HVJC   ,6HMJC   ,6HXCJC  ,6HTR    ,6H0     ,6H0     ,
     6   6H0     ,6H0     ,6HCJS   ,6HVJS   ,6HMJS   ,6HXTB   ,6HEG    ,
     7   6HXTI   ,6HKF    ,6HAF    ,6HFC    ,
     1   6HVTO   ,6HBETA  ,6HLAMBDA,6HRD    ,6HRS    ,6HCGS   ,6HCGD   ,
     2   6HPB    ,6HIS    ,6HKF    ,6HAF    ,6HFC    ,
     1   6HLEVEL ,6HVTO   ,6HKP    ,6HGAMMA ,6HPHI   ,6HLAMBDA,6HRD    ,
     2   6HRS    ,6HCBD   ,6HCBS   ,6HIS    ,6HPB    ,6HCGSO  ,6HCGDO  ,
     3   6HCGBO  ,6HRSH   ,6HCJ    ,6HMJ    ,6HCJSW  ,6HMJSW  ,6HJS    ,
     4   6HTOX   ,6HNSUB  ,6HNSS   ,6HNFS   ,6HTPG   ,6HXJ    ,6HLD    ,
     5   6HUO    ,6HUCRIT ,6HUEXP  ,6HUTRA  ,6HVMAX  ,6HNEFF  ,6HXQC   ,
     6   6HKF    ,6HAF    ,6HFC    ,6HDELTA ,6HTHETA ,6HETA   ,6HKAPPA ,
     7   0.0D0   /
C
C  INITIALIZE VARIABLES
C
      CALL SECOND(T1)
      CALL ZERO4(IDEBUG,20)
      CALL GETLIN
      IF (KEOF.NE.0) GO TO 6000
      CALL COPY8(AFIELD,ATITLE,10)
      CALL GETM4(IELMNT,0)
      CALL GETM8(ITEMPS,1)
      VALUE(ITEMPS+1)=27.0D0
      ITEMNO=1
      NOPAGE=0
      CALL TITLE(-1,72,1,TITINP)
      IWIDTH=80
      DO 5 I=1,8
      ACHAR=ABLNK
      CALL MOVE(ACHAR,1,ATITLE(10),I,1)
      IF(ACHAR.EQ.ABLNK) GO TO 8
    5 CONTINUE
      WRITE(IOFILE,6)
    6 FORMAT('0WARNING:  INPUT LINE-WIDTH SET TO 72 COLUMNS BECAUSE',/
     11X,'POSSIBLE SEQUENCING APPEARS IN COLS 73-80')
      IWIDTH=72
    8 DO 10 I=1,15
      AFIELD(I)=ABLNK
   10 CONTINUE
      CALL COPY8(AFIELD,OLDLIN,15)
      CALL GETM4(ISBCKT,0)
      NSBCKT=0
      CALL GETM8(IUNSAT,0)
      NUNSAT=0
      NUMALT=0
      NUMCYC=0
      LWIDTH=132
      IPRNTA=0
      IPRNTL=0
      IPRNTM=1
      IPRNTN=0
      IPRNTO=0
      GMIN=1.0D-12
      PIVTOL=1.0D-13
      PIVREL=1.0D-3
      RELTOL=0.001D0
      ABSTOL=1.0D-12
      VNTOL=1.0D-6
      TRTOL=7.0D0
      CHGTOL=1.0D-14
      DEFL=1.0D-4
      DEFW=1.0D-4
      DEFAD=0.0D0
      DEFAS=0.0D0
      NUMDGT=4
      NUMTEM=1
      ITL1=100
      ITL2=50
      ITL3=4
      ITL4=10
      ITL5=5000
      ITL6=0
      LIMTIM=2
      LIMPTS=201
      LVLCOD=1
      LVLTIM=2
      METHOD=1
      XMU=0.5D0
      MAXORD=2
      NOSOLV=0
      ICVFLG=0
      ITCELM(2)=0
      IDIST=0
      IDPRT=0
      INOISE=0
      JACFLG=0
      JTRFLG=0
      CALL GETM4(IFOUR,0)
      NFOUR=0
      CALL GETM4(NSNOD,0)
      CALL GETM8(NSVAL,0)
      CALL GETM4(ICNOD,0)
      CALL GETM8(ICVAL,0)
      KINEL=0
      KOVAR=0
      KSSOP=0
      NOSPRT=0
      NSENS=0
      CALL GETM4(ISENS,0)
      NUMNOD=0
      NCNODS=0
      NUNODS=0
      CALL ZERO4(LOCATE,50)
      CALL ZERO4(JELCNT,50)
      INSIZE=50
      CALL GETM8(IFIELD,INSIZE)
      CALL GETM4(ICODE,INSIZE)
      CALL GETM8(IDELIM,INSIZE)
      CALL GETM4(ICOLUM,INSIZE)
      GO TO 50
C
C  ERROR ENTRY
C
   40 NOGO=1
C
C  READ AND DECODE NEXT CARD IN INPUT DECK
C
   50 IGOOF=0
      CALL CARD
      IF (KEOF.NE.0) GO TO 5000
      IF (IGOOF.NE.0) GO TO 40
      IF (NODPLC(ICODE+1).EQ.0) GO TO 95
      ANAM=VALUE(IFIELD+1)
      CALL MOVE(ANAM,2,ABLNK,1,7)
      IF (ANAM.NE.APER) GO TO 70
      CALL MOVE(ANAM,1,VALUE(IFIELD+1),2,7)
      CALL KEYSRC(AIDC,NAIDC,ANAM,ID)
      IF (ID.LE.0) GO TO 90
      IF (ID.EQ.4) GO TO 5000
      IF (ID.EQ.5) GO TO 800
      IF (ID.EQ.7) GO TO 500
      IF (ID.EQ.13) GO TO 700
      IF (ID.EQ.22) NUMALT=NUMALT+1
      IF (NSBCKT.GE.1) GO TO 85
      IF (ID.NE.22) CALL RUNCON(ID)
      IF (IGOOF.NE.0) GO TO 40
      GO TO 50
   70 ID=0
   80 ID=ID+1
      IF (ID.GT.20) GO TO 90
      IF (ANAM.EQ.AIDE(ID)) GO TO 100
      GO TO 80
   85 WRITE (IOFILE,86)
   86 FORMAT('0WARNING:  ABOVE LINE NOT ALLOWED WITHIN SUBCIRCUIT -- ',
     1   'IGNORED'/)
      GO TO 50
   90 WRITE (IOFILE,91) VALUE(IFIELD+1)
   91 FORMAT('0*ERROR*:  UNKNOWN DATA CARD:  ',A8/)
      GO TO 40
   95 WRITE (IOFILE,96)
   96 FORMAT('0*ERROR*:  UNRECOGNIZABLE DATA CARD'/)
      GO TO 40
C
C  ELEMENT AND DEVICE CARDS
C
  100 CALL FIND(VALUE(IFIELD+1),ID,LOC,1)
      LOCV=NODPLC(LOC+1)
      IF (ID.EQ.4) GO TO 140
      IF (ID.EQ.19) GO TO 900
      ISTOP=NNODS(ID)+1
      IF (NODPLC(LOC+L2NOD(ID)).NE.0) GO TO 113
      DO 110 I=2,ISTOP
      IF (NODPLC(ICODE+I).NE.0) GO TO 410
      IF (VALUE(IFIELD+I).LT.0.0D0) GO TO 400
  110 NODPLC(LOC+I)=VALUE(IFIELD+I)
      GO TO 115
  113 DO 114 I=2,ISTOP
      NODPLC(LOC+I)=0
  114 CONTINUE
  115 GO TO (120,130,130,140,150,150,180,180,200,200,300,300,300,300,
     1   390,390,350,390,390,390), ID
C
C  RESISTOR
C
  120 IF (NODPLC(ICODE+4).NE.0) GO TO 420
      IF (VALUE(IFIELD+4).EQ.0.0D0) GO TO 480
      VALUE(LOCV+2)=VALUE(IFIELD+4)
      IFLD=4
  122 IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 50,122,124
  124 ANAM=VALUE(IFIELD+IFLD)
      IF (ANAM.NE.ALSTC) GO TO 460
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 50,126,124
  126 VALUE(LOCV+3)=VALUE(IFIELD+IFLD)
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 50,128,124
  128 VALUE(LOCV+4)=VALUE(IFIELD+IFLD)
      GO TO 50
C
C  CAPACITOR OR INDUCTOR
C
  130 IKNT=0
      LTAB=7
      IF (ID.EQ.3) LTAB=10
      IF (NODPLC(ICODE+4)) 420,131,132
  131 IF (VALUE(IFIELD+4).LE.0.0D0) GO TO 420
      VALUE(LOCV+1)=VALUE(IFIELD+4)
      NODPLC(LOC+4)=1
      IFLD=5
      IF (NODPLC(ICODE+IFLD)) 50,420,139
  132 CALL GETM8(NODPLC(LOC+LTAB),0)
      ANAM=VALUE(IFIELD+4)
      IF (ANAM.NE.APOLY) GO TO 450
      IFLD=4
  134 IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 50,136,138
  136 CALL EXTMEM(NODPLC(LOC+LTAB),1)
      IKNT=IKNT+1
      ISPOT=NODPLC(LOC+LTAB)+IKNT
      VALUE(ISPOT)=VALUE(IFIELD+IFLD)
      GO TO 134
  138 IF (IKNT.EQ.0) GO TO 420
  139 ANAM=VALUE(IFIELD+IFLD)
      IF (ANAM.NE.AIC) GO TO 460
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.0) GO TO 50
      VALUE(LOCV+2)=VALUE(IFIELD+IFLD)
      GO TO 50
C
C  MUTUAL INDUCTANCE
C
  140 IF (NODPLC(ICODE+2).NE.1) GO TO 430
      ANAM=VALUE(IFIELD+2)
      CALL MOVE(ANAM,2,ABLNK,1,7)
      IF (ANAM.NE.AIDE(3)) GO TO 430
      CALL EXTNAM(VALUE(IFIELD+2),NODPLC(LOC+2))
      IF (NODPLC(ICODE+3).NE.1) GO TO 430
      ANAM=VALUE(IFIELD+3)
      CALL MOVE(ANAM,2,ABLNK,1,7)
      IF (ANAM.NE.AIDE(3)) GO TO 430
      CALL EXTNAM(VALUE(IFIELD+3),NODPLC(LOC+3))
      IF (NODPLC(ICODE+4).NE.0) GO TO 420
      XK=VALUE(IFIELD+4)
      IF (XK.LE.0.0D0) GO TO 420
      IF (XK.LE.1.0D0) GO TO 145
      XK=1.0D0
      WRITE (IOFILE,141)
  141 FORMAT('0WARNING:  COEFFICIENT OF COUPLING RESET TO 1.0D0'/)
  145 VALUE(LOCV+1)=XK
      GO TO 50
C
C  VOLTAGE CONTROLLED (NONLINEAR) SOURCES
C
  150 NDIM=1
      IFLD=3
      IF (NODPLC(ICODE+4)) 410,156,152
  152 ANAM=VALUE(IFIELD+4)
      IF (ANAM.NE.APOLY) GO TO 450
      IF (NODPLC(ICODE+5).NE.0) GO TO 420
      NDIM=VALUE(IFIELD+5)
      IF (NDIM.LE.0) GO TO 420
      IFLD=5
  156 NODPLC(LOC+4)=NDIM
      LTAB=ID+1
      NSSNOD=2*NDIM
      NMAT=4*NDIM
      IF (ID.EQ.6) NMAT=4+2*NDIM
      CALL GETM4(NODPLC(LOC+LTAB),NSSNOD)
      CALL GETM4(NODPLC(LOC+LTAB+1),NMAT)
      CALL GETM8(NODPLC(LOC+LTAB+2),0)
      CALL GETM8(NODPLC(LOC+LTAB+3),NDIM)
      CALL GETM4(NODPLC(LOC+LTAB+4),NDIM)
      CALL GETM8(NODPLC(LOC+LTAB+5),NDIM)
      ISPOT=NODPLC(LOC+LTAB+5)
      CALL ZERO8(VALUE(ISPOT+1),NDIM)
      LNOD=NODPLC(LOC+LTAB)
      DO 158 I=1,NSSNOD
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.0) GO TO 410
      IF (VALUE(IFIELD+IFLD).LT.0.0D0) GO TO 400
      NODPLC(LNOD+I)=VALUE(IFIELD+IFLD)
  158 CONTINUE
  160 IKNT=0
  162 IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.0) GO TO 164
      CALL EXTMEM(NODPLC(LOC+LTAB+2),1)
      IKNT=IKNT+1
      ISPOT=NODPLC(LOC+LTAB+2)+IKNT
      VALUE(ISPOT)=VALUE(IFIELD+IFLD)
      GO TO 162
  164 IF (IKNT.EQ.0) GO TO 420
      IF (NODPLC(ICODE+IFLD).NE.1) GO TO 170
      ANAM=VALUE(IFIELD+IFLD)
      IF (ANAM.NE.AIC) GO TO 460
      DO 168 I=1,NDIM
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 170,166,420
  166 ISPOT=NODPLC(LOC+LTAB+5)+I
      VALUE(ISPOT)=VALUE(IFIELD+IFLD)
  168 CONTINUE
  170 IF (NDIM.NE.1) GO TO 50
      IF (IKNT.NE.1) GO TO 50
      CALL EXTMEM(NODPLC(LOC+LTAB+2),1)
      ISPOT=NODPLC(LOC+LTAB+2)
      VALUE(ISPOT+2)=VALUE(ISPOT+1)
      VALUE(ISPOT+1)=0.0D0
      GO TO 50
C
C  CURRENT CONTROLLED (NONLINEAR) SOURCES
C
  180 NDIM=1
      IFLD=3
      IF (NODPLC(ICODE+4).NE.1) GO TO 470
      ANAM=VALUE(IFIELD+4)
      IF (ANAM.NE.APOLY) GO TO 182
      IFLD=5
      IF (NODPLC(ICODE+5).NE.0) GO TO 420
      NDIM=VALUE(IFIELD+5)
      IF (NDIM.LE.0) GO TO 420
  182 NODPLC(LOC+4)=NDIM
      LTAB=ID-1
      NMAT=2*NDIM
      IF (ID.EQ.8) NMAT=4+NDIM
      CALL GETM4(NODPLC(LOC+LTAB),NDIM)
      CALL GETM4(NODPLC(LOC+LTAB+1),NMAT)
      CALL GETM8(NODPLC(LOC+LTAB+2),0)
      CALL GETM8(NODPLC(LOC+LTAB+3),NDIM)
      CALL GETM4(NODPLC(LOC+LTAB+4),NDIM)
      CALL GETM8(NODPLC(LOC+LTAB+5),NDIM)
      ISPOT=NODPLC(LOC+LTAB+5)
      CALL ZERO8(VALUE(ISPOT+1),NDIM)
      DO 184 I=1,NDIM
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.1) GO TO 470
      ANAM=VALUE(IFIELD+IFLD)
      CALL MOVE(ANAM,2,ABLNK,1,7)
      IF (ANAM.NE.AIDE(9)) GO TO 470
      CALL EXTNAM(VALUE(IFIELD+IFLD),LOCT)
      ISPOT=NODPLC(LOC+LTAB)+I
      NODPLC(ISPOT)=LOCT
  184 CONTINUE
      GO TO 160
C
C  INDEPENDENT SOURCES
C
  200 IFLD=3
      CALL GETM8(NODPLC(LOC+5),0)
  210 IFLD=IFLD+1
  215 IF (NODPLC(ICODE+IFLD)) 50,220,230
  220 IF (IFLD.GT.4) GO TO 210
  225 VALUE(LOCV+1)=VALUE(IFIELD+IFLD)
      GO TO 210
  230 ANAM=VALUE(IFIELD+IFLD)
      IF (ANAM.NE.ALSDC) GO TO 235
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 50,225,230
  235 IF (ANAM.NE.ALSAC) GO TO 260
      VALUE(LOCV+2)=1.0D0
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 50,240,230
  240 VALUE(LOCV+2)=VALUE(IFIELD+IFLD)
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 50,250,230
  250 VALUE(LOCV+3)=VALUE(IFIELD+IFLD)
      GO TO 210
  260 ID=0
      CALL MOVE(ANAM,3,ABLNK,1,6)
      IF (ANAM.EQ.ALSPU) ID=1
      IF (ANAM.EQ.ALSSI) ID=2
      IF (ANAM.EQ.ALSEX) ID=3
      IF (ANAM.EQ.ALSPW) ID=4
      IF (ANAM.EQ.ALSSF) ID=5
      IF (ID.EQ.0) GO TO 450
      NODPLC(LOC+4)=ID
      IKNT=0
  270 IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.0) GO TO 280
      CALL EXTMEM(NODPLC(LOC+5),1)
      IKNT=IKNT+1
      ISPOT=NODPLC(LOC+5)+IKNT
      VALUE(ISPOT)=VALUE(IFIELD+IFLD)
      GO TO 270
  280 AVAL=0.0D0
      IF (ID.NE.4) GO TO 285
C...  FOR PWL SOURCE FUNCTION, FORCE EVEN NUMBER OF INPUT VALUES
      IBIT=0
      IF(IKNT.NE.(IKNT/2)*2) IBIT=1
      AVAL=VALUE(ISPOT)
      IF (IBIT.EQ.0) GO TO 290
      CALL EXTMEM(NODPLC(LOC+5),1)
      AVAL=VALUE(ISPOT-1)
      IKNT=IKNT+1
      ISPOT=NODPLC(LOC+5)+IKNT
      VALUE(ISPOT)=AVAL
      GO TO 290
  285 IF (IKNT.GE.7) GO TO 215
  290 CALL EXTMEM(NODPLC(LOC+5),2)
      ISPOT=NODPLC(LOC+5)+IKNT
      VALUE(ISPOT+1)=0.0D0
      VALUE(ISPOT+2)=AVAL
      IKNT=IKNT+2
      GO TO 285
C
C  DEVICE CARDS
C
  300 VALUE(LOCV+1)=1.0D0
      IF (ID.NE.14) GO TO 305
      VALUE(LOCV+1)=0.0D0
      VALUE(LOCV+11)=0.0D0
      VALUE(LOCV+12)=0.0D0
      VALUE(LOCV+13)=1.0D0
      VALUE(LOCV+14)=1.0D0
      VALUE(LOCV+15)=0.0D0
  305 LOCM=LOC+NTNODS(ID)+2
      IFLD=NNODS(ID)+2
C
C  TEMPORARILY (UNTIL MODCHK) PUT BJT'S SUBSTRATE NODE INTO NODPLC(LOC+5)
C
      IF(ID.NE.12) GO TO 308
      IF(NODPLC(ICODE+5).NE.0) GO TO 308
      IFLD=6
      IF (NODPLC(LOC+L2NOD(ID)).NE.0) GO TO 306
      NODPLC(LOC+5)=VALUE(IFIELD+5)
      GO TO 308
  306 NODPLC(LOC+5)=0
  308 CONTINUE
C
C    RESERVE DEVICE INTERNAL NODES,READ DEVICE GEOMETRY PARAMETERS
C    AND INITIAL CONDITIONS
C
      IF (NODPLC(ICODE+IFLD).NE.1) GO TO 440
      CALL EXTNAM(VALUE(IFIELD+IFLD),NODPLC(LOCM))
  310 IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 50,325,315
  315 ANAM=VALUE(IFIELD+IFLD)
      IF (ANAM.NE.ALSOFF) GO TO 320
      NODPLC(LOCM+1)=1
      GO TO 310
  320 IF (ANAM.NE.AREA) GO TO 330
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 50,325,315
  325 IF (VALUE(IFIELD+IFLD).LE.0.0D0) GO TO 420
      IF (ID.EQ.14) GO TO 343
      VALUE(LOCV+1)=VALUE(IFIELD+IFLD)
      GO TO 310
  330 IF (ANAM.NE.AIC) GO TO 341
      IKNT=0
      ICLOC=0
      IF (ID.EQ.14) ICLOC=3
      MAXKNT=NUMIC(ID-10)
  335 IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 50,340,315
  340 IKNT=IKNT+1
      IF (IKNT.GT.MAXKNT) GO TO 335
      VALUE(LOCV+ICLOC+IKNT+1)=VALUE(IFIELD+IFLD)
      GO TO 335
  341 IF (ID.NE.14) GO TO 460
      ISPOT=0
      IF (ANAM.EQ.ALSL) ISPOT=1
      IF (ANAM.EQ.ALSW) ISPOT=2
      IF (ANAM.EQ.ALSAD) ISPOT=3
      IF (ANAM.EQ.ALSZX) ISPOT=3
      IF (ANAM.EQ.ALSAS) ISPOT=4
      IF (ANAM.EQ.ALSPD) ISPOT=11
      IF (ANAM.EQ.ALSPS) ISPOT=12
      IF (ANAM.EQ.ALSRDS) ISPOT=13
      IF (ANAM.EQ.ALSRSS) ISPOT=14
      IF (ANAM.EQ.ALSXQC) ISPOT=15
      IF (ISPOT.EQ.0) GO TO 460
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 50,342,315
  342 IF (VALUE(IFIELD+IFLD).LE.0.0D0) GO TO 420
      VALUE(LOCV+ISPOT)=VALUE(IFIELD+IFLD)
      GO TO 310
  343 IKNT=0
  344 IKNT=IKNT+1
      IF(VALUE(IFIELD+IFLD).LE.0.0D0) GO TO 420
      IF(IKNT.GT.15) GO TO 490
      IF(IKNT.EQ.5) IKNT=11
      VALUE(LOCV+IKNT)=VALUE(IFIELD+IFLD)
      IFLD=IFLD+1
      IF(NODPLC(ICODE+IFLD)) 345,344,345
  345 IF(NODPLC(ICODE+IFLD)) 50,50,315
C
C  TRANSMISSION LINES
C
  350 IFLD=5
      XNL=0.25D0
      TFREQ=0.0D0
  355 IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 378,355,360
  360 ANAM=VALUE(IFIELD+IFLD)
      IF (ANAM.EQ.AIC) GO TO 364
      IF (ANAM.EQ.ALSNL) GO TO 370
      IF (ANAM.EQ.ALSF) GO TO 374
      ID=0
      IF (ANAM.EQ.ALSZ0) ID=1
      IF (ANAM.EQ.ALSZO) ID=1
      IF (ANAM.EQ.ALSTD) ID=2
      IF (ID.EQ.0) GO TO 460
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 378,362,360
  362 IF (VALUE(IFIELD+IFLD).LE.0.0D0) GO TO 420
      VALUE(LOCV+ID)=VALUE(IFIELD+IFLD)
      GO TO 355
  364 IKNT=0
  366 IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 378,368,360
  368 IKNT=IKNT+1
      IF (IKNT.GT.4) GO TO 366
      VALUE(LOCV+IKNT+4)=VALUE(IFIELD+IFLD)
      GO TO 366
  370 IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 378,372,360
  372 IF (VALUE(IFIELD+IFLD).LE.0.0D0) GO TO 420
      XNL=VALUE(IFIELD+IFLD)
      GO TO 355
  374 IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 378,376,360
  376 IF (VALUE(IFIELD+IFLD).LE.0.0D0) GO TO 420
      TFREQ=VALUE(IFIELD+IFLD)
      GO TO 355
  378 IF (VALUE(LOCV+1).NE.0.0D0) GO TO 380
      WRITE (IOFILE,379)
  379 FORMAT('0*ERROR*:  Z0 MUST BE SPECIFIED'/)
      GO TO 40
  380 IF (VALUE(LOCV+2).NE.0.0D0) GO TO 50
      IF (TFREQ.NE.0.0D0) GO TO 382
      WRITE (IOFILE,381)
  381 FORMAT('0*ERROR*:  EITHER TD OR F MUST BE SPECIFIED'/)
      GO TO 40
  382 VALUE(LOCV+2)=XNL/TFREQ
      GO TO 50
C
C  ELEMENTS NOT YET IMPLEMENTED
C
  390 WRITE (IOFILE,391)
  391 FORMAT('0*ERROR*:  ELEMENT TYPE NOT YET IMPLEMENTED'/)
      GO TO 40
C
C  ELEMENT CARD ERRORS
C
  400 WRITE (IOFILE,401)
  401 FORMAT('0*ERROR*:  NEGATIVE NODE NUMBER FOUND'/)
      GO TO 40
  410 WRITE (IOFILE,411)
  411 FORMAT('0*ERROR*:  NODE NUMBERS ARE MISSING'/)
      GO TO 40
  420 WRITE (IOFILE,421)
  421 FORMAT('0*ERROR*:  VALUE IS MISSING OR IS NONPOSITIVE'/)
      GO TO 40
  430 WRITE (IOFILE,431)
  431 FORMAT('0*ERROR*:  MUTUAL INDUCTANCE REFERENCES ARE MISSING'/)
      GO TO 40
  440 WRITE (IOFILE,441)
  441 FORMAT('0*ERROR*:  MODEL NAME IS MISSING'/)
      GO TO 40
  450 WRITE (IOFILE,451) ANAM
  451 FORMAT('0*ERROR*:  UNKNOWN SOURCE FUNCTION:  ',A8)
      GO TO 40
  460 WRITE (IOFILE,461) ANAM
  461 FORMAT('0*ERROR*:  UNKNOWN PARAMETER:  ',A8/)
      GO TO 40
  470 WRITE (IOFILE,471)
  471 FORMAT('0*ERROR*:  VOLTAGE SOURCE NOT FOUND ON ABOVE LINE'/)
      GO TO 40
  480 WRITE (IOFILE,481)
  481 FORMAT('0*ERROR*:  VALUE IS ZERO'/)
      GO TO 40
  490 WRITE(IOFILE,491)
  491 FORMAT('0*ERROR*:  EXTRA NUMERICAL DATA ON MOSFET CARD'/)
      GO TO 40
C
C  MODEL CARD
C
  500 IF (NODPLC(ICODE+2).NE.1) GO TO 650
      IF (NODPLC(ICODE+3).NE.1) GO TO 650
      ID=0
  510 ID=ID+1
      IF (ID.GT.7) GO TO 660
      IF (VALUE(IFIELD+3).NE.AIDM(ID)) GO TO 510
      IPOL=IPOLAR(ID)
      JTYPE=MODID(ID)
      ID=JTYPE+20
      CALL FIND(VALUE(IFIELD+2),ID,LOC,1)
      NODPLC(LOC+2)=IPOL
      LOCV=NODPLC(LOC+1)
  520 LOCM=IPAR(JTYPE)
      NOPAR=IPAR(JTYPE+1)-LOCM
      IFLD=3
  530 IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 50,530,560
  560 ANAM=VALUE(IFIELD+IFLD)
      IF(JTYPE.EQ.2) ANAM=ALIAS(ANAM)
      IKNT=0
  570 IKNT=IKNT+1
      IF (IKNT.GT.NOPAR) GO TO 670
      IF (ANAM.NE.AMPAR(LOCM+IKNT)) GO TO 570
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 50,580,560
  580 VALUE(LOCV+IKNT)=VALUE(IFIELD+IFLD)
      IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 50,590,560
  590 IKNT=IKNT+1
      IF (IKNT.GT.NOPAR) GO TO 530
      IF (ABLNK.NE.AMPAR(LOCM+IKNT)) GO TO 530
      GO TO 580
C
C  MODEL CARD ERRORS
C
  650 WRITE (IOFILE,651)
  651 FORMAT('0*ERROR*:  MODEL TYPE IS MISSING'/)
      GO TO 40
  660 WRITE (IOFILE,661) VALUE(IFIELD+3)
  661 FORMAT('0*ERROR*:  UNKNOWN MODEL TYPE:  ',A8/)
      GO TO 40
  670 WRITE (IOFILE,671) ANAM
  671 FORMAT('0*ERROR*:  UNKNOWN MODEL PARAMETER:  ',A8,/)
      NOGO=1
      GO TO 530
C
C  SUBCIRCUIT DEFINITION
C
  700 IF (NODPLC(ICODE+2).NE.1) GO TO 780
      CALL FIND(VALUE(IFIELD+2),20,LOC,1)
      CALL EXTMEM(ISBCKT,1)
      NSBCKT=NSBCKT+1
      NODPLC(ISBCKT+NSBCKT)=LOC
      IFLD=2
      IF (NODPLC(ICODE+3).NE.0) GO TO 790
      CALL GETM4(NODPLC(LOC+2),0)
      IKNT=0
  710 IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD)) 50,720,710
  720 CALL EXTMEM(NODPLC(LOC+2),1)
      IKNT=IKNT+1
      ISPOT=NODPLC(LOC+2)+IKNT
      IF (VALUE(IFIELD+IFLD).LE.0.0D0) GO TO 770
      NODPLC(ISPOT)=VALUE(IFIELD+IFLD)
      NODE=NODPLC(ISPOT)
      I=IKNT-1
  730 IF (I.EQ.0) GO TO 710
      ISPOT=ISPOT-1
      IF (NODPLC(ISPOT).EQ.NODE) GO TO 760
      I=I-1
      GO TO 730
  760 WRITE (IOFILE,761) NODE
  761 FORMAT('0*ERROR*:  SUBCIRCUIT DEFINITION DUPLICATES NODE ',I5,/)
      GO TO 40
  770 WRITE (IOFILE,771)
  771 FORMAT('0*ERROR*:  NONPOSITIVE NODE NUMBER FOUND IN SUBCIRCUIT ',
     1   'DEFINITION'/)
      GO TO 40
  780 WRITE (IOFILE,781)
  781 FORMAT('0*ERROR*:  SUBCIRCUIT NAME MISSING'/)
      GO TO 40
  790 WRITE (IOFILE,791)
  791 FORMAT('0*ERROR*:  SUBCIRCUIT NODES MISSING'/)
      GO TO 40
C
C  .ENDS PROCESSING
C
  800 IF (NSBCKT.EQ.0) GO TO 890
      IKNT=1
      IF (NODPLC(ICODE+2).LE.0) GO TO 820
      ANAM=VALUE(IFIELD+2)
      IKNT=NSBCKT
  810 LOC=NODPLC(ISBCKT+IKNT)
      LOCV=NODPLC(LOC+1)
      ANAMS=VALUE(LOCV)
      IF (ANAM.EQ.ANAMS) GO TO 820
      IKNT=IKNT-1
      IF (IKNT.NE.0) GO TO 810
      GO TO 880
  820 IREL=NSBCKT-IKNT+1
      CALL RELMEM(ISBCKT,IREL)
      NSBCKT=NSBCKT-IREL
      GO TO 50
  880 WRITE (IOFILE,881) ANAM
  881 FORMAT('0*ERROR*:  UNKNOWN SUBCIRCUIT NAME:  ',A8/)
      GO TO 40
  890 WRITE (IOFILE,891)
  891 FORMAT('0WARNING:  NO SUBCIRCUIT DEFINITION KNOWN -- LINE IGNORED'
     1/)
      GO TO 50
C
C  SUBCIRCUIT CALL
C
  900 CALL GETM4(NODPLC(LOC+2),0)
      IFLD=1
      IKNT=0
  910 IFLD=IFLD+1
      IF (NODPLC(ICODE+IFLD).NE.0) GO TO 920
      CALL EXTMEM(NODPLC(LOC+2),1)
      IKNT=IKNT+1
      ISPOT=NODPLC(LOC+2)+IKNT
      IF (VALUE(IFIELD+IFLD).LT.0.0D0) GO TO 400
      NODPLC(ISPOT)=VALUE(IFIELD+IFLD)
      GO TO 910
  920 IF (IKNT.EQ.0) GO TO 410
      IF (NODPLC(ICODE+IFLD).NE.1) GO TO 990
      CALL EXTNAM(VALUE(IFIELD+IFLD),NODPLC(LOC+3))
      GO TO 50
  990 WRITE (IOFILE,991)
  991 FORMAT('0*ERROR*:  SUBCIRCUIT NAME MISSING'/)
      GO TO 40
C
C  END
C
 5000 IF (NSBCKT.EQ.0) GO TO 5010
      NSBCKT=0
      WRITE (IOFILE,5001)
 5001 FORMAT('0*ERROR*:  .ENDS  CARD MISSING'/)
      NOGO=1
 5010 CALL CLRMEM(IFIELD)
      CALL CLRMEM(ICODE)
      CALL CLRMEM(IDELIM)
      CALL CLRMEM(ICOLUM)
      CALL CLRMEM(ISBCKT)
      IF (NFOUR.EQ.0) CALL CLRMEM(IFOUR)
      IF (NSENS.EQ.0) CALL CLRMEM(ISENS)
 6000 CALL SECOND(T2)
      RSTATS(1)=T2-T1
      RETURN
      END
